/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompileResultsListener;
import ghidra.app.decompiler.component.DecompilerCallbackHandler;
import ghidra.app.decompiler.component.DecompilerCallbackHandlerAdapter;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerProgramListener;
import ghidra.app.decompiler.component.EmptyDecompileData;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonOptions;
import ghidra.features.codecompare.decompile.DiffClangHighlightController;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;
import java.util.function.Consumer;

public class CDisplay {
    private static final String OPTIONS_TITLE = "Decompiler";
    private DecompilerController controller;
    private DecompileOptions decompileOptions;
    private FieldLocation lastCursorPosition;
    private DiffClangHighlightController highlightController;
    private Program program;
    private DecompilerProgramListener programListener;

    public CDisplay(ServiceProvider serviceProvider, DecompilerCodeComparisonOptions comparisonOptions, final DecompileResultsListener decompileListener, final Consumer<ProgramLocation> locationConsumer) {
        this.highlightController = new DiffClangHighlightController(comparisonOptions);
        this.decompileOptions = new DecompileOptions();
        DecompilerCallbackHandlerAdapter handler = new DecompilerCallbackHandlerAdapter(this){

            public void locationChanged(ProgramLocation programLocation) {
                locationConsumer.accept(programLocation);
            }
        };
        this.controller = new DecompilerController(serviceProvider, (DecompilerCallbackHandler)handler, this.decompileOptions, null){

            public void setDecompileData(DecompileData decompileData) {
                super.setDecompileData(decompileData);
                decompileListener.setDecompileData(decompileData);
                CDisplay.this.controller.getDecompilerPanel().validate();
            }
        };
        this.controller.getDecompilerPanel().setHighlightController((ClangHighlightController)this.highlightController);
        this.programListener = new DecompilerProgramListener(this.controller, () -> this.refresh());
    }

    public DecompilerPanel getDecompilerPanel() {
        return this.controller.getDecompilerPanel();
    }

    private void updateProgram(PluginTool tool, Function function) {
        Program newProgram;
        Program program = newProgram = function == null ? null : function.getProgram();
        if (this.program == newProgram) {
            return;
        }
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this.programListener);
        }
        this.program = newProgram;
        if (this.program != null) {
            this.program.addListener((DomainObjectListener)this.programListener);
            this.initializeOptions(tool, function);
        }
    }

    public void showFunction(PluginTool tool, Function function) {
        this.updateProgram(tool, function);
        this.lastCursorPosition = null;
        if (function == null) {
            this.clearAndShowMessage("No Function");
            return;
        }
        if (function.isExternal()) {
            this.clearAndShowMessage("\"" + function.getName(true) + "\" is an external function.");
            return;
        }
        Address entry = function.getEntryPoint();
        ProgramLocation location = new ProgramLocation(this.program, entry);
        this.controller.display(this.program, location, new ViewerPosition(0, 0, 0));
    }

    public void clearAndShowMessage(String message) {
        this.controller.setDecompileData((DecompileData)new EmptyDecompileData(message));
        DecompilerPanel decompilerPanel = this.getDecompilerPanel();
        decompilerPanel.paintImmediately(decompilerPanel.getBounds());
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        this.controller.setMouseNavigationEnabled(enabled);
    }

    public void dispose() {
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this.programListener);
            this.program = null;
        }
        this.programListener.dispose();
        this.controller.dispose();
    }

    public void refresh() {
        this.saveCursorPosition();
        DecompileData data = this.getDecompileData();
        if (data != null) {
            this.controller.refreshDisplay(data.getProgram(), data.getLocation(), null);
        }
    }

    public void programClosed(Program closedProgram) {
        if (closedProgram == this.program) {
            this.controller.clear();
            this.controller.programClosed(closedProgram);
            this.updateProgram(null, null);
        }
    }

    public boolean isBusy() {
        return this.controller.isDecompiling();
    }

    public DecompileData getDecompileData() {
        DecompileData decompileData = this.controller.getDecompileData();
        if (decompileData instanceof EmptyDecompileData) {
            return null;
        }
        return decompileData;
    }

    public void initializeOptions(PluginTool tool, Function function) {
        if (tool == null) {
            return;
        }
        ToolOptions fieldOptions = tool.getOptions("Listing Fields");
        ToolOptions options = tool.getOptions(OPTIONS_TITLE);
        Program p = function == null ? null : function.getProgram();
        this.decompileOptions.grabFromToolAndProgram(fieldOptions, options, p);
    }

    DiffClangHighlightController getHighlightController() {
        return this.highlightController;
    }

    private void saveCursorPosition() {
        this.lastCursorPosition = this.getDecompilerPanel().getFieldPanel().getCursorLocation();
    }

    void restoreCursorPosition() {
        if (this.lastCursorPosition != null) {
            BigInteger index = this.lastCursorPosition.getIndex();
            int fieldNum = this.lastCursorPosition.getFieldNum();
            int row = this.lastCursorPosition.getRow();
            int col = this.lastCursorPosition.getCol();
            FieldPanel fieldPanel = this.getDecompilerPanel().getFieldPanel();
            fieldPanel.setCursorPosition(index, fieldNum, row, col);
        }
    }
}

