/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.plugin.core.debug.service.breakpoint.TraceBreakpointSet;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.target.Target;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class LoneLogicalBreakpoint
implements LogicalBreakpointInternal {
    private final Set<Trace> justThisTrace;
    private final TraceBreakpointSet breaks;
    private final long length;
    private final Set<TraceBreakpointKind> kinds;

    public LoneLogicalBreakpoint(PluginTool tool, Trace trace, Address address, long length, Collection<TraceBreakpointKind> kinds) {
        this.breaks = new TraceBreakpointSet(tool, trace, address);
        this.length = length;
        this.kinds = Set.copyOf(kinds);
        this.justThisTrace = Set.of(trace);
    }

    public String toString() {
        return String.format("<%s trace=%s>", this.getClass().getSimpleName(), this.breaks);
    }

    public boolean isEmpty() {
        return this.breaks.isEmpty();
    }

    public long getLength() {
        return this.length;
    }

    public Set<TraceBreakpointKind> getKinds() {
        return this.kinds;
    }

    public ProgramLocation getProgramLocation() {
        return null;
    }

    public Bookmark getProgramBookmark() {
        return null;
    }

    public String getName() {
        return "";
    }

    public void setName(String name) {
        throw new IllegalStateException("Breakpoint must be saved to a program before naming");
    }

    public String getEmuSleigh() {
        return this.breaks.computeSleigh();
    }

    public void setEmuSleigh(String sleigh) {
        this.breaks.setEmuSleigh(sleigh);
    }

    @Override
    public void setTraceAddress(Trace trace, Address address) {
        throw new AssertionError();
    }

    @Override
    public void setTarget(Trace trace, Target target) {
        this.breaks.setTarget(target);
    }

    @Override
    public void removeTrace(Trace trace) {
        throw new AssertionError();
    }

    public Set<TraceBreakpointLocation> getTraceBreakpoints() {
        return this.breaks.getBreakpoints();
    }

    public Set<TraceBreakpointLocation> getTraceBreakpoints(Trace trace) {
        return this.breaks.getTrace() != trace ? Set.of() : this.getTraceBreakpoints();
    }

    public Set<Trace> getMappedTraces() {
        return this.justThisTrace;
    }

    public Set<Trace> getParticipatingTraces() {
        if (this.breaks.isEmpty()) {
            return Set.of();
        }
        return this.justThisTrace;
    }

    public Address getTraceAddress(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return null;
        }
        return this.breaks.getAddress();
    }

    public DomainObject getDomainObject() {
        return this.breaks.getTrace();
    }

    public Address getAddress() {
        return this.breaks.getAddress();
    }

    public LogicalBreakpoint.State computeStateForProgram(Program program) {
        return LogicalBreakpoint.State.NONE;
    }

    public LogicalBreakpoint.State computeStateForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return LogicalBreakpoint.State.NONE;
        }
        return LogicalBreakpoint.ProgramMode.NONE.combineTrace(this.breaks.computeMode(), LogicalBreakpoint.Perspective.TRACE);
    }

    public LogicalBreakpoint.State computeStateForLocation(TraceBreakpointLocation loc) {
        if (!this.breaks.getBreakpoints().contains(loc)) {
            return LogicalBreakpoint.State.NONE;
        }
        return LogicalBreakpoint.ProgramMode.NONE.combineTrace(this.breaks.computeMode(loc), LogicalBreakpoint.Perspective.TRACE);
    }

    public LogicalBreakpoint.State computeState() {
        return LogicalBreakpoint.ProgramMode.NONE.combineTrace(this.breaks.computeMode(), LogicalBreakpoint.Perspective.LOGICAL);
    }

    public void enableForProgram() {
    }

    public void disableForProgram() {
    }

    public void deleteForProgram() {
    }

    public CompletableFuture<Void> enableForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return AsyncUtils.nil();
        }
        return this.enable();
    }

    public CompletableFuture<Void> disableForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return AsyncUtils.nil();
        }
        return this.disable();
    }

    public CompletableFuture<Void> deleteForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return AsyncUtils.nil();
        }
        return this.delete();
    }

    @Override
    public void planEnable(BreakpointActionSet actions, Trace trace) {
        if (trace != null && trace != this.breaks.getTrace()) {
            return;
        }
        this.breaks.planEnable(actions, this.length, this.kinds);
    }

    public String generateStatusEnable(Trace trace) {
        if (trace == null || trace == this.breaks.getTrace()) {
            return null;
        }
        return "A breakpoint is not in this trace. Is there a target? Check your module map.";
    }

    public CompletableFuture<Void> enable() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planEnable(actions, null);
        return actions.execute();
    }

    @Override
    public void planDisable(BreakpointActionSet actions, Trace trace) {
        if (trace != null && trace != this.breaks.getTrace()) {
            return;
        }
        this.breaks.planDisable(actions, this.length, this.kinds);
    }

    public CompletableFuture<Void> disable() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDisable(actions, null);
        return actions.execute();
    }

    @Override
    public void planDelete(BreakpointActionSet actions, Trace trace) {
        if (trace != null && trace != this.breaks.getTrace()) {
            return;
        }
        this.breaks.planDelete(actions, this.length, this.kinds);
    }

    public CompletableFuture<Void> delete() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDelete(actions, null);
        return actions.execute();
    }

    @Override
    public boolean canMerge(Program program, Bookmark bookmark) {
        return false;
    }

    @Override
    public boolean canMerge(TraceBreakpointLocation breakpoint, long snap) {
        if (!Objects.equals(this.kinds, breakpoint.getKinds(snap))) {
            return false;
        }
        return this.breaks.canMerge(breakpoint);
    }

    @Override
    public boolean trackBreakpoint(Bookmark bookmark) {
        throw new AssertionError();
    }

    @Override
    public boolean trackBreakpoint(TraceBreakpointLocation breakpoint) {
        return this.breaks.add(breakpoint);
    }

    @Override
    public boolean untrackBreakpoint(Program program, Bookmark bookmark) {
        return false;
    }

    @Override
    public boolean untrackBreakpoint(TraceBreakpointLocation breakpoint) {
        return this.breaks.remove(breakpoint);
    }
}

