/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.Histogram;
import com.tdunning.math.stats.TDigest;
import java.util.Iterator;

public class Comparison {
    public static double compareChi2(TDigest dist1, TDigest dist2, double[] qCuts) {
        double[][] count = new double[][]{new double[qCuts.length + 1], new double[qCuts.length + 1]};
        double oldQ = 0.0;
        double oldQ2 = 0.0;
        for (int i = 0; i <= qCuts.length; ++i) {
            double x;
            double newQ;
            if (i == qCuts.length) {
                newQ = 1.0;
                x = Math.max(dist1.getMax(), dist2.getMax()) + 1.0;
            } else {
                newQ = qCuts[i];
                x = dist1.quantile(newQ);
            }
            count[0][i] = (double)dist1.size() * (newQ - oldQ);
            double q2 = dist2.cdf(x);
            count[1][i] = (double)dist2.size() * (q2 - oldQ2);
            oldQ = newQ;
            oldQ2 = q2;
        }
        return Comparison.llr(count);
    }

    public static double compareChi2(Histogram dist1, Histogram dist2) {
        long[] k2;
        if (!dist1.getClass().equals(dist2.getClass())) {
            throw new IllegalArgumentException(String.format("Must have same class arguments, got %s and %s", dist1.getClass(), dist2.getClass()));
        }
        long[] k1 = dist1.getCounts();
        int n1 = k1.length;
        if (n1 != (k2 = dist2.getCounts()).length || dist1.lowerBound(0) != dist2.lowerBound(0) || dist1.lowerBound(n1 - 1) != dist2.lowerBound(n1 - 1)) {
            throw new IllegalArgumentException("Incompatible histograms in terms of size or bounds");
        }
        double[][] count = new double[2][n1];
        for (int i = 0; i < n1; ++i) {
            count[0][i] = k1[i];
            count[1][i] = k2[i];
        }
        return Comparison.llr(count);
    }

    public static double llr(double[][] count) {
        if (count.length == 0) {
            throw new IllegalArgumentException("Must have some data in llr");
        }
        int columns = count[0].length;
        int rows = count.length;
        double[] rowSums = new double[rows];
        double[] colSums = new double[columns];
        double totalCount = 0.0;
        double h = 0.0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                double k = count[i][j];
                int n = i;
                rowSums[n] = rowSums[n] + k;
                int n2 = j;
                colSums[n2] = colSums[n2] + k;
                if (k < 0.0) {
                    throw new IllegalArgumentException(String.format("Illegal negative count (%.5f) at %d,%d", k, i, j));
                }
                if (!(k > 0.0)) continue;
                h += k * Math.log(k);
                totalCount += k;
            }
        }
        double normalizer = totalCount * Math.log(totalCount);
        h -= normalizer;
        double hr = 0.0;
        for (int i = 0; i < rows; ++i) {
            if (!(rowSums[i] > 0.0)) continue;
            hr += rowSums[i] * Math.log(rowSums[i]);
        }
        hr -= normalizer;
        double hc = 0.0;
        for (int j = 0; j < columns; ++j) {
            if (!(colSums[j] > 0.0)) continue;
            hc += colSums[j] * Math.log(colSums[j]);
        }
        return 2.0 * (h - hr - (hc -= normalizer));
    }

    public static double ks(TDigest d1, TDigest d2) {
        Iterator<Centroid> ix1 = d1.centroids().iterator();
        Iterator<Centroid> ix2 = d2.centroids().iterator();
        double diff = 0.0;
        double x1 = d1.getMin();
        double x2 = d2.getMin();
        while (x1 <= d1.getMax() && x2 <= d2.getMax()) {
            double q2;
            if (x1 < x2) {
                diff = Comparison.maxDiff(d1, d2, diff, x1);
                x1 = Comparison.nextValue(d1, ix1, x1);
                continue;
            }
            if (x1 > x2) {
                diff = Comparison.maxDiff(d1, d2, diff, x2);
                x2 = Comparison.nextValue(d2, ix2, x2);
                continue;
            }
            if (x1 != x2) continue;
            diff = Comparison.maxDiff(d1, d2, diff, x1);
            double q1 = d1.cdf(x1);
            if (q1 < (q2 = d2.cdf(x2))) {
                x1 = Comparison.nextValue(d1, ix1, x1);
                continue;
            }
            if (q1 > q2) {
                x2 = Comparison.nextValue(d2, ix2, x2);
                continue;
            }
            x1 = Comparison.nextValue(d1, ix1, x1);
            x2 = Comparison.nextValue(d2, ix2, x2);
        }
        while (x1 <= d1.getMax()) {
            diff = Comparison.maxDiff(d1, d2, diff, x1);
            x1 = Comparison.nextValue(d1, ix1, x1);
        }
        while (x2 <= d2.getMax()) {
            diff = Comparison.maxDiff(d2, d2, diff, x2);
            x2 = Comparison.nextValue(d2, ix2, x2);
        }
        long n1 = d1.size();
        long n2 = d2.size();
        return diff * Math.sqrt((double)n1 * (double)n2 / (double)(n1 + n2));
    }

    private static double maxDiff(TDigest d1, TDigest d2, double diff, double x1) {
        diff = Math.max(diff, Math.abs(d1.cdf(x1) - d2.cdf(x1)));
        return diff;
    }

    private static double nextValue(TDigest d, Iterator<Centroid> ix, double x) {
        if (ix.hasNext()) {
            return ix.next().mean();
        }
        if (x < d.getMax()) {
            return d.getMax();
        }
        return d.getMax() + 1.0;
    }
}

