/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.protobufs;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.opensearch.protobufs.CommonProto;
import org.opensearch.protobufs.Fuzziness;
import org.opensearch.protobufs.FuzzinessOrBuilder;
import org.opensearch.protobufs.FuzzyQueryOrBuilder;
import org.opensearch.protobufs.GeneralNumber;
import org.opensearch.protobufs.GeneralNumberOrBuilder;

public final class FuzzyQuery
extends GeneratedMessageV3
implements FuzzyQueryOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int FIELD_FIELD_NUMBER = 1;
    private volatile Object field_ = "";
    public static final int BOOST_FIELD_NUMBER = 2;
    private float boost_ = 0.0f;
    public static final int UNDERSCORE_NAME_FIELD_NUMBER = 3;
    private volatile Object underscoreName_ = "";
    public static final int MAX_EXPANSIONS_FIELD_NUMBER = 4;
    private int maxExpansions_ = 0;
    public static final int PREFIX_LENGTH_FIELD_NUMBER = 5;
    private int prefixLength_ = 0;
    public static final int REWRITE_FIELD_NUMBER = 6;
    private int rewrite_ = 0;
    public static final int TRANSPOSITIONS_FIELD_NUMBER = 7;
    private boolean transpositions_ = false;
    public static final int FUZZINESS_FIELD_NUMBER = 8;
    private Fuzziness fuzziness_;
    public static final int VALUE_FIELD_NUMBER = 9;
    private Value value_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final FuzzyQuery DEFAULT_INSTANCE = new FuzzyQuery();
    private static final Parser<FuzzyQuery> PARSER = new AbstractParser<FuzzyQuery>(){

        public FuzzyQuery parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            Builder builder = FuzzyQuery.newBuilder();
            try {
                builder.mergeFrom(codedInputStream, extensionRegistryLite);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException uninitializedMessageException) {
                throw uninitializedMessageException.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException iOException) {
                throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private FuzzyQuery(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private FuzzyQuery() {
        this.field_ = "";
        this.underscoreName_ = "";
        this.rewrite_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unusedPrivateParameter) {
        return new FuzzyQuery();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_FuzzyQuery_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_FuzzyQuery_fieldAccessorTable.ensureFieldAccessorsInitialized(FuzzyQuery.class, Builder.class);
    }

    @Override
    public String getField() {
        Object object = this.field_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.field_ = string;
        return string;
    }

    @Override
    public ByteString getFieldBytes() {
        Object object = this.field_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.field_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasBoost() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public float getBoost() {
        return this.boost_;
    }

    @Override
    public boolean hasUnderscoreName() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getUnderscoreName() {
        Object object = this.underscoreName_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.underscoreName_ = string;
        return string;
    }

    @Override
    public ByteString getUnderscoreNameBytes() {
        Object object = this.underscoreName_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.underscoreName_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public int getMaxExpansions() {
        return this.maxExpansions_;
    }

    @Override
    public int getPrefixLength() {
        return this.prefixLength_;
    }

    @Override
    public int getRewriteValue() {
        return this.rewrite_;
    }

    @Override
    public MultiTermQueryRewrite getRewrite() {
        MultiTermQueryRewrite multiTermQueryRewrite = MultiTermQueryRewrite.forNumber(this.rewrite_);
        return multiTermQueryRewrite == null ? MultiTermQueryRewrite.UNRECOGNIZED : multiTermQueryRewrite;
    }

    @Override
    public boolean getTranspositions() {
        return this.transpositions_;
    }

    @Override
    public boolean hasFuzziness() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Fuzziness getFuzziness() {
        return this.fuzziness_ == null ? Fuzziness.getDefaultInstance() : this.fuzziness_;
    }

    @Override
    public FuzzinessOrBuilder getFuzzinessOrBuilder() {
        return this.fuzziness_ == null ? Fuzziness.getDefaultInstance() : this.fuzziness_;
    }

    @Override
    public boolean hasValue() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Value getValue() {
        return this.value_ == null ? Value.getDefaultInstance() : this.value_;
    }

    @Override
    public ValueOrBuilder getValueOrBuilder() {
        return this.value_ == null ? Value.getDefaultInstance() : this.value_;
    }

    public final boolean isInitialized() {
        byte by = this.memoizedIsInitialized;
        if (by == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.field_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)1, (Object)this.field_);
        }
        if ((this.bitField0_ & 1) != 0) {
            codedOutputStream.writeFloat(2, this.boost_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)3, (Object)this.underscoreName_);
        }
        if (this.maxExpansions_ != 0) {
            codedOutputStream.writeInt32(4, this.maxExpansions_);
        }
        if (this.prefixLength_ != 0) {
            codedOutputStream.writeInt32(5, this.prefixLength_);
        }
        if (this.rewrite_ != MultiTermQueryRewrite.MULTI_TERM_QUERY_REWRITE_UNSPECIFIED.getNumber()) {
            codedOutputStream.writeEnum(6, this.rewrite_);
        }
        if (this.transpositions_) {
            codedOutputStream.writeBool(7, this.transpositions_);
        }
        if ((this.bitField0_ & 4) != 0) {
            codedOutputStream.writeMessage(8, (MessageLite)this.getFuzziness());
        }
        if ((this.bitField0_ & 8) != 0) {
            codedOutputStream.writeMessage(9, (MessageLite)this.getValue());
        }
        this.getUnknownFields().writeTo(codedOutputStream);
    }

    public int getSerializedSize() {
        int n = this.memoizedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.field_)) {
            n += GeneratedMessageV3.computeStringSize((int)1, (Object)this.field_);
        }
        if ((this.bitField0_ & 1) != 0) {
            n += CodedOutputStream.computeFloatSize((int)2, (float)this.boost_);
        }
        if ((this.bitField0_ & 2) != 0) {
            n += GeneratedMessageV3.computeStringSize((int)3, (Object)this.underscoreName_);
        }
        if (this.maxExpansions_ != 0) {
            n += CodedOutputStream.computeInt32Size((int)4, (int)this.maxExpansions_);
        }
        if (this.prefixLength_ != 0) {
            n += CodedOutputStream.computeInt32Size((int)5, (int)this.prefixLength_);
        }
        if (this.rewrite_ != MultiTermQueryRewrite.MULTI_TERM_QUERY_REWRITE_UNSPECIFIED.getNumber()) {
            n += CodedOutputStream.computeEnumSize((int)6, (int)this.rewrite_);
        }
        if (this.transpositions_) {
            n += CodedOutputStream.computeBoolSize((int)7, (boolean)this.transpositions_);
        }
        if ((this.bitField0_ & 4) != 0) {
            n += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getFuzziness());
        }
        if ((this.bitField0_ & 8) != 0) {
            n += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getValue());
        }
        this.memoizedSize = n += this.getUnknownFields().getSerializedSize();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FuzzyQuery)) {
            return super.equals(object);
        }
        FuzzyQuery fuzzyQuery = (FuzzyQuery)object;
        if (!this.getField().equals(fuzzyQuery.getField())) {
            return false;
        }
        if (this.hasBoost() != fuzzyQuery.hasBoost()) {
            return false;
        }
        if (this.hasBoost() && Float.floatToIntBits(this.getBoost()) != Float.floatToIntBits(fuzzyQuery.getBoost())) {
            return false;
        }
        if (this.hasUnderscoreName() != fuzzyQuery.hasUnderscoreName()) {
            return false;
        }
        if (this.hasUnderscoreName() && !this.getUnderscoreName().equals(fuzzyQuery.getUnderscoreName())) {
            return false;
        }
        if (this.getMaxExpansions() != fuzzyQuery.getMaxExpansions()) {
            return false;
        }
        if (this.getPrefixLength() != fuzzyQuery.getPrefixLength()) {
            return false;
        }
        if (this.rewrite_ != fuzzyQuery.rewrite_) {
            return false;
        }
        if (this.getTranspositions() != fuzzyQuery.getTranspositions()) {
            return false;
        }
        if (this.hasFuzziness() != fuzzyQuery.hasFuzziness()) {
            return false;
        }
        if (this.hasFuzziness() && !this.getFuzziness().equals(fuzzyQuery.getFuzziness())) {
            return false;
        }
        if (this.hasValue() != fuzzyQuery.hasValue()) {
            return false;
        }
        if (this.hasValue() && !this.getValue().equals(fuzzyQuery.getValue())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)fuzzyQuery.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int n = 41;
        n = 19 * n + FuzzyQuery.getDescriptor().hashCode();
        n = 37 * n + 1;
        n = 53 * n + this.getField().hashCode();
        if (this.hasBoost()) {
            n = 37 * n + 2;
            n = 53 * n + Float.floatToIntBits(this.getBoost());
        }
        if (this.hasUnderscoreName()) {
            n = 37 * n + 3;
            n = 53 * n + this.getUnderscoreName().hashCode();
        }
        n = 37 * n + 4;
        n = 53 * n + this.getMaxExpansions();
        n = 37 * n + 5;
        n = 53 * n + this.getPrefixLength();
        n = 37 * n + 6;
        n = 53 * n + this.rewrite_;
        n = 37 * n + 7;
        n = 53 * n + Internal.hashBoolean((boolean)this.getTranspositions());
        if (this.hasFuzziness()) {
            n = 37 * n + 8;
            n = 53 * n + this.getFuzziness().hashCode();
        }
        if (this.hasValue()) {
            n = 37 * n + 9;
            n = 53 * n + this.getValue().hashCode();
        }
        this.memoizedHashCode = n = 29 * n + this.getUnknownFields().hashCode();
        return n;
    }

    public static FuzzyQuery parseFrom(ByteBuffer byteBuffer) throws InvalidProtocolBufferException {
        return (FuzzyQuery)PARSER.parseFrom(byteBuffer);
    }

    public static FuzzyQuery parseFrom(ByteBuffer byteBuffer, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (FuzzyQuery)PARSER.parseFrom(byteBuffer, extensionRegistryLite);
    }

    public static FuzzyQuery parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return (FuzzyQuery)PARSER.parseFrom(byteString);
    }

    public static FuzzyQuery parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (FuzzyQuery)PARSER.parseFrom(byteString, extensionRegistryLite);
    }

    public static FuzzyQuery parseFrom(byte[] byArray) throws InvalidProtocolBufferException {
        return (FuzzyQuery)PARSER.parseFrom(byArray);
    }

    public static FuzzyQuery parseFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (FuzzyQuery)PARSER.parseFrom(byArray, extensionRegistryLite);
    }

    public static FuzzyQuery parseFrom(InputStream inputStream) throws IOException {
        return (FuzzyQuery)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream);
    }

    public static FuzzyQuery parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (FuzzyQuery)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static FuzzyQuery parseDelimitedFrom(InputStream inputStream) throws IOException {
        return (FuzzyQuery)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream);
    }

    public static FuzzyQuery parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (FuzzyQuery)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static FuzzyQuery parseFrom(CodedInputStream codedInputStream) throws IOException {
        return (FuzzyQuery)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream);
    }

    public static FuzzyQuery parseFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (FuzzyQuery)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public Builder newBuilderForType() {
        return FuzzyQuery.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FuzzyQuery fuzzyQuery) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(fuzzyQuery);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
        Builder builder = new Builder(builderParent);
        return builder;
    }

    public static FuzzyQuery getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<FuzzyQuery> parser() {
        return PARSER;
    }

    public Parser<FuzzyQuery> getParserForType() {
        return PARSER;
    }

    public FuzzyQuery getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements FuzzyQueryOrBuilder {
        private int bitField0_;
        private Object field_ = "";
        private float boost_;
        private Object underscoreName_ = "";
        private int maxExpansions_;
        private int prefixLength_;
        private int rewrite_ = 0;
        private boolean transpositions_;
        private Fuzziness fuzziness_;
        private SingleFieldBuilderV3<Fuzziness, Fuzziness.Builder, FuzzinessOrBuilder> fuzzinessBuilder_;
        private Value value_;
        private SingleFieldBuilderV3<Value, Value.Builder, ValueOrBuilder> valueBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_FuzzyQuery_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_FuzzyQuery_fieldAccessorTable.ensureFieldAccessorsInitialized(FuzzyQuery.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent builderParent) {
            super(builderParent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getFuzzinessFieldBuilder();
                this.getValueFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.field_ = "";
            this.boost_ = 0.0f;
            this.underscoreName_ = "";
            this.maxExpansions_ = 0;
            this.prefixLength_ = 0;
            this.rewrite_ = 0;
            this.transpositions_ = false;
            this.fuzziness_ = null;
            if (this.fuzzinessBuilder_ != null) {
                this.fuzzinessBuilder_.dispose();
                this.fuzzinessBuilder_ = null;
            }
            this.value_ = null;
            if (this.valueBuilder_ != null) {
                this.valueBuilder_.dispose();
                this.valueBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_FuzzyQuery_descriptor;
        }

        public FuzzyQuery getDefaultInstanceForType() {
            return FuzzyQuery.getDefaultInstance();
        }

        public FuzzyQuery build() {
            FuzzyQuery fuzzyQuery = this.buildPartial();
            if (!fuzzyQuery.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)fuzzyQuery);
            }
            return fuzzyQuery;
        }

        public FuzzyQuery buildPartial() {
            FuzzyQuery fuzzyQuery = new FuzzyQuery(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(fuzzyQuery);
            }
            this.onBuilt();
            return fuzzyQuery;
        }

        private void buildPartial0(FuzzyQuery fuzzyQuery) {
            int n = this.bitField0_;
            if ((n & 1) != 0) {
                fuzzyQuery.field_ = this.field_;
            }
            int n2 = 0;
            if ((n & 2) != 0) {
                fuzzyQuery.boost_ = this.boost_;
                n2 |= 1;
            }
            if ((n & 4) != 0) {
                fuzzyQuery.underscoreName_ = this.underscoreName_;
                n2 |= 2;
            }
            if ((n & 8) != 0) {
                fuzzyQuery.maxExpansions_ = this.maxExpansions_;
            }
            if ((n & 0x10) != 0) {
                fuzzyQuery.prefixLength_ = this.prefixLength_;
            }
            if ((n & 0x20) != 0) {
                fuzzyQuery.rewrite_ = this.rewrite_;
            }
            if ((n & 0x40) != 0) {
                fuzzyQuery.transpositions_ = this.transpositions_;
            }
            if ((n & 0x80) != 0) {
                fuzzyQuery.fuzziness_ = this.fuzzinessBuilder_ == null ? this.fuzziness_ : (Fuzziness)this.fuzzinessBuilder_.build();
                n2 |= 4;
            }
            if ((n & 0x100) != 0) {
                fuzzyQuery.value_ = this.valueBuilder_ == null ? this.value_ : (Value)this.valueBuilder_.build();
                n2 |= 8;
            }
            fuzzyQuery.bitField0_ |= n2;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.setField(fieldDescriptor, object);
        }

        public Builder clearField(Descriptors.FieldDescriptor fieldDescriptor) {
            return (Builder)super.clearField(fieldDescriptor);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            return (Builder)super.clearOneof(oneofDescriptor);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n, Object object) {
            return (Builder)super.setRepeatedField(fieldDescriptor, n, object);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.addRepeatedField(fieldDescriptor, object);
        }

        public Builder mergeFrom(Message message) {
            if (message instanceof FuzzyQuery) {
                return this.mergeFrom((FuzzyQuery)message);
            }
            super.mergeFrom(message);
            return this;
        }

        public Builder mergeFrom(FuzzyQuery fuzzyQuery) {
            if (fuzzyQuery == FuzzyQuery.getDefaultInstance()) {
                return this;
            }
            if (!fuzzyQuery.getField().isEmpty()) {
                this.field_ = fuzzyQuery.field_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (fuzzyQuery.hasBoost()) {
                this.setBoost(fuzzyQuery.getBoost());
            }
            if (fuzzyQuery.hasUnderscoreName()) {
                this.underscoreName_ = fuzzyQuery.underscoreName_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (fuzzyQuery.getMaxExpansions() != 0) {
                this.setMaxExpansions(fuzzyQuery.getMaxExpansions());
            }
            if (fuzzyQuery.getPrefixLength() != 0) {
                this.setPrefixLength(fuzzyQuery.getPrefixLength());
            }
            if (fuzzyQuery.rewrite_ != 0) {
                this.setRewriteValue(fuzzyQuery.getRewriteValue());
            }
            if (fuzzyQuery.getTranspositions()) {
                this.setTranspositions(fuzzyQuery.getTranspositions());
            }
            if (fuzzyQuery.hasFuzziness()) {
                this.mergeFuzziness(fuzzyQuery.getFuzziness());
            }
            if (fuzzyQuery.hasValue()) {
                this.mergeValue(fuzzyQuery.getValue());
            }
            this.mergeUnknownFields(fuzzyQuery.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            if (extensionRegistryLite == null) {
                throw new NullPointerException();
            }
            try {
                boolean bl = false;
                block17: while (!bl) {
                    int n = codedInputStream.readTag();
                    switch (n) {
                        case 0: {
                            bl = true;
                            continue block17;
                        }
                        case 10: {
                            this.field_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 21: {
                            this.boost_ = codedInputStream.readFloat();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 26: {
                            this.underscoreName_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.maxExpansions_ = codedInputStream.readInt32();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 40: {
                            this.prefixLength_ = codedInputStream.readInt32();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 48: {
                            this.rewrite_ = codedInputStream.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 56: {
                            this.transpositions_ = codedInputStream.readBool();
                            this.bitField0_ |= 0x40;
                            continue block17;
                        }
                        case 66: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getFuzzinessFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 74: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getValueFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 0x100;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(codedInputStream, extensionRegistryLite, n)) continue;
                    bl = true;
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getField() {
            Object object = this.field_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.field_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getFieldBytes() {
            Object object = this.field_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.field_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setField(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.field_ = string;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearField() {
            this.field_ = FuzzyQuery.getDefaultInstance().getField();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setFieldBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            FuzzyQuery.checkByteStringIsUtf8((ByteString)byteString);
            this.field_ = byteString;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBoost() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public float getBoost() {
            return this.boost_;
        }

        public Builder setBoost(float f) {
            this.boost_ = f;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearBoost() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.boost_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasUnderscoreName() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getUnderscoreName() {
            Object object = this.underscoreName_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.underscoreName_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getUnderscoreNameBytes() {
            Object object = this.underscoreName_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.underscoreName_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setUnderscoreName(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.underscoreName_ = string;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearUnderscoreName() {
            this.underscoreName_ = FuzzyQuery.getDefaultInstance().getUnderscoreName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setUnderscoreNameBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            FuzzyQuery.checkByteStringIsUtf8((ByteString)byteString);
            this.underscoreName_ = byteString;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getMaxExpansions() {
            return this.maxExpansions_;
        }

        public Builder setMaxExpansions(int n) {
            this.maxExpansions_ = n;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearMaxExpansions() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.maxExpansions_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPrefixLength() {
            return this.prefixLength_;
        }

        public Builder setPrefixLength(int n) {
            this.prefixLength_ = n;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPrefixLength() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.prefixLength_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getRewriteValue() {
            return this.rewrite_;
        }

        public Builder setRewriteValue(int n) {
            this.rewrite_ = n;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public MultiTermQueryRewrite getRewrite() {
            MultiTermQueryRewrite multiTermQueryRewrite = MultiTermQueryRewrite.forNumber(this.rewrite_);
            return multiTermQueryRewrite == null ? MultiTermQueryRewrite.UNRECOGNIZED : multiTermQueryRewrite;
        }

        public Builder setRewrite(MultiTermQueryRewrite multiTermQueryRewrite) {
            if (multiTermQueryRewrite == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.rewrite_ = multiTermQueryRewrite.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRewrite() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.rewrite_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getTranspositions() {
            return this.transpositions_;
        }

        public Builder setTranspositions(boolean bl) {
            this.transpositions_ = bl;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearTranspositions() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.transpositions_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFuzziness() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Fuzziness getFuzziness() {
            if (this.fuzzinessBuilder_ == null) {
                return this.fuzziness_ == null ? Fuzziness.getDefaultInstance() : this.fuzziness_;
            }
            return (Fuzziness)this.fuzzinessBuilder_.getMessage();
        }

        public Builder setFuzziness(Fuzziness fuzziness) {
            if (this.fuzzinessBuilder_ == null) {
                if (fuzziness == null) {
                    throw new NullPointerException();
                }
                this.fuzziness_ = fuzziness;
            } else {
                this.fuzzinessBuilder_.setMessage((AbstractMessage)fuzziness);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setFuzziness(Fuzziness.Builder builder) {
            if (this.fuzzinessBuilder_ == null) {
                this.fuzziness_ = builder.build();
            } else {
                this.fuzzinessBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeFuzziness(Fuzziness fuzziness) {
            if (this.fuzzinessBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.fuzziness_ != null && this.fuzziness_ != Fuzziness.getDefaultInstance()) {
                    this.getFuzzinessBuilder().mergeFrom(fuzziness);
                } else {
                    this.fuzziness_ = fuzziness;
                }
            } else {
                this.fuzzinessBuilder_.mergeFrom((AbstractMessage)fuzziness);
            }
            if (this.fuzziness_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearFuzziness() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.fuzziness_ = null;
            if (this.fuzzinessBuilder_ != null) {
                this.fuzzinessBuilder_.dispose();
                this.fuzzinessBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Fuzziness.Builder getFuzzinessBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Fuzziness.Builder)this.getFuzzinessFieldBuilder().getBuilder();
        }

        @Override
        public FuzzinessOrBuilder getFuzzinessOrBuilder() {
            if (this.fuzzinessBuilder_ != null) {
                return (FuzzinessOrBuilder)this.fuzzinessBuilder_.getMessageOrBuilder();
            }
            return this.fuzziness_ == null ? Fuzziness.getDefaultInstance() : this.fuzziness_;
        }

        private SingleFieldBuilderV3<Fuzziness, Fuzziness.Builder, FuzzinessOrBuilder> getFuzzinessFieldBuilder() {
            if (this.fuzzinessBuilder_ == null) {
                this.fuzzinessBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getFuzziness(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.fuzziness_ = null;
            }
            return this.fuzzinessBuilder_;
        }

        @Override
        public boolean hasValue() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Value getValue() {
            if (this.valueBuilder_ == null) {
                return this.value_ == null ? Value.getDefaultInstance() : this.value_;
            }
            return (Value)this.valueBuilder_.getMessage();
        }

        public Builder setValue(Value value) {
            if (this.valueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.value_ = value;
            } else {
                this.valueBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setValue(Value.Builder builder) {
            if (this.valueBuilder_ == null) {
                this.value_ = builder.build();
            } else {
                this.valueBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeValue(Value value) {
            if (this.valueBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.value_ != null && this.value_ != Value.getDefaultInstance()) {
                    this.getValueBuilder().mergeFrom(value);
                } else {
                    this.value_ = value;
                }
            } else {
                this.valueBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.value_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearValue() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.value_ = null;
            if (this.valueBuilder_ != null) {
                this.valueBuilder_.dispose();
                this.valueBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Value.Builder getValueBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Value.Builder)this.getValueFieldBuilder().getBuilder();
        }

        @Override
        public ValueOrBuilder getValueOrBuilder() {
            if (this.valueBuilder_ != null) {
                return (ValueOrBuilder)this.valueBuilder_.getMessageOrBuilder();
            }
            return this.value_ == null ? Value.getDefaultInstance() : this.value_;
        }

        private SingleFieldBuilderV3<Value, Value.Builder, ValueOrBuilder> getValueFieldBuilder() {
            if (this.valueBuilder_ == null) {
                this.valueBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getValue(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.value_ = null;
            }
            return this.valueBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.setUnknownFields(unknownFieldSet);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.mergeUnknownFields(unknownFieldSet);
        }
    }

    public static enum MultiTermQueryRewrite implements ProtocolMessageEnum
    {
        MULTI_TERM_QUERY_REWRITE_UNSPECIFIED(0),
        MULTI_TERM_QUERY_REWRITE_CONSTANT_SCORE(1),
        MULTI_TERM_QUERY_REWRITE_CONSTANT_SCORE_BOOLEAN(2),
        MULTI_TERM_QUERY_REWRITE_SCORING_BOOLEAN(3),
        MULTI_TERM_QUERY_REWRITE_TOP_TERMS_N(4),
        MULTI_TERM_QUERY_REWRITE_TOP_TERMS_BLENDED_FREQS_N(5),
        MULTI_TERM_QUERY_REWRITE_TOP_TERMS_BOOST_N(6),
        UNRECOGNIZED(-1);

        public static final int MULTI_TERM_QUERY_REWRITE_UNSPECIFIED_VALUE = 0;
        public static final int MULTI_TERM_QUERY_REWRITE_CONSTANT_SCORE_VALUE = 1;
        public static final int MULTI_TERM_QUERY_REWRITE_CONSTANT_SCORE_BOOLEAN_VALUE = 2;
        public static final int MULTI_TERM_QUERY_REWRITE_SCORING_BOOLEAN_VALUE = 3;
        public static final int MULTI_TERM_QUERY_REWRITE_TOP_TERMS_N_VALUE = 4;
        public static final int MULTI_TERM_QUERY_REWRITE_TOP_TERMS_BLENDED_FREQS_N_VALUE = 5;
        public static final int MULTI_TERM_QUERY_REWRITE_TOP_TERMS_BOOST_N_VALUE = 6;
        private static final Internal.EnumLiteMap<MultiTermQueryRewrite> internalValueMap;
        private static final MultiTermQueryRewrite[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static MultiTermQueryRewrite valueOf(int n) {
            return MultiTermQueryRewrite.forNumber(n);
        }

        public static MultiTermQueryRewrite forNumber(int n) {
            switch (n) {
                case 0: {
                    return MULTI_TERM_QUERY_REWRITE_UNSPECIFIED;
                }
                case 1: {
                    return MULTI_TERM_QUERY_REWRITE_CONSTANT_SCORE;
                }
                case 2: {
                    return MULTI_TERM_QUERY_REWRITE_CONSTANT_SCORE_BOOLEAN;
                }
                case 3: {
                    return MULTI_TERM_QUERY_REWRITE_SCORING_BOOLEAN;
                }
                case 4: {
                    return MULTI_TERM_QUERY_REWRITE_TOP_TERMS_N;
                }
                case 5: {
                    return MULTI_TERM_QUERY_REWRITE_TOP_TERMS_BLENDED_FREQS_N;
                }
                case 6: {
                    return MULTI_TERM_QUERY_REWRITE_TOP_TERMS_BOOST_N;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<MultiTermQueryRewrite> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)MultiTermQueryRewrite.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return MultiTermQueryRewrite.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)FuzzyQuery.getDescriptor().getEnumTypes().get(0);
        }

        public static MultiTermQueryRewrite valueOf(Descriptors.EnumValueDescriptor enumValueDescriptor) {
            if (enumValueDescriptor.getType() != MultiTermQueryRewrite.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (enumValueDescriptor.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[enumValueDescriptor.getIndex()];
        }

        private MultiTermQueryRewrite(int n2) {
            this.value = n2;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<MultiTermQueryRewrite>(){

                public MultiTermQueryRewrite findValueByNumber(int n) {
                    return MultiTermQueryRewrite.forNumber(n);
                }
            };
            VALUES = MultiTermQueryRewrite.values();
        }
    }

    public static final class Value
    extends GeneratedMessageV3
    implements ValueOrBuilder {
        private static final long serialVersionUID = 0L;
        private int valueCase_ = 0;
        private Object value_;
        public static final int STRING_VALUE_FIELD_NUMBER = 1;
        public static final int BOOL_VALUE_FIELD_NUMBER = 2;
        public static final int GENERAL_NUMBER_FIELD_NUMBER = 3;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Value DEFAULT_INSTANCE = new Value();
        private static final Parser<Value> PARSER = new AbstractParser<Value>(){

            public Value parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
                Builder builder = Value.newBuilder();
                try {
                    builder.mergeFrom(codedInputStream, extensionRegistryLite);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw invalidProtocolBufferException.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException uninitializedMessageException) {
                    throw uninitializedMessageException.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException iOException) {
                    throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Value(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Value() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unusedPrivateParameter) {
            return new Value();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_FuzzyQuery_Value_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_FuzzyQuery_Value_fieldAccessorTable.ensureFieldAccessorsInitialized(Value.class, Builder.class);
        }

        @Override
        public ValueCase getValueCase() {
            return ValueCase.forNumber(this.valueCase_);
        }

        @Override
        public boolean hasStringValue() {
            return this.valueCase_ == 1;
        }

        @Override
        public String getStringValue() {
            Object object = "";
            if (this.valueCase_ == 1) {
                object = this.value_;
            }
            if (object instanceof String) {
                return (String)object;
            }
            ByteString byteString = (ByteString)object;
            String string = byteString.toStringUtf8();
            if (this.valueCase_ == 1) {
                this.value_ = string;
            }
            return string;
        }

        @Override
        public ByteString getStringValueBytes() {
            Object object = "";
            if (this.valueCase_ == 1) {
                object = this.value_;
            }
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                if (this.valueCase_ == 1) {
                    this.value_ = byteString;
                }
                return byteString;
            }
            return (ByteString)object;
        }

        @Override
        public boolean hasBoolValue() {
            return this.valueCase_ == 2;
        }

        @Override
        public boolean getBoolValue() {
            if (this.valueCase_ == 2) {
                return (Boolean)this.value_;
            }
            return false;
        }

        @Override
        public boolean hasGeneralNumber() {
            return this.valueCase_ == 3;
        }

        @Override
        public GeneralNumber getGeneralNumber() {
            if (this.valueCase_ == 3) {
                return (GeneralNumber)this.value_;
            }
            return GeneralNumber.getDefaultInstance();
        }

        @Override
        public GeneralNumberOrBuilder getGeneralNumberOrBuilder() {
            if (this.valueCase_ == 3) {
                return (GeneralNumber)this.value_;
            }
            return GeneralNumber.getDefaultInstance();
        }

        public final boolean isInitialized() {
            byte by = this.memoizedIsInitialized;
            if (by == 1) {
                return true;
            }
            if (by == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
            if (this.valueCase_ == 1) {
                GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)1, (Object)this.value_);
            }
            if (this.valueCase_ == 2) {
                codedOutputStream.writeBool(2, ((Boolean)this.value_).booleanValue());
            }
            if (this.valueCase_ == 3) {
                codedOutputStream.writeMessage(3, (MessageLite)((GeneralNumber)this.value_));
            }
            this.getUnknownFields().writeTo(codedOutputStream);
        }

        public int getSerializedSize() {
            int n = this.memoizedSize;
            if (n != -1) {
                return n;
            }
            n = 0;
            if (this.valueCase_ == 1) {
                n += GeneratedMessageV3.computeStringSize((int)1, (Object)this.value_);
            }
            if (this.valueCase_ == 2) {
                n += CodedOutputStream.computeBoolSize((int)2, (boolean)((Boolean)this.value_));
            }
            if (this.valueCase_ == 3) {
                n += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((GeneralNumber)this.value_));
            }
            this.memoizedSize = n += this.getUnknownFields().getSerializedSize();
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Value)) {
                return super.equals(object);
            }
            Value value = (Value)object;
            if (!this.getValueCase().equals((Object)value.getValueCase())) {
                return false;
            }
            switch (this.valueCase_) {
                case 1: {
                    if (this.getStringValue().equals(value.getStringValue())) break;
                    return false;
                }
                case 2: {
                    if (this.getBoolValue() == value.getBoolValue()) break;
                    return false;
                }
                case 3: {
                    if (this.getGeneralNumber().equals(value.getGeneralNumber())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)value.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int n = 41;
            n = 19 * n + Value.getDescriptor().hashCode();
            switch (this.valueCase_) {
                case 1: {
                    n = 37 * n + 1;
                    n = 53 * n + this.getStringValue().hashCode();
                    break;
                }
                case 2: {
                    n = 37 * n + 2;
                    n = 53 * n + Internal.hashBoolean((boolean)this.getBoolValue());
                    break;
                }
                case 3: {
                    n = 37 * n + 3;
                    n = 53 * n + this.getGeneralNumber().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = n = 29 * n + this.getUnknownFields().hashCode();
            return n;
        }

        public static Value parseFrom(ByteBuffer byteBuffer) throws InvalidProtocolBufferException {
            return (Value)PARSER.parseFrom(byteBuffer);
        }

        public static Value parseFrom(ByteBuffer byteBuffer, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (Value)PARSER.parseFrom(byteBuffer, extensionRegistryLite);
        }

        public static Value parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
            return (Value)PARSER.parseFrom(byteString);
        }

        public static Value parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (Value)PARSER.parseFrom(byteString, extensionRegistryLite);
        }

        public static Value parseFrom(byte[] byArray) throws InvalidProtocolBufferException {
            return (Value)PARSER.parseFrom(byArray);
        }

        public static Value parseFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (Value)PARSER.parseFrom(byArray, extensionRegistryLite);
        }

        public static Value parseFrom(InputStream inputStream) throws IOException {
            return (Value)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream);
        }

        public static Value parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return (Value)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
        }

        public static Value parseDelimitedFrom(InputStream inputStream) throws IOException {
            return (Value)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream);
        }

        public static Value parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return (Value)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
        }

        public static Value parseFrom(CodedInputStream codedInputStream) throws IOException {
            return (Value)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream);
        }

        public static Value parseFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return (Value)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream, (ExtensionRegistryLite)extensionRegistryLite);
        }

        public Builder newBuilderForType() {
            return Value.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Value value) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(value);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
            Builder builder = new Builder(builderParent);
            return builder;
        }

        public static Value getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Value> parser() {
            return PARSER;
        }

        public Parser<Value> getParserForType() {
            return PARSER;
        }

        public Value getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ValueOrBuilder {
            private int valueCase_ = 0;
            private Object value_;
            private int bitField0_;
            private SingleFieldBuilderV3<GeneralNumber, GeneralNumber.Builder, GeneralNumberOrBuilder> generalNumberBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return CommonProto.internal_static_FuzzyQuery_Value_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CommonProto.internal_static_FuzzyQuery_Value_fieldAccessorTable.ensureFieldAccessorsInitialized(Value.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent builderParent) {
                super(builderParent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.generalNumberBuilder_ != null) {
                    this.generalNumberBuilder_.clear();
                }
                this.valueCase_ = 0;
                this.value_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CommonProto.internal_static_FuzzyQuery_Value_descriptor;
            }

            public Value getDefaultInstanceForType() {
                return Value.getDefaultInstance();
            }

            public Value build() {
                Value value = this.buildPartial();
                if (!value.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)value);
                }
                return value;
            }

            public Value buildPartial() {
                Value value = new Value(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(value);
                }
                this.buildPartialOneofs(value);
                this.onBuilt();
                return value;
            }

            private void buildPartial0(Value value) {
                int n = this.bitField0_;
            }

            private void buildPartialOneofs(Value value) {
                value.valueCase_ = this.valueCase_;
                value.value_ = this.value_;
                if (this.valueCase_ == 3 && this.generalNumberBuilder_ != null) {
                    value.value_ = this.generalNumberBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
                return (Builder)super.setField(fieldDescriptor, object);
            }

            public Builder clearField(Descriptors.FieldDescriptor fieldDescriptor) {
                return (Builder)super.clearField(fieldDescriptor);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
                return (Builder)super.clearOneof(oneofDescriptor);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n, Object object) {
                return (Builder)super.setRepeatedField(fieldDescriptor, n, object);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
                return (Builder)super.addRepeatedField(fieldDescriptor, object);
            }

            public Builder mergeFrom(Message message) {
                if (message instanceof Value) {
                    return this.mergeFrom((Value)message);
                }
                super.mergeFrom(message);
                return this;
            }

            public Builder mergeFrom(Value value) {
                if (value == Value.getDefaultInstance()) {
                    return this;
                }
                switch (value.getValueCase().ordinal()) {
                    case 0: {
                        this.valueCase_ = 1;
                        this.value_ = value.value_;
                        this.onChanged();
                        break;
                    }
                    case 1: {
                        this.setBoolValue(value.getBoolValue());
                        break;
                    }
                    case 2: {
                        this.mergeGeneralNumber(value.getGeneralNumber());
                        break;
                    }
                }
                this.mergeUnknownFields(value.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
                if (extensionRegistryLite == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean bl = false;
                    block11: while (!bl) {
                        int n = codedInputStream.readTag();
                        switch (n) {
                            case 0: {
                                bl = true;
                                continue block11;
                            }
                            case 10: {
                                String string = codedInputStream.readStringRequireUtf8();
                                this.valueCase_ = 1;
                                this.value_ = string;
                                continue block11;
                            }
                            case 16: {
                                this.value_ = codedInputStream.readBool();
                                this.valueCase_ = 2;
                                continue block11;
                            }
                            case 26: {
                                codedInputStream.readMessage((MessageLite.Builder)this.getGeneralNumberFieldBuilder().getBuilder(), extensionRegistryLite);
                                this.valueCase_ = 3;
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(codedInputStream, extensionRegistryLite, n)) continue;
                        bl = true;
                    }
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw invalidProtocolBufferException.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public ValueCase getValueCase() {
                return ValueCase.forNumber(this.valueCase_);
            }

            public Builder clearValue() {
                this.valueCase_ = 0;
                this.value_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasStringValue() {
                return this.valueCase_ == 1;
            }

            @Override
            public String getStringValue() {
                Object object = "";
                if (this.valueCase_ == 1) {
                    object = this.value_;
                }
                if (!(object instanceof String)) {
                    ByteString byteString = (ByteString)object;
                    String string = byteString.toStringUtf8();
                    if (this.valueCase_ == 1) {
                        this.value_ = string;
                    }
                    return string;
                }
                return (String)object;
            }

            @Override
            public ByteString getStringValueBytes() {
                Object object = "";
                if (this.valueCase_ == 1) {
                    object = this.value_;
                }
                if (object instanceof String) {
                    ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                    if (this.valueCase_ == 1) {
                        this.value_ = byteString;
                    }
                    return byteString;
                }
                return (ByteString)object;
            }

            public Builder setStringValue(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                this.valueCase_ = 1;
                this.value_ = string;
                this.onChanged();
                return this;
            }

            public Builder clearStringValue() {
                if (this.valueCase_ == 1) {
                    this.valueCase_ = 0;
                    this.value_ = null;
                    this.onChanged();
                }
                return this;
            }

            public Builder setStringValueBytes(ByteString byteString) {
                if (byteString == null) {
                    throw new NullPointerException();
                }
                Value.checkByteStringIsUtf8((ByteString)byteString);
                this.valueCase_ = 1;
                this.value_ = byteString;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBoolValue() {
                return this.valueCase_ == 2;
            }

            @Override
            public boolean getBoolValue() {
                if (this.valueCase_ == 2) {
                    return (Boolean)this.value_;
                }
                return false;
            }

            public Builder setBoolValue(boolean bl) {
                this.valueCase_ = 2;
                this.value_ = bl;
                this.onChanged();
                return this;
            }

            public Builder clearBoolValue() {
                if (this.valueCase_ == 2) {
                    this.valueCase_ = 0;
                    this.value_ = null;
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasGeneralNumber() {
                return this.valueCase_ == 3;
            }

            @Override
            public GeneralNumber getGeneralNumber() {
                if (this.generalNumberBuilder_ == null) {
                    if (this.valueCase_ == 3) {
                        return (GeneralNumber)this.value_;
                    }
                    return GeneralNumber.getDefaultInstance();
                }
                if (this.valueCase_ == 3) {
                    return (GeneralNumber)this.generalNumberBuilder_.getMessage();
                }
                return GeneralNumber.getDefaultInstance();
            }

            public Builder setGeneralNumber(GeneralNumber generalNumber) {
                if (this.generalNumberBuilder_ == null) {
                    if (generalNumber == null) {
                        throw new NullPointerException();
                    }
                    this.value_ = generalNumber;
                    this.onChanged();
                } else {
                    this.generalNumberBuilder_.setMessage((AbstractMessage)generalNumber);
                }
                this.valueCase_ = 3;
                return this;
            }

            public Builder setGeneralNumber(GeneralNumber.Builder builder) {
                if (this.generalNumberBuilder_ == null) {
                    this.value_ = builder.build();
                    this.onChanged();
                } else {
                    this.generalNumberBuilder_.setMessage((AbstractMessage)builder.build());
                }
                this.valueCase_ = 3;
                return this;
            }

            public Builder mergeGeneralNumber(GeneralNumber generalNumber) {
                if (this.generalNumberBuilder_ == null) {
                    this.value_ = this.valueCase_ == 3 && this.value_ != GeneralNumber.getDefaultInstance() ? GeneralNumber.newBuilder((GeneralNumber)this.value_).mergeFrom(generalNumber).buildPartial() : generalNumber;
                    this.onChanged();
                } else if (this.valueCase_ == 3) {
                    this.generalNumberBuilder_.mergeFrom((AbstractMessage)generalNumber);
                } else {
                    this.generalNumberBuilder_.setMessage((AbstractMessage)generalNumber);
                }
                this.valueCase_ = 3;
                return this;
            }

            public Builder clearGeneralNumber() {
                if (this.generalNumberBuilder_ == null) {
                    if (this.valueCase_ == 3) {
                        this.valueCase_ = 0;
                        this.value_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.valueCase_ == 3) {
                        this.valueCase_ = 0;
                        this.value_ = null;
                    }
                    this.generalNumberBuilder_.clear();
                }
                return this;
            }

            public GeneralNumber.Builder getGeneralNumberBuilder() {
                return (GeneralNumber.Builder)this.getGeneralNumberFieldBuilder().getBuilder();
            }

            @Override
            public GeneralNumberOrBuilder getGeneralNumberOrBuilder() {
                if (this.valueCase_ == 3 && this.generalNumberBuilder_ != null) {
                    return (GeneralNumberOrBuilder)this.generalNumberBuilder_.getMessageOrBuilder();
                }
                if (this.valueCase_ == 3) {
                    return (GeneralNumber)this.value_;
                }
                return GeneralNumber.getDefaultInstance();
            }

            private SingleFieldBuilderV3<GeneralNumber, GeneralNumber.Builder, GeneralNumberOrBuilder> getGeneralNumberFieldBuilder() {
                if (this.generalNumberBuilder_ == null) {
                    if (this.valueCase_ != 3) {
                        this.value_ = GeneralNumber.getDefaultInstance();
                    }
                    this.generalNumberBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((GeneralNumber)this.value_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.value_ = null;
                }
                this.valueCase_ = 3;
                this.onChanged();
                return this.generalNumberBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFieldSet) {
                return (Builder)super.setUnknownFields(unknownFieldSet);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
                return (Builder)super.mergeUnknownFields(unknownFieldSet);
            }
        }

        public static enum ValueCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            STRING_VALUE(1),
            BOOL_VALUE(2),
            GENERAL_NUMBER(3),
            VALUE_NOT_SET(0);

            private final int value;

            private ValueCase(int n2) {
                this.value = n2;
            }

            @Deprecated
            public static ValueCase valueOf(int n) {
                return ValueCase.forNumber(n);
            }

            public static ValueCase forNumber(int n) {
                switch (n) {
                    case 1: {
                        return STRING_VALUE;
                    }
                    case 2: {
                        return BOOL_VALUE;
                    }
                    case 3: {
                        return GENERAL_NUMBER;
                    }
                    case 0: {
                        return VALUE_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }
    }

    public static interface ValueOrBuilder
    extends MessageOrBuilder {
        public boolean hasStringValue();

        public String getStringValue();

        public ByteString getStringValueBytes();

        public boolean hasBoolValue();

        public boolean getBoolValue();

        public boolean hasGeneralNumber();

        public GeneralNumber getGeneralNumber();

        public GeneralNumberOrBuilder getGeneralNumberOrBuilder();

        public Value.ValueCase getValueCase();
    }
}

