/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.launchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class JvmErgonomics {
    private static final Pattern OPTION = Pattern.compile("^\\s*\\S+\\s+(?<flag>\\S+)\\s+:?=\\s+(?<value>\\S+)?\\s+\\{[^}]+?\\}(\\s+\\{[^}]+})?");
    private static final Pattern SYSTEM_PROPERTY = Pattern.compile("^-D(?<key>[\\w+].*?)=(?<value>.*)$");

    private JvmErgonomics() {
        throw new AssertionError((Object)"No instances intended");
    }

    static List<String> choose(List<String> userDefinedJvmOptions) throws InterruptedException, IOException {
        ArrayList<String> ergonomicChoices = new ArrayList<String>();
        Map<String, Optional<String>> finalJvmOptions = JvmErgonomics.finalJvmOptions(userDefinedJvmOptions);
        long heapSize = JvmErgonomics.extractHeapSize(finalJvmOptions);
        long maxDirectMemorySize = JvmErgonomics.extractMaxDirectMemorySize(finalJvmOptions);
        if (maxDirectMemorySize == 0L && userDefinedJvmOptions.stream().noneMatch(s -> s.startsWith("-XX:MaxDirectMemorySize"))) {
            ergonomicChoices.add("-XX:MaxDirectMemorySize=" + heapSize / 2L);
        }
        return ergonomicChoices;
    }

    static Map<String, Optional<String>> finalJvmOptions(List<String> userDefinedJvmOptions) throws InterruptedException, IOException {
        return Collections.unmodifiableMap(JvmErgonomics.flagsFinal(userDefinedJvmOptions).stream().map(OPTION::matcher).filter(Matcher::matches).collect(Collectors.toMap(m -> m.group("flag"), m -> Optional.ofNullable(m.group("value")))));
    }

    private static List<String> flagsFinal(List<String> userDefinedJvmOptions) throws InterruptedException, IOException {
        String java = Paths.get(System.getProperty("java.home"), "bin", "java").toString();
        List<String> command = Collections.unmodifiableList(Stream.of(Stream.of(java), userDefinedJvmOptions.stream(), Stream.of("-Xshare:off"), Stream.of("-XX:+PrintFlagsFinal"), Stream.of("-version")).reduce(Stream::concat).get().collect(Collectors.toList()));
        Process process = new ProcessBuilder(new String[0]).command(command).start();
        List<String> output = JvmErgonomics.readLinesFromInputStream(process.getInputStream());
        List<String> error = JvmErgonomics.readLinesFromInputStream(process.getErrorStream());
        int status = process.waitFor();
        if (status != 0) {
            String message = String.format(Locale.ROOT, "starting java failed with [%d]\noutput:\n%s\nerror:\n%s", status, String.join((CharSequence)"\n", output), String.join((CharSequence)"\n", error));
            throw new RuntimeException(message);
        }
        return output;
    }

    private static List<String> readLinesFromInputStream(InputStream is) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            List<String> list;
            try (BufferedReader br = new BufferedReader(isr);){
                list = Collections.unmodifiableList(br.lines().collect(Collectors.toList()));
            }
            return list;
        }
    }

    static Long extractHeapSize(Map<String, Optional<String>> finalJvmOptions) {
        return Long.parseLong(finalJvmOptions.get("MaxHeapSize").get());
    }

    static long extractMaxDirectMemorySize(Map<String, Optional<String>> finalJvmOptions) {
        return Long.parseLong(finalJvmOptions.get("MaxDirectMemorySize").get());
    }

    static Map<String, String> extractSystemProperties(List<String> userDefinedJvmOptions) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (String jvmOption : userDefinedJvmOptions) {
            Matcher matcher = SYSTEM_PROPERTY.matcher(jvmOption);
            if (!matcher.matches()) continue;
            systemProperties.put(matcher.group("key"), matcher.group("value"));
        }
        return systemProperties;
    }
}

