/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nativeprotocol;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.opensearch.common.io.Streams;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.BytesStream;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.compress.CompressorRegistry;

final class CompressibleBytesOutputStream
extends StreamOutput {
    private final OutputStream stream;
    private final BytesStream bytesStreamOutput;
    private final boolean shouldCompress;

    CompressibleBytesOutputStream(BytesStream bytesStreamOutput, boolean shouldCompress) throws IOException {
        this.bytesStreamOutput = bytesStreamOutput;
        this.shouldCompress = shouldCompress;
        this.stream = shouldCompress ? CompressorRegistry.defaultCompressor().threadLocalOutputStream((OutputStream)Streams.flushOnCloseStream(bytesStreamOutput)) : bytesStreamOutput;
    }

    BytesReference materializeBytes() throws IOException {
        if (this.shouldCompress) {
            this.stream.close();
        }
        return this.bytesStreamOutput.bytes();
    }

    public void writeByte(byte b) throws IOException {
        this.stream.write(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.stream.write(b, offset, length);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
        if (this.stream != this.bytesStreamOutput) {
            assert (this.shouldCompress) : "If the streams are different we should be compressing";
            IOUtils.close((Closeable)this.stream);
        }
    }

    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

