/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.XContentUtils;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="2.19.0")
public class ProcessorExecutionDetail
implements Writeable,
ToXContentObject {
    private final String processorName;
    private long durationMillis;
    private Object inputData;
    private Object outputData;
    private ProcessorStatus status;
    private String errorMessage;
    private String tag;
    private static final ParseField PROCESSOR_NAME_FIELD = new ParseField("processor_name", new String[0]);
    private static final ParseField DURATION_MILLIS_FIELD = new ParseField("duration_millis", new String[0]);
    private static final ParseField INPUT_DATA_FIELD = new ParseField("input_data", new String[0]);
    private static final ParseField OUTPUT_DATA_FIELD = new ParseField("output_data", new String[0]);
    private static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    private static final ParseField ERROR_MESSAGE_FIELD = new ParseField("error", new String[0]);
    private static final ParseField TAG_FIELD = new ParseField("tag", new String[0]);
    public static final String PROCESSOR_EXECUTION_DETAILS_KEY = "processorExecutionDetails";

    public ProcessorExecutionDetail(String processorName, long durationMillis, Object inputData, Object outputData, ProcessorStatus status, String errorMessage, String tag) {
        this.processorName = processorName;
        this.durationMillis = durationMillis;
        this.inputData = inputData;
        this.outputData = outputData;
        this.status = status;
        this.errorMessage = errorMessage;
        this.tag = tag;
    }

    public ProcessorExecutionDetail(String processorName) {
        this(processorName, 0L, null, null, ProcessorStatus.SUCCESS, null, null);
    }

    public ProcessorExecutionDetail(String processorName, String tag) {
        this(processorName, 0L, null, null, ProcessorStatus.SUCCESS, null, tag);
    }

    public ProcessorExecutionDetail(StreamInput in) throws IOException {
        this.processorName = in.readString();
        this.durationMillis = in.readLong();
        this.inputData = in.readGenericValue();
        this.outputData = in.readGenericValue();
        this.status = (ProcessorStatus)in.readEnum(ProcessorStatus.class);
        this.errorMessage = in.readString();
        this.tag = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.processorName);
        out.writeLong(this.durationMillis);
        out.writeGenericValue(this.inputData);
        out.writeGenericValue(this.outputData);
        out.writeEnum((Enum)this.status);
        out.writeString(this.errorMessage);
        out.writeString(this.tag);
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public Object getInputData() {
        return this.inputData;
    }

    public Object getOutputData() {
        return this.outputData;
    }

    public void markProcessorAsFailed(ProcessorStatus status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public ProcessorStatus getStatus() {
        return this.status;
    }

    public void addInput(Object inputData) {
        this.inputData = inputData;
    }

    public void addOutput(Object outputData) {
        this.outputData = outputData;
    }

    public void addTook(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PROCESSOR_NAME_FIELD.getPreferredName(), this.processorName);
        if (this.tag != null) {
            builder.field(TAG_FIELD.getPreferredName(), this.tag);
        }
        builder.field(DURATION_MILLIS_FIELD.getPreferredName(), this.durationMillis);
        builder.field(STATUS_FIELD.getPreferredName(), this.status.name().toLowerCase(Locale.ROOT));
        if (this.status == ProcessorStatus.FAIL) {
            builder.field(ERROR_MESSAGE_FIELD.getPreferredName(), this.errorMessage);
        }
        this.addFieldToXContent(builder, INPUT_DATA_FIELD.getPreferredName(), this.inputData, params);
        this.addFieldToXContent(builder, OUTPUT_DATA_FIELD.getPreferredName(), this.outputData, params);
        builder.endObject();
        return builder;
    }

    private void addFieldToXContent(XContentBuilder builder, String fieldName, Object data, ToXContent.Params params) throws IOException {
        if (data == null) {
            builder.nullField(fieldName);
            return;
        }
        if (data instanceof List) {
            builder.startArray(fieldName);
            for (Object item : (List)data) {
                this.writeItemToXContent(builder, item, params);
            }
            builder.endArray();
        } else if (data instanceof Map) {
            builder.startObject(fieldName);
            for (Map.Entry entry : ((Map)data).entrySet()) {
                this.addFieldToXContent(builder, entry.getKey().toString(), entry.getValue(), params);
            }
            builder.endObject();
        } else if (data instanceof ToXContentObject) {
            builder.field(fieldName);
            ((ToXContentObject)data).toXContent(builder, params);
        } else if (data instanceof String) {
            String jsonString = (String)data;
            try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonString);){
                Map parsedMap = parser.map();
                builder.startObject(fieldName);
                for (Map.Entry entry : parsedMap.entrySet()) {
                    this.addFieldToXContent(builder, (String)entry.getKey(), entry.getValue(), params);
                }
                builder.endObject();
            }
            catch (IOException e) {
                builder.field(fieldName, jsonString);
            }
        } else {
            builder.field(fieldName, data);
        }
    }

    private void writeItemToXContent(XContentBuilder builder, Object item, ToXContent.Params params) throws IOException {
        if (item instanceof ToXContentObject) {
            ((ToXContentObject)item).toXContent(builder, params);
        } else {
            builder.value(item);
        }
    }

    public static ProcessorExecutionDetail fromXContent(XContentParser parser) throws IOException {
        String processorName = null;
        long durationMillis = 0L;
        Object inputData = null;
        Object outputData = null;
        ProcessorStatus status = null;
        String errorMessage = null;
        String tag = null;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        }
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (PROCESSOR_NAME_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                processorName = parser.text();
                continue;
            }
            if (TAG_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                tag = parser.text();
                continue;
            }
            if (DURATION_MILLIS_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                durationMillis = parser.longValue();
                continue;
            }
            if (STATUS_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                status = ProcessorStatus.valueOf(parser.text().toUpperCase(Locale.ROOT));
                continue;
            }
            if (ERROR_MESSAGE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                errorMessage = parser.text();
                continue;
            }
            if (INPUT_DATA_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                inputData = XContentUtils.readValue((XContentParser)parser, (XContentParser.Token)parser.currentToken());
                continue;
            }
            if (OUTPUT_DATA_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                outputData = XContentUtils.readValue((XContentParser)parser, (XContentParser.Token)parser.currentToken());
                continue;
            }
            parser.skipChildren();
        }
        if (processorName == null) {
            throw new IllegalArgumentException("Processor name is required");
        }
        return new ProcessorExecutionDetail(processorName, durationMillis, inputData, outputData, status, errorMessage, tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.processorName, this.durationMillis, this.inputData, this.outputData, this.status, this.errorMessage, this.tag});
    }

    @PublicApi(since="2.19.0")
    public static enum ProcessorStatus {
        SUCCESS,
        FAIL;

    }
}

