/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private static final String SEMANTIC_VERSION_REGEX = "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$";
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;
    private final String build;

    public SemanticVersion(int major, int minor, int patch, String preRelease, String build) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Version numbers cannot be negative");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuild() {
        return this.build;
    }

    public static SemanticVersion parse(String version) {
        Pattern pattern;
        Matcher matcher;
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be null or empty");
        }
        version = version.trim();
        if ((version = version.replaceAll("\\[|\\]", "")).matches(".*\\s+.*")) {
            version = version.replaceAll("\\s+", ".");
        }
        if (!(matcher = (pattern = Pattern.compile(SEMANTIC_VERSION_REGEX)).matcher(version)).matches()) {
            throw new IllegalArgumentException("Invalid semantic version format: [" + version + "]");
        }
        try {
            return new SemanticVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4), matcher.group(5));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version numbers in: " + version, e);
        }
    }

    public String getNormalizedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SemanticVersion.padWithZeros(this.major, 20)).append('.').append(SemanticVersion.padWithZeros(this.minor, 20)).append('.').append(SemanticVersion.padWithZeros(this.patch, 20));
        if (this.preRelease != null) {
            sb.append('-').append(this.preRelease);
        }
        if (this.build != null) {
            sb.append('+').append(this.build);
        }
        return sb.toString();
    }

    public String getNormalizedComparableString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SemanticVersion.padWithZeros(this.major, 20)).append(".");
        sb.append(SemanticVersion.padWithZeros(this.minor, 20)).append(".");
        sb.append(SemanticVersion.padWithZeros(this.patch, 20));
        if (this.preRelease == null || this.preRelease.isEmpty()) {
            sb.append("~");
        } else {
            sb.append("-").append(this.preRelease.trim().toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }

    @Override
    public int compareTo(SemanticVersion other) {
        if (other == null) {
            return 1;
        }
        int majorComparison = Integer.compare(this.major, other.major);
        if (majorComparison != 0) {
            return majorComparison;
        }
        int minorComparison = Integer.compare(this.minor, other.minor);
        if (minorComparison != 0) {
            return minorComparison;
        }
        int patchComparison = Integer.compare(this.patch, other.patch);
        if (patchComparison != 0) {
            return patchComparison;
        }
        if (this.preRelease == null && other.preRelease != null) {
            return 1;
        }
        if (this.preRelease != null && other.preRelease == null) {
            return -1;
        }
        if (this.preRelease != null && other.preRelease != null) {
            return this.comparePreRelease(this.preRelease, other.preRelease);
        }
        return 0;
    }

    private int comparePreRelease(String pre1, String pre2) {
        String[] parts1 = pre1.split("\\.");
        String[] parts2 = pre2.split("\\.");
        int length = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            String part1 = parts1[i];
            String part2 = parts2[i];
            boolean isNum1 = part1.matches("\\d+");
            boolean isNum2 = part2.matches("\\d+");
            if (isNum1 && isNum2) {
                int num2;
                int num1 = Integer.parseInt(part1);
                int comparison = Integer.compare(num1, num2 = Integer.parseInt(part2));
                if (comparison == 0) continue;
                return comparison;
            }
            int comparison = part1.compareTo(part2);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.preRelease != null) {
            sb.append('-').append(this.preRelease);
        }
        if (this.build != null) {
            sb.append('+').append(this.build);
        }
        return sb.toString();
    }

    private static String padWithZeros(long value, int width) {
        String str = Long.toString(value);
        int padding = width - str.length();
        if (padding > 0) {
            char[] zeros = new char[padding];
            Arrays.fill(zeros, '0');
            return new String(zeros) + str;
        }
        return str;
    }
}

