/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.ingest;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ingest.SimulateDocumentBaseResult;
import org.opensearch.action.ingest.SimulateDocumentResult;
import org.opensearch.action.ingest.SimulateDocumentVerboseResult;
import org.opensearch.action.ingest.SimulatePipelineRequest;
import org.opensearch.action.ingest.SimulatePipelineResponse;
import org.opensearch.action.ingest.SimulateProcessorResult;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ingest.CompoundProcessor;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestService;
import org.opensearch.ingest.Pipeline;
import org.opensearch.ingest.TrackingResultProcessor;
import org.opensearch.threadpool.ThreadPool;

class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;
    private final IngestService ingestService;

    SimulateExecutionService(ThreadPool threadPool, IngestService ingestService) {
        this.threadPool = threadPool;
        this.ingestService = ingestService;
    }

    void executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose, BiConsumer<SimulateDocumentResult, Exception> handler) {
        if (verbose) {
            CopyOnWriteArrayList<SimulateProcessorResult> processorResultList = new CopyOnWriteArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), null, processorResultList);
            Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
            ingestDocument.executePipeline(verbosePipeline, (result, e) -> handler.accept(new SimulateDocumentVerboseResult(processorResultList), (Exception)e));
        } else {
            ingestDocument.executePipeline(pipeline, (result, e) -> {
                if (e == null) {
                    handler.accept(new SimulateDocumentBaseResult((IngestDocument)result), null);
                } else {
                    handler.accept(new SimulateDocumentBaseResult((Exception)e), null);
                }
            });
        }
    }

    public void execute(SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.ingestService.validateProcessorCountForIngestPipeline(request.getPipeline());
        this.threadPool.executor(THREAD_POOL_NAME).execute(ActionRunnable.wrap(listener, l -> {
            AtomicInteger counter = new AtomicInteger();
            CopyOnWriteArrayList<SimulateDocumentResult> responses = new CopyOnWriteArrayList<SimulateDocumentResult>(new SimulateDocumentBaseResult[request.getDocuments().size()]);
            if (request.getDocuments().isEmpty()) {
                l.onResponse((Object)new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
                return;
            }
            int iter = 0;
            for (IngestDocument ingestDocument : request.getDocuments()) {
                int index = iter++;
                this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose(), (response, e) -> {
                    if (response != null) {
                        responses.set(index, (SimulateDocumentResult)response);
                    }
                    if (counter.incrementAndGet() == request.getDocuments().size()) {
                        listener.onResponse((Object)new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
                    }
                });
            }
        }));
    }
}

