/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class EnglishPluralStemFilter
extends TokenFilter {
    private final EnglishPluralStemmer stemmer = new EnglishPluralStemmer();
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    public EnglishPluralStemFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }

    public static class EnglishPluralStemmer {
        public static final char[][] oesExceptions = new char[][]{"shoes".toCharArray(), "canoes".toCharArray(), "oboes".toCharArray()};
        public static final char[][] chesExceptions = new char[][]{"cliches".toCharArray(), "avalanches".toCharArray(), "mustaches".toCharArray(), "moustaches".toCharArray(), "quiches".toCharArray(), "headaches".toCharArray(), "heartaches".toCharArray(), "porsches".toCharArray(), "tranches".toCharArray(), "caches".toCharArray()};

        public int stem(char[] s, int len) {
            if (len < 3 || s[len - 1] != 's') {
                return len;
            }
            switch (s[len - 2]) {
                case 's': 
                case 'u': {
                    return len;
                }
                case 'e': {
                    if (len > 4 && s[len - 3] == 'i') {
                        s[len - 3] = 121;
                        return len - 2;
                    }
                    if (len <= 3) break;
                    if (len > 4 && s[len - 3] == 'x') {
                        return len - 2;
                    }
                    if (len > 3 && s[len - 3] == 'o') {
                        if (this.isException(s, len, oesExceptions)) {
                            return len - 1;
                        }
                        return len - 2;
                    }
                    if (len <= 4) break;
                    if (s[len - 4] == 's' && (s[len - 3] == 'h' || s[len - 3] == 's')) {
                        return len - 2;
                    }
                    if (len <= 4 || s[len - 4] != 'c' || s[len - 3] != 'h') break;
                    if (this.isException(s, len, chesExceptions)) {
                        return len - 1;
                    }
                    return len - 2;
                }
            }
            return len - 1;
        }

        private boolean isException(char[] s, int len, char[][] exceptionsList) {
            for (char[] oesRule : exceptionsList) {
                int rulePos = oesRule.length - 1;
                boolean matched = true;
                for (int sPos = len - 1; rulePos >= 0 && sPos >= 0; --rulePos, --sPos) {
                    if (oesRule[rulePos] == s[sPos]) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return true;
            }
            return false;
        }
    }
}

