/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.jcajce.interfaces.LMSPublicKey;

class ProvLMSPublicKey
implements LMSPublicKey {
    private static final long serialVersionUID = 1L;
    private transient AsymmetricLMSPublicKey baseKey;

    ProvLMSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.baseKey = new AsymmetricLMSPublicKey(subjectPublicKeyInfo);
    }

    ProvLMSPublicKey(AsymmetricLMSPublicKey asymmetricLMSPublicKey) {
        this.baseKey = asymmetricLMSPublicKey;
    }

    @Override
    public final String getAlgorithm() {
        return "LMS";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProvLMSPublicKey) {
            ProvLMSPublicKey provLMSPublicKey = (ProvLMSPublicKey)object;
            return this.baseKey.equals(provLMSPublicKey.baseKey);
        }
        return false;
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    @Override
    public int getLevels() {
        return this.baseKey.getL();
    }

    AsymmetricLMSPublicKey getBaseKey() {
        return this.baseKey;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricLMSPublicKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

