/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.ChaCha20;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ChaCha20SpecUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;

final class ProvChaCha20
extends AlgorithmProvider {
    private static final String PREFIX = ProvChaCha20.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            return new ChaCha20ParametersCreator((ChaCha20.Parameters)parameters);
        }
    };
    private ParametersCreatorProvider<Parameters> nonceParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            return new IvParametersCreator((ChaCha20.AuthParameters)parameters);
        }
    };

    ProvChaCha20() {
    }

    @Override
    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.CHACHA20", PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "ChaCha20", 256, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new ChaCha20.KeyGenerator(secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "CHACHA20", "CHACHA7539", "CHACHA20-POLY1305");
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "CHACHA20", PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.CHACHA20", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("ChaCha20");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "CHACHA20", "CHACHA7539");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.CHACHA20-POLY1305", PREFIX + "$AlgParamsCP", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("ChaCha20-Poly1305");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "CHACHA20-POLY1305", PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.CHACHA20", PREFIX + "$AlgParamGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "ChaCha20", 12);
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameterGenerator", "CHACHA20", "CHACHA7539");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CHACHA20", PREFIX + "$Base", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 96, ChaCha20.STREAM).withParameters(ChaCha20SpecUtil.getCipherSpecClasses()).withGeneralOperators(ProvChaCha20.this.generalParametersCreatorProvider, new ChaCha20.OperatorFactory(), null).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "CHACHA20", "CHACHA7539");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CHACHA20-POLY1305", PREFIX + "$ChaPolyBase", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 96, ChaCha20.WithPoly1305).withParameters(ChaCha20SpecUtil.getCipherSpecClasses()).withGeneralOperators(ProvChaCha20.this.nonceParametersCreatorProvider, null, new ChaCha20.AEADOperatorFactory()).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "CHACHA20-POLY1305", PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305);
    }

    class ChaCha20ParametersCreator<T extends ChaCha20.Parameters>
    implements ParametersCreator {
        private final ChaCha20.Parameters baseParameters;

        ChaCha20ParametersCreator(ChaCha20.Parameters parameters) {
            this.baseParameters = parameters;
        }

        public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                return this.baseParameters.withIV(((IvParameterSpec)algorithmParameterSpec).getIV()).withCounter(0);
            }
            if (ChaCha20SpecUtil.isChaCha20Spec(algorithmParameterSpec)) {
                try {
                    ASN1Sequence aSN1Sequence = ChaCha20SpecUtil.extractChaCha20Parameters(algorithmParameterSpec);
                    return this.baseParameters.withIV(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets()).withCounter(ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).intValueExact());
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException("Cannot process ChaCha20ParameterSpec: " + exception.getMessage(), exception);
                }
            }
            if (bl && ((GeneralAlgorithm)this.baseParameters.getAlgorithm()).requiresAlgorithmParameters()) {
                return this.baseParameters.withIV(secureRandom).withCounter(0);
            }
            return this.baseParameters;
        }
    }
}

