﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotwireless/IoTWirelessRequest.h>
#include <aws/iotwireless/IoTWireless_EXPORTS.h>
#include <aws/iotwireless/model/LoRaWANStartFuotaTask.h>

#include <utility>

namespace Aws {
namespace IoTWireless {
namespace Model {

/**
 */
class StartFuotaTaskRequest : public IoTWirelessRequest {
 public:
  AWS_IOTWIRELESS_API StartFuotaTaskRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "StartFuotaTask"; }

  AWS_IOTWIRELESS_API Aws::String SerializePayload() const override;

  ///@{

  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  StartFuotaTaskRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const LoRaWANStartFuotaTask& GetLoRaWAN() const { return m_loRaWAN; }
  inline bool LoRaWANHasBeenSet() const { return m_loRaWANHasBeenSet; }
  template <typename LoRaWANT = LoRaWANStartFuotaTask>
  void SetLoRaWAN(LoRaWANT&& value) {
    m_loRaWANHasBeenSet = true;
    m_loRaWAN = std::forward<LoRaWANT>(value);
  }
  template <typename LoRaWANT = LoRaWANStartFuotaTask>
  StartFuotaTaskRequest& WithLoRaWAN(LoRaWANT&& value) {
    SetLoRaWAN(std::forward<LoRaWANT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  LoRaWANStartFuotaTask m_loRaWAN;
  bool m_loRaWANHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTWireless
}  // namespace Aws
