/*
 * Copyright (C) 2010 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

const char *const ir_expression_operation_strings[] = {
   "~",
   "!",
   "neg",
   "abs",
   "sign",
   "rcp",
   "rsq",
   "sqrt",
   "exp",
   "log",
   "exp2",
   "log2",
   "f2i",
   "f2u",
   "i2f",
   "f2b",
   "b2f",
   "b2f16",
   "i2b",
   "b2i",
   "u2f",
   "i2u",
   "u2i",
   "d2f",
   "f2d",
   "f2f16",
   "f2fmp",
   "f162f",
   "u2f16",
   "f162u",
   "i2f16",
   "f162i",
   "d2f16",
   "f162d",
   "u642f16",
   "f162u64",
   "i642f16",
   "f162i64",
   "i2i",
   "i2imp",
   "u2u",
   "u2ump",
   "d2i",
   "i2d",
   "d2u",
   "u2d",
   "d2b",
   "f162b",
   "bitcast_i2f",
   "bitcast_f2i",
   "bitcast_u2f",
   "bitcast_f2u",
   "bitcast_u642d",
   "bitcast_i642d",
   "bitcast_d2u64",
   "bitcast_d2i64",
   "i642i",
   "u642i",
   "i642u",
   "u642u",
   "i642b",
   "i642f",
   "u642f",
   "i642d",
   "u642d",
   "i2i64",
   "u2i64",
   "b2i64",
   "f2i64",
   "d2i64",
   "i2u64",
   "u2u64",
   "f2u64",
   "d2u64",
   "u642i64",
   "i642u64",
   "trunc",
   "ceil",
   "floor",
   "fract",
   "round_even",
   "sin",
   "cos",
   "atan",
   "dFdx",
   "dFdxCoarse",
   "dFdxFine",
   "dFdy",
   "dFdyCoarse",
   "dFdyFine",
   "packSnorm2x16",
   "packSnorm4x8",
   "packUnorm2x16",
   "packUnorm4x8",
   "packHalf2x16",
   "unpackSnorm2x16",
   "unpackSnorm4x8",
   "unpackUnorm2x16",
   "unpackUnorm4x8",
   "unpackHalf2x16",
   "bitfield_reverse",
   "bit_count",
   "find_msb",
   "find_lsb",
   "clz",
   "sat",
   "packDouble2x32",
   "unpackDouble2x32",
   "packSampler2x32",
   "packImage2x32",
   "unpackSampler2x32",
   "unpackImage2x32",
   "frexp_sig",
   "frexp_exp",
   "subroutine_to_int",
   "interpolate_at_centroid",
   "get_buffer_size",
   "ssbo_unsized_array_length",
   "implicitly_sized_array_length",
   "packInt2x32",
   "packUint2x32",
   "unpackInt2x32",
   "unpackUint2x32",
   "+",
   "-",
   "add_sat",
   "sub_sat",
   "abs_sub",
   "average",
   "average_rounded",
   "*",
   "*",
   "imul_high",
   "/",
   "carry",
   "borrow",
   "%",
   "<",
   ">=",
   "==",
   "!=",
   "all_equal",
   "any_nequal",
   "<<",
   ">>",
   "&",
   "^",
   "|",
   "&&",
   "^^",
   "||",
   "dot",
   "min",
   "max",
   "pow",
   "ldexp",
   "vector_extract",
   "interpolate_at_offset",
   "interpolate_at_sample",
   "atan2",
   "fma",
   "lrp",
   "csel",
   "bitfield_extract",
   "vector_insert",
   "bitfield_insert",
   "vector",
};

const char *const ir_expression_operation_enum_strings[] = {
   "bit_not",
   "logic_not",
   "neg",
   "abs",
   "sign",
   "rcp",
   "rsq",
   "sqrt",
   "exp",
   "log",
   "exp2",
   "log2",
   "f2i",
   "f2u",
   "i2f",
   "f2b",
   "b2f",
   "b2f16",
   "i2b",
   "b2i",
   "u2f",
   "i2u",
   "u2i",
   "d2f",
   "f2d",
   "f2f16",
   "f2fmp",
   "f162f",
   "u2f16",
   "f162u",
   "i2f16",
   "f162i",
   "d2f16",
   "f162d",
   "u642f16",
   "f162u64",
   "i642f16",
   "f162i64",
   "i2i",
   "i2imp",
   "u2u",
   "u2ump",
   "d2i",
   "i2d",
   "d2u",
   "u2d",
   "d2b",
   "f162b",
   "bitcast_i2f",
   "bitcast_f2i",
   "bitcast_u2f",
   "bitcast_f2u",
   "bitcast_u642d",
   "bitcast_i642d",
   "bitcast_d2u64",
   "bitcast_d2i64",
   "i642i",
   "u642i",
   "i642u",
   "u642u",
   "i642b",
   "i642f",
   "u642f",
   "i642d",
   "u642d",
   "i2i64",
   "u2i64",
   "b2i64",
   "f2i64",
   "d2i64",
   "i2u64",
   "u2u64",
   "f2u64",
   "d2u64",
   "u642i64",
   "i642u64",
   "trunc",
   "ceil",
   "floor",
   "fract",
   "round_even",
   "sin",
   "cos",
   "atan",
   "dFdx",
   "dFdx_coarse",
   "dFdx_fine",
   "dFdy",
   "dFdy_coarse",
   "dFdy_fine",
   "pack_snorm_2x16",
   "pack_snorm_4x8",
   "pack_unorm_2x16",
   "pack_unorm_4x8",
   "pack_half_2x16",
   "unpack_snorm_2x16",
   "unpack_snorm_4x8",
   "unpack_unorm_2x16",
   "unpack_unorm_4x8",
   "unpack_half_2x16",
   "bitfield_reverse",
   "bit_count",
   "find_msb",
   "find_lsb",
   "clz",
   "saturate",
   "pack_double_2x32",
   "unpack_double_2x32",
   "pack_sampler_2x32",
   "pack_image_2x32",
   "unpack_sampler_2x32",
   "unpack_image_2x32",
   "frexp_sig",
   "frexp_exp",
   "subroutine_to_int",
   "interpolate_at_centroid",
   "get_buffer_size",
   "ssbo_unsized_array_length",
   "implicitly_sized_array_length",
   "pack_int_2x32",
   "pack_uint_2x32",
   "unpack_int_2x32",
   "unpack_uint_2x32",
   "add",
   "sub",
   "add_sat",
   "sub_sat",
   "abs_sub",
   "avg",
   "avg_round",
   "mul",
   "mul_32x16",
   "imul_high",
   "div",
   "carry",
   "borrow",
   "mod",
   "less",
   "gequal",
   "equal",
   "nequal",
   "all_equal",
   "any_nequal",
   "lshift",
   "rshift",
   "bit_and",
   "bit_xor",
   "bit_or",
   "logic_and",
   "logic_xor",
   "logic_or",
   "dot",
   "min",
   "max",
   "pow",
   "ldexp",
   "vector_extract",
   "interpolate_at_offset",
   "interpolate_at_sample",
   "atan2",
   "fma",
   "lrp",
   "csel",
   "bitfield_extract",
   "vector_insert",
   "bitfield_insert",
   "vector",
};
