/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class RemovePrefixQuickFix
extends PsiUpdateModCommandQuickFix {
    private final String myPrefix;

    public RemovePrefixQuickFix(String prefix) {
        this.myPrefix = prefix;
    }

    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.remove.string.prefix", this.myPrefix);
        if (string == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.remove.string.prefix", new Object[0]);
        if (string == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PyStringLiteralExpression pyString;
        if (project == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(4);
        }
        if ((pyString = PyUtil.as(element, PyStringLiteralExpression.class)) != null) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance((Project)project);
            for (ASTNode node : pyString.getStringNodes()) {
                int prefixLength;
                String nodeText = node.getText();
                if (!nodeText.substring(0, prefixLength = PyStringLiteralUtil.getPrefixLength((String)nodeText)).equalsIgnoreCase(this.myPrefix)) continue;
                PyStringLiteralExpression replacement = elementGenerator.createStringLiteralAlreadyEscaped(nodeText.substring(prefixLength));
                node.getPsi().replace(replacement.getFirstChild());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

