/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyMoveAttributeToInitQuickFix;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyAttributeOutsideInitInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static boolean expressionReferencesLocalName(@NotNull PyExpression assignedValue, @NotNull PyFunction function) {
        if (assignedValue == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(2);
        }
        if (function == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(3);
        }
        Collection references2 = PsiTreeUtil.collectElementsOfType((PsiElement)assignedValue, (Class[])new Class[]{PyReferenceExpression.class});
        for (PyReferenceExpression reference : references2) {
            Collection<PsiElement> resolved;
            if (reference.isQualified() || (resolved = PyResolveUtil.resolveLocally(reference)).isEmpty() || ContainerUtil.exists(resolved, it -> it instanceof PyParameter && ((PyParameter)it).isSelf()) || !ContainerUtil.exists(resolved, it -> function == ScopeUtil.getScopeOwner(it))) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefinedByProperty(@NotNull PyTargetExpression attribute, @NotNull Collection<Property> properties, @NotNull MultiMap<String, PyTargetExpression> attributesInInit) {
        if (attribute == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(5);
        }
        if (attributesInInit == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(6);
        }
        return ((StreamEx)StreamEx.of(properties).filter(it -> PyAttributeOutsideInitInspection.isSetBy(attribute, it))).anyMatch(it -> attributesInInit.containsKey((Object)it.getName()));
    }

    private static boolean isApplicable(@NotNull PyClass containingClass, @NotNull TypeEvalContext context) {
        if (containingClass == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(8);
        }
        return !PythonUnitTestDetectorsKt.isTestClass(containingClass, context) && !containingClass.isSubclass("django.db.models.base.Model", context);
    }

    @Nullable
    private static Collection<PyTargetExpression> getSetterTargetExpressions(@NotNull Property property) {
        if (property == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(9);
        }
        if (!property.getSetter().isDefined() || property.getSetter().value() == null) {
            return null;
        }
        PyFunction setter = ((PyCallable)property.getSetter().value()).asMethod();
        if (setter == null) {
            return null;
        }
        return ((StreamEx)StreamEx.of(ControlFlowCache.getScope((ScopeOwner)setter).getTargetExpressions()).filter(PyUtil::isInstanceAttribute)).toList();
    }

    private static boolean isSetBy(@NotNull PyTargetExpression attribute, @NotNull Property property) {
        Collection<PyTargetExpression> propertyTargetExpressions;
        if (attribute == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(10);
        }
        if (property == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(11);
        }
        return (propertyTargetExpressions = PyAttributeOutsideInitInspection.getSetterTargetExpressions(property)) != null && attribute.getName() != null && StreamEx.of(propertyTargetExpressions).map(targetExpression -> targetExpression.getName()).nonNull().anyMatch(name -> name.equals(attribute.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesInInit";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionReferencesLocalName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefinedByProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetterTargetExpressions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isSetBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            PyClass containingClass;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((containingClass = node.getContainingClass()) == null) {
                return;
            }
            String name = node.getName();
            if (name != null && name.startsWith("_")) {
                return;
            }
            if (!PyAttributeOutsideInitInspection.isApplicable(containingClass, this.myTypeEvalContext)) {
                return;
            }
            if (node.getModifier() != null) {
                return;
            }
            Map localProperties = containingClass.getProperties();
            MultiMap declaredAttributes = new MultiMap();
            HashSet inheritedProperties = new HashSet();
            ((StreamEx)StreamEx.of((Collection)containingClass.getClassAttributes()).filter(attribute -> !localProperties.containsKey(attribute.getName()))).forEach(attribute -> declaredAttributes.putValue((Object)attribute.getName(), attribute));
            PyFunction initMethod = containingClass.findMethodByName("__init__", false, this.myTypeEvalContext);
            if (initMethod != null) {
                PyClassImpl.collectInstanceAttributes(initMethod, (MultiMap<String, PyTargetExpression>)declaredAttributes);
            }
            for (PyClass superClass : containingClass.getAncestorClasses(this.myTypeEvalContext)) {
                PyFunction superInit = superClass.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (superInit != null) {
                    PyClassImpl.collectInstanceAttributes(superInit, (MultiMap<String, PyTargetExpression>)declaredAttributes);
                }
                for (PyTargetExpression classAttr : superClass.getClassAttributes()) {
                    declaredAttributes.putValue((Object)classAttr.getName(), (Object)classAttr);
                }
                inheritedProperties.addAll(superClass.getProperties().keySet());
            }
            MultiMap attributes = new MultiMap();
            PyClassImpl.collectInstanceAttributes(node, (MultiMap<String, PyTargetExpression>)attributes);
            for (PyTargetExpression attribute2 : attributes.values()) {
                PyExpression assignedValue;
                String attributeName = attribute2.getName();
                if (attributeName == null || declaredAttributes.containsKey((Object)attributeName) || inheritedProperties.contains(attributeName) || localProperties.containsKey(attributeName) || PyAttributeOutsideInitInspection.isDefinedByProperty(attribute2, localProperties.values(), (MultiMap<String, PyTargetExpression>)declaredAttributes) || (assignedValue = attribute2.findAssignedValue()) == null) continue;
                if (PyAttributeOutsideInitInspection.expressionReferencesLocalName(assignedValue, node)) {
                    this.registerProblem((PsiElement)attribute2, PyPsiBundle.message("INSP.attribute.outside.init", attributeName), new AddFieldQuickFix(attributeName, "None", containingClass.getName(), false));
                    continue;
                }
                this.registerProblem((PsiElement)attribute2, PyPsiBundle.message("INSP.attribute.outside.init", attributeName), new LocalQuickFix[]{new PyMoveAttributeToInitQuickFix(), new AddFieldQuickFix(attributeName, "None", containingClass.getName(), false)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

