/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.authtoken.jwt.claims;

import java.util.List;
import org.opensearch.security.authtoken.jwt.EncryptionDecryptionUtil;
import org.opensearch.security.authtoken.jwt.claims.JwtClaimsBuilder;

public class OBOJwtClaimsBuilder
extends JwtClaimsBuilder {
    private final EncryptionDecryptionUtil encryptionDecryptionUtil;

    public OBOJwtClaimsBuilder(String encryptionKey) {
        this.encryptionDecryptionUtil = new EncryptionDecryptionUtil(encryptionKey);
    }

    public OBOJwtClaimsBuilder addRoles(List<String> roles) {
        String listOfRoles = String.join((CharSequence)",", roles);
        this.addCustomClaim("er", this.encryptionDecryptionUtil.encrypt(listOfRoles));
        return this;
    }

    public OBOJwtClaimsBuilder addBackendRoles(Boolean includeBackendRoles, List<String> backendRoles) {
        if (includeBackendRoles.booleanValue() && backendRoles != null) {
            String listOfBackendRoles = String.join((CharSequence)",", backendRoles);
            this.addCustomClaim("br", listOfBackendRoles);
        }
        return this;
    }
}

