/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;
import org.apache.kafka.common.Uuid;

public abstract class ApplicationEvent {
    private final Type type;
    private final Uuid id;
    private long enqueuedMs;

    protected ApplicationEvent(Type type) {
        this.type = Objects.requireNonNull(type);
        this.id = Uuid.randomUuid();
    }

    public Type type() {
        return this.type;
    }

    public Uuid id() {
        return this.id;
    }

    public void setEnqueuedMs(long enqueuedMs) {
        this.enqueuedMs = enqueuedMs;
    }

    public long enqueuedMs() {
        return this.enqueuedMs;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationEvent that = (ApplicationEvent)o;
        return this.type == that.type && this.id.equals(that.id);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }

    protected String toStringBase() {
        return "type=" + String.valueOf((Object)this.type) + ", id=" + String.valueOf(this.id) + ", enqueuedMs=" + this.enqueuedMs;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + "}";
    }

    public static enum Type {
        COMMIT_ASYNC,
        COMMIT_SYNC,
        POLL,
        FETCH_COMMITTED_OFFSETS,
        NEW_TOPICS_METADATA_UPDATE,
        ASSIGNMENT_CHANGE,
        LIST_OFFSETS,
        CHECK_AND_UPDATE_POSITIONS,
        RESET_OFFSET,
        TOPIC_METADATA,
        ALL_TOPICS_METADATA,
        TOPIC_SUBSCRIPTION_CHANGE,
        TOPIC_PATTERN_SUBSCRIPTION_CHANGE,
        TOPIC_RE2J_PATTERN_SUBSCRIPTION_CHANGE,
        UPDATE_SUBSCRIPTION_METADATA,
        UNSUBSCRIBE,
        CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED,
        COMMIT_ON_CLOSE,
        CREATE_FETCH_REQUESTS,
        LEAVE_GROUP_ON_CLOSE,
        STOP_FIND_COORDINATOR_ON_CLOSE,
        PAUSE_PARTITIONS,
        RESUME_PARTITIONS,
        CURRENT_LAG,
        SHARE_FETCH,
        SHARE_ACKNOWLEDGE_ASYNC,
        SHARE_ACKNOWLEDGE_SYNC,
        SHARE_SUBSCRIPTION_CHANGE,
        SHARE_UNSUBSCRIBE,
        SHARE_ACKNOWLEDGE_ON_CLOSE,
        SHARE_ACKNOWLEDGEMENT_COMMIT_CALLBACK_REGISTRATION,
        SEEK_UNVALIDATED;

    }
}

