/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import org.jooq.tools.StringUtils;

public final class JSONFormat {
    public static final JSONFormat DEFAULT_FOR_RESULTS = new JSONFormat();
    public static final JSONFormat DEFAULT_FOR_RECORDS = new JSONFormat().header(false);
    final boolean format;
    final String newline;
    final int indent;
    final String[] indented;
    final boolean header;
    final RecordFormat recordFormat;

    public JSONFormat() {
        this(false, "\n", 2, null, true, RecordFormat.ARRAY);
    }

    private JSONFormat(boolean format, String newline, int indent, String[] indented, boolean header, RecordFormat recordFormat) {
        String[] stringArray;
        this.format = format;
        this.newline = newline;
        this.indent = indent;
        if (indented != null) {
            stringArray = indented;
        } else {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "";
            stringArray2[1] = format ? StringUtils.rightPad("", indent * 1) : "";
            stringArray2[2] = format ? StringUtils.rightPad("", indent * 2) : "";
            stringArray = stringArray2;
            stringArray2[3] = format ? StringUtils.rightPad("", indent * 3) : "";
        }
        this.indented = stringArray;
        this.header = header;
        this.recordFormat = recordFormat;
    }

    public JSONFormat format(boolean newFormat) {
        return new JSONFormat(newFormat, this.newline, this.indent, null, this.header, this.recordFormat);
    }

    public boolean format() {
        return this.format;
    }

    public JSONFormat newline(String newNewline) {
        return new JSONFormat(this.format, newNewline, this.indent, this.indented, this.header, this.recordFormat);
    }

    public String newline() {
        return this.format ? this.newline : "";
    }

    public JSONFormat indent(int newIndent) {
        return new JSONFormat(this.format, this.newline, newIndent, null, this.header, this.recordFormat);
    }

    public int indent() {
        return this.indent;
    }

    public String indentString(int level) {
        if (level < this.indented.length) {
            return this.indented[level];
        }
        if (this.format) {
            return StringUtils.rightPad("", this.indent * level);
        }
        return "";
    }

    public JSONFormat header(boolean newHeader) {
        return new JSONFormat(this.format, this.newline, this.indent, this.indented, newHeader, this.recordFormat);
    }

    public boolean header() {
        return this.header;
    }

    public JSONFormat recordFormat(RecordFormat newRecordFormat) {
        return new JSONFormat(this.format, this.newline, this.indent, this.indented, this.header, newRecordFormat);
    }

    public RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public static enum RecordFormat {
        ARRAY,
        OBJECT;

    }
}

