/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.IngestTotal;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Ingest
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Ingest> {
    @Nonnull
    private final Map<String, IngestTotal> pipelines;
    @Nullable
    private final IngestTotal total;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer);

    private Ingest(Builder builder) {
        this.pipelines = ApiTypeHelper.unmodifiable(builder.pipelines);
        this.total = builder.total;
    }

    public static Ingest of(Function<Builder, ObjectBuilder<Ingest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, IngestTotal> pipelines() {
        return this.pipelines;
    }

    @Nullable
    public final IngestTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.pipelines)) {
            generator.writeKey("pipelines");
            generator.writeStartObject();
            for (Map.Entry<String, IngestTotal> item0 : this.pipelines.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipelines, JsonpDeserializer.stringMapDeserializer(IngestTotal._DESERIALIZER), "pipelines");
        op.add(Builder::total, IngestTotal._DESERIALIZER, "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.pipelines);
        result = 31 * result + Objects.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ingest other = (Ingest)o;
        return Objects.equals(this.pipelines, other.pipelines) && Objects.equals(this.total, other.total);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Ingest> {
        @Nullable
        private Map<String, IngestTotal> pipelines;
        @Nullable
        private IngestTotal total;

        public Builder() {
        }

        private Builder(Ingest o) {
            this.pipelines = Builder._mapCopy(o.pipelines);
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.pipelines = Builder._mapCopy(o.pipelines);
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder pipelines(Map<String, IngestTotal> map) {
            this.pipelines = Builder._mapPutAll(this.pipelines, map);
            return this;
        }

        @Nonnull
        public final Builder pipelines(String key, IngestTotal value) {
            this.pipelines = Builder._mapPut(this.pipelines, key, value);
            return this;
        }

        @Nonnull
        public final Builder pipelines(String key, Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.pipelines(key, fn.apply(new IngestTotal.Builder()).build());
        }

        @Nonnull
        public final Builder total(@Nullable IngestTotal value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder total(Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.total(fn.apply(new IngestTotal.Builder()).build());
        }

        @Override
        @Nonnull
        public Ingest build() {
            this._checkSingleUse();
            return new Ingest(this);
        }
    }
}

