/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.indexInsight;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RegexpQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLConfig;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.indexInsight.IndexInsight;
import org.opensearch.ml.common.indexInsight.IndexInsightTask;
import org.opensearch.ml.common.indexInsight.IndexInsightTaskStatus;
import org.opensearch.ml.common.indexInsight.MLIndexInsightType;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.transport.config.MLConfigGetAction;
import org.opensearch.ml.common.transport.config.MLConfigGetRequest;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.repackage.com.google.common.hash.Hashing;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public abstract class AbstractIndexInsightTask
implements IndexInsightTask {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractIndexInsightTask.class);
    protected final MLIndexInsightType taskType;
    protected final String sourceIndex;
    protected final Client client;
    protected final SdkClient sdkClient;

    protected AbstractIndexInsightTask(MLIndexInsightType taskType, String sourceIndex, Client client, SdkClient sdkClient) {
        this.taskType = taskType;
        this.sourceIndex = sourceIndex;
        this.client = client;
        this.sdkClient = sdkClient;
    }

    @Override
    public void execute(String tenantId, ActionListener<IndexInsight> listener) {
        this.getIndexInsight(this.generateDocId(), tenantId, (ActionListener<GetResponse>)ActionListener.wrap(getResponse -> {
            if (getResponse.isExists()) {
                this.handleExistingDoc(getResponse.getSourceAsMap(), tenantId, listener);
            } else {
                SearchSourceBuilder patternSourceBuilder = AbstractIndexInsightTask.buildPatternSourceBuilder(this.taskType.name());
                this.sdkClient.searchDataObjectAsync(SearchDataObjectRequest.builder().tenantId(tenantId).indices(new String[]{".plugins-ml-index-insight-storage"}).searchSourceBuilder(patternSourceBuilder).build()).whenComplete((r, throwable) -> {
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        listener.onFailure(cause);
                    } else {
                        SearchResponse searchResponse = r.searchResponse();
                        SearchHit[] hits = searchResponse.getHits().getHits();
                        Map<String, Object> mappedPatternSource = AbstractIndexInsightTask.matchPattern(hits, this.sourceIndex);
                        if (Objects.isNull(mappedPatternSource)) {
                            this.beginGeneration(tenantId, listener);
                        } else {
                            this.handlePatternMatchedDoc(mappedPatternSource, tenantId, listener);
                        }
                    }
                });
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void handleExistingDoc(Map<String, Object> source, String tenantId, ActionListener<IndexInsight> listener) {
        String currentStatus = (String)source.get("status");
        Long lastUpdateTime = (Long)source.get("last_updated_time");
        long currentTime = Instant.now().toEpochMilli();
        IndexInsightTaskStatus status = IndexInsightTaskStatus.fromString(currentStatus);
        switch (status) {
            case GENERATING: {
                if (lastUpdateTime != null && currentTime - lastUpdateTime > 180000L) {
                    this.beginGeneration(tenantId, listener);
                    break;
                }
                listener.onFailure((Exception)new OpenSearchStatusException("Index insight is being generated, please wait...", RestStatus.TOO_MANY_REQUESTS, new Object[0]));
                break;
            }
            case COMPLETED: {
                if (lastUpdateTime != null && currentTime - lastUpdateTime > 86400000L) {
                    this.beginGeneration(tenantId, listener);
                    break;
                }
                IndexInsight insight = IndexInsight.builder().index((String)source.get("index_name")).taskType(MLIndexInsightType.valueOf((String)source.get("task_type"))).content((String)source.get("content")).status(IndexInsightTaskStatus.COMPLETED).lastUpdatedTime(Instant.ofEpochMilli(lastUpdateTime)).tenantId(tenantId).build();
                listener.onResponse((Object)insight);
                break;
            }
            case FAILED: {
                this.beginGeneration(tenantId, listener);
            }
        }
    }

    protected void handlePatternMatchedDoc(Map<String, Object> patternSource, String tenantId, ActionListener<IndexInsight> listener) {
        String currentStatus = (String)patternSource.get("status");
        IndexInsightTaskStatus status = IndexInsightTaskStatus.fromString(currentStatus);
        if (status != IndexInsightTaskStatus.COMPLETED) {
            this.beginGeneration(tenantId, listener);
            return;
        }
        Long lastUpdateTime = (Long)patternSource.get("last_updated_time");
        long currentTime = Instant.now().toEpochMilli();
        if (lastUpdateTime != null && currentTime - lastUpdateTime > 86400000L) {
            this.beginGeneration(tenantId, listener);
            return;
        }
        this.handlePatternResult(patternSource, tenantId, listener);
    }

    protected void beginGeneration(String tenantId, ActionListener<IndexInsight> listener) {
        IndexInsight indexInsight = IndexInsight.builder().index(this.sourceIndex).tenantId(tenantId).taskType(this.taskType).status(IndexInsightTaskStatus.GENERATING).lastUpdatedTime(Instant.now()).build();
        this.writeIndexInsight(indexInsight, tenantId, (ActionListener<Boolean>)ActionListener.wrap(r -> this.runWithPrerequisites(tenantId, listener), e -> this.saveFailedStatus(tenantId, (Exception)e, listener)));
    }

    protected void runWithPrerequisites(String tenantId, ActionListener<IndexInsight> listener) {
        List<MLIndexInsightType> prerequisites = this.getPrerequisites();
        AtomicInteger completedCount = new AtomicInteger(0);
        if (prerequisites.isEmpty()) {
            this.runTask(tenantId, listener);
            return;
        }
        for (MLIndexInsightType prerequisite : prerequisites) {
            IndexInsightTask prerequisiteTask = this.createPrerequisiteTask(prerequisite);
            prerequisiteTask.execute(tenantId, (ActionListener<IndexInsight>)ActionListener.wrap(prereqInsight -> {
                if (completedCount.incrementAndGet() == prerequisites.size()) {
                    this.runTask(tenantId, listener);
                }
            }, e -> this.saveFailedStatus(tenantId, new Exception("Failed to run prerequisite: " + String.valueOf((Object)prerequisite), (Throwable)e), listener)));
        }
    }

    protected void saveResult(String content, String tenantId, ActionListener<IndexInsight> listener) {
        IndexInsight insight = IndexInsight.builder().index(this.sourceIndex).taskType(this.taskType).content(content).status(IndexInsightTaskStatus.COMPLETED).lastUpdatedTime(Instant.now()).tenantId(tenantId).build();
        this.writeIndexInsight(insight, tenantId, (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse((Object)insight), e -> this.saveFailedStatus(tenantId, (Exception)e, listener)));
    }

    protected void saveFailedStatus(String tenantId, Exception error, ActionListener<IndexInsight> listener) {
        IndexInsight indexInsight = IndexInsight.builder().tenantId(tenantId).index(this.sourceIndex).taskType(this.taskType).status(IndexInsightTaskStatus.FAILED).build();
        this.writeIndexInsight(indexInsight, tenantId, (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onFailure(error), e -> listener.onFailure(e)));
    }

    protected String generateDocId() {
        return this.generateDocId(this.taskType);
    }

    protected String generateDocId(MLIndexInsightType taskType) {
        String combined = this.sourceIndex + "_" + taskType.toString();
        return Hashing.sha256().hashString(combined, StandardCharsets.UTF_8).toString();
    }

    protected void getInsightContentFromContainer(MLIndexInsightType taskType, String tenantId, ActionListener<Map<String, Object>> listener) {
        String docId = this.generateDocId(taskType);
        this.getIndexInsight(docId, tenantId, (ActionListener<GetResponse>)ActionListener.wrap(getResponse -> {
            try {
                String content = getResponse.isExists() ? getResponse.getSourceAsMap().get("content").toString() : "";
                Map contentMap = (Map)StringUtils.gson.fromJson(content, Map.class);
                listener.onResponse((Object)contentMap);
            }
            catch (Exception e) {
                listener.onResponse(new HashMap());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void handlePatternResult(Map<String, Object> patternSource, String tenantId, ActionListener<IndexInsight> listener) {
        Long lastUpdateTime = (Long)patternSource.get("last_updated_time");
        IndexInsight insight = IndexInsight.builder().index(this.sourceIndex).taskType(this.taskType).content((String)patternSource.get("content")).status(IndexInsightTaskStatus.COMPLETED).lastUpdatedTime(Instant.ofEpochMilli(lastUpdateTime)).tenantId(tenantId).build();
        listener.onResponse((Object)insight);
    }

    private void getIndexInsight(String docId, String tenantId, ActionListener<GetResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.getDataObjectAsync(((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().tenantId(tenantId)).index(".plugins-ml-index-insight-storage")).id(docId)).build()).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to get index insight document", (Throwable)cause);
                    listener.onFailure(cause);
                } else {
                    try {
                        GetResponse getResponse = r.getResponse();
                        assert (getResponse != null);
                        listener.onResponse((Object)getResponse);
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void writeIndexInsight(IndexInsight indexInsight, String tenantId, ActionListener<Boolean> listener) {
        String docId = this.generateDocId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().tenantId(tenantId)).index(".plugins-ml-index-insight-storage")).dataObject((ToXContentObject)indexInsight).id(docId)).build()).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to write index insight document", (Throwable)cause);
                    listener.onFailure(cause);
                } else {
                    try {
                        IndexResponse indexResponse = r.indexResponse();
                        assert (indexResponse != null);
                        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED || indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                            listener.onResponse((Object)true);
                        } else {
                            listener.onFailure((Exception)new RuntimeException("Failed to put generating index insight doc"));
                        }
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected static void getAgentIdToRun(Client client, String tenantId, ActionListener<String> actionListener) {
        MLConfigGetRequest mlConfigGetRequest = new MLConfigGetRequest("os_index_insight_agent", tenantId);
        client.execute((ActionType)MLConfigGetAction.INSTANCE, (ActionRequest)mlConfigGetRequest, ActionListener.wrap(r -> {
            MLConfig mlConfig = r.getMlConfig();
            actionListener.onResponse((Object)mlConfig.getConfiguration().getAgentId());
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    protected static void extractFieldNamesTypes(Map<String, Object> mappingSource, Map<String, String> fieldsToType, String prefix, boolean includeFields) {
        if (((String)prefix).length() > 0) {
            prefix = (String)prefix + ".";
        }
        for (Map.Entry<String, Object> entry : mappingSource.entrySet()) {
            String fieldType;
            String n = entry.getKey();
            Object v = entry.getValue();
            if (!(v instanceof Map)) continue;
            Map vMap = (Map)v;
            if (vMap.containsKey("type") && !(fieldType = vMap.getOrDefault("type", "")).equals("alias") && !fieldType.equals("object")) {
                fieldsToType.put((String)prefix + n, fieldType);
            }
            if (vMap.containsKey("properties")) {
                AbstractIndexInsightTask.extractFieldNamesTypes((Map)vMap.get("properties"), fieldsToType, (String)prefix + n, includeFields);
            }
            if (!includeFields || !vMap.containsKey("fields")) continue;
            AbstractIndexInsightTask.extractFieldNamesTypes((Map)vMap.get("fields"), fieldsToType, (String)prefix + n, true);
        }
    }

    private static SearchSourceBuilder buildPatternSourceBuilder(String taskType) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(100);
        RegexpQueryBuilder regexpQuery = QueryBuilders.regexpQuery((String)"index_name", (String)".*[*?,].*");
        TermQueryBuilder termQuery = QueryBuilders.termQuery((String)"task_type", (String)taskType);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)regexpQuery).filter((QueryBuilder)termQuery);
        sourceBuilder.query((QueryBuilder)boolQuery);
        return sourceBuilder;
    }

    private static String extractModelResponse(Map<String, Object> data) {
        if (data.containsKey("choices")) {
            return (String)JsonPath.read(data, (String)"$.choices[0].message.content", (Predicate[])new Predicate[0]);
        }
        if (data.containsKey("content")) {
            return (String)JsonPath.read(data, (String)"$.content[0].text", (Predicate[])new Predicate[0]);
        }
        return (String)JsonPath.read(data, (String)"$.response", (Predicate[])new Predicate[0]);
    }

    private static Map<String, Object> matchPattern(SearchHit[] hits, String targetIndex) {
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            String pattern = (String)source.get("index_name");
            if (!Regex.simpleMatch((String)pattern, (String)targetIndex)) continue;
            return source;
        }
        return null;
    }

    protected static void callLLMWithAgent(Client client, String agentId, String prompt, String sourceIndex, ActionListener<String> listener) {
        AgentMLInput agentInput = AgentMLInput.AgentMLInputBuilder().agentId(agentId).functionName(FunctionName.AGENT).inputDataset(RemoteInferenceInputDataSet.builder().parameters(Collections.singletonMap("prompt", prompt)).build()).build();
        MLExecuteTaskRequest executeRequest = new MLExecuteTaskRequest(FunctionName.AGENT, agentInput);
        client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)executeRequest, ActionListener.wrap(mlResp -> {
            try {
                String response;
                ModelTensorOutput out = (ModelTensorOutput)mlResp.getOutput();
                ModelTensors t = out.getMlModelOutputs().get(0);
                ModelTensor mt = t.getMlModelTensors().get(0);
                String result = mt.getResult();
                if (result.startsWith("{")) {
                    Map data = (Map)StringUtils.gson.fromJson(result, Map.class);
                    response = AbstractIndexInsightTask.extractModelResponse(data);
                } else {
                    response = result;
                }
                listener.onResponse((Object)response);
            }
            catch (Exception e) {
                log.error("Error parsing LLM response for index {}: {}", (Object)sourceIndex, (Object)e.getMessage());
                listener.onFailure(e);
            }
        }, e -> {
            log.error("Failed to call LLM for index {}: {}", (Object)sourceIndex, (Object)e.getMessage());
            listener.onFailure(e);
        }));
    }

    protected void handleError(String message, Exception e, String tenantId, ActionListener<IndexInsight> listener, boolean shouldStore) {
        log.error(message, (Object)this.sourceIndex, (Object)e);
        if (shouldStore) {
            this.saveFailedStatus(tenantId, e, listener);
        } else {
            listener.onFailure(e);
        }
    }

    protected void handleError(String message, Exception e, String tenantId, ActionListener<IndexInsight> listener) {
        this.handleError(message, e, tenantId, listener, true);
    }
}

