/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.search.SearchModule;
import org.opensearch.search.builder.SearchSourceBuilder;

@InputDataSet(value=MLInputDataType.SEARCH_QUERY)
public class SearchQueryInputDataset
extends MLInputDataset {
    private final SearchSourceBuilder searchSourceBuilder;
    private final List<String> indices;
    private static NamedXContentRegistry xContentRegistry;

    public SearchQueryInputDataset(@NonNull List<String> indices, @NonNull SearchSourceBuilder searchSourceBuilder) {
        super(MLInputDataType.SEARCH_QUERY);
        Objects.requireNonNull(indices, "indices is marked non-null but is null");
        Objects.requireNonNull(searchSourceBuilder, "searchSourceBuilder is marked non-null but is null");
        if (indices.isEmpty()) {
            throw new IllegalArgumentException("indices can't be empty");
        }
        this.indices = indices;
        this.searchSourceBuilder = searchSourceBuilder;
    }

    public SearchQueryInputDataset(StreamInput streaminput) throws IOException {
        super(MLInputDataType.SEARCH_QUERY);
        String searchString = streaminput.readString();
        XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchString);
        this.searchSourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
        this.indices = streaminput.readStringList();
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        streamOutput.writeString(this.searchSourceBuilder.toString());
        streamOutput.writeStringCollection(this.indices);
    }

    @Generated
    public static SearchQueryInputDatasetBuilder builder() {
        return new SearchQueryInputDatasetBuilder();
    }

    @Generated
    public SearchSourceBuilder getSearchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    @Generated
    public List<String> getIndices() {
        return this.indices;
    }

    static {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, Collections.emptyList());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }

    @Generated
    public static class SearchQueryInputDatasetBuilder {
        @Generated
        private List<String> indices;
        @Generated
        private SearchSourceBuilder searchSourceBuilder;

        @Generated
        SearchQueryInputDatasetBuilder() {
        }

        @Generated
        public SearchQueryInputDatasetBuilder indices(@NonNull List<String> indices) {
            Objects.requireNonNull(indices, "indices is marked non-null but is null");
            this.indices = indices;
            return this;
        }

        @Generated
        public SearchQueryInputDatasetBuilder searchSourceBuilder(@NonNull SearchSourceBuilder searchSourceBuilder) {
            Objects.requireNonNull(searchSourceBuilder, "searchSourceBuilder is marked non-null but is null");
            this.searchSourceBuilder = searchSourceBuilder;
            return this;
        }

        @Generated
        public SearchQueryInputDataset build() {
            return new SearchQueryInputDataset(this.indices, this.searchSourceBuilder);
        }

        @Generated
        public String toString() {
            return "SearchQueryInputDataset.SearchQueryInputDatasetBuilder(indices=" + String.valueOf(this.indices) + ", searchSourceBuilder=" + String.valueOf(this.searchSourceBuilder) + ")";
        }
    }
}

