/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

public class MultiModalConnectorPreProcessFunction
extends ConnectorPreProcessFunction {
    public MultiModalConnectorPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        this.validateTextDocsInput(mlInput);
        List<String> docs = ((TextDocsInputDataSet)mlInput.getInputDataset()).getDocs();
        if (docs.size() == 0 || docs.size() == 1 && docs.get(0) == null) {
            throw new IllegalArgumentException("No input text or image provided");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextDocsInputDataSet inputData = (TextDocsInputDataSet)mlInput.getInputDataset();
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        parametersMap.put("inputText", inputData.getDocs().get(0));
        if (inputData.getDocs().size() > 1) {
            parametersMap.put("inputImage", inputData.getDocs().get(1));
        }
        return RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(Map.of("parameters", parametersMap))).build();
    }
}

