/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.XyCartesianCoordinates;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class XyLocation
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<XyLocation> _DESERIALIZER = JsonpDeserializer.lazy(XyLocation::buildXyLocationDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private XyLocation(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private XyLocation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static XyLocation of(Function<Builder, ObjectBuilder<XyLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCartesian() {
        return this._kind == Kind.Cartesian;
    }

    public XyCartesianCoordinates cartesian() {
        return (XyCartesianCoordinates)TaggedUnionUtils.get(this, Kind.Cartesian);
    }

    public boolean isCoords() {
        return this._kind == Kind.Coords;
    }

    public List<Double> coords() {
        return (List)TaggedUnionUtils.get(this, Kind.Coords);
    }

    public boolean isText() {
        return this._kind == Kind.Text;
    }

    public String text() {
        return (String)TaggedUnionUtils.get(this, Kind.Text);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 1: {
                    generator.writeStartArray();
                    for (Double item0 : (List)this._value) {
                        generator.write(item0.doubleValue());
                    }
                    generator.writeEnd();
                    break;
                }
                case 2: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<XyLocation> buildXyLocationDeserializer() {
        return new UnionDeserializer.Builder<XyLocation, Kind, Object>(XyLocation::new, false).addMember(Kind.Cartesian, XyCartesianCoordinates._DESERIALIZER).addMember(Kind.Coords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer())).addMember(Kind.Text, JsonpDeserializer.stringDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XyLocation other = (XyLocation)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<XyLocation> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(XyLocation o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<XyLocation> cartesian(XyCartesianCoordinates v) {
            this._kind = Kind.Cartesian;
            this._value = v;
            return this;
        }

        public ObjectBuilder<XyLocation> cartesian(Function<XyCartesianCoordinates.Builder, ObjectBuilder<XyCartesianCoordinates>> fn) {
            return this.cartesian(fn.apply(new XyCartesianCoordinates.Builder()).build());
        }

        public ObjectBuilder<XyLocation> coords(List<Double> v) {
            this._kind = Kind.Coords;
            this._value = v;
            return this;
        }

        public ObjectBuilder<XyLocation> text(String v) {
            this._kind = Kind.Text;
            this._value = v;
            return this;
        }

        @Override
        public XyLocation build() {
            this._checkSingleUse();
            return new XyLocation(this);
        }
    }

    public static enum Kind {
        Cartesian,
        Coords,
        Text;

    }
}

