/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){function e(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var r,n={},i={};function a(){if(r)return i;r=1,Object.defineProperty(i,"__esModule",{value:!0}),i.setMatrixArrayType=function(t){i.ARRAY_TYPE=e=t;},i.toRadian=function(t){return t*a},i.equals=function(e,r){return Math.abs(e-r)<=t*Math.max(1,Math.abs(e),Math.abs(r))},i.RANDOM=i.ARRAY_TYPE=i.EPSILON=void 0;var t=1e-6;i.EPSILON=t;var e="undefined"!=typeof Float32Array?Float32Array:Array;i.ARRAY_TYPE=e;var n=Math.random;i.RANDOM=n;var a=Math.PI/180;return Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)}),i}var s,o={};function l(){if(s)return o;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}s=1,Object.defineProperty(o,"__esModule",{value:!0}),o.create=function(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},o.clone=function(t){var r=new e.ARRAY_TYPE(4);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r},o.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},o.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},o.fromValues=function(t,r,n,i){var a=new e.ARRAY_TYPE(4);return a[0]=t,a[1]=r,a[2]=n,a[3]=i,a},o.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},o.transpose=function(t,e){if(t===e){var r=e[1];t[1]=e[2],t[2]=r;}else t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3];return t},o.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r*a-i*n;return s?(t[0]=a*(s=1/s),t[1]=-n*s,t[2]=-i*s,t[3]=r*s,t):null},o.adjoint=function(t,e){var r=e[0];return t[0]=e[3],t[1]=-e[1],t[2]=-e[2],t[3]=r,t},o.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},o.multiply=n,o.rotate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=n*-o+a*l,t[3]=i*-o+s*l,t},o.scale=function(t,e,r){var n=e[1],i=e[2],a=e[3],s=r[0],o=r[1];return t[0]=e[0]*s,t[1]=n*s,t[2]=i*o,t[3]=a*o,t},o.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t},o.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t},o.str=function(t){return "mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},o.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},o.LDU=function(t,e,r,n){return t[2]=n[2]/n[0],r[0]=n[0],r[1]=n[1],r[3]=n[3]-t[2]*r[1],[t,e,r]},o.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},o.subtract=i,o.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},o.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=t[3],o=r[0],l=r[1],u=r[2],c=r[3];return Math.abs(n-o)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(a-u)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(u))&&Math.abs(s-c)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(c))},o.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},o.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},o.sub=o.mul=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*o+a*l,t[1]=i*o+s*l,t[2]=n*u+a*c,t[3]=i*u+s*c,t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}return o.mul=n,o.sub=i,o}var u,c={};function h(){if(u)return c;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}u=1,Object.defineProperty(c,"__esModule",{value:!0}),c.create=function(){var t=new e.ARRAY_TYPE(6);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},c.clone=function(t){var r=new e.ARRAY_TYPE(6);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r},c.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t},c.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},c.fromValues=function(t,r,n,i,a,s){var o=new e.ARRAY_TYPE(6);return o[0]=t,o[1]=r,o[2]=n,o[3]=i,o[4]=a,o[5]=s,o},c.set=function(t,e,r,n,i,a,s){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t},c.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=r*a-n*i;return l?(t[0]=a*(l=1/l),t[1]=-n*l,t[2]=-i*l,t[3]=r*l,t[4]=(i*o-a*s)*l,t[5]=(n*s-r*o)*l,t):null},c.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},c.multiply=n,c.rotate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+a*u,t[1]=i*c+s*u,t[2]=n*-u+a*c,t[3]=i*-u+s*c,t[4]=o,t[5]=l,t},c.scale=function(t,e,r){var n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=r[0],u=r[1];return t[0]=e[0]*l,t[1]=n*l,t[2]=i*u,t[3]=a*u,t[4]=s,t[5]=o,t},c.translate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=r[0],c=r[1];return t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=n*u+a*c+o,t[5]=i*u+s*c+l,t},c.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t[4]=0,t[5]=0,t},c.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t[4]=0,t[5]=0,t},c.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=e[0],t[5]=e[1],t},c.str=function(t){return "mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},c.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},c.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t},c.subtract=i,c.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t},c.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t},c.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]},c.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=t[3],o=t[4],l=t[5],u=r[0],c=r[1],h=r[2],p=r[3],f=r[4],d=r[5];return Math.abs(n-u)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(u))&&Math.abs(i-c)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(c))&&Math.abs(a-h)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(h))&&Math.abs(s-p)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(p))&&Math.abs(o-f)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(f))&&Math.abs(l-d)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(d))},c.sub=c.mul=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=r[0],c=r[1],h=r[2],p=r[3],f=r[4],d=r[5];return t[0]=n*u+a*c,t[1]=i*u+s*c,t[2]=n*h+a*p,t[3]=i*h+s*p,t[4]=n*f+a*d+o,t[5]=i*f+s*d+l,t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t}return c.mul=n,c.sub=i,c}var p,f={};function d(){if(p)return f;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}p=1,Object.defineProperty(f,"__esModule",{value:!0}),f.create=function(){var t=new e.ARRAY_TYPE(9);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},f.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},f.clone=function(t){var r=new e.ARRAY_TYPE(9);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r},f.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},f.fromValues=function(t,r,n,i,a,s,o,l,u){var c=new e.ARRAY_TYPE(9);return c[0]=t,c[1]=r,c[2]=n,c[3]=i,c[4]=a,c[5]=s,c[6]=o,c[7]=l,c[8]=u,c},f.set=function(t,e,r,n,i,a,s,o,l,u){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t[6]=o,t[7]=l,t[8]=u,t},f.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},f.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[5];t[1]=e[3],t[2]=e[6],t[3]=r,t[5]=e[7],t[6]=n,t[7]=i;}else t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8];return t},f.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=c*s-o*u,p=-c*a+o*l,f=u*a-s*l,d=r*h+n*p+i*f;return d?(t[0]=h*(d=1/d),t[1]=(-c*n+i*u)*d,t[2]=(o*n-i*s)*d,t[3]=p*d,t[4]=(c*r-i*l)*d,t[5]=(-o*r+i*a)*d,t[6]=f*d,t[7]=(-u*r+n*l)*d,t[8]=(s*r-n*a)*d,t):null},f.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8];return t[0]=s*c-o*u,t[1]=i*u-n*c,t[2]=n*o-i*s,t[3]=o*l-a*c,t[4]=r*c-i*l,t[5]=i*a-r*o,t[6]=a*u-s*l,t[7]=n*l-r*u,t[8]=r*s-n*a,t},f.determinant=function(t){var e=t[3],r=t[4],n=t[5],i=t[6],a=t[7],s=t[8];return t[0]*(s*r-n*a)+t[1]*(-s*e+n*i)+t[2]*(a*e-r*i)},f.multiply=n,f.translate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1];return t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=o,t[5]=l,t[6]=p*n+f*s+u,t[7]=p*i+f*o+c,t[8]=p*a+f*l+h,t},f.rotate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=Math.sin(r),f=Math.cos(r);return t[0]=f*n+p*s,t[1]=f*i+p*o,t[2]=f*a+p*l,t[3]=f*s-p*n,t[4]=f*o-p*i,t[5]=f*l-p*a,t[6]=u,t[7]=c,t[8]=h,t},f.scale=function(t,e,r){var n=r[0],i=r[1];return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=i*e[3],t[4]=i*e[4],t[5]=i*e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},f.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=e[0],t[7]=e[1],t[8]=1,t},f.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},f.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=e[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},f.fromMat2d=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=0,t[3]=e[2],t[4]=e[3],t[5]=0,t[6]=e[4],t[7]=e[5],t[8]=1,t},f.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r+r,o=n+n,l=i+i,u=r*s,c=n*s,h=n*o,p=i*s,f=i*o,d=i*l,m=a*s,y=a*o,g=a*l;return t[0]=1-h-d,t[3]=c-g,t[6]=p+y,t[1]=c+g,t[4]=1-u-d,t[7]=f-m,t[2]=p-y,t[5]=f+m,t[8]=1-u-h,t},f.normalFromMat4=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*s,v=r*l-i*s,b=r*u-a*s,_=n*l-i*o,w=n*u-a*o,M=i*u-a*l,A=c*m-h*d,S=c*y-p*d,I=c*g-f*d,P=h*y-p*m,z=h*g-f*m,E=p*g-f*y,k=x*E-v*z+b*P+_*I-w*S+M*A;return k?(t[0]=(o*E-l*z+u*P)*(k=1/k),t[1]=(l*I-s*E-u*S)*k,t[2]=(s*z-o*I+u*A)*k,t[3]=(i*z-n*E-a*P)*k,t[4]=(r*E-i*I+a*S)*k,t[5]=(n*I-r*z-a*A)*k,t[6]=(m*M-y*w+g*_)*k,t[7]=(y*b-d*M-g*v)*k,t[8]=(d*w-m*b+g*x)*k,t):null},f.projection=function(t,e,r){return t[0]=2/e,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/r,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},f.str=function(t){return "mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},f.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},f.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t},f.subtract=i,f.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t},f.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t},f.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},f.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=t[3],o=t[4],l=t[5],u=t[6],c=t[7],h=t[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return Math.abs(n-p)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(p))&&Math.abs(i-f)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(f))&&Math.abs(a-d)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(d))&&Math.abs(s-m)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(o-y)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(y))&&Math.abs(l-g)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(u-x)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(x))&&Math.abs(c-v)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(v))&&Math.abs(h-b)<=e.EPSILON*Math.max(1,Math.abs(h),Math.abs(b))},f.sub=f.mul=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+f*s+d*u,t[1]=p*i+f*o+d*c,t[2]=p*a+f*l+d*h,t[3]=m*n+y*s+g*u,t[4]=m*i+y*o+g*c,t[5]=m*a+y*l+g*h,t[6]=x*n+v*s+b*u,t[7]=x*i+v*o+b*c,t[8]=x*a+v*l+b*h,t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t}return f.mul=n,f.sub=i,f}var m,y={};function g(){if(m)return y;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}m=1,Object.defineProperty(y,"__esModule",{value:!0}),y.create=function(){var t=new e.ARRAY_TYPE(16);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},y.clone=function(t){var r=new e.ARRAY_TYPE(16);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r},y.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},y.fromValues=function(t,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y){var g=new e.ARRAY_TYPE(16);return g[0]=t,g[1]=r,g[2]=n,g[3]=i,g[4]=a,g[5]=s,g[6]=o,g[7]=l,g[8]=u,g[9]=c,g[10]=h,g[11]=p,g[12]=f,g[13]=d,g[14]=m,g[15]=y,g},y.set=function(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t[6]=o,t[7]=l,t[8]=u,t[9]=c,t[10]=h,t[11]=p,t[12]=f,t[13]=d,t[14]=m,t[15]=y,t},y.identity=n,y.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[3],a=e[6],s=e[7],o=e[11];t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=a,t[11]=e[14],t[12]=i,t[13]=s,t[14]=o;}else t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15];return t},y.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*s,v=r*l-i*s,b=r*u-a*s,_=n*l-i*o,w=n*u-a*o,M=i*u-a*l,A=c*m-h*d,S=c*y-p*d,I=c*g-f*d,P=h*y-p*m,z=h*g-f*m,E=p*g-f*y,k=x*E-v*z+b*P+_*I-w*S+M*A;return k?(t[0]=(o*E-l*z+u*P)*(k=1/k),t[1]=(i*z-n*E-a*P)*k,t[2]=(m*M-y*w+g*_)*k,t[3]=(p*w-h*M-f*_)*k,t[4]=(l*I-s*E-u*S)*k,t[5]=(r*E-i*I+a*S)*k,t[6]=(y*b-d*M-g*v)*k,t[7]=(c*M-p*b+f*v)*k,t[8]=(s*z-o*I+u*A)*k,t[9]=(n*I-r*z-a*A)*k,t[10]=(d*w-m*b+g*x)*k,t[11]=(h*b-c*w-f*x)*k,t[12]=(o*S-s*P-l*A)*k,t[13]=(r*P-n*S+i*A)*k,t[14]=(m*v-d*_-y*x)*k,t[15]=(c*_-h*v+p*x)*k,t):null},y.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15];return t[0]=o*(p*g-f*y)-h*(l*g-u*y)+m*(l*f-u*p),t[1]=-(n*(p*g-f*y)-h*(i*g-a*y)+m*(i*f-a*p)),t[2]=n*(l*g-u*y)-o*(i*g-a*y)+m*(i*u-a*l),t[3]=-(n*(l*f-u*p)-o*(i*f-a*p)+h*(i*u-a*l)),t[4]=-(s*(p*g-f*y)-c*(l*g-u*y)+d*(l*f-u*p)),t[5]=r*(p*g-f*y)-c*(i*g-a*y)+d*(i*f-a*p),t[6]=-(r*(l*g-u*y)-s*(i*g-a*y)+d*(i*u-a*l)),t[7]=r*(l*f-u*p)-s*(i*f-a*p)+c*(i*u-a*l),t[8]=s*(h*g-f*m)-c*(o*g-u*m)+d*(o*f-u*h),t[9]=-(r*(h*g-f*m)-c*(n*g-a*m)+d*(n*f-a*h)),t[10]=r*(o*g-u*m)-s*(n*g-a*m)+d*(n*u-a*o),t[11]=-(r*(o*f-u*h)-s*(n*f-a*h)+c*(n*u-a*o)),t[12]=-(s*(h*y-p*m)-c*(o*y-l*m)+d*(o*p-l*h)),t[13]=r*(h*y-p*m)-c*(n*y-i*m)+d*(n*p-i*h),t[14]=-(r*(o*y-l*m)-s*(n*y-i*m)+d*(n*l-i*o)),t[15]=r*(o*p-l*h)-s*(n*p-i*h)+c*(n*l-i*o),t},y.determinant=function(t){var e=t[0],r=t[1],n=t[2],i=t[3],a=t[4],s=t[5],o=t[6],l=t[7],u=t[8],c=t[9],h=t[10],p=t[11],f=t[12],d=t[13],m=t[14],y=t[15];return (e*s-r*a)*(h*y-p*m)-(e*o-n*a)*(c*y-p*d)+(e*l-i*a)*(c*m-h*d)+(r*o-n*s)*(u*y-p*f)-(r*l-i*s)*(u*m-h*f)+(n*l-i*o)*(u*d-c*f)},y.multiply=i,y.translate=function(t,e,r){var n,i,a,s,o,l,u,c,h,p,f,d,m=r[0],y=r[1],g=r[2];return e===t?(t[12]=e[0]*m+e[4]*y+e[8]*g+e[12],t[13]=e[1]*m+e[5]*y+e[9]*g+e[13],t[14]=e[2]*m+e[6]*y+e[10]*g+e[14],t[15]=e[3]*m+e[7]*y+e[11]*g+e[15]):(i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=a,t[3]=s,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*m+o*y+h*g+e[12],t[13]=i*m+l*y+p*g+e[13],t[14]=a*m+u*y+f*g+e[14],t[15]=s*m+c*y+d*g+e[15]),t},y.scale=function(t,e,r){var n=r[0],i=r[1],a=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*a,t[9]=e[9]*a,t[10]=e[10]*a,t[11]=e[11]*a,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},y.rotate=function(t,r,n,i){var a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,P,z,E=i[0],k=i[1],T=i[2],B=Math.hypot(E,k,T);return B<e.EPSILON?null:(E*=B=1/B,k*=B,T*=B,a=Math.sin(n),s=Math.cos(n),u=r[1],c=r[2],h=r[3],f=r[5],d=r[6],m=r[7],g=r[9],x=r[10],v=r[11],b=E*E*(o=1-s)+s,M=E*k*o-T*a,A=k*k*o+s,S=T*k*o+E*a,I=E*T*o+k*a,P=k*T*o-E*a,z=T*T*o+s,t[0]=(l=r[0])*b+(p=r[4])*(_=k*E*o+T*a)+(y=r[8])*(w=T*E*o-k*a),t[1]=u*b+f*_+g*w,t[2]=c*b+d*_+x*w,t[3]=h*b+m*_+v*w,t[4]=l*M+p*A+y*S,t[5]=u*M+f*A+g*S,t[6]=c*M+d*A+x*S,t[7]=h*M+m*A+v*S,t[8]=l*I+p*P+y*z,t[9]=u*I+f*P+g*z,t[10]=c*I+d*P+x*z,t[11]=h*I+m*P+v*z,r!==t&&(t[12]=r[12],t[13]=r[13],t[14]=r[14],t[15]=r[15]),t)},y.rotateX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[4],s=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=a*i+u*n,t[5]=s*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-a*n,t[9]=c*i-s*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},y.rotateY=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[0],s=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=a*i-u*n,t[1]=s*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=a*n+u*i,t[9]=s*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},y.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[0],s=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=a*i+u*n,t[1]=s*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-a*n,t[5]=c*i-s*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},y.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=e[0],t[13]=e[1],t[14]=e[2],t[15]=1,t},y.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromRotation=function(t,r,n){var i,a,s,o=n[0],l=n[1],u=n[2],c=Math.hypot(o,l,u);return c<e.EPSILON?null:(o*=c=1/c,l*=c,u*=c,i=Math.sin(r),a=Math.cos(r),t[0]=o*o*(s=1-a)+a,t[1]=l*o*s+u*i,t[2]=u*o*s-l*i,t[3]=0,t[4]=o*l*s-u*i,t[5]=l*l*s+a,t[6]=u*l*s+o*i,t[7]=0,t[8]=o*u*s+l*i,t[9]=l*u*s-o*i,t[10]=u*u*s+a,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},y.fromXRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=n,t[6]=r,t[7]=0,t[8]=0,t[9]=-r,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromYRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=0,t[2]=-r,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=r,t[9]=0,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromZRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=0,t[4]=-r,t[5]=n,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromRotationTranslation=s,y.fromQuat2=function(t,r){var n=new e.ARRAY_TYPE(3),i=-r[0],a=-r[1],o=-r[2],l=r[3],u=r[4],c=r[5],h=r[6],p=r[7],f=i*i+a*a+o*o+l*l;return f>0?(n[0]=2*(u*l+p*i+c*o-h*a)/f,n[1]=2*(c*l+p*a+h*i-u*o)/f,n[2]=2*(h*l+p*o+u*a-c*i)/f):(n[0]=2*(u*l+p*i+c*o-h*a),n[1]=2*(c*l+p*a+h*i-u*o),n[2]=2*(h*l+p*o+u*a-c*i)),s(t,r,n),t},y.getTranslation=function(t,e){return t[0]=e[12],t[1]=e[13],t[2]=e[14],t},y.getScaling=o,y.getRotation=function(t,r){var n=new e.ARRAY_TYPE(3);o(n,r);var i=1/n[0],a=1/n[1],s=1/n[2],l=r[0]*i,u=r[1]*a,c=r[2]*s,h=r[4]*i,p=r[5]*a,f=r[6]*s,d=r[8]*i,m=r[9]*a,y=r[10]*s,g=l+p+y,x=0;return g>0?(x=2*Math.sqrt(g+1),t[3]=.25*x,t[0]=(f-m)/x,t[1]=(d-c)/x,t[2]=(u-h)/x):l>p&&l>y?(x=2*Math.sqrt(1+l-p-y),t[3]=(f-m)/x,t[0]=.25*x,t[1]=(u+h)/x,t[2]=(d+c)/x):p>y?(x=2*Math.sqrt(1+p-l-y),t[3]=(d-c)/x,t[0]=(u+h)/x,t[1]=.25*x,t[2]=(f+m)/x):(x=2*Math.sqrt(1+y-l-p),t[3]=(u-h)/x,t[0]=(d+c)/x,t[1]=(f+m)/x,t[2]=.25*x),t},y.fromRotationTranslationScale=function(t,e,r,n){var i=e[0],a=e[1],s=e[2],o=e[3],l=i+i,u=a+a,c=s+s,h=i*l,p=i*u,f=i*c,d=a*u,m=a*c,y=s*c,g=o*l,x=o*u,v=o*c,b=n[0],_=n[1],w=n[2];return t[0]=(1-(d+y))*b,t[1]=(p+v)*b,t[2]=(f-x)*b,t[3]=0,t[4]=(p-v)*_,t[5]=(1-(h+y))*_,t[6]=(m+g)*_,t[7]=0,t[8]=(f+x)*w,t[9]=(m-g)*w,t[10]=(1-(h+d))*w,t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t},y.fromRotationTranslationScaleOrigin=function(t,e,r,n,i){var a=e[0],s=e[1],o=e[2],l=e[3],u=a+a,c=s+s,h=o+o,p=a*u,f=a*c,d=a*h,m=s*c,y=s*h,g=o*h,x=l*u,v=l*c,b=l*h,_=n[0],w=n[1],M=n[2],A=i[0],S=i[1],I=i[2],P=(1-(m+g))*_,z=(f+b)*_,E=(d-v)*_,k=(f-b)*w,T=(1-(p+g))*w,B=(y+x)*w,C=(d+v)*M,V=(y-x)*M,D=(1-(p+m))*M;return t[0]=P,t[1]=z,t[2]=E,t[3]=0,t[4]=k,t[5]=T,t[6]=B,t[7]=0,t[8]=C,t[9]=V,t[10]=D,t[11]=0,t[12]=r[0]+A-(P*A+k*S+C*I),t[13]=r[1]+S-(z*A+T*S+V*I),t[14]=r[2]+I-(E*A+B*S+D*I),t[15]=1,t},y.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r+r,o=n+n,l=i+i,u=r*s,c=n*s,h=n*o,p=i*s,f=i*o,d=i*l,m=a*s,y=a*o,g=a*l;return t[0]=1-h-d,t[1]=c+g,t[2]=p-y,t[3]=0,t[4]=c-g,t[5]=1-u-d,t[6]=f+m,t[7]=0,t[8]=p+y,t[9]=f-m,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.frustum=function(t,e,r,n,i,a,s){var o=1/(r-e),l=1/(i-n),u=1/(a-s);return t[0]=2*a*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*a*l,t[6]=0,t[7]=0,t[8]=(r+e)*o,t[9]=(i+n)*l,t[10]=(s+a)*u,t[11]=-1,t[12]=0,t[13]=0,t[14]=s*a*2*u,t[15]=0,t},y.perspectiveNO=l,y.perspectiveZO=function(t,e,r,n,i){var a,s=1/Math.tan(e/2);return t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=i*(a=1/(n-i)),t[14]=i*n*a):(t[10]=-1,t[14]=-n),t},y.perspectiveFromFieldOfView=function(t,e,r,n){var i=Math.tan(e.upDegrees*Math.PI/180),a=Math.tan(e.downDegrees*Math.PI/180),s=Math.tan(e.leftDegrees*Math.PI/180),o=Math.tan(e.rightDegrees*Math.PI/180),l=2/(s+o),u=2/(i+a);return t[0]=l,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=-(s-o)*l*.5,t[9]=(i-a)*u*.5,t[10]=n/(r-n),t[11]=-1,t[12]=0,t[13]=0,t[14]=n*r/(r-n),t[15]=0,t},y.orthoNO=u,y.orthoZO=function(t,e,r,n,i,a,s){var o=1/(e-r),l=1/(n-i),u=1/(a-s);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=a*u,t[15]=1,t},y.lookAt=function(t,r,i,a){var s,o,l,u,c,h,p,f,d,m,y=r[0],g=r[1],x=r[2],v=a[0],b=a[1],_=a[2],w=i[0],M=i[1],A=i[2];return Math.abs(y-w)<e.EPSILON&&Math.abs(g-M)<e.EPSILON&&Math.abs(x-A)<e.EPSILON?n(t):(p=y-w,f=g-M,d=x-A,s=b*(d*=m=1/Math.hypot(p,f,d))-_*(f*=m),o=_*(p*=m)-v*d,l=v*f-b*p,(m=Math.hypot(s,o,l))?(s*=m=1/m,o*=m,l*=m):(s=0,o=0,l=0),u=f*l-d*o,c=d*s-p*l,h=p*o-f*s,(m=Math.hypot(u,c,h))?(u*=m=1/m,c*=m,h*=m):(u=0,c=0,h=0),t[0]=s,t[1]=u,t[2]=p,t[3]=0,t[4]=o,t[5]=c,t[6]=f,t[7]=0,t[8]=l,t[9]=h,t[10]=d,t[11]=0,t[12]=-(s*y+o*g+l*x),t[13]=-(u*y+c*g+h*x),t[14]=-(p*y+f*g+d*x),t[15]=1,t)},y.targetTo=function(t,e,r,n){var i=e[0],a=e[1],s=e[2],o=n[0],l=n[1],u=n[2],c=i-r[0],h=a-r[1],p=s-r[2],f=c*c+h*h+p*p;f>0&&(c*=f=1/Math.sqrt(f),h*=f,p*=f);var d=l*p-u*h,m=u*c-o*p,y=o*h-l*c;return (f=d*d+m*m+y*y)>0&&(d*=f=1/Math.sqrt(f),m*=f,y*=f),t[0]=d,t[1]=m,t[2]=y,t[3]=0,t[4]=h*y-p*m,t[5]=p*d-c*y,t[6]=c*m-h*d,t[7]=0,t[8]=c,t[9]=h,t[10]=p,t[11]=0,t[12]=i,t[13]=a,t[14]=s,t[15]=1,t},y.str=function(t){return "mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},y.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},y.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},y.subtract=c,y.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},y.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t[9]=e[9]+r[9]*n,t[10]=e[10]+r[10]*n,t[11]=e[11]+r[11]*n,t[12]=e[12]+r[12]*n,t[13]=e[13]+r[13]*n,t[14]=e[14]+r[14]*n,t[15]=e[15]+r[15]*n,t},y.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},y.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=t[3],o=t[4],l=t[5],u=t[6],c=t[7],h=t[8],p=t[9],f=t[10],d=t[11],m=t[12],y=t[13],g=t[14],x=t[15],v=r[0],b=r[1],_=r[2],w=r[3],M=r[4],A=r[5],S=r[6],I=r[7],P=r[8],z=r[9],E=r[10],k=r[11],T=r[12],B=r[13],C=r[14],V=r[15];return Math.abs(n-v)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(i-b)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(a-_)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(_))&&Math.abs(s-w)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))&&Math.abs(l-A)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(A))&&Math.abs(u-S)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(S))&&Math.abs(c-I)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-P)<=e.EPSILON*Math.max(1,Math.abs(h),Math.abs(P))&&Math.abs(p-z)<=e.EPSILON*Math.max(1,Math.abs(p),Math.abs(z))&&Math.abs(f-E)<=e.EPSILON*Math.max(1,Math.abs(f),Math.abs(E))&&Math.abs(d-k)<=e.EPSILON*Math.max(1,Math.abs(d),Math.abs(k))&&Math.abs(m-T)<=e.EPSILON*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(y-B)<=e.EPSILON*Math.max(1,Math.abs(y),Math.abs(B))&&Math.abs(g-C)<=e.EPSILON*Math.max(1,Math.abs(g),Math.abs(C))&&Math.abs(x-V)<=e.EPSILON*Math.max(1,Math.abs(x),Math.abs(V))},y.sub=y.mul=y.ortho=y.perspective=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function i(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],m=e[12],y=e[13],g=e[14],x=e[15],v=r[0],b=r[1],_=r[2],w=r[3];return t[0]=v*n+b*o+_*h+w*m,t[1]=v*i+b*l+_*p+w*y,t[2]=v*a+b*u+_*f+w*g,t[3]=v*s+b*c+_*d+w*x,t[4]=(v=r[4])*n+(b=r[5])*o+(_=r[6])*h+(w=r[7])*m,t[5]=v*i+b*l+_*p+w*y,t[6]=v*a+b*u+_*f+w*g,t[7]=v*s+b*c+_*d+w*x,t[8]=(v=r[8])*n+(b=r[9])*o+(_=r[10])*h+(w=r[11])*m,t[9]=v*i+b*l+_*p+w*y,t[10]=v*a+b*u+_*f+w*g,t[11]=v*s+b*c+_*d+w*x,t[12]=(v=r[12])*n+(b=r[13])*o+(_=r[14])*h+(w=r[15])*m,t[13]=v*i+b*l+_*p+w*y,t[14]=v*a+b*u+_*f+w*g,t[15]=v*s+b*c+_*d+w*x,t}function s(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=n+n,l=i+i,u=a+a,c=n*o,h=n*l,p=n*u,f=i*l,d=i*u,m=a*u,y=s*o,g=s*l,x=s*u;return t[0]=1-(f+m),t[1]=h+x,t[2]=p-g,t[3]=0,t[4]=h-x,t[5]=1-(c+m),t[6]=d+y,t[7]=0,t[8]=p+g,t[9]=d-y,t[10]=1-(c+f),t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t}function o(t,e){var r=e[4],n=e[5],i=e[6],a=e[8],s=e[9],o=e[10];return t[0]=Math.hypot(e[0],e[1],e[2]),t[1]=Math.hypot(r,n,i),t[2]=Math.hypot(a,s,o),t}function l(t,e,r,n,i){var a,s=1/Math.tan(e/2);return t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(a=1/(n-i)),t[14]=2*i*n*a):(t[10]=-1,t[14]=-2*n),t}function u(t,e,r,n,i,a,s){var o=1/(e-r),l=1/(n-i),u=1/(a-s);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(s+a)*u,t[15]=1,t}function c(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t}return y.perspective=l,y.ortho=u,y.mul=i,y.sub=c,y}var x,v={},b={};function _(){if(x)return b;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}x=1,Object.defineProperty(b,"__esModule",{value:!0}),b.create=n,b.clone=function(t){var r=new e.ARRAY_TYPE(3);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r},b.length=i,b.fromValues=function(t,r,n){var i=new e.ARRAY_TYPE(3);return i[0]=t,i[1]=r,i[2]=n,i},b.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},b.set=function(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t},b.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},b.subtract=s,b.multiply=o,b.divide=l,b.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t},b.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t},b.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t},b.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t},b.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t},b.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t},b.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t},b.distance=u,b.squaredDistance=c,b.squaredLength=h,b.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t},b.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t},b.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],a=r*r+n*n+i*i;return a>0&&(a=1/Math.sqrt(a)),t[0]=e[0]*a,t[1]=e[1]*a,t[2]=e[2]*a,t},b.dot=p,b.cross=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[0],o=r[1],l=r[2];return t[0]=i*l-a*o,t[1]=a*s-n*l,t[2]=n*o-i*s,t},b.lerp=function(t,e,r,n){var i=e[0],a=e[1],s=e[2];return t[0]=i+n*(r[0]-i),t[1]=a+n*(r[1]-a),t[2]=s+n*(r[2]-s),t},b.hermite=function(t,e,r,n,i,a){var s=a*a,o=s*(2*a-3)+1,l=s*(a-2)+a,u=s*(a-1),c=s*(3-2*a);return t[0]=e[0]*o+r[0]*l+n[0]*u+i[0]*c,t[1]=e[1]*o+r[1]*l+n[1]*u+i[1]*c,t[2]=e[2]*o+r[2]*l+n[2]*u+i[2]*c,t},b.bezier=function(t,e,r,n,i,a){var s=1-a,o=s*s,l=a*a,u=o*s,c=3*a*o,h=3*l*s,p=l*a;return t[0]=e[0]*u+r[0]*c+n[0]*h+i[0]*p,t[1]=e[1]*u+r[1]*c+n[1]*h+i[1]*p,t[2]=e[2]*u+r[2]*c+n[2]*h+i[2]*p,t},b.random=function(t,r){r=r||1;var n=2*e.RANDOM()*Math.PI,i=2*e.RANDOM()-1,a=Math.sqrt(1-i*i)*r;return t[0]=Math.cos(n)*a,t[1]=Math.sin(n)*a,t[2]=i*r,t},b.transformMat4=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[3]*n+r[7]*i+r[11]*a+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*a+r[12])/(s=s||1),t[1]=(r[1]*n+r[5]*i+r[9]*a+r[13])/s,t[2]=(r[2]*n+r[6]*i+r[10]*a+r[14])/s,t},b.transformMat3=function(t,e,r){var n=e[0],i=e[1],a=e[2];return t[0]=n*r[0]+i*r[3]+a*r[6],t[1]=n*r[1]+i*r[4]+a*r[7],t[2]=n*r[2]+i*r[5]+a*r[8],t},b.transformQuat=function(t,e,r){var n=r[0],i=r[1],a=r[2],s=e[0],o=e[1],l=e[2],u=i*l-a*o,c=a*s-n*l,h=n*o-i*s,p=i*h-a*c,f=a*u-n*h,d=n*c-i*u,m=2*r[3];return c*=m,h*=m,f*=2,d*=2,t[0]=s+(u*=m)+(p*=2),t[1]=o+c+f,t[2]=l+h+d,t},b.rotateX=function(t,e,r,n){var i=[],a=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],a[0]=i[0],a[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),a[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=a[0]+r[0],t[1]=a[1]+r[1],t[2]=a[2]+r[2],t},b.rotateY=function(t,e,r,n){var i=[],a=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],a[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),a[1]=i[1],a[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=a[0]+r[0],t[1]=a[1]+r[1],t[2]=a[2]+r[2],t},b.rotateZ=function(t,e,r,n){var i=[],a=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],a[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),a[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),a[2]=i[2],t[0]=a[0]+r[0],t[1]=a[1]+r[1],t[2]=a[2]+r[2],t},b.angle=function(t,e){var r=t[0],n=t[1],i=t[2],a=e[0],s=e[1],o=e[2],l=Math.sqrt(r*r+n*n+i*i)*Math.sqrt(a*a+s*s+o*o),u=l&&p(t,e)/l;return Math.acos(Math.min(Math.max(u,-1),1))},b.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},b.str=function(t){return "vec3("+t[0]+", "+t[1]+", "+t[2]+")"},b.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},b.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=r[0],o=r[1],l=r[2];return Math.abs(n-s)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(s))&&Math.abs(i-o)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(o))&&Math.abs(a-l)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(l))},b.forEach=b.sqrLen=b.len=b.sqrDist=b.dist=b.div=b.mul=b.sub=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(){var t=new e.ARRAY_TYPE(3);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function i(t){return Math.hypot(t[0],t[1],t[2])}function s(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function o(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function l(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t}function u(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2])}function c(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return r*r+n*n+i*i}function h(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n}function p(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}b.sub=s,b.mul=o,b.div=l,b.dist=u,b.sqrDist=c,b.len=i,b.sqrLen=h;var f,d=(f=n(),function(t,e,r,n,i,a){var s,o;for(e||(e=3),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,s=r;s<o;s+=e)f[0]=t[s],f[1]=t[s+1],f[2]=t[s+2],i(f,f,a),t[s]=f[0],t[s+1]=f[1],t[s+2]=f[2];return t});return b.forEach=d,b}var w,M,A={};function S(){if(w)return A;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}w=1,Object.defineProperty(A,"__esModule",{value:!0}),A.create=n,A.clone=function(t){var r=new e.ARRAY_TYPE(4);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r},A.fromValues=function(t,r,n,i){var a=new e.ARRAY_TYPE(4);return a[0]=t,a[1]=r,a[2]=n,a[3]=i,a},A.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},A.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},A.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},A.subtract=i,A.multiply=s,A.divide=o,A.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t[3]=Math.ceil(e[3]),t},A.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t[3]=Math.floor(e[3]),t},A.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t[3]=Math.min(e[3],r[3]),t},A.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t[3]=Math.max(e[3],r[3]),t},A.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t[3]=Math.round(e[3]),t},A.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},A.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},A.distance=l,A.squaredDistance=u,A.length=c,A.squaredLength=h,A.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},A.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t[3]=1/e[3],t},A.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r*r+n*n+i*i+a*a;return s>0&&(s=1/Math.sqrt(s)),t[0]=r*s,t[1]=n*s,t[2]=i*s,t[3]=a*s,t},A.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},A.cross=function(t,e,r,n){var i=r[0]*n[1]-r[1]*n[0],a=r[0]*n[2]-r[2]*n[0],s=r[0]*n[3]-r[3]*n[0],o=r[1]*n[2]-r[2]*n[1],l=r[1]*n[3]-r[3]*n[1],u=r[2]*n[3]-r[3]*n[2],c=e[0],h=e[1],p=e[2],f=e[3];return t[0]=h*u-p*l+f*o,t[1]=-c*u+p*s-f*a,t[2]=c*l-h*s+f*i,t[3]=-c*o+h*a-p*i,t},A.lerp=function(t,e,r,n){var i=e[0],a=e[1],s=e[2],o=e[3];return t[0]=i+n*(r[0]-i),t[1]=a+n*(r[1]-a),t[2]=s+n*(r[2]-s),t[3]=o+n*(r[3]-o),t},A.random=function(t,r){var n,i,a,s,o,l;r=r||1;do{o=(n=2*e.RANDOM()-1)*n+(i=2*e.RANDOM()-1)*i;}while(o>=1);do{l=(a=2*e.RANDOM()-1)*a+(s=2*e.RANDOM()-1)*s;}while(l>=1);var u=Math.sqrt((1-o)/l);return t[0]=r*n,t[1]=r*i,t[2]=r*a*u,t[3]=r*s*u,t},A.transformMat4=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*a+r[12]*s,t[1]=r[1]*n+r[5]*i+r[9]*a+r[13]*s,t[2]=r[2]*n+r[6]*i+r[10]*a+r[14]*s,t[3]=r[3]*n+r[7]*i+r[11]*a+r[15]*s,t},A.transformQuat=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[0],o=r[1],l=r[2],u=r[3],c=u*n+o*a-l*i,h=u*i+l*n-s*a,p=u*a+s*i-o*n,f=-s*n-o*i-l*a;return t[0]=c*u+f*-s+h*-l-p*-o,t[1]=h*u+f*-o+p*-s-c*-l,t[2]=p*u+f*-l+c*-o-h*-s,t[3]=e[3],t},A.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},A.str=function(t){return "vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},A.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},A.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=t[3],o=r[0],l=r[1],u=r[2],c=r[3];return Math.abs(n-o)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(a-u)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(u))&&Math.abs(s-c)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(c))},A.forEach=A.sqrLen=A.len=A.sqrDist=A.dist=A.div=A.mul=A.sub=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}function s(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}function o(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t[3]=e[3]/r[3],t}function l(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2],e[3]-t[3])}function u(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2],a=e[3]-t[3];return r*r+n*n+i*i+a*a}function c(t){return Math.hypot(t[0],t[1],t[2],t[3])}function h(t){var e=t[0],r=t[1],n=t[2],i=t[3];return e*e+r*r+n*n+i*i}A.sub=i,A.mul=s,A.div=o,A.dist=l,A.sqrDist=u,A.len=c,A.sqrLen=h;var p,f=(p=n(),function(t,e,r,n,i,a){var s,o;for(e||(e=4),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,s=r;s<o;s+=e)p[0]=t[s],p[1]=t[s+1],p[2]=t[s+2],p[3]=t[s+3],i(p,p,a),t[s]=p[0],t[s+1]=p[1],t[s+2]=p[2],t[s+3]=p[3];return t});return A.forEach=f,A}function I(){if(M)return v;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}M=1,Object.defineProperty(v,"__esModule",{value:!0}),v.create=l,v.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},v.setAxisAngle=u,v.getAxisAngle=function(t,r){var n=2*Math.acos(r[3]),i=Math.sin(n/2);return i>e.EPSILON?(t[0]=r[0]/i,t[1]=r[1]/i,t[2]=r[2]/i):(t[0]=1,t[1]=0,t[2]=0),n},v.getAngle=function(t,e){var r=g(t,e);return Math.acos(2*r*r-1)},v.multiply=c,v.rotateX=function(t,e,r){r*=.5;var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+s*o,t[1]=i*l+a*o,t[2]=a*l-i*o,t[3]=s*l-n*o,t},v.rotateY=function(t,e,r){r*=.5;var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l-a*o,t[1]=i*l+s*o,t[2]=a*l+n*o,t[3]=s*l-i*o,t},v.rotateZ=function(t,e,r){r*=.5;var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=a*l+s*o,t[3]=s*l-a*o,t},v.calculateW=function(t,e){var r=e[0],n=e[1],i=e[2];return t[0]=r,t[1]=n,t[2]=i,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-i*i)),t},v.exp=h,v.ln=p,v.pow=function(t,e,r){return p(t,e),y(t,t,r),h(t,t),t},v.slerp=f,v.random=function(t){var r=e.RANDOM(),n=e.RANDOM(),i=e.RANDOM(),a=Math.sqrt(1-r),s=Math.sqrt(r);return t[0]=a*Math.sin(2*Math.PI*n),t[1]=a*Math.cos(2*Math.PI*n),t[2]=s*Math.sin(2*Math.PI*i),t[3]=s*Math.cos(2*Math.PI*i),t},v.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r*r+n*n+i*i+a*a,o=s?1/s:0;return t[0]=-r*o,t[1]=-n*o,t[2]=-i*o,t[3]=a*o,t},v.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},v.fromMat3=m,v.fromEuler=function(t,e,r,n){var i=.5*Math.PI/180;e*=i,r*=i,n*=i;var a=Math.sin(e),s=Math.cos(e),o=Math.sin(r),l=Math.cos(r),u=Math.sin(n),c=Math.cos(n);return t[0]=a*l*c-s*o*u,t[1]=s*o*c+a*l*u,t[2]=s*l*u-a*o*c,t[3]=s*l*c+a*o*u,t},v.str=function(t){return "quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},v.setAxes=v.sqlerp=v.rotationTo=v.equals=v.exactEquals=v.normalize=v.sqrLen=v.squaredLength=v.len=v.length=v.lerp=v.dot=v.scale=v.mul=v.add=v.set=v.copy=v.fromValues=v.clone=void 0;var e=o(a()),r=o(d()),n=o(_()),i=o(S());function s(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (s=function(t){return t?r:e})(t)}function o(e,r){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var n=s(r);if(n&&n.has(e))return n.get(e);var i={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(i,o,l):i[o]=e[o];}return i.default=e,n&&n.set(e,i),i}function l(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function u(t,e,r){r*=.5;var n=Math.sin(r);return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=Math.cos(r),t}function c(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+s*o+i*u-a*l,t[1]=i*c+s*l+a*o-n*u,t[2]=a*c+s*u+n*l-i*o,t[3]=s*c-n*o-i*l-a*u,t}function h(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=Math.sqrt(r*r+n*n+i*i),o=Math.exp(a),l=s>0?o*Math.sin(s)/s:0;return t[0]=r*l,t[1]=n*l,t[2]=i*l,t[3]=o*Math.cos(s),t}function p(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=Math.sqrt(r*r+n*n+i*i),o=s>0?Math.atan2(s,a)/s:0;return t[0]=r*o,t[1]=n*o,t[2]=i*o,t[3]=.5*Math.log(r*r+n*n+i*i+a*a),t}function f(t,r,n,i){var a,s,o,l,u,c=r[0],h=r[1],p=r[2],f=r[3],d=n[0],m=n[1],y=n[2],g=n[3];return (s=c*d+h*m+p*y+f*g)<0&&(s=-s,d=-d,m=-m,y=-y,g=-g),1-s>e.EPSILON?(a=Math.acos(s),o=Math.sin(a),l=Math.sin((1-i)*a)/o,u=Math.sin(i*a)/o):(l=1-i,u=i),t[0]=l*c+u*d,t[1]=l*h+u*m,t[2]=l*p+u*y,t[3]=l*f+u*g,t}function m(t,e){var r,n=e[0]+e[4]+e[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,t[0]=(e[5]-e[7])*(r=.5/r),t[1]=(e[6]-e[2])*r,t[2]=(e[1]-e[3])*r;else {var i=0;e[4]>e[0]&&(i=1),e[8]>e[3*i+i]&&(i=2);var a=(i+1)%3,s=(i+2)%3;r=Math.sqrt(e[3*i+i]-e[3*a+a]-e[3*s+s]+1),t[i]=.5*r,t[3]=(e[3*a+s]-e[3*s+a])*(r=.5/r),t[a]=(e[3*a+i]+e[3*i+a])*r,t[s]=(e[3*s+i]+e[3*i+s])*r;}return t}v.clone=i.clone,v.fromValues=i.fromValues,v.copy=i.copy,v.set=i.set,v.add=i.add,v.mul=c;var y=i.scale;v.scale=y;var g=i.dot;v.dot=g,v.lerp=i.lerp;var x=i.length;v.length=x,v.len=x;var b=i.squaredLength;v.squaredLength=b,v.sqrLen=b;var w=i.normalize;v.normalize=w,v.exactEquals=i.exactEquals,v.equals=i.equals;var A,I,P,z=(A=n.create(),I=n.fromValues(1,0,0),P=n.fromValues(0,1,0),function(t,e,r){var i=n.dot(e,r);return i<-.999999?(n.cross(A,I,e),n.len(A)<1e-6&&n.cross(A,P,e),n.normalize(A,A),u(t,A,Math.PI),t):i>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(n.cross(A,e,r),t[0]=A[0],t[1]=A[1],t[2]=A[2],t[3]=1+i,w(t,t))});v.rotationTo=z;var E,k,T=(E=l(),k=l(),function(t,e,r,n,i,a){return f(E,e,i,a),f(k,r,n,a),f(t,E,k,2*a*(1-a)),t});v.sqlerp=T;var B,C=(B=r.create(),function(t,e,r,n){return B[0]=r[0],B[3]=r[1],B[6]=r[2],B[1]=n[0],B[4]=n[1],B[7]=n[2],B[2]=-e[0],B[5]=-e[1],B[8]=-e[2],w(t,m(t,B))});return v.setAxes=C,v}var P,z={};function E(){if(P)return z;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}P=1,Object.defineProperty(z,"__esModule",{value:!0}),z.create=function(){var t=new e.ARRAY_TYPE(8);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},z.clone=function(t){var r=new e.ARRAY_TYPE(8);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r},z.fromValues=function(t,r,n,i,a,s,o,l){var u=new e.ARRAY_TYPE(8);return u[0]=t,u[1]=r,u[2]=n,u[3]=i,u[4]=a,u[5]=s,u[6]=o,u[7]=l,u},z.fromRotationTranslationValues=function(t,r,n,i,a,s,o){var l=new e.ARRAY_TYPE(8);l[0]=t,l[1]=r,l[2]=n,l[3]=i;var u=.5*a,c=.5*s,h=.5*o;return l[4]=u*i+c*n-h*r,l[5]=c*i+h*t-u*n,l[6]=h*i+u*r-c*t,l[7]=-u*t-c*r-h*n,l},z.fromRotationTranslation=o,z.fromTranslation=function(t,e){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*e[0],t[5]=.5*e[1],t[6]=.5*e[2],t[7]=0,t},z.fromRotation=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},z.fromMat4=function(t,i){var a=r.create();n.getRotation(a,i);var s=new e.ARRAY_TYPE(3);return n.getTranslation(s,i),o(t,a,s),t},z.copy=l,z.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},z.set=function(t,e,r,n,i,a,s,o,l){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t[6]=o,t[7]=l,t},z.getDual=function(t,e){return t[0]=e[4],t[1]=e[5],t[2]=e[6],t[3]=e[7],t},z.setDual=function(t,e){return t[4]=e[0],t[5]=e[1],t[6]=e[2],t[7]=e[3],t},z.getTranslation=function(t,e){var r=e[4],n=e[5],i=e[6],a=e[7],s=-e[0],o=-e[1],l=-e[2],u=e[3];return t[0]=2*(r*u+a*s+n*l-i*o),t[1]=2*(n*u+a*o+i*s-r*l),t[2]=2*(i*u+a*l+r*o-n*s),t},z.translate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=.5*r[0],l=.5*r[1],u=.5*r[2],c=e[4],h=e[5],p=e[6],f=e[7];return t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=s*o+i*u-a*l+c,t[5]=s*l+a*o-n*u+h,t[6]=s*u+n*l-i*o+p,t[7]=-n*o-i*l-a*u+f,t},z.rotateX=function(t,e,n){var i=-e[0],a=-e[1],s=-e[2],o=e[3],l=e[4],u=e[5],c=e[6],h=e[7],p=l*o+h*i+u*s-c*a,f=u*o+h*a+c*i-l*s,d=c*o+h*s+l*a-u*i,m=h*o-l*i-u*a-c*s;return r.rotateX(t,e,n),t[4]=p*(o=t[3])+m*(i=t[0])+f*(s=t[2])-d*(a=t[1]),t[5]=f*o+m*a+d*i-p*s,t[6]=d*o+m*s+p*a-f*i,t[7]=m*o-p*i-f*a-d*s,t},z.rotateY=function(t,e,n){var i=-e[0],a=-e[1],s=-e[2],o=e[3],l=e[4],u=e[5],c=e[6],h=e[7],p=l*o+h*i+u*s-c*a,f=u*o+h*a+c*i-l*s,d=c*o+h*s+l*a-u*i,m=h*o-l*i-u*a-c*s;return r.rotateY(t,e,n),t[4]=p*(o=t[3])+m*(i=t[0])+f*(s=t[2])-d*(a=t[1]),t[5]=f*o+m*a+d*i-p*s,t[6]=d*o+m*s+p*a-f*i,t[7]=m*o-p*i-f*a-d*s,t},z.rotateZ=function(t,e,n){var i=-e[0],a=-e[1],s=-e[2],o=e[3],l=e[4],u=e[5],c=e[6],h=e[7],p=l*o+h*i+u*s-c*a,f=u*o+h*a+c*i-l*s,d=c*o+h*s+l*a-u*i,m=h*o-l*i-u*a-c*s;return r.rotateZ(t,e,n),t[4]=p*(o=t[3])+m*(i=t[0])+f*(s=t[2])-d*(a=t[1]),t[5]=f*o+m*a+d*i-p*s,t[6]=d*o+m*s+p*a-f*i,t[7]=m*o-p*i-f*a-d*s,t},z.rotateByQuatAppend=function(t,e,r){var n=r[0],i=r[1],a=r[2],s=r[3],o=e[0],l=e[1],u=e[2],c=e[3];return t[0]=o*s+c*n+l*a-u*i,t[1]=l*s+c*i+u*n-o*a,t[2]=u*s+c*a+o*i-l*n,t[3]=c*s-o*n-l*i-u*a,t[4]=(o=e[4])*s+(c=e[7])*n+(l=e[5])*a-(u=e[6])*i,t[5]=l*s+c*i+u*n-o*a,t[6]=u*s+c*a+o*i-l*n,t[7]=c*s-o*n-l*i-u*a,t},z.rotateByQuatPrepend=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+s*o+i*u-a*l,t[1]=i*c+s*l+a*o-n*u,t[2]=a*c+s*u+n*l-i*o,t[3]=s*c-n*o-i*l-a*u,t[4]=n*(c=r[7])+s*(o=r[4])+i*(u=r[6])-a*(l=r[5]),t[5]=i*c+s*l+a*o-n*u,t[6]=a*c+s*u+n*l-i*o,t[7]=s*c-n*o-i*l-a*u,t},z.rotateAroundAxis=function(t,r,n,i){if(Math.abs(i)<e.EPSILON)return l(t,r);var a=Math.hypot(n[0],n[1],n[2]);i*=.5;var s=Math.sin(i),o=s*n[0]/a,u=s*n[1]/a,c=s*n[2]/a,h=Math.cos(i),p=r[0],f=r[1],d=r[2],m=r[3];t[0]=p*h+m*o+f*c-d*u,t[1]=f*h+m*u+d*o-p*c,t[2]=d*h+m*c+p*u-f*o,t[3]=m*h-p*o-f*u-d*c;var y=r[4],g=r[5],x=r[6],v=r[7];return t[4]=y*h+v*o+g*c-x*u,t[5]=g*h+v*u+x*o-y*c,t[6]=x*h+v*c+y*u-g*o,t[7]=v*h-y*o-g*u-x*c,t},z.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t},z.multiply=u,z.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t},z.lerp=function(t,e,r,n){var i=1-n;return c(e,r)<0&&(n=-n),t[0]=e[0]*i+r[0]*n,t[1]=e[1]*i+r[1]*n,t[2]=e[2]*i+r[2]*n,t[3]=e[3]*i+r[3]*n,t[4]=e[4]*i+r[4]*n,t[5]=e[5]*i+r[5]*n,t[6]=e[6]*i+r[6]*n,t[7]=e[7]*i+r[7]*n,t},z.invert=function(t,e){var r=p(e);return t[0]=-e[0]/r,t[1]=-e[1]/r,t[2]=-e[2]/r,t[3]=e[3]/r,t[4]=-e[4]/r,t[5]=-e[5]/r,t[6]=-e[6]/r,t[7]=e[7]/r,t},z.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=e[7],t},z.normalize=function(t,e){var r=p(e);if(r>0){r=Math.sqrt(r);var n=e[0]/r,i=e[1]/r,a=e[2]/r,s=e[3]/r,o=e[4],l=e[5],u=e[6],c=e[7],h=n*o+i*l+a*u+s*c;t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=(o-n*h)/r,t[5]=(l-i*h)/r,t[6]=(u-a*h)/r,t[7]=(c-s*h)/r;}return t},z.str=function(t){return "quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},z.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]},z.equals=function(t,r){var n=t[0],i=t[1],a=t[2],s=t[3],o=t[4],l=t[5],u=t[6],c=t[7],h=r[0],p=r[1],f=r[2],d=r[3],m=r[4],y=r[5],g=r[6],x=r[7];return Math.abs(n-h)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(h))&&Math.abs(i-p)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(p))&&Math.abs(a-f)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(f))&&Math.abs(s-d)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(d))&&Math.abs(o-m)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(m))&&Math.abs(l-y)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(y))&&Math.abs(u-g)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(g))&&Math.abs(c-x)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(x))},z.sqrLen=z.squaredLength=z.len=z.length=z.dot=z.mul=z.setReal=z.getReal=void 0;var e=s(a()),r=s(I()),n=s(g());function i(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (i=function(t){return t?r:e})(t)}function s(e,r){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var n=i(r);if(n&&n.has(e))return n.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,n&&n.set(e,a),a}function o(t,e,r){var n=.5*r[0],i=.5*r[1],a=.5*r[2],s=e[0],o=e[1],l=e[2],u=e[3];return t[0]=s,t[1]=o,t[2]=l,t[3]=u,t[4]=n*u+i*l-a*o,t[5]=i*u+a*s-n*l,t[6]=a*u+n*o-i*s,t[7]=-n*s-i*o-a*l,t}function l(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t}function u(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[4],l=r[5],u=r[6],c=r[7],h=e[4],p=e[5],f=e[6],d=e[7],m=r[0],y=r[1],g=r[2],x=r[3];return t[0]=n*x+s*m+i*g-a*y,t[1]=i*x+s*y+a*m-n*g,t[2]=a*x+s*g+n*y-i*m,t[3]=s*x-n*m-i*y-a*g,t[4]=n*c+s*o+i*u-a*l+h*x+d*m+p*g-f*y,t[5]=i*c+s*l+a*o-n*u+p*x+d*y+f*m-h*g,t[6]=a*c+s*u+n*l-i*o+f*x+d*g+h*y-p*m,t[7]=s*c-n*o-i*l-a*u+d*x-h*m-p*y-f*g,t}z.getReal=r.copy,z.setReal=r.copy,z.mul=u;var c=r.dot;z.dot=c;var h=r.length;z.length=h,z.len=h;var p=r.squaredLength;return z.squaredLength=p,z.sqrLen=p,z}var k,T,B={};function C(){if(k)return B;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}k=1,Object.defineProperty(B,"__esModule",{value:!0}),B.create=n,B.clone=function(t){var r=new e.ARRAY_TYPE(2);return r[0]=t[0],r[1]=t[1],r},B.fromValues=function(t,r){var n=new e.ARRAY_TYPE(2);return n[0]=t,n[1]=r,n},B.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t},B.set=function(t,e,r){return t[0]=e,t[1]=r,t},B.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t},B.subtract=i,B.multiply=s,B.divide=o,B.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t},B.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t},B.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t},B.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t},B.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t},B.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},B.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t},B.distance=l,B.squaredDistance=u,B.length=c,B.squaredLength=h,B.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t},B.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t},B.normalize=function(t,e){var r=e[0],n=e[1],i=r*r+n*n;return i>0&&(i=1/Math.sqrt(i)),t[0]=e[0]*i,t[1]=e[1]*i,t},B.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]},B.cross=function(t,e,r){var n=e[0]*r[1]-e[1]*r[0];return t[0]=t[1]=0,t[2]=n,t},B.lerp=function(t,e,r,n){var i=e[0],a=e[1];return t[0]=i+n*(r[0]-i),t[1]=a+n*(r[1]-a),t},B.random=function(t,r){r=r||1;var n=2*e.RANDOM()*Math.PI;return t[0]=Math.cos(n)*r,t[1]=Math.sin(n)*r,t},B.transformMat2=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i,t[1]=r[1]*n+r[3]*i,t},B.transformMat2d=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i+r[4],t[1]=r[1]*n+r[3]*i+r[5],t},B.transformMat3=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[3]*i+r[6],t[1]=r[1]*n+r[4]*i+r[7],t},B.transformMat4=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},B.rotate=function(t,e,r,n){var i=e[0]-r[0],a=e[1]-r[1],s=Math.sin(n),o=Math.cos(n);return t[0]=i*o-a*s+r[0],t[1]=i*s+a*o+r[1],t},B.angle=function(t,e){var r=t[0],n=t[1],i=e[0],a=e[1],s=Math.sqrt(r*r+n*n)*Math.sqrt(i*i+a*a);return Math.acos(Math.min(Math.max(s&&(r*i+n*a)/s,-1),1))},B.zero=function(t){return t[0]=0,t[1]=0,t},B.str=function(t){return "vec2("+t[0]+", "+t[1]+")"},B.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]},B.equals=function(t,r){var n=t[0],i=t[1],a=r[0],s=r[1];return Math.abs(n-a)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(a))&&Math.abs(i-s)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(s))},B.forEach=B.sqrLen=B.sqrDist=B.dist=B.div=B.mul=B.sub=B.len=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var a={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(a,o,l):a[o]=e[o];}return a.default=e,i&&i.set(e,a),a}(a());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(){var t=new e.ARRAY_TYPE(2);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0),t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t}function s(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t}function o(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t}function l(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1])}function u(t,e){var r=e[0]-t[0],n=e[1]-t[1];return r*r+n*n}function c(t){return Math.hypot(t[0],t[1])}function h(t){var e=t[0],r=t[1];return e*e+r*r}B.len=c,B.sub=i,B.mul=s,B.div=o,B.dist=l,B.sqrDist=u,B.sqrLen=h;var p,f=(p=n(),function(t,e,r,n,i,a){var s,o;for(e||(e=2),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,s=r;s<o;s+=e)p[0]=t[s],p[1]=t[s+1],i(p,p,a),t[s]=p[0],t[s+1]=p[1];return t});return B.forEach=f,B}function V(){if(T)return n;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}T=1,Object.defineProperty(n,"__esModule",{value:!0}),n.vec4=n.vec3=n.vec2=n.quat2=n.quat=n.mat4=n.mat3=n.mat2d=n.mat2=n.glMatrix=void 0;var e=x(a());n.glMatrix=e;var r=x(l());n.mat2=r;var i=x(h());n.mat2d=i;var s=x(d());n.mat3=s;var o=x(g());n.mat4=o;var u=x(I());n.quat=u;var c=x(E());n.quat2=c;var p=x(C());n.vec2=p;var f=x(_());n.vec3=f;var m=x(S());function y(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (y=function(t){return t?r:e})(t)}function x(e,r){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var n=y(r);if(n&&n.has(e))return n.get(e);var i={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in e)if("default"!==s&&Object.prototype.hasOwnProperty.call(e,s)){var o=a?Object.getOwnPropertyDescriptor(e,s):null;o&&(o.get||o.set)?Object.defineProperty(i,s,o):i[s]=e[s];}return i.default=e,n&&n.set(e,i),i}return n.vec4=m,n}var D,L,R,F,O=V(),N=function(){if(L)return D;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return L=1,D=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var a=this.sampleCurveDerivativeX(r);if(Math.abs(a)<1e-6)break;r-=i/a;}var s=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?s=r:o=r,r=.5*(o-s)+s;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},D}(),U=e(N);function j(){if(F)return R;function t(t,e){this.x=t,this.y=e;}return F=1,R=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},R}var q=e(j());function $(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!$(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!$(t[r],e[r]))return !1;return !0}return t===e}const G=Math.PI/180,Y=180/Math.PI;function X(t){return t*G}function Z(t){return t*Y}const H=[[0,0],[1,0],[1,1],[0,1]];function W(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function K(t,e,r,n){const i=new U(t,e,r,n);return function(t){return i.solve(t)}}const J=K(.25,.1,.25,1);function Q(t,e,r){return Math.min(r,Math.max(e,t))}function tt(t,e,r){return (r=Q((r-t)/(e-t),0,1))*r*(3-2*r)}function et(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function rt(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let a=null;t.forEach(((t,s)=>{e(t,((t,e)=>{t&&(a=t),i[s]=e,0==--n&&r(a,i);}));}));}function nt(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let it=1;function at(){return it++}function st(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function ot(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function lt(t,e){return -1!==t.indexOf(e,t.length-e.length)}function ut(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function ct(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function ht(t){return Array.isArray(t)?t.map(ht):"object"==typeof t&&t?ut(t,ht):t}const pt={};function ft(t){pt[t]||("undefined"!=typeof console&&console.warn(t),pt[t]=!0);}function dt(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function mt(t){let e=0;for(let r,n,i=0,a=t.length,s=a-1;i<a;s=i++)r=t[i],n=t[s],e+=(n.x-r.x)*(r.y+n.y);return e}function yt([t,e,r]){const n=X(e+90),i=X(r);return {x:t*Math.cos(n)*Math.sin(i),y:t*Math.sin(n)*Math.sin(i),z:t*Math.cos(i),azimuthal:e,polar:r}}function gt(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function xt(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const a=n||i;return e[r]=!a||a.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let vt=null;function bt(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function _t(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<n?e=i+1:r=i;}return e}function wt(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<=n?e=i+1:r=i;}return e}function Mt(t){return t>0?1/(1.001-t):1+t}function At(t){return t>0?1-1/(1.001-t):-t}const St={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!St.API_URL)return null;try{const t=new URL(St.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",RASTERARRAYS_URL_PREFIX:"rasterarrays/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",MESHOPT_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_base_v0.20.wasm",MESHOPT_SIMD_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_simd_v0.20.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf",TILES3D_URL_PREFIX:"3dtiles/v1"};function It(t){return St.API_URL_REGEX.test(t)}function Pt(t){return St.API_SPRITE_REGEX.test(t)}let zt,Et,kt,Tt,Bt,Ct;function Vt(){return null==zt&&(zt=self.OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof self.createImageBitmap),zt}const Dt={now:()=>void 0!==Tt?Tt:performance.now(),setNow(t){Tt=t;},restoreNow(){Tt=void 0;},frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const{width:r,height:n}=t;Bt||(Bt=document.createElement("canvas"));const i=Bt.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return (r>Bt.width||n>Bt.height)&&(Bt.width=r,Bt.height=n),i.clearRect(-e,-e,r+2*e,n+2*e),i.drawImage(t,0,0,r,n),i.getImageData(-e,-e,r+2*e,n+2*e)},resolveURL:t=>(Et||(Et=document.createElement("a")),Et.href=t,Et.href),get devicePixelRatio(){return window.devicePixelRatio},get prefersReducedMotion(){return !!window.matchMedia&&(null==kt&&(kt=window.matchMedia("(prefers-reduced-motion: reduce)")),kt.matches)},hasCanvasFingerprintNoise(){if(void 0!==Ct)return Ct;if(!Vt())return Ct=!1,!1;const t=new OffscreenCanvas(85,1),e=t.getContext("2d",{willReadFrequently:!0});let r=0;for(let n=0;n<t.width;++n)e.fillStyle=`rgba(${r++},${r++},${r++}, 255)`,e.fillRect(n,0,1,1);const n=e.getImageData(0,0,t.width,t.height);r=0;for(let t=0;t<n.data.length;++t)if(t%4!=3&&r++!==n.data[t])return Ct=!0,!0;return Ct=!1,!1}};function Lt(t,e){const r=t.indexOf("?");if(r<0)return `${t}?${new URLSearchParams(e).toString()}`;const n=new URLSearchParams(t.slice(r));for(const t in e)n.set(t,e[t]);return `${t.slice(0,r)}?${n.toString()}`}function Rt(t,e={persistentParams:[]}){const r=t.indexOf("?");if(r<0)return t;const n=new URLSearchParams,i=new URLSearchParams(t.slice(r));for(const t of e.persistentParams){const e=i.get(t);e&&n.set(t,e);}const a=n.toString();return `${t.slice(0,r)}${a.length>0?`?${a}`:""}`}const Ft="mapbox-tiles";let Ot=500,Nt=50;const Ut=["language","worldview","jobid"];let jt,qt;function $t(){try{return caches}catch(t){}}function Gt(){const t=$t();t&&null==jt&&(jt=t.open(Ft));}let Yt=1/0;const Xt={supported:!1,testSupport:function(t){!Wt&&Ht&&(Kt?Qt(t):Zt=t);}};let Zt,Ht,Wt=!1,Kt=!1;const Jt="undefined"!=typeof self?self:{};function Qt(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,Ht),t.isContextLost())return;Xt.supported=!0;}catch(t){}t.deleteTexture(e),Wt=!0;}Jt.document&&(Ht=Jt.document.createElement("img"),Ht.onload=function(){Zt&&Qt(Zt),Zt=null,Kt=!0;},Ht.onerror=function(){Wt=!0,Zt=null;},Ht.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const te={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Iconset:"Iconset",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(te);class ee extends Error{constructor(t,e,r){401===e&&It(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const re=gt()?()=>self.worker&&self.worker.referrer:()=>("blob:"===location.protocol?parent:self).location.href;const ne=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(re())&&!/^\w+:/.test(r))){if(self.fetch&&self.Request&&self.AbortController&&Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:re(),referrerPolicy:t.referrerPolicy,signal:r.signal});let i=!1,a=!1;const s=(o=n.url).indexOf("sku=")>0&&It(o);var o;"json"===t.type&&n.headers.set("Accept","application/json");const l=(r,i,o)=>{if(a)return;if(r&&"SecurityError"!==r.message&&ft(r.toString()),i&&o)return u(i);const l=Date.now();fetch(n).then((r=>{if(r.ok){const t=s?r.clone():null;return u(r,t,l)}return e(new ee(r.statusText,r.status,t.url))})).catch((r=>{"AbortError"!==r.name&&e(new Error(`${r.message} ${t.url}`));}));},u=(r,s,o)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{a||(s&&o&&function(t,e,r){if(Gt(),null==jt)return;const n=xt(e.headers.get("Cache-Control")||"");if(n["no-store"])return;const i={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>i.headers.set(e,t))),n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString());const a=i.headers.get("Expires");if(!a)return;if(new Date(a).getTime()-r<42e4)return;let s=Rt(t.url,{persistentParams:Ut});if(206===e.status){const e=t.headers.get("Range");if(!e)return;i.status=200,s=Lt(s,{range:e});}!function(t,e){if(void 0===qt)try{new Response(new ReadableStream),qt=!0;}catch(t){qt=!1;}qt?e(t.body):t.blob().then(e);}(e,(t=>{const r=new Response(200!==(n=e.status)&&404!==n&&[101,103,204,205,304].includes(n)?null:t,i);var n;Gt(),null!=jt&&jt.then((t=>t.put(s,r))).catch((t=>ft(t.message)));}));}(n,s,o),i=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{a||e(new Error(t.message));}));};return s?function(t,e){if(Gt(),null==jt)return e(null);jt.then((r=>{let n=Rt(t.url,{persistentParams:Ut});const i=t.headers.get("Range");i&&(n=Lt(n,{range:i})),r.match(n).then((t=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=xt(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(t);r.delete(n),i&&r.put(n,t.clone()),e(null,t,i);})).catch(e);})).catch(e);}(n,l):l(null,null),{cancel:()=>{a=!0,i||r.abort();}}}(t,e);if(gt()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new ee(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},ie=function(t,e){return ne(nt(t,{type:"arrayBuffer"}),e)};function ae(t){const e=document.createElement("a");return e.href=t,e.protocol===location.protocol&&e.host===location.host}const se="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let oe,le;oe=[],le=0;const ue=function(t,e){if(Xt.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),le>=St.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return oe.push(r),r}le++;let r=!1;const n=()=>{if(!r)for(r=!0,le--;oe.length&&le<St.MAX_PARALLEL_IMAGE_REQUESTS;){const t=oe.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=ue(e,r).cancel);}},i=ie(t,((t,r,i,a)=>{n(),t?e(t):r&&(self.createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,i,a))):function(t,e){const r=new Image;r.onload=()=>{e(null,r),URL.revokeObjectURL(r.src),r.onload=null,requestAnimationFrame((()=>{r.src=se;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):se;}(r,((t,r)=>e(t,r,i,a))));}));return {cancel:()=>{i.cancel(),n();}}};var ce,he,pe,fe={exports:{}},de={exports:{}},me={exports:{}},ye=function(){if(pe)return fe.exports;pe=1;var t=(ce||(ce=1,de.exports=function(t,e){var r,n,i,a,s,o,l,u;for(n=t.length-(r=3&t.length),i=e,s=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(a=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(a>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),de.exports),e=(he||(he=1,me.exports=function(t,e){for(var r,n=t.length,i=e^n,a=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(a)|(255&t.charCodeAt(++a))<<8|(255&t.charCodeAt(++a))<<16|(255&t.charCodeAt(++a))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++a;switch(n){case 3:i^=(255&t.charCodeAt(a+2))<<16;case 2:i^=(255&t.charCodeAt(a+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(a)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),me.exports);return fe.exports=t,fe.exports.murmur3=t,fe.exports.murmur2=e,fe.exports}(),ge=e(ye);class xe{constructor(t,...e){nt(this,e[0]||{}),this.type=t;}}class ve extends xe{constructor(t,e={}){super("error",nt({error:t},e));}}function be(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function _e(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class we{on(t,e){return this._listeners=this._listeners||{},be(t,e,this._listeners),this}off(t,e){return _e(t,e,this._listeners),_e(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},be(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){const r="string"==typeof t?new xe(t,e):t,n=r.type;if(this.listens(n)){r.target=this;const t=this._listeners&&this._listeners[n]?this._listeners[n].slice():[];for(const e of t)e.call(this,r);const e=this._oneTimeListeners&&this._oneTimeListeners[n]?this._oneTimeListeners[n].slice():[];for(const t of e)_e(n,t,this._oneTimeListeners),t.call(this,r);const i=this._eventedParent;i&&(nt(r,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(r));}else r instanceof ve&&console.error(r.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Me,Ae={},Se=function(){if(Me)return Ae;Me=1;var t={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function e(t){return (t=Math.round(t))<0?0:t>255?255:t}function r(t){return e("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function n(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function i(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{Ae.parseCSSColor=function(a){var s,o=a.replace(/ /g,"").toLowerCase();if(o in t)return t[o].slice();if("#"===o[0])return 4===o.length?(s=parseInt(o.substr(1),16))>=0&&s<=4095?[(3840&s)>>4|(3840&s)>>8,240&s|(240&s)>>4,15&s|(15&s)<<4,1]:null:7===o.length&&(s=parseInt(o.substr(1),16))>=0&&s<=16777215?[(16711680&s)>>16,(65280&s)>>8,255&s,1]:null;var l=o.indexOf("("),u=o.indexOf(")");if(-1!==l&&u+1===o.length){var c=o.substr(0,l),h=o.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case"rgba":if(4!==h.length)return null;p=n(h.pop());case"rgb":return 3!==h.length?null:[r(h[0]),r(h[1]),r(h[2]),p];case"hsla":if(4!==h.length)return null;p=n(h.pop());case"hsl":if(3!==h.length)return null;var f=(parseFloat(h[0])%360+360)%360/360,d=n(h[1]),m=n(h[2]),y=m<=.5?m*(d+1):m+d-m*d,g=2*m-y;return [e(255*i(g,y,f+1/3)),e(255*i(g,y,f)),e(255*i(g,y,f-1/3)),p];default:return null}}return null};}catch(t){}return Ae}();class Ie{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof Ie)return t;if("string"!=typeof t)return;const e=Se.parseCSSColor(t);return e?new Ie(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toStringPremultipliedAlpha(){const[t,e,r,n]=0===this.a?[0,0,0,0]:[255*this.r/this.a,255*this.g/this.a,255*this.b/this.a,this.a];return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toString(){const[t,e,r,n]=[this.r,this.g,this.b,this.a];return `rgba(${Math.round(255*t)},${Math.round(255*e)},${Math.round(255*r)},${n})`}toRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new Pe(t,e,r,n,i)}clone(){return new Ie(this.r,this.g,this.b,this.a)}}class Pe{constructor(t,e,r,n,i){if(t){const a=t.image.height,s=a*a;e=0===i?0:e/i*(a-1),r=0===i?0:r/i*(a-1),n=0===i?0:n/i*(a-1);const o=Math.floor(e),l=Math.floor(r),u=Math.floor(n),c=Math.ceil(e),h=Math.ceil(r),p=Math.ceil(n),f=e-o,d=r-l,m=n-u,y=t.image.data,g=4*(o+l*s+u*a),x=4*(o+l*s+p*a),v=4*(o+h*s+u*a),b=4*(o+h*s+p*a),_=4*(c+l*s+u*a),w=4*(c+l*s+p*a),M=4*(c+h*s+u*a),A=4*(c+h*s+p*a);if(g<0||A>=y.length)throw new Error("out of range");this.r=ze(ze(ze(y[g],y[x],m),ze(y[v],y[b],m),d),ze(ze(y[_],y[w],m),ze(y[M],y[A],m),d),f)/255*i,this.g=ze(ze(ze(y[g+1],y[x+1],m),ze(y[v+1],y[b+1],m),d),ze(ze(y[_+1],y[w+1],m),ze(y[M+1],y[A+1],m),d),f)/255*i,this.b=ze(ze(ze(y[g+2],y[x+2],m),ze(y[v+2],y[b+2],m),d),ze(ze(y[_+2],y[w+2],m),ze(y[M+2],y[A+2],m),d),f)/255*i,this.a=i;}else this.r=e,this.g=r,this.b=n,this.a=i;}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}toHslaArray(){if(0===this.a)return [0,0,0,0];const{r:t,g:e,b:r,a:n}=this,i=Math.min(Math.max(t/n,0),1),a=Math.min(Math.max(e/n,0),1),s=Math.min(Math.max(r/n,0),1),o=Math.min(i,a,s),l=Math.max(i,a,s),u=(o+l)/2;if(o===l)return [0,0,100*u,n];const c=l-o,h=u>.5?c/(2-l-o):c/(l+o);let p=0;return l===i?p=(a-s)/c+(a<s?6:0):l===a?p=(s-i)/c+2:l===s&&(p=(i-a)/c+4),p*=60,[Math.min(Math.max(p,0),360),Math.min(Math.max(100*h,0),100),Math.min(Math.max(100*u,0),100),n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[t/n,e/n,r/n,n]}toArray01Scaled(t){const{r:e,g:r,b:n,a:i}=this;return 0===i?[0,0,0]:[e/i*t,r/i*t,n/i*t]}toArray01PremultipliedAlpha(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}toArray01Linear(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[Math.pow(t/n,2.2),Math.pow(e/n,2.2),Math.pow(r/n,2.2),n]}}function ze(t,e,r){return t*(1-r)+e*r}function Ee(t,e,r){return t.map(((t,n)=>ze(t,e[n],r)))}Ie.black=new Ie(0,0,0,1),Ie.white=new Ie(1,1,1,1),Ie.transparent=new Ie(0,0,0,0),Ie.red=new Ie(1,0,0,1),Ie.blue=new Ie(0,0,1,1);var ke=Object.freeze({__proto__:null,array:Ee,color:function(t,e,r){return new Ie(ze(t.r,e.r,r),ze(t.g,e.g,r),ze(t.b,e.b,r),ze(t.a,e.a,r))},number:ze});function Te(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class Be extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Ce{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Ce(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Ve={kind:"null"},De={kind:"number"},Le={kind:"string"},Re={kind:"boolean"},Fe={kind:"color"},Oe={kind:"object"},Ne={kind:"value"},Ue={kind:"collator"},je={kind:"formatted"},qe={kind:"resolvedImage"};function $e(t,e){return {kind:"array",itemType:t,N:e}}function Ge(t){if("array"===t.kind){const e=Ge(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Ye=[Ve,De,Le,Re,Fe,je,Oe,$e(Ne),qe];function Xe(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Xe(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Ye)if(!Xe(t,e))return null}return `Expected ${Ge(t)} but found ${Ge(e)} instead.`}function Ze(t,e){return e.some((e=>e.kind===t.kind))}function He(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}class We{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Ke{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Je{constructor(t){this.sections=t;}static fromString(t){return new Je([new Ke(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&t.image.namePrimary))}static factory(t){return t instanceof Je?t:Je.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.namePrimary]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toRenderColor(null).toArray())),t.push(r);}return t}}class Qe{constructor(t,e){if(this.id=t,this.options=e||{params:{}},this.options.transform){const{a:t,b:e,c:r,d:n,e:i,f:a}=this.options.transform;this.options.transform=new DOMMatrix([t,e,r,n,i,a]);}else this.options.transform=new DOMMatrix([1,0,0,1,0,0]);}static deserializeId(t){return JSON.parse(t).id}static deserializeFromString(t){const e=JSON.parse(t),{a:r,b:n,c:i,d:a,e:s,f:o}=e.options.transform;return new DOMMatrix([r,n,i,a,s,o]),new Qe(e.id,e.options)}scaleSelf(t){return this.options.transform=this.options.transform.scale(t),this}serialize(){const t={id:this.id};this.options&&(t.options=this.options);const{a:e,b:r,c:n,d:i,e:a,f:s}=this.options.transform;return t.options.transform={a:e,b:r,c:n,d:i,e:a,f:s},JSON.stringify(t)}}class tr{constructor(t){this.namePrimary=t.namePrimary,t.nameSecondary&&(this.nameSecondary=t.nameSecondary),t.optionsPrimary&&(this.optionsPrimary=t.optionsPrimary),t.optionsSecondary&&(this.optionsSecondary=t.optionsSecondary),this.available=t.available;}toString(){return this.namePrimary&&this.nameSecondary?`[${this.namePrimary},${this.nameSecondary}]`:this.namePrimary}getPrimary(){return new Qe(this.namePrimary,{params:this.optionsPrimary&&this.optionsPrimary.params||{}})}getSerializedPrimary(){return this.getPrimary().serialize()}getSecondary(){return this.nameSecondary?new Qe(this.nameSecondary,{params:this.optionsSecondary&&this.optionsSecondary.params||{}}):null}static from(t){return "string"==typeof t?tr.build(t):t}static build(t,e,r,n){return t?new tr({namePrimary:t,nameSecondary:e,optionsPrimary:r,optionsSecondary:n,available:!1}):null}}function er(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function rr(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof Ie)return !0;if(t instanceof We)return !0;if(t instanceof Je)return !0;if(t instanceof tr)return !0;if(Array.isArray(t)){for(const e of t)if(!rr(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!rr(t[e]))return !1;return !0}return !1}function nr(t){if(null===t)return Ve;if("string"==typeof t)return Le;if("boolean"==typeof t)return Re;if("number"==typeof t)return De;if(t instanceof Ie)return Fe;if(t instanceof We)return Ue;if(t instanceof Je)return je;if(t instanceof tr)return qe;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=nr(e);if(r){if(r===t)continue;r=Ne;break}r=t;}return $e(r||Ne,e)}return Oe}function ir(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Ie?t.toStringPremultipliedAlpha():t instanceof Je||t instanceof tr?t.toString():JSON.stringify(t)}class ar{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!rr(t[1]))return e.error("invalid value");const r=t[1];let n=nr(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new ar(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof Ie?["rgba"].concat(this.value.toRenderColor(null).toArray()):this.value instanceof Je?this.value.serialize():this.value}}class sr{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const or={string:Le,number:De,boolean:Re,object:Oe};class lr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,a;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in or)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=or[r],n++;}else i=Ne;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);a=t[2],n++;}r=$e(i,a);}else r=or[i];const a=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Ne);if(!r)return null;a.push(r);}return new lr(r,a)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!Xe(this.type,nr(r)))return r;if(e===this.args.length-1)throw new sr(`The expression ${JSON.stringify(this.args[e].serialize())} evaluated to ${Ge(nr(r))} but was expected to be of type ${Ge(this.type)}.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class ur{constructor(t){this.type=je,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const a=t[r];if(i&&"object"==typeof a&&!Array.isArray(a)){i=!1;let t=null;if(a["font-scale"]&&(t=e.parseObjectValue(a["font-scale"],r,"font-scale",De),!t))return null;let s=null;if(a["text-font"]&&(s=e.parseObjectValue(a["text-font"],r,"text-font",$e(Le)),!s))return null;let o=null;if(a["text-color"]&&(o=e.parseObjectValue(a["text-color"],r,"text-color",Fe),!o))return null;const l=n[n.length-1];l.scale=t,l.font=s,l.textColor=o;}else {const a=e.parse(t[r],r,Ne);if(!a)return null;const s=a.type.kind;if("string"!==s&&"value"!==s&&"null"!==s&&"resolvedImage"!==s)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:a,scale:null,font:null,textColor:null});}}return new ur(n)}evaluate(t){return new Je(this.sections.map((e=>{const r=e.content.evaluate(t);return nr(r)===qe?new Ke("",r,null,null,null):new Ke(ir(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class cr{constructor(t,e,r,n){this._imageWarnHistory={},this.type=qe,this.inputPrimary=t,this.inputSecondary=e,this.inputPrimaryParams=r,this.inputSecondaryParams=n;}static parse(t,e){if(t.length<2)return e.error("Expected two or more arguments.");let r=1;const n=[];function i(){if(r<t.length){const i=e.parse(t[r],r++,Le);return i?(n.push({image:i,options:void 0}),!0):(e.error(n.length?"Secondary image variant is not a string.":"No image name provided."),!1)}return !0}function a(){if(r<t.length){if(null===(i=t[r])||"object"!=typeof i||Array.isArray(i))return !0;const a=t[r].params,s=e.concat(r);if(!a)return r++,!0;if("object"!=typeof a||a.constructor!==Object)return s.error('Image options "params" should be an object'),!1;const o={},l=s.concat(void 0,"params");for(const t in a){if(!t)return l.error("Image parameter name should be non-empty"),!1;const e=l.concat(void 0,t).parse(a[t],void 0,Fe,void 0,{typeAnnotation:"coerce"});if(!e)return !1;o[t]=e;}return n[n.length-1].options=o,r++,!0}var i;return !0}for(let t=0;t<2;t++)if(!i()||!a())return;return new cr(n[0].image,n[1]?n[1].image:void 0,n[0].options,n[1]?n[1].options:void 0)}evaluateParams(t,e){const r={};if(e){for(const n in e)if(e[n])try{const i=e[n].evaluate(t),a=`Ignoring image parameter "${n}" with semi-transparent color ${i.toString()}`;if(1!==i.a){this._imageWarnHistory[a]||(console.warn(a),this._imageWarnHistory[a]=!0);continue}r[n]=i;}catch(t){continue}if(0!==Object.keys(r).length)return {params:r}}}evaluate(t){const e=tr.build(this.inputPrimary.evaluate(t),this.inputSecondary?this.inputSecondary.evaluate(t):void 0,this.inputPrimaryParams?this.evaluateParams(t,this.inputPrimaryParams):void 0,this.inputSecondaryParams?this.evaluateParams(t,this.inputSecondaryParams):void 0);return e&&t.availableImages&&(e.available=t.availableImages.indexOf(e.namePrimary)>-1,e.nameSecondary&&e.available&&t.availableImages&&(e.available=t.availableImages.indexOf(e.nameSecondary)>-1)),e}eachChild(t){if(t(this.inputPrimary),this.inputPrimaryParams)for(const e in this.inputPrimaryParams)this.inputPrimaryParams[e]&&t(this.inputPrimaryParams[e]);if(this.inputSecondary&&(t(this.inputSecondary),this.inputSecondaryParams))for(const e in this.inputSecondaryParams)this.inputSecondaryParams[e]&&t(this.inputSecondaryParams[e]);}outputDefined(){return !1}serializeParams(t){const e={};if(t){for(const r in t)t[r]&&(e[r]=t[r].serialize());return {params:e}}}serialize(){const t=["image",this.inputPrimary.serialize()];return this.inputPrimaryParams&&t.push(this.serializeParams(this.inputPrimaryParams)),this.inputSecondary&&(t.push(this.inputSecondary.serialize()),this.inputSecondaryParams&&t.push(this.serializeParams(this.inputSecondaryParams))),t}}function hr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}const pr={"to-boolean":Re,"to-color":Fe,"to-number":De,"to-string":Le};class fr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0],n=[];let i=Ve;if("to-array"===r){if(!Array.isArray(t[1]))return null;const r=t[1].length;if(e.expectedType){if("array"!==e.expectedType.kind)return e.error(`Expected ${e.expectedType.kind} but found array.`);i=$e(e.expectedType.itemType,r);}else {if(!(r>0&&rr(t[1][0])))return null;i=$e(nr(t[1][0]),r);}for(let a=0;a<r;a++){const r=t[1][a];let s;if("array"===hr(r))s=e.parse(r,void 0,i.itemType);else {const t=hr(r);if(t!==i.itemType.kind)return e.error(`Expected ${i.itemType.kind} but found ${t}.`);s=e.registry.literal.parse(["literal",void 0===r?null:r],e);}if(!s)return null;n.push(s);}}else {if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");i=pr[r];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,Ne);if(!i)return null;n.push(i);}}return new fr(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Ie)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:er(e[0],e[1],e[2],e[3]),!r))return new Ie(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new sr(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new sr(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Je.fromString(ir(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?tr.build(ir(this.args[0].evaluate(t))):"array"===this.type.kind?this.args.map((e=>e.evaluate(t))):ir(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new ur([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new cr(this.args[0]).serialize();const t="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const dr=["Unknown","Point","LineString","Polygon"];class mr{constructor(t,e){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.scope=t,this.options=e;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?dr[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(t){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Ie.parse(t)),e}getConfig(t){return this.options?this.options.get(t):null}}class yr{constructor(t,e,r,n,i){this.name=t,this.type=e,this._evaluate=r,this.args=n,this._overloadIndex=i;}evaluate(t){if(!this._evaluate){const t=yr.definitions[this.name];this._evaluate=Array.isArray(t)?t[2]:t.overloads[this._overloadIndex][1];}return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=yr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,a=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,s=[];let o=null,l=-1;for(const[n,u]of a){if(Array.isArray(n)&&n.length!==t.length-1)continue;s.push(n),l++,o=new Rn(e.registry,e.path,null,e.scope,void 0,e._scope,e.options);const a=[];let c=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){c=!0;break}a.push(s);}if(!c)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new yr(r,i,u,a,l)}}if(1===s.length)e.errors.push(...o.errors);else {const r=(s.length?s:a.map((([t])=>t))).map(gr).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Ge(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){yr.definitions=e;for(const r in e)t[r]=yr;}}function gr(t){return Array.isArray(t)?`(${t.map(Ge).join(", ")})`:`(${Ge(t.type)}...)`}class xr{constructor(t,e,r){this.type=Ue,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=void 0===r["case-sensitive"]?e.parse(!1,1,Re):e.parseObjectValue(r["case-sensitive"],1,"case-sensitive",Re);if(!n)return null;const i=void 0===r["diacritic-sensitive"]?e.parse(!1,1,Re):e.parseObjectValue(r["diacritic-sensitive"],1,"diacritic-sensitive",Re);if(!i)return null;let a=null;return r.locale&&(a=e.parseObjectValue(r.locale,1,"locale",Le),!a)?null:new xr(n,i,a)}evaluate(t){return new We(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function vr(t,e,r=0,n=t.length-1,i=_r){for(;n>r;){if(n-r>600){const a=n-r+1,s=e-r+1,o=Math.log(a),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(a-l)/a)*(s-a/2<0?-1:1);vr(t,e,Math.max(r,Math.floor(e-s*l/a+u)),Math.min(n,Math.floor(e+(a-s)*l/a+u)),i);}const a=t[e];let s=r,o=n;for(br(t,r,e),i(t[n],a)>0&&br(t,r,n);s<o;){for(br(t,s,o),s++,o--;i(t[s],a)<0;)s++;for(;i(t[o],a)>0;)o--;}0===i(t[r],a)?br(t,r,o):(o++,br(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function br(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function _r(t,e){return t<e?-1:t>e?1:0}function wr(t){let e=0;for(let r,n,i=0,a=t.length,s=a-1;i<a;s=i++)r=t[i],n=t[s],e+=(n.x-r.x)*(r.y+n.y);return e}function Mr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Ar(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Sr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],a=t[0]-r[0],s=t[1]-r[1];return n*s-a*i==0&&n*a<=0&&i*s<=0}function Ir(t,e,r=!1){let n=!1;for(let o=0,l=e.length;o<l;o++){const l=e[o];for(let e=0,o=l.length,u=o-1;e<o;u=e++){const o=l[u],c=l[e];if(Sr(t,o,c))return r;(a=o)[1]>(i=t)[1]!=(s=c)[1]>i[1]&&i[0]<(s[0]-a[0])*(i[1]-a[1])/(s[1]-a[1])+a[0]&&(n=!n);}}var i,a,s;return n}function Pr(t,e,r,n){const i=n[0]-r[0],a=n[1]-r[1],s=(t[0]-r[0])*a-i*(t[1]-r[1]),o=(e[0]-r[0])*a-i*(e[1]-r[1]);return s>0&&o<0||s<0&&o>0}function zr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(a=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*a[0]&&!(!Pr(t,e,r,n)||!Pr(r,n,t,e));var i,a;}const Er=8192;function kr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Er),Math.round(n*i*Er)]}function Tr(t,e){for(let r=0;r<e.length;r++)if(Ir(t,e[r]))return !0;return !1}function Br(t,e,r){for(const n of r)for(let r=0,i=n.length,a=i-1;r<i;a=r++)if(zr(t,e,n[a],n[r]))return !0;return !1}function Cr(t,e){for(let r=0;r<t.length;++r)if(!Ir(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Br(t[r],t[r+1],e))return !1;return !0}function Vr(t,e){for(let r=0;r<e.length;r++)if(Cr(t,e[r]))return !0;return !1}function Dr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const a=[];for(let n=0;n<t[i].length;n++){const s=kr(t[i][n],r);Mr(e,s),a.push(s);}n.push(a);}return n}function Lr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const a=Dr(t[i],e,r);n.push(a);}return n}function Rr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Mr(e,t);}function Fr(t,e,r,n){const i=Math.pow(2,n.z)*Er,a=[n.x*Er,n.y*Er],s=[];if(!t)return s;for(const n of t)for(const t of n){const n=[t.x+a[0],t.y+a[1]];Rr(n,e,r,i),s.push(n);}return s}function Or(t,e,r,n){const i=Math.pow(2,n.z)*Er,a=[n.x*Er,n.y*Er],s=[];if(!t)return s;for(const r of t){const t=[];for(const n of r){const r=[n.x+a[0],n.y+a[1]];Mr(e,r),t.push(r);}s.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of s)for(const n of t)Rr(n,e,r,i);}var o;return s}class Nr{constructor(t,e){this.type=Re,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(rr(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Nr(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Nr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Nr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const a=Dr(e.coordinates,n,i),s=Fr(t.geometry(),r,n,i);if(!Ar(r,n))return !1;for(const t of s)if(!Ir(t,a))return !1}if("MultiPolygon"===e.type){const a=Lr(e.coordinates,n,i),s=Fr(t.geometry(),r,n,i);if(!Ar(r,n))return !1;for(const t of s)if(!Tr(t,a))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const a=Dr(e.coordinates,n,i),s=Or(t.geometry(),r,n,i);if(!Ar(r,n))return !1;for(const t of s)if(!Cr(t,a))return !1}if("MultiPolygon"===e.type){const a=Lr(e.coordinates,n,i),s=Or(t.geometry(),r,n,i);if(!Ar(r,n))return !1;for(const t of s)if(!Vr(t,a))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}const Ur={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},jr=1/298.257223563,qr=jr*(2-jr),$r=Math.PI/180;class Gr{static fromTile(t,e,r){const n=Math.PI*(1-2*(t+.5)/Math.pow(2,e)),i=Math.atan(.5*(Math.exp(n)-Math.exp(-n)))/$r;return new Gr(i,r)}static get units(){return Ur}constructor(t,e){if(void 0===t)throw new Error("No latitude given.");if(e&&!Ur[e])throw new Error(`Unknown unit ${e}. Use one of: ${Object.keys(Ur).join(", ")}`);const r=6378.137*$r*(e?Ur[e]:1),n=Math.cos(t*$r),i=1/(1-qr*(1-n*n)),a=Math.sqrt(i);this.kx=r*a*n,this.ky=r*a*i*(1-qr);}distance(t,e){const r=Zr(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}bearing(t,e){const r=Zr(e[0]-t[0])*this.kx;return Math.atan2(r,(e[1]-t[1])*this.ky)/$r}destination(t,e,r){const n=r*$r;return this.offset(t,Math.sin(n)*e,Math.cos(n)*e)}offset(t,e,r){return [t[0]+e/this.kx,t[1]+r/this.ky]}lineDistance(t){let e=0;for(let r=0;r<t.length-1;r++)e+=this.distance(t[r],t[r+1]);return e}area(t){let e=0;for(let r=0;r<t.length;r++){const n=t[r];for(let t=0,i=n.length,a=i-1;t<i;a=t++)e+=Zr(n[t][0]-n[a][0])*(n[t][1]+n[a][1])*(r?-1:1);}return Math.abs(e)/2*this.kx*this.ky}along(t,e){let r=0;if(e<=0)return t[0];for(let n=0;n<t.length-1;n++){const i=t[n],a=t[n+1],s=this.distance(i,a);if(r+=s,r>e)return Xr(i,a,(e-(r-s))/s)}return t[t.length-1]}pointToSegmentDistance(t,e,r){let[n,i]=e,a=Zr(r[0]-n)*this.kx,s=(r[1]-i)*this.ky;if(0!==a||0!==s){const e=(Zr(t[0]-n)*this.kx*a+(t[1]-i)*this.ky*s)/(a*a+s*s);e>1?(n=r[0],i=r[1]):e>0&&(n+=a/this.kx*e,i+=s/this.ky*e);}return a=Zr(t[0]-n)*this.kx,s=(t[1]-i)*this.ky,Math.sqrt(a*a+s*s)}pointOnLine(t,e){let r=1/0,n=t[0][0],i=t[0][1],a=0,s=0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=Zr(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(Zr(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=Zr(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<r&&(r=f,n=l,i=u,a=o,s=p);}return {point:[n,i],index:a,t:Math.max(0,Math.min(1,s))}}lineSlice(t,e,r){let n=this.pointOnLine(r,t),i=this.pointOnLine(r,e);if(n.index>i.index||n.index===i.index&&n.t>i.t){const t=n;n=i,i=t;}const a=[n.point],s=n.index+1,o=i.index;!Yr(r[s],a[0])&&s<=o&&a.push(r[s]);for(let t=s+1;t<=o;t++)a.push(r[t]);return Yr(r[o],i.point)||a.push(i.point),a}lineSliceAlong(t,e,r){let n=0;const i=[];for(let a=0;a<r.length-1;a++){const s=r[a],o=r[a+1],l=this.distance(s,o);if(n+=l,n>t&&0===i.length&&i.push(Xr(s,o,(t-(n-l))/l)),n>=e)return i.push(Xr(s,o,(e-(n-l))/l)),i;n>t&&i.push(o);}return i}bufferPoint(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[0]+n,t[1]+r]}bufferBBox(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[2]+n,t[3]+r]}insideBBox(t,e){return Zr(t[0]-e[0])>=0&&Zr(t[0]-e[2])<=0&&t[1]>=e[1]&&t[1]<=e[3]}}function Yr(t,e){return t[0]===e[0]&&t[1]===e[1]}function Xr(t,e,r){const n=Zr(e[0]-t[0]);return [t[0]+n*r,t[1]+(e[1]-t[1])*r]}function Zr(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}class Hr{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,a=e[i];if(r(n,a)>=0)break;e[t]=a,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const a=n+1;if(a<this.length&&r(e[a],e[n])<0&&(n=a),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}var Wr=8192;function Kr(t,e){return e.dist-t.dist}const Jr=100,Qr=50;function tn(t){const e=[1/0,1/0,-1/0,-1/0];if(e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return !1;return !0}function en(t){return t[1]-t[0]+1}function rn(t,e){const r=t[1]>=t[0]&&t[1]<e;return r||console.warn("Distance Expression: Index is out of range"),r}function nn(t,e){if(t[0]>t[1])return [null,null];const r=en(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}{if(1===r)return [t,null];const e=Math.floor(r/2)-1;return [[t[0],t[0]+e],[t[0]+e+1,t[1]]]}}function an(t,e){const r=[1/0,1/0,-1/0,-1/0];if(!rn(e,t.length))return r;for(let n=e[0];n<=e[1];++n)Mr(r,t[n]);return r}function sn(t){const e=[1/0,1/0,-1/0,-1/0];for(let r=0;r<t.length;++r)for(let n=0;n<t[r].length;++n)Mr(e,t[r][n]);return e}function on(t,e,r){if(tn(t)||tn(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function ln(t){return 360*t-180}function un(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function cn(t,e){const r=Math.pow(2,e.z),n=(t.y/Wr+e.y)/r;return [ln((t.x/Wr+e.x)/r),un(n)]}function hn(t,e){const r=[];for(let n=0;n<t.length;++n)r.push(cn(t[n],e));return r}function pn(t,e,r){const n=r.pointOnLine(e,t).point;return r.distance(t,n)}function fn(t,e,r,n,i){const a=r.slice(n[0],n[1]+1);let s=1/0;for(let r=e[0];r<=e[1];++r)if(0===(s=Math.min(s,pn(t[r],a,i))))return 0;return s}function dn(t,e,r,n,i){const a=Math.min(i.pointToSegmentDistance(t,r,n),i.pointToSegmentDistance(e,r,n)),s=Math.min(i.pointToSegmentDistance(r,t,e),i.pointToSegmentDistance(n,t,e));return Math.min(a,s)}function mn(t,e,r,n,i){if(!rn(e,t.length)||!rn(n,r.length))return NaN;let a=1/0;for(let s=e[0];s<e[1];++s)for(let e=n[0];e<n[1];++e){if(zr(t[s],t[s+1],r[e],r[e+1]))return 0;a=Math.min(a,dn(t[s],t[s+1],r[e],r[e+1],i));}return a}function yn(t,e,r,n,i){if(!rn(e,t.length)||!rn(n,r.length))return NaN;let a=1/0;for(let s=e[0];s<=e[1];++s)for(let e=n[0];e<=n[1];++e)if(0===(a=Math.min(a,i.distance(t[s],r[e]))))return a;return a}function gn(t,e,r){if(Ir(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i.length;if(e<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(i[0]!==i[e-1]&&0===(n=Math.min(n,r.pointToSegmentDistance(t,i[e-1],i[0]))))return n;if(0===(n=Math.min(n,pn(t,i,r))))return n}return n}function xn(t,e,r,n){if(!rn(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Ir(t[n],r,!0))return 0;let i=1/0;for(let a=e[0];a<e[1];++a)for(const e of r)for(let r=0,s=e.length,o=s-1;r<s;o=r++){if(zr(t[a],t[a+1],e[o],e[r]))return 0;i=Math.min(i,dn(t[a],t[a+1],e[o],e[r],n));}return i}function vn(t,e){for(const r of t)for(let t=0;t<=r.length-1;++t)if(Ir(r[t],e,!0))return !0;return !1}function bn(t,e,r,n=1/0){const i=sn(t),a=sn(e);if(n!==1/0&&on(i,a,r)>=n)return n;if(Ar(i,a)){if(vn(t,e))return 0}else if(vn(e,t))return 0;let s=n;for(const n of t)for(let t=0,i=n.length,a=i-1;t<i;a=t++)for(const i of e)for(let e=0,o=i.length,l=o-1;e<o;l=e++){if(zr(n[a],n[t],i[l],i[e]))return 0;s=Math.min(s,dn(n[a],n[t],i[l],i[e],r));}return s}function _n(t,e,r,n,i,a,s){if(null===a||null===s)return;const o=on(an(n,a),an(i,s),r);o<e&&t.push({dist:o,range1:a,range2:s});}function wn(t,e,r,n,i=1/0){let a=Math.min(n.distance(t[0],r[0][0]),i);if(0===a)return a;const s=new Hr([{dist:0,range1:[0,t.length-1],range2:[0,0]}],Kr),o=e?Qr:Jr,l=sn(r);for(;s.length;){const i=s.pop();if(i.dist>=a)continue;const u=i.range1;if(en(u)<=o){if(!rn(u,t.length))return NaN;if(e){const e=xn(t,u,r,n);if(0===(a=Math.min(a,e)))return a}else for(let e=u[0];e<=u[1];++e){const i=gn(t[e],r,n);if(0===(a=Math.min(a,i)))return a}}else {const r=nn(u,e);if(null!==r[0]){const e=on(an(t,r[0]),l,n);e<a&&s.push({dist:e,range1:r[0],range2:[0,0]});}if(null!==r[1]){const e=on(an(t,r[1]),l,n);e<a&&s.push({dist:e,range1:r[1],range2:[0,0]});}}}return a}function Mn(t,e,r,n,i,a=1/0){let s=Math.min(a,i.distance(t[0],r[0]));if(0===s)return s;const o=new Hr([{dist:0,range1:[0,t.length-1],range2:[0,r.length-1]}],Kr),l=e?Qr:Jr,u=n?Qr:Jr;for(;o.length;){const a=o.pop();if(a.dist>=s)continue;const c=a.range1,h=a.range2;if(en(c)<=l&&en(h)<=u){if(!rn(c,t.length)||!rn(h,r.length))return NaN;if(e&&n?s=Math.min(s,mn(t,c,r,h,i)):e||n?e&&!n?s=Math.min(s,fn(r,h,t,c,i)):!e&&n&&(s=Math.min(s,fn(t,c,r,h,i))):s=Math.min(s,yn(t,c,r,h,i)),0===s)return s}else {const a=nn(c,e),l=nn(h,n);_n(o,s,i,t,r,a[0],l[0]),_n(o,s,i,t,r,a[0],l[1]),_n(o,s,i,t,r,a[1],l[0]),_n(o,s,i,t,r,a[1],l[1]);}}return s}function An(t,e,r,n,i=1/0){let a=i;const s=an(t,[0,t.length-1]);for(const i of r)if(!(a!==1/0&&on(s,an(i,[0,i.length-1]),n)>=a)&&(a=Math.min(a,Mn(t,e,i,!0,n,a)),0===a))return a;return a}function Sn(t,e,r,n,i=1/0){let a=i;const s=an(t,[0,t.length-1]);for(const i of r){if(a!==1/0&&on(s,sn(i),n)>=a)continue;const r=wn(t,e,i,n,a);if(isNaN(r))return r;if(0===(a=Math.min(a,r)))return a}return a}function In(t){return "Point"===t||"MultiPoint"===t||"LineString"===t||"MultiLineString"===t||"Polygon"===t||"MultiPolygon"===t}class Pn{constructor(t,e){this.type=De,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires either one argument, but found ' ${t.length-1} instead.`);if(rr(t[1])){const e=t[1];if("FeatureCollection"===e.type){for(let t=0;t<e.features.length;++t)if(In(e.features[t].geometry.type))return new Pn(e,e.features[t].geometry)}else if("Feature"===e.type){if(In(e.geometry.type))return new Pn(e,e.geometry)}else if(In(e.type))return new Pn(e,e)}return e.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(t){const e=t.geometry(),r=t.canonicalID();if(null!=e&&null!=r){if("Point"===t.geometryType())return function(t,e,r){const n=[];for(const r of t)for(const t of r)n.push(cn(t,e));const i=new Gr(n[0][1],"meters");return "Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type?Mn(n,!1,"Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,i):"MultiLineString"===r.type?An(n,!1,r.coordinates,i):"Polygon"===r.type||"MultiPolygon"===r.type?Sn(n,!1,"Polygon"===r.type?[r.coordinates]:r.coordinates,i):null}(e,r,this.geometries);if("LineString"===t.geometryType())return function(t,e,r){const n=[];for(const r of t){const t=[];for(const n of r)t.push(cn(n,e));n.push(t);}const i=new Gr(n[0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return An("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const a=An(r.coordinates[e],!0,n,i,t);if(isNaN(a))return a;if(0===(t=Math.min(t,a)))return t}return t}if("Polygon"===r.type||"MultiPolygon"===r.type){let t=1/0;for(let e=0;e<n.length;e++){const a=Sn(n[e],!0,"Polygon"===r.type?[r.coordinates]:r.coordinates,i,t);if(isNaN(a))return a;if(0===(t=Math.min(t,a)))return t}return t}return null}(e,r,this.geometries);if("Polygon"===t.geometryType())return function(t,e,r){const n=[];for(const r of function(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,a;for(let e=0;e<r;e++){const r=wr(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===a&&(a=r<0),a===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}return i&&n.push(i),n}(t)){const t=[];for(let n=0;n<r.length;++n)t.push(hn(r[n],e));n.push(t);}const i=new Gr(n[0][0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return Sn("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const a=Sn(r.coordinates[e],!0,n,i,t);if(isNaN(a))return a;if(0===(t=Math.min(t,a)))return t}return t}return "Polygon"===r.type||"MultiPolygon"===r.type?function(t,e,r){let n=1/0;for(const i of t)for(const t of e){const e=bn(i,t,r,n);if(isNaN(e))return e;if(0===(n=Math.min(n,e)))return n}return n}("Polygon"===r.type?[r.coordinates]:r.coordinates,n,i):null}(e,r,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return !0}serialize(){return ["distance",this.geojson]}}function zn(t,e){switch(t){case"string":return ir(e);case"number":return +e;case"boolean":return !!e;case"color":return Ie.parse(e);case"formatted":return Je.fromString(ir(e));case"resolvedImage":return tr.build(ir(e))}return e}function En(t,e,r,n){return void 0!==n&&(t=n*Math.round(t/n)),void 0!==e&&t<e&&(t=e),void 0!==r&&t>r&&(t=r),t}class kn{constructor(t,e,r){this.type=t,this.key=e,this.scope=r;}static parse(t,e){let r=e.expectedType;if(null==r&&(r=Ne),t.length<2||t.length>3)return e.error("Invalid number of arguments for 'config' expression.");const n=e.parse(t[1],1);if(!(n instanceof ar))return e.error("Key name of 'config' expression must be a string literal.");if(t.length>=3){const i=e.parse(t[2],2);return i instanceof ar?new kn(r,ir(n.value),ir(i.value)):e.error("Scope of 'config' expression must be a string literal.")}return new kn(r,ir(n.value))}evaluate(t){const e=[this.key,this.scope,t.scope].filter(Boolean).join(""),r=t.getConfig(e);if(!r)return null;const{type:n,value:i,values:a,minValue:s,maxValue:o,stepValue:l}=r,u=r.default.evaluate(t);let c=u;if(i){const e=t.scope;t.scope=(e||"").split("").slice(1).join(""),c=i.evaluate(t),t.scope=e;}return n&&(c=zn(n,c)),void 0===c||void 0===s&&void 0===o&&void 0===l||("number"==typeof c?c=En(c,s,o,l):Array.isArray(c)&&(c=c.map((t=>"number"==typeof t?En(t,s,o,l):t)))),void 0!==i&&void 0!==c&&a&&!a.includes(c)&&(c=u,n&&(c=zn(n,c))),(n&&n!==this.type||void 0!==c&&nr(c)!==this.type)&&(c=zn(this.type.kind,c)),c}eachChild(){}outputDefined(){return !1}serialize(){const t=["config",this.key];return this.scope&&t.concat(this.key),t}}function Tn(t){if(t instanceof yr){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Nr)return !1;if(t instanceof Pn)return !1;let e=!0;return t.eachChild((t=>{e&&!Tn(t)&&(e=!1);})),e}function Bn(t){if(t instanceof yr&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!Bn(t)&&(e=!1);})),e}function Cn(t){if(t instanceof kn)return new Set([t.key]);let e=new Set;return t.eachChild((t=>{e=new Set([...e,...Cn(t)]);})),e}function Vn(t,e){if(t instanceof yr&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Vn(t,e)&&(r=!1);})),r}class Dn{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Dn(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class Ln{constructor(t,e=[],r,n=new Ce,i=[],a,s){this.registry=t,this.path=e,this.key=e.map((t=>"string"==typeof t?`['${t}']`:`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r,this._scope=a,this.options=s;}parse(t,e,r,n,i={}){return e||r?this.concat(e,null,r,n)._parse(t,i):this._parse(t,i)}parseObjectValue(t,e,r,n,i,a={}){return this.concat(e,r,n,i)._parse(t,a)}_parse(t,e){function r(t,e,r){return "assert"===r?new lr(e,[t]):"coerce"===r?new fr(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n="string"==typeof t[0]?this.registry[t[0]]:void 0;if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof ar)&&"resolvedImage"!==i.type.kind&&Fn(i)){const t=new mr(this._scope,this.options);try{i=new ar(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return fr.parse(["to-array",t],this)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r,n){let i="number"==typeof t?this.path.concat(t):this.path;i="string"==typeof e?i.concat(e):i;const a=n?this.scope.concat(n):this.scope;return new Ln(this.registry,i,r||null,a,this.errors,this._scope,this.options)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Be(r,t));}checkSubtype(t,e){const r=Xe(t,e);return r&&this.error(r),r}}var Rn=Ln;function Fn(t){if(t instanceof Dn)return Fn(t.boundExpression);if(t instanceof yr&&"error"===t.name)return !1;if(t instanceof xr)return !1;if(t instanceof Nr)return !1;if(t instanceof Pn)return !1;if(t instanceof kn)return !1;const e=t instanceof fr||t instanceof lr;let r=!0;return t.eachChild((t=>{r=e?r&&Fn(t):r&&t instanceof ar;})),!!r&&Tn(t)&&Vn(t,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])}function On(t,e){const r=t.length-1;let n,i,a=0,s=r,o=0;for(;a<=s;)if(o=Math.floor((a+s)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;a=o+1;}else {if(!(n>e))throw new sr("Input is not a number.");s=o-1;}return 0}class Nn{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,De);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const a=1===r?-1/0:t[r],s=t[r+1],o=r,l=r+1;if("number"!=typeof a)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=a)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(s,l,i);if(!u)return null;i=i||u.type,n.push([a,u]);}return new Nn(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[On(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}const Un=.95047,jn=1.08883,qn=4/29,$n=6/29,Gn=3*$n*$n,Yn=$n*$n*$n,Xn=Math.PI/180,Zn=180/Math.PI;function Hn(t){return t>Yn?Math.pow(t,1/3):t/Gn+qn}function Wn(t){return t>$n?t*t*t:Gn*(t-qn)}function Kn(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Jn(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Qn(t){const e=Jn(t.r),r=Jn(t.g),n=Jn(t.b),i=Hn((.4124564*e+.3575761*r+.1804375*n)/Un),a=Hn((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*a-16,a:500*(i-a),b:200*(a-Hn((.0193339*e+.119192*r+.9503041*n)/jn)),alpha:t.a}}function ti(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Wn(e),r=Un*Wn(r),n=jn*Wn(n),new Ie(Kn(3.2404542*r-1.5371385*e-.4985314*n),Kn(-.969266*r+1.8760108*e+.041556*n),Kn(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function ei(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const ri={forward:Qn,reverse:ti,interpolate:function(t,e,r){return {l:ze(t.l,e.l,r),a:ze(t.a,e.a,r),b:ze(t.b,e.b,r),alpha:ze(t.alpha,e.alpha,r)}}},ni={forward:function(t){const{l:e,a:r,b:n}=Qn(t),i=Math.atan2(n,r)*Zn;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Xn,r=t.c;return ti({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:ei(t.h,e.h,r),c:ze(t.c,e.c,r),l:ze(t.l,e.l,r),alpha:ze(t.alpha,e.alpha,r)}}};var ii=Object.freeze({__proto__:null,hcl:ni,lab:ri});class ai{constructor(t,e,r,n,i,a){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.dynamicStops=i,this.labels=[],this.outputs=[];for(const[t,e]of a)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=si(e,t.base,r,n);else if("linear"===t.name)i=si(e,1,r,n);else if("cubic-bezier"===t.name){const a=t.controlPoints;i=new U(a[0],a[1],a[2],a[3]).solve(si(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...a]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<3)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length-1>3&&(t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,De),!i)return null;const s=[];let o=null;if("interpolate-hcl"===r||"interpolate-lab"===r?o=Fe:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType),t.length-1==3){const t=e.parse(a[0],3,Ne);return t?new ai(o,r,n,i,t,s):null}for(let t=0;t<a.length;t+=2){const r=a[t],n=a[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(s.length&&s[s.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,s.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new ai(o,r,n,i,null,s):e.error(`Type ${Ge(o)} is not interpolatable.`)}evaluate(t){let e=this.labels,r=this.outputs;if(this.dynamicStops){const n=this.dynamicStops.evaluate(t);if(n.length%2!=0)throw new sr("Expected an even number of arguments.");e=[],r=[];for(let t=0;t<n.length;t+=2){const i=n[t],a=new ar(De,n[t+1]);if("number"!=typeof i)throw new sr('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.');if(e.length&&e[e.length-1]>=i)throw new sr('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.');e.push(i),r.push(a);}if(0===e.length)throw new sr("Expected at least one input/output pair.")}if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const a=On(e,n),s=ai.interpolationFactor(this.interpolation,n,e[a],e[a+1]),o=r[a].evaluate(t),l=r[a+1].evaluate(t);return "interpolate"===this.operator?ke[this.type.kind.toLowerCase()](o,l,s):"interpolate-hcl"===this.operator?ni.reverse(ni.interpolate(ni.forward(o),ni.forward(l),s)):ri.reverse(ri.interpolate(ri.forward(o),ri.forward(l),s))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];if(this.dynamicStops)e.push(this.dynamicStops.serialize());else for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function si(t,e,r,n){const i=n-r,a=t-r;return 0===i?0:1===e?a/i:(Math.pow(e,a)-1)/(Math.pow(e,i)-1)}class oi{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const a=n&&i.some((t=>Xe(n,t.type)));return new oi(a?Ne:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof tr&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class li{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const a=e.parse(t[n+1],n+1);if(!a)return null;r.push([i,a]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new li(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class ui{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,De),n=e.parse(t[2],2,$e(e.expectedType||Ne));return r&&n?new ui(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new sr(`Array index out of bounds: ${e} < 0.`);if(e>r.length-1)throw new sr(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e===Math.floor(e))return r[e];const n=Math.floor(e),i=Math.ceil(e),a=r[n],s=r[i];if("number"!=typeof a||"number"!=typeof s)throw new sr(`Cannot interpolate between non-number values at index ${e}.`);const o=e-n;return a*(1-o)+s*o}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class ci{constructor(t,e){this.type=Re,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ne),n=e.parse(t[2],2,Ne);return r&&n?Ze(r.type,[Re,Le,De,Ve,Ne])?new ci(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ge(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!He(e,["boolean","string","number","null"]))throw new sr(`Expected first argument to be of type boolean, string, number or null, but found ${Ge(nr(e))} instead.`);if(!He(r,["string","array"]))throw new sr(`Expected second argument to be of type array or string, but found ${Ge(nr(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class hi{constructor(t,e,r){this.type=De,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ne),n=e.parse(t[2],2,Ne);if(!r||!n)return null;if(!Ze(r.type,[Re,Le,De,Ve,Ne]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ge(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,De);return i?new hi(r,n,i):null}return new hi(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!He(e,["boolean","string","number","null"]))throw new sr(`Expected first argument to be of type boolean, string, number or null, but found ${Ge(nr(e))} instead.`);if(!He(r,["string","array"]))throw new sr(`Expected second argument to be of type array or string, but found ${Ge(nr(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class pi{constructor(t,e,r,n,i,a){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=a;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},a=[];for(let s=2;s<t.length-1;s+=2){let o=t[s];const l=t[s+1];Array.isArray(o)||(o=[o]);const u=e.concat(s);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,nr(t)))return null}else r=nr(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=a.length;}const c=e.parse(l,s,n);if(!c)return null;n=n||c.type,a.push(c);}const s=e.parse(t[1],1,Ne);if(!s)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==s.type.kind&&e.concat(1).checkSubtype(r,s.type)?null:new pi(r,n,s,i,a,o):null}evaluate(t){const e=this.input.evaluate(t);return (nr(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class fi{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const a=e.parse(t[i],i,Re);if(!a)return null;const s=e.parse(t[i+1],i+1,r);if(!s)return null;n.push([a,s]),r=r||s.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new fi(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class di{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ne),n=e.parse(t[2],2,De);if(!r||!n)return null;if(!Ze(r.type,[$e(Ne),Le,Ne]))return e.error(`Expected first argument to be of type array or string, but found ${Ge(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,De);return i?new di(r.type,r,n,i):null}return new di(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!He(e,["string","array"]))throw new sr(`Expected first argument to be of type array or string, but found ${Ge(nr(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function mi(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function yi(t,e,r,n){return 0===n.compare(e,r)}function gi(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Re,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let a=e.parse(t[1],1,Ne);if(!a)return null;if(!mi(r,a.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Ge(a.type)}'.`);let s=e.parse(t[2],2,Ne);if(!s)return null;if(!mi(r,s.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Ge(s.type)}'.`);if(a.type.kind!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error(`Cannot compare types '${Ge(a.type)}' and '${Ge(s.type)}'.`);n&&("value"===a.type.kind&&"value"!==s.type.kind?a=new lr(s.type,[a]):"value"!==a.type.kind&&"value"===s.type.kind&&(s=new lr(a.type,[s])));let o=null;if(4===t.length){if("string"!==a.type.kind&&"string"!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Ue),!o)return null}return new i(a,s,o)}evaluate(i){const a=this.lhs.evaluate(i),s=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=nr(a),r=nr(s);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new sr(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=nr(a),r=nr(s);if("string"!==t.kind||"string"!==r.kind)return e(i,a,s)}return this.collator?r(i,a,s,this.collator.evaluate(i)):e(i,a,s)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const xi=gi("==",(function(t,e,r){return e===r}),yi),vi=gi("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !yi(0,e,r,n)})),bi=gi("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),_i=gi(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),wi=gi("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Mi=gi(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class Ai{constructor(t,e,r,n,i,a){this.type=Le,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=a;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,De);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parseObjectValue(n.locale,2,"locale",Le),!i))return null;let a=null;if(n.currency&&(a=e.parseObjectValue(n.currency,2,"currency",Le),!a))return null;let s=null;if(n.unit&&(s=e.parseObjectValue(n.unit,2,"unit",Le),!s))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parseObjectValue(n["min-fraction-digits"],2,"min-fraction-digits",De),!o))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parseObjectValue(n["max-fraction-digits"],2,"max-fraction-digits",De),!l)?null:new Ai(r,i,a,s,o,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class Si{constructor(t){this.type=De,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Ge(r.type)} instead.`):new Si(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new sr(`Expected value to be of type string or array, but found ${Ge(nr(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}function Ii(t){return function(){t=1831565813+(t|=0)|0;let e=Math.imul(t^t>>>15,1|t);return e=e+Math.imul(e^e>>>7,61|e)^e,((e^e>>>14)>>>0)/4294967296}}const Pi={"==":xi,"!=":vi,">":_i,"<":bi,">=":Mi,"<=":wi,array:lr,at:ui,boolean:lr,case:fi,coalesce:oi,collator:xr,format:ur,image:cr,in:ci,"index-of":hi,interpolate:ai,"interpolate-hcl":ai,"interpolate-lab":ai,length:Si,let:li,literal:ar,match:pi,number:lr,"number-format":Ai,object:lr,slice:di,step:Nn,string:lr,"to-boolean":fr,"to-color":fr,"to-number":fr,"to-string":fr,var:Dn,within:Nr,distance:Pn,config:kn};function zi(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const a=i?i.evaluate(t):1,s=er(e,r,n,a);if(s)throw new sr(s);return new Ie(e/255*a,r/255*a,n/255*a,a)}function Ei(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const a=i?i.evaluate(t):1,s=function(t,e,r,n){return "number"==typeof t&&t>=0&&t<=360?"number"==typeof e&&e>=0&&e<=100&&"number"==typeof r&&r>=0&&r<=100?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid hsla value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'h' must be between 0 and 360.`}(e,r,n,a);if(s)throw new sr(s);const o=`hsla(${e}, ${r}%, ${n}%, ${a})`,l=Ie.parse(o);if(!l)throw new sr(`Failed to parse HSLA color: ${o}`);return l}function ki(t,e){return t in e}function Ti(t,e){const r=e[t];return void 0===r?null:r}function Bi(t){return {type:t}}function Ci(t){return {result:"success",value:t}}function Vi(t){return {result:"error",value:t}}function Di(t,e){return !!t&&!!t.parameters&&t.parameters.indexOf(e)>-1}function Li(t){return "data-driven"===t["property-type"]}function Ri(t){return Di(t.expression,"measure-light")}function Fi(t){return Di(t.expression,"zoom")}function Oi(t){return !!t.expression&&t.expression.interpolated}function Ni(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Ui(t){return t}function ji(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),a=t.type||(Oi(e)?"exponential":"interval");if(r&&((t=Te({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],Ie.parse(t[1])]))),t.default=Ie.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!ii[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let s,o,l;if("exponential"===a)s=Yi;else if("interval"===a)s=Gi;else if("categorical"===a){s=$i,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==a)throw new Error(`Unknown function type "${a}"`);s=Xi;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],a=i[0].zoom;void 0===r[a]&&(r[a]={zoom:a,type:t.type,property:t.property,default:t.default,stops:[]},n.push(a)),r[a].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,ji(r[t],e)]);const a={name:"linear"};return {kind:"composite",interpolationType:a,interpolationFactor:ai.interpolationFactor.bind(void 0,a),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Yi({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===a?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:ai.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>s(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?qi(t.default,e.default):s(t,e,i,o,l)}}}function qi(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function $i(t,e,r,n,i){return qi(typeof r===i?n[r]:void 0,t.default,e.default)}function Gi(t,e,r){if("number"!==hr(r))return qi(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=On(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Yi(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==hr(r))return qi(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const a=On(t.stops.map((t=>t[0])),r),s=function(t,e,r,n){const i=n-r,a=t-r;return 0===i?0:1===e?a/i:(Math.pow(e,a)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[a][0],t.stops[a+1][0]),o=t.stops[a][1],l=t.stops[a+1][1];let u=ke[e.type]||Ui;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=ii[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),s));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,s)}}:u(o,l,s)}function Xi(t,e,r){return "color"===e.type?r=Ie.parse(r):"formatted"===e.type?r=Je.fromString(r.toString()):"resolvedImage"===e.type?r=tr.build(r.toString()):hr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),qi(r,t.default,e.default)}yr.register(Pi,{error:[{kind:"error"},[Le],(t,[e])=>{throw new sr(e.evaluate(t))}],typeof:[Le,[Ne],(t,[e])=>Ge(nr(e.evaluate(t)))],"to-rgba":[$e(De,4),[Fe],(t,[e])=>e.evaluate(t).toRenderColor(null).toArray()],"to-hsla":[$e(De,4),[Fe],(t,[e])=>e.evaluate(t).toRenderColor(null).toHslaArray()],rgb:[Fe,[De,De,De],zi],rgba:[Fe,[De,De,De,De],zi],hsl:[Fe,[De,De,De],Ei],hsla:[Fe,[De,De,De,De],Ei],has:{type:Re,overloads:[[[Le],(t,[e])=>ki(e.evaluate(t),t.properties())],[[Le,Oe],(t,[e,r])=>ki(e.evaluate(t),r.evaluate(t))]]},get:{type:Ne,overloads:[[[Le],(t,[e])=>Ti(e.evaluate(t),t.properties())],[[Le,Oe],(t,[e,r])=>Ti(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ne,[Le],(t,[e])=>Ti(e.evaluate(t),t.featureState||{})],properties:[Oe,[],t=>t.properties()],"geometry-type":[Le,[],t=>t.geometryType()],id:[Ne,[],t=>t.id()],zoom:[De,[],t=>t.globals.zoom],pitch:[De,[],t=>t.globals.pitch||0],"distance-from-center":[De,[],t=>t.distanceFromCenter()],"measure-light":[De,[Le],(t,[e])=>t.measureLight(e.evaluate(t))],"heatmap-density":[De,[],t=>t.globals.heatmapDensity||0],"line-progress":[De,[],t=>t.globals.lineProgress||0],"raster-value":[De,[],t=>t.globals.rasterValue||0],"raster-particle-speed":[De,[],t=>t.globals.rasterParticleSpeed||0],"sky-radial-progress":[De,[],t=>t.globals.skyRadialProgress||0],accumulated:[Ne,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[De,Bi(De),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[De,Bi(De),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:De,overloads:[[[De,De],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[De],(t,[e])=>-e.evaluate(t)]]},"/":[De,[De,De],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[De,[De,De],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[De,[],()=>Math.LN2],pi:[De,[],()=>Math.PI],e:[De,[],()=>Math.E],"^":[De,[De,De],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[De,[De],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[De,[De],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[De,[De],(t,[e])=>Math.log(e.evaluate(t))],log2:[De,[De],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[De,[De],(t,[e])=>Math.sin(e.evaluate(t))],cos:[De,[De],(t,[e])=>Math.cos(e.evaluate(t))],tan:[De,[De],(t,[e])=>Math.tan(e.evaluate(t))],asin:[De,[De],(t,[e])=>Math.asin(e.evaluate(t))],acos:[De,[De],(t,[e])=>Math.acos(e.evaluate(t))],atan:[De,[De],(t,[e])=>Math.atan(e.evaluate(t))],min:[De,Bi(De),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[De,Bi(De),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[De,[De],(t,[e])=>Math.abs(e.evaluate(t))],round:[De,[De],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[De,[De],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[De,[De],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Re,[Le,Ne],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Re,[Ne],(t,[e])=>t.id()===e.value],"filter-type-==":[Re,[Le],(t,[e])=>t.geometryType()===e.value],"filter-<":[Re,[Le,Ne],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Re,[Ne],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[Re,[Le,Ne],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Re,[Ne],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[Re,[Le,Ne],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Re,[Ne],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[Re,[Le,Ne],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Re,[Ne],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[Re,[Ne],(t,[e])=>e.value in t.properties()],"filter-has-id":[Re,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Re,[$e(Le)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Re,[$e(Ne)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Re,[Le,$e(Ne)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Re,[Le,$e(Ne)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Re,overloads:[[[Re,Re],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Bi(Re),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Re,overloads:[[[Re,Re],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Bi(Re),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Re,[Re],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Re,[Le],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Le,[Le],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Le,[Le],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Le,Bi(Ne),(t,e)=>e.map((e=>ir(e.evaluate(t)))).join("")],"resolved-locale":[Le,[Ue],(t,[e])=>e.evaluate(t).resolvedLocale()],random:[De,[De,De,Ne],(t,e)=>{const[r,n,i]=e.map((e=>e.evaluate(t)));if(r>n)return r;if(r===n)return r;let a;if("string"==typeof i)a=function(t){let e=0;if(0===t.length)return e;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return e}(i);else {if("number"!=typeof i)throw new sr(`Invalid seed input: ${i}`);a=i;}return r+Ii(a)()*(n-r)}]});class Zi{constructor(t,e,r,n){this.expression=t,this._warningHistory={},this._evaluator=new mr(r,n),this._defaultValue=e?function(t){return "color"===t.type&&(Ni(t.default)||Array.isArray(t.default))?new Ie(0,0,0,0):"color"===t.type?Ie.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this.configDependencies=Cn(t);}evaluateWithoutErrorHandling(t,e,r,n,i,a,s,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=a,this._evaluator.featureTileCoord=s||null,this._evaluator.featureDistanceData=o||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,a,s,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=a||null,this._evaluator.featureTileCoord=s||null,this._evaluator.featureDistanceData=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new sr(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(`Failed to evaluate expression "${JSON.stringify(this.expression.serialize())}". ${t.message}`)),this._defaultValue}}}function Hi(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Pi}function Wi(t,e,r,n){const i=new Rn(Pi,[],e?function(t){const e={color:Fe,string:Le,number:De,enum:Le,boolean:Re,formatted:je,resolvedImage:qe};return "array"===t.type?$e(e[t.value]||Ne,t.length):e[t.type]}(e):void 0,void 0,void 0,r,n),a=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return a?Ci(new Zi(a,e,r,n)):Vi(i.errors)}class Ki{constructor(t,e,r,n){this.kind=t,this._styleExpression=e,this.isLightConstant=r,this.isLineProgressConstant=n,this.isStateDependent="constant"!==t&&!Bn(e.expression),this.configDependencies=Cn(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,a)}evaluate(t,e,r,n,i,a){return this._styleExpression.evaluate(t,e,r,n,i,a)}}class Ji{constructor(t,e,r,n,i,a){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Bn(e.expression),this.isLightConstant=i,this.isLineProgressConstant=a,this.configDependencies=Cn(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,a)}evaluate(t,e,r,n,i,a){return this._styleExpression.evaluate(t,e,r,n,i,a)}interpolationFactor(t,e,r){return this.interpolationType?ai.interpolationFactor(this.interpolationType,t,e,r):0}}function Qi(t,e,r,n){if("error"===(t=Wi(t,e,r,n)).result)return t;const i=t.value.expression,a=Tn(i);if(!a&&!Li(e))return Vi([new Be("","data expressions not supported")]);const s=Vn(i,["zoom","pitch","distance-from-center"]);if(!s&&!Fi(e))return Vi([new Be("","zoom expressions not supported")]);const o=Vn(i,["measure-light"]);if(!o&&!Ri(e))return Vi([new Be("","measure-light expression not supported")]);const l=Vn(i,["line-progress"]);if(!l&&!function(t){return Di(t.expression,"line-progress")}(e))return Vi([new Be("","line-progress expression not supported")]);const u=e.expression&&e.expression.relaxZoomRestriction,c=ea(i);return c||s||u?c instanceof Be?Vi([c]):c instanceof ai&&!Oi(e)?Vi([new Be("",'"interpolate" expressions cannot be used with this property')]):Ci(c?new Ji(a&&l?"camera":"composite",t.value,c.labels,c instanceof ai?c.interpolation:void 0,o,l):new Ki(a&&l?"constant":"source",t.value,o,l)):Vi([new Be("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class ta{constructor(t,e){this._parameters=t,this._specification=e,Te(this,ji(this._parameters,this._specification));}static deserialize(t){return new ta(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function ea(t){let e=null;if(t instanceof li)e=ea(t.result);else if(t instanceof oi){for(const r of t.args)if(e=ea(r),e)break}else (t instanceof Nn||t instanceof ai)&&t.input instanceof yr&&"zoom"===t.input.name&&(e=t);return e instanceof Be||t.eachChild((t=>{const r=ea(t);r instanceof Be?e=r:e&&r&&e!==r&&(e=new Be("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}var ra,na,ia=function(){if(na)return ra;na=1,ra=e;var t=3;function e(e,r,n){var i=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;var a=new Int32Array(this.arrayBuffer);e=a[0],this.d=(r=a[1])+2*(n=a[2]);for(var s=0;s<this.d*this.d;s++){var o=a[t+s],l=a[t+s+1];i.push(o===l?null:a.subarray(o,l));}var u=a[t+i.length+1];this.keys=a.subarray(a[t+i.length],u),this.bboxes=a.subarray(u),this.insert=this._insertReadonly;}else {this.d=r+2*n;for(var c=0;c<this.d*this.d;c++)i.push([]);this.keys=[],this.bboxes=[];}this.n=r,this.extent=e,this.padding=n,this.scale=r/e,this.uid=0;var h=n/r*e;this.min=-h,this.max=e+h;}return e.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},e.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},e.prototype._insertCell=function(t,e,r,n,i,a){this.cells[i].push(a);},e.prototype.query=function(t,e,r,n,i){var a=this.min,s=this.max;if(t<=a&&e<=a&&s<=r&&s<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},e.prototype._queryCell=function(t,e,r,n,i,a,s,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===s[p]){var f=4*p;(o?o(c[f+0],c[f+1],c[f+2],c[f+3]):t<=c[f+2]&&e<=c[f+3]&&r>=c[f+0]&&n>=c[f+1])?(s[p]=!0,a.push(u[p])):s[p]=!1;}}},e.prototype._forEachCell=function(t,e,r,n,i,a,s,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var f=u;f<=h;f++){var d=this.d*f+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(f),this._convertFromCellCoord(p+1),this._convertFromCellCoord(f+1)))&&i.call(this,t,e,r,n,d,a,s,o))return}},e.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},e.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},e.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var e=this.cells,r=t+this.cells.length+1+1,n=0,i=0;i<this.cells.length;i++)n+=this.cells[i].length;var a=new Int32Array(r+n+this.keys.length+this.bboxes.length);a[0]=this.extent,a[1]=this.n,a[2]=this.padding;for(var s=r,o=0;o<e.length;o++){var l=e[o];a[t+o]=s,a.set(l,s),s+=l.length;}return a[t+e.length]=s,a.set(this.keys,s),a[t+e.length+1]=s+=this.keys.length,a.set(this.bboxes,s),s+=this.bboxes.length,a.buffer},ra}(),aa=e(ia);const sa={};function oa(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writable:!1}),sa[e]={klass:t,omit:r.omit||[]};}oa(Object,"Object"),aa.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.add(r),{buffer:r}},aa.deserialize=function(t){return new aa(t.buffer)},Object.defineProperty(aa,"name",{value:"Grid"}),oa(aa,"Grid"),"undefined"!=typeof DOMMatrix&&oa(DOMMatrix,"DOMMatrix"),oa(Ie,"Color"),oa(Error,"Error"),oa(Je,"Formatted"),oa(Ke,"FormattedSection"),oa(ee,"AJAXError"),oa(tr,"ResolvedImage"),oa(ta,"StylePropertyFunction"),oa(Zi,"StyleExpression",{omit:["_evaluator"]}),oa(Qe,"ImageIdWithOptions"),oa(Ji,"ZoomDependentExpression"),oa(Ki,"ZoomConstantExpression"),oa(yr,"CompoundExpression",{omit:["_evaluate"]});for(const t in Pi)sa[Pi[t]._classRegistryKey]||oa(Pi[t],`Expression${t}`);function la(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function ua(t){return self.ImageBitmap&&t instanceof ImageBitmap}function ca(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(la(t)||ua(t))return e&&e.add(t),t;if(ArrayBuffer.isView(t))return e&&e.add(t.buffer),t;if(t instanceof ImageData)return e&&e.add(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(ca(n,e));return r}if(t instanceof Map){const e={$name:"Map"};for(const[r,n]of t.entries())e[r]=ca(n);return e}if(t instanceof Set){const e={$name:"Set"};let r=0;for(const n of t.values())e[++r]=ca(n);return e}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`Can't serialize object of unregistered class "${n}".`);const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t)t.hasOwnProperty(r)&&(sa[n].omit.indexOf(r)>=0||(i[r]=ca(t[r],e)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function ha(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||la(t)||ua(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(ha);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=new Map;for(const r of Object.keys(t))"$name"!==r&&e.set(r,ha(t[r]));return e}if("Set"===e){const e=new Set;for(const r of Object.keys(t))"$name"!==r&&e.add(ha(t[r]));return e}const{klass:r}=sa[e];if(!r)throw new Error(`Can't deserialize unregistered class "${e}".`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=ha(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const pa={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519,Osage:t=>t>=66736&&t<=66815,"CJK Unified Ideographs Extension B":t=>t>=131072&&t<=173791};function fa(t){for(const e of t)if(ya(e.charCodeAt(0)))return !0;return !1}function da(t){for(const e of t)if(!ma(e.charCodeAt(0)))return !1;return !0}function ma(t){return !(pa.Arabic(t)||pa["Arabic Supplement"](t)||pa["Arabic Extended-A"](t)||pa["Arabic Presentation Forms-A"](t)||pa["Arabic Presentation Forms-B"](t))}function ya(t){return !(746!==t&&747!==t&&(t<4352||!(pa["Bopomofo Extended"](t)||pa.Bopomofo(t)||pa["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||pa["CJK Compatibility Ideographs"](t)||pa["CJK Compatibility"](t)||pa["CJK Radicals Supplement"](t)||pa["CJK Strokes"](t)||!(!pa["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||pa["CJK Unified Ideographs Extension A"](t)||pa["CJK Unified Ideographs"](t)||pa["Enclosed CJK Letters and Months"](t)||pa["Hangul Compatibility Jamo"](t)||pa["Hangul Jamo Extended-A"](t)||pa["Hangul Jamo Extended-B"](t)||pa["Hangul Jamo"](t)||pa["Hangul Syllables"](t)||pa.Hiragana(t)||pa["Ideographic Description Characters"](t)||pa.Kanbun(t)||pa["Kangxi Radicals"](t)||pa["Katakana Phonetic Extensions"](t)||pa.Katakana(t)&&12540!==t||!(!pa["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!pa["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||pa["Unified Canadian Aboriginal Syllabics"](t)||pa["Unified Canadian Aboriginal Syllabics Extended"](t)||pa["Vertical Forms"](t)||pa["Yijing Hexagram Symbols"](t)||pa["Yi Syllables"](t)||pa["Yi Radicals"](t))))}function ga(t){return !(ya(t)||function(t){return !!(pa["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||pa["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||pa["Letterlike Symbols"](t)||pa["Number Forms"](t)||pa["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||pa["Control Pictures"](t)&&9251!==t||pa["Optical Character Recognition"](t)||pa["Enclosed Alphanumerics"](t)||pa["Geometric Shapes"](t)||pa["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||pa["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||pa["CJK Symbols and Punctuation"](t)||pa.Katakana(t)||pa["Private Use Area"](t)||pa["CJK Compatibility Forms"](t)||pa["Small Form Variants"](t)||pa["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function xa(t){return t>=1424&&t<=2303||pa["Arabic Presentation Forms-A"](t)||pa["Arabic Presentation Forms-B"](t)}function va(t,e){return !(!e&&xa(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||pa.Khmer(t))}function ba(t){for(const e of t)if(xa(e.charCodeAt(0)))return !0;return !1}const _a="deferred",wa="loading",Ma="loaded";let Aa=null,Sa="unavailable",Ia=null;const Pa=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Sa="error"),Aa&&Aa(t);};function za(){Ea.fire(new xe("pluginStateChange",{pluginStatus:Sa,pluginURL:Ia}));}const Ea=new we,ka=function(){return Sa},Ta=function(){if(Sa!==_a||!Ia)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Sa=wa,za(),Ia&&ie({url:Ia},(t=>{t?Pa(t):(Sa=Ma,za());}));},Ba={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Sa===Ma||null!=Ba.applyArabicShaping,isLoading:()=>Sa===wa,setState(t){Sa=t.pluginStatus,Ia=t.pluginURL;},isParsed:()=>null!=Ba.applyArabicShaping&&null!=Ba.processBidirectionalText&&null!=Ba.processStyledBidirectionalText,getPluginURL:()=>Ia};class Ca{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch,this.brightness=e.brightness):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!va(r.charCodeAt(0),e))return !1;return !0}(t,Ba.isLoaded())}}class Va{constructor(t,e,r,n){this.property=t,this.value=e,this.expression=function(t,e,r,n){if(Ni(t))return new ta(t,e);if(Hi(t)||Array.isArray(t)&&t.length>0){const i=Qi(t,e,r,n);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=Ie.parse(t)),{kind:"constant",configDependencies:new Set,evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r,n);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Da{constructor(t,e,r){this.property=t,this.value=new Va(t,void 0,e,r);}transitioned(t,e){return new Ra(this.property,this.value,e,nt({},t.transition,this.transition),t.now)}untransitioned(){return new Ra(this.property,this.value,null,{},0)}}class La{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._scope=e,this._options=r,this.configDependencies=new Set;}getValue(t){return ht(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Da(this._values[t].property,this._scope,this._options)),this._values[t].value=new Va(this._values[t].property,null===e?void 0:ht(e),this._scope,this._options),this._values[t].value.expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].value.expression.configDependencies]));}setTransitionOrValue(t,e){e&&(this._options=e);const r=this._properties.properties;if(t)for(const e in t){const n=t[e];if(lt(e,"-transition")){const t=e.slice(0,-11);r[t]&&this.setTransition(t,n);}else r.hasOwnProperty(e)&&this.setValue(e,n);}}getTransition(t){return ht(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Da(this._values[t].property)),this._values[t].transition=ht(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Fa(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Fa(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Ra{constructor(t,e,r,n,i){const a=n.delay||0,s=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+a,this.end=this.begin+s,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),a=this.prior;if(a){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return a.possiblyEvaluate(t,e,r);{const s=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(a.possiblyEvaluate(t,e,r),i,W(s))}}return i}}class Fa{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Ua(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Oa{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._scope=e,this._options=r,this.configDependencies=new Set;}getValue(t){return ht(this._values[t].value)}setValue(t,e){this._values[t]=new Va(this._values[t].property,null===e?void 0:ht(e),this._scope,this._options),this._values[t].expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].expression.configDependencies]));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Ua(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Na{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Ua{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class ja{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=ke[this.specification.type];return n?n(t,e,r):t}}class qa{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Na(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Na(this,{kind:"constant",value:void 0},t.parameters);const n=ke[this.specification.type];return n?new Na(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,a){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,a)}}class $a{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Ga{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new Ca(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new Va(n,void 0),a=this.defaultTransitionablePropertyValues[r]=new Da(n);this.defaultTransitioningPropertyValues[r]=a.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}oa(qa,"DataDrivenProperty"),oa(ja,"DataConstantProperty"),oa($a,"ColorRampProperty");var Ya=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"required":false,"type":"array","value":"light-3d"},"terrain":{"type":"terrain","optional":true},"fog":{"type":"fog"},"snow":{"type":"snow","experimental":true},"rain":{"type":"rain","experimental":true},"camera":{"type":"camera"},"color-theme":{"type":"colorTheme"},"indoor":{"type":"indoor","experimental":true},"imports":{"type":"array","value":"import"},"schema":{"type":"schema"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"},"models":{"type":"models"},"featuresets":{"experimental":true,"type":"featuresets"}},"featuresets":{"experimental":true,"*":{"type":"featureset"}},"featureset":{"experimental":true,"metadata":{"experimental":true,"type":"*"},"selectors":{"experimental":true,"type":"array","value":"selector"}},"selector":{"experimental":true,"layer":{"experimental":true,"type":"string","required":true},"properties":{"experimental":true,"type":"selectorProperty","required":false},"featureNamespace":{"experimental":true,"type":"string","required":false},"_uniqueFeatureID":{"experimental":true,"type":"boolean","private":true,"required":false}},"selectorProperty":{"experimental":true,"*":{"experimental":true,"type":"*"}},"model":{"type":"string","required":true},"import":{"id":{"type":"string","required":true},"url":{"type":"string","required":true},"config":{"type":"config"},"data":{"type":"$root"},"color-theme":{"type":"colorTheme","optional":true}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","property-type":"data-constant","expression":{},"required":true},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string","required":true},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false,"property-type":"data-constant"},"shadow-quality":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"parameters":["zoom"]},"experimental":true},"shadow-intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_raster_array","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_array":{"experimental":true,"type":{"required":true,"type":"enum","values":{"raster-array":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"rasterLayers":{"type":"*"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"},"dynamic":{"type":"boolean","default":false}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":1}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":1}},"url":{"required":false,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"required":true,"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"raster-particle":{"experimental":true},"hillshade":{},"model":{"experimental":true},"background":{},"sky":{},"slot":{},"clip":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_clip","layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_raster-particle","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_clip":{"clip-layer-types":{"type":"array","value":"enum","values":{"model":1,"symbol":1},"default":[],"expression":{},"property-type":"data-constant"},"clip-layer-scope":{"type":"array","value":"string","default":[],"expression":{},"property-type":"data-constant"}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-base":1,"hd-road-markup":1},"default":"none","experimental":true,"private":true,"expression":{},"property-type":"data-constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"circle-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-markup":1},"default":"none","experimental":true,"expression":{},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","experimental":true,"default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1,"none":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-z-offset":{"type":"number","experimental":true,"default":0,"expression":{"parameters":["zoom","feature","line-progress"]},"property-type":"data-driven"},"line-elevation-reference":{"type":"enum","values":{"none":1,"sea":1,"ground":1,"hd-road-markup":1},"default":"none","experimental":true,"expression":{},"property-type":"data-constant"},"line-cross-slope":{"type":"number","experimental":true,"expression":{},"property-type":"constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"line-width-unit":{"type":"enum","values":{"pixels":1,"meters":1},"default":"pixels","experimental":true,"private":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-elevation-reference":{"type":"enum","values":{"sea":1,"ground":1,"hd-road-markup":1},"default":"ground","experimental":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":0.1,"maximum":10,"experimental":true,"private":true,"expression":{},"property-type":"data-constant"},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":0.1,"maximum":10,"experimental":true,"private":true,"expression":{},"property-type":"data-constant"},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster-particle":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_hillshade":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster-particle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_clip":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_model":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"snow":{"density":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,0.85],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"opacity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,0.3],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","property-type":"data-constant","default":"#ffffff","experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"center-thinning":{"type":"number","property-type":"data-constant","default":0.4,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,50],"minimum":0,"maximum":360,"length":2,"value":"number","property-type":"data-constant","transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"flake-size":{"type":"number","property-type":"data-constant","default":0.71,"minimum":0,"maximum":5,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"rain":{"density":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,0.5],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["measure-light","brightness"],0,"#03113d",0.3,"#a8adbc"],"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"opacity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["measure-light","brightness"],0,0.88,1,0.7],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,1],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["measure-light","brightness"],0,"#001736",0.3,"#464646"],"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"center-thinning":{"type":"number","property-type":"data-constant","default":0.57,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,80],"minimum":0,"maximum":360,"length":2,"value":"number","property-type":"data-constant","transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"droplet-size":{"type":"array","default":[2.6,18.2],"minimum":0,"maximum":50,"length":2,"value":"number","property-type":"data-constant","transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"distortion-strength":{"type":"number","property-type":"data-constant","default":0.7,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective","property-type":"data-constant"}},"colorTheme":{"data":{"type":"string","property-type":"data-constant","expression":{}}},"indoor":{"floorplanFeaturesetId":{"type":"string","experimental":true,"property-type":"data-constant","expression":{}},"buildingFeaturesetId":{"type":"string","experimental":true,"property-type":"data-constant","expression":{}}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_raster-particle","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"fill-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-height-alignment":{"type":"enum","experimental":true,"values":{"terrain":1,"flat":1},"default":"flat","property-type":"data-constant"},"fill-extrusion-base-alignment":{"type":"enum","experimental":true,"values":{"terrain":1,"flat":1},"default":"terrain","property-type":"data-constant"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"property-type":"data-constant","type":"number","experimental":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"property-type":"data-constant","type":"number","experimental":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"property-type":"data-constant","type":"number","experimental":true,"default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"property-type":"data-constant","type":"color","experimental":true,"default":"#ffffff","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"property-type":"data-constant","type":"number","experimental":true,"default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","experimental":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","experimental":true,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"property-type":"data-constant","type":"number","experimental":true,"default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"property-type":"data-constant","type":"number","experimental":true,"default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"property-type":"data-constant","type":"boolean","default":true,"experimental":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"fill-extrusion-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"fill-extrusion-line-width":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-cast-shadows":{"type":"boolean","default":true,"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light","line-progress"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"property-type":"constant"},"line-trim-fade-range":{"type":"array","value":"number","experimental":true,"length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-trim-color":{"type":"color","experimental":true,"default":"transparent","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-border-width":{"type":"number","private":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","private":true,"default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-occlusion-opacity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"property-type":"data-constant"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-image-cross-fade":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"transition":true},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-color-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"symbol-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-value"]},"property-type":"color-ramp"},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"raster-array-band":{"type":"string","required":false,"experimental":true,"property-type":"data-constant"},"raster-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster-particle":{"raster-particle-array-band":{"type":"string","required":false,"property-type":"data-constant"},"raster-particle-count":{"type":"number","default":512,"minimum":1,"property-type":"data-constant"},"raster-particle-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-particle-speed"]},"property-type":"color-ramp"},"raster-particle-max-speed":{"type":"number","default":1,"minimum":1,"property-type":"data-constant"},"raster-particle-speed-factor":{"type":"number","default":0.2,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-fade-opacity-factor":{"type":"number","default":0.98,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-reset-rate-factor":{"type":"number","default":0.8,"minimum":0,"maximum":1,"property-type":"data-constant"},"raster-particle-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_background":{"background-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":[]},"experimental":true,"property-type":"data-constant"},"background-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"property-type":"data-driven"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d","property-type":"data-constant"},"model-cast-shadows":{"type":"boolean","default":true,"property-type":"data-constant"},"model-receive-shadows":{"type":"boolean","default":true,"property-type":"data-constant"},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant","transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"model-front-cutoff":{"type":"array","private":true,"value":"number","property-type":"data-constant","expression":{"interpolated":true,"parameters":["zoom"]},"length":3,"default":[0,0,1],"minimum":[0,0,0],"maximum":[1,1,1]}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"*"}}}');function Xa(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Za(t){if(Array.isArray(t))return t.map(Za);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Za(t[r]);return e}return Xa(t)}function Ha(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!Ha(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function Wa(t,e="",r=null,n="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};Ha(t)||(t=ns(t));const i=t;let a=!0;try{a=function(t){if(!Qa(t))return t;let e=Za(t);return Ja(e),e=Ka(e),e}(i);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(i,null,2)}\n        `);}let s=null,o=null;if("background"!==n&&"sky"!==n&&"slot"!==n){o=Ya[`filter_${n}`];const t=Wi(a,o,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));s=(e,r,n)=>t.value.evaluate(e,r,{},n);}let l=null,u=null;if(a!==i){const t=Wi(i,o,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));l=(e,r,n,i,a)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,a),u=!Tn(t.value.expression);}return {filter:s,dynamicFilter:l||void 0,needGeometry:rs(a),needFeature:!!u}}function Ka(t){if(!Array.isArray(t))return t;const e=function(t){if(ts.has(t[0]))for(let e=1;e<t.length;e++)if(Qa(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>Ka(t)))}function Ja(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||Qa(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||Qa(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||Qa(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)Ja(t[e]);}function Qa(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(Qa(t[e]))return !0;return !1}const ts=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function es(t,e){return t<e?-1:t>e?1:0}function rs(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(rs(t[e]))return !0;return !1}function ns(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?is(t[1],t[2],"=="):"!="===e?os(is(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?is(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(ns))):"all"===e?["all"].concat(t.slice(1).map(ns)):"none"===e?["all"].concat(t.slice(1).map(ns).map(os)):"in"===e?as(t[1],t.slice(2)):"!in"===e?os(as(t[1],t.slice(2))):"has"===e?ss(t[1]):"!has"!==e||os(ss(t[1]));var r;}function is(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function as(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(es)]]:["filter-in-small",t,["literal",e]]}}function ss(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function os(t){return ["!",t]}const ls="";function us(t,e){return e?`${t}${ls}${e}`:t}const cs="-transition",hs=new Set(["fill","line","background","hillshade","raster"]);class ps extends we{constructor(t,e,r,n,i){if(super(),this.id=t.id,this.fqid=us(this.id,r),this.type=t.type,this.scope=r,this.lut=n,this.options=i,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.configDependencies=new Set,"custom"!==t.type){if(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,t.type&&"background"!==t.type&&"sky"!==t.type&&"slot"!==t.type){this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter;const e=Wi(this.filter,Ya[`filter_${t.type}`]);"error"!==e.result&&(this.configDependencies=new Set([...this.configDependencies,...e.value.configDependencies]));}if(t.slot&&(this.slot=t.slot),e.layout&&(this._unevaluatedLayout=new Oa(e.layout,this.scope,i),this.configDependencies=new Set([...this.configDependencies,...this._unevaluatedLayout.configDependencies])),e.paint){this._transitionablePaint=new La(e.paint,this.scope,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e]);for(const e in t.layout)this.setLayoutProperty(e,t.layout[e]);this.configDependencies=new Set([...this.configDependencies,...this._transitionablePaint.configDependencies]),this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Ua(e.paint);}}}onAdd(t){}onRemove(t){}isDraped(t){return !this.is3D()&&hs.has(this.type)}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e){if("custom"===this.type&&"visibility"===t)return void(this.visibility=e);const r=this._unevaluatedLayout;r._properties.properties[t]&&(r.setValue(t,e),this.configDependencies=new Set([...this.configDependencies,...r.configDependencies]),"visibility"===t&&this.possiblyEvaluateVisibility());}possiblyEvaluateVisibility(){this._unevaluatedLayout._values.visibility&&(this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0}));}getPaintProperty(t){return lt(t,cs)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e){const r=this._transitionablePaint,n=r._properties.properties;if(lt(t,cs)){const i=t.slice(0,-11);return n[i]&&r.setTransition(i,e||void 0),!1}if(!n[t])return !1;const i=r._values[t],a=i.value.isDataDriven(),s=i.value;r.setValue(t,e),this.configDependencies=new Set([...this.configDependencies,...r.configDependencies]),this._handleSpecialPaintPropertyUpdate(t);const o=r._values[t].value,l=o.isDataDriven(),u=lt(t,"pattern")||"line-dasharray"===t;return l||a||u||this._handleOverridablePaintPropertyUpdate(t,s,o)}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getDefaultProgramParams(t,e,r){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){return ct({id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()},((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}hasShadowPass(){return !1}canCastShadows(){return !1}hasLightBeamPass(){return !1}cutoffRange(){return 0}tileCoverLift(){return 0}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Na&&Li(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(t){this._filterCompiled||(this._featureFilter=Wa(this.filter,this.scope,t),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}getLayerRenderingStats(){return this._stats}resetLayerRenderingStats(t){this._stats&&("shadow"===t.renderPass?this._stats.numRenderedVerticesInShadowPass=0:this._stats.numRenderedVerticesInTransparentPass=0);}queryRadius(t){}queryIntersectsFeature(t,e,r,n,i,a,s,o,l){}}const fs={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ds{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class ms{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.add(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("StructArray#_refreshViews() must be implemented by each concrete StructArray layout")}emplace(...t){throw new Error("StructArray#emplace() must be implemented by each concrete StructArray layout")}emplaceBack(...t){throw new Error("StructArray#emplaceBack() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function ys(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=fs[t.type].BYTES_PER_ELEMENT,a=r=gs(r,Math.max(e,i)),s=t.components||1;return n=Math.max(n,i),r+=i*s,{name:t.name,type:t.type,components:s,offset:a}})),size:gs(r,Math.max(n,e)),alignment:e}}function gs(t,e){return Math.ceil(t/e)*e}class xs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}xs.prototype.bytesPerElement=4,oa(xs,"StructArrayLayout2i4");class vs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}vs.prototype.bytesPerElement=6,oa(vs,"StructArrayLayout3i6");class bs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,t}}bs.prototype.bytesPerElement=8,oa(bs,"StructArrayLayout4i8");class _s extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=5*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,this.int16[s+4]=a,t}}_s.prototype.bytesPerElement=10,oa(_s,"StructArrayLayout5i10");class ws extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=a,this.uint8[u+7]=s,this.float32[c+2]=o,t}}ws.prototype.bytesPerElement=12,oa(ws,"StructArrayLayout2i4ub1f12");class Ms extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ms.prototype.bytesPerElement=12,oa(Ms,"StructArrayLayout3f12");class As extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=6*t,o=3*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,this.float32[o+2]=a,t}}As.prototype.bytesPerElement=12,oa(As,"StructArrayLayout4ui1f12");class Ss extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.uint16[a+0]=e,this.uint16[a+1]=r,this.uint16[a+2]=n,this.uint16[a+3]=i,t}}Ss.prototype.bytesPerElement=8,oa(Ss,"StructArrayLayout4ui8");class Is extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=a,this.int16[o+5]=s,t}}Is.prototype.bytesPerElement=12,oa(Is,"StructArrayLayout6i12");class Ps extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,a,s,o,l,u,c,h)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=a,this.uint16[f+5]=s,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}Ps.prototype.bytesPerElement=24,oa(Ps,"StructArrayLayout4i4ui4i24");class zs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=10*t,l=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.float32[l+2]=i,this.float32[l+3]=a,this.float32[l+4]=s,t}}zs.prototype.bytesPerElement=20,oa(zs,"StructArrayLayout3i3f20");class Es extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,t}}Es.prototype.bytesPerElement=16,oa(Es,"StructArrayLayout4f16");class ks extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ks.prototype.bytesPerElement=4,oa(ks,"StructArrayLayout1ul4");class Ts extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ts.prototype.bytesPerElement=4,oa(Ts,"StructArrayLayout2ui4");class Bs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,i,a,s,o,l,u,c,h,p)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f){const d=20*t,m=10*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.int16[d+4]=a,this.float32[m+3]=s,this.float32[m+4]=o,this.float32[m+5]=l,this.float32[m+6]=u,this.int16[d+14]=c,this.uint32[m+8]=h,this.uint16[d+18]=p,this.uint16[d+19]=f,t}}Bs.prototype.bytesPerElement=40,oa(Bs,"StructArrayLayout5i4f1i1ul2ui40");class Cs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=a,this.int16[l+6]=s,this.int16[l+7]=o,t}}Cs.prototype.bytesPerElement=16,oa(Cs,"StructArrayLayout3i2i2i16");class Vs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=4*t,o=8*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.int16[o+6]=i,this.int16[o+7]=a,t}}Vs.prototype.bytesPerElement=16,oa(Vs,"StructArrayLayout2f1f2i16");class Ds extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=20*t,l=5*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.float32[l+3]=a,this.float32[l+4]=s,t}}Ds.prototype.bytesPerElement=20,oa(Ds,"StructArrayLayout2ub4f20");class Ls extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Ls.prototype.bytesPerElement=6,oa(Ls,"StructArrayLayout3ui6");class Rs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b){const _=this.length;return this.resize(_+1),this.emplace(_,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_){const w=30*t,M=15*t,A=60*t;return this.int16[w+0]=e,this.int16[w+1]=r,this.int16[w+2]=n,this.float32[M+2]=i,this.float32[M+3]=a,this.uint16[w+8]=s,this.uint16[w+9]=o,this.uint32[M+5]=l,this.uint32[M+6]=u,this.uint32[M+7]=c,this.uint16[w+16]=h,this.uint16[w+17]=p,this.uint16[w+18]=f,this.float32[M+10]=d,this.float32[M+11]=m,this.uint8[A+48]=y,this.uint8[A+49]=g,this.uint8[A+50]=x,this.uint32[M+13]=v,this.int16[w+28]=b,this.uint8[A+58]=_,t}}Rs.prototype.bytesPerElement=60,oa(Rs,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class Fs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,P,z,E,k,T){const B=this.length;return this.resize(B+1),this.emplace(B,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,P,z,E,k,T)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,P,z,E,k,T,B){const C=20*t,V=40*t,D=80*t;return this.float32[C+0]=e,this.float32[C+1]=r,this.int16[V+4]=n,this.int16[V+5]=i,this.int16[V+6]=a,this.int16[V+7]=s,this.int16[V+8]=o,this.int16[V+9]=l,this.int16[V+10]=u,this.int16[V+11]=c,this.int16[V+12]=h,this.uint16[V+13]=p,this.uint16[V+14]=f,this.uint16[V+15]=d,this.uint16[V+16]=m,this.uint16[V+17]=y,this.uint16[V+18]=g,this.uint16[V+19]=x,this.uint16[V+20]=v,this.uint16[V+21]=b,this.uint16[V+22]=_,this.uint16[V+23]=w,this.uint16[V+24]=M,this.uint16[V+25]=A,this.uint16[V+26]=S,this.uint16[V+27]=I,this.uint32[C+14]=P,this.float32[C+15]=z,this.float32[C+16]=E,this.float32[C+17]=k,this.float32[C+18]=T,this.uint8[D+76]=B,t}}Fs.prototype.bytesPerElement=80,oa(Fs,"StructArrayLayout2f9i15ui1ul4f1ub80");class Os extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Os.prototype.bytesPerElement=4,oa(Os,"StructArrayLayout1f4");class Ns extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=5*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,this.float32[s+4]=a,t}}Ns.prototype.bytesPerElement=20,oa(Ns,"StructArrayLayout5f20");class Us extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=a,this.float32[l+5]=s,this.float32[l+6]=o,t}}Us.prototype.bytesPerElement=28,oa(Us,"StructArrayLayout7f28");class js extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,r,n,i,a,s,o,l,u,c)}emplace(t,e,r,n,i,a,s,o,l,u,c,h){const p=11*t;return this.float32[p+0]=e,this.float32[p+1]=r,this.float32[p+2]=n,this.float32[p+3]=i,this.float32[p+4]=a,this.float32[p+5]=s,this.float32[p+6]=o,this.float32[p+7]=l,this.float32[p+8]=u,this.float32[p+9]=c,this.float32[p+10]=h,t}}js.prototype.bytesPerElement=44,oa(js,"StructArrayLayout11f44");class qs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,a,s,o,l)}emplace(t,e,r,n,i,a,s,o,l,u){const c=9*t;return this.float32[c+0]=e,this.float32[c+1]=r,this.float32[c+2]=n,this.float32[c+3]=i,this.float32[c+4]=a,this.float32[c+5]=s,this.float32[c+6]=o,this.float32[c+7]=l,this.float32[c+8]=u,t}}qs.prototype.bytesPerElement=36,oa(qs,"StructArrayLayout9f36");class $s extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}$s.prototype.bytesPerElement=8,oa($s,"StructArrayLayout2f8");class Gs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=6*t;return this.uint32[3*t+0]=e,this.uint16[a+2]=r,this.uint16[a+3]=n,this.uint16[a+4]=i,t}}Gs.prototype.bytesPerElement=12,oa(Gs,"StructArrayLayout1ul3ui12");class Ys extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Ys.prototype.bytesPerElement=2,oa(Ys,"StructArrayLayout1ui2");class Xs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m){const y=this.length;return this.resize(y+1),this.emplace(y,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y){const g=16*t;return this.float32[g+0]=e,this.float32[g+1]=r,this.float32[g+2]=n,this.float32[g+3]=i,this.float32[g+4]=a,this.float32[g+5]=s,this.float32[g+6]=o,this.float32[g+7]=l,this.float32[g+8]=u,this.float32[g+9]=c,this.float32[g+10]=h,this.float32[g+11]=p,this.float32[g+12]=f,this.float32[g+13]=d,this.float32[g+14]=m,this.float32[g+15]=y,t}}Xs.prototype.bytesPerElement=64,oa(Xs,"StructArrayLayout16f64");class Zs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=10*t,u=5*t;return this.uint16[l+0]=e,this.uint16[l+1]=r,this.uint16[l+2]=n,this.uint16[l+3]=i,this.float32[u+2]=a,this.float32[u+3]=s,this.float32[u+4]=o,t}}Zs.prototype.bytesPerElement=20,oa(Zs,"StructArrayLayout4ui3f20");class Hs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.int16[1*t+0]=e,t}}Hs.prototype.bytesPerElement=2,oa(Hs,"StructArrayLayout1i2");class Ws extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint8[1*t+0]=e,t}}Ws.prototype.bytesPerElement=1,oa(Ws,"StructArrayLayout1ub1");class Ks extends ds{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}Ks.prototype.size=40;class Js extends Bs{get(t){return new Ks(this,t)}}oa(Js,"CollisionBoxArray");class Qs extends ds{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}Qs.prototype.size=60;class to extends Rs{get(t){return new Qs(this,t)}}oa(to,"PlacedSymbolArray");class eo extends ds{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(t){this._structArray.uint32[this._pos4+14]=t;}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(t){this._structArray.float32[this._pos4+18]=t;}get hasIconTextFit(){return this._structArray.uint8[this._pos1+76]}}eo.prototype.size=80;class ro extends Fs{get(t){return new eo(this,t)}}oa(ro,"SymbolInstanceArray");class no extends Os{getoffsetX(t){return this.float32[1*t+0]}}oa(no,"GlyphOffsetArray");class io extends xs{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}oa(io,"SymbolLineVertexArray");class ao extends ds{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}ao.prototype.size=12;class so extends Gs{get(t){return new ao(this,t)}}oa(so,"FeatureIndexArray");class oo extends Ts{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}oa(oo,"FillExtrusionCentroidArray");class lo extends ds{get a_join_normal_inside0(){return this._structArray.int16[this._pos2+0]}get a_join_normal_inside1(){return this._structArray.int16[this._pos2+1]}get a_join_normal_inside2(){return this._structArray.int16[this._pos2+2]}}lo.prototype.size=6;class uo extends vs{get(t){return new lo(this,t)}}oa(uo,"FillExtrusionWallArray");const co=ys([{name:"a_pos",components:2,type:"Int16"}],4),ho=ys([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class po{constructor(t=[]){this.segments=t;}_prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>po.MAX_VERTEX_ARRAY_LENGTH&&ft(`Max vertices per segment is ${po.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>po.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e,primitiveOffset:r,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}prepareSegment(t,e,r,n){return this._prepareSegment(t,e.length,r.length,n)}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new po([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function fo(t,e){return 256*(t=Q(Math.floor(t),0,255))+Q(Math.floor(e),0,255)}po.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,oa(po,"SegmentVector");const mo=ys([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),yo=ys([{name:"a_dash",components:4,type:"Uint16"}]);class go{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(xo(t)),this.positions.push(e,r,n);}eachPosition(t,e){const r=xo(t);let n=0,i=this.ids.length-1;for(;n<i;){const t=n+i>>1;this.ids[t]>=r?i=t:n=t+1;}for(;this.ids[n]===r;)e(this.positions[3*n],this.positions[3*n+1],this.positions[3*n+2]),n++;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return vo(r,n,0,r.length-1),e&&(e.add(r.buffer),e.add(n.buffer)),{ids:r,positions:n}}static deserialize(t){const e=new go;let r;e.ids=t.ids,e.positions=t.positions;for(const t of e.ids)t!==r&&e.uniqueIds.push(t),r=t;return e.indexed=!0,e}}function xo(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:ge(String(t))}function vo(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let a=r-1,s=n+1;for(;;){do{a++;}while(t[a]<i);do{s--;}while(t[s]>i);if(a>=s)break;bo(t,a,s),bo(e,3*a,3*s),bo(e,3*a+1,3*s+1),bo(e,3*a+2,3*s+2);}s-r<n-s?(vo(t,e,r,s),r=s+1):(vo(t,e,s+1,n),n=s);}}function bo(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}oa(go,"FeaturePositionMap");class _o{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}set(t,e,r){throw new Error("Uniform#set() must be implemented by each concrete Uniform")}}class wo extends _o{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}}class Mo extends _o{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class Ao extends _o{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}}class So extends _o{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}}class Io extends _o{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class Po extends _o{constructor(t){super(t),this.current=Ie.transparent.toRenderColor(null);}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const zo=new Float32Array(16);class Eo extends _o{constructor(t){super(t),this.current=zo;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}}const ko=new Float32Array(9),To=new Float32Array(4);class Bo extends _o{constructor(t){super(t),this.current=To;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}}function Co(t){return [fo(255*t.r,255*t.g),fo(255*t.b,255*t.a)]}class Vo{constructor(t,e,r,n){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r,this.context=n;}setUniform(t,e,r,n,i){const a=n.constantOr(this.value);e.set(t,i,a instanceof Ie?a.toRenderColor(this.ignoreLut?null:this.context.lut):a);}getBinding(t,e){return "color"===this.type?new Po(t):new Mo(t)}}class Do{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.pixelRatio=1;}setConstantPatternPositions(t){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br);}setUniform(t,e,r,n,i){const a="u_pattern"===i||"u_dash"===i?this.pattern:"u_pixel_ratio"===i?this.pixelRatio:null;a&&e.set(t,i,a);}getBinding(t,e){return "u_pattern"===e||"u_dash"===e?new Io(t):new Mo(t)}}class Lo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,a,s){const o=this.paintVertexArray.length,l="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate(new Ca(0,{brightness:a}),e,{},i,n,s):"constant"===this.expression.kind&&this.expression.value;!this.lutExpression||"composite"!==this.lutExpression.kind&&"source"!==this.lutExpression.kind||(this.ignoreLut="none"===this.lutExpression.evaluate(new Ca(0,{brightness:a}),e,{},i,n,s)),this.paintVertexArray.resize(t),this._setPaintValue(o,t,l,this.context);}updatePaintArray(t,e,r,n,i,a,s){const o="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate({zoom:0,brightness:s},r,n,void 0,i):"constant"===this.expression.kind&&this.expression.value;!this.lutExpression||"composite"!==this.lutExpression.kind&&"source"!==this.lutExpression.kind||(this.ignoreLut="none"===this.lutExpression.evaluate({zoom:0,brightness:s},r,n,void 0,i)),this._setPaintValue(t,e,o,this.context);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Co(r.toRenderColor(this.ignoreLut?null:n.lut));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.lutExpression&&"constant"!==this.lutExpression.kind&&(this.lutExpression.isStateDependent||!this.lutExpression.isLightConstant)||"constant"!==this.expression.kind&&(this.expression.isStateDependent||!this.expression.isLightConstant)));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Ro{constructor(t,e,r,n,i,a){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.context=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new a;}populatePaintArray(t,e,r,n,i,a,s){const o=this.expression.evaluate(new Ca(this.context.zoom,{brightness:a}),e,{},i,n,s),l=this.expression.evaluate(new Ca(this.context.zoom+1,{brightness:a}),e,{},i,n,s);!this.lutExpression||"composite"!==this.lutExpression.kind&&"source"!==this.lutExpression.kind||(this.ignoreLut="none"===this.lutExpression.evaluate(new Ca(this.context.zoom,{brightness:a}),e,{},i,n,s));const u=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(u,t,o,l,this.context);}updatePaintArray(t,e,r,n,i,a,s){const o=this.expression.evaluate({zoom:this.context.zoom,brightness:s},r,n,void 0,i),l=this.expression.evaluate({zoom:this.context.zoom+1,brightness:s},r,n,void 0,i);!this.lutExpression||"composite"!==this.lutExpression.kind&&"source"!==this.lutExpression.kind||(this.ignoreLut="none"===this.lutExpression.evaluate({zoom:this.context.zoom,brightness:s},r,n,void 0,i)),this._setPaintValue(t,e,o,l,this.context);}_setPaintValue(t,e,r,n,i){if("color"===this.type){const n=Co(r.toRenderColor(this.ignoreLut?null:i.lut)),a=Co(r.toRenderColor(this.ignoreLut?null:i.lut));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],a[0],a[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const a=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,s=Q(this.expression.interpolationFactor(a,this.context.zoom,this.context.zoom+1),0,1);e.set(t,i,s);}getBinding(t,e){return new Mo(t)}}class Fo{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?yo:mo).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n;}populatePaintArray(t,e,r,n){const i=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,a,s){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],a);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r];if(!i)return;const{tl:a,br:s,pixelRatio:o}=i;for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,a[0],a[1],s[0],s[1],o);}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Oo{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[],this.context=e;const n=[];for(const i in t.paint._values){const a=t.paint.get(i),s=t.paint.get(`${i}-use-theme`);if(i.endsWith("-use-theme"))continue;if(!r(i))continue;if(!(a instanceof Na&&Li(a.property.specification)))continue;const o=jo(i,t.type),l=a.value,u=a.property.specification.type,c=!!a.property.useIntegerZoom,h="line-dasharray"===i||i.endsWith("pattern"),p="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind||s&&"constant"!==s.value.kind;if("constant"!==l.kind||p)if("source"===l.kind||p||h){const e=Go(i,u,"source");this.binders[i]=h?new Fo(l,o,u,e,t.id):new Lo(l,o,u,e),n.push(`/a_${i}`);}else {const t=Go(i,u,"composite");this.binders[i]=new Ro(l,o,u,c,e,t),n.push(`/z_${i}`);}else this.binders[i]=h?new Do(l.value,o):new Vo(l.value,o,u,e),n.push(`/u_${i}`);s&&(this.binders[i].ignoreLut="none"===s.constantOr("default"),this.binders[i].lutExpression=s.value,this.binders[i].checkUseTheme=!0);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Lo||e instanceof Ro?e.maxValue:0}populatePaintArrays(t,e,r,n,i,a,s){for(const o in this.binders){const l=this.binders[o];l.context=this.context,l instanceof Lo||l instanceof Ro||l instanceof Fo?l.populatePaintArray(t,e,r,n,i,a,s):l.lutExpression&&l instanceof Vo&&l.lutExpression&&("composite"===l.lutExpression.kind||"source"===l.lutExpression.kind)&&(l.ignoreLut="none"===l.lutExpression.evaluate(new Ca(0,{brightness:a}),e,{},i,n,s));}}setConstantPatternPositions(t){for(const e in this.binders){const r=this.binders[e];r instanceof Do&&r.setConstantPatternPositions(t);}}updatePaintArrays(t,e,r,n,i,a,s,o,l){let u=!1;const c=Object.keys(t),h=0!==c.length&&!o,p=h?c:e.uniqueIds;this.context.lut=i.lut;for(const o in this.binders){const c=this.binders[o];if(c.context=this.context,(c instanceof Lo||c instanceof Ro||c instanceof Fo)&&c.expression&&c.expression.kind&&"constant"!==c.expression.kind&&(!0===c.expression.isStateDependent||!1===c.expression.isLightConstant)){const f=i.paint.get(o);c.expression=f.value;for(const r of p){const i=t[r.toString()];e.eachPosition(r,((t,e,r)=>{const o=n.feature(t);c.updatePaintArray(e,r,o,i,a,s,l);}));}if(!h)for(const e of r.uniqueIds){const i=t[e.toString()];r.eachPosition(e,((t,e,r)=>{const o=n.feature(t);c.updatePaintArray(e,r,o,i,a,s,l);}));}u=!0;}}return u}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Vo||r instanceof Do)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Lo||r instanceof Ro||r instanceof Fo)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Vo||r instanceof Do||r instanceof Ro)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Vo||n instanceof Do||n instanceof Ro)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:a,binding:s}of r){if(this.binders[a].checkUseTheme&&this.binders[a]instanceof Vo){const t=n.get(`${a}-use-theme`);t.isConstant()&&(this.binders[a].ignoreLut="none"===t.constantOr("default"));}this.binders[a].setUniform(t,s,i,n.get(a),e);}}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof Lo||e instanceof Ro||e instanceof Fo)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Lo||r instanceof Ro||r instanceof Fo)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Lo||e instanceof Ro||e instanceof Fo)&&e.destroy();}}}class No{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Oo(n,e,r);this.needsUpload=!1,this._featureMap=new go,this._featureMapWithoutIds=new go,this._bufferOffset=0,this._idlessCounter=0;}populatePaintArrays(t,e,r,n,i,a,s,o){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,a,s,o);void 0!==e.id?this._featureMap.add(e.id,r,this._bufferOffset,t):(this._featureMapWithoutIds.add(this._idlessCounter,r,this._bufferOffset,t),this._idlessCounter+=1),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i,a,s){for(const o of r)this.needsUpload=this.programConfigurations[o.id].updatePaintArrays(t,this._featureMap,this._featureMapWithoutIds,e,o,n,i,a,s||0)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const Uo={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-occlusion-opacity":["occlusion_opacity"],"icon-occlusion-opacity":["occlusion_opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"symbol-z-offset":["z_offset"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function jo(t,e){return Uo[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const qo={"line-pattern":{source:As,composite:As},"fill-pattern":{source:As,composite:As},"fill-extrusion-pattern":{source:As,composite:As},"line-dasharray":{source:Ss,composite:Ss}},$o={color:{source:$s,composite:Es},number:{source:Os,composite:$s}};function Go(t,e,r){const n=qo[t];return n&&n[r]||$o[e][r]}oa(Vo,"ConstantBinder"),oa(Do,"PatternConstantBinder"),oa(Lo,"SourceExpressionBinder"),oa(Fo,"PatternCompositeBinder"),oa(Ro,"CompositeExpressionBinder"),oa(Oo,"ProgramConfiguration",{omit:["_buffers"]}),oa(No,"ProgramConfigurationSet");const Yo=Wr/Math.PI/2,Xo=5,Zo=6,Ho=16383,Wo=64,Ko=[Wo,32,16],Jo=-Yo,Qo=Yo;function tl(t,e,r,n=Yo){return r=X(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function el(t,e,r){return tl(Math.cos(X(t)),Math.sin(X(t)),e,r)}const rl=6371008.8,nl=2*Math.PI*rl;class il{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new il(et(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return rl*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new al({lng:this.lng-r,lat:this.lat-e},{lng:this.lng+r,lat:this.lat+e})}toEcef(t){return el(this.lat,this.lng,Yo+t*Yo/rl)}static convert(t){if(t instanceof il)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new il(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new il(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class al{constructor(t,e){if(t)if(e)this.setSouthWest(t).setNorthEast(e);else if(4===t.length){const e=t;this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]);}else {const e=t;this.setSouthWest(e[0]).setNorthEast(e[1]);}}setNorthEast(t){return this._ne=t instanceof il?new il(t.lng,t.lat):il.convert(t),this}setSouthWest(t){return this._sw=t instanceof il?new il(t.lng,t.lat):il.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof il)n=t,i=t;else {if(!(t instanceof al))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(al.convert(t)):this.extend(il.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(il.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new il(n.lng,n.lat),this._ne=new il(i.lng,i.lat)),this}getCenter(){return new il((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new il(this.getWest(),this.getNorth())}getSouthEast(){return new il(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=il.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){if(t)return t instanceof al?t:new al(t)}}const sl=0,ol=25.5;function ll(t){return nl*Math.cos(t*Math.PI/180)}function ul(t){return (180+t)/360}function cl(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function hl(t,e){return t/ll(e)}function pl(t){return 360*t-180}function fl(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function dl(t,e){return t*ll(fl(e))}const ml=85.051129;function yl(t){return Math.cos(X(Q(t,-ml,ml)))}function gl(t,e){const r=Q(e,sl,ol),n=Math.pow(2,r);return yl(t)*nl/(512*n)}function xl(t){return 1/Math.cos(t*Math.PI/180)}function vl(t,e=0){const r=Math.exp(Math.PI*(1-(t.y+e/Wr)/(1<<t.z)*2));return 80150034*r/(r*r+1)/Wr/(1<<t.z)}class bl{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=il.convert(t);return new bl(ul(r.lng),cl(r.lat),hl(e,r.lat))}toLngLat(){return new il(pl(this.x),fl(this.y))}toAltitude(){return dl(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/nl*xl(fl(this.y))}}function _l(t,e,r,n,i,a,s,o,l){const u=(e+n)/2,c=(r+i)/2,h=new q(u,c);o(h),function(t,e,r,n,i,a){const s=r-i,o=n-a;return Math.abs((n-e)*s-(r-t)*o)/Math.hypot(s,o)}(h.x,h.y,a.x,a.y,s.x,s.y)>=l?(_l(t,e,r,u,c,a,h,o,l),_l(t,u,c,n,i,h,s,o,l)):t.push(s);}function wl(t,e,r){let n=t[0],i=n.x,a=n.y;e(n);const s=[n];for(let o=1;o<t.length;o++){const l=t[o],{x:u,y:c}=l;e(l),_l(s,i,a,u,c,n,l,e,r),i=u,a=c,n=l;}return s}function Ml(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);Ml(t,e,i,n),Ml(t,i,r,n);}else t.push(r);}function Al(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const a=t[i];Ml(n,r,a,e),r=a;}return n}const Sl=Math.pow(2,14)-1,Il=-Sl-1;function Pl(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=Q(r,Il,Sl),t.y=Q(n,Il,Sl),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&ft("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function zl(t,e,r){const n=t.loadGeometry(),i=t.extent,a=Wr/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const a=1<<e.z,{scale:s,x:o,y:l,projection:u}=r,c=t=>{const r=pl((e.x+t.x/i)/a),n=fl((e.y+t.y/i)/a),c=u.project(r,n);t.x=(c.x*s-o)*i,t.y=(c.y*s-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=wl(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)Pl(e,a);return n}function El(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?zl(t):[]}}function kl(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}function Tl(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class Bl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new xs,this.indexArray=new Ls,this.segments=new po,this.programConfigurations=new No(t.layers,{zoom:t.zoom,lut:t.lut}),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}updateFootprints(t,e){}populate(t,e,r,n){const i=this.layers[0],a=[];let s=null;"circle"===i.type&&(s=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=El(e,t);if(!this.layers[0]._featureFilter.filter(new Ca(this.zoom),u,r))continue;const c=s?s.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:zl(e,r,n),patterns:{},sortKey:c};a.push(h);}s&&a.sort(((t,e)=>t.sortKey-e.sortKey));let o=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new Is,o=n.projection);for(const n of a){const{geometry:i,index:a,sourceLayerIndex:s}=n,l=t[a].feature;this.addFeature(n,i,a,e.availableImages,r,o,e.brightness),e.featureIndex.insert(l,i,a,s,this.index);}}update(t,e,r,n,i,a,s){this.programConfigurations.updatePaintArrays(t,e,i,r,n,a,s);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,co.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,ho.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy());}addFeature(t,e,r,n,i,a,s){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Wr||n<0||n>=Wr)continue;if(a){const t=a.projectTilePoint(r,n,i),e=a.upVector(i,r,n),s=this.globeExtVertexArray;Tl(s,t,e),Tl(s,t,e),Tl(s,t,e),Tl(s,t,e);}const s=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),o=s.vertexLength;kl(this.layoutVertexArray,r,n,-1,-1),kl(this.layoutVertexArray,r,n,1,-1),kl(this.layoutVertexArray,r,n,1,1),kl(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(o,o+1,o+2),this.indexArray.emplaceBack(o,o+2,o+3),s.vertexLength+=4,s.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i,s);}}function Cl(t,e){for(let r=0;r<t.length;r++)if(jl(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(jl(t,e[r]))return !0;return !!Rl(t,e)}function Vl(t,e,r){return !!jl(t,e)||!!Ol(e,t,r)}function Dl(t,e){if(1===t.length)return Ul(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(jl(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Ul(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Rl(t,e[r]))return !0;return !1}function Ll(t,e,r){if(t.length>1){if(Rl(t,e))return !0;for(let n=0;n<e.length;n++)if(Ol(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(Ol(t[n],e,r))return !0;return !1}function Rl(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Fl(n,i,e[t],e[t+1]))return !0}return !1}function Fl(t,e,r,n){return dt(t,r,n)!==dt(e,r,n)&&dt(t,e,r)!==dt(t,e,n)}function Ol(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Nl(t,e[r-1],e[r])<n)return !0;return !1}function Nl(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Ul(t,e){let r,n,i,a=!1;for(let s=0;s<t.length;s++){r=t[s];for(let t=0,s=r.length-1;t<r.length;s=t++)n=r[t],i=r[s],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(a=!a);}return a}function jl(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const a=t[n],s=t[i];a.y>e.y!=s.y>e.y&&e.x<(s.x-a.x)*(e.y-a.y)/(s.y-a.y)+a.x&&(r=!r);}return r}function ql(t,e,r,n,i){for(const a of t)if(e<=a.x&&r<=a.y&&n>=a.x&&i>=a.y)return !0;const a=[new q(e,r),new q(e,i),new q(n,i),new q(n,r)];if(t.length>2)for(const e of a)if(jl(t,e))return !0;for(let e=0;e<t.length-1;e++)if($l(t[e],t[e+1],a))return !0;return !1}function $l(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const a=dt(t,e,r[0]);return a!==dt(t,e,r[1])||a!==dt(t,e,r[2])||a!==dt(t,e,r[3])}function Gl(t,e,r,n,i,a){let s=e.y-t.y,o=t.x-e.x;if(a=a||0){const t=s*s+o*o;if(0===t)return !0;const e=Math.sqrt(t);s/=e,o/=e;}return !((r.x-t.x)*s+(r.y-t.y)*o-a<0||(n.x-t.x)*s+(n.y-t.y)*o-a<0||(i.x-t.x)*s+(i.y-t.y)*o-a<0)}function Yl(t,e,r,n,i,a,s){return !(Gl(t,e,n,i,a,s)||Gl(e,r,n,i,a,s)||Gl(r,t,n,i,a,s)||Gl(n,i,t,e,r,s)||Gl(i,a,t,e,r,s)||Gl(a,n,t,e,r,s))}function Xl(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function Zl(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function Hl(t,e,r,n,i){if(!e[0]&&!e[1])return t;const a=q.convert(e)._mult(i);"viewport"===r&&a._rotate(-n);const s=[];for(let e=0;e<t.length;e++)s.push(t[e].sub(a));return s}function Wl(t,e,r,n){const i=q.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}let Kl,Jl;oa(Bl,"CircleBucket",{omit:["layers"]});var Ql,tu={exports:{}},eu=(Ql||(Ql=1,function(t,e){!function(t){function e(t,e,n){var i=r(256*t,256*(e=Math.pow(2,n)-e-1),n),a=r(256*(t+1),256*(e+1),n);return i[0]+","+i[1]+","+a[0]+","+a[1]}function r(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}t.getURL=function(t,r,n,i,a,s){return s=s||{},t+"?"+["bbox="+e(n,i,a),"format="+(s.format||"image/png"),"service="+(s.service||"WMS"),"version="+(s.version||"1.1.1"),"request="+(s.request||"GetMap"),"srs="+(s.srs||"EPSG:3857"),"width="+(s.width||256),"height="+(s.height||256),"layers="+r].join("&")},t.getTileBBox=e,t.getMercCoords=r,Object.defineProperty(t,"__esModule",{value:!0});}(e);}(0,tu.exports)),tu.exports);class ru{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=au(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=eu.getTileBBox(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let a=t;a>0;a--)n=1<<a-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class nu{constructor(t,e){this.wrap=t,this.canonical=e,this.key=au(t,e.z,e.z,e.x,e.y);}}class iu{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new ru(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:au(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new iu(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new iu(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return au(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return au(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.z<this.canonical.z&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new iu(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new iu(e,this.wrap,e,r,n),new iu(e,this.wrap,e,r+1,n),new iu(e,this.wrap,e,r,n+1),new iu(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new iu(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new iu(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new nu(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function au(t,e,r,n,i){const a=1<<Math.min(r,22);let s=a*(i%a)+n%a;return t&&r<22&&(s+=a*a*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*s+r)+(e-r)}const su=[t=>{let e=t.canonical.x-1,r=t.wrap;return e<0&&(e=(1<<t.canonical.z)-1,r--),new iu(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>{let e=t.canonical.x+1,r=t.wrap;return e===1<<t.canonical.z&&(e=0,r++),new iu(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>new iu(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new iu(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)];oa(ru,"CanonicalTileID"),oa(iu,"OverscaledTileID",{omit:["projMatrix","expandedProjMatrix"]});const ou=ys([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:lu}=ou,uu=ys([{name:"a_pos_3",components:3,type:"Int16"}]);var cu=ys([{name:"a_pos",type:"Int16",components:2}]);class hu{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=O.vec3.dot(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1]+(t[2]-this.pos[2])*e[2])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,r[2]=this.pos[2]+this.dir[2]*i,!0}closestPointOnSphere(t,e,r){if(O.vec3.equals(this.pos,t)||0===e)return r[0]=r[1]=r[2]=0,!1;const[n,i,a]=this.dir,s=this.pos[0]-t[0],o=this.pos[1]-t[1],l=this.pos[2]-t[2],u=n*n+i*i+a*a,c=2*(s*n+o*i+l*a),h=c*c-4*u*(s*s+o*o+l*l-e*e);if(h<0){const t=Math.max(-c/2,0),u=s+n*t,h=o+i*t,p=l+a*t,f=Math.hypot(u,h,p);return r[0]=u*e/f,r[1]=h*e/f,r[2]=p*e/f,!1}{const t=(-c-Math.sqrt(h))/(2*u);if(t<0){const t=Math.hypot(s,o,l);return r[0]=s*e/t,r[1]=o*e/t,r[2]=l*e/t,!1}return r[0]=s+n*t,r[1]=o+i*t,r[2]=l+a*t,!0}}}class pu{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(t,e,r){const n=[-1,1,1],i=[1,1,1],a=[1,-1,1],s=[-1,-1,1],o=O.vec3.transformMat4(n,n,t),l=O.vec3.transformMat4(i,i,t),u=O.vec3.transformMat4(a,a,t),c=O.vec3.transformMat4(s,s,t);return new pu(o,l,u,c,e/r)}}function fu(t,e,r){let n=1/0,i=-1/0;const a=[];for(const s of t){O.vec3.sub(a,s,e);const t=O.vec3.dot(a,r);n=Math.min(n,t),i=Math.max(i,t);}return [n,i]}function du(t,e){let r=!0;for(let n=0;n<t.planes.length;n++){const i=t.planes[n];let a=0;for(let t=0;t<e.length;t++)a+=O.vec3.dot(i,e[t])+i[3]>=0;if(0===a)return 0;a!==e.length&&(r=!1);}return r?2:1}function mu(t,e){for(const r of t.projections){const n=fu(e,t.points[0],r.axis);if(r.projection[1]<n[0]||r.projection[0]>n[1])return 0}return 1}function yu(t,e){let r=0;const n=[0,0,0,0];for(let i=0;i<t.length;i++)n[0]=t[i][0],n[1]=t[i][1],n[2]=t[i][2],n[3]=1,O.vec4.dot(n,e)>=0&&r++;return r}class gu{constructor(t,e){this.points=t||new Array(8).fill([0,0,0]),this.planes=e||new Array(6).fill([0,0,0,0]),this.bounds=xu.fromPoints(this.points),this.projections=[],this.frustumEdges=[O.vec3.sub([],this.points[2],this.points[3]),O.vec3.sub([],this.points[0],this.points[3]),O.vec3.sub([],this.points[4],this.points[0]),O.vec3.sub([],this.points[5],this.points[1]),O.vec3.sub([],this.points[6],this.points[2]),O.vec3.sub([],this.points[7],this.points[3])];for(const t of this.frustumEdges){const e=[0,-t[2],t[1]],r=[t[2],0,-t[0]];this.projections.push({axis:e,projection:fu(this.points,this.points[0],e)}),this.projections.push({axis:r,projection:fu(this.points,this.points[0],r)});}}static fromInvProjectionMatrix(t,e,r,n){const i=Math.pow(2,r),a=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const a=O.vec4.transformMat4([],r,t),s=1/a[3]/e*i;return O.vec4.mul(a,a,[s,s,n?1/a[3]:s,s])})),s=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=O.vec3.sub([],a[t[0]],a[t[1]]),r=O.vec3.sub([],a[t[2]],a[t[1]]),n=O.vec3.normalize([],O.vec3.cross([],e,r)),i=-O.vec3.dot(n,a[t[1]]);return n.concat(i)})),o=[];for(let t=0;t<a.length;t++)o.push([a[t][0],a[t][1],a[t][2]]);return new gu(o,s)}intersectsPrecise(t,e,r){for(let r=0;r<e.length;r++)if(!yu(t,e[r]))return 0;for(let e=0;e<this.planes.length;e++)if(!yu(t,this.planes[e]))return 0;for(const e of r)for(const r of this.frustumEdges){const n=O.vec3.cross([],e,r),i=O.vec3.length(n);if(0===i)continue;O.vec3.scale(n,n,1/i);const a=fu(this.points,this.points[0],n),s=fu(t,this.points[0],n);if(a[0]>s[1]||s[0]>a[1])return 0}return 1}containsPoint(t){for(const e of this.planes){const r=e[3];if(O.vec3.dot([e[0],e[1],e[2]],t)+r<0)return !1}return !0}}class xu{static fromPoints(t){const e=[1/0,1/0,1/0],r=[-1/0,-1/0,-1/0];for(const n of t)O.vec3.min(e,e,n),O.vec3.max(r,r,n);return new xu(e,r)}static fromTileIdAndHeight(t,e,r){const n=1<<t.canonical.z,i=t.canonical.x,a=t.canonical.y;return new xu([i/n,a/n,e],[(i+1)/n,(a+1)/n,r])}static applyTransform(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)O.vec3.transformMat4(r[t],r[t],e);return xu.fromPoints(r)}static applyTransformFast(t,e){const r=[e[12],e[13],e[14]],n=[...r];for(let i=0;i<3;i++)for(let a=0;a<3;a++){const s=e[4*a+i],o=s*t.min[a],l=s*t.max[a];r[i]+=Math.min(o,l),n[i]+=Math.max(o,l);}return new xu(r,n)}static projectAabbCorners(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)O.vec3.transformMat4(r[t],r[t],e);return r}constructor(t,e){this.min=t,this.max=e,this.center=O.vec3.scale([],O.vec3.add([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=O.vec3.clone(this.min),n=O.vec3.clone(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],n[t]=e[t]?this.center[t]:this.max[t];return n[2]=this.max[2],new xu(r,n)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){return this.intersectsAabb(t.bounds)?du(t,this.getCorners()):0}intersectsFlat(t){return this.intersectsAabb(t.bounds)?du(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(t,e){return e||this.intersects(t)?mu(t,this.getCorners()):0}intersectsPreciseFlat(t,e){return e||this.intersectsFlat(t)?mu(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(t){for(let e=0;e<3;++e)if(this.min[e]>t.max[e]||t.min[e]>this.max[e])return !1;return !0}intersectsAabbXY(t){return !(this.min[0]>t.max[0]||t.min[0]>this.max[0]||this.min[1]>t.max[1]||t.min[1]>this.max[1])}encapsulate(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t.min[e]),this.max[e]=Math.max(this.max[e],t.max[e]);}encapsulatePoint(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t[e]),this.max[e]=Math.max(this.max[e],t[e]);}closestPoint(t){return [Math.max(Math.min(this.max[0],t[0]),this.min[0]),Math.max(Math.min(this.max[1],t[1]),this.min[1]),Math.max(Math.min(this.max[2],t[2]),this.min[2])]}}function vu(t){return t*Yo/rl}oa(xu,"Aabb");const bu=[new xu([Jo,Jo,Jo],[Qo,Qo,Qo]),new xu([Jo,Jo,Jo],[0,0,Qo]),new xu([0,Jo,Jo],[Qo,0,Qo]),new xu([Jo,0,Jo],[0,Qo,Qo]),new xu([0,0,Jo],[Qo,Qo,Qo])];function _u(t,e,r,n=!0){const i=O.vec3.scale([],t._camera.position,t.worldSize),a=[e,r,1,1];O.vec4.transformMat4(a,a,t.pixelMatrixInverse),O.vec4.scale(a,a,1/a[3]);const s=O.vec3.sub([],a,i),o=O.vec3.normalize([],s),l=t.globeMatrix,u=[l[12],l[13],l[14]],c=O.vec3.sub([],u,i),h=O.vec3.length(c),p=O.vec3.normalize([],c),f=t.worldSize/(2*Math.PI),d=O.vec3.dot(p,o),m=Math.asin(f/h);if(m<Math.acos(d)){if(!n)return null;const t=[],e=[];O.vec3.scale(t,o,h/d),O.vec3.normalize(e,O.vec3.sub(e,t,c)),O.vec3.normalize(o,O.vec3.add(o,c,O.vec3.scale(o,e,Math.tan(m)*h)));}const y=[];new hu(i,o).closestPointOnSphere(u,f,y);const g=O.vec3.normalize([],bt(l,0)),x=O.vec3.normalize([],bt(l,1)),v=O.vec3.normalize([],bt(l,2)),b=O.vec3.dot(g,y),_=O.vec3.dot(x,y),w=O.vec3.dot(v,y),M=Z(Math.asin(-_/f));let A=Z(Math.atan2(b,w));A=t.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(t.center.lng,A);const S=ul(A),I=Q(cl(M),0,1);return new bl(S,I)}class wu{constructor(t,e,r){this.a=O.vec3.sub([],t,r),this.b=O.vec3.sub([],e,r),this.center=r;const n=O.vec3.normalize([],this.a),i=O.vec3.normalize([],this.b);this.angle=Math.acos(O.vec3.dot(n,i));}}function Mu(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,Q(r,0,1))+t.center[e]}function Au(t){if(t.z<=1)return bu[t.z+2*t.y+t.x];const e=Eu(zu(t));return xu.fromPoints(e)}function Su(t,e,r){return O.vec3.scale(t,t,1-r),O.vec3.scaleAndAdd(t,t,e,r)}function Iu(t,e,r){for(const n of t)O.vec3.transformMat4(n,n,e),O.vec3.scale(n,n,r);}function Pu(t,e,r,n){const i=e/t.worldSize,a=t.globeMatrix;if(r.z<=1){const t=Au(r).getCorners();return Iu(t,a,i),xu.fromPoints(t)}const s=zu(r,n),o=Eu(s,Yo+vu(t._tileCoverLift));Iu(o,a,i);const l=Number.MAX_VALUE,u=[-l,-l,-l],c=[l,l,l];if(s.contains(t.center)){for(const t of o)O.vec3.min(c,c,t),O.vec3.max(u,u,t);u[2]=0;const e=t.point,r=[e.x*i,e.y*i,0];return O.vec3.min(c,c,r),O.vec3.max(u,u,r),new xu(c,u)}if(t._tileCoverLift>0){for(const t of o)O.vec3.min(c,c,t),O.vec3.max(u,u,t);return new xu(c,u)}const h=[a[12]*i,a[13]*i,a[14]*i],p=s.getCenter(),f=Q(t.center.lat,-ml,ml),d=Q(p.lat,-ml,ml),m=ul(t.center.lng),y=cl(f);let g=m-ul(p.lng);const x=y-cl(d);g>.5?g-=1:g<-.5&&(g+=1);let v=0;if(Math.abs(g)>Math.abs(x))v=g>=0?1:3;else {v=x>=0?0:2;const t=[a[4]*i,a[5]*i,a[6]*i],e=-Math.sin(X(x>=0?s.getSouth():s.getNorth()))*Yo;O.vec3.scaleAndAdd(h,h,t,e);}const b=o[v],_=o[(v+1)%4],w=new wu(b,_,h),M=[Mu(w,0)||b[0],Mu(w,1)||b[1],Mu(w,2)||b[2]],A=Fu(t.zoom);if(A>0){const n=function({x:t,y:e,z:r},n,i,a,s){const o=1/(1<<r);let l=t*o,u=l+o,c=e*o,h=c+o,p=0;const f=(l+u)/2-a;return f>.5?p=-1:f<-.5&&(p=1),l=((l+p)*n-(a*=n))*i+a,u=((u+p)*n-a)*i+a,c=(c*n-(s*=n))*i+s,h=(h*n-s)*i+s,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(r,e,t._pixelsPerMercatorPixel,m,y);for(let t=0;t<o.length;t++)Su(o[t],n[t],A);const i=O.vec3.add([],n[v],n[(v+1)%4]);O.vec3.scale(i,i,.5),Su(M,i,A);}for(const t of o)O.vec3.min(c,c,t),O.vec3.max(u,u,t);return c[2]=Math.min(b[2],_[2]),O.vec3.min(c,c,M),O.vec3.max(u,u,M),new xu(c,u)}function zu({x:t,y:e,z:r},n=!1){const i=1/(1<<r),a=new il(pl(t*i),e===(1<<r)-1&&n?-90:fl((e+1)*i)),s=new il(pl((t+1)*i),0===e&&n?90:fl(e*i));return new al(a,s)}function Eu(t,e=Yo){const r=X(t.getNorth()),n=X(t.getSouth()),i=Math.cos(r),a=Math.cos(n),s=Math.sin(r),o=Math.sin(n),l=t.getWest(),u=t.getEast();return [tl(a,o,l,e),tl(a,o,u,e),tl(i,s,u,e),tl(i,s,l,e)]}function ku(t,e,r,n){const i=1<<r.z,a=(t/Wr+r.x)/i;return el(fl((e/Wr+r.y)/i),pl(a),n)}function Tu({min:t,max:e}){return Ho/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const Bu=new Float64Array(16);function Cu(t){const e=Tu(t),r=O.mat4.fromScaling(Bu,[e,e,e]);return O.mat4.translate(r,r,O.vec3.negate([],t.min))}function Vu(t){const e=O.mat4.fromTranslation(Bu,t.min),r=1/Tu(t);return O.mat4.scale(e,e,[r,r,r])}function Du(t){const e=Wr/(2*Math.PI);return t/(2*Math.PI)/e}function Lu(t,e){return Wr/(512*Math.pow(2,t))*Tu(Au(e))}function Ru(t,e,r,n,i){const a=Du(r),s=[t,e,-r/(2*Math.PI)],o=O.mat4.identity(new Float64Array(16));return O.mat4.translate(o,o,s),O.mat4.scale(o,o,[a,a,a]),O.mat4.rotateX(o,o,X(-i)),O.mat4.rotateY(o,o,X(-n)),o}function Fu(t){return tt(Xo,Zo,t)}function Ou(t,e){const r=el(e.lat,e.lng),n=function(t){const e=el(t._center.lat,t._center.lng),r=O.vec3.fromValues(0,1,0);let n=O.vec3.cross([],r,e);const i=O.mat4.fromRotation([],-t.angle,e);n=O.vec3.transformMat4(n,n,i),O.mat4.fromRotation(i,-t._pitch,n);const a=O.vec3.normalize([],e);return O.vec3.scale(a,a,vu(t.cameraToCenterDistance/t.pixelsPerMeter)),O.vec3.transformMat4(a,a,i),O.vec3.add([],e,a)}(t),i=O.vec3.subtract([],n,r);return O.vec3.angle(i,r)}function Nu(t,e){return Ou(t,e)>Math.PI/2*1.01}const Uu=X(85),ju=Math.cos(Uu),qu=Math.sin(Uu),$u=O.mat4.create(),Gu=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e};function Yu(t,e,r,n,i,a,s,o,l){if(a&&t.queryGeometry.isAboveHorizon)return !1;a&&(l*=t.pixelToTileUnitsFactor);const u=t.tileID.canonical,c=r.projection.upVectorScale(u,r.center.lat,r.worldSize).metersToTile;for(const h of e)for(const e of h){const h=e.add(o),p=i&&r.elevation?r.elevation.exaggeration()*i.getElevationAt(h.x,h.y,!0):0,f=r.projection.projectTilePoint(h.x,h.y,u);if(p>0){const t=r.projection.upVector(u,h.x,h.y);f.x+=t[0]*c*p,f.y+=t[1]*c*p,f.z+=t[2]*c*p;}const d=a?h:Xu(f.x,f.y,f.z,n),m=a?t.tilespaceRays.map((t=>Wu(t,p))):t.queryGeometry.screenGeometry,y=O.vec4.transformMat4([],[f.x,f.y,f.z,1],n);if(!s&&a?l*=y[3]/r.cameraToCenterDistance:s&&!a&&(l*=r.cameraToCenterDistance/y[3]),a){const t=fl((e.y/Wr+u.y)/(1<<u.z));l/=r.projection.pixelsPerMeter(t,1)/hl(1,t);}if(Vl(m,d,l))return !0}return !1}function Xu(t,e,r,n){const i=O.vec4.transformMat4([],[t,e,r,1],n);return new q(i[0]/i[3],i[1]/i[3])}const Zu=O.vec3.fromValues(0,0,0),Hu=O.vec3.fromValues(0,0,1);function Wu(t,e){const r=O.vec3.create();return Zu[2]=e,t.intersectsPlane(Zu,Hu,r),new q(r[0],r[1])}class Ku extends Bl{}let Ju,Qu,tc,ec;function rc(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function nc(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(ic(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r,null),t.width=n,t.height=i,t.data=e.data);}function ic(t,e,r,n,i,a,s,o){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const l=t.data,u=e.data,c=4===a&&o;for(let o=0;o<i.height;o++){const h=((r.y+o)*t.width+r.x)*a,p=((n.y+o)*e.width+n.x)*a;if(c)for(let t=0;t<i.width;t++){const e=h+t*a+3,r=p+t*a;u[r+0]=255,u[r+1]=255,u[r+2]=255,u[r+3]=l[e];}else if(s)for(let t=0;t<i.width;t++){const e=h+t*a,r=p+t*a,n=l[e+3],i=new Ie(l[e+0]/255*n,l[e+1]/255*n,l[e+2]/255*n,n).toRenderColor(s).toArray();u[r+0]=i[0],u[r+1]=i[1],u[r+2]=i[2],u[r+3]=i[3];}else for(let t=0;t<i.width*a;t++)u[p+t]=l[h+t];}return e}oa(Ku,"HeatmapBucket",{omit:["layers"]});class ac{constructor(t,e){rc(this,t,1,e);}resize(t){nc(this,new ac(t),1);}clone(){return new ac({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){ic(t,e,r,n,i,1,null);}}class sc{constructor(t,e){rc(this,t,4,e);}resize(t){nc(this,new sc(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new sc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i,a,s){ic(t,e,r,n,i,4,a,s);}}class oc{constructor(t,e){this.width=t.width,this.height=t.height,this.data=e instanceof Uint8Array?new Float32Array(e.buffer):e;}}function lc(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new sc({width:r,height:n}),a=(r,n,a)=>{e[t.evaluationKey]=a;const s=t.expression.evaluate(e);s&&(i.data[r+n+0]=Math.floor(255*s.r/s.a),i.data[r+n+1]=Math.floor(255*s.g/s.a),i.data[r+n+2]=Math.floor(255*s.b/s.a),i.data[r+n+3]=Math.floor(255*s.a));};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,s=0;n<r;n++,s+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];a(i,s,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)a(0,e,t/(r-1));return i}oa(ac,"AlphaImage"),oa(sc,"RGBAImage");const uc=ys([{name:"a_pos",components:2,type:"Int16"}],4),{members:cc}=uc;function hc(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let a=pc(t,0,i,r,!0);const s=[];if(!a||a.next===a.prev)return s;let o,l,u;if(n&&(a=function(t,e,r,n){const i=[];for(let r=0,a=e.length;r<a;r++){const s=pc(t,e[r]*n,r<a-1?e[r+1]*n:t.length,n,!1);s===s.next&&(s.steiner=!0),i.push(Mc(s));}i.sort(vc);for(let t=0;t<i.length;t++)r=bc(i[t],r);return r}(t,e,a,r)),t.length>80*r){o=1/0,l=1/0;let e=-1/0,n=-1/0;for(let a=r;a<i;a+=r){const r=t[a],i=t[a+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return dc(a,s,r,o,l,u,0),s}function pc(t,e,r,n,i){let a;if(i===function(t,e,r,n){let i=0;for(let a=e,s=r-n;a<r;a+=n)i+=(t[s]-t[a])*(t[a+1]+t[s+1]),s=a;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)a=Cc(i/n|0,t[i],t[i+1],a);else for(let i=r-n;i>=e;i-=n)a=Cc(i/n|0,t[i],t[i+1],a);return a&&Pc(a,a.next)&&(Vc(a),a=a.next),a}function fc(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Pc(n,n.next)&&0!==Ic(n.prev,n,n.next))n=n.next;else {if(Vc(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function dc(t,e,r,n,i,a,s){if(!t)return;!s&&a&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=wc(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let a=null;for(e=0;i;){e++;let s=i,o=0;for(let t=0;t<r&&(o++,s=s.nextZ,s);t++);let l=r;for(;o>0||l>0&&s;)0!==o&&(0===l||!s||i.z<=s.z)?(n=i,i=i.nextZ,o--):(n=s,s=s.nextZ,l--),a?a.nextZ=n:t=n,n.prevZ=a,a=n;i=s;}a.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,a);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(a?yc(t,n,i,a):mc(t))e.push(l.i,t.i,u.i),Vc(t),t=u.next,o=u.next;else if((t=u)===o){s?1===s?dc(t=gc(fc(t),e),e,r,n,i,a,2):2===s&&xc(t,e,r,n,i,a):dc(fc(t),e,r,n,i,a,1);break}}}function mc(t){const e=t.prev,r=t,n=t.next;if(Ic(e,r,n)>=0)return !1;const i=e.x,a=r.x,s=n.x,o=e.y,l=r.y,u=n.y,c=i<a?i<s?i:s:a<s?a:s,h=o<l?o<u?o:u:l<u?l:u,p=i>a?i>s?i:s:a>s?a:s,f=o>l?o>u?o:u:l>u?l:u;let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Ac(i,o,a,l,s,u,d.x,d.y)&&Ic(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function yc(t,e,r,n){const i=t.prev,a=t,s=t.next;if(Ic(i,a,s)>=0)return !1;const o=i.x,l=a.x,u=s.x,c=i.y,h=a.y,p=s.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,m=o>l?o>u?o:u:l>u?l:u,y=c>h?c>p?c:p:h>p?h:p,g=wc(f,d,e,r,n),x=wc(m,y,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==s&&Ac(o,c,l,h,u,p,v.x,v.y)&&Ic(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==s&&Ac(o,c,l,h,u,p,b.x,b.y)&&Ic(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==s&&Ac(o,c,l,h,u,p,v.x,v.y)&&Ic(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==s&&Ac(o,c,l,h,u,p,b.x,b.y)&&Ic(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function gc(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Pc(n,i)&&zc(n,r,r.next,i)&&Tc(n,i)&&Tc(i,n)&&(e.push(n.i,r.i,i.i),Vc(r),Vc(r.next),r=t=i),r=r.next;}while(r!==t);return fc(r)}function xc(t,e,r,n,i,a){let s=t;do{let t=s.next.next;for(;t!==s.prev;){if(s.i!==t.i&&Sc(s,t)){let o=Bc(s,t);return s=fc(s,s.next),o=fc(o,o.next),dc(s,e,r,n,i,a,0),void dc(o,e,r,n,i,a,0)}t=t.next;}s=s.next;}while(s!==t)}function vc(t,e){return t.x-e.x}function bc(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let a,s=-1/0;do{if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>s&&(s=t,a=r.x<r.next.x?r:r.next,t===n))return a}r=r.next;}while(r!==e);if(!a)return null;const o=a,l=a.x,u=a.y;let c=1/0;r=a;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Ac(i<u?n:s,i,l,u,i<u?s:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);Tc(r,t)&&(e<c||e===c&&(r.x>a.x||r.x===a.x&&_c(a,r)))&&(a=r,c=e);}r=r.next;}while(r!==o);return a}(t,e);if(!r)return e;const n=Bc(r,t);return fc(n,n.next),fc(r,r.next)}function _c(t,e){return Ic(t.prev,t,e.prev)<0&&Ic(e.next,t,t.next)<0}function wc(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Mc(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function Ac(t,e,r,n,i,a,s,o){return (i-s)*(e-o)>=(t-s)*(a-o)&&(t-s)*(n-o)>=(r-s)*(e-o)&&(r-s)*(a-o)>=(i-s)*(n-o)}function Sc(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&zc(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Tc(t,e)&&Tc(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,a=(t.y+e.y)/2;do{r.y>a!=r.next.y>a&&r.next.y!==r.y&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Ic(t.prev,t,e.prev)||Ic(t,e.prev,e))||Pc(t,e)&&Ic(t.prev,t,t.next)>0&&Ic(e.prev,e,e.next)>0)}function Ic(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Pc(t,e){return t.x===e.x&&t.y===e.y}function zc(t,e,r,n){const i=kc(Ic(t,e,r)),a=kc(Ic(t,e,n)),s=kc(Ic(r,n,t)),o=kc(Ic(r,n,e));return i!==a&&s!==o||!(0!==i||!Ec(t,r,e))||!(0!==a||!Ec(t,n,e))||!(0!==s||!Ec(r,t,n))||!(0!==o||!Ec(r,e,n))}function Ec(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function kc(t){return t>0?1:t<0?-1:0}function Tc(t,e){return Ic(t.prev,t,t.next)<0?Ic(t,e,t.next)>=0&&Ic(t,t.prev,e)>=0:Ic(t,e,t.prev)<0||Ic(t,t.next,e)<0}function Bc(t,e){const r=Dc(t.i,t.x,t.y),n=Dc(e.i,e.x,e.y),i=t.next,a=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,a.next=n,n.prev=a,n}function Cc(t,e,r,n){const i=Dc(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function Vc(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function Dc(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function Lc(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,a;for(let e=0;e<r;e++){const r=mt(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===a&&(a=r<0),a===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(vr(n[t],e,1,n[t].length-1,Rc),n[t]=n[t].slice(0,e));return n}function Rc(t,e){return e.area-t.area}function Fc(t,e,r=1){if(!t)return null;const n="string"==typeof t?t:t.getPrimary().id;e[n]||(e[n]=[]);const i=tr.from(n).getPrimary().scaleSelf(r);return e[n].push(i),i.serialize()}function Oc(t,e,r,n){const i=n.patternDependencies;let a=!1;for(const n of e){const e=n.paint.get(`${t}-pattern`);e.isConstant()||(a=!0),Fc(e.constantOr(null),i,r)&&(a=!0);}return a}function Nc(t,e,r,n,i,a){const s=a.patternDependencies;for(const o of e){const e=o.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},a.availableImages);t=t&&t.name?t.name:t;const l=Fc(t,s,i);l&&(r.patterns[o.id]=l);}}return r}class Uc{constructor(t){this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new xs,this.indexArray=new Ls,this.indexArray2=new Ts,this.programConfigurations=new No(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new po,this.segments2=new po,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Oc("fill",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("fill-sort-key"),a=[];for(const{feature:s,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=El(s,t);if(!this.layers[0]._featureFilter.filter(new Ca(this.zoom),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:s.properties,type:s.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:zl(s,r,n),patterns:{},sortKey:h};a.push(p);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of a){const{geometry:i,index:a,sourceLayerIndex:s}=n;if(this.hasPattern){const t=Nc("fill",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,a,r,{},e.availableImages,e.brightness,e.elevationFeatures);e.featureIndex.insert(t[a].feature,i,a,s,this.index);}}update(t,e,r,n,i,a,s){this.programConfigurations.updatePaintArrays(t,e,i,r,n,a,s);}addFeatures(t,e,r,n,i,a){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,a,t.elevationFeatures);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,cc),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,a=[],s,o){for(const t of Lc(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],a=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&a.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const s=hc(i,a);for(let t=0;t<s.length;t+=3)this.indexArray.emplaceBack(n+s[t],n+s[t+1],n+s[t+2]);r.vertexLength+=e,r.primitiveLength+=s.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,a,n,s);}}let jc,qc,$c,Gc;oa(Uc,"FillBucket",{omit:["layers","patternFeatures"]});class Yc{constructor(t,e,r,n){if(this.triangleCount=e.length/3,this.min=new q(0,0),this.max=new q(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===t.length)return;const[i,a]=[t[0].clone(),t[0].clone()];for(let e=1;e<t.length;++e){const r=t[e];i.x=Math.min(i.x,r.x),i.y=Math.min(i.y,r.y),a.x=Math.max(a.x,r.x),a.y=Math.max(a.y,r.y);}if(n){const t=Math.ceil(Math.max(a.x-i.x,a.y-i.y)/n);r=Math.max(r,t);}if(0===r)return;this.min=i,this.max=a;const s=this.max.sub(this.min);s.x=Math.max(s.x,1),s.y=Math.max(s.y,1);const o=Math.max(s.x,s.y)/r;this.cellsX=Math.max(1,Math.ceil(s.x/o)),this.cellsY=Math.max(1,Math.ceil(s.y/o)),this.xScale=1/o,this.yScale=1/o;const l=[];for(let r=0;r<this.triangleCount;r++){const n=t[e[3*r+0]].sub(this.min),i=t[e[3*r+1]].sub(this.min),a=t[e[3*r+2]].sub(this.min),s=Xc(Math.floor(Math.min(n.x,i.x,a.x)),this.xScale,this.cellsX),u=Xc(Math.floor(Math.max(n.x,i.x,a.x)),this.xScale,this.cellsX),c=Xc(Math.floor(Math.min(n.y,i.y,a.y)),this.yScale,this.cellsY),h=Xc(Math.floor(Math.max(n.y,i.y,a.y)),this.yScale,this.cellsY),p=new q(0,0),f=new q(0,0),d=new q(0,0),m=new q(0,0);for(let t=c;t<=h;++t){p.y=f.y=t*o,d.y=m.y=(t+1)*o;for(let e=s;e<=u;++e)p.x=d.x=e*o,f.x=m.x=(e+1)*o,(Yl(n,i,a,p,f,m)||Yl(n,i,a,p,m,d))&&l.push({cellIdx:t*this.cellsX+e,triIdx:r});}}if(0===l.length)return;l.sort(((t,e)=>t.cellIdx-e.cellIdx||t.triIdx-e.triIdx));let u=0;for(;u<l.length;){const t=l[u].cellIdx,e={start:this.payload.length,len:0};for(;u<l.length&&l[u].cellIdx===t;)++e.len,this.payload.push(l[u++].triIdx);this.cells[t]=e;}}_lazyInitLookup(){this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8))),this.lookup.fill(0);}queryPoint(t,e){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>t.x||t.y>this.max.y||this.min.y>t.y)return;const r=Xc(t.x-this.min.x,this.xScale,this.cellsX),n=Xc(t.y-this.min.y,this.yScale,this.cellsY),i=this.cells[n*this.cellsX+r];if(i){this._lazyInitLookup();for(let t=0;t<i.len;t++){const r=this.payload[i.start+t],n=Math.floor(r/8),a=1<<r%8;if(!(this.lookup[n]&a)&&(this.lookup[n]|=a,e.push(r),e.length===this.triangleCount))return}}}query(t,e,r){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>e.x)return;if(t.y>this.max.y||this.min.y>e.y)return;this._lazyInitLookup();const n=Xc(t.x-this.min.x,this.xScale,this.cellsX),i=Xc(e.x-this.min.x,this.xScale,this.cellsX),a=Xc(t.y-this.min.y,this.yScale,this.cellsY),s=Xc(e.y-this.min.y,this.yScale,this.cellsY);for(let t=a;t<=s;t++)for(let e=n;e<=i;e++){const n=this.cells[t*this.cellsX+e];if(n)for(let t=0;t<n.len;t++){const e=this.payload[n.start+t],i=Math.floor(e/8),a=1<<e%8;if(!(this.lookup[i]&a)&&(this.lookup[i]|=a,r.push(e),r.length===this.triangleCount))return}}}}function Xc(t,e,r){return Math.max(0,Math.min(r-1,Math.floor(t*e)))}oa(Yc,"TriangleGridIndex");class Zc{constructor(t){this.zoom=t.zoom,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.footprints=[];}updateFootprints(t,e){for(const r of this.footprints)e.push({footprint:r,id:t});}populate(t,e,r,n){const i=[];for(const{feature:e,id:a,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=El(e,t);if(!this.layers[0]._featureFilter.filter(new Ca(this.zoom),l,r))continue;const u={id:a,properties:e.properties,type:e.type,sourceLayerIndex:o,index:s,geometry:t?l.geometry:zl(e,r,n),patterns:{}};i.push(u);}for(const n of i){const{geometry:i,index:a,sourceLayerIndex:s}=n;this.addFeature(n,i,a,r,{},e.availableImages,e.brightness),e.featureIndex.insert(t[a].feature,i,a,s,this.index);}}isEmpty(){return 0===this.footprints.length}uploadPending(){return !1}upload(t){}update(t,e,r,n,i,a,s){}destroy(){}addFeature(t,e,r,n,i,a=[],s){for(const t of Lc(e,2)){const e=[],r=[],n=[],i=new q(1/0,1/0),a=new q(-1/0,-1/0);for(const s of t)if(0!==s.length){s!==t[0]&&n.push(r.length/2);for(let t=0;t<s.length;t++)r.push(s[t].x),r.push(s[t].y),e.push(s[t]),i.x=Math.min(i.x,s[t].x),i.y=Math.min(i.y,s[t].y),a.x=Math.max(a.x,s[t].x),a.y=Math.max(a.y,s[t].y);}const s=hc(r,n),o=new Yc(e,s,8,256);this.footprints.push({vertices:e,indices:s,grid:o,min:i,max:a});}}}oa(Zc,"ClipBucket",{omit:["layers"]});const Hc=ys([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),Wc=ys([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),Kc=ys([{name:"a_centroid_pos",components:2,type:"Uint16"}]),Jc=ys([{name:"a_join_normal_inside",components:3,type:"Int16"}]),Qc=ys([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),th=ys([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:eh}=Hc;var rh,nh,ih,ah,sh,oh,lh,uh={};function ch(){if(nh)return rh;nh=1;var t=j();function e(t,e,n,i,a){this.properties={},this.extent=n,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=a,t.readFields(r,this,e);}function r(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function n(t){for(var e,r,n=0,i=0,a=t.length,s=a-1;i<a;s=i++)n+=((r=t[s]).x-(e=t[i]).x)*(e.y+r.y);return n}return rh=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var r,n=e.readVarint()+e.pos,i=1,a=0,s=0,o=0,l=[];e.pos<n;){if(a<=0){var u=e.readVarint();i=7&u,a=u>>3;}if(a--,1===i||2===i)s+=e.readSVarint(),o+=e.readSVarint(),1===i&&(r&&l.push(r),r=[]),r.push(new t(s,o));else {if(7!==i)throw new Error("unknown command "+i);r&&r.push(r[0].clone());}}return r&&l.push(r),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,a=0,s=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<s&&(s=i),i>o&&(o=i),(a+=t.readSVarint())<l&&(l=a),a>u&&(u=a);else if(7!==r)throw new Error("unknown command "+r)}return [s,l,o,u]},e.prototype.toGeoJSON=function(t,r,i){var a,s,o=this.extent*Math.pow(2,i),l=this.extent*t,u=this.extent*r,c=this.loadGeometry(),h=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+l)/o-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+u)/o)*Math.PI/180))-90];}}switch(this.type){case 1:var f=[];for(a=0;a<c.length;a++)f[a]=c[a][0];p(c=f);break;case 2:for(a=0;a<c.length;a++)p(c[a]);break;case 3:for(c=function(t){var e=t.length;if(e<=1)return [t];for(var r,i,a=[],s=0;s<e;s++){var o=n(t[s]);0!==o&&(void 0===i&&(i=o<0),i===o<0?(r&&a.push(r),r=[t[s]]):r.push(t[s]));}return r&&a.push(r),a}(c),a=0;a<c.length;a++)for(s=0;s<c[a].length;s++)p(c[a][s]);}1===c.length?c=c[0]:h="Multi"+h;var d={type:"Feature",geometry:{type:h,coordinates:c},properties:this.properties};return "id"in this&&(d.id=this.id),d},rh}function hh(){if(ah)return ih;ah=1;var t=ch();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length;}function r(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}return ih=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var r=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,r,this.extent,this._keys,this._values)},ih}function ph(){return lh||(lh=1,uh.VectorTile=function(){if(oh)return sh;oh=1;var t=hh();function e(e,r,n){if(3===e){var i=new t(n,n.readVarint()+n.pos);i.length&&(r[i.name]=i);}}return sh=function(t,r){this.layers=t.readFields(e,{},r);},sh}(),uh.VectorTileFeature=ch(),uh.VectorTileLayer=hh()),uh}var fh=ph();class dh extends q{constructor(t,e,r){super(t,e),this.z=r;}}class mh extends dh{constructor(t,e,r,n){super(t,e,r),this.w=n;}}function yh(t,e,r,n){const i=[],a=0===n?(t,e,r,n,i,a)=>{t.push(new q(a,r+(a-e)/(n-e)*(i-r)));}:(t,e,r,n,i,a)=>{t.push(new q(e+(a-r)/(i-r)*(n-e),a));};for(const s of t){const t=[];for(const i of s){if(i.length<=2)continue;const s=[];for(let t=0;t<i.length-1;t++){const o=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?o:l,p=0===n?u:c;h<e?p>e&&a(s,o,l,u,c,e):h>r?p<r&&a(s,o,l,u,c,r):s.push(i[t]),p<e&&h>=e&&a(s,o,l,u,c,e),p>r&&h<=r&&a(s,o,l,u,c,r);}let o=i[i.length-1];const l=0===n?o.x:o.y;l>=e&&l<=r&&s.push(o),s.length&&(o=s[s.length-1],s[0].x===o.x&&s[0].y===o.y||s.push(s[0]),t.push(s));}t.length&&i.push(t);}return i}function gh(t,e,r,n){const i="x"===r?"y":"x",a=(n-t[r])/(e[r]-t[r]);t[i]=t[i]+(e[i]-t[i])*a,t[r]=n,t.hasOwnProperty("z")&&(t.z=ze(t.z,e.z,a)),t.hasOwnProperty("w")&&(t.w=ze(t.w,e.w,a));}function xh(t,e,r,n){const i=r,a=n;for(const r of ["x","y"]){let n=t,s=e;n[r]>=s[r]&&(n=e,s=t),n[r]<i&&s[r]>i&&gh(n,s,r,i),n[r]<a&&s[r]>a&&gh(s,n,r,a);}}const vh=Number.MAX_SAFE_INTEGER;function bh(t,e,r,n){return t.order<e||t.order===vh||!(t.clipMask&r)||function(t,e){return 0!==e.length&&void 0===e.find((e=>e===t))}(n,t.clipScope)}function _h(t,e){return t.x-e.x||t.y-e.y}function wh(t,e){return 0===_h(t.min,e.min)&&0===_h(t.max,e.max)}function Mh(t,e){return !(t.min.x>e.max.x||t.max.x<e.min.x||t.min.y>e.max.y||t.max.y<e.min.y)}function Ah(t,e){if(t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(t[r].sourceId!==e[r].sourceId||!wh(t[r],e[r])||t[r].order!==e[r].order||t[r].clipMask!==e[r].clipMask||!$(t[r].clipScope,e[r].clipScope))return !1;return !0}function Sh(t,e,r){const n=1/Wr,i=1/(1<<r.canonical.z),a=(e.x*n+r.canonical.x)*i+r.wrap,s=(e.y*n+r.canonical.y)*i;return {min:new q((t.x*n+r.canonical.x)*i+r.wrap,(t.y*n+r.canonical.y)*i),max:new q(a,s)}}function Ih(t,e,r){const n=1<<r.canonical.z,i=((e.x-r.wrap)*n-r.canonical.x)*Wr,a=(e.y*n-r.canonical.y)*Wr;return {min:new q(((t.x-r.wrap)*n-r.canonical.x)*Wr,(t.y*n-r.canonical.y)*Wr),max:new q(i,a)}}function Ph(t,e,r,n,i,a,s){const o=t.indices,l=t.vertices,u=[];for(let c=n;c<n+i;c+=3){const n=e[r[c+0]+a],i=e[r[c+1]+a],h=e[r[c+2]+a],p=Math.min(n.x,i.x,h.x),f=Math.max(n.x,i.x,h.x),d=Math.min(n.y,i.y,h.y),m=Math.max(n.y,i.y,h.y);u.length=0,t.grid.query(new q(p,d),new q(f,m),u);for(let t=0;t<u.length;t++){const e=u[t];if(Yl(l[o[3*e+0]],l[o[3*e+1]],l[o[3*e+2]],n,i,h,s))return !0}}return !1}function zh(t,e,r,n){if(!t||!r)return !1;let i=t.vertices;if(!e.canonical.equals(n.canonical)||e.wrap!==n.wrap){if(r.vertices.length<t.vertices.length)return zh(r,n,t,e);const a=e.canonical,s=n.canonical,o=Math.pow(2,s.z-a.z);i=t.vertices.map((t=>new q((t.x+a.x*Wr)*o-s.x*Wr,(t.y+a.y*Wr)*o-s.y*Wr)));}return Ph(r,i,t.indices,0,t.indices.length,0,0)}function Eh(t,e,r,n){const i=Math.pow(2,n.z-r.z);return new q((t+r.x*Wr)*i-n.x*Wr,(e+r.y*Wr)*i-n.y*Wr)}function kh(t,e){const r=[];e.grid.queryPoint(t,r);const n=e.indices,i=e.vertices;for(let e=0;e<r.length;e++){const a=r[e];if(jl([i[n[3*a+0]],i[n[3*a+1]],i[n[3*a+2]]],t))return !0}return !1}const Th=[new q(0,0),new q(Wr,0),new q(Wr,Wr),new q(0,Wr)];function Bh(t,e){const r=[];let n=[];if(!e||t.length<2)return [t];if(2===t.length)return $l(t[0],t[1],Th)?[t]:[];for(let e=0;e<t.length+2;e++){const i=t[e%t.length],a=t[(e+1)%t.length],s=$l(0===e?t[t.length-1]:t[(e-1)%t.length],i,Th),o=$l(i,a,Th),l=s||o;l&&n.push(i),l&&o||n.length>0&&(n.length>1&&r.push(n),n=[]);}return n.length>1&&r.push(n),r}const Ch=fh.VectorTileFeature.types,Vh=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius","fill-extrusion-line-width","fill-extrusion-emissive-strength"],Dh=["fill-extrusion-flood-light-ground-radius"],Lh=Math.pow(2,13),Rh=Math.pow(2,15)-1,Fh=new q(0,1),Oh=2147483648;function Nh(t,e,r,n,i,a,s,o){t.emplaceBack((e<<1)+s,(r<<1)+a,(Math.floor(n*Lh)<<1)+i,Math.round(o));}function Uh(t,e,r){t.emplaceBack(e.x*Wr,e.y*Wr,r?1:0);}function jh(t,e,r,n,i,a){t.emplaceBack(e.x,e.y,(r.x<<1)+n,(r.y<<1)+i,a);}function qh(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class $h{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0;}}class Gh{constructor(){this.centroidXY=new q(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.polygonSegIdx=-1,this.polygonSegLen=0,this.min=new q(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new q(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0;}span(){return new q(this.max.x-this.min.x,this.max.y-this.min.y)}}class Yh{constructor(){this.acc=new q(0,0),this.accCount=0,this.centroidDataIndex=0;}startRing(t,e){t.min.x===Number.MAX_VALUE&&(t.min.x=t.max.x=e.x,t.min.y=t.max.y=e.y);}appendEdge(t,e,r){this.accCount++,this.acc._add(e);let n=!!this.borders;e.x<t.min.x?(t.min.x=e.x,n=!0):e.x>t.max.x&&(t.max.x=e.x,n=!0),e.y<t.min.y?(t.min.y=e.y,n=!0):e.y>t.max.y&&(t.max.y=e.y,n=!0),((0===e.x||e.x===Wr)&&e.x===r.x)!=((0===e.y||e.y===Wr)&&e.y===r.y)&&this.processBorderOverlap(e,r),n&&this.checkBorderIntersection(e,r);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,ze(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>Wr!=t.x>Wr&&this.addBorderIntersection(1,ze(e.y,t.y,(Wr-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,ze(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>Wr!=t.y>Wr&&this.addBorderIntersection(3,ze(e.x,t.x,(Wr-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){return 0===this.accCount?new q(0,0):new q(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0):0}}function Xh(t,e){const r=t.add(e)._unit(),n=Q(t.x*r.x+t.y*r.y,-1,1);var i,a,s;return s=Math.acos(n),Math.min(4,Math.max(-4,Math.tan(s)))/4*Rh*((i=t).x*(a=e).y-i.y*a.x<0?-1:1)}const Zh=[t=>t.x<0,t=>t.x>Wr,t=>t.y<0,t=>t.y>Wr];function Hh(t,e,r,n){const i=[4];if(0===n)return i;r._mult(n);const a=t.sub(r),s=e.sub(r),o=[t,e,a,s];for(let t=0;t<4;t++)for(const e of o)if(Zh[t](e)){i.push(t);break}return i}class Wh{constructor(t){this.vertexArray=new _s,this.indexArray=new Ls,this.programConfigurations=new No(t.layers,{zoom:t.zoom,lut:t.lut},(t=>Dh.includes(t))),this._segments=new po,this.hiddenByLandmarkVertexArray=new Ws,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new po;}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(t,e,r,n=!1){const i=t.length;if(i>2){let a=Math.max(0,this._segments.get().length-1);const s=this._segments._prepareSegment(4*i,this.vertexArray.length,2*this._segmentToGroundQuads[a].length);let o;a!==this._segments.get().length-1&&(a++,this._segmentToGroundQuads[a]=[],this._segmentToRegionTriCounts[a]=[0,0,0,0,0]);{const e=t[0],r=t[1];o=Xh(e.sub(t[i-1])._perp()._unit(),r.sub(e)._perp()._unit());}for(let l=0;l<i;l++){const u=l===i-1?0:l+1,c=t[l],h=t[u],p=t[u===i-1?0:u+1],f=h.sub(c)._perp()._unit(),d=Xh(f,p.sub(h)._perp()._unit()),m=o,y=d;if(ep(c,h,e)||n&&rp(c,e)&&rp(h,e)){o=d;continue}const g=s.vertexLength;jh(this.vertexArray,c,h,1,1,m),jh(this.vertexArray,c,h,1,0,m),jh(this.vertexArray,c,h,0,1,y),jh(this.vertexArray,c,h,0,0,y),s.vertexLength+=4;const x=Hh(c,h,f,r);for(const t of x)this._segmentToGroundQuads[a].push({id:g,region:t}),this._segmentToRegionTriCounts[a][t]+=2,s.primitiveLength+=2;o=d;}}}prepareBorderSegments(){if(!this.hasData())return;const t=this._segments.get(),e=t.length;for(let t=0;t<e;t++)this._segmentToGroundQuads[t].sort(((t,e)=>t.region-e.region));for(let r=0;r<e;r++){const e=this._segmentToGroundQuads[r],n=t[r],i=this._segmentToRegionTriCounts[r];i.reduce(((t,e)=>t+e),0);let a=0;for(let t=0;t<=4;t++){const e=i[t];if(0!==e){let r=this.regionSegments[t];r||(r=this.regionSegments[t]=new po);const i={vertexOffset:n.vertexOffset,primitiveOffset:n.primitiveOffset+a,vertexLength:n.vertexLength,primitiveLength:e};r.get().push(i);}a+=e;}for(let t=0;t<e.length;t++){const r=e[t].id;this.indexArray.emplaceBack(r,r+1,r+3),this.indexArray.emplaceBack(r,r+3,r+2);}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null;}addPaintPropertiesData(t,e,r,n,i,a){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,t,e,r,n,i,a);}upload(t){this.hasData()&&(this.vertexBuffer=t.createVertexBuffer(this.vertexArray,Wc.members),this.indexBuffer=t.createIndexBuffer(this.indexArray));}uploadPaintProperties(t){this.hasData()&&this.programConfigurations.upload(t);}update(t,e,r,n,i,a,s){this.hasData()&&this.programConfigurations.updatePaintArrays(t,e,r,n,i,a,s);}updateHiddenByLandmark(t){if(!this.hasData())return;const e=t.groundVertexCount+t.groundVertexArrayOffset;if(0===t.groundVertexCount)return;const r=t.flags&Oh?1:0;for(let n=t.groundVertexArrayOffset;n<e;++n)this.hiddenByLandmarkVertexArray.emplace(n,r);this._needsHiddenByLandmarkUpdate=!0;}uploadHiddenByLandmark(t){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=t.createVertexBuffer(this.hiddenByLandmarkVertexArray,Qc.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1);}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let t=0;t<=4;t++){const e=this.regionSegments[t];e&&e.destroy();}}}}class Kh{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.pixelRatio=t.pixelRatio,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new Ls,this.footprintVertices=new xs,this.footprintSegments=[],this.layoutVertexArray=new bs,this.centroidVertexArray=new oo,this.wallVertexArray=new uo,this.indexArray=new Ls,this.programConfigurations=new No(t.layers,{zoom:t.zoom,lut:t.lut},(t=>Vh.includes(t))),this.segments=new po,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.groundEffect=new Wh(t),this.maxHeight=0,this.partLookup={},this.triangleSubSegments=[],this.polygonSegments=[];}updateFootprints(t,e){}populate(t,e,r,n){this.features=[],this.hasPattern=Oc("fill-extrusion",this.layers,this.pixelRatio,e),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.selfDEMTileTimestamp=Number.MAX_VALUE,this.borderDEMTileTimestamp=[Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE],this.tileToMeter=vl(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter,this.wallMode=0!==this.layers[0].paint.get("fill-extrusion-line-width").constantOr(1);for(const{feature:i,id:a,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=El(i,t);if(!this.layers[0]._featureFilter.filter(new Ca(this.zoom),l,r))continue;const u={id:a,sourceLayerIndex:o,index:s,geometry:t?l.geometry:zl(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length,h="Polygon"===Ch[u.type];if(this.hasPattern)this.features.push(Nc("fill-extrusion",this.layers,u,this.zoom,this.pixelRatio,e));else if(this.wallMode)for(const t of u.geometry)for(const i of Bh(t,h))this.addFeature(u,[i],s,r,{},e.availableImages,n,e.brightness);else this.addFeature(u,u.geometry,s,r,{},e.availableImages,n,e.brightness);e.featureIndex.insert(i,u.geometry,s,o,this.index,c);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles(),this.groundEffect.prepareBorderSegments(),this.polygonSegments.length=0;}addFeatures(t,e,r,n,i,a){for(const t of this.features){const s="Polygon"===Ch[t.type],{geometry:o}=t;if(this.wallMode)for(const l of o)for(const o of Bh(l,s))this.addFeature(t,[o],t.index,e,r,n,i,a);else this.addFeature(t,o,t.index,e,r,n,i,a);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles();}update(t,e,r,n,i,a,s){this.programConfigurations.updatePaintArrays(t,e,i,r,n,a,s),this.groundEffect.update(t,e,i,r,n,a,s);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,eh),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.wallVertexBuffer=t.createVertexBuffer(this.wallVertexArray,Jc.members),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,th.members,!0)),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){this.groundEffect.uploadHiddenByLandmark(t),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Kc.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,a,s,o){const l=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(t,{})/this.tileToMeter,u=[new q(0,0),new q(Wr,Wr)],c=s.projection,h="globe"===c.name,p=this.wallMode||"Polygon"===Ch[t.type],f=new Yh;f.centroidDataIndex=this.centroidData.length;const d=new Gh,m=this.layers[0].paint.get("fill-extrusion-base").evaluate(t,{},n)<=0,y=this.layers[0].paint.get("fill-extrusion-height").evaluate(t,{},n);let g;if(d.height=y,d.vertexArrayOffset=this.layoutVertexArray.length,d.groundVertexArrayOffset=this.groundEffect.vertexArray.length,h&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new Is),this.wallMode){if(h)return void ft("Non zero fill-extrusion-line-width is not yet supported on globe.");if(1!==e.length)return;g=function(t){const e=t[0].x===t[t.length-1].x&&t[0].y===t[t.length-1].y,r=function(t){let e=0;const r=t.length;for(let n=0;n<r;n++)e+=(t[(n+1)%r].x-t[n].x)*(t[(n+1)%r].y+t[n].y);return e>=0}(t);r||(t=t.reverse());const n={geometry:[],joinNormals:[],indices:[]},i=[],a=[],s=[];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;if(o<(e?3:2))return n;let l,u,c,h,p,f=0;for(;f<o-1&&t[f].equals(t[f+1]);)f++;e&&(l=t[o-2],p=t[f].sub(l)._unit()._perp());for(let r=f;r<o;r++){if(c=r===o-1?e?t[f+1]:void 0:t[r+1],c&&t[r].equals(c))continue;p&&(h=p),l&&(u=l),l=t[r],p=c?c.sub(l)._unit()._perp():h,h=h||p;let n=h.add(p);0===n.x&&0===n.y||n._unit();const d=n.x*p.x+n.y*p.y,m=0!==d?1/d:1/0,y=h.x*p.y-h.y*p.x>0;let g="miter";const x=2;"miter"===g&&m>x&&(g="bevel"),"bevel"===g&&(m>100&&(g="flipbevel"),m<x&&(g="miter"));const v=(t,e,r,n)=>{const o=new q(t.x,t.y),l=new q(t.x,t.y);o.x+=e.x*n,o.y+=e.y*n,l.x-=e.x*Math.max(r,1),l.y-=e.y*Math.max(r,1),s.push(e),i.push(o),a.push(l);};if("miter"===g)n._mult(m),v(l,n,0,0);else if("flipbevel"===g)n=p.mult(-1),v(l,n,0,0),v(l,n.mult(-1),0,0);else {const t=-Math.sqrt(m*m-1),e=y?t:0,r=y?0:t;u&&v(l,h,e,r),c&&v(l,p,e,r);}}n.geometry=[...i,...a.reverse(),i[0]],n.joinNormals=[...s,...s.reverse(),s[s.length-1]];const d=n.geometry.length-1;for(let t=0;t<d/2;t++)if(t+1<d/2){let e=t,r=t+1,i=d-1-t,a=d-2-t;e=0===e?d-1:e-1,r=0===r?d-1:r-1,i=0===i?d-1:i-1,a=0===a?d-1:a-1,n.indices.push(i),n.indices.push(r),n.indices.push(e),n.indices.push(i),n.indices.push(a),n.indices.push(r);}return n}(e[0]),e=[g.geometry];}const x=(t,e)=>t<(e.length-1)/2||t===e.length-1,v=this.wallMode?[e]:Lc(e,500);for(let t=v.length-1;t>=0;t--){const e=v[t];(0===e.length||(b=e[0]).every((t=>t.x<=0))||b.every((t=>t.x>=Wr))||b.every((t=>t.y<=0))||b.every((t=>t.y>=Wr)))&&v.splice(t,1);}var b;let _;if(h)_=sp(v,u,n);else {_=[];for(const t of v)_.push({polygon:t,bounds:u});}const w=p?this.edgeRadius:0,M=w>0&&this.zoom<17,A=(t,e)=>{if(0===t.length)return !1;const r=t[t.length-1];return e.x===r.x&&e.y===r.y};for(const{polygon:t,bounds:e}of _){let r=0,i=0;for(const e of t)p&&!e[0].equals(e[e.length-1])&&e.push(e[0]),i+=p?e.length-1:e.length;const a=this.segments.prepareSegment((p?5:4)*i,this.layoutVertexArray,this.indexArray);d.footprintSegIdx<0&&(d.footprintSegIdx=this.footprintSegments.length),d.polygonSegIdx<0&&(d.polygonSegIdx=this.polygonSegments.length);const s={triangleArrayOffset:this.indexArray.length,triangleCount:0,triangleSegIdx:this.segments.segments.length-1},o=new $h;if(o.vertexOffset=this.footprintVertices.length,o.indexOffset=3*this.footprintIndices.length,o.ringIndices=[],p){const i=[],s=[];r=a.vertexLength;for(let r=0;r<t.length;r++){const u=t[r];u.length&&0!==r&&s.push(i.length/2);const p=[];let f,d;f=u[1].sub(u[0])._perp()._unit(),o.ringIndices.push(u.length-1);for(let t=1;t<u.length;t++){const e=u[t],r=u[t===u.length-1?1:t+1],s=e.clone();if(w){d=r.sub(e)._perp()._unit();const t=f.add(d)._unit(),n=w*Math.min(4,1/(f.x*t.x+f.y*t.y));s.x+=n*t.x,s.y+=n*t.y,s.x=Math.round(s.x),s.y=Math.round(s.y),f=d;}if(!m||0!==w&&!M||A(p,s)||p.push(s),Nh(this.layoutVertexArray,s.x,s.y,0,0,1,1,0),this.wallMode){const e=x(t,u);Uh(this.wallVertexArray,g.joinNormals[t],!e);}a.vertexLength++,this.footprintVertices.emplaceBack(e.x,e.y),i.push(e.x,e.y),h&&qh(this.layoutVertexExtArray,c.projectTilePoint(s.x,s.y,n),c.upVector(n,s.x,s.y));}m&&(0===w||M)&&(0!==p.length&&A(p,p[0])&&p.pop(),this.groundEffect.addData(p,e,l));}const u=this.wallMode?g.indices:hc(i,s);for(let t=0;t<u.length;t+=3)this.footprintIndices.emplaceBack(o.vertexOffset+u[t+0],o.vertexOffset+u[t+1],o.vertexOffset+u[t+2]),this.indexArray.emplaceBack(r+u[t],r+u[t+2],r+u[t+1]),a.primitiveLength++;o.indexCount+=u.length,o.vertexCount+=this.footprintVertices.length-o.vertexOffset;}for(let i=0;i<t.length;i++){const s=t[i];f.startRing(d,s[0]);let o=s.length>4&&np(s[s.length-2],s[0],s[1]),u=w?Qh(s[s.length-2],s[0],s[1],w):0;const y=[];let v,b,_;b=s[1].sub(s[0])._perp()._unit();let M=!0;for(let t=1,i=0;t<s.length;t++){let l=s[t-1],p=s[t];const S=s[t===s.length-1?1:t+1];if(f.appendEdge(d,p,l),ep(p,l,e)){w&&(b=S.sub(p)._perp()._unit(),M=!M);continue}const I=p.sub(l)._perp(),P=I.x/(Math.abs(I.x)+Math.abs(I.y)),z=I.y>0?1:0,E=l.dist(p);if(i+E>32768&&(i=0),w){_=S.sub(p)._perp()._unit();let t=tp(l,p,S,Jh(b,_),w);isNaN(t)&&(t=0);const e=p.sub(l)._unit();l=l.add(e.mult(u))._round(),p=p.add(e.mult(-t))._round(),u=t,b=_,m&&this.zoom>=17&&(A(y,l)||y.push(l),A(y,p)||y.push(p));}const k=a.vertexLength,T=s.length>4&&np(l,p,S);let B=ip(i,o,M);if(Nh(this.layoutVertexArray,l.x,l.y,P,z,0,0,B),Nh(this.layoutVertexArray,l.x,l.y,P,z,0,1,B),this.wallMode){const e=x(t-1,s),r=g.joinNormals[t-1];Uh(this.wallVertexArray,r,e),Uh(this.wallVertexArray,r,e);}if(i+=E,B=ip(i,T,!M),o=T,Nh(this.layoutVertexArray,p.x,p.y,P,z,0,0,B),Nh(this.layoutVertexArray,p.x,p.y,P,z,0,1,B),this.wallMode){const e=x(t,s),r=g.joinNormals[t];Uh(this.wallVertexArray,r,e),Uh(this.wallVertexArray,r,e);}if(a.vertexLength+=4,this.indexArray.emplaceBack(k+0,k+1,k+2),this.indexArray.emplaceBack(k+1,k+3,k+2),a.primitiveLength+=2,w){const n=r+(1===t?s.length-2:t-2),i=1===t?r:n+1;if(this.indexArray.emplaceBack(k+1,n,k+3),this.indexArray.emplaceBack(n,i,k+3),a.primitiveLength+=2,void 0===v&&(v=k),!ep(S,s[t],e)){const e=t===s.length-1?v:a.vertexLength;this.indexArray.emplaceBack(k+2,k+3,e),this.indexArray.emplaceBack(k+3,e+1,e),this.indexArray.emplaceBack(k+3,i,e+1),a.primitiveLength+=3;}M=!M;}if(h){const t=this.layoutVertexExtArray,e=c.projectTilePoint(l.x,l.y,n),r=c.projectTilePoint(p.x,p.y,n),i=c.upVector(n,l.x,l.y),a=c.upVector(n,p.x,p.y);qh(t,e,i),qh(t,e,i),qh(t,r,a),qh(t,r,a);}}p&&(r+=s.length-1),m&&w&&this.zoom>=17&&(0!==y.length&&A(y,y[0])&&y.pop(),this.groundEffect.addData(y,e,l,w>0));}this.footprintSegments.push(o),s.triangleCount=this.indexArray.length-s.triangleArrayOffset,this.polygonSegments.push(s),++d.footprintSegLen,++d.polygonSegLen;}if(d.vertexCount=this.layoutVertexArray.length-d.vertexArrayOffset,d.groundVertexCount=this.groundEffect.vertexArray.length-d.groundVertexArrayOffset,0!==d.vertexCount){if(d.centroidXY=f.borders?Fh:this.encodeCentroid(f,d),this.centroidData.push(d),f.borders){this.featuresOnBorder.push(f);const t=this.featuresOnBorder.length-1;for(let e=0;e<f.borders.length;e++)f.borders[e][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[e].push(t);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,a,n,o),this.groundEffect.addPaintPropertiesData(t,r,i,a,n,o),this.maxHeight=Math.max(this.maxHeight,y);}}sortBorders(){for(let t=0;t<this.borderFeatureIndices.length;t++)this.borderFeatureIndices[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}splitToSubtiles(){const t=[];for(let e=0;e<this.centroidData.length;e++){const r=this.centroidData[e],n=+(r.min.y+r.max.y>Wr),i=2*n+(+(r.min.x+r.max.x>Wr)^n);for(let n=0;n<r.polygonSegLen;n++){const a=r.polygonSegIdx+n;t.push({centroidIdx:e,subtile:i,polygonSegmentIdx:a,triangleSegmentIdx:this.polygonSegments[a].triangleSegIdx});}}const e=new Ls;t.sort(((t,e)=>t.triangleSegmentIdx===e.triangleSegmentIdx?t.subtile-e.subtile:t.triangleSegmentIdx-e.triangleSegmentIdx));let r=0,n=0,i=0;for(const e of t){if(e.triangleSegmentIdx!==r)break;i++;}const a=t.length;for(;n!==t.length;){r=t[n].triangleSegmentIdx;let s=0,o=n,l=n;for(let e=o;e<i&&t[e].subtile===s;e++)l++;for(;o!==i;){const n=t[o];s=n.subtile;const a=this.centroidData[n.centroidIdx].min.clone(),u=this.centroidData[n.centroidIdx].max.clone(),c={vertexOffset:this.segments.segments[r].vertexOffset,primitiveOffset:e.length,vertexLength:this.segments.segments[r].vertexLength,primitiveLength:0,sortKey:void 0,vaos:{}};for(let r=o;r<l;r++){const n=t[r],i=this.polygonSegments[n.polygonSegmentIdx],s=this.centroidData[n.centroidIdx].min,o=this.centroidData[n.centroidIdx].max,l=this.indexArray.uint16;for(let t=i.triangleArrayOffset;t<i.triangleArrayOffset+i.triangleCount;t++)e.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);c.primitiveLength+=i.triangleCount,a.x=Math.min(a.x,s.x),a.y=Math.min(a.y,s.y),u.x=Math.max(u.x,o.x),u.y=Math.max(u.y,o.y);}c.primitiveLength>0&&this.triangleSubSegments.push({segment:c,min:a,max:u}),o=l;for(let e=o;e<i&&t[e].subtile===t[o].subtile;e++)l++;}n=i;for(let e=n;e<a&&t[e].triangleSegmentIdx===t[n].triangleSegmentIdx;e++)i++;}e._trim(),this.indexArray=e;}getVisibleSegments(t,e,r){const n=new po;if(this.wallMode){for(const t of this.triangleSubSegments)n.segments.push(t.segment);return n}let i=0,a=0;const s=1<<t.canonical.z;if(e){const r=e.getMinMaxForTile(t);r&&(i=r.min,a=r.max);}a+=this.maxHeight;const o=t.toUnwrapped();let l;const u=[o.canonical.x/s+o.wrap,o.canonical.y/s],c=[(o.canonical.x+1)/s+o.wrap,(o.canonical.y+1)/s],h=(t,e,r)=>[t[0]*(1-r[0])+e[0]*r[0],t[1]*(1-r[1])+e[1]*r[1]],p=[],f=[];for(const t of this.triangleSubSegments){p[0]=t.min.x/Wr,p[1]=t.min.y/Wr,f[0]=t.max.x/Wr,f[1]=t.max.y/Wr;const e=h(u,c,p),s=h(u,c,f);if(0===new xu([e[0],e[1],i],[s[0],s[1],a]).intersectsPrecise(r)){l&&(n.segments.push(l),l=void 0);continue}const o=t.segment;l&&l.vertexOffset!==o.vertexOffset&&(n.segments.push(l),l=void 0),l?(l.vertexLength+=o.vertexLength,l.primitiveLength+=o.primitiveLength):l={vertexOffset:o.vertexOffset,primitiveLength:o.primitiveLength,vertexLength:o.vertexLength,primitiveOffset:o.primitiveOffset,sortKey:void 0,vaos:{}};}return l&&n.segments.push(l),n}encodeCentroid(t,e){const r=t.centroid(),n=e.span(),i=Math.min(7,Math.round(n.x*this.tileToMeter/10)),a=Math.min(7,Math.round(n.y*this.tileToMeter/10));return new q(Q(r.x,1,Wr-1)<<3|i,Q(r.y,1,Wr-1)<<3|a)}encodeBorderCentroid(t){if(!t.borders)return new q(0,0);const e=t.borders,r=Number.MAX_VALUE;if(e[0][0]!==r||e[1][0]!==r){const t=e[0][0]!==r?0:1;return new q(6|(e[0][0]!==r?0:65528),(e[t][0]+e[t][1])/2<<3|6)}{const t=e[2][0]!==r?2:3;return new q((e[t][0]+e[t][1])/2<<3|6,6|(e[2][0]!==r?0:65528))}}showCentroid(t){const e=this.centroidData[t.centroidDataIndex];e.flags&=Oh,e.centroidXY.x=0,e.centroidXY.y=0,this.writeCentroidToBuffer(e);}writeCentroidToBuffer(t){this.groundEffect.updateHiddenByLandmark(t);const e=t.vertexArrayOffset,r=t.vertexCount+t.vertexArrayOffset,n=t.flags&Oh?Fh:t.centroidXY,i=this.centroidVertexArray.geta_centroid_pos0(e);if(this.centroidVertexArray.geta_centroid_pos1(e)!==n.y||i!==n.x){for(let t=e;t<r;++t)this.centroidVertexArray.emplace(t,n.x,n.y);this.needsCentroidUpdate=!0;}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.centroidData)this.writeCentroidToBuffer(t);}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped());if(Ah(this.activeReplacements,n))return;if(this.activeReplacements=n,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const t of this.centroidData)t.flags&=2147483647;const i=[];for(const e of this.activeReplacements){if(e.order<r)continue;const n=Math.max(1,Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z));for(const r of this.centroidData)if(!(r.flags&Oh||e.min.x>r.max.x||r.min.x>e.max.x||e.min.y>r.max.y||r.min.y>e.max.y))for(let a=0;a<r.footprintSegLen;a++){const s=this.footprintSegments[r.footprintSegIdx+a];if(i.length=0,op(this.footprintVertices,s.vertexOffset,s.vertexCount,e.footprintTileId.canonical,t.canonical,i),Ph(e.footprint,i,this.footprintIndices.uint16,s.indexOffset,s.indexCount,-s.vertexOffset,-n)){r.flags|=Oh;break}}}for(const t of this.centroidData)this.writeCentroidToBuffer(t);this.borderDoneWithNeighborZ=[-1,-1,-1,-1];}footprintContainsPoint(t,e,r){let n=!1;for(let i=0;i<r.footprintSegLen;i++){const a=this.footprintSegments[r.footprintSegIdx+i];let s=0;for(const r of a.ringIndices){for(let i=s,o=r+s-1;i<r+s;o=i++){const r=this.footprintVertices.int16[2*(i+a.vertexOffset)+0],s=this.footprintVertices.int16[2*(i+a.vertexOffset)+1],l=this.footprintVertices.int16[2*(o+a.vertexOffset)+1];s>e!=l>e&&t<(this.footprintVertices.int16[2*(o+a.vertexOffset)+0]-r)*(e-s)/(l-s)+r&&(n=!n);}s=r;}}return n}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+Wr)*Wr+(e+Wr);if(this.partLookup.hasOwnProperty(i)){const t=this.partLookup[i];return t?{height:t.height,hidden:!!(t.flags&Oh)}:void 0}for(const a of this.centroidData)t>a.max.x||a.min.x>t||e>a.max.y||a.min.y>e||this.footprintContainsPoint(t,e,a)&&a&&a.height>r&&(r=a.height,this.partLookup[i]=a,n=!!(a.flags&Oh));if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.partLookup[i]=void 0;}}function Jh(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function Qh(t,e,r,n){const i=e.sub(t)._perp()._unit(),a=r.sub(e)._perp()._unit();return tp(t,e,r,Jh(i,a),n)}function tp(t,e,r,n,i){const a=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*a/n)}function ep(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function rp(t,e){return t.x<e[0].x||t.x>e[1].x||t.y<e[0].y||t.y>e[1].y}function np(t,e,r){if(t.x<0||t.x>=Wr||e.x<0||e.x>=Wr||r.x<0||r.x>=Wr)return !1;const n=r.sub(e),i=n.perp(),a=t.sub(e);return (n.x*a.x+n.y*a.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(a.x*a.x+a.y*a.y))>-.866&&i.x*a.x+i.y*a.y<0}function ip(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function ap(){const t=Math.PI/32,e=Math.tan(t),r=rl;return r*Math.sqrt(1+2*e*e)-r}function sp(t,e,r){const n=1<<r.z,i=pl(r.x/n),a=pl((r.x+1)/n),s=fl(r.y/n),o=fl((r.y+1)/n);return function(t,e,r,n,i=0,a){const s=[];if(!t.length||!r||!n)return s;const o=(t,e)=>{for(const r of t)s.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=yh(p,e[0].y-i,e[1].y+i,1),p=yh(p,e[0].x-i,e[1].x+i,0),!p.length)return s;const f=[];for(h.length?f.push({polygons:p,bounds:e,depth:0}):o(p,e);f.length;){const t=f.pop(),e=t.depth,r=h[e],n=t.bounds[0],s=t.bounds[1],l=0===r?n.x:n.y,u=0===r?s.x:s.y,c=a?a(r,l,u):.5*(l+u),p=yh(t.polygons,l-i,c+i,r),d=yh(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new q(0===r?c:s.x,1===r?c:s.y)];h.length>e+1?f.push({polygons:p,bounds:t,depth:e+1}):o(p,t);}if(d.length){const t=[new q(0===r?c:n.x,1===r?c:n.y),s];h.length>e+1?f.push({polygons:d,bounds:t,depth:e+1}):o(d,t);}}return s}(t,e,Math.ceil((a-i)/11.25),Math.ceil((s-o)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=fl((r.y+e/Wr)/n);return (cl(.5*(fl((r.y+i/Wr)/n)+t))*n-r.y)*Wr}}))}function op(t,e,r,n,i,a){const s=Math.pow(2,n.z-i.z);for(let o=0;o<r;o++){let r=t.int16[2*(o+e)+0],l=t.int16[2*(o+e)+1];r=(r+i.x*Wr)*s-n.x*Wr,l=(l+i.y*Wr)*s-n.y*Wr,a.push(new q(r,l));}}let lp,up;function cp(t,e){return t.x*e.x+t.y*e.y}function hp(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const a=e[r],s=t[0],o=i.sub(n),l=a.sub(n),u=s.sub(n),c=cp(o,o),h=cp(o,l),p=cp(l,l),f=cp(u,o),d=cp(u,l),m=c*p-h*h,y=(p*f-h*d)/m,g=(c*d-h*f)/m,x=n.z*(1-y-g)+i.z*y+a.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function pp(t,e,r,n,i,a,s,o){const l=s*i.getElevationAt(t,e,!0,!0),u=0!==a[0],c=u?0===a[1]?s*(a[0]/7-450):s*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),a=10*(e[0]-8*n),s=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(a*l-1)),c=Math.floor(.5*(s*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,f=2*c+1,d=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,f),m=Math.abs(d[0]-d[1]),y=Math.abs(d[2]-d[3]),g=Math.abs(d[0]-d[2])+Math.abs(d[1]-d[3]),x=Math.min(.25,.5*l*(m+y)/p),v=Math.min(.25,.5*l*g/f);return o+Math.max(x*a,v*s)}(i,a,o):l;return {base:l+(0===r?-1:r),top:u?Math.max(c+n,l+r+2):l+n}}oa(Kh,"FillExtrusionBucket",{omit:["layers","features"]}),oa(Gh,"PartData"),oa($h,"FootprintSegment"),oa(Yh,"BorderCentroidData"),oa(Wh,"GroundEffect");const fp=ys([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),dp=ys([{name:"a_z_offset_width",components:3,type:"Float32"}],4),{members:mp}=fp,yp=ys([{name:"a_packed",components:3,type:"Float32"}]),{members:gp}=yp,xp=ys([{name:"a_pattern_data",components:3,type:"Float32"}]),{members:vp}=xp;class bp{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new ac({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=st(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,a=t[0]*r,s=!0;n.push({left:i,right:a,isDash:s,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){s=!s;const l=t[e];i=o*r,o+=l,a=o*r,n.push({left:i,right:a,isDash:s,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let a=0,s=t[a];for(let o=0;o<this.width;o++){o/s.right>1&&(s=t[++a]);const l=Math.abs(o-s.left),u=Math.abs(o-s.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(s.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+o]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let a=0,s=t[a];for(let r=0;r<this.width;r++){r/s.right>1&&(s=t[++a]);const n=Math.abs(r-s.left),o=Math.abs(r-s.right),l=Math.min(n,o);this.image.data[i+r]=Math.max(0,Math.min(255,(s.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,a=2*i+1;if(this.nextRow+a>this.height)return ft("LineAtlas out of space"),null;0===t.length&&t.push(1);let s=0;for(let e=0;e<t.length;e++)t[e]<0&&(ft("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),s+=t[e];if(0!==s){const r=this.width/s,a=this.getDashRanges(t,this.width,r);n?this.addRoundDash(a,r,i):this.addRegularDash(a,"square"===e?.5*r:0);}const o=this.nextRow+i;this.nextRow+=a;const l={tl:[o,i],br:[s,0]};return this.positions[r]=l,l}}oa(bp,"LineAtlas");const _p=fh.VectorTileFeature.types,wp=Math.cos(Math.PI/180*37.5),Mp=Math.cos(Math.PI/180*5);class Ap{constructor(t){this.evaluationGlobals={zoom:0,lineProgress:void 0},this.zoom=t.zoom,this.evaluationGlobals.zoom=this.zoom,this.overscaling=t.overscaling,this.pixelRatio=t.pixelRatio,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.hasZOffset=!1,this.hasCrossSlope=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new ws,this.layoutVertexArray2=new Ms,this.patternVertexArray=new Ms,this.indexArray=new Ls,this.programConfigurations=new No(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new po,this.maxLineLength=0,this.zOffsetVertexArray=new Ms,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.tessellationStep=t.tessellationStep?t.tessellationStep:Wr/64;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Oc("line",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("line-sort-key");this.tileToMeter=vl(r);const a=this.layers[0].layout.get("line-z-offset"),s=a.isConstant()&&!a.constantOr(0),o=this.layers[0].layout.get("line-elevation-reference");this.hasZOffset="sea"===o||"ground"===o||!s&&"none"===o,this.hasZOffset&&"none"===o&&ft(`line-elevation-reference: ground is used for the layer ${this.layerIds[0]} because non-zero line-z-offset value was found.`);const l=this.layers[0].layout.get("line-cross-slope");this.hasCrossSlope=this.hasZOffset&&void 0!==l;const u=[];for(const{feature:e,id:a,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=El(e,t);if(!this.layers[0]._featureFilter.filter(new Ca(this.zoom),l,r))continue;const c=i?i.evaluate(l,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:o,index:s,geometry:t?l.geometry:zl(e,r,n),patterns:{},sortKey:c};u.push(h);}i&&u.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:c,featureIndex:h}=e,p=this.addConstantDashes(c);for(const n of u){const{geometry:i,index:a,sourceLayerIndex:s}=n;if(p&&this.addFeatureDashes(n,c),this.hasPattern){const t=Nc("line",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,a,r,c.positions,e.availableImages,e.brightness);h.insert(t[a].feature,i,a,s,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,a=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===a.kind)continue;let s,o;if("constant"===i.kind){if(s=i.value,!s)continue}else s=i.evaluate({zoom:r},t);o="constant"===a.kind?a.value:a.evaluate({zoom:r},t),e.addDash(s,o),t.patterns[n.id]=e.getKey(s,o);}}update(t,e,r,n,i,a,s){this.programConfigurations.updatePaintArrays(t,e,i,r,n,a,s);}addFeatures(t,e,r,n,i,a){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,a);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,gp)),0!==this.patternVertexArray.length&&(this.patternVertexBuffer=t.createVertexBuffer(this.patternVertexArray,vp)),!this.zOffsetVertexBuffer&&this.zOffsetVertexArray.length>0&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,dp.members,!0)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,mp),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,a,s){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),u=o.get("line-cap").evaluate(t,{}),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t),this.lineFeature=t,this.zOffsetValue=o.get("line-z-offset").value;const p=this.layers[0].paint.get("line-width").value;"constant"!==p.kind&&!1===p.isLineProgressConstant&&(this.variableWidthValue=p);for(const r of e)this.addLine(r,t,n,l,u,c,h);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,a,n,s);}addLine(t,e,r,n,i,a,s){this.distance=0,this.prevDistance=0,this.scaledDistance=0,this.totalDistance=0,this.totalFeatureLength=0,this.lineSoFar=0,this.currentVertex=void 0;const o="none"===n;if(this.patternJoinNone=this.hasPattern&&o,this.segmentStart=0,this.segmentStartf32=0,this.segmentPoints=[],this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.totalFeatureLength=this.totalDistance/(this.lineClips.end-this.lineClips.start),this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===_p[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===n&&(a=1.05);const h=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let p,f,d,m,y,g;this.e1=this.e2=-1,l&&(p=t[u-2],y=t[c].sub(p)._unit()._perp());for(let e=c;e<u;e++){if(d=e===u-1?l?t[c+1]:void 0:t[e+1],d&&t[e].equals(d))continue;y&&(m=y),p&&(f=p),p=t[e],g=this.evaluateLineProgressFeatures(f?f.dist(p):0),y=d?d.sub(p)._unit()._perp():m,m=m||y;const r=f&&d;let x=r?n:l||o?"butt":i;const v=m.x*y.x+m.y*y.y;if(o){const t=function(t){if(t.patternJoinNone){const e=t.segmentPoints.length/2,r=t.lineSoFar-t.segmentStart;for(let n=0;n<e;++n){const e=t.segmentPoints[2*n+1],i=Math.round(t.segmentPoints[2*n])+.5+.25*e;t.patternVertexArray.emplaceBack(i,r,t.segmentStart),t.patternVertexArray.emplaceBack(i,r,t.segmentStart);}t.segmentPoints.length=0;}t.e1=t.e2=-1;};if(r&&v<Mp){this.updateDistance(f,p),this.addCurrentVertex(p,m,1,1,h,g),t(this),this.addCurrentVertex(p,y,-1,-1,h,g);continue}if(f){if(!d){this.updateDistance(f,p),this.addCurrentVertex(p,m,1,1,h,g),t(this);continue}x="miter";}}let b=m.add(y);0===b.x&&0===b.y||b._unit();const _=b.x*y.x+b.y*y.y,w=0!==_?1/_:1/0,M=2*Math.sqrt(2-2*_),A=_<wp&&f&&d,S=m.x*y.y-m.y*y.x>0,I=this.overscaling<=16?15*Wr/(512*this.overscaling):0;if(r&&"round"===x)if(w<s)x="miter";else if(w<=2){const t=Sp(p,-10,Wr+10);x=this.hasZOffset&&(t||this.hasCrossSlope)?"miter":"fakeround";}if("miter"===x&&w>a&&(x="bevel"),"bevel"===x&&(w>2&&(x="flipbevel"),w<a&&(x="miter")),f&&!("miter"===x&&A)&&this.updateDistance(f,p),"miter"===x)if(A){const t=p.dist(f);if(t>2*I){const e=p.sub(p.sub(f)._mult(I/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,m,0,0,h,g),f=e;}this.updateDistance(f,p),b._mult(w),this.addCurrentVertex(p,b,0,0,h,g);const e=p.dist(d);if(e>2*I){const t=p.add(d.sub(p)._mult(I/e)._round());this.updateDistance(p,t),this.addCurrentVertex(t,y,0,0,h,g),p=t;}}else b._mult(w),this.addCurrentVertex(p,b,0,0,h,g);else if("flipbevel"===x){if(w>100)b=y.mult(-1);else {const t=w*m.add(y).mag()/m.sub(y).mag();b._perp()._mult(t*(S?-1:1));}this.addCurrentVertex(p,b,0,0,h,g),this.addCurrentVertex(p,b.mult(-1),0,0,h,g);}else if("bevel"===x||"fakeround"===x){null!=g&&f&&this.addCurrentVertex(p,m,-1,-1,h,g);const t=p.dist(f)<=2*I&&"bevel"!==x,e=b.mult(S?1:-1);e._mult(w);const r=y.mult(S?-1:1),n=m.mult(S?-1:1),i=this.evaluateLineProgressFeatures(this.distance);if(null==g&&(this.addHalfVertex(p,e.x,e.y,!1,!S,0,h,i),t||this.addHalfVertex(p,e.x+2*n.x,e.y+2*n.y,!1,S,0,h,i)),"fakeround"===x){const t=Math.round(180*M/Math.PI/20);this.addHalfVertex(p,n.x,n.y,!1,S,0,h,i);for(let e=0;e<t;e++){let a=e/t;if(.5!==a){const t=a-.5;a+=a*t*(a-1)*((1.0904+v*(v*(3.55645-1.43519*v)-3.2452))*t*t+(.848013+v*(.215638*v-1.06021)));}const s=r.sub(n)._mult(a)._add(n)._unit();this.addHalfVertex(p,s.x,s.y,!1,S,0,h,i);}this.addHalfVertex(p,r.x,r.y,!1,S,0,h,i);}t||null!=g||this.addHalfVertex(p,e.x+2*r.x,e.y+2*r.y,!1,S,0,h,i),null!=g&&d&&this.addCurrentVertex(p,y,1,1,h,g);}else "butt"===x?this.addCurrentVertex(p,b,0,0,h,g):"square"===x?(f||this.addCurrentVertex(p,b,-1,-1,h,g),this.addCurrentVertex(p,b,0,0,h,g),f&&this.addCurrentVertex(p,b,1,1,h,g)):"round"===x&&(f&&(this.addCurrentVertex(p,m,0,0,h,g),this.addCurrentVertex(p,m,1,1,h,g,!0)),d&&(this.addCurrentVertex(p,y,-1,-1,h,g,!0),this.addCurrentVertex(p,y,0,0,h,g)));}}addVerticesTo(t,e,r,n,i,a,s,o,l,u){const c=(e.w-t.w)/this.tessellationStep|0;let h=0;const p=this.scaledDistance;if(c>1){this.lineSoFar=t.w;const p=(e.x-t.x)/c,f=(e.y-t.y)/c,d=(e.z-t.z)/c,m=(e.w-t.w)/c;for(let e=1;e<c;++e){t.x+=p,t.y+=f,t.z+=d,this.lineSoFar+=m,h+=m;const e=this.evaluateLineProgressFeatures(this.prevDistance+h);this.scaledDistance=(this.prevDistance+h)/this.totalDistance,this.addHalfVertex(t,r,n,u,!1,s,l,e),this.addHalfVertex(t,i,a,u,!0,-o,l,e);}}this.lineSoFar=e.w,this.scaledDistance=p;const f=this.evaluateLineProgressFeatures(this.distance);this.addHalfVertex(e,r,n,u,!1,s,l,f),this.addHalfVertex(e,i,a,u,!0,-o,l,f);}evaluateLineProgressFeatures(t){if(!this.variableWidthValue&&!this.hasZOffset)return null;this.evaluationGlobals.lineProgress=0,this.lineClips?this.evaluationGlobals.lineProgress=Math.min(1,(this.totalFeatureLength*this.lineClips.start+t)/this.totalFeatureLength):ft(`line-progress evaluation for ${this.layerIds[0]} requires enabling 'lineMetrics' for the source.`);let e=0;return this.variableWidthValue&&"constant"!==this.variableWidthValue.kind&&(e=this.variableWidthValue.evaluate(this.evaluationGlobals,this.lineFeature)||0),this.hasZOffset?"constant"===this.zOffsetValue.kind?{zOffset:this.zOffsetValue.value,variableWidth:e}:{zOffset:this.zOffsetValue.evaluate(this.evaluationGlobals,this.lineFeature)||0,variableWidth:e}:{zOffset:0,variableWidth:e}}addCurrentVertex(t,e,r,n,i,a,s=!1){const o=e.x+e.y*r,l=e.y-e.x*r,u=e.y*n-e.x,c=-e.y-e.x*n;if(null!=a){const e=this.hasZOffset,h=-10,p=Wr+10,f=a.zOffset,d=new mh(t.x,t.y,f,this.lineSoFar),m=!!e&&Sp(t,h,p),y=this.lineSoFar,g=this.distance;if(this.currentVertex)if(m){const e=this.currentVertexIsOutside,a=this.currentVertex,m=new mh(t.x,t.y,f,this.lineSoFar);if(xh(a,m,h,p),!Sp(m,h,p)){if(e){this.e1=this.e2=-1,this.distance-=a.dist(d),this.lineSoFar=a.w;const t=this.evaluateLineProgressFeatures(a.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(a,o,l,s,!1,r,i,t),this.addHalfVertex(a,u,c,s,!0,-n,i,t),this.prevDistance=this.distance;}this.distance=this.prevDistance+a.dist(m),this.scaledDistance=this.distance/this.totalDistance,this.addVerticesTo(a,m,o,l,u,c,r,n,i,s),this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}}else {const t=this.currentVertex;if(this.currentVertexIsOutside){xh(t,d,h,p),this.e1=this.e2=-1,this.distance-=t.dist(d),this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t.w;const e=this.evaluateLineProgressFeatures(t.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(t,o,l,s,!1,r,i,e),this.addHalfVertex(t,u,c,s,!0,-n,i,e),this.prevDistance=this.distance,this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}this.addVerticesTo(t,d,o,l,u,c,r,n,i,s);}else m||(this.addHalfVertex(t,o,l,s,!1,r,i,a),this.addHalfVertex(t,u,c,s,!0,-n,i,a));this.currentVertex=d,this.currentVertexIsOutside=m,this.lineSoFar=y;}else this.addHalfVertex(t,o,l,s,!1,r,i,a),this.addHalfVertex(t,u,c,s,!0,-n,i,a);}addHalfVertex({x:t,y:e},r,n,i,a,s,o,l){if(this.patternJoinNone&&(0===this.segmentPoints.length&&(this.segmentStart=this.lineSoFar,this.segmentStartf32=Math.fround(this.lineSoFar)),a||this.segmentPoints.push(this.lineSoFar-this.segmentStart,s)),this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(a?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===s?0:s<0?-1:1),0,this.lineSoFar-this.segmentStartf32),this.lineClips){const t=ze(this.lineClips.start,this.lineClips.end,this.scaledDistance);this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,t);}const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),o.primitiveLength++),a?this.e2=u:this.e1=u,null!=l&&this.zOffsetVertexArray.emplaceBack(l.zOffset,l.variableWidth,l.variableWidth);}updateScaledDistance(){this.lineClips?(this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=this.totalFeatureLength*this.lineClips.start+this.distance):this.lineSoFar=this.distance;}updateDistance(t,e){this.prevDistance=this.distance,this.distance+=t.dist(e),this.updateScaledDistance();}}function Sp(t,e,r){return t.x<e||t.x>r||t.y<e||t.y>r}let Ip,Pp;function zp(t,e,r){return e*(Wr/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}oa(Ap,"LineBucket",{omit:["layers","patternFeatures","currentVertex","currentVertexIsOutside"]});const Ep=(t,e,r)=>(1-r)*t+r*e;function kp(t,e){return 1/zp(t,1,e.tileZoom)}function Tp(t,e,r,n){return t.translatePosMatrix(n||e.tileID.projMatrix,e,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const Bp=t=>{const e=[];Cp(t)&&e.push("RENDER_LINE_DASH"),t.paint.get("line-gradient")&&e.push("RENDER_LINE_GRADIENT");const r=t.paint.get("line-trim-offset");0===r[0]&&0===r[1]||e.push("RENDER_LINE_TRIM_OFFSET"),0!==t.paint.get("line-border-width").constantOr(1)&&e.push("RENDER_LINE_BORDER");const n="none"===t.layout.get("line-join").constantOr("miter"),i=!!t.paint.get("line-pattern").constantOr(1);return n&&i&&e.push("LINE_JOIN_NONE"),e};function Cp(t){const e=t.paint.get("line-dasharray").value;return e.value||"constant"!==e.kind}let Vp;const Dp=()=>Vp||(Vp={layout:Ip||(Ip=new Ga({"line-cap":new qa(Ya.layout_line["line-cap"]),"line-join":new qa(Ya.layout_line["line-join"]),"line-miter-limit":new ja(Ya.layout_line["line-miter-limit"]),"line-round-limit":new ja(Ya.layout_line["line-round-limit"]),"line-sort-key":new qa(Ya.layout_line["line-sort-key"]),"line-z-offset":new qa(Ya.layout_line["line-z-offset"]),"line-elevation-reference":new ja(Ya.layout_line["line-elevation-reference"]),"line-cross-slope":new ja(Ya.layout_line["line-cross-slope"]),visibility:new ja(Ya.layout_line.visibility),"line-width-unit":new ja(Ya.layout_line["line-width-unit"])})),paint:Pp||(Pp=new Ga({"line-opacity":new qa(Ya.paint_line["line-opacity"]),"line-color":new qa(Ya.paint_line["line-color"]),"line-translate":new ja(Ya.paint_line["line-translate"]),"line-translate-anchor":new ja(Ya.paint_line["line-translate-anchor"]),"line-width":new qa(Ya.paint_line["line-width"]),"line-gap-width":new qa(Ya.paint_line["line-gap-width"]),"line-offset":new qa(Ya.paint_line["line-offset"]),"line-blur":new qa(Ya.paint_line["line-blur"]),"line-dasharray":new qa(Ya.paint_line["line-dasharray"]),"line-pattern":new qa(Ya.paint_line["line-pattern"]),"line-gradient":new $a(Ya.paint_line["line-gradient"]),"line-trim-offset":new ja(Ya.paint_line["line-trim-offset"]),"line-trim-fade-range":new ja(Ya.paint_line["line-trim-fade-range"]),"line-trim-color":new ja(Ya.paint_line["line-trim-color"]),"line-emissive-strength":new ja(Ya.paint_line["line-emissive-strength"]),"line-border-width":new qa(Ya.paint_line["line-border-width"]),"line-border-color":new qa(Ya.paint_line["line-border-color"]),"line-occlusion-opacity":new ja(Ya.paint_line["line-occlusion-opacity"]),"line-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"line-gradient-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"line-trim-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"line-border-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},Vp);class Lp extends qa{possiblyEvaluate(t,e){return e=new Ca(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=nt({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let Rp;function Fp(t,e){return e>0?e+2*t:t}const Op=ys([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Np=ys([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),Up=ys([{name:"a_projected_pos",components:4,type:"Float32"}],4);ys([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const jp=ys([{name:"a_auto_z_offset",components:1,type:"Float32"}],4),qp=ys([{name:"a_texb",components:2,type:"Uint16"}]),$p=ys([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_elevation_from_sea",components:2,type:"Float32"}]),Gp=ys([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"},{name:"a_auto_z_offset",components:1,type:"Float32"}]);ys([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Yp=ys([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),Xp=ys([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);ys([{name:"triangle",components:3,type:"Uint16"}]),ys([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),ys([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Uint8",name:"hasIconTextFit"}]),ys([{type:"Float32",name:"offsetX"}]),ys([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);var Zp=24;const Hp=128;function Wp(t,e,r,n,i){if("camera"===t.kind)return t.maxSize;if("composite"===t.kind){const n=e.possiblyEvaluate(new Ca(t.maxZoom),r).evaluate(i,{},r),a=e.possiblyEvaluate(new Ca(t.minZoom),r).evaluate(i,{},r);return Math.max(n,a)}return e.possiblyEvaluate(new Ca(n)).evaluate(i,{},r)}function Kp(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Ca(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let a=i;for(;a<e.length&&e[a]<t+1;)a++;a=Math.min(e.length-1,a);const s=e[i],o=e[a];return "composite"===r.kind?{kind:"composite",minZoom:s,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:s,maxZoom:o,minSize:r.evaluate(new Ca(s)),maxSize:r.evaluate(new Ca(o)),interpolationType:n}}}function Jp(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/Hp:"composite"===t.kind?ze(n/Hp,i/Hp,r):e}function Qp(t,e,r=1){let n=0,i=0;if("constant"===t.kind)i=t.layoutSize*r;else if("source"!==t.kind){const{interpolationType:a,minZoom:s,maxZoom:o}=t,l=a?Q(ai.interpolationFactor(a,e,s,o),0,1):0;"camera"===t.kind?i=ze(t.minSize,t.maxSize,l)*r:n=l*r;}return {uSizeT:n,uSize:i}}var tf=Object.freeze({__proto__:null,SIZE_PACK_FACTOR:Hp,evaluateSizeForFeature:Jp,evaluateSizeForZoom:Qp,getRasterizedIconSize:Wp,getSizeData:Kp});function ef(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ba.applyArabicShaping&&(t=Ba.applyArabicShaping(t)),t}(t.text,e,r);})),t}const rf={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function nf(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function af(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}var sf,of,lf,uf={};
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */function cf(){return sf||(sf=1,uf.read=function(t,e,r,n,i){var a,s,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,a=f&(1<<-c)-1,f>>=-c,c+=o;c>0;a=256*a+t[e+h],h+=p,c-=8);for(s=a&(1<<-c)-1,a>>=-c,c+=n;c>0;s=256*s+t[e+h],h+=p,c-=8);if(0===a)a=1-u;else {if(a===l)return s?NaN:1/0*(f?-1:1);s+=Math.pow(2,n),a-=u;}return (f?-1:1)*s*Math.pow(2,a-n)},uf.write=function(t,e,r,n,i,a){var s,o,l,u=8*a-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:a-1,d=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,s=c):(s=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-s))<1&&(s--,l*=2),(e+=s+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(s++,l/=2),s+h>=c?(o=0,s=c):s+h>=1?(o=(e*l-1)*Math.pow(2,i),s+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),s=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(s=s<<i|o,u+=i;u>0;t[r+f]=255&s,f+=d,s/=256,u-=8);t[r+f-d]|=128*m;}),uf}function hf(){if(lf)return of;lf=1,of=e;var t=cf();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var r=4294967296,n=1/r,i="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function a(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function s(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function o(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function l(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function u(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function c(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function h(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function p(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function f(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function d(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function m(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function y(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function g(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function x(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function v(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,a=this.pos;this.type=7&n,t(i,e,this),this.pos===a&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=v(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+v(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,a=r.buf;if(n=(112&(i=a[r.pos++]))>>4,i<128)return s(t,n,e);if(n|=(127&(i=a[r.pos++]))<<3,i<128)return s(t,n,e);if(n|=(127&(i=a[r.pos++]))<<10,i<128)return s(t,n,e);if(n|=(127&(i=a[r.pos++]))<<17,i<128)return s(t,n,e);if(n|=(127&(i=a[r.pos++]))<<24,i<128)return s(t,n,e);if(n|=(1&(i=a[r.pos++]))<<31,i<128)return s(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&i?function(t,e,r){return i.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var a,s,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(a=t[i+1]))&&(u=(31&l)<<6|63&a)<=127&&(u=null):3===c?(s=t[i+2],128==(192&(a=t[i+1]))&&128==(192&s)&&((u=(15&l)<<12|(63&a)<<6|63&s)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(s=t[i+2],o=t[i+3],128==(192&(a=t[i+1]))&&128==(192&s)&&128==(192&o)&&((u=(15&l)<<18|(63&a)<<12|(63&s)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,r){if(this.type!==e.Bytes)return t.push(this.readVarint(r));var n=a(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(r));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var r=a(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed64());return t},skip:function(t){var r=7&t;if(r===e.Varint)for(;this.buf[this.pos++]>127;);else if(r===e.Bytes)this.pos=this.readVarint()+this.pos;else if(r===e.Fixed32)this.pos+=4;else {if(r!==e.Fixed64)throw new Error("Unimplemented type: "+r);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,a=0;a<e.length;a++){if((n=e.charCodeAt(a))>55295&&n<57344){if(!i){n>56319||a+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&o(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&o(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,r,n){this.writeTag(t,e.Bytes),this.writeRawMessage(r,n);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,u,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,c,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,h,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,f,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,d,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,m,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,y,e);},writeBytesField:function(t,r){this.writeTag(t,e.Bytes),this.writeBytes(r);},writeFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeFixed32(r);},writeSFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeSFixed32(r);},writeFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeFixed64(r);},writeSFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeSFixed64(r);},writeVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeVarint(r);},writeSVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeSVarint(r);},writeStringField:function(t,r){this.writeTag(t,e.Bytes),this.writeString(r);},writeFloatField:function(t,r){this.writeTag(t,e.Fixed32),this.writeFloat(r);},writeDoubleField:function(t,r){this.writeTag(t,e.Fixed64),this.writeDouble(r);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}},of}var pf=e(hf());const ff=3;function df(t,e,r){e.glyphs=[],1===t&&r.readMessage(mf,e);}function mf(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:a,left:s,top:o,advance:l}=r.readMessage(yf,{});e.glyphs.push({id:t,bitmap:new ac({width:i+2*ff,height:a+2*ff},n),metrics:{width:i,height:a,left:s,top:o,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function yf(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const gf=ff,xf={horizontal:1,vertical:2,horizontalOnly:3};class vf{constructor(){this.scale=1,this.fontStack="",this.image=null;}static forText(t,e){const r=new vf;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new vf;return e.image=t,e}}class bf{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new bf;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCodePoint(t){return this.text.codePointAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,a=t.charCodeAt(n-1)||null;r+=!e&&(i&&ga(i)&&!rf[t[n+1]]||a&&ga(a)&&!rf[t[n-1]])||!rf[t[n]]?t[n]:rf[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&wf[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&wf[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new bf;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(vf.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image&&t.image.namePrimary?t.image.getPrimary():null;if(!e)return void ft("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCodePoint(r),this.sections.push(vf.forImage(e)),this.sectionIndex.push(this.sections.length-1)):ft("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function _f(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d){const m=bf.fromFeature(t,i);h===xf.vertical&&m.verticalizePunctuation(p);let y=[];const g=function(t,e,r,n,i,a){if(!t)return [];const s=[],o=function(t,e,r,n,i,a){let s=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);s+=Af(t.getCodePoint(r),o,n,i,e,a);}return s/Math.max(1,Math.ceil(s/r))}(t,e,r,n,i,a),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCodePoint(r);if(wf[p]||(u+=Af(p,h,n,i,e,a)),r<t.length()-1){const e=!((c=p)<11904||!(pa["Bopomofo Extended"](c)||pa.Bopomofo(c)||pa["CJK Compatibility Forms"](c)||pa["CJK Compatibility Ideographs"](c)||pa["CJK Compatibility"](c)||pa["CJK Radicals Supplement"](c)||pa["CJK Strokes"](c)||pa["CJK Symbols and Punctuation"](c)||pa["CJK Unified Ideographs Extension A"](c)||pa["CJK Unified Ideographs"](c)||pa["Enclosed CJK Letters and Months"](c)||pa["Halfwidth and Fullwidth Forms"](c)||pa.Hiragana(c)||pa["Ideographic Description Characters"](c)||pa["Kangxi Radicals"](c)||pa["Katakana Phonetic Extensions"](c)||pa.Katakana(c)||pa["Vertical Forms"](c)||pa["Yi Radicals"](c)||pa["Yi Syllables"](c)));(Mf[p]||e||h.image)&&s.push(Pf(r+1,u,o,s,If(p,t.getCodePoint(r+1),e&&l),!1));}}var c;return zf(Pf(t.length(),u,o,s,0,!0))}(m,u,a,e,n,f),{processBidirectionalText:x,processStyledBidirectionalText:v}=Ba;if(x&&1===m.sections.length){const t=x(m.toString(),g);for(const e of t){const t=new bf;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);y.push(t);}}else if(v){const t=v(m.text,m.sectionIndex,g);for(const e of t){const t=new bf;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,y.push(t);}}else y=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,g);const b=[],_={positionedLines:b,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};return function(t,e,r,n,i,a,s,o,l,u,c,h){let p=0,f=0,d=0;const m="right"===o?1:"left"===o?0:.5;let y=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.image)continue;const r=e[t.fontStack];if(r&&(y=void 0!==r.ascender&&void 0!==r.descender,!y))break}if(!y)break}let g=0;for(const s of i){s.trim();const i=s.getMaxScale(),o=(i-1)*Zp,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let _=0;if(!s.length()){f+=a,++g;continue}let w=0,M=0;for(let a=0;a<s.length();a++){const o=s.getSection(a),d=s.getSectionIndex(a),m=s.getCodePoint(a);let g=o.scale,v=null,A=null,S=null,I=Zp,P=0;const z=!(l===xf.horizontal||!c&&!ya(m)||c&&(wf[m]||(x=m,pa.Arabic(x)||pa["Arabic Supplement"](x)||pa["Arabic Extended-A"](x)||pa["Arabic Presentation Forms-A"](x)||pa["Arabic Presentation Forms-B"](x))));if(o.image){const e=n[o.image.serialize()];if(!e)continue;S=o.image.id,t.iconsInText=t.iconsInText||!0,A=e.paddedRect;const r=e.displaySize;g=g*Zp/h,v={width:r[0],height:r[1],left:0,top:-gf,advance:z?r[1]:r[0],localGlyph:!1},P=y?-v.height*g:i*Zp-17-r[1]*g,I=v.advance;const a=(z?r[0]:r[1])*g-Zp*i;a>0&&a>_&&(_=a);}else {const t=r[o.fontStack];if(!t)continue;t[m]&&(A=t[m]);const n=e[o.fontStack];if(!n)continue;const a=n.glyphs[m];if(!a)continue;if(v=a.metrics,I=8203!==m?Zp:0,y){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;w<r&&(w=r,M=(t-e)/2*g),P=-t*g;}else P=(i-g)*Zp-17;}z?(t.verticalizable=!0,b.push({glyph:m,imageName:S,x:p,y:f+P,vertical:z,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:A}),p+=I*g+u):(b.push({glyph:m,imageName:S,x:p,y:f+P,vertical:z,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:A}),p+=v.advance*g+u);}0!==b.length&&(d=Math.max(p-u,d),y?kf(b,m,_,M,a*i/2):kf(b,m,_,0,a/2)),p=0;const A=a*i+_;v.lineOffset=Math.max(_,o),f+=A,++g;}var x;const v=f,{horizontalAlign:b,verticalAlign:_}=Ef(s);((function(t,e,r,n,i,a){const s=(e-r)*i,o=-a*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=s,t.y+=o;}))(t.positionedLines,m,b,_,d,v),t.top+=-_*v,t.bottom=t.top+v,t.left+=-b*d,t.right=t.left+d,t.hasBaseline=y;}(_,e,r,n,y,s,o,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&_}const wf={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Mf={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Af(t,e,r,n,i,a){if(e.image){const t=n[e.image.serialize()];return t?t.displaySize[0]*e.scale*Zp/a+i:0}{const n=r[e.fontStack],a=n&&n.glyphs[t];return a?a.metrics.advance*e.scale+i:0}}function Sf(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function If(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Pf(t,e,r,n,i,a){let s=null,o=Sf(e,r,i,a);for(const t of n){const n=Sf(e-t.x,r,i,a)+t.badness;n<=o&&(s=t,o=n);}return {index:t,x:e,priorBreak:s,badness:o}}function zf(t){return t?zf(t.priorBreak).concat(t.index):[]}function Ef(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function kf(t,e,r,n,i){if(!(e||r||n||i))return;const a=t.length-1,s=t[a],o=(s.x+s.metrics.advance*s.scale)*e;for(let e=0;e<=a;e++)t[e].x-=o,t[e].y+=r+n+i;}function Tf(t,e,r,n){const{horizontalAlign:i,verticalAlign:a}=Ef(n),s=r[0]-t.displaySize[0]*i,o=r[1]-t.displaySize[1]*a;return {imagePrimary:t,imageSecondary:e,top:o,bottom:o+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function Bf(t,e,r,n,i,a){const s=t.imagePrimary;let o;if(s.content){const t=s.content,e=s.pixelRatio||1;o=[t[0]/e,t[1]/e,s.displaySize[0]-t[2]/e,s.displaySize[1]-t[3]/e];}const l=e.left*a,u=e.right*a;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-s.displaySize[0])/2,h=f+s.displaySize[0]);const d=e.top*a,m=e.bottom*a;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+m+n[2]):(c=i[1]+(d+m-s.displaySize[1])/2,p=c+s.displaySize[1]),{imagePrimary:s,imageSecondary:void 0,top:c,right:h,bottom:p,left:f,collisionPadding:o}}class Cf extends q{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new Cf(this.x,this.y,this.z,this.angle,this.segment)}}function Vf(t,e,r,n,i){if(void 0===e.segment)return !0;let a=e,s=e.segment+1,o=0;for(;o>-r/2;){if(s--,s<0)return !1;o-=t[s].dist(a),a=t[s];}o+=t[s].dist(t[s+1]),s++;const l=[];let u=0;for(;o<r/2;){const e=t[s],r=t[s+1];if(!r)return !1;let a=t[s-1].angleTo(e)-e.angleTo(r);for(a=Math.abs((a+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:a}),u+=a;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;s++,o+=e.dist(r);}return !0}function Df(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Lf(t,e,r){return t?.6*e*r:0}function Rf(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function Ff(t,e,r,n,i,a){const s=Lf(r,i,a),o=Rf(r,n)*a;let l=0;const u=Df(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],a=n.dist(i);if(l+a>u){const c=(u-l)/a,h=ze(n.x,i.x,c),p=ze(n.y,i.y,c),f=new Cf(h,p,0,i.angleTo(n),r);return !s||Vf(t,f,o,s,e)?f:void 0}l+=a;}}function Of(t,e,r,n,i,a,s,o,l){const u=Lf(n,a,s),c=Rf(n,i),h=c*s,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),Nf(t,p?e/2*o%e:(c/2+2*a)*s*o%e,e,u,r,h,p,!1,l)}function Nf(t,e,r,n,i,a,s,o,l){const u=a/2,c=Df(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const s=t[e],o=t[e+1],d=s.dist(o),m=o.angleTo(s);for(;p+r<h+d;){p+=r;const y=(p-h)/d,g=ze(s.x,o.x,y),x=ze(s.y,o.y,y);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Cf(g,x,0,m,e);n&&!Vf(t,r,a,n,i)||f.push(r);}}h+=d;}return o||f.length||s||(f=Nf(t,h/2,r,n,i,a,s,!0,l)),f}function Uf(t,e,r,n,i){const a=[];for(let s=0;s<t.length;s++){const o=t[s];let l;for(let t=0;t<o.length-1;t++){let s=o[t],u=o[t+1];s.x<e&&u.x<e||(s.x<e?s=new q(e,s.y+(e-s.x)/(u.x-s.x)*(u.y-s.y))._round():u.x<e&&(u=new q(e,s.y+(e-s.x)/(u.x-s.x)*(u.y-s.y))._round()),s.y<r&&u.y<r||(s.y<r?s=new q(s.x+(r-s.y)/(u.y-s.y)*(u.x-s.x),r)._round():u.y<r&&(u=new q(s.x+(r-s.y)/(u.y-s.y)*(u.x-s.x),r)._round()),s.x>=n&&u.x>=n||(s.x>=n?s=new q(n,s.y+(n-s.x)/(u.x-s.x)*(u.y-s.y))._round():u.x>=n&&(u=new q(n,s.y+(n-s.x)/(u.x-s.x)*(u.y-s.y))._round()),s.y>=i&&u.y>=i||(s.y>=i?s=new q(s.x+(i-s.y)/(u.y-s.y)*(u.x-s.x),i)._round():u.y>=i&&(u=new q(s.x+(i-s.y)/(u.y-s.y)*(u.x-s.x),i)._round()),l&&s.equals(l[l.length-1])||(l=[s],a.push(l)),l.push(u)))));}}return a}function jf(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,a=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,a=Math.max(a,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:a,fill:e/(i*a)||0}}oa(Cf,"Anchor");const qf=1;class $f{static getImagePositionScale(t,e,r){return e&&t&&t.options&&t.options.transform?{x:t.options.transform.a,y:t.options.transform.d}:{x:r,y:r}}constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:a,sdf:s,usvg:o},l,u){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=a,this.version=r,this.padding=l,this.sdf=s,this.scale=$f.getImagePositionScale(u,o,e);}get tl(){return [this.paddedRect.x+this.padding,this.paddedRect.y+this.padding]}get br(){return [this.paddedRect.x+this.paddedRect.w-this.padding,this.paddedRect.y+this.paddedRect.h-this.padding]}get displaySize(){return [(this.paddedRect.w-2*this.padding)/this.scale.x,(this.paddedRect.h-2*this.padding)/this.scale.y]}}class Gf{constructor(t,e,r){const n={},i={};this.haveRenderCallbacks=[];const a=[];this.addImages(t,n,qf,a),this.addImages(e,i,2,a);const{w:s,h:o}=jf(a),l=new sc({width:s||1,height:o||1});for(const e in t){const i=t[e],a=n[e].paddedRect;sc.copy(i.data,l,{x:0,y:0},{x:a.x+qf,y:a.y+qf},i.data,r,i.sdf);}for(const t in e){const n=e[t],a=i[t].paddedRect;let s=i[t].padding;const o=a.x+s,u=a.y+s,c=n.data.width,h=n.data.height;s=s>1?s-1:s,sc.copy(n.data,l,{x:0,y:0},{x:o,y:u},n.data,r),sc.copy(n.data,l,{x:0,y:h-s},{x:o,y:u-s},{width:c,height:s},r),sc.copy(n.data,l,{x:0,y:0},{x:o,y:u+h},{width:c,height:s},r),sc.copy(n.data,l,{x:c-s,y:0},{x:o-s,y:u},{width:s,height:h},r),sc.copy(n.data,l,{x:0,y:0},{x:o+c,y:u},{width:s,height:h},r),sc.copy(n.data,l,{x:c-s,y:h-s},{x:o-s,y:u-s},{width:s,height:s},r),sc.copy(n.data,l,{x:0,y:h-s},{x:o+c,y:u-s},{width:s,height:s},r),sc.copy(n.data,l,{x:0,y:0},{x:o+c,y:u+h},{width:s,height:s},r),sc.copy(n.data,l,{x:c-s,y:0},{x:o-s,y:u+h},{width:s,height:s},r);}this.lut=r,this.image=l,this.iconPositions=n,this.patternPositions=i;}addImages(t,e,r,n){for(const i in t){const a=t[i],s={x:0,y:0,w:a.data.width+2*r,h:a.data.height+2*r};n.push(s);const o=Qe.deserializeFromString(i);e[i]=new $f(s,a,r,o),a.hasRenderCallback&&this.haveRenderCallbacks.push(o.id);}}patchUpdatedImages(t,e,r){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e,r))),t.dispatchRenderCallbacks(this.haveRenderCallbacks,r);for(const n in t.getUpdatedImages(r)){for(const i of Object.keys(this.iconPositions))Qe.deserializeId(i)===n&&this.patchUpdatedImage(this.iconPositions[i],t.getImage(n,r),e);for(const i of Object.keys(this.patternPositions))Qe.deserializeId(i)===n&&this.patchUpdatedImage(this.patternPositions[i],t.getImage(n,r),e);}}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl,a=t.sdf;if(this.lut||a){const t={width:e.data.width,height:e.data.height},s=new sc(t);sc.copy(e.data,s,{x:0,y:0},{x:0,y:0},t,this.lut,a),r.update(s,{position:{x:n,y:i}});}else r.update(e.data,{position:{x:n,y:i}});}}oa($f,"ImagePosition"),oa(Gf,"ImageAtlas");const Yf=1e20;function Xf(t,e,r,n,i,a,s,o,l){for(let u=e;u<e+n;u++)Zf(t,r*a+u,a,i,s,o,l);for(let u=r;u<r+i;u++)Zf(t,u*a+e,1,n,s,o,l);}function Zf(t,e,r,n,i,a,s){a[0]=0,s[0]=-Yf,s[1]=Yf,i[0]=t[e];for(let o=1,l=0,u=0;o<n;o++){i[o]=t[e+o*r];const n=o*o;do{const t=a[l];u=(i[o]-i[t]+n-t*t)/(o-t)/2;}while(u<=s[l]&&--l>-1);l++,a[l]=o,s[l]=u,s[l+1]=Yf;}for(let o=0,l=0;o<n;o++){for(;s[l+1]<o;)l++;const n=a[l],u=o-n;t[e+o*r]=i[n]+u*u;}}const Hf=2,Wf={none:0,ideographs:1,all:2};class Kf{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.urls={},this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t,e){this.urls[e]=t;}getGlyphs(t,e,r){const n=[],i=this.urls[e]||St.GLYPHS_URL;for(const e in t)for(const r of t[e])n.push({stack:e,id:r});rt(n,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let a=n.glyphs[e];if(void 0!==a)return void r(null,{stack:t,id:e,glyph:a});if(a=this._tinySDF(n,t,e),a)return n.glyphs[e]=a,void r(null,{stack:t,id:e,glyph:a});const s=Math.floor(e/256);if(256*s>65535)return ft("glyphs > 65535 not supported"),void r(null,{stack:t,id:e,glyph:a});if(n.ranges[s])return void r(null,{stack:t,id:e,glyph:a});let o=n.requests[s];o||(o=n.requests[s]=[],Kf.loadGlyphRange(t,s,i,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[s]=!0;}for(const r of o)r(t,e);delete n.requests[s];}))),o.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,e)=>{if(t)r(t);else if(e){const t={};for(const{stack:r,id:n,glyph:i}of e)void 0===t[r]&&(t[r]={}),void 0===t[r].glyphs&&(t[r].glyphs={}),t[r].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[r].ascender=this.entries[r].ascender,t[r].descender=this.entries[r].descender;r(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==Wf.none&&(this.localGlyphMode===Wf.all?!!this.localFontFamily:!!this.localFontFamily&&(pa["CJK Unified Ideographs"](t)||pa["Hangul Syllables"](t)||pa.Hiragana(t)||pa.Katakana(t)||pa["CJK Symbols and Punctuation"](t)||pa["CJK Unified Ideographs Extension A"](t)||pa["CJK Unified Ideographs Extension B"](t)||pa.Osage(t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new Kf.TinySDF({fontFamily:n,fontWeight:r,fontSize:24*Hf,buffer:3*Hf,radius:8*Hf}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const a=String.fromCodePoint(r),{data:s,width:o,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:f}=i.draw(a);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new ac({width:o,height:l},s),metrics:{width:u/Hf,height:c/Hf,left:h/Hf,top:p/Hf-27,advance:f/Hf,localGlyph:!0}}}}Kf.loadGlyphRange=function(t,e,r,n,i){const a=256*e,s=a+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${a}-${s}`),te.Glyphs);ie(o,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new pf(t).readFields(df,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},Kf.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:a="normal",fontStyle:s="normal"}={}){this.buffer=e,this.cutoff=n,this.radius=r;const o=this.size=t+4*e,l=this._createCanvas(o),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${s} ${a} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:a}=this.ctx.measureText(t),s=Math.ceil(r),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(a-i))),l=Math.min(this.size-this.buffer,s+Math.ceil(n)),u=o+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),f={data:p,width:u,height:c,glyphWidth:o,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return f;const{ctx:d,buffer:m,gridInner:y,gridOuter:g}=this;d.clearRect(m,m,o,l),d.fillText(t,m,m+s);const x=d.getImageData(m,m,o,l);g.fill(Yf,0,h),y.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const r=x.data[4*(t*o+e)+3]/255;if(0===r)continue;const n=(t+m)*u+e+m;if(1===r)g[n]=0,y[n]=Yf;else {const t=.5-r;g[n]=t>0?t*t:0,y[n]=t<0?t*t:0;}}Xf(g,0,0,u,c,u,this.f,this.v,this.z),Xf(y,m,m,o,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(y[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return f}};const Jf=qf;function Qf(t,e){return t+e[1]-e[0]}function td(t,e,r,n,i=1){const a=[],s=t.imagePrimary,o=s.pixelRatio,l=s.paddedRect.w-2*Jf,u=s.paddedRect.h-2*Jf,c=(t.right-t.left)*i,h=(t.bottom-t.top)*i,p=s.stretchX||[[0,l]],f=s.stretchY||[[0,u]],d=p.reduce(Qf,0),m=f.reduce(Qf,0),y=l-d,g=u-m;let x=0,v=d,b=0,_=m,w=0,M=y,A=0,S=g;if(s.content&&n){const t=s.content;x=ed(p,0,t[0]),b=ed(f,0,t[1]),v=ed(p,t[0],t[2]),_=ed(f,t[1],t[3]),w=t[0]-x,A=t[1]-b,M=t[2]-t[0]-v,S=t[3]-t[1]-_;}const I=(n,a,l,u)=>{const p=nd(n.stretch-x,v,c,t.left*i),f=id(n.fixed-w,M,n.stretch,d),y=nd(a.stretch-b,_,h,t.top*i),g=id(a.fixed-A,S,a.stretch,m),I=nd(l.stretch-x,v,c,t.left*i),P=id(l.fixed-w,M,l.stretch,d),z=nd(u.stretch-b,_,h,t.top*i),E=id(u.fixed-A,S,u.stretch,m),k=new q(p,y),T=new q(I,y),B=new q(I,z),C=new q(p,z),V=new q(f/o,g/o),D=new q(P/o,E/o),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];k._matMult(r),T._matMult(r),C._matMult(r),B._matMult(r);}const R=n.stretch+n.fixed,F=l.stretch+l.fixed,O=a.stretch+a.fixed,N=u.stretch+u.fixed,U=t.imageSecondary;return {tl:k,tr:T,bl:C,br:B,texPrimary:{x:s.paddedRect.x+Jf+R,y:s.paddedRect.y+Jf+O,w:F-R,h:N-O},texSecondary:U?{x:U.paddedRect.x+Jf+R,y:U.paddedRect.y+Jf+O,w:F-R,h:N-O}:void 0,writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:V,pixelOffsetBR:D,minFontScaleX:M/o/c,minFontScaleY:S/o/h,isSDF:r}};if(n&&(s.stretchX||s.stretchY)){const t=rd(p,y,d),e=rd(f,g,m);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)a.push(I(n,e[t],i,e[t+1]));}}else a.push(I({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return a}function ed(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function rd(t,e,r){const n=[{fixed:-Jf,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+Jf,stretch:r}),n}function nd(t,e,r,n){return t/e*r+n}function id(t,e,r,n){return t-e*r/n}function ad(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}function sd(t,e=1,r=!1){let n=1/0,i=1/0,a=-1/0,s=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>s)&&(s=e.y);}const l=Math.min(a-n,s-i);let u=l/2;const c=new Hr([],od);if(0===l)return new q(n,i);for(let e=n;e<a;e+=l)for(let r=i;r<s;r+=l)c.push(new ld(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,a=i.length,s=a-1;t<a;s=t++){const a=i[t],o=i[s],l=a.x*o.y-o.x*a.y;r+=(a.x+o.x)*l,n+=(a.y+o.y)*l,e+=3*l;}return new ld(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new ld(n.p.x-u,n.p.y-u,u,t)),c.push(new ld(n.p.x+u,n.p.y-u,u,t)),c.push(new ld(n.p.x-u,n.p.y+u,u,t)),c.push(new ld(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function od(t,e){return e.max-t.max}class ld{constructor(t,e,r,n){this.p=new q(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const a=e[i];for(let e=0,i=a.length,s=i-1;e<i;s=e++){const i=a[e],o=a[s];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Nl(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const ud=Number.POSITIVE_INFINITY,cd=Math.sqrt(2);function hd(t,[e,r]){let n=0,i=0;if(r===ud){e<0&&(e=0);const r=e/cd;switch(t){case"top-right":case"top-left":i=r-7;break;case"bottom-right":case"bottom-left":i=7-r;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":n=-r;break;case"top-left":case"bottom-left":n=r;break;case"left":n=e;break;case"right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}}return [n,i]}function pd(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function fd(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d){let m=a.textMaxSize.evaluate(e,{},h);void 0===m?m=s*a.textScaleFactor:m*=a.textScaleFactor;const y=t.layers[0].layout,g=y.get("icon-offset").evaluate(e,{},h),x=gd(r.horizontal)||r.vertical,v="globe"===p.name,b=Zp,_=s*a.textScaleFactor/b,w=t.tilePixelRatio*m/b,M=(T=t.overscaling,t.zoom>18&&T>2&&(T>>=1),Math.max(Wr/(512*T),1)*y.get("symbol-spacing")),A=y.get("text-padding")*t.tilePixelRatio,S=y.get("icon-padding")*t.tilePixelRatio,I=X(y.get("text-max-angle")),P="map"===y.get("text-rotation-alignment")&&"point"!==y.get("symbol-placement"),z="map"===y.get("icon-rotation-alignment")&&"point"!==y.get("symbol-placement"),E=y.get("symbol-placement"),k=M/2;var T;const B=y.get("icon-text-fit").evaluate(e,{},h),C=y.get("icon-text-fit-padding").evaluate(e,{},h),V="none"!==B;let D;!1===t.hasAnyIconTextFit&&V&&(t.hasAnyIconTextFit=!0),n&&V&&(t.allowVerticalPlacement&&r.vertical&&(D=Bf(n,r.vertical,B,C,g,_)),x&&(n=Bf(n,x,B,C,g,_)));const L=(s,o,m)=>{if(o.x<0||o.x>=Wr||o.y<0||o.y>=Wr)return;let y=null;if(v){const{x:t,y:e,z:r}=p.projectTilePoint(o.x,o.y,m);y={anchor:new Cf(t,e,r,0,void 0),up:p.upVector(m,o.x,o.y)};}!function(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I){const P=t.addToLineVertexArray(e,n);let z,E,k,T,B,C,V,D=0,L=0,R=0,F=0,O=-1,N=-1;const U={};let j=ge("");const q=r?r.anchor:e,$="none"!==l.layout.get("icon-text-fit").evaluate(b,{},A);let G=0,Y=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[G,Y]=l.layout.get("text-offset").evaluate(b,{},A).map((t=>t*Zp)):(G=l.layout.get("text-radial-offset").evaluate(b,{},A)*Zp,Y=ud),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(d)C=vd(t),o&&(V=vd(o));else {const r=l.layout.get("text-rotate").evaluate(b,{},A)+90;k=xd(u,q,e,c,h,p,t,f,r,m),o&&(T=xd(u,q,e,c,h,p,o,g,r));}}if(a){const n=t.iconSizeData,i=l.layout.get("icon-rotate").evaluate(b,{},A),s=td(a,i,w,$,_.iconScaleFactor),f=o?td(o,i,w,$,_.iconScaleFactor):void 0;E=xd(u,q,e,c,h,p,a,g,i,null),D=4*s.length;let d=null;"source"===n.kind?(d=[Hp*l.layout.get("icon-size").evaluate(b,{},A)*_.iconScaleFactor],d[0]>md&&ft(`${t.layerIds[0]}: Value for "icon-size" is >= ${dd}. Reduce your "icon-size".`)):"composite"===n.kind&&(d=[Hp*_.compositeIconSizes[0].evaluate(b,{},A)*_.iconScaleFactor,Hp*_.compositeIconSizes[1].evaluate(b,{},A)*_.iconScaleFactor],(d[0]>md||d[1]>md)&&ft(`${t.layerIds[0]}: Value for "icon-size" is >= ${dd}. Reduce your "icon-size".`)),t.addSymbols(t.icon,s,d,v,x,b,!1,r,e,P.lineStartIndex,P.lineLength,-1,M,A,S,I),O=t.icon.placedSymbolArray.length-1,f&&(L=4*f.length,t.addSymbols(t.icon,f,d,v,x,b,xf.vertical,r,e,P.lineStartIndex,P.lineLength,-1,M,A,S,I),N=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const a=i.horizontal[n];z||(j=ge(a.text),d?B=vd(a):z=xd(u,q,e,c,h,p,a,f,l.layout.get("text-rotate").evaluate(b,{},A),m));const o=1===a.positionedLines.length;if(R+=yd(t,r,e,a,s,l,d,b,m,P,i.vertical?xf.horizontal:xf.horizontalOnly,o?Object.keys(i.horizontal):[n],U,O,_,M,A,S),o)break}i.vertical&&(F+=yd(t,r,e,i.vertical,s,l,d,b,m,P,xf.vertical,["vertical"],U,N,_,M,A,S));let X=-1;const Z=(t,e)=>t?Math.max(t,e):e;X=Z(B,X),X=Z(C,X),X=Z(V,X);const H=X>-1?1:0;t.glyphOffsetArray.length>=65535&&ft("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,q.x,q.y,q.z,U.right>=0?U.right:-1,U.center>=0?U.center:-1,U.left>=0?U.left:-1,U.vertical>=0?U.vertical:-1,O,N,j,void 0!==z?z:t.collisionBoxArray.length,void 0!==z?z+1:t.collisionBoxArray.length,void 0!==k?k:t.collisionBoxArray.length,void 0!==k?k+1:t.collisionBoxArray.length,void 0!==E?E:t.collisionBoxArray.length,void 0!==E?E+1:t.collisionBoxArray.length,T||t.collisionBoxArray.length,T?T+1:t.collisionBoxArray.length,c,R,F,D,L,H,0,G,Y,X,0,$?1:0);}(t,o,y,s,r,n,i,D,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,A,P,l,0,S,z,g,e,a,u,c,h,f,d);};if("line"===E)for(const i of Uf(e.geometry,0,0,Wr,Wr)){const e=Of(i,M,I,r.vertical||x,n,b,w,t.overscaling,Wr);for(const r of e)x&&bd(t,x.text,k,r)||L(i,r,h);}else if("line-center"===E){for(const t of e.geometry)if(t.length>1){const e=Ff(t,I,r.vertical||x,n,b,w);e&&L(t,e,h);}}else if("Polygon"===e.type)for(const t of Lc(e.geometry,0)){const e=sd(t,16);L(t[0],new Cf(e.x,e.y,0,0,void 0),h);}else if("LineString"===e.type)for(const t of e.geometry)L(t,new Cf(t[0].x,t[0].y,0,0,void 0),h);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)L([e],new Cf(e.x,e.y,0,0,void 0),h);}const dd=255,md=dd*Hp;function yd(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g){const x=function(t,e,r,n,i,a,s,o){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,f=h/p;let d=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];d=ad(e,f,d,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let a=gf+1,h=!0,p=1,f=0;if(t.imageName){const e=s[tr.build(t.imageName).getSerializedPrimary()];if(!e)continue;if(e.sdf){ft("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,a=qf/p;}const m=(i||o)&&t.vertical,y=t.metrics.advance*t.scale/2,g=t.metrics,x=t.rect;if(null===x)continue;o&&e.verticalizable&&(f=t.imageName?y-t.metrics.width*t.scale/2:0);const v=i?[t.x+y,t.y]:[0,0];let b=[0,0],_=[0,0],w=!1;i||(m?(_=[t.x+y+c[0],t.y+c[1]-f],w=!0):b=[t.x+y+r[0],t.y+r[1]-f]);const M=x.w*t.scale/(p*(t.localGlyph?Hf:1)),A=x.h*t.scale/(p*(t.localGlyph?Hf:1));let S,I,P,z;if(m){const e=t.y-d,r=new q(-y,y-e),n=-Math.PI/2,i=new q(..._);S=new q(-y+b[0],b[1]),S._rotateAround(n,r)._add(i),S.x+=-e+y,S.y-=(g.left-a)*t.scale;const s=t.imageName?g.advance*t.scale:Zp*t.scale,o=String.fromCodePoint(t.glyph);nf(o)?S.x+=(1-a)*t.scale:af(o)?S.x+=s-g.height*t.scale+(-a-1)*t.scale:S.x+=t.imageName||g.width+2*a===x.w&&g.height+2*a===x.h?(s-A)/2:(s-(g.height+2*a)*t.scale)/2,I=new q(S.x,S.y-M),P=new q(S.x+A,S.y),z=new q(S.x+A,S.y-M);}else {const e=(g.left-a)*t.scale-y+b[0],r=(-g.top-a)*t.scale+b[1],n=e+M,i=r+A;S=new q(e,r),I=new q(n,r),P=new q(e,i),z=new q(n,i);}if(u){let t;t=i?new q(0,0):w?new q(c[0],c[1]):new q(r[0],r[1]),S._rotateAround(u,t),I._rotateAround(u,t),P._rotateAround(u,t),z._rotateAround(u,t);}const E=new q(0,0),k=new q(0,0);l.push({tl:S,tr:I,bl:P,br:z,texPrimary:n,texSecondary:void 0,writingMode:e.writingMode,glyphOffset:v,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:E,pixelOffsetBR:k,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,a,s,o,i,t.allowVerticalPlacement),v=t.textSizeData;let b=null;"source"===v.kind?(b=[Hp*a.layout.get("text-size").evaluate(o,{},y)*d.textScaleFactor],b[0]>md&&ft(`${t.layerIds[0]}: Value for "text-size" is >= ${dd}. Reduce your "text-size".`)):"composite"===v.kind&&(b=[Hp*d.compositeTextSizes[0].evaluate(o,{},y)*d.textScaleFactor,Hp*d.compositeTextSizes[1].evaluate(o,{},y)*d.textScaleFactor],(b[0]>md||b[1]>md)&&ft(`${t.layerIds[0]}: Value for "text-size" is >= ${dd}. Reduce your "text-size".`)),t.addSymbols(t.text,x,b,l,s,o,c,e,r,u.lineStartIndex,u.lineLength,f,m,y,g,!1);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*x.length}function gd(t){for(const e in t)return t[e];return null}function xd(t,e,r,n,i,a,s,o,l,u){let c=s.top,h=s.bottom,p=s.left,f=s.right;const d=s.collisionPadding;if(d&&(p-=d[0],c-=d[1],f+=d[2],h+=d[3]),l){const t=new q(p,c),e=new q(f,c),r=new q(p,h),n=new q(f,h),i=X(l);let a=new q(0,0);u&&(a=new q(u[0],u[1])),t._rotateAround(i,a),e._rotateAround(i,a),r._rotateAround(i,a),n._rotateAround(i,a),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),c=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,p,c,f,h,o,n,i,a),t.length-1}function vd(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function bd(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function _d(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),a=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01));let s=Math.sin(t._pitch)*a+i;const o=i*(1/t._horizonShift);if(!t.elevation||0===t.elevation.exaggeration()){let e=Math.max(t.zoom-17,0);t.isOrthographic&&(e/=10),s*=1+e;}return Math.min(1.01*s,o)}function wd(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,a=t.y*r,s=(t.y+1)*r,o=pl(n),l=pl(i),u=fl(a),c=fl(s),h=e.project(o,u),p=e.project(l,u),f=e.project(l,c),d=e.project(o,c);let m=Math.min(h.x,p.x,f.x,d.x),y=Math.min(h.y,p.y,f.y,d.y),g=Math.max(h.x,p.x,f.x,d.x),x=Math.max(h.y,p.y,f.y,d.y);const v=r/16;function b(t,r,n,i,a,s){const o=(n+a)/2,l=(i+s)/2,u=e.project(pl(o),fl(l)),c=Math.max(0,m-u.x,y-u.y,u.x-g,u.y-x);m=Math.min(m,u.x),g=Math.max(g,u.x),y=Math.min(y,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,o,l),b(u,r,o,l,a,s));}b(h,p,n,a,i,a),b(p,f,i,a,i,s),b(f,d,i,s,n,s),b(d,h,n,s,n,a),m-=v,y-=v,g+=v,x+=v;const _=1/Math.max(g-m,x-y);return {scale:_,x:m*_,y:y*_,x2:g*_,y2:x*_,projection:e}}function Md(t,{x:e,y:r},n=0){return new q(((e-n)*t.scale-t.x)*Wr,(r*t.scale-t.y)*Wr)}const Ad=O.mat4.identity(new Float32Array(16));class Sd{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new il(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r=!0){return t._coordinatePoint(t.locationCoordinate(e),r)}pixelsPerMeter(t,e){return hl(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return _d(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),a=new q(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(a,n))}pointCoordinate3D(t,e,r){const n=new q(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation&&t.elevation.visibleDemTiles.length)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return Ad}createTileMatrix(t,e,r){let n,i,a;const s=r.canonical,o=O.mat4.identity(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=wd(s,this);n=1,i=l.x+r.wrap*l.scale,a=l.y,O.mat4.scale(o,o,[n/l.scale,n/l.scale,t.pixelsPerMeter/e]);}else n=e/t.zoomScale(s.z),i=(s.x+Math.pow(2,s.z)*r.wrap)*n,a=s.y*n;return O.mat4.translate(o,o,[i,a,0]),O.mat4.scale(o,o,[n/Wr,n/Wr,1]),o}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class Id extends Sd{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin(X(e));this.n=(n+Math.sin(X(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,a=X(t-this.center[0]),s=X(e),o=Math.sqrt(n-2*r*Math.sin(s))/r;return {x:o*Math.sin(a*r),y:o*Math.cos(a*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,a=i+e;let s=Math.atan2(t,Math.abs(a))*Math.sign(a);a*r<0&&(s-=Math.PI*Math.sign(t)*Math.sign(a));const o=X(this.center[0])*r;s=et(s,-Math.PI-o,Math.PI-o);const l=Q(Z(s/r)+this.center[0],-180,180),u=Math.asin(Q((n-(t*t+a*a)*r*r)/(2*r),-1,1)),c=Q(Z(u),-ml,ml);return new il(l,c)}}const Pd=1.340264,zd=-.081106,Ed=893e-6,kd=.003796,Td=Math.sqrt(3)/2;class Bd extends Sd{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(Td*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(Td*(Pd+3*zd*n+i*(7*Ed+9*kd*n)))/Math.PI+.5),y:1-.5*(r*(Pd+zd*n+i*(Ed+kd*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,a,s,o=0;o<12&&(a=r*(Pd+zd*n+i*(Ed+kd*n))-e,s=Pd+3*zd*n+i*(7*Ed+9*kd*n),t=a/s,r=Q(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++o);const a=Td*t*(Pd+3*zd*n+i*(7*Ed+9*kd*n))/Math.cos(r),s=Math.asin(Math.sin(r)/Td),o=Q(180*a/Math.PI,-180,180),l=Q(180*s/Math.PI,-ml,ml);return new il(o,l)}}class Cd extends Sd{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=Q(360*(.5-e),-ml,ml);return new il(r,n)}}const Vd=Math.PI/2;function Dd(t){return Math.tan((Vd+t)/2)}class Ld extends Sd{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=X(e),i=X(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const a=Math.cos(n),s=Dd(n);this.n=n===i?Math.sin(n):Math.log(a/Math.cos(i))/Math.log(Dd(i)/s),this.f=a*Math.pow(Dd(n),this.n)/this.n;}project(t,e){e=X(e),this.southernCenter&&(e=-e),t=X(t-this.center[0]);const r=1e-6,{n,f:i}=this;i>0?e<-Vd+r&&(e=-Vd+r):e>Vd-r&&(e=Vd-r);const a=i/Math.pow(Dd(e),n);let s=a*Math.sin(n*t),o=i-a*Math.cos(n*t);return s=.5*(s/Math.PI+.5),o=.5*(o/Math.PI+.5),{x:s,y:this.southernCenter?o:1-o,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,a=Math.sign(i),s=Math.sign(r)*Math.sqrt(t*t+i*i);let o=Math.atan2(t,Math.abs(i))*a;i*r<0&&(o-=Math.PI*Math.sign(t)*a);const l=Q(Z(o/r)+this.center[0],-180,180),u=Q(Z(2*Math.atan(Math.pow(n/s,1/r))-Vd),-ml,ml);return new il(l,this.southernCenter?-u:u)}}class Rd extends Sd{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:ul(t),y:cl(e),z:0}}unproject(t,e){const r=pl(t),n=fl(e);return new il(r,n)}}const Fd=X(ml);class Od extends Sd{project(t,e){const r=(e=X(e))*e,n=r*r;return {x:.5*((t=X(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,a=r*r;do{a=r*r;const t=a*a;i=(r*(1.007226+a*(.015085+t*(.028874*a-.044475-.005916*t)))-e)/(1.007226+a*(.045255+t*(.259866*a-.311325-.005916*11*t))),r=Q(r-i,-Fd,Fd);}while(Math.abs(i)>1e-6&&--n>0);a=r*r;const s=Q(Z(t/(.8707+a*(a*(a*a*a*(.003971-.001529*a)-.013791)-.131979))),-180,180),o=Z(r);return new il(s,o)}}const Nd=X(ml);class Ud extends Sd{project(t,e){e=X(e),t=X(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),a=Math.sin(i)/i,s=.5*(t*n+2*r*Math.sin(t/2)/a)||0,o=.5*(e+Math.sin(e)/a)||0;return {x:.5*(s/Math.PI+.5),y:1-.5*(o/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const a=1e-6;let s=0,o=0;do{const i=Math.cos(n),a=Math.sin(n),l=2*a*i,u=a*a,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),f=2*h*p,d=p*p,m=1-c*h*h,y=m?1/m:0,g=m?Math.acos(i*h)*Math.sqrt(1/m):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*a+n)-e,b=.5*y*(c*d+g*i*h*u)+1/Math.PI,_=y*(f*l/4-g*a*p),w=.125*y*(l*p-g*a*c*f),M=.5*y*(u*h+g*d*i)+.5,A=_*w-M*b;s=(v*_-x*M)/A,o=(x*w-v*b)/A,r=Q(r-s,-Math.PI,Math.PI),n=Q(n-o,-Nd,Nd);}while((Math.abs(s)>a||Math.abs(o)>a)&&--i>0);return new il(Z(r),Z(n))}}class jd extends Sd{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(X(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:X(t)*n*r+.5,y:-Math.sin(X(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,a=Q(Z((t-.5)/r)/n,-180,180),s=Math.asin(Q(i*n,-1,1)),o=Q(Z(s),-ml,ml);return new il(a,o)}}class qd extends Rd{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(t,e,r){const n=ku(t,e,r),i=Cu(Au(r));return O.vec3.transformMat4(n,n,i),{x:n[0],y:n[1],z:n[2]}}locationPoint(t,e){const r=el(e.lat,e.lng),n=O.vec3.normalize([],r),i=t.elevation?t.elevation.getAtPointOrZero(t.locationCoordinate(e),t._centerAltitude):t._centerAltitude,a=hl(1,0)*Wr*i;O.vec3.scaleAndAdd(r,r,n,a);const s=O.mat4.identity(new Float64Array(16));return O.mat4.multiply(s,t.pixelMatrix,t.globeMatrix),O.vec3.transformMat4(r,r,s),new q(r[0],r[1])}pixelsPerMeter(t,e){return hl(1,0)*e}pixelSpaceConversion(t,e,r){const n=hl(1,t)*e,i=ze(hl(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(t,e,r){const n=Vu(Au(r.canonical));return O.mat4.multiply(new Float64Array(16),t.globeMatrix,n)}createInversionMatrix(t,e){const{center:r}=t,n=Cu(Au(e));return O.mat4.rotateY(n,n,X(r.lng)),O.mat4.rotateX(n,n,X(r.lat)),O.mat4.scale(n,n,[t._pixelsPerMercatorPixel,t._pixelsPerMercatorPixel,1]),Float32Array.from(n)}pointCoordinate(t,e,r,n){return _u(t,e,r,!0)||new bl(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !_u(t,e.x,e.y,!1)}farthestPixelDistance(t){const e=function(t,e){const r=t.cameraToCenterDistance,n=t._centerAltitude*e,i=t._camera,a=t._camera.forward(),s=O.vec3.add([],O.vec3.scale([],a,-r),[0,0,n]),o=t.worldSize/(2*Math.PI),l=[0,0,-o],u=t.width/t.height,c=Math.tan(t.fovAboveCenter),h=O.vec3.scale([],i.up(),c),p=O.vec3.scale([],i.right(),c*u),f=O.vec3.normalize([],O.vec3.add([],O.vec3.add([],a,h),p)),d=[];let m;if(new hu(s,f).closestPointOnSphere(l,o,d)){const e=O.vec3.add([],d,l),r=O.vec3.sub([],e,s);m=Math.cos(t.fovAboveCenter)*O.vec3.length(r);}else {const t=O.vec3.sub([],s,l),e=O.vec3.sub([],l,s);O.vec3.normalize(e,e);const r=O.vec3.length(t)-o;m=Math.sqrt(r*(r+2*o));const n=Math.acos(m/(o+r))-Math.acos(O.vec3.dot(a,e));m*=Math.cos(n);}return 1.01*m}(t,this.pixelsPerMeter(t.center.lat,t.worldSize)),r=Fu(t.zoom);if(r>0){const n=_d(t,hl(1,t.center.lat)*t.worldSize),i=t.worldSize/(2*Math.PI),a=Math.max(t.width,t.height)/t.worldSize*Math.PI;return ze(e,n+i*(1-Math.cos(a)),Math.pow(r,10))}return e}upVector(t,e,r){return ku(e,r,t,1)}upVectorScale(t){return {metersToTile:vu(Tu(Au(t)))}}}function $d(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case"mercator":return new Rd(t);case"equirectangular":return new Cd(t);case"naturalEarth":return new Od(t);case"equalEarth":return new Bd(t);case"winkelTripel":return new Ud(t);case"albers":return r?new jd(t):new Id(t);case"lambertConformalConic":return r?new jd(t):new Ld(t);case"globe":return new qd(t)}throw new Error(`Invalid projection name: ${t.name}`)}const Gd=fh.VectorTileFeature.types,Yd=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Xd(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=o?Math.min(md,Math.round(o[0])):0,d=o?Math.min(md,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),a,s,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function Zd(t,e,r){t.emplaceBack(e,r);}function Hd(t,e,r,n,i,a,s){t.emplaceBack(e,r,n,i,a,s);}function Wd(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function Kd(t){for(const e of t.sections)if(ba(e.text))return !0;return !1}class Jd{constructor(t){this.layoutVertexArray=new Ps,this.indexArray=new Ls,this.programConfigurations=t,this.segments=new po,this.dynamicLayoutVertexArray=new Es,this.opacityVertexArray=new ks,this.placedSymbolArray=new to,this.iconTransitioningVertexArray=new Ts,this.globeExtVertexArray=new zs,this.zOffsetVertexArray=new Os;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}upload(t,e,r,n,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Op.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Up.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Yd,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=t.createVertexBuffer(this.iconTransitioningVertexArray,qp.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Np.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||i)&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,jp.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy());}}oa(Jd,"SymbolBuffers");class Qd{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new po,this.collisionVertexArray=new Ds,this.collisionVertexArrayExt=new Es;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,$p.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,Gp.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}oa(Qd,"CollisionBuffers");class tm{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.lut=t.lut,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=O.mat4.identity([]),this.placementViewportMatrix=O.mat4.identity([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Kp(this.zoom,e["text-size"]),this.iconSizeData=Kp(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=r.get("text-writing-mode").map((t=>xf[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID,this.projection=t.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=r.get("symbol-z-elevate"),this.activeReplacements=[],this.replacementUpdateTime=0;}createArrays(){this.text=new Jd(new No(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("text")||t.startsWith("symbol")))),this.icon=new Jd(new No(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("icon")||t.startsWith("symbol")))),this.glyphOffsetArray=new no,this.lineVertexArray=new io,this.symbolInstances=new ro;}calculateGlyphDependencies(t,e,r,n,i){for(const r of t){const t=r.codePointAt(0);if(void 0===t)break;if(e[t]=!0,n&&i&&t<=65535){const t=rf[r];t&&(e[t.charCodeAt(0)]=!0);}}}updateFootprints(t,e){}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);return !Ah(this.activeReplacements,r)&&(this.activeReplacements=r,!0)}populate(t,e,r,n){const i=this.layers[0],a=i.layout,s="globe"===this.projection.name,o=a.get("text-font"),l=a.get("text-field"),u=a.get("icon-image"),[c,h]=a.get("icon-size-scale-range"),p=Q(e.scaleFactor||1,c,h),f=("constant"!==l.value.kind||l.value.value instanceof Je&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==o.value.kind||o.value.value.length>0),d="constant"!==u.value.kind||!!u.value.value||Object.keys(u.parameters).length>0,m=a.get("symbol-sort-key");if(this.features=[],!f&&!d)return;const y=e.iconDependencies,g=e.glyphDependencies,x=e.availableImages,v=new Ca(this.zoom);for(const{feature:e,id:l,index:u,sourceLayerIndex:c}of t){const t=i._featureFilter.needGeometry,h=El(e,t);if(!i._featureFilter.filter(v,h,r))continue;if(t||(h.geometry=zl(e,r,n)),s&&1!==e.type&&r.z<=5){const t=h.geometry,e=.98078528056,n=(t,n)=>{const i=ku(t.x,t.y,r,1),a=ku(n.x,n.y,r,1);return O.vec3.dot(i,a)<e};for(let e=0;e<t.length;e++)t[e]=Al(t[e],n);}let b,_;if(f){const t=i.getValueAndResolveTokens("text-field",h,r,x),e=Je.factory(t);Kd(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===ka()||this.hasRTLText&&Ba.isParsed())&&(b=ef(e,i,h));}if(d){const t=i.getValueAndResolveTokens("icon-image",h,r,x);_=t instanceof tr?t:tr.build(t);}if(!b&&!_)continue;const w=this.sortFeaturesByKey?m.evaluate(h,{},r):void 0,M={id:l,text:b,icon:_,index:u,sourceLayerIndex:c,geometry:h.geometry,properties:e.properties,type:Gd[e.type],sortKey:w};if(this.features.push(M),_){const t=Wp(this.iconSizeData,this.layers[0]._unevaluatedLayout._values["icon-size"],r,this.zoom,M)*p*this.pixelRatio,e=_.getPrimary().scaleSelf(t);if(y[e.id]=y[e.id]||[],y[e.id].push(e),_.nameSecondary){const e=_.getSecondary().scaleSelf(t);y[e.id]=y[e.id]||[],y[e.id].push(e);}}if(b){const t=o.evaluate(h,{},r).join(","),e="map"===a.get("text-rotation-alignment")&&"point"!==a.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(xf.vertical)>=0;for(const r of b.sections)if(r.image){const t=r.image.getPrimary().scaleSelf(this.pixelRatio);y[t.id]=y[t.id]||[],y[t.id].push(t);}else {const n=fa(b.toString()),i=r.fontStack||t,a=g[i]=g[i]||{};this.calculateGlyphDependencies(r.text,a,e,this.allowVerticalPlacement,n);}}}"line"===a.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function a(e){n.push(t[e]),i++;}function s(t,e,i){const a=r[t];return delete r[t],r[e]=a,n[a].geometry[0].pop(),n[a].geometry[0]=n[a].geometry[0].concat(i[0]),a}function o(t,r,i){const a=e[r];return delete e[r],e[t]=a,n[a].geometry[0].shift(),n[a].geometry[0]=i[0].concat(n[a].geometry[0]),a}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){a(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=s(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?s(f,d,h):d in e?o(f,d,h):(a(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n,i,a,s){this.text.programConfigurations.updatePaintArrays(t,e,i,r,n,a,s),this.icon.programConfigurations.updatePaintArrays(t,e,i,r,n,a,s);}updateZOffset(){const t=(t,e,n)=>{r+=e,r>t.length&&t.resize(r);for(let i=-e;i<0;i++)t.emplace(i+r,n);},e=(t,e,r)=>{n+=e,n>t.length&&t.resize(n);for(let i=-e;i<0;i++)t.emplace(i+n,r);};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let r=0,n=0;for(let r=0;r<this.symbolInstances.length;r++){const n=this.symbolInstances.get(r),{numHorizontalGlyphVertices:i,numVerticalGlyphVertices:a,numIconVertices:s}=n,o=n.zOffset,l=s>0;if((i>0||a>0)&&(t(this.text.zOffsetVertexArray,i,o),t(this.text.zOffsetVertexArray,a,o)),l){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=n;t>=0&&e(this.icon.zOffsetVertexArray,s,o),r>=0&&e(this.icon.zOffsetVertexArray,n.numVerticalIconVertices,o);}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=$d(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m){const y=t.indexArray,g=t.layoutVertexArray,x=t.globeExtVertexArray,v=t.segments.prepareSegment(4*e.length,g,y,this.canOverlap?a.sortKey:void 0),b=this.glyphOffsetArray.length,_=v.vertexLength,w=this.allowVerticalPlacement&&s===xf.vertical?Math.PI/2:0,M=a.text&&a.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:s,bl:u,br:c,texPrimary:h,texSecondary:b,pixelOffsetTL:_,pixelOffsetBR:A,minFontScaleX:S,minFontScaleY:I,glyphOffset:P,isSDF:z,sectionIndex:E}=e[n],k=v.vertexLength,T=P[1];if(Xd(g,l.x,l.y,i.x,T+i.y,h.x,h.y,r,z,_.x,_.y,S,I),Xd(g,l.x,l.y,s.x,T+s.y,h.x+h.w,h.y,r,z,A.x,_.y,S,I),Xd(g,l.x,l.y,u.x,T+u.y,h.x,h.y+h.h,r,z,_.x,A.y,S,I),Xd(g,l.x,l.y,c.x,T+c.y,h.x+h.w,h.y+h.h,r,z,A.x,A.y,S,I),o){const{x:e,y:r,z:n}=o.anchor,[i,a,s]=o.up;Hd(x,e,r,n,i,a,s),Hd(x,e,r,n,i,a,s),Hd(x,e,r,n,i,a,s),Hd(x,e,r,n,i,a,s),Wd(t.dynamicLayoutVertexArray,e,r,n,w);}else Wd(t.dynamicLayoutVertexArray,l.x,l.y,l.z,w);if(m){const e=b||h;Zd(t.iconTransitioningVertexArray,e.x,e.y),Zd(t.iconTransitioningVertexArray,e.x+e.w,e.y),Zd(t.iconTransitioningVertexArray,e.x,e.y+e.h),Zd(t.iconTransitioningVertexArray,e.x+e.w,e.y+e.h);}y.emplaceBack(k,k+1,k+2),y.emplaceBack(k+1,k+2,k+3),v.vertexLength+=4,v.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(P[0]),n!==e.length-1&&E===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(g.length,a,a.index,{},p,f,d,M&&M[E]);}const A=o?o.anchor:l;t.placedSymbolArray.emplaceBack(A.x,A.y,A.z,l.x,l.y,b,this.glyphOffsetArray.length-b,_,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],s,0,!1,0,h,0);}_commitLayoutVertex(t,e,r,n,i,a,s){t.emplaceBack(e,r,n,i,a,Math.round(s.x),Math.round(s.y));}_addCollisionDebugVertices(t,e,r,n,i,a,s){const o=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=o.vertexLength,u=s.tileAnchorX,c=s.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0,0,0);this._commitDebugCollisionVertexUpdate(r.collisionVertexArrayExt,e,t.padding,s.zOffset),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new q(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new q(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new q(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new q(t.x1,t.y2)),o.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),o.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,a){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceTextSize(t,a,e,s);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,a);}}_addIconDebugCollisionBoxes(t,e,r,n,i,a){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceIconSize(t,e,a.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,a);}}generateCollisionDebugBuffers(t,e,r){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Qd(Cs,Yp.members,Ts),this.iconCollisionBox=new Qd(Cs,Yp.members,Ts);const n=Qp(this.iconSizeData,t),i=Qp(this.textSizeData,t,r);for(let r=0;r<this.symbolInstances.length;r++){const a=this.symbolInstances.get(r);this._addTextDebugCollisionBoxes(i,t,e,a.textBoxStartIndex,a.textBoxEndIndex,a),this._addTextDebugCollisionBoxes(i,t,e,a.verticalTextBoxStartIndex,a.verticalTextBoxEndIndex,a),this._addIconDebugCollisionBoxes(n,t,e,a.iconBoxStartIndex,a.iconBoxEndIndex,a),this._addIconDebugCollisionBoxes(n,t,e,a.verticalIconBoxStartIndex,a.verticalIconBoxEndIndex,a);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),a=Jp(this.textSizeData,t,i)/Zp;return this.tilePixelRatio*a}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=Jp(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r,n){t.emplaceBack(e,-r,-r,n),t.emplaceBack(e,r,-r,n),t.emplaceBack(e,r,r,n),t.emplaceBack(e,-r,r,n);}_updateTextDebugCollisionBoxes(t,e,r,n,i,a,s){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceTextSize(t,a,e,s);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding,a.zOffset);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,a,s){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceIconSize(t,e,a.placedIconSymbolIndex);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding,a.zOffset);}}updateCollisionDebugBuffers(t,e,r,n){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const i=Qp(this.iconSizeData,t,n),a=Qp(this.textSizeData,t,r);for(let s=0;s<this.symbolInstances.length;s++){const o=this.symbolInstances.get(s);this._updateTextDebugCollisionBoxes(a,t,e,o.textBoxStartIndex,o.textBoxEndIndex,o,r),this._updateTextDebugCollisionBoxes(a,t,e,o.verticalTextBoxStartIndex,o.verticalTextBoxEndIndex,o,r),this._updateIconDebugCollisionBoxes(i,t,e,o.iconBoxStartIndex,o.iconBoxEndIndex,o,n),this._updateIconDebugCollisionBoxes(i,t,e,o.verticalIconBoxStartIndex,o.verticalIconBoxEndIndex,o,n);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,a,s,o,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=f;}if(n<i){const{x1:e,y1:r,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=f;}if(a<s){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(a);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=f;}if(o<l){const{x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(o);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=f;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],a=[];for(let t=0;t<this.symbolInstances.length;++t){a.push(t);const s=this.symbolInstances.get(t);n.push(0|Math.round(e*s.tileAnchorX+r*s.tileAnchorY)),i.push(s.featureIndex);}return a.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),a}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let t=0;t<this.symbolInstances.length;++t)this.symbolInstanceIndexesSortedZOffset.push(t);}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((t,e)=>this.symbolInstances.get(e).zOffset-this.symbolInstances.get(t).zOffset))}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:a,placedIconSymbolIndex:s,verticalPlacedIconSymbolIndex:o}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),a>=0&&this.addIndicesForPlacedSymbol(this.text,a),s>=0&&this.addIndicesForPlacedSymbol(this.icon,s),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let em,rm,nm;oa(tm,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),tm.addDynamicAttributes=Wd;class im{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:Ve,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}oa(im,"FormatSectionOverride",{omit:["defaultValue"]});const am=()=>nm||(nm={layout:em||(em=new Ga({"symbol-placement":new ja(Ya.layout_symbol["symbol-placement"]),"symbol-spacing":new ja(Ya.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new ja(Ya.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new qa(Ya.layout_symbol["symbol-sort-key"]),"symbol-z-order":new ja(Ya.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new ja(Ya.layout_symbol["symbol-z-elevate"]),"symbol-elevation-reference":new ja(Ya.layout_symbol["symbol-elevation-reference"]),"icon-allow-overlap":new ja(Ya.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new ja(Ya.layout_symbol["icon-ignore-placement"]),"icon-optional":new ja(Ya.layout_symbol["icon-optional"]),"icon-rotation-alignment":new ja(Ya.layout_symbol["icon-rotation-alignment"]),"icon-size":new qa(Ya.layout_symbol["icon-size"]),"icon-size-scale-range":new ja(Ya.layout_symbol["icon-size-scale-range"]),"icon-text-fit":new qa(Ya.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new qa(Ya.layout_symbol["icon-text-fit-padding"]),"icon-image":new qa(Ya.layout_symbol["icon-image"]),"icon-rotate":new qa(Ya.layout_symbol["icon-rotate"]),"icon-padding":new ja(Ya.layout_symbol["icon-padding"]),"icon-keep-upright":new ja(Ya.layout_symbol["icon-keep-upright"]),"icon-offset":new qa(Ya.layout_symbol["icon-offset"]),"icon-anchor":new qa(Ya.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new ja(Ya.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new ja(Ya.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new ja(Ya.layout_symbol["text-rotation-alignment"]),"text-field":new qa(Ya.layout_symbol["text-field"]),"text-font":new qa(Ya.layout_symbol["text-font"]),"text-size":new qa(Ya.layout_symbol["text-size"]),"text-size-scale-range":new ja(Ya.layout_symbol["text-size-scale-range"]),"text-max-width":new qa(Ya.layout_symbol["text-max-width"]),"text-line-height":new qa(Ya.layout_symbol["text-line-height"]),"text-letter-spacing":new qa(Ya.layout_symbol["text-letter-spacing"]),"text-justify":new qa(Ya.layout_symbol["text-justify"]),"text-radial-offset":new qa(Ya.layout_symbol["text-radial-offset"]),"text-variable-anchor":new ja(Ya.layout_symbol["text-variable-anchor"]),"text-anchor":new qa(Ya.layout_symbol["text-anchor"]),"text-max-angle":new ja(Ya.layout_symbol["text-max-angle"]),"text-writing-mode":new ja(Ya.layout_symbol["text-writing-mode"]),"text-rotate":new qa(Ya.layout_symbol["text-rotate"]),"text-padding":new ja(Ya.layout_symbol["text-padding"]),"text-keep-upright":new ja(Ya.layout_symbol["text-keep-upright"]),"text-transform":new qa(Ya.layout_symbol["text-transform"]),"text-offset":new qa(Ya.layout_symbol["text-offset"]),"text-allow-overlap":new ja(Ya.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new ja(Ya.layout_symbol["text-ignore-placement"]),"text-optional":new ja(Ya.layout_symbol["text-optional"]),visibility:new ja(Ya.layout_symbol.visibility)})),paint:rm||(rm=new Ga({"icon-opacity":new qa(Ya.paint_symbol["icon-opacity"]),"icon-occlusion-opacity":new qa(Ya.paint_symbol["icon-occlusion-opacity"]),"icon-emissive-strength":new qa(Ya.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new qa(Ya.paint_symbol["text-emissive-strength"]),"icon-color":new qa(Ya.paint_symbol["icon-color"]),"icon-halo-color":new qa(Ya.paint_symbol["icon-halo-color"]),"icon-halo-width":new qa(Ya.paint_symbol["icon-halo-width"]),"icon-halo-blur":new qa(Ya.paint_symbol["icon-halo-blur"]),"icon-translate":new ja(Ya.paint_symbol["icon-translate"]),"icon-translate-anchor":new ja(Ya.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new qa(Ya.paint_symbol["icon-image-cross-fade"]),"text-opacity":new qa(Ya.paint_symbol["text-opacity"]),"text-occlusion-opacity":new qa(Ya.paint_symbol["text-occlusion-opacity"]),"text-color":new qa(Ya.paint_symbol["text-color"],{runtimeType:Fe,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new qa(Ya.paint_symbol["text-halo-color"]),"text-halo-width":new qa(Ya.paint_symbol["text-halo-width"]),"text-halo-blur":new qa(Ya.paint_symbol["text-halo-blur"]),"text-translate":new ja(Ya.paint_symbol["text-translate"]),"text-translate-anchor":new ja(Ya.paint_symbol["text-translate-anchor"]),"icon-color-saturation":new ja(Ya.paint_symbol["icon-color-saturation"]),"icon-color-contrast":new ja(Ya.paint_symbol["icon-color-contrast"]),"icon-color-brightness-min":new ja(Ya.paint_symbol["icon-color-brightness-min"]),"icon-color-brightness-max":new ja(Ya.paint_symbol["icon-color-brightness-max"]),"symbol-z-offset":new qa(Ya.paint_symbol["symbol-z-offset"]),"icon-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"icon-halo-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"text-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"text-halo-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},nm);class sm extends ps{constructor(t,e,r,n){super(t,am(),e,r,n),this._colorAdjustmentMatrix=O.mat4.identity([]),this.hasInitialOcclusionOpacityProperties=void 0!==t.paint&&("icon-occlusion-opacity"in t.paint||"text-occlusion-opacity"in t.paint);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getColorAdjustmentMatrix(t,e,r,n){return this._saturation===t&&this._contrast===e&&this._brightnessMin===r&&this._brightnessMax===n||(this._colorAdjustmentMatrix=function(t,e,r,n){t=At(t),e=Mt(e);const i=O.mat4.create(),a=t/3,s=1-2*a,o=[s,a,a,0,a,s,a,0,a,a,s,0,0,0,0,1],l=.5-.5*e,u=n-r;return O.mat4.multiply(i,[u,0,0,0,0,u,0,0,0,0,u,0,r,r,r,1],[e,0,0,0,0,e,0,0,0,0,e,0,l,l,l,1]),O.mat4.multiply(i,i,o),i}(t,e,r,n),this._saturation=t,this._contrast=e,this._brightnessMin=r,this._brightnessMax=n),this._colorAdjustmentMatrix}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),a=this._unevaluatedLayout._values[t];return a.isDataDriven()||Hi(a.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new tm(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of am().paint.overridableProperties){if(!sm.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new im(e),n=new Zi(r,e.property.specification,this.scope,this.options);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Ki("source",n):new Ji("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new Na(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&sm.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=am().paint.properties[e];let i=!1;const a=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Je)a(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof ar&&nr(e.value)===je?a(e.value.sections):e instanceof ur?a(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramIds(){return ["symbol"]}getDefaultProgramParams(t,e,r){return {config:new Oo(this,{zoom:e,lut:r}),overrideFog:!1}}}let om,lm,um,cm;var hm=ys([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);function pm(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.RGBA;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.DEPTH_COMPONENT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.DEPTH_STENCIL;case WebGL2RenderingContext.R8:case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.RED}}function fm(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.UNSIGNED_SHORT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.UNSIGNED_INT_24_8;case WebGL2RenderingContext.R8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.FLOAT}}class dm{constructor(t,e,r,n){this.context=t,this.format=r,this.useMipmap=n&&n.useMipmap,this.texture=t.gl.createTexture(),this.update(e,{premultiply:n&&n.premultiply});}update(t,e){const r=t&&t instanceof HTMLVideoElement&&0===t.width?t.videoWidth:t.width,n=t&&t instanceof HTMLVideoElement&&0===t.height?t.videoHeight:t.height,{context:i}=this,{gl:a}=i,{x:s,y:o}=e&&e.position?e.position:{x:0,y:0},l=s+r,u=o+n;!this.size||this.size[0]===l&&this.size[1]===u||(a.bindTexture(a.TEXTURE_2D,null),a.deleteTexture(this.texture),this.texture=a.createTexture(),this.size=null),a.bindTexture(a.TEXTURE_2D,this.texture),i.pixelStoreUnpackFlipY.set(!1),i.pixelStoreUnpack.set(1),i.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA8&&(!e||!1!==e.premultiply));const c=t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap;if(!this.size&&l>0&&u>0){const t=this.useMipmap?Math.floor(Math.log2(Math.max(l,u)))+1:1;a.texStorage2D(a.TEXTURE_2D,t,this.format,l,u),this.size=[l,u];}if(this.size)if(c)a.texSubImage2D(a.TEXTURE_2D,0,s,o,pm(this.format),fm(this.format),t);else {const e=t.data;e&&a.texSubImage2D(a.TEXTURE_2D,0,s,o,r,n,pm(this.format),fm(this.format),e);}this.useMipmap&&a.generateMipmap(a.TEXTURE_2D);}bind(t,e,r=!1){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),t!==this.minFilter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,this.useMipmap&&!r?t===i.NEAREST?i.NEAREST_MIPMAP_NEAREST:i.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),e!==this.wrapS&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrapS=e);}bindExtraParam(t,e,r,n){const{context:i}=this,{gl:a}=i;a.bindTexture(a.TEXTURE_2D,this.texture),e!==this.magFilter&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,e),this.magFilter=e),t!==this.minFilter&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,this.useMipmap?t===a.NEAREST?a.NEAREST_MIPMAP_NEAREST:a.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),r!==this.wrapS&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,r),this.wrapS=r),n!==this.wrapT&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,n),this.wrapT=n);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class mm{constructor(t,e){this.context=t,this.texture=e;}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}}function ym(t,e,r,n,i,a,s,o){const l=[t,e,1,r,n,1,i,a,1],u=[s,o,1],c=O.mat3.adjoint([],l),[h,p,f]=O.vec3.transformMat3(u,u,c);return O.mat3.multiply(l,l,[h,0,0,0,p,0,0,0,f])}function gm(t,e,r,n,i,a,s,o){const l=function(t,e,r,n,i,a,s,o){const l=ym(0,0,1,0,1,1,0,1),u=ym(t,e,r,n,i,a,s,o),c=O.mat3.adjoint([],l);return O.mat3.multiply(u,u,c)}(t,e,r,n,i,a,s,o);return [l[2]/l[8]/Wr,l[5]/l[8]/Wr]}function xm(t){return [t[0],Math.min(Math.max(t[1],-ml),ml)]}class vm extends we{constructor(t,e,r,n){super(),this.id=t,this.dispatcher=r,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(n),this.options=e,this._dirty=!1;}load(t,e){if(this._loaded=e||!1,this.fire(new xe("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=ue(this.map._requestManager.transformRequest(this.url,te.Image),((e,r)=>{this._imageRequest=null,this._loaded=!0,e?this.fire(new ve(e)):r&&(this.image=r instanceof HTMLImageElement?Dt.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return t.url?(this._imageRequest&&t.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=t.url,this.load(t.coordinates,this._loaded),this):this}setTexture(t){if(!(t.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new mm(this.map.painter.context,t.handle),this.width=t.dimensions[0],this.height=t.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new xe("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(t){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof mm||this.texture.destroy(),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy());}setCoordinates(t){if(this.coordinates=t,this._boundsArray=void 0,this._unsupportedCoords=!1,!t.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let e=t[0][1],r=t[0][1];for(const n of t)n[1]>r&&(r=n[1]),n[1]<e&&(e=n[1]);const n=(r+e)/2;if(n>ml?this.onNorthPole=!0:n<-ml&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const e=t.map(bl.fromLngLat);this.tileID=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const a of t)e=Math.min(e,a.x),r=Math.min(r,a.y),n=Math.max(n,a.x),i=Math.max(i,a.y);const a=Math.max(n-e,i-r),s=Math.max(0,Math.floor(-Math.log(a)/Math.LN2)),o=Math.pow(2,s);let l=Math.floor((e+n)/2*o);return l>1&&(l-=1),new ru(s,l,Math.floor((r+i)/2*o))}(e),this.minzoom=this.maxzoom=this.tileID.z;}return this.fire(new xe("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0,this._unsupportedCoords=!1;}_prepareData(t){for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}if(this._boundsArray||this.onNorthPole||this.onSouthPole||this._unsupportedCoords)return;const e=wd(new ru(0,0,0),this.map.transform.projection),r=[e.projection.project(this.coordinates[0][0],this.coordinates[0][1]),e.projection.project(this.coordinates[1][0],this.coordinates[1][1]),e.projection.project(this.coordinates[2][0],this.coordinates[2][1]),e.projection.project(this.coordinates[3][0],this.coordinates[3][1])];if(!function(t){const e=t[1].x-t[0].x,r=t[1].y-t[0].y,n=t[2].x-t[1].x,i=t[2].y-t[1].y,a=t[3].x-t[2].x,s=t[3].y-t[2].y,o=t[0].x-t[3].x,l=t[0].y-t[3].y,u=e*i-n*r,c=n*s-a*i,h=a*l-o*s,p=o*r-e*l;return u>0&&c>0&&h>0&&p>0||u<0&&c<0&&h<0&&p<0}(r))return console.warn("Image source coordinates are defining non-convex area in the Mercator projection"),void(this._unsupportedCoords=!0);const n=wd(this.tileID,this.map.transform.projection),[i,a,s,o]=this.coordinates.map((t=>{const e=n.projection.project(t[0],t[1]);return Md(n,e)._round()}));this.perspectiveTransform=gm(i.x,i.y,a.x,a.y,s.x,s.y,o.x,o.y);const l=this._boundsArray=new bs;l.emplaceBack(i.x,i.y,0,0),l.emplaceBack(a.x,a.y,Wr,0),l.emplaceBack(o.x,o.y,0,Wr),l.emplaceBack(s.x,s.y,Wr,Wr),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy()),this.boundsBuffer=t.createVertexBuffer(l,hm.members),this.boundsSegments=po.simpleSegment(0,0,4,2);const u=[],c=[xm((h=this.coordinates)[0]),xm(h[1]),xm(h[2]),xm(h[3])];var h;const[p,f,d,m]=function(t){let e=t[0][0],r=e,n=t[0][1],i=n;for(let a=1;a<t.length;a++)t[a][0]<e?e=t[a][0]:t[a][0]>r&&(r=t[a][0]),t[a][1]<n?n=t[a][1]:t[a][1]>i&&(i=t[a][1]);return [e,n,r-e,i-n]}(c);{const n=new bs,[i,a,s,o]=function(t){let e=t[0].x,r=e,n=t[0].y,i=n;for(let a=1;a<t.length;a++)t[a].x<e?e=t[a].x:t[a].x>r&&(r=t[a].x),t[a].y<n?n=t[a].y:t[a].y>i&&(i=t[a].y);return [e,n,r-e,i-n]}(r),l=t=>[(t.x-i)/s,(t.y-a)/o],[c,h,y,g]=r.map(l),x=function(t,e,r,n,i,a,s,o){const l=ym(0,0,1,0,1,1,0,1),u=ym(t,e,r,n,i,a,s,o),c=O.mat3.adjoint([],u);return O.mat3.multiply(l,l,c)}(c[0],c[1],h[0],h[1],y[0],y[1],g[0],g[1]);this.elevatedGlobePerspectiveTransform=gm(c[0],c[1],h[0],h[1],y[0],y[1],g[0],g[1]);const v=(t,e)=>{u.push(t.lng);const r=Math.round((t.lng-p)/d*Wr),i=Math.round((t.lat-f)/m*Wr),a=l(e),s=O.vec3.transformMat3([],[a[0],a[1],1],x),o=Math.round(s[0]/s[2]*Wr),c=Math.round(s[1]/s[2]*Wr);n.emplaceBack(r,i,o,c);},b=r[3].x-r[0].x,_=r[3].y-r[0].y,w=r[2].x-r[1].x,M=r[2].y-r[1].y;for(let t=0;t<65;t++){const n=t/64,i=[r[0].x+n*b,r[0].y+n*_],a=[r[1].x+n*w,r[1].y+n*M],s=a[0]-i[0],o=a[1]-i[1];for(let t=0;t<65;t++){const r=t/64,n={x:i[0]+s*r,y:i[1]+o*r,z:0};v(e.projection.unproject(n.x,n.y),n);}}this.elevatedGlobeVertexBuffer=t.createVertexBuffer(n,hm.members);}{this.maxLongitudeTriangleSize=0;let e=[],r=new Ls;const n=(t,n,i)=>{r.emplaceBack(t,n,i);const a=u[t],s=u[n],o=u[i],l=Math.min(Math.min(a,s),o),c=Math.max(Math.max(a,s),o)-l;c>this.maxLongitudeTriangleSize&&(this.maxLongitudeTriangleSize=c),e.push(l+c/2);};for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=65*t+e,i=r+1,a=r+65,s=a+1;n(r,a,i),n(i,a,s);}[e,r]=function(t,e){const r=Array.from({length:t.length},((t,e)=>e));r.sort(((e,r)=>t[e]-t[r]));const n=[],i=new Ls;for(let a=0;a<r.length;a++){const s=r[a];n.push(t[s]);const o=3*s,l=o+1;i.emplaceBack(e.uint16[o],e.uint16[l],e.uint16[l+1]);}return [n,i]}(e,r),this.elevatedGlobeTrianglesCenterLongitudes=e,this.elevatedGlobeIndexBuffer=t.createIndexBuffer(r);}this.elevatedGlobeSegments=po.simpleSegment(0,0,4225,8192),this.elevatedGlobeGridMatrix=new Float32Array([0,d/Wr,0,m/Wr,0,0,f,p,0]);}prepare(){const t=0!==Object.keys(this.tiles).length;if(this.tileID&&!t)return;const e=this.map.painter.context,r=e.gl;!this._dirty||this.texture instanceof mm||(this.texture?this.texture.update(this.image):(this.texture=new dm(e,this.image,r.RGBA8),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE)),this._dirty=!1),t&&this._prepareData(e);}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}getSegmentsForLongitude(t){const e=this.elevatedGlobeSegments;if(!this.elevatedGlobeTrianglesCenterLongitudes||!e)return null;const r=this.elevatedGlobeTrianglesCenterLongitudes;let n=(i=t+180)+360*Math.round((r[0]-i)/360);var i;const a=new po,s=(t,r)=>{a.segments.push({vertexOffset:0,primitiveOffset:t,vertexLength:e.segments[0].vertexLength,primitiveLength:r,sortKey:void 0,vaos:{}});},o=.51*this.maxLongitudeTriangleSize;if(Math.abs(r[0]-n)<=o){const t=wt(r,0,r.length,n+o);return t===r.length||s(t,_t(r,t+1,r.length,n+360-o)-t),a}n<r[0]&&(n+=360);const l=_t(r,0,r.length,n-o);if(l===r.length)return s(0,r.length),a;s(0,l-0);const u=wt(r,l+1,r.length,n+o);return u!==r.length&&s(u,r.length-u),a}}const bm=(Math.pow(256,2)-1)/16907520;class _m extends ps{constructor(t,e,r,n){super(t,{layout:um||(um=new Ga({visibility:new ja(Ya.layout_raster.visibility)})),paint:cm||(cm=new Ga({"raster-opacity":new ja(Ya.paint_raster["raster-opacity"]),"raster-color":new $a(Ya.paint_raster["raster-color"]),"raster-color-mix":new ja(Ya.paint_raster["raster-color-mix"]),"raster-color-range":new ja(Ya.paint_raster["raster-color-range"]),"raster-hue-rotate":new ja(Ya.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new ja(Ya.paint_raster["raster-brightness-min"]),"raster-brightness-max":new ja(Ya.paint_raster["raster-brightness-max"]),"raster-saturation":new ja(Ya.paint_raster["raster-saturation"]),"raster-contrast":new ja(Ya.paint_raster["raster-contrast"]),"raster-resampling":new ja(Ya.paint_raster["raster-resampling"]),"raster-fade-duration":new ja(Ya.paint_raster["raster-fade-duration"]),"raster-emissive-strength":new ja(Ya.paint_raster["raster-emissive-strength"]),"raster-array-band":new ja(Ya.paint_raster["raster-array-band"]),"raster-elevation":new ja(Ya.paint_raster["raster-elevation"]),"raster-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this.updateColorRamp(),this._curRampRange=[NaN,NaN];}getProgramIds(){return ["raster"]}hasColorMap(){return !!this._transitionablePaint._values["raster-color"].value.value}tileCoverLift(){return this.paint.get("raster-elevation")}isDraped(t){return !(t&&t._source instanceof vm&&(t._source.onNorthPole||t._source.onSouthPole))&&0===this.paint.get("raster-elevation")}_handleSpecialPaintPropertyUpdate(t){"raster-color"!==t&&"raster-color-range"!==t||(this._curRampRange=[NaN,NaN],this.updateColorRamp());}updateColorRamp(t){if(!this.hasColorMap())return;if(!this._curRampRange)return;const e=this._transitionablePaint._values["raster-color"].value.expression,[r,n]=t||this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0})||[NaN,NaN];isNaN(r)&&isNaN(n)||r===this._curRampRange[0]&&n===this._curRampRange[1]||(this.colorRamp=lc({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:r,end:n}],resolution:256}),this.colorRampTexture=null,this._curRampRange=[r,n]);}}let wm,Mm,Am,Sm,Im;class Pm extends ps{constructor(t,e,r,n){super(t,{layout:wm||(wm=new Ga({visibility:new ja(Ya["layout_raster-particle"].visibility)})),paint:Mm||(Mm=new Ga({"raster-particle-array-band":new ja(Ya["paint_raster-particle"]["raster-particle-array-band"]),"raster-particle-count":new ja(Ya["paint_raster-particle"]["raster-particle-count"]),"raster-particle-color":new $a(Ya["paint_raster-particle"]["raster-particle-color"]),"raster-particle-max-speed":new ja(Ya["paint_raster-particle"]["raster-particle-max-speed"]),"raster-particle-speed-factor":new ja(Ya["paint_raster-particle"]["raster-particle-speed-factor"]),"raster-particle-fade-opacity-factor":new ja(Ya["paint_raster-particle"]["raster-particle-fade-opacity-factor"]),"raster-particle-reset-rate-factor":new ja(Ya["paint_raster-particle"]["raster-particle-reset-rate-factor"]),"raster-particle-elevation":new ja(Ya["paint_raster-particle"]["raster-particle-elevation"]),"raster-particle-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp(),this.lastInvalidatedAt=Dt.now();}onRemove(t){this.colorRampTexture&&this.colorRampTexture.destroy(),this.tileFramebuffer&&this.tileFramebuffer.destroy(),this.particleFramebuffer&&this.particleFramebuffer.destroy();}hasColorMap(){return !!this._transitionablePaint._values["raster-particle-color"].value.value}getProgramIds(){return ["rasterParticle"]}hasOffscreenPass(){return "none"!==this.visibility}isDraped(t){return !1}_handleSpecialPaintPropertyUpdate(t){"raster-particle-color"!==t&&"raster-particle-max-speed"!==t||(this._updateColorRamp(),this._invalidateAnimationState()),"raster-particle-count"===t&&this._invalidateAnimationState();}_updateColorRamp(){if(!this.hasColorMap())return;const t=this._transitionablePaint._values["raster-particle-color"].value.expression,e=this._transitionablePaint._values["raster-particle-max-speed"].value.expression.evaluate({zoom:0});this.colorRamp=lc({expression:t,evaluationKey:"rasterParticleSpeed",image:this.colorRamp,clips:[{start:0,end:e}],resolution:256}),this.colorRampTexture=null;}_invalidateAnimationState(){this.lastInvalidatedAt=Dt.now();}tileCoverLift(){return this.paint.get("raster-particle-elevation")}}class zm extends ps{constructor(t,e){super(t,{},e,null),this.implementation=t,t.slot&&(this.slot=t.slot);}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isDraped(t){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}function Em(t,e,r){const n=[0,0,1],i=O.quat.identity([]);return O.quat.rotateY(i,i,r?-X(t)+Math.PI:X(t)),O.quat.rotateX(i,i,-X(e)),O.vec3.transformQuat(n,n,i),O.vec3.normalize(n,n)}function km(t,e){const r=Bm(t.projection,t.zoom,t.width,t.height),n=function(t,e,r,n,i){const a=new il(r.lng-180*Cm,r.lat),s=new il(r.lng+180*Cm,r.lat),o=t.project(a.lng,a.lat),l=t.project(s.lng,s.lat),u=-Math.atan2(l.y-o.y,l.x-o.x),c=bl.fromLngLat(r);c.y=Q(c.y,-1+Cm,1-Cm);const h=c.toLngLat(),p=t.project(h.lng,h.lat),f=bl.fromLngLat(h);f.x+=Cm;const d=f.toLngLat(),m=t.project(d.lng,d.lat),y=Dm(m.x-p.x,m.y-p.y,u),g=bl.fromLngLat(h);g.y+=Cm;const x=g.toLngLat(),v=t.project(x.lng,x.lat),b=Dm(v.x-p.x,v.y-p.y,u),_=Math.abs(y.x)/Math.abs(b.y),w=O.mat4.identity([]);O.mat4.rotateZ(w,w,-u*(1-(i?0:n)));const M=O.mat4.identity([]);return O.mat4.scale(M,M,[1,1-(1-_)*n,1]),M[4]=-b.x/b.y*n,O.mat4.rotateZ(M,M,u),O.mat4.multiply(M,w,M),M}(t.projection,0,t.center,r,e),i=Tm(t);return O.mat4.scale(n,n,[i,i,1]),n}function Tm(t){const e=t.projection,r=Bm(t.projection,t.zoom,t.width,t.height),n=Vm(e,t.center),i=Vm(e,il.convert(e.center));return Math.pow(2,n*r+(1-r)*i)}function Bm(t,e,r,n,i=1/0){const a=t.range;if(!a)return 0;const s=Math.min(i,Math.max(r,n)),o=Math.log(s/1024)/Math.LN2;return tt(a[0]+o,a[1]+o,e)}const Cm=1/4e4;function Vm(t,e){const r=Q(e.lat,-ml,ml),n=new il(e.lng-180*Cm,r),i=new il(e.lng+180*Cm,r),a=t.project(n.lng,r),s=t.project(i.lng,r),o=bl.fromLngLat(n),l=bl.fromLngLat(i),u=s.x-a.x,c=s.y-a.y,h=l.x-o.x,p=l.y-o.y,f=Math.sqrt((h*h+p*p)/(u*u+c*c));return Math.log(f)/Math.LN2}function Dm(t,e,r){const n=Math.cos(r),i=Math.sin(r);return {x:t*n-e*i,y:t*i+e*n}}function Lm(t,e,r){O.mat4.identity(t),O.mat4.rotateZ(t,t,X(e[2])),O.mat4.rotateX(t,t,X(e[0])),O.mat4.rotateY(t,t,X(e[1])),O.mat4.scale(t,t,r),O.mat4.multiply(t,t,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1]);}function Rm(t,e,r,n,i,a,s,o){const l=[r[0]-e[0],r[1]-e[1],0],u=[n[0]-e[0],n[1]-e[1],0];if(O.vec3.length(l)<1e-12||O.vec3.length(u)<1e-12)return O.quat.identity(t);const c=O.vec3.cross([],l,u);O.vec3.normalize(c,c),O.vec3.subtract(u,n,e),l[2]=(a-i)*o,u[2]=(s-i)*o;const h=l;return O.vec3.cross(h,l,u),O.vec3.normalize(h,h),O.quat.rotationTo(t,c,h)}function Fm(t,e,r=!1){const n=Fu(e.zoom),i=function(t,e,r){const n=e.worldSize,i=[t[12],t[13],t[14]],a=fl(i[1]/n),s=pl(i[0]/n),o=O.mat4.identity([]),l=hl(1,a)*n,u=hl(1,0)*n*gl(a,e.zoom),c=1/Du(n);let h=u*c;if(r){const t=Bm(e.projection,e.zoom,e.width,e.height,1024);h=c*e.projection.pixelSpaceConversion(e.center.lat,n,t);}const p=el(a,s);O.vec3.add(p,p,O.vec3.scale([],O.vec3.normalize([],p),l*h*i[2]));const f=function(t){const e=[t[0],t[1],t[2]];let r=[0,1,0];const n=O.vec3.cross([],r,e);return O.vec3.cross(r,e,n),0===O.vec3.squaredLength(r)&&(r=[0,1,0],O.vec3.cross(n,e,r)),O.vec3.normalize(n,n),O.vec3.normalize(r,r),O.vec3.normalize(e,e),[n[0],n[1],n[2],0,r[0],r[1],r[2],0,e[0],e[1],e[2],0,t[0],t[1],t[2],1]}(p);O.mat4.scale(o,o,[h,h,h*l]),O.mat4.translate(o,o,[-i[0],-i[1],-i[2]]);const d=O.mat4.multiply([],e.globeMatrix,f);return O.mat4.multiply(d,d,o),O.mat4.multiply(d,d,t),d}(t,e,r);if(n>0){const r=function(t,e){const r=e.worldSize,n=hl(1,0)*r*gl(e.center.lat,e.zoom)/Du(r),i=hl(1,e.center.lat)*r,a=O.mat4.identity([]);return O.mat4.rotateY(a,a,X(e.center.lng)),O.mat4.rotateX(a,a,X(e.center.lat)),O.mat4.translate(a,a,[0,0,Yo]),O.mat4.scale(a,a,[n,n,n*i]),O.mat4.translate(a,a,[e.point.x-.5*r,e.point.y-.5*r,0]),O.mat4.multiply(a,a,t),O.mat4.multiply(a,e.globeMatrix,a)}(t,e);return function(t,e,r){const n=(t,e,r)=>{const n=O.vec3.length(t),i=O.vec3.length(e),a=Su(t,e,r);return O.vec3.scale(a,a,1/O.vec3.length(a)*ze(n,i,r))},i=n([t[0],t[1],t[2]],[e[0],e[1],e[2]],r),a=n([t[4],t[5],t[6]],[e[4],e[5],e[6]],r),s=n([t[8],t[9],t[10]],[e[8],e[9],e[10]],r),o=Su([t[12],t[13],t[14]],[e[12],e[13],e[14]],r);return [i[0],i[1],i[2],0,a[0],a[1],a[2],0,s[0],s[1],s[2],0,o[0],o[1],o[2],1]}(i,r,n)}return i}function Om(t,e,r,n){const i=xu.projectAabbCorners(n,r);let a=Number.MAX_VALUE,s=-1;for(let t=0;t<i.length;++t){const r=i[t];r[0]=(.5*r[0]+.5)*e.width,r[1]=(.5-.5*r[1])*e.height,r[2]<a&&(s=t,a=r[2]);}const o=t=>new q(i[t][0],i[t][1]);let l;switch(s){case 0:case 6:l=[o(1),o(5),o(4),o(7),o(3),o(2),o(1)];break;case 1:case 7:l=[o(0),o(4),o(5),o(6),o(2),o(3),o(0)];break;case 3:case 5:l=[o(1),o(0),o(4),o(7),o(6),o(2),o(1)];break;default:l=[o(1),o(5),o(6),o(7),o(3),o(0),o(1)];}if(Cl(t,l))return a}const Nm=ys([{name:"a_pos_3f",components:3,type:"Float32"}]),Um=ys([{name:"a_color_3f",components:3,type:"Float32"}]),jm=ys([{name:"a_color_4f",components:4,type:"Float32"}]),qm=ys([{name:"a_uv_2f",components:2,type:"Float32"}]),$m=ys([{name:"a_normal_3f",components:3,type:"Float32"}]),Gm=ys([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),Ym=ys([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]),Xm={None:0,Model:1,Symbol:2,FillExtrusion:4,All:7};class Zm{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function Hm(t,e){const r=-1===t.indexOf("://");try{return new URL(t,r&&e?"http://example.com":void 0),!0}catch(t){return !1}}class Wm{constructor(t,e){this.feature=t,this.instancedDataOffset=e,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0];}}class Km{constructor(){this.instancedDataArray=new Xs,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={};}}class Jm{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.projection=t.projection,this.index=t.index,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0},this.modelUris=[],this.modelsRequested=!1,this.activeReplacements=[],this.replacementUpdateTime=0;}updateFootprints(t,e){}populate(t,e,r,n){this.tileToMeter=vl(r);const i=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:a,id:s,index:o,sourceLayerIndex:l}of t){const t=null!=s?s:a.properties&&a.properties.hasOwnProperty("id")?a.properties.id:void 0,u=El(a,i);if(!this.layers[0]._featureFilter.filter(new Ca(this.zoom),u,r))continue;const c={id:t,sourceLayerIndex:l,index:o,geometry:i?u.geometry:zl(a,r,n),properties:a.properties,type:a.type,patterns:{}},h=this.addFeature(c,c.geometry,u);h&&e.featureIndex.insert(a,c.geometry,o,l,this.index,this.instancesPerModel[h].instancedDataArray.length,Wr/32);}this.lookup=null;}update(t,e,r,n){for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e in t)r.idToFeaturesIndex.hasOwnProperty(e)&&(this.evaluate(r.features[r.idToFeaturesIndex[e]],t[e],r,!0),this.uploaded=!1);}this.maxHeight=0;}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return !1;let t=!1;for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e of r.features){const n=this.layers[0],i=e.feature,a=this.canonical,s=n.paint.get("model-rotation").evaluate(i,{},a),o=n.paint.get("model-scale").evaluate(i,{},a),l=n.paint.get("model-translation").evaluate(i,{},a);O.vec3.exactEquals(e.rotation,s)&&O.vec3.exactEquals(e.scale,o)&&O.vec3.exactEquals(e.translation,l)||(this.evaluate(e,e.featureStates,r,!0),t=!0);}}return t}updateReplacement(t,e,r,n){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const i=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);if(Ah(this.activeReplacements,i))return !1;this.activeReplacements=i;let a=!1;for(const e in this.instancesPerModel){const i=this.instancesPerModel[e],s=i.instancedDataArray;for(const e of i.features){const i=e.instancedDataOffset,o=e.instancedDataCount;for(let e=0;e<o;e++){const o=16*(e+i);let l=s.float32[o+0];const u=l>Wr;l=u?l-Wr:l;const c=Math.floor(l),h=s.float32[o+1];let p=!1;for(const e of this.activeReplacements)if(!bh(e,r,Xm.Model,n)&&!(e.min.x>c||c>e.max.x||e.min.y>h||h>e.max.y)&&(p=kh(Eh(c,h,t.canonical,e.footprintTileId.canonical),e.footprint),p))break;s.float32[o]=p?l+Wr:l,a=a||p!==u;}}}return a}isEmpty(){for(const t in this.instancesPerModel)if(0!==this.instancesPerModel[t].instancedDataArray.length)return !1;return !0}uploadPending(){return !this.uploaded}upload(t){if(!this.uploaded)for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];r.instancedDataArray.length<0||0===r.instancedDataArray.length||(r.instancedDataBuffer?r.instancedDataBuffer.updateData(r.instancedDataArray):r.instancedDataBuffer=t.createVertexBuffer(r.instancedDataArray,Gm.members,!0,void 0,this.instanceCount));}this.uploaded=!0;}destroy(){for(const t in this.instancesPerModel){const e=this.instancesPerModel[t];0!==e.instancedDataArray.length&&e.instancedDataBuffer&&e.instancedDataBuffer.destroy();}const t=this.layers[0].modelManager;if(t&&this.modelUris)for(const e of this.modelUris)t.removeModel(e,"");}addFeature(t,e,r){const n=this.layers[0],i=n.layout.get("model-id").evaluate(r,{},this.canonical);if(!i)return ft(`modelId is not evaluated for layer ${n.id} and it is not going to get rendered.`),i;Hm(i,!1)&&(this.modelUris.includes(i)||this.modelUris.push(i)),this.instancesPerModel[i]||(this.instancesPerModel[i]=new Km);const a=this.instancesPerModel[i],s=a.instancedDataArray,o=new Wm(r,s.length);for(const t of e)for(const e of t){if(e.x<0||e.x>=Wr||e.y<0||e.y>=Wr)continue;const t=(this.lookupDim-1)/Wr,r=this.lookupDim*(e.y*t|0)+e.x*t|0;if(this.lookup){if(0!==this.lookup[r])continue;this.lookup[r]=1;}this.instanceCount++;const n=s.length;s.resize(n+1),a.instancesEvaluatedElevation.push(0),s.float32[16*n]=e.x,s.float32[16*n+1]=e.y;}return o.instancedDataCount=a.instancedDataArray.length-o.instancedDataOffset,o.instancedDataCount>0&&(t.id&&(a.idToFeaturesIndex[t.id]=a.features.length),a.features.push(o),this.evaluate(o,{},a,!1)),i}getModelUris(){return this.modelUris}evaluate(t,e,r,n){const i=this.layers[0],a=t.feature,s=this.canonical,o=t.rotation=i.paint.get("model-rotation").evaluate(a,e,s),l=t.scale=i.paint.get("model-scale").evaluate(a,e,s),u=t.translation=i.paint.get("model-translation").evaluate(a,e,s),c=i.paint.get("model-color").evaluate(a,e,s);c.a=i.paint.get("model-color-mix-intensity").evaluate(a,e,s);const h=[];this.maxVerticalOffset<u[2]&&(this.maxVerticalOffset=u[2]),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),Lm(h,o,l);const p=Math.round(100*c.a)+c.b/1.05;for(let e=0;e<t.instancedDataCount;++e){const i=t.instancedDataOffset+e,a=16*i,o=r.instancedDataArray.float32;let l=0;n&&(l=o[a+6]-r.instancesEvaluatedElevation[i]);const f=0|o[a+1];o[a]=(0|o[a])+c.r/1.05,o[a+1]=f+c.g/1.05,o[a+2]=p,o[a+3]=1/(s.z>10?this.tileToMeter:vl(s,f)),o[a+4]=u[0],o[a+5]=u[1],o[a+6]=u[2]+l,o[a+7]=h[0],o[a+8]=h[1],o[a+9]=h[2],o[a+10]=h[4],o[a+11]=h[5],o[a+12]=h[6],o[a+13]=h[8],o[a+14]=h[9],o[a+15]=h[10],r.instancesEvaluatedElevation[i]=u[2];}}}let Qm,ty;oa(Jm,"ModelBucket",{omit:["layers"]}),oa(Km,"PerModelAttributes"),oa(Wm,"ModelFeature");const ey=64,ry={CoordinateSpaceTile:1,CoordinateSpaceYUp:2,HasMapboxMeshFeatures:4,HasMeshoptCompression:8};function ny(t,e,r,n,i,a,s,o,l,u=!1){const c=r.zoom,h=r.project(n),p=gl(n.lat,c),f=1/p;O.mat4.identity(t),O.mat4.translate(t,t,[h.x+s[0]*f,h.y+s[1]*f,s[2]]);let d=1,m=1;const y=r.worldSize;if(u){if("mercator"===r.projection.name){let t=0;r.elevation&&(t=r.elevation.getAtPointOrZero(new bl(h.x/y,h.y/y),0));const e=O.vec4.transformMat4([],[h.x,h.y,t,1],r.projMatrix)[3]/r.cameraToCenterDistance;d=e,m=e*gl(r.center.lat,c);}else if("globe"===r.projection.name){const e=Fm(t,r),i=O.mat4.multiply([],r.projMatrix,e),a=[0,0,0,1];O.vec4.transformMat4(a,a,i);const s=a[3]/r.cameraToCenterDistance,o=Fu(c),l=r.projection.pixelsPerMeter(n.lat,y)*gl(n.lat,c),u=r.projection.pixelsPerMeter(r.center.lat,y)*gl(r.center.lat,c);d=s/ze(l,yl(r.center.lat),o),m=s*p/l,d*=u,m*=u;}}else d=f;O.mat4.scale(t,t,[d,d,m]);const g=[...t],x=e.orientation,v=[];if(Lm(v,[x[0]+i[0],x[1]+i[1],x[2]+i[2]],a),O.mat4.multiply(t,g,v),o&&r.elevation){let i=0;const a=[];if(l&&r.elevation){i=function(t,e,r,n,i){const a=e.elevation;if(!a)return 0;const s=xu.projectAabbCorners(r,n),o=hl(1,i.lat)*e.worldSize,l=function(t,e){const r=[0,0,1],n=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const i of n){const n=t[i.corners[0]],a=t[i.corners[1]],s=t[i.corners[2]],o=[a[0]-n[0],a[1]-n[1],e*(a[2]-n[2])],l=O.vec3.cross(o,o,[s[0]-n[0],s[1]-n[1],e*(s[2]-n[2])]);O.vec3.normalize(l,l),i.dotProductWithUp=O.vec3.dot(l,r);}return n.sort(((t,e)=>t.dotProductWithUp-e.dotProductWithUp)),n[0].corners}(s,o),u=s[l[0]],c=s[l[1]],h=s[l[2]],p=s[l[3]],f=a.getAtPointOrZero(new bl(u[0]/e.worldSize,u[1]/e.worldSize),0),d=a.getAtPointOrZero(new bl(c[0]/e.worldSize,c[1]/e.worldSize),0),m=a.getAtPointOrZero(new bl(h[0]/e.worldSize,h[1]/e.worldSize),0),y=a.getAtPointOrZero(new bl(p[0]/e.worldSize,p[1]/e.worldSize),0),g=(f+y)/2,x=(d+m)/2;return g>x?d<m?Rm(t,c,p,u,d,y,f,o):Rm(t,h,u,p,m,f,y,o):f<y?Rm(t,u,c,h,f,d,m,o):Rm(t,p,h,c,y,m,d,o),Math.max(g,x)}(a,r,e.aabb,t,n);const s=O.mat4.fromQuat([],a),o=O.mat4.multiply([],s,v);O.mat4.multiply(t,g,o);}else i=r.elevation.getAtPointOrZero(new bl(h.x/y,h.y/y),0);0!==i&&(t[14]+=i);}}function iy(t,e,r=!1){t.uploaded||(t.gfxTexture=new dm(e,t.image,r?e.gl.R8:e.gl.RGBA8,{useMipmap:t.sampler.minFilter>=e.gl.NEAREST_MIPMAP_NEAREST}),t.uploaded=!0,t.image=null);}function ay(t,e,r){t.indexBuffer=e.createIndexBuffer(t.indexArray,!1,!0),t.vertexBuffer=e.createVertexBuffer(t.vertexArray,Nm.members,!1,!0),t.normalArray&&(t.normalBuffer=e.createVertexBuffer(t.normalArray,$m.members,!1,!0)),t.texcoordArray&&(t.texcoordBuffer=e.createVertexBuffer(t.texcoordArray,qm.members,!1,!0)),t.colorArray&&(t.colorBuffer=e.createVertexBuffer(t.colorArray,(12===t.colorArray.bytesPerElement?Um:jm).members,!1,!0)),t.featureArray&&(t.pbrBuffer=e.createVertexBuffer(t.featureArray,Ym.members,!0)),t.segments=po.simpleSegment(0,0,t.vertexArray.length,t.indexArray.length);const n=t.material;n.pbrMetallicRoughness.baseColorTexture&&iy(n.pbrMetallicRoughness.baseColorTexture,e),n.pbrMetallicRoughness.metallicRoughnessTexture&&iy(n.pbrMetallicRoughness.metallicRoughnessTexture,e),n.normalTexture&&iy(n.normalTexture,e),n.occlusionTexture&&iy(n.occlusionTexture,e,r),n.emissionTexture&&iy(n.emissionTexture,e);}function sy(t,e,r){if(t.meshes)for(const n of t.meshes)ay(n,e,r);if(t.children)for(const n of t.children)sy(n,e,r);}function oy(t){if(t.meshes)for(const e of t.meshes)e.indexArray.destroy(),e.vertexArray.destroy(),e.colorArray&&e.colorArray.destroy(),e.normalArray&&e.normalArray.destroy(),e.texcoordArray&&e.texcoordArray.destroy(),e.featureArray&&e.featureArray.destroy();if(t.children)for(const e of t.children)oy(e);}function ly(t){if(t.meshes)for(const r of t.meshes)r.vertexBuffer&&(r.vertexBuffer.destroy(),r.indexBuffer.destroy(),r.normalBuffer&&r.normalBuffer.destroy(),r.texcoordBuffer&&r.texcoordBuffer.destroy(),r.colorBuffer&&r.colorBuffer.destroy(),r.pbrBuffer&&r.pbrBuffer.destroy(),r.segments.destroy(),r.material&&((e=r.material).pbrMetallicRoughness.baseColorTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),e.pbrMetallicRoughness.metallicRoughnessTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),e.normalTexture&&e.normalTexture.gfxTexture&&e.normalTexture.gfxTexture.destroy(),e.emissionTexture&&e.emissionTexture.gfxTexture&&e.emissionTexture.gfxTexture.destroy(),e.occlusionTexture&&e.occlusionTexture.gfxTexture&&e.occlusionTexture.gfxTexture.destroy()));var e;if(t.children)for(const e of t.children)ly(e);}class uy{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,a=n.tileID,s=1<<e.canonical.z-a.canonical.z;return new uy(n,i.dim/Wr/s,[(e.canonical.x/s-a.canonical.x)*i.dim,(e.canonical.y/s-a.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),i=Math.floor(r);return new q(n,i)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],a=e*this._scale+this._offset[1],s=Math.floor(i),o=Math.floor(a),l=this._dem;return n=!!n,r?ze(ze(l.get(s,o,n),l.get(s,o+1,n),a-o),ze(l.get(s+1,o,n),l.get(s+1,o+1,n),a-o),i-s):l.get(s,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*hl(1,t)*this._dem.stride}}const cy=new Float32Array(262144),hy=new Uint8Array(262144);function py(t){let e=0;if(t.meshes)for(const r of t.meshes)e=Math.max(e,r.aabb.max[2]);if(t.children)for(const r of t.children)e=Math.max(e,py(r));return e}function fy(t,e,r){if(t.meshes)for(const n of t.meshes){if(n.aabb.min[0]===1/0)continue;const i=xu.applyTransform(n.aabb,t.matrix);r.insert(e,i.min[0],i.min[1],i.max[0],i.max[1]);}if(t.children)for(const n of t.children)fy(n,e,r);}const dy=["","wall","door","roof","window","lamp","logo"];class my{constructor(t){this.node=t,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.cameraCollisionOpacity=1,this.feature={type:"Point",id:t.id,geometry:[],properties:{height:py(t)}},this.aabb=this._getLocalBounds(),this.state=null;}_getLocalBounds(){if(!this.node.meshes)return new xu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);if(!this.aabb){let t=0;const e=new xu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const r of this.node.meshes)this.node.lightMeshIndex!==t&&(r.transformedAabb=xu.applyTransformFast(r.aabb,this.node.matrix),e.encapsulate(r.transformedAabb)),t++;this.aabb=e;}return this.aabb}}class yy{constructor(t,e,r,n,i,a,s){this.id=r,this.layers=t,this.layerIds=this.layers.map((t=>t.fqid)),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.modelTraits|=ry.CoordinateSpaceTile,this.uploaded=!1,this.hasPattern=!1,n&&(this.modelTraits|=ry.HasMapboxMeshFeatures),i&&(this.modelTraits|=ry.HasMeshoptCompression),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=a,this.dirty=!0,this.needsUpload=!1,this.nodesInfo=[];for(const t of e)this.nodesInfo.push(new my(t)),fy(t,s.featureIndexArray.length,s.grid),s.featureIndexArray.emplaceBack(this.nodesInfo.length-1,0,s.bucketLayerIDs.length-1,0);this.states={};}updateFootprints(t,e){for(const r of this.getNodesInfo()){const n=r.node;n.footprint&&e.push({footprint:n.footprint,id:t});}}update(t){const e=0!==Object.keys(t).length;if(e&&!this.stateDependentLayers.length)return;const r=e?this.stateDependentLayers:this.layers;if(!$(t,this.states))for(const e of r)this.evaluate(e,t);this.states=structuredClone(t);}populate(){console.log("populate 3D model bucket");}uploadPending(){return !this.uploaded||this.needsUpload}upload(t){if(!this.needsUpload)return;const e=this.getNodesInfo();for(const r of e){const e=r.node;this.uploaded?this.updatePbrBuffer(e):sy(e,t,!0);}for(const t of e)oy(t.node);this.uploaded=!0,this.needsUpload=!1;}updatePbrBuffer(t){let e=!1;if(!t.meshes)return e;for(const r of t.meshes)r.pbrBuffer&&(r.pbrBuffer.updateData(r.featureArray),e=!0);return e}needsReEvaluation(t,e,r){const n=t.transform.projectionOptions,i=t.style.getBrightness(),a=this.brightness!==i;if(!this.uploaded||this.dirty||n.name!==this.projection.name||gy(r.paint.get("model-color").value,a)||gy(r.paint.get("model-color-mix-intensity").value,a)||gy(r.paint.get("model-roughness").value,a)||gy(r.paint.get("model-emissive-strength").value,a)||gy(r.paint.get("model-height-based-emissive-strength-multiplier").value,a)){this.projection=n,this.brightness=i;const t=this.getNodesInfo();for(const e of t)e.state=null;return !0}return !1}evaluateScale(t,e){if(t.transform.zoom===this.zoom)return;this.zoom=t.transform.zoom;const r=this.getNodesInfo(),n=this.id.canonical;for(const t of r){const r=t.feature;t.evaluatedScale=e.paint.get("model-scale").evaluate(r,{},n);}}evaluate(t,e){const r=this.getNodesInfo();for(const n of r){if(!n.node.meshes)continue;const r=n.feature,i=e&&e[r.id];if($(i,n.state))continue;n.state=structuredClone(i);const a=n.node.meshes&&n.node.meshes[0].featureData,s=n.evaluatedColor[2],o=n.evaluatedRMEA[2],l=this.id.canonical;if(n.hasTranslucentParts=!1,a){for(let e=0;e<dy.length;e++){const a=dy[e];a.length&&(r.properties.part=a);const s=t.paint.get("model-color").evaluate(r,i,l).toRenderColor(null),o=t.paint.get("model-color-mix-intensity").evaluate(r,i,l);n.evaluatedColor[e]=[s.r,s.g,s.b,o],n.evaluatedRMEA[e][0]=t.paint.get("model-roughness").evaluate(r,i,l),n.evaluatedRMEA[e][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l),n.evaluatedRMEA[e][3]=s.a,n.emissionHeightBasedParams[e]=t.paint.get("model-height-based-emissive-strength-multiplier").evaluate(r,i,l),!n.hasTranslucentParts&&s.a<1&&(n.hasTranslucentParts=!0);}delete r.properties.part,vy(n,s!==n.evaluatedColor[2]||o!==n.evaluatedRMEA[2],this.modelTraits);}else n.evaluatedRMEA[0][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l);n.evaluatedScale=t.paint.get("model-scale").evaluate(r,i,l),this.updatePbrBuffer(n.node)||(this.needsUpload=!0);}this.dirty=!1;}elevationUpdate(t,e,r,n){const i=t.findDEMTileFor(r);if(i&&(i.tileID.canonical!==this.terrainTile||e!==this.terrainExaggeration)){if(i.dem&&i.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=i.tileID.overscaledZ;const e=uy.create(t,r,i);if(!e)return;this.modelTraits&ry.HasMapboxMeshFeatures&&this.updateDEM(t,e,r,n);for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.vertices||!r.footprint.vertices.length)continue;const n=r.footprint.vertices;let i=e.getElevationAt(n[0].x,n[0].y,!0,!0);for(let t=1;t<n.length;t++)i=Math.min(i,e.getElevationAt(n[t].x,n[t].y,!0,!0));r.elevation=i;}}this.terrainTile=i.tileID.canonical,this.terrainExaggeration=e;}}updateDEM(t,e,r,n){let i=e._dem._modifiedForSources[n];if(void 0===i&&(e._dem._modifiedForSources[n]=[],i=e._dem._modifiedForSources[n]),i.includes(r.canonical))return;const a=e._dem.dim;i.push(r.canonical);let s=!1;for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.grid)continue;const n=r.footprint.grid,i=e.tileCoordToPixel(n.min.x,n.min.y),o=e.tileCoordToPixel(n.max.x,n.max.y),l=Math.min(Math.min(a-o.y,i.x),Math.min(i.y,a-o.x));if(l<0)continue;const u=Q(l,2,5);let c=Math.max(0,i.x-u),h=Math.max(0,i.y-u),p=Math.min(o.x+u,a-1),f=Math.min(o.y+u,a-1);for(let t=h;t<=f;++t)for(let e=c;e<=p;++e)hy[t*a+e]=255;let d=0,m=0;for(let t=0;t<n.cellsY;++t)for(let r=0;r<n.cellsX;++r){if(!n.cells[t*n.cellsX+r])continue;const i=e.tileCoordToPixel(n.min.x+r/n.xScale,n.min.y+t/n.yScale),s=e.tileCoordToPixel(n.min.x+(r+1)/n.xScale,n.min.y+(t+1)/n.yScale);for(let t=i.y;t<=Math.min(s.y+1,a-1);++t)for(let r=i.x;r<=Math.min(s.x+1,a-1);++r)255===hy[t*a+r]&&(hy[t*a+r]=0,d+=e.getElevationAtPixel(r,t),m++);}const y=d/m;c=Math.max(1,i.x-u),h=Math.max(1,i.y-u),p=Math.min(o.x+u,a-2),f=Math.min(o.y+u,a-2),s=!0;for(let t=h;t<=f;++t)for(let r=c;r<=p;++r)0===hy[t*a+r]&&(cy[t*a+r]=e._dem.set(r,t,y));for(let t=1;t<u;++t){c=Math.max(1,i.x-t),h=Math.max(1,i.y-t),p=Math.min(o.x+t,a-2),f=Math.min(o.y+t,a-2);for(let r=h;r<=f;++r)for(let n=c;n<=p;++n){const i=r*a+n;if(255===hy[i]){let s=0,o=0,l=-1,c=-1;for(let e=-1;e<=1;++e)for(let i=-1;i<=1;++i){const u=(r+e)*a+n+i;if(hy[u]>=t)continue;const h=cy[u],p=Math.abs(h);p>o&&(s=h,o=p,l=i,c=e);}if(o>.1){const a=1-(t+.5*Math.abs(l*c))/u;let o=e._dem.get(n,r)+s*a;const h=e._dem.get(n+l,r+c),p=e._dem.get(n-l,r-c,!0);(o-h)*(o-p)>0&&(o=(h+p)/2),cy[i]=e._dem.set(n,r,o),hy[i]=t;}}}}}s&&(e._demTile.needsDEMTextureUpload=!0,e._dem._timestamp=Dt.now());}getNodesInfo(){return this.nodesInfo}destroy(){const t=this.getNodesInfo();for(const e of t)oy(e.node),ly(e.node);}isEmpty(){return !this.nodesInfo.length}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped()),n=this.getNodesInfo();for(let t=0;t<this.nodesInfo.length;t++){const e=n[t].node;n[t].hiddenByReplacement=!!e.footprint&&!r.find((t=>t.footprint===e.footprint));}}getHeightAtTileCoord(t,e){const r=this.getNodesInfo(),n=[],i=[0,0,0],a=O.mat4.identity([]);for(let s=0;s<this.nodesInfo.length;s++){const o=r[s],l=o.node.meshes[0],u=l.transformedAabb;if(t<u.min[0]||e<u.min[1]||t>u.max[0]||e>u.max[1])continue;if(!0===o.node.hidden)return {height:1/0,maxHeight:o.feature.properties.height,hidden:!1,verticalScale:o.evaluatedScale[2]};O.mat4.invert(a,o.node.matrix),i[0]=t,i[1]=e,O.vec3.transformMat4(i,i,a);const c=(i[0]-l.aabb.min[0])/(l.aabb.max[0]-l.aabb.min[0])*ey|0,h=Math.min(63,(i[1]-l.aabb.min[1])/(l.aabb.max[1]-l.aabb.min[1])*ey|0)*ey+Math.min(63,c),p=l.heightmap[h];if(!(p<0&&o.node.footprint)){if(o.hiddenByReplacement)return;return {height:p,maxHeight:o.feature.properties.height,hidden:!1,verticalScale:o.evaluatedScale[2]}}if(o.node.footprint.grid.query(new q(t,e),new q(t,e),n),n.length>0)return {height:void 0,maxHeight:o.feature.properties.height,hidden:o.hiddenByReplacement,verticalScale:o.evaluatedScale[2]}}}}function gy(t,e){return !t.isLightConstant&&e}function xy(t,e,r,n,i,a,s,o){let l=(61440&e|(61440&e)>>4)>>8,u=(3840&e|(3840&e)>>4)>>4,c=240&e|(240&e)>>4;r[3]>0&&(l=ze(l,255*r[0],r[3]),u=ze(u,255*r[1],r[3]),c=ze(c,255*r[2],r[3]));const h=l<<8|u,p=c<<8|Math.floor(255*n[3]),f=function(t){const e=Q(t,0,2);return Math.min(Math.round(.5*e*255),255)}(n[2])<<8|15*n[0]<<4|15*n[1],d=Q(i[0],0,1),m=Q(i[1],0,1),y=Q(i[2],0,1),g=Q(i[3],0,1);let x,v,b,_;if(d!==m&&s!==a&&m!==d){const t=s-a;v=1/(t*(m-d)),b=-(a+t*d)/(t*(m-d));const e=Q(i[4],-1,1);_=Math.pow(10,e),x=255*y<<8|255*g;}else x=65535,v=0,b=1,_=1;if(t.emplaceBack(h,p,f,x,v,b,_),o){const t=o.length;o.clear();for(let e=0;e<t;e++)o.emplaceBack(h,p,f,x,v,b,_);}}function vy(t,e,r){const n=t.node;let i=0;const a=r&ry.HasMeshoptCompression;for(const r of n.meshes){if(n.lights&&n.lightMeshIndex===i)continue;if(!r.featureData)continue;r.featureArray=new Zs,r.featureArray.reserve(r.featureData.length);let s=e;for(const e of r.featureData){const i=a?65535&e:e>>16&65535,o=a?e>>16&65535:65535&e,l=(15&o)<8?15&o:0,u=t.evaluatedRMEA[l],c=t.evaluatedColor[l],h=t.emissionHeightBasedParams[l];let p;if(s&&2===l&&n.lights&&(p=new Zs,p.resize(10*n.lights.length)),xy(r.featureArray,i,c,u,h,r.aabb.min[2],r.aabb.max[2],p),p&&s){s=!1;const t=n.meshes[n.lightMeshIndex];t.featureArray=p,t.featureArray._trim();}}r.featureArray._trim(),i++;}}function by(t,e,r,n){const i=1<<t.z;e.lat=fl((n/Wr+t.y)/i),e.lng=pl((r/Wr+t.x)/i);}oa(yy,"Tiled3dModelBucket",{omit:["layers"]}),oa(my,"Tiled3dModelFeature");const _y={circle:class extends ps{constructor(t,e,r,n){super(t,{layout:Kl||(Kl=new Ga({"circle-sort-key":new qa(Ya.layout_circle["circle-sort-key"]),"circle-elevation-reference":new ja(Ya.layout_circle["circle-elevation-reference"]),visibility:new ja(Ya.layout_circle.visibility)})),paint:Jl||(Jl=new Ga({"circle-radius":new qa(Ya.paint_circle["circle-radius"]),"circle-color":new qa(Ya.paint_circle["circle-color"]),"circle-blur":new qa(Ya.paint_circle["circle-blur"]),"circle-opacity":new qa(Ya.paint_circle["circle-opacity"]),"circle-translate":new ja(Ya.paint_circle["circle-translate"]),"circle-translate-anchor":new ja(Ya.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new ja(Ya.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new ja(Ya.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new qa(Ya.paint_circle["circle-stroke-width"]),"circle-stroke-color":new qa(Ya.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new qa(Ya.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new ja(Ya.paint_circle["circle-emissive-strength"]),"circle-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"circle-stroke-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}createBucket(t){return new Bl(t)}queryRadius(t){const e=t;return Xl("circle-radius",this,e)+Xl("circle-stroke-width",this,e)+Zl(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,a,s,o){const l=Wl(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return Yu(t,n,a,s,o,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getDefaultProgramParams(t,e,r){const n=Gu(this);return {config:new Oo(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}},heatmap:class extends ps{createBucket(t){return new Ku(t)}constructor(t,e,r,n){super(t,{layout:Ju||(Ju=new Ga({visibility:new ja(Ya.layout_heatmap.visibility)})),paint:Qu||(Qu=new Ga({"heatmap-radius":new qa(Ya.paint_heatmap["heatmap-radius"]),"heatmap-weight":new qa(Ya.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new ja(Ya.paint_heatmap["heatmap-intensity"]),"heatmap-color":new $a(Ya.paint_heatmap["heatmap-color"]),"heatmap-opacity":new ja(Ya.paint_heatmap["heatmap-opacity"]),"heatmap-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=lc({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return Xl("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,a,s,o){const l=this.paint.get("heatmap-radius").evaluate(e,r);return Yu(t,n,a,s,o,!0,!0,new q(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getDefaultProgramParams(t,e,r){return "heatmap"===t?{config:new Oo(this,{zoom:e,lut:r}),overrideFog:!1}:{}}},hillshade:class extends ps{constructor(t,e,r,n){super(t,{layout:tc||(tc=new Ga({visibility:new ja(Ya.layout_hillshade.visibility)})),paint:ec||(ec=new Ga({"hillshade-illumination-direction":new ja(Ya.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new ja(Ya.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new ja(Ya.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new ja(Ya.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new ja(Ya.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new ja(Ya.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new ja(Ya.paint_hillshade["hillshade-emissive-strength"]),"hillshade-shadow-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"hillshade-highlight-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"hillshade-accent-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}shouldRedrape(){return this.hasOffscreenPass()&&"viewport"===this.paint.get("hillshade-illumination-anchor")}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}},fill:class extends ps{constructor(t,e,r,n){super(t,{layout:jc||(jc=new Ga({"fill-sort-key":new qa(Ya.layout_fill["fill-sort-key"]),visibility:new ja(Ya.layout_fill.visibility),"fill-elevation-reference":new ja(Ya.layout_fill["fill-elevation-reference"])})),paint:qc||(qc=new Ga({"fill-antialias":new ja(Ya.paint_fill["fill-antialias"]),"fill-opacity":new qa(Ya.paint_fill["fill-opacity"]),"fill-color":new qa(Ya.paint_fill["fill-color"]),"fill-outline-color":new qa(Ya.paint_fill["fill-outline-color"]),"fill-translate":new ja(Ya.paint_fill["fill-translate"]),"fill-translate-anchor":new ja(Ya.paint_fill["fill-translate-anchor"]),"fill-pattern":new qa(Ya.paint_fill["fill-pattern"]),"fill-emissive-strength":new ja(Ya.paint_fill["fill-emissive-strength"]),"fill-z-offset":new qa(Ya.paint_fill["fill-z-offset"]),"fill-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"fill-outline-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getDefaultProgramParams(t,e,r){return {config:new Oo(this,{zoom:e,lut:r}),overrideFog:!1}}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new Uc(t)}queryRadius(){return Zl(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,a){return !t.queryGeometry.isAboveHorizon&&Dl(Hl(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return !0}is3D(){return 0!==this.paint.get("fill-z-offset").constantOr(1)}},"fill-extrusion":class extends ps{constructor(t,e,r,n){super(t,{layout:lp||(lp=new Ga({visibility:new ja(Ya["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new ja(Ya["layout_fill-extrusion"]["fill-extrusion-edge-radius"])})),paint:up||(up=new Ga({"fill-extrusion-opacity":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-height-alignment":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-height-alignment"]),"fill-extrusion-base-alignment":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-base-alignment"]),"fill-extrusion-vertical-gradient":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]),"fill-extrusion-emissive-strength":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-emissive-strength"]),"fill-extrusion-line-width":new qa(Ya["paint_fill-extrusion"]["fill-extrusion-line-width"]),"fill-extrusion-cast-shadows":new ja(Ya["paint_fill-extrusion"]["fill-extrusion-cast-shadows"]),"fill-extrusion-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"fill-extrusion-flood-light-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new Kh(t)}queryRadius(){return Zl(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}hasShadowPass(){return this.paint.get("fill-extrusion-cast-shadows")}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(t,e,r,n,i,a,s,o,l){const u=Wl(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=[0,0],f=o&&a.elevation,d=a.elevation?a.elevation.exaggeration():1,m=t.tile.getBucket(this);if(f&&m instanceof Kh){const t=m.centroidVertexArray,e=l+1;e<t.length&&(p[0]=t.geta_centroid_pos0(e),p[1]=t.geta_centroid_pos1(e));}if(0===p[0]&&1===p[1])return !1;"globe"===a.projection.name&&(n=sp([n],[new q(0,0),new q(Wr,Wr)],t.tileID.canonical).map((t=>t.polygon)).flat());const y=f?o:null,[g,x]=function(t,e,r,n,i,a,s,o,l,u,c){return "globe"===t.projection.name?function(t,e,r,n,i,a,s,o,l,u,c){const h=[],p=[],f=t.projection.upVectorScale(c,t.center.lat,t.worldSize).metersToTile,d=[0,0,0,1],m=[0,0,0,1],y=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},g=ap();r>0&&(r+=g),n+=g;for(const g of e){const e=[],x=[];for(const h of g){const p=h.x+i.x,g=h.y+i.y,v=t.projection.projectTilePoint(p,g,c),b=t.projection.upVector(c,h.x,h.y);let _=r,w=n;if(s){const t=pp(p,g,r,n,s,o,l,u);_+=t.base,w+=t.top;}0!==r?y(d,v.x+b[0]*f*_,v.y+b[1]*f*_,v.z+b[2]*f*_):y(d,v.x,v.y,v.z),y(m,v.x+b[0]*f*w,v.y+b[1]*f*w,v.z+b[2]*f*w),O.vec3.transformMat4(d,d,a),O.vec3.transformMat4(m,m,a),e.push(new dh(d[0],d[1],d[2])),x.push(new dh(m[0],m[1],m[2]));}h.push(e),p.push(x);}return [h,p]}(t,e,r,n,i,a,s,o,l,u,c):s?function(t,e,r,n,i,a,s,o,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],f=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,d=pp(c,p,e,r,a,s,o,l);h[0]=c,h[1]=p,h[2]=d.base,h[3]=1,O.vec4.transformMat4(h,h,i),h[3]=Math.max(h[3],1e-5);const m=new dh(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=c,h[1]=p,h[2]=d.top,h[3]=1,O.vec4.transformMat4(h,h,i),h[3]=Math.max(h[3],1e-5);const y=new dh(h[0]/h[3],h[1]/h[3],h[2]/h[3]);t.push(m),f.push(y);}u.push(t),c.push(f);}return [u,c]}(e,r,n,i,a,s,o,l,u):function(t,e,r,n,i){const a=[],s=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,f=i[10]*r,d=i[11]*r;for(const e of t){const t=[],r=[];for(const a of e){const e=a.x+n.x,s=a.y+n.y,m=i[0]*e+i[4]*s+i[12],y=i[1]*e+i[5]*s+i[13],g=i[2]*e+i[6]*s+i[14],x=i[3]*e+i[7]*s+i[15],v=m+o,b=y+l,_=g+u,w=Math.max(x+c,1e-5),M=m+h,A=y+p,S=g+f,I=Math.max(x+d,1e-5);t.push(new dh(v/w,b/w,_/w)),r.push(new dh(M/I,A/I,S/I));}a.push(t),s.push(r);}return [a,s]}(e,r,n,i,a)}(a,n,h,c,u,s,y,p,d,a.center.lat,t.tileID.canonical),v=t.queryGeometry;return function(t,e,r){let n=1/0;Dl(r,e)&&(n=hp(r,e[0]));for(let i=0;i<e.length;i++){const a=e[i],s=t[i];for(let t=0;t<a.length-1;t++){const e=a[t],i=[e,a[t+1],s[t+1],s[t],e];Cl(r,i)&&(n=Math.min(n,hp(r,i)));}}return n!==1/0&&n}(g,x,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},line:class extends ps{constructor(t,e,r,n){const i=Dp();super(t,i,e,r,n),i.layout&&(this.layout=new Ua(i.layout)),this.gradientVersion=0,this.hasElevatedBuckets=!1,this.hasNonElevatedBuckets=!1;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof Nn,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=(()=>{if(Rp)return Rp;const t=Dp();return Rp=new Lp(t.paint.properties["line-width"].specification),Rp.useIntegerZoom=!0,Rp})().possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Ap(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(t,e,r){const n=Bp(this);return {config:new Oo(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}queryRadius(t){const e=t,r=Fp(Xl("line-width",this,e),Xl("line-gap-width",this,e)),n=Xl("line-offset",this,e);return r/2+Math.abs(n)+Zl(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,a){if(t.queryGeometry.isAboveHorizon)return !1;const s=Hl(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),o=t.pixelToTileUnitsFactor/2*Fp(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new q(0,0);for(let i=0;i<t.length;i++){const a=t[i],s=[];for(let t=0;t<a.length;t++){const r=a[t],i=a[t+1],o=0===t?n:r.sub(a[t-1])._unit()._perp(),l=t===a.length-1?n:i.sub(r)._unit()._perp(),u=o._add(l)._unit();u._mult(1/(u.x*l.x+u.y*l.y)),s.push(u._mult(e)._add(r));}r.push(s);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(jl(t,i[e]))return !0;if(Ll(t,i,r))return !0}return !1}(s,n,o)}isTileClipped(){return !0}isDraped(t){return !this.hasElevatedBuckets}},symbol:sm,background:class extends ps{constructor(t,e,r,n){super(t,{layout:om||(om=new Ga({visibility:new ja(Ya.layout_background.visibility)})),paint:lm||(lm=new Ga({"background-pitch-alignment":new ja(Ya.paint_background["background-pitch-alignment"]),"background-color":new ja(Ya.paint_background["background-color"]),"background-pattern":new ja(Ya.paint_background["background-pattern"]),"background-opacity":new ja(Ya.paint_background["background-opacity"]),"background-emissive-strength":new ja(Ya.paint_background["background-emissive-strength"]),"background-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}is3D(){return "viewport"===this.paint.get("background-pitch-alignment")}},raster:_m,"raster-particle":Pm,sky:class extends ps{constructor(t,e,r,n){super(t,{layout:Am||(Am=new Ga({visibility:new ja(Ya.layout_sky.visibility)})),paint:Sm||(Sm=new Ga({"sky-type":new ja(Ya.paint_sky["sky-type"]),"sky-atmosphere-sun":new ja(Ya.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new ja(Ya.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new ja(Ya.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new ja(Ya.paint_sky["sky-gradient-radius"]),"sky-gradient":new $a(Ya.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new ja(Ya.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new ja(Ya.paint_sky["sky-atmosphere-color"]),"sky-opacity":new ja(Ya.paint_sky["sky-opacity"]),"sky-gradient-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-halo-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=lc({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,a=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&ft("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?Em(a.azimuthal,90-a.polar,e):Em(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return Em(r[0],90-r[1],e)}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}},slot:class extends ps{constructor(t,e,r,n){super(t,{paint:Im||(Im=new Ga({}))},e,null);}},model:class extends ps{constructor(t,e,r,n){super(t,{layout:Qm||(Qm=new Ga({visibility:new ja(Ya.layout_model.visibility),"model-id":new qa(Ya.layout_model["model-id"])})),paint:ty||(ty=new Ga({"model-opacity":new qa(Ya.paint_model["model-opacity"]),"model-rotation":new qa(Ya.paint_model["model-rotation"]),"model-scale":new qa(Ya.paint_model["model-scale"]),"model-translation":new qa(Ya.paint_model["model-translation"]),"model-color":new qa(Ya.paint_model["model-color"]),"model-color-mix-intensity":new qa(Ya.paint_model["model-color-mix-intensity"]),"model-type":new ja(Ya.paint_model["model-type"]),"model-cast-shadows":new ja(Ya.paint_model["model-cast-shadows"]),"model-receive-shadows":new ja(Ya.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new ja(Ya.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new qa(Ya.paint_model["model-emissive-strength"]),"model-roughness":new qa(Ya.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new qa(Ya.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new ja(Ya.paint_model["model-cutoff-fade-range"]),"model-front-cutoff":new ja(Ya.paint_model["model-front-cutoff"]),"model-color-use-theme":new qa({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new Jm(t)}getProgramIds(){return ["model"]}is3D(){return !0}hasShadowPass(){return !0}canCastShadows(){return !0}hasLightBeamPass(){return !0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(t){return t instanceof yy?Wr-1:0}queryIntersectsFeature(t,e,r,n,i,a){if(!this.modelManager)return !1;const s=this.modelManager,o=t.tile.getBucket(this);if(!(o&&o instanceof Jm))return !1;for(const r in o.instancesPerModel){const n=o.instancesPerModel[r],i=void 0!==e.id?e.id:e.properties&&e.properties.hasOwnProperty("id")?e.properties.id:void 0;if(n.idToFeaturesIndex.hasOwnProperty(i)){const e=n.features[n.idToFeaturesIndex[i]],l=s.getModel(r,this.scope);if(!l)return !1;let u=O.mat4.create();const c=new il(0,0),h=o.canonical;let p=Number.MAX_VALUE;for(let r=0;r<e.instancedDataCount;++r){const i=16*(e.instancedDataOffset+r),s=n.instancedDataArray.float32,o=[s[i+4],s[i+5],s[i+6]];by(h,c,s[i],0|s[i+1]),ny(u,l,a,c,e.rotation,e.scale,o,!1,!1,!1),"globe"===a.projection.name&&(u=Fm(u,a));const f=O.mat4.multiply([],a.projMatrix,u),d=t.queryGeometry,m=Om(d.isPointQuery()?d.screenBounds:d.screenGeometry,a,f,l.aabb);null!=m&&(p=Math.min(m,p));}return p!==Number.MAX_VALUE&&p}}return !1}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven()||"model-color"!==t&&"model-color-mix-intensity"!==t&&"model-rotation"!==t&&"model-scale"!==t&&"model-translation"!==t&&"model-emissive-strength"!==t)}_isPropertyZoomDependent(t){const e=this._transitionablePaint._values[t];return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof Ji}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}},clip:class extends ps{constructor(t,e,r,n){super(t,{layout:$c||($c=new Ga({"clip-layer-types":new ja(Ya.layout_clip["clip-layer-types"]),"clip-layer-scope":new ja(Ya.layout_clip["clip-layer-scope"])})),paint:Gc||(Gc=new Ga({}))},e,r,n);}recalculate(t,e){super.recalculate(t,e);}createBucket(t){return new Zc(t)}isTileClipped(){return !0}is3D(){return !0}}};class wy{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class My{constructor(){this.tasks={},this.taskQueue=[],ot(["process"],this),this.invoker=new wy(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){try{t();}finally{}return null}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class Ay{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},ot(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new My;}send(t,e,r,n,i=!1,a){const s=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=a,this.callbacks[s]=r);const o=new Set;return this.target.postMessage({id:s,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:ca(e,o)},o),{cancel:()=>{r&&delete this.callbacks[s],this.target.postMessage({id:s,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||gt()){const t=this.callbacks[r],n=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});n&&(this.cancelCallbacks[r]=n);}else this.processTask(r,e);}processTask(t,e){if(delete this.cancelCallbacks[t],"<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(ha(e.error)):r(null,ha(e.data)));}else {const r=new Set,n=e.hasCallback?(e,n)=>{this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?ca(e):null,data:ca(n,r)},r);}:()=>{},i=ha(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source,i.scope)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}}var Sy={workerUrl:"",workerClass:null,workerParams:void 0};const Iy="mapboxgl_preloaded_worker_pool";class Py{constructor(){this.active={};}acquire(t,e=Py.workerCount){if(!this.workers)for(this.workers=[];this.workers.length<e;)this.workers.push(null!=Sy.workerClass?new Sy.workerClass:new self.Worker(Sy.workerUrl,Sy.workerParams));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],this.workers&&0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[Iy]}numActive(){return Object.keys(this.active).length}}Py.workerCount=2;class zy{constructor(t,e,r="Worker",n=Py.workerCount){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=at();const i=this.workerPool.acquire(this.id,n);for(let t=0;t<i.length;t++){const n=new zy.Actor(i[t],e,this.id);n.name=`${r} ${t}`,this.actors.push(n);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,e,r){rt(this.actors,((r,n)=>{r.send(t,e,n);}),r=r||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}let Ey,ky;function Ty(){return Ey||(Ey=new Py),Ey}zy.Actor=Ay;const By=new Ie(0,0,0);var Cy=(t=>(t[t.PATH_RULE_UNSPECIFIED=0]="PATH_RULE_UNSPECIFIED",t[t.PATH_RULE_NON_ZERO=1]="PATH_RULE_NON_ZERO",t[t.PATH_RULE_EVEN_ODD=2]="PATH_RULE_EVEN_ODD",t))(Cy||{}),Vy=(t=>(t[t.LINE_CAP_UNSPECIFIED=0]="LINE_CAP_UNSPECIFIED",t[t.LINE_CAP_BUTT=1]="LINE_CAP_BUTT",t[t.LINE_CAP_ROUND=2]="LINE_CAP_ROUND",t[t.LINE_CAP_SQUARE=3]="LINE_CAP_SQUARE",t))(Vy||{}),Dy=(t=>(t[t.LINE_JOIN_UNSPECIFIED=0]="LINE_JOIN_UNSPECIFIED",t[t.LINE_JOIN_MITER=1]="LINE_JOIN_MITER",t[t.LINE_JOIN_MITER_CLIP=2]="LINE_JOIN_MITER_CLIP",t[t.LINE_JOIN_ROUND=3]="LINE_JOIN_ROUND",t[t.LINE_JOIN_BEVEL=4]="LINE_JOIN_BEVEL",t))(Dy||{}),Ly=(t=>(t[t.PAINT_ORDER_UNSPECIFIED=0]="PAINT_ORDER_UNSPECIFIED",t[t.PAINT_ORDER_FILL_AND_STROKE=1]="PAINT_ORDER_FILL_AND_STROKE",t[t.PAINT_ORDER_STROKE_AND_FILL=2]="PAINT_ORDER_STROKE_AND_FILL",t))(Ly||{}),Ry=(t=>(t[t.PATH_COMMAND_UNSPECIFIED=0]="PATH_COMMAND_UNSPECIFIED",t[t.PATH_COMMAND_MOVE=1]="PATH_COMMAND_MOVE",t[t.PATH_COMMAND_LINE=2]="PATH_COMMAND_LINE",t[t.PATH_COMMAND_QUAD=3]="PATH_COMMAND_QUAD",t[t.PATH_COMMAND_CUBIC=4]="PATH_COMMAND_CUBIC",t[t.PATH_COMMAND_CLOSE=5]="PATH_COMMAND_CLOSE",t))(Ry||{}),Fy=(t=>(t[t.MASK_TYPE_UNSPECIFIED=0]="MASK_TYPE_UNSPECIFIED",t[t.MASK_TYPE_LUMINANCE=1]="MASK_TYPE_LUMINANCE",t[t.MASK_TYPE_ALPHA=2]="MASK_TYPE_ALPHA",t))(Fy||{});function Oy(t,e,r){1===t&&e.icons.push(function(t,e){return function(t){if(t.usvg_tree.height||(t.usvg_tree.height=t.usvg_tree.width),!t.metadata)return t;const{metadata:e}=t;if(e.content_area){const{content_area:r}=e;null==r.top&&(r.top=r.left),null==r.width&&(r.width=t.usvg_tree.width),null==r.height&&(r.height=r.width);}return e.stretch_x&&e.stretch_x.length&&Ny(e,"x"),e.stretch_y&&e.stretch_y.length&&Ny(e,"y"),t}(t.readFields(Uy,{name:void 0},e))}(r,r.readVarint()+r.pos));}function Ny(t,e){const r=[],n=t[`stretch_${e}`];let i=null;for(let t=0;t<n.length;t++)null===i?i=0===r.length?n[0]:r[r.length-1][1]+n[t]:(r.push([i,i+n[t]]),i=null);t[`stretch_${e}_areas`]=r;}function Uy(t,e,r){1===t?e.name=r.readString():2===t?e.metadata=function(t,e){return t.readFields(jy,{stretch_x:null,stretch_y:null,stretch_x_areas:null,stretch_y_areas:null,variables:[]},e)}(r,r.readVarint()+r.pos):3===t&&(e.usvg_tree=function(t,e){return t.readFields(Gy,{width:20,children:[],linear_gradients:[],radial_gradients:[],clip_paths:[],masks:[]},e)}(r,r.readVarint()+r.pos),e.data="usvg_tree");}function jy(t,e,r){1===t?e.stretch_x=r.readPackedVarint():2===t?e.stretch_y=r.readPackedVarint():3===t?e.content_area=function(t,e){return t.readFields(qy,{left:0},e)}(r,r.readVarint()+r.pos):4===t&&e.variables.push(function(t,e){return t.readFields($y,{name:void 0},e)}(r,r.readVarint()+r.pos));}function qy(t,e,r){1===t?e.left=r.readVarint():2===t?e.width=r.readVarint():3===t?e.top=r.readVarint():4===t&&(e.height=r.readVarint());}function $y(t,e,r){1===t?e.name=r.readString():2===t&&(e.rgb_color=Qy(r.readVarint()),e.value="rgb_color");}function Gy(t,e,r){1===t?e.width=e.height=r.readVarint():2===t?e.height=r.readVarint():3===t?e.children.push(Yy(r,r.readVarint()+r.pos)):4===t?e.linear_gradients.push(function(t,e){return t.readFields(eg,{spread_method:1,stops:[],x1:0,y1:0,x2:1,y2:0},e)}(r,r.readVarint()+r.pos)):5===t?e.radial_gradients.push(function(t,e){return t.readFields(ig,{spread_method:1,stops:[],cx:.5,cy:.5,r:.5,fx:.5,fy:.5,fr:0},e)}(r,r.readVarint()+r.pos)):7===t?e.clip_paths.push(function(t,e){return t.readFields(ag,{children:[]},e)}(r,r.readVarint()+r.pos)):8===t&&e.masks.push(function(t,e){const r=t.readFields(sg,{left:0,width:20,mask_type:1,children:[]},e);return null==r.height&&(r.height=r.width),null==r.top&&(r.top=r.left),r}(r,r.readVarint()+r.pos));}function Yy(t,e){return t.readFields(Xy,{},e)}function Xy(t,e,r){1===t?(e.group=function(t,e){return t.readFields(Zy,{opacity:255,children:[]},e)}(r,r.readVarint()+r.pos),e.node="group"):2===t&&(e.path=function(t,e){return t.readFields(Ky,{paint_order:1,commands:[],step:1,diffs:[],rule:1},e)}(r,r.readVarint()+r.pos),e.node="path");}function Zy(t,e,r){1===t?e.transform=Hy(r,r.readVarint()+r.pos):2===t?e.opacity=r.readVarint():5===t?e.clip_path_idx=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(Yy(r,r.readVarint()+r.pos));}function Hy(t,e){return t.readFields(Wy,{sx:1,ky:0,kx:0,sy:1,tx:0,ty:0},e)}function Wy(t,e,r){1===t?e.sx=r.readFloat():2===t?e.ky=r.readFloat():3===t?e.kx=r.readFloat():4===t?e.sy=r.readFloat():5===t?e.tx=r.readFloat():6===t&&(e.ty=r.readFloat());}function Ky(t,e,r){1===t?e.fill=function(t,e){return t.readFields(Jy,{rgb_color:By,paint:"rgb_color",opacity:255},e)}(r,r.readVarint()+r.pos):2===t?e.stroke=function(t,e){return t.readFields(tg,{rgb_color:By,paint:"rgb_color",dasharray:[],dashoffset:0,miterlimit:4,opacity:255,width:1,linecap:1,linejoin:1},e)}(r,r.readVarint()+r.pos):3===t?e.paint_order=r.readVarint():5===t?r.readPackedVarint(e.commands):6===t?e.step=r.readFloat():7===t?r.readPackedSVarint(e.diffs):8===t&&(e.rule=r.readVarint());}function Jy(t,e,r){1===t?(e.rgb_color=Qy(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t&&(e.opacity=r.readVarint());}function Qy(t){return new Ie((t>>16&255)/255,(t>>8&255)/255,(255&t)/255,1)}function tg(t,e,r){1===t?(e.rgb_color=Qy(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t?r.readPackedFloat(e.dasharray):6===t?e.dashoffset=r.readFloat():7===t?e.miterlimit=r.readFloat():8===t?e.opacity=r.readVarint():9===t?e.width=r.readFloat():10===t?e.linecap=r.readVarint():11===t&&(e.linejoin=r.readVarint());}function eg(t,e,r){1===t?e.transform=Hy(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(rg(r,r.readVarint()+r.pos)):4===t?e.x1=r.readFloat():5===t?e.y1=r.readFloat():6===t?e.x2=r.readFloat():7===t&&(e.y2=r.readFloat());}function rg(t,e){return t.readFields(ng,{offset:0,opacity:255,rgb_color:By},e)}function ng(t,e,r){1===t?e.offset=r.readFloat():2===t?e.opacity=r.readVarint():3===t&&(e.rgb_color=Qy(r.readVarint()));}function ig(t,e,r){1===t?e.transform=Hy(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(rg(r,r.readVarint()+r.pos)):4===t?e.cx=r.readFloat():5===t?e.cy=r.readFloat():6===t?e.r=r.readFloat():7===t?e.fx=r.readFloat():8===t?e.fy=r.readFloat():9===t&&(e.fr=r.readFloat());}function ag(t,e,r){1===t?e.transform=Hy(r,r.readVarint()+r.pos):2===t?e.clip_path_idx=r.readVarint():3===t&&e.children.push(Yy(r,r.readVarint()+r.pos));}function sg(t,e,r){1===t?e.left=e.top=r.readFloat():2===t?e.width=e.height=r.readFloat():3===t?e.top=r.readFloat():4===t?e.height=r.readFloat():5===t?e.mask_type=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(Yy(r,r.readVarint()+r.pos));}class og{static calculate(t,e){const r=new Map,n=new Map;if(0===Object.keys(t).length)return r;e.forEach((t=>{n.set(t.name,t.rgb_color||new Ie(0,0,0));}));for(const[e,i]of Object.entries(t))n.has(e)?r.set(n.get(e).toStringPremultipliedAlpha(),i):console.warn(`Ignoring unknown image variable "${e}"`);return r}}function lg(t,e=255,r){const n=e/255,i=t.toStringPremultipliedAlpha(),a=r.has(i)?r.get(i).clone():t.clone();return a.a=n,a.toString()}function ug(t,e){if(!Vt()){const r=document.createElement("canvas");return r.width=t,r.height=e,r}return new OffscreenCanvas(t,e)}function cg(t,e){const r=og.calculate(e.params,t.metadata?t.metadata.variables:[]),n=t.usvg_tree,i=n.width,a=n.height,s=e.transform?e.transform:new DOMMatrix,o=Math.max(1,Math.round(i*s.a)),l=Math.max(1,Math.round(a*s.d)),u=new DOMMatrix([o/i,0,0,l/a,0,0]),c=ug(o,l).getContext("2d");return hg(c,u,n,n,r),c.getImageData(0,0,o,l)}function hg(t,e,r,n,i){for(const a of n.children)pg(t,e,r,a,i);}function pg(t,e,r,n,i){n.group?(t.save(),function(t,e,r,n,i){const a=null!=n.mask_idx?r.masks[n.mask_idx]:null,s=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;if(n.transform&&(e=_g(n.transform).preMultiplySelf(e)),!function(t,e,r){return 255!==t.opacity||e||r}(n,null!=s,null!=a))return void hg(t,e,r,n,i);const o=ug(t.canvas.width,t.canvas.height),l=o.getContext("2d");hg(l,e,r,n,i),s&&vg(l,e,r,s),a&&bg(l,e,r,a,i),t.globalAlpha=n.opacity/255,t.drawImage(o,0,0);}(t,e,r,n.group,i),t.restore()):n.path&&(t.save(),function(t,e,r,n,i){const a=wg(n);t.setTransform(e),n.paint_order===Ly.PAINT_ORDER_FILL_AND_STROKE?(fg(t,r,n,a,i),mg(t,r,n,a,i)):(mg(t,r,n,a,i),fg(t,r,n,a,i));}(t,e,r,n.path,i),t.restore());}function fg(t,e,r,n,i){const a=r.fill;if(!a)return;const s=a.opacity/255;switch(a.paint){case"rgb_color":t.fillStyle=lg(a.rgb_color,a.opacity,i);break;case"linear_gradient_idx":t.fillStyle=yg(t,e.linear_gradients[a.linear_gradient_idx],s,i);break;case"radial_gradient_idx":t.fillStyle=gg(t,e.radial_gradients[a.radial_gradient_idx],s,i);}t.fill(n,dg(r));}function dg(t){return t.rule===Cy.PATH_RULE_NON_ZERO?"nonzero":t.rule===Cy.PATH_RULE_EVEN_ODD?"evenodd":void 0}function mg(t,e,r,n,i){const a=r.stroke;if(!a)return;t.lineWidth=a.width,t.miterLimit=a.miterlimit,t.setLineDash(a.dasharray),t.lineDashOffset=a.dashoffset;const s=a.opacity/255;switch(a.paint){case"rgb_color":t.strokeStyle=lg(a.rgb_color,a.opacity,i);break;case"linear_gradient_idx":t.strokeStyle=yg(t,e.linear_gradients[a.linear_gradient_idx],s,i);break;case"radial_gradient_idx":t.strokeStyle=gg(t,e.radial_gradients[a.radial_gradient_idx],s,i);}switch(a.linejoin){case Dy.LINE_JOIN_MITER_CLIP:case Dy.LINE_JOIN_MITER:t.lineJoin="miter";break;case Dy.LINE_JOIN_ROUND:t.lineJoin="round";break;case Dy.LINE_JOIN_BEVEL:t.lineJoin="bevel";}switch(a.linecap){case Vy.LINE_CAP_BUTT:t.lineCap="butt";break;case Vy.LINE_CAP_ROUND:t.lineCap="round";break;case Vy.LINE_CAP_SQUARE:t.lineCap="square";}t.stroke(n);}function yg(t,e,r,n){if(1===e.stops.length){const t=e.stops[0];return lg(t.rgb_color,t.opacity*r,n)}const i=_g(e.transform),{x1:a,y1:s,x2:o,y2:l}=e,u=i.transformPoint(new DOMPoint(a,s)),c=i.transformPoint(new DOMPoint(o,l)),h=t.createLinearGradient(u.x,u.y,c.x,c.y);for(const t of e.stops)h.addColorStop(t.offset,lg(t.rgb_color,t.opacity*r,n));return h}function gg(t,e,r,n){if(1===e.stops.length){const t=e.stops[0];return lg(t.rgb_color,t.opacity*r,n)}const i=_g(e.transform),{fx:a,fy:s,cx:o,cy:l}=e,u=i.transformPoint(new DOMPoint(a,s)),c=i.transformPoint(new DOMPoint(o,l)),h=t.createRadialGradient(u.x,u.y,0,c.x,c.y,e.r*((i.a+i.d)/2));for(const t of e.stops)h.addColorStop(t.offset,lg(t.rgb_color,t.opacity*r,n));return h}function xg(t,e,r,n){const i=n.transform?_g(n.transform).preMultiplySelf(e):e,a=ug(t.canvas.width,t.canvas.height),s=a.getContext("2d");for(const t of n.children)if(t.group)xg(s,i,r,t.group);else if(t.path){const e=t.path,r=new Path2D;r.addPath(wg(e),i),s.fill(r,dg(e));}const o=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;o&&vg(s,i,r,o),t.globalCompositeOperation="source-over",t.drawImage(a,0,0);}function vg(t,e,r,n){const i=ug(t.canvas.width,t.canvas.height);xg(i.getContext("2d"),e,r,n),t.globalCompositeOperation="destination-in",t.drawImage(i,0,0);}function bg(t,e,r,n,i){if(0===n.children.length)return;const a=null!=n.mask_idx?r.masks[n.mask_idx]:null;a&&bg(t,e,r,a,i);const s=t.canvas.width,o=t.canvas.height,l=ug(s,o),u=l.getContext("2d"),c=n.width,h=n.height,p=n.left,f=n.top,d=new Path2D,m=new Path2D;m.rect(p,f,c,h),d.addPath(m,e),u.clip(d);for(const t of n.children)pg(u,e,r,t,i);const y=u.getImageData(0,0,s,o),g=y.data;if(n.mask_type===Fy.MASK_TYPE_LUMINANCE)for(let t=0;t<g.length;t+=4)g[t+3]=g[t+3]/255*(.2126*g[t]+.7152*g[t+1]+.0722*g[t+2]);u.putImageData(y,0,0),t.globalCompositeOperation="destination-in",t.drawImage(l,0,0);}function _g(t){return t?new DOMMatrix([t.sx,t.ky,t.kx,t.sy,t.tx,t.ty]):new DOMMatrix}function wg(t){const e=new Path2D,r=t.step;let n=t.diffs[0]*r,i=t.diffs[1]*r;e.moveTo(n,i);for(let a=0,s=2;a<t.commands.length;a++)switch(t.commands[a]){case Ry.PATH_COMMAND_MOVE:n+=t.diffs[s++]*r,i+=t.diffs[s++]*r,e.moveTo(n,i);break;case Ry.PATH_COMMAND_LINE:n+=t.diffs[s++]*r,i+=t.diffs[s++]*r,e.lineTo(n,i);break;case Ry.PATH_COMMAND_QUAD:{const a=n+t.diffs[s++]*r,o=i+t.diffs[s++]*r;n=a+t.diffs[s++]*r,i=o+t.diffs[s++]*r,e.quadraticCurveTo(a,o,n,i);break}case Ry.PATH_COMMAND_CUBIC:{const a=n+t.diffs[s++]*r,o=i+t.diffs[s++]*r,l=a+t.diffs[s++]*r,u=o+t.diffs[s++]*r;n=l+t.diffs[s++]*r,i=u+t.diffs[s++]*r,e.bezierCurveTo(a,o,l,u,n,i);break}case Ry.PATH_COMMAND_CLOSE:e.closePath();}return e}class Mg{constructor(t){this.capacity=t,this.cache=new Map;}get(t){if(!this.cache.has(t))return;const e=this.cache.get(t);return this.cache.delete(t),this.cache.set(t,e),e}put(t,e){this.cache.has(t)?this.cache.delete(t):this.cache.size===this.capacity&&this.cache.delete(this.cache.keys().next().value),this.cache.set(t,e);}delete(t){this.cache.delete(t);}}class Ag{constructor(){this.cacheMap=new Map,this.cacheDependenciesMap=new Map;}static _getImage(t){return new sc(t,t.data)}getFromCache(t,e,r){return this.cacheMap.has(r)||this.cacheMap.set(r,new Mg(150)),this.cacheMap.get(r).get(us(t.serialize(),e))}setInCache(t,e,r,n){this.cacheDependenciesMap.has(n)||this.cacheDependenciesMap.set(n,new Map),this.cacheMap.has(n)||this.cacheMap.set(n,new Mg(150));const i=this.cacheDependenciesMap.get(n);i.get(us(t.id,r))||i.set(us(t.id,r),new Set);const a=this.cacheMap.get(n),s=t.serialize();i.get(us(t.id,r)).add(s),a.put(us(t.serialize(),r),e);}removeImagesFromCacheByIds(t,e,r=""){if(!this.cacheMap.has(r)||!this.cacheDependenciesMap.has(r))return;const n=this.cacheMap.get(r),i=this.cacheDependenciesMap.get(r);for(const r of t)if(i.has(us(r,e))){for(const t of i.get(us(r,e)))n.delete(t);i.delete(us(r,e));}}rasterize(t,e,r,n,i=cg){const a=this.getFromCache(t,r,n);if(a)return a.clone();const s=i(e.icon,t.options),o=Ag._getImage(s);return this.setInCache(t,o,r,n),o.clone()}}class Sg{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Ig(t,e,r,n){let i=0,a=Number.MAX_VALUE;for(let s=0;s<3;s++)if(Math.abs(n[s])<1e-15){if(r[s]<t[s]||r[s]>e[s])return null}else {const o=1/n[s];let l=(t[s]-r[s])*o,u=(e[s]-r[s])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<a&&(a=u),i>a)return null}return i}function Pg(t,e,r,n,i,a,s,o,l,u,c){const h=n-t,p=i-e,f=a-r,d=s-t,m=o-e,y=l-r,g=c[1]*y-c[2]*m,x=c[2]*d-c[0]*y,v=c[0]*m-c[1]*d,b=h*g+p*x+f*v;if(Math.abs(b)<1e-15)return null;const _=1/b,w=u[0]-t,M=u[1]-e,A=u[2]-r,S=(w*g+M*x+A*v)*_;if(S<0||S>1)return null;const I=M*f-A*p,P=A*h-w*f,z=w*p-M*h,E=(c[0]*I+c[1]*P+c[2]*z)*_;return E<0||S+E>1?null:(d*I+m*P+y*z)*_}function zg(t,e,r){return (t-e)/(r-e)}function Eg(t,e,r,n,i,a,s,o,l){const u=1<<r,c=a-n,h=s-i,p=(t+1)/u*c+n,f=(e+0)/u*h+i,d=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=f,l[0]=p,l[1]=d;}class kg{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,a=(t,e,r,n,i)=>{const a=n?1:0,s=(t+1)*r-a,o=e*r,l=(e+1)*r-a;i[0]=t*r,i[1]=o,i[2]=s,i[3]=l;};let s=new Sg(n);const o=[];for(let e=0;e<n*n;e++){a(e%n,Math.floor(e/n),i,!1,o);const r=Bg(o[0],o[1],t),l=Bg(o[2],o[1],t),u=Bg(o[2],o[3],t),c=Bg(o[0],o[3],t);s.minimums.push(Math.min(r,l,u,c)),s.maximums.push(Math.max(r,l,u,c)),s.leaves.push(1);}for(r.push(s),n/=2;n>=1;n/=2){const t=r[r.length-1];s=new Sg(n);for(let e=0;e<n*n;e++){a(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),f=t.isLeaf(o[0],o[3]),d=Math.min(r.min,i.min,l.min,u.min),m=Math.max(r.max,i.max,l.max,u.max),y=c&&h&&p&&f;s.maximums.push(m),s.minimums.push(d),s.leaves.push(m-d<=5&&y?1:0);}r.push(s);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,a,s=1){return Ig([t,e,-100],[r,n,this.maximums[0]*s],i,a)}raycast(t,e,r,n,i,a,s=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,n,i,a,s);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:f,nodex:d,nodey:m,depth:y}=p.pop();if(this.leaves[o]){Eg(d,m,y,t,e,r,n,c,h);const o=1<<y,l=(d+0)/o,u=(d+1)/o,p=(m+0)/o,g=(m+1)/o,x=Bg(l,p,this.dem)*s,v=Bg(u,p,this.dem)*s,b=Bg(u,g,this.dem)*s,_=Bg(l,g,this.dem)*s,w=Pg(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,a),M=Pg(h[0],h[1],b,c[0],h[1],_,c[0],c[1],x,i,a),A=Math.min(null!==w?w:Number.MAX_VALUE,null!==M?M:Number.MAX_VALUE);if(A!==Number.MAX_VALUE)return A;{const t=O.vec3.scaleAndAdd([],i,a,f);if(Tg(x,v,_,b,zg(t[0],c[0],h[0]),zg(t[1],c[1],h[1]))>=t[2])return f}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){Eg((d<<1)+this._siblingOffset[p][0],(m<<1)+this._siblingOffset[p][1],y+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*s;const f=Ig(c,h,i,a);if(null!=f){const t=f;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(d<<1)+this._siblingOffset[e][0],nodey:(m<<1)+this._siblingOffset[e][1],depth:y+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const a=n-1,s=t[a];let o=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],a=s.getElevation(n,i),u=s.isLeaf(n,i),c=this._addNode(a.min,a.max,u);u&&(o|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)o&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],a,l+n);}}function Tg(t,e,r,n,i,a){return ze(ze(t,r,a),ze(e,n,a),i)}function Bg(t,e,r){const n=r.dim,i=Q(t*n-.5,0,n-1),a=Q(e*n-.5,0,n-1),s=Math.floor(i),o=Math.floor(a),l=Math.min(s+1,n-1),u=Math.min(o+1,n-1);return Tg(r.get(s,o),r.get(l,o),r.get(s,u),r.get(l,u),i-s,a-o)}const Cg={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function Vg(t,e,r){return (256*t*256+256*e+r)/10-1e4}function Dg(t,e,r){return 256*t+e+r/256-32768}class Lg{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return void ft(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const i=this.dim=e.height-2,a=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.floatView=new Float32Array(e.data.buffer),this.borderReady=n,this._modifiedForSources={},!n){for(let t=0;t<i;t++)a[this._idx(-1,t)]=a[this._idx(0,t)],a[this._idx(i,t)]=a[this._idx(i-1,t)],a[this._idx(t,-1)]=a[this._idx(t,0)],a[this._idx(t,i)]=a[this._idx(t,i-1)];a[this._idx(-1,-1)]=a[this._idx(0,0)],a[this._idx(i,-1)]=a[this._idx(i-1,0)],a[this._idx(-1,i)]=a[this._idx(0,i-1)],a[this._idx(i,i)]=a[this._idx(i-1,i-1)];}const s="terrarium"===r?Dg:Vg;for(let t=0;t<a.length;++t){const e=4*t;this.floatView[t]=s(this.pixels[e],this.pixels[e+1],this.pixels[e+2]);}this._timestamp=Dt.now();}_buildQuadTree(){this._tree=new kg(this);}get(t,e,r=!1){r&&(t=Q(t,-1,this.dim),e=Q(e,-1,this.dim));const n=this._idx(t,e);return this.floatView[n]}set(t,e,r){const n=this._idx(t,e),i=this.floatView[n];return this.floatView[n]=r,r-i}static getUnpackVector(t){return Cg[t]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=Lg.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new oc({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,a=r*this.dim,s=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:a=s-1;break;case 1:s=a+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=a;e<s;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+o,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}function Rg(t,e,r){1===t?e.headerLength=r.readFixed32():2===t?e.x=r.readVarint():3===t?e.y=r.readVarint():4===t?e.z=r.readVarint():5===t&&e.layers.push(function(t,e){return t.readFields(jg,{version:0,name:"",units:"",tileSize:0,buffer:0,pixelFormat:0,dataIndex:[]},e)}(r,r.readVarint()+r.pos));}function Fg(t,e,r){1===t?(e.delta_filter=function(t,e){return t.readFields(Og,{blockSize:0},e)}(r,r.readVarint()+r.pos),e.filter="delta_filter"):2===t?(r.readVarint(),e.filter="zigzag_filter"):3===t?(r.readVarint(),e.filter="bitshuffle_filter"):4===t&&(r.readVarint(),e.filter="byteshuffle_filter");}function Og(t,e,r){1===t&&(e.blockSize=r.readVarint());}function Ng(t,e,r){1===t?(r.readVarint(),e.codec="gzip_data"):2===t?(r.readVarint(),e.codec="jpeg_image"):3===t?(r.readVarint(),e.codec="webp_image"):4===t&&(r.readVarint(),e.codec="png_image");}function Ug(t,e,r){let n=0,i=0;1===t?e.firstByte=r.readFixed64():2===t?e.lastByte=r.readFixed64():3===t?e.filters.push(function(t,e){return t.readFields(Fg,{},e)}(r,r.readVarint()+r.pos)):4===t?e.codec=function(t,e){return t.readFields(Ng,{},e)}(r,r.readVarint()+r.pos):5===t?i=r.readFloat():6===t?n=r.readFloat():7===t?e.bands.push(r.readString()):8===t?e.offset=r.readDouble():9===t&&(e.scale=r.readDouble()),0===e.offset&&(e.offset=i),0===e.scale&&(e.scale=n);}function jg(t,e,r){1===t?e.version=r.readVarint():2===t?e.name=r.readString():3===t?e.units=r.readString():4===t?e.tileSize=r.readVarint():5===t?e.buffer=r.readVarint():6===t?e.pixelFormat=r.readVarint():7===t&&e.dataIndex.push(function(t,e){return t.readFields(Ug,{firstByte:0,lastByte:0,filters:[],codec:null,offset:0,scale:0,bands:[]},e)}(r,r.readVarint()+r.pos));}function qg(t,e,r){if(2===t)!function(t,e,r){t.readFields($g,r,e);}(r,r.readVarint()+r.pos,e);else if(3===t)throw new Error("Not implemented")}function $g(t,e,r){if(1===t){let t=0;const n=r.readVarint()+r.pos;for(;r.pos<n;)e[t++]=r.readVarint();}}function Gg(t,e){if(4!==e.length)throw new Error(`Expected data of dimension 4 but got ${e.length}.`);let r=e[3];for(let n=2;n>=1;n--){const i=1===n?1:0,a=2===n?1:0;for(let n=0;n<e[0];n++){const s=e[1]*n;for(let n=i;n<e[1];n++){const i=e[2]*(n+s);for(let n=a;n<e[2];n++){const a=e[3]*(n+i);for(let n=0;n<e[3];n++){const e=a+n;t[e]+=t[e-r];}}}}r*=e[n];}return t}function Yg(t){for(let e=0,r=t.length;e<r;e++)t[e]=t[e]>>>1^-(1&t[e]);return t}function Xg(t,e){switch(e){case"uint32":return t;case"uint16":for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];t[e]=(240&r)>>4|(61440&r)>>8|(240&n)<<4|61440&n,t[e+1]=15&r|(3840&r)>>4|(15&n)<<8|(3840&n)<<4;}return t;case"uint8":for(let e=0;e<t.length;e+=4){const r=t[e],n=t[e+1],i=t[e+2],a=t[e+3];t[e+0]=(192&r)>>6|(192&n)>>4|(192&i)>>2|192&a,t[e+1]=(48&r)>>4|(48&n)>>2|48&i|(48&a)<<2,t[e+2]=(12&r)>>2|12&n|(12&i)<<2|(12&a)<<4,t[e+3]=3&r|(3&n)<<2|(3&i)<<4|(3&a)<<6;}return t;default:throw new Error(`Invalid pixel format, "${e}"`)}}oa(Lg,"DEMData"),oa(kg,"DemMinMaxQuadTree",{omit:["dem"]});var Zg=Uint8Array,Hg=Uint16Array,Wg=Int32Array,Kg=new Zg([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),Jg=new Zg([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),Qg=new Zg([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),tx=function(t,e){for(var r=new Hg(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new Wg(r[30]);for(n=1;n<30;++n)for(var a=r[n];a<r[n+1];++a)i[a]=a-r[n]<<5|n;return {b:r,r:i}},ex=tx(Kg,2),rx=ex.b,nx=ex.r;rx[28]=258,nx[258]=28;for(var ix=tx(Jg,0).b,ax=new Hg(32768),sx=0;sx<32768;++sx){var ox=(43690&sx)>>1|(21845&sx)<<1;ax[sx]=((65280&(ox=(61680&(ox=(52428&ox)>>2|(13107&ox)<<2))>>4|(3855&ox)<<4))>>8|(255&ox)<<8)>>1;}var lx=function(t,e,r){for(var n=t.length,i=0,a=new Hg(e);i<n;++i)t[i]&&++a[t[i]-1];var s,o=new Hg(e);for(i=1;i<e;++i)o[i]=o[i-1]+a[i-1]<<1;s=new Hg(1<<e);var l=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],c=e-t[i],h=o[t[i]-1]++<<c,p=h|(1<<c)-1;h<=p;++h)s[ax[h]>>l]=u;return s},ux=new Zg(288);for(sx=0;sx<144;++sx)ux[sx]=8;for(sx=144;sx<256;++sx)ux[sx]=9;for(sx=256;sx<280;++sx)ux[sx]=7;for(sx=280;sx<288;++sx)ux[sx]=8;var cx=new Zg(32);for(sx=0;sx<32;++sx)cx[sx]=5;var hx=lx(ux,9),px=lx(cx,5),fx=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},dx=function(t,e,r){var n=e/8|0;return (t[n]|t[n+1]<<8)>>(7&e)&r},mx=function(t,e){var r=e/8|0;return (t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},yx=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],gx=function(t,e,r){var n=new Error(e||yx[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,gx),!r)throw n;return n},xx=new Zg(0),vx="undefined"!=typeof TextDecoder&&new TextDecoder;try{vx.decode(xx,{stream:!0});}catch(t){}const bx={gzip_data:"gzip"};class _x extends Error{constructor(t){super(t),this.name="MRTError";}}const wx={0:"uint32",1:"uint32",2:"uint16",3:"uint8"},Mx={uint32:1,uint16:2,uint8:4},Ax={uint32:Uint32Array,uint16:Uint16Array,uint8:Uint8Array};let Sx;class Ix{constructor(t=5){this.x=NaN,this.y=NaN,this.z=NaN,this.layers={},this._cacheSize=t;}getLayer(t){const e=this.layers[t];if(!e)throw new _x(`Layer '${t}' not found`);return e}getHeaderLength(t){const e=new Uint8Array(t),r=new DataView(t);if(13!==e[0])throw new _x("File is not a valid MRT.");return r.getUint32(1,!0)}parseHeader(t){const e=new Uint8Array(t),r=this.getHeaderLength(t);if(e.length<r)throw new _x(`Expected header with length >= ${r} but got buffer of length ${e.length}`);const n=function(t,e){return t.readFields(Rg,{headerLength:0,x:0,y:0,z:0,layers:[]},void 0)}(new Sx(e.subarray(0,r)));if(!isNaN(this.x)&&(this.x!==n.x||this.y!==n.y||this.z!==n.z))throw new _x(`Invalid attempt to parse header ${n.z}/${n.x}/${n.y} for tile ${this.z}/${this.x}/${this.y}`);this.x=n.x,this.y=n.y,this.z=n.z;for(const t of n.layers)this.layers[t.name]=new Px(t,{cacheSize:this._cacheSize});return this}createDecodingTask(t){const e=[],r=this.getLayer(t.layerName);for(let n of t.blockIndices){const i=r.dataIndex[n],a=i.firstByte-t.firstByte,s=i.lastByte-t.firstByte;if(r._blocksInProgress.has(n))continue;const o={layerName:r.name,firstByte:a,lastByte:s,pixelFormat:r.pixelFormat,blockIndex:n,blockShape:[i.bands.length].concat(r.bandShape),buffer:r.buffer,codec:i.codec.codec,filters:i.filters.map((t=>t.filter))};r._blocksInProgress.add(n),e.push(o);}return new zx(e,(()=>{e.forEach((t=>r._blocksInProgress.delete(t.blockIndex)));}),((t,n)=>{if(e.forEach((t=>r._blocksInProgress.delete(t.blockIndex))),t)throw t;n.forEach((t=>{this.getLayer(t.layerName).processDecodedData(t);}));}))}}class Px{constructor({version:t,name:e,units:r,tileSize:n,pixelFormat:i,buffer:a,dataIndex:s},o){if(this.version=t,1!==this.version)throw new _x(`Cannot parse raster layer encoded with MRT version ${t}`);this.name=e,this.units=r,this.tileSize=n,this.buffer=a,this.pixelFormat=wx[i],this.dataIndex=s,this.bandShape=[n+2*a,n+2*a,Mx[this.pixelFormat]],this._decodedBlocks=new Mg(o?o.cacheSize:5),this._blocksInProgress=new Set;}get dimension(){return Mx[this.pixelFormat]}get cacheSize(){return this._decodedBlocks.capacity}getBandList(){return this.dataIndex.map((({bands:t})=>t)).flat()}processDecodedData(t){const e=t.blockIndex.toString();this._decodedBlocks.get(e)||this._decodedBlocks.put(e,t.data);}getBlockForBand(t){let e=0;switch(typeof t){case"string":for(const[r,n]of this.dataIndex.entries()){for(const[i,a]of n.bands.entries())if(a===t)return {bandIndex:e+i,blockIndex:r,blockBandIndex:i};e+=n.bands.length;}break;case"number":for(const[r,n]of this.dataIndex.entries()){if(t>=e&&t<e+n.bands.length)return {bandIndex:t,blockIndex:r,blockBandIndex:t-e};e+=n.bands.length;}break;default:throw new _x(`Invalid band \`${JSON.stringify(t)}\`. Expected string or integer.`)}throw new _x(`Band not found: ${JSON.stringify(t)}`)}getDataRange(t){let e=1/0,r=-1/0;const n=[],i=new Set;for(const a of t){const{blockIndex:t}=this.getBlockForBand(a);if(t<0)throw new _x(`Invalid band: ${JSON.stringify(a)}`);const s=this.dataIndex[t];n.includes(t)||n.push(t),i.add(t),e=Math.min(e,s.firstByte),r=Math.max(r,s.lastByte);}if(i.size>this.cacheSize)throw new _x(`Number of blocks to decode (${i.size}) exceeds cache size (${this.cacheSize}).`);return {layerName:this.name,firstByte:e,lastByte:r,blockIndices:n}}hasBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0}hasDataForBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0&&!!this._decodedBlocks.get(e.toString())}getBandView(t){const{blockIndex:e,blockBandIndex:r}=this.getBlockForBand(t),n=this._decodedBlocks.get(e.toString());if(!n)throw new _x(`Data for band ${JSON.stringify(t)} of layer "${this.name}" not decoded.`);const i=this.dataIndex[e],a=this.bandShape.reduce(((t,e)=>t*e),1),s=r*a,o=n.subarray(s,s+a);return {data:o,bytes:new Uint8Array(o.buffer).subarray(o.byteOffset,o.byteOffset+o.byteLength),tileSize:this.tileSize,buffer:this.buffer,pixelFormat:this.pixelFormat,dimension:this.dimension,offset:i.offset,scale:i.scale}}}Ix.setPbf=function(t){Sx=t;};class zx{constructor(t,e,r){this.tasks=t,this._onCancel=e,this._onComplete=r,this._finalized=!1;}cancel(){this._finalized||(this._onCancel(),this._finalized=!0);}complete(t,e){this._finalized||(this._onComplete(t,e),this._finalized=!0);}}Ix.performDecoding=function(t,e){const r=new Uint8Array(t);return Promise.all(e.tasks.map((t=>{const{layerName:e,firstByte:n,lastByte:i,pixelFormat:a,blockShape:s,blockIndex:o,filters:l,codec:u}=t,c=r.subarray(n,i+1),h=new Uint32Array(s[0]*s[1]*s[2]);let p;if("gzip_data"!==u)throw new _x(`Unhandled codec: ${u}`);return p=function(t,e){if(!globalThis.DecompressionStream&&"gzip_data"===e)return Promise.resolve(((a=function(t){31==t[0]&&139==t[1]&&8==t[2]||gx(6,"invalid gzip data");var e=t[3],r=10;4&e&&(r+=2+(t[10]|t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[r++]);return r+(2&e)}(i=t))+8>i.length&&gx(6,"invalid gzip data"),function(t,e,r,n){var i=t.length;if(!i||e.f&&!e.l)return r||new Zg(0);var a=!r,s=a||2!=e.i,o=e.i;a&&(r=new Zg(3*i));var l,u,c=function(t){var e=r.length;if(t>e){var n=new Zg(Math.max(2*e,t));n.set(r),r=n;}},h=e.f||0,p=e.p||0,f=e.b||0,d=e.l,m=e.d,y=e.m,g=e.n,x=8*i;do{if(!d){h=dx(t,p,1);var v=dx(t,p+1,3);if(p+=3,!v){var b=t[(T=4+((p+7)/8|0))-4]|t[T-3]<<8,_=T+b;if(_>i){o&&gx(0);break}s&&c(f+b),r.set(t.subarray(T,_),f),e.b=f+=b,e.p=p=8*_,e.f=h;continue}if(1==v)d=hx,m=px,y=9,g=5;else if(2==v){var w=dx(t,p,31)+257,M=dx(t,p+10,15)+4,A=w+dx(t,p+5,31)+1;p+=14;for(var S=new Zg(A),I=new Zg(19),P=0;P<M;++P)I[Qg[P]]=dx(t,p+3*P,7);p+=3*M;var z=fx(I),E=(1<<z)-1,k=lx(I,z);for(P=0;P<A;){var T,B=k[dx(t,p,E)];if(p+=15&B,(T=B>>4)<16)S[P++]=T;else {var C=0,V=0;for(16==T?(V=3+dx(t,p,3),p+=2,C=S[P-1]):17==T?(V=3+dx(t,p,7),p+=3):18==T&&(V=11+dx(t,p,127),p+=7);V--;)S[P++]=C;}}var D=S.subarray(0,w),L=S.subarray(w);y=fx(D),g=fx(L),d=lx(D,y),m=lx(L,g);}else gx(1);if(p>x){o&&gx(0);break}}s&&c(f+131072);for(var R=(1<<y)-1,F=(1<<g)-1,O=p;;O=p){var N=(C=d[mx(t,p)&R])>>4;if((p+=15&C)>x){o&&gx(0);break}if(C||gx(2),N<256)r[f++]=N;else {if(256==N){O=p,d=null;break}var U=N-254;N>264&&(U=dx(t,p,(1<<($=Kg[P=N-257]))-1)+rx[P],p+=$);var j=m[mx(t,p)&F],q=j>>4;if(j||gx(3),p+=15&j,L=ix[q],q>3){var $=Jg[q];L+=mx(t,p)&(1<<$)-1,p+=$;}if(p>x){o&&gx(0);break}s&&c(f+131072);var G=f+U;if(f<L){var Y=0-L,X=Math.min(L,G);for(Y+f<0&&gx(3);f<X;++f)r[f]=(void 0)[Y+f];}for(;f<G;++f)r[f]=r[f-L];}}e.l=d,e.p=O,e.b=f,e.f=h,d&&(h=1,e.m=y,e.d=m,e.n=g);}while(!h);return f!=r.length&&a?(l=r,(null==(u=f)||u>l.length)&&(u=l.length),new Zg(l.subarray(0,u))):r.subarray(0,f)}(i.subarray(a,-8),{i:2},new Zg(((r=i)[(n=r.length)-4]|r[n-3]<<8|r[n-2]<<16|r[n-1]<<24)>>>0))));var r,n,i,a;const s=bx[e];if(!s)throw new Error(`Unhandled codec: ${e}`);const o=new globalThis.DecompressionStream(s);return new Response(new Blob([t]).stream().pipeThrough(o)).arrayBuffer().then((t=>new Uint8Array(t)))}(c,u).then((t=>(function(t,e){t.readFields(qg,e);}(new Sx(t),h),new(0,Ax[a])(h.buffer)))),p.then((t=>{for(let e=l.length-1;e>=0;e--)switch(l[e]){case"delta_filter":Gg(t,s);break;case"zigzag_filter":Yg(t);break;case"bitshuffle_filter":Xg(t,a);break;default:throw new _x(`Unhandled filter "${l[e]}"`)}return {layerName:e,blockIndex:o,data:t}})).catch((t=>{throw t}))})))},oa(zx,"MRTDecodingBatch",{omit:["_onCancel","_onComplete"]});let Ex,kx,Tx,Bx,Cx,Vx=null;function Dx(){return gt()&&self.worker&&self.worker.dracoUrl?self.worker.dracoUrl:kx||St.DRACO_URL}function Lx(){if(gt()&&self.worker&&self.worker.meshoptUrl)return self.worker.meshoptUrl;if(Bx)return Bx;const t=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]);if("object"!=typeof WebAssembly)throw new Error("WebAssembly not supported, cannot instantiate meshoptimizer");return Bx=WebAssembly.validate(t)?St.MESHOPT_SIMD_URL:St.MESHOPT_URL,Bx}const Rx={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},Fx={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",5123:"DT_UINT16",5125:"DT_UINT32",5126:"DT_FLOAT32"},Ox={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function Nx(t,e,r){const n=r.json.bufferViews.length,i=r.buffers.length;e.bufferView=n,r.json.bufferViews[n]={buffer:i,byteLength:t.byteLength},r.buffers[i]=t;}const Ux="KHR_draco_mesh_compression";function jx(t,e){const r=t.extensions&&t.extensions[Ux];if(!r)return;const n=new Tx.Decoder,i=Hx(e,r.bufferView),a=new Tx.Mesh;if(!n.DecodeArrayToMesh(i,i.byteLength,a))throw new Error("Failed to decode Draco mesh");const s=e.json.accessors[t.indices],o=Rx[s.componentType],l=s.count*o.BYTES_PER_ELEMENT,u=Tx._malloc(l);o===Uint16Array?n.GetTrianglesUInt16Array(a,l,u):n.GetTrianglesUInt32Array(a,l,u),Nx(Tx.memory.buffer.slice(u,u+l),s,e),Tx._free(u);for(const i of Object.keys(r.attributes)){const s=n.GetAttributeByUniqueId(a,r.attributes[i]),o=e.json.accessors[t.attributes[i]],l=Fx[o.componentType],u=o.count*Ox[o.type]*Rx[o.componentType].BYTES_PER_ELEMENT,c=Tx._malloc(u);n.GetAttributeDataArrayForAllPoints(a,s,Tx[l],u,c),Nx(Tx.memory.buffer.slice(c,c+u),o,e),Tx._free(c);}n.destroy(),a.destroy(),delete t.extensions[Ux];}const qx="EXT_meshopt_compression";function $x(t,e){if(!t.extensions||!t.extensions[qx])return;const r=t.extensions[qx],n=new Uint8Array(e.buffers[r.buffer],r.byteOffset||0,r.byteLength||0),i=new Uint8Array(r.count*r.byteStride);Cx.decodeGltfBuffer(i,r.count,r.byteStride,n,r.mode,r.filter),t.buffer=e.buffers.length,t.byteOffset=0,e.buffers[t.buffer]=i.buffer,delete t.extensions[qx];}const Gx=1179937895,Yx=new TextDecoder("utf8");function Xx(t,e){return new URL(t,e).href}function Zx(t,e,r,n){return fetch(Xx(t.uri,n)).then((t=>t.arrayBuffer())).then((t=>{e.buffers[r]=t;}))}function Hx(t,e){const r=t.json.bufferViews[e];return new Uint8Array(t.buffers[r.buffer],r.byteOffset||0,r.byteLength)}function Wx(t,e,r,n){if(t.uri){const i=Xx(t.uri,n);return fetch(i).then((t=>t.blob())).then((t=>createImageBitmap(t))).then((t=>{e.images[r]=t;}))}if(void 0!==t.bufferView){const n=Hx(e,t.bufferView),i=new Blob([n],{type:t.mimeType});return createImageBitmap(i).then((t=>{e.images[r]=t;}))}}function Kx(t,e=0,r){const n={json:null,images:[],buffers:[]};if(new Uint32Array(t,e,1)[0]===Gx){const r=new Uint32Array(t,e);let i=2;const a=(r[i++]>>2)-3,s=r[i++]>>2;if(i++,n.json=JSON.parse(Yx.decode(r.subarray(i,i+s))),i+=s,i<a){const a=r[i++];i++;const s=e+(i<<2);n.buffers[0]=t.slice(s,s+a);}}else n.json=JSON.parse(Yx.decode(new Uint8Array(t,e)));const{buffers:i,images:a,meshes:s,extensionsUsed:o,bufferViews:l}=n.json;let u=Promise.resolve();if(i){const t=[];for(let e=0;e<i.length;e++){const a=i[e];a.uri?t.push(Zx(a,n,e,r)):n.buffers[e]||(n.buffers[e]=null);}u=Promise.all(t);}return u.then((()=>{const t=[],e=o&&o.includes(Ux),i=o&&o.includes(qx);if(e&&t.push(function(){if(!Tx)return null!=Ex?Ex:(Ex=function(t){let e,r=null;function n(){e=new Uint8Array(r.buffer);}function i(){throw new Error("Unexpected Draco error.")}const a={a:{a:i,d:function(t,r,n){return e.copyWithin(t,r,r+n)},c:function(t){const i=e.length,a=Math.max(t>>>0,Math.ceil(1.2*i)),s=Math.ceil((a-i)/65536);try{return r.grow(s),n(),!0}catch(t){return !1}},b:i}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,a):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,a)))).then((t=>{const{Rb:i,Qb:a,P:s,T:o,X:l,Ja:u,La:c,Qa:h,Va:p,Wa:f,eb:d,jb:m,f:y,e:g,yb:x,zb:v,Ab:b,Bb:_,Db:w,Gb:M}=t.instance.exports;r=g;const A=(()=>{let t=0,r=0,n=0,s=0;return o=>{n&&(i(s),i(t),r+=n,n=t=0),t||(r+=128,t=a(r));const l=o.length+7&-8;let u=t;l>=r&&(n=l,u=s=a(l));for(let t=0;t<o.length;t++)e[u+t]=o[t];return u}})();return n(),y(),{memory:g,_free:i,_malloc:a,Mesh:class{constructor(){this.ptr=s();}destroy(){o(this.ptr);}},Decoder:class{constructor(){this.ptr=u();}destroy(){m(this.ptr);}DecodeArrayToMesh(t,e,r){const n=A(t),i=c(this.ptr,n,e,r.ptr);return !!l(i)}GetAttributeByUniqueId(t,e){return {ptr:h(this.ptr,t.ptr,e)}}GetTrianglesUInt16Array(t,e,r){p(this.ptr,t.ptr,e,r);}GetTrianglesUInt32Array(t,e,r){f(this.ptr,t.ptr,e,r);}GetAttributeDataArrayForAllPoints(t,e,r,n,i){d(this.ptr,t.ptr,e.ptr,r,n,i);}},DT_INT8:x(),DT_UINT8:v(),DT_INT16:b(),DT_UINT16:_(),DT_UINT32:w(),DT_FLOAT32:M()}}))}(fetch(Dx())),Ex.then((t=>{Tx=t,Ex=void 0;})))}()),i&&t.push(function(){if(Cx)return;const t=function(t){let e;const r=WebAssembly.instantiateStreaming(t,{}).then((t=>{e=t.instance,e.exports.__wasm_call_ctors();})),n={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},i={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"};return {ready:r,supported:!0,decodeGltfBuffer(t,r,a,s,o,l){!function(t,e,r,n,i,a,s){const o=t.exports.sbrk,l=n+3&-4,u=o(l*i),c=o(a.length),h=new Uint8Array(t.exports.memory.buffer);h.set(a,c);const p=e(u,n,i,c,a.length);if(0===p&&s&&s(u,l,i),r.set(h.subarray(u,u+n*i)),o(u-o(0)),0!==p)throw new Error(`Malformed buffer data: ${p}`)}(e,e.exports[i[o]],t,r,a,s,e.exports[n[l]]);}}}(fetch(Lx()));return t.ready.then((()=>{Cx=t;}))}()),a)for(let e=0;e<a.length;e++)t.push(Wx(a[e],n,e,r));return (t.length?Promise.all(t):Promise.resolve()).then((()=>{if(e&&s)for(const{primitives:t}of s)for(const e of t)jx(e,n);if(i&&s&&l)for(const t of l)$x(t,n);return n}))}))}function Jx(t,e){const r=t.json.bufferViews[e.bufferView],n=Rx[e.componentType];return new n(t.buffers[r.buffer],(e.byteOffset||0)+(r.byteOffset||0),e.count*(r.byteStride&&r.byteStride!==Ox[e.type]*n.BYTES_PER_ELEMENT?r.byteStride/n.BYTES_PER_ELEMENT:Ox[e.type]))}function Qx(t,e,r,n){const i=Rx[e.componentType],a=function(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:return 1}}(i),s=t.json.bufferViews[e.bufferView],o=s.byteStride?s.byteStride/i.BYTES_PER_ELEMENT:Ox[e.type],l=r.float32,u=l.length/r.capacity;for(let t=0,r=0;t<e.count*o;t+=o,r+=u)for(let e=0;e<u;e++)l[r+e]=n[t+e]*a;r._trim();}function tv(t,e,r){const n=t.indices,i=t.attributes,a={};a.indexArray=new Ls;const s=e.json.accessors[n],o=s.count/3;a.indexArray.reserve(o);const l=Jx(e,s);for(let t=0;t<o;t++)a.indexArray.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);a.indexArray._trim(),a.vertexArray=new Ms;const u=e.json.accessors[i.POSITION];a.vertexArray.reserve(u.count);const c=Jx(e,u);for(let t=0;t<u.count;t++)a.vertexArray.emplaceBack(c[3*t],c[3*t+1],c[3*t+2]);if(a.vertexArray._trim(),a.aabb=new xu(u.min,u.max),a.centroid=function(t,e){const r=[0,0,0],n=t.length;if(n>0){for(let i=0;i<n;i++){const n=3*t[i];r[0]+=e[n],r[1]+=e[n+1],r[2]+=e[n+2];}r[0]/=n,r[1]/=n,r[2]/=n;}return r}(l,c),void 0!==i.COLOR_0){const t=e.json.accessors[i.COLOR_0],r=Ox[t.type],n=Jx(e,t);a.colorArray=3===r?new Ms:new Es,a.colorArray.resize(t.count),Qx(e,t,a.colorArray,n);}if(void 0!==i.NORMAL){a.normalArray=new Ms;const t=e.json.accessors[i.NORMAL];a.normalArray.resize(t.count);const r=Jx(e,t);Qx(e,t,a.normalArray,r);}if(void 0!==i.TEXCOORD_0&&r.length>0){a.texcoordArray=new $s;const t=e.json.accessors[i.TEXCOORD_0];a.texcoordArray.resize(t.count);const r=Jx(e,t);Qx(e,t,a.texcoordArray,r);}if(void 0!==i._FEATURE_ID_RGBA4444){const t=e.json.accessors[i._FEATURE_ID_RGBA4444];e.json.extensionsUsed&&e.json.extensionsUsed.includes("EXT_meshopt_compression")&&(a.featureData=Jx(e,t));}void 0!==i._FEATURE_RGBA4444&&(a.featureData=new Uint32Array(Jx(e,e.json.accessors[i._FEATURE_RGBA4444]).buffer));const h=t.material;return a.material=function(t,e){const{emissiveFactor:r=[0,0,0],alphaMode:n="OPAQUE",alphaCutoff:i=.5,normalTexture:a,occlusionTexture:s,emissiveTexture:o,doubleSided:l}=t,{baseColorFactor:u=[1,1,1,1],metallicFactor:c=1,roughnessFactor:h=1,baseColorTexture:p,metallicRoughnessTexture:f}=t.pbrMetallicRoughness||{},d=s?e[s.index]:void 0;if(s&&s.extensions&&s.extensions.KHR_texture_transform&&d){const t=s.extensions.KHR_texture_transform;d.offsetScale=[t.offset[0],t.offset[1],t.scale[0],t.scale[1]];}return {pbrMetallicRoughness:{baseColorFactor:new Ie(...u),metallicFactor:c,roughnessFactor:h,baseColorTexture:p?e[p.index]:void 0,metallicRoughnessTexture:f?e[f.index]:void 0},doubleSided:l,emissiveFactor:r,alphaMode:n,alphaCutoff:i,normalTexture:a?e[a.index]:void 0,occlusionTexture:d,emissionTexture:o?e[o.index]:void 0,defined:void 0===t.defined}}(void 0!==h?e.json.materials[h]:{defined:!1},r),a}function ev(t,e,r){const{matrix:n,rotation:i,translation:a,scale:s,mesh:o,extras:l,children:u}=t,c={};if(c.matrix=n||O.mat4.fromRotationTranslationScale([],i||[0,0,0,1],a||[0,0,0],s||[1,1,1]),void 0!==o){c.meshes=r[o];const t=c.anchor=[0,0];for(const e of c.meshes){const{min:r,max:n}=e.aabb;t[0]+=r[0]+n[0],t[1]+=r[1]+n[1];}t[0]=Math.floor(t[0]/c.meshes.length/2),t[1]=Math.floor(t[1]/c.meshes.length/2);}if(l&&(l.id&&(c.id=l.id),l.lights&&(c.lights=function(t){if(!t.length)return [];const e=function(t){const e=atob(t),r=new Uint8Array(e.length);for(let t=0;t<e.length;t++)r[t]=e.codePointAt(t);return r}(t),r=[],n=e.length/24,i=new Uint16Array(e.buffer),a=new Float32Array(e.buffer);for(let t=0;t<n;t++){const e=i[2*t*6]/30,n=i[2*t*6+1]/30,s=i[2*t*6+10]/100,o=a[6*t+1],l=a[6*t+2],u=a[6*t+3],c=a[6*t+4],h=u-o,p=c-l,f=Math.hypot(h,p);r.push({pos:[o+.5*h,l+.5*p,n],normal:[p/f,-h/f,0],width:f,height:e,depth:s,points:[o,l,u,c]});}return r}(l.lights))),u){const t=[];for(const n of u)t.push(ev(e.json.nodes[n],e,r));c.children=t;}return c}function rv(t){if(0===t.vertices.length||0===t.indices.length)return null;const e=new Yc(t.vertices,t.indices,8,256),[r,n]=[e.min.clone(),e.max.clone()];return {vertices:t.vertices,indices:t.indices,grid:e,min:r,max:n}}function nv(t){if(!t.extras||!t.extras.ground)return null;const e=t.extras.ground;if(!e||!Array.isArray(e)||0===e.length)return null;const r=e[0];if(!r||!Array.isArray(r)||0===r.length)return null;const n=[];for(const t of r){if(!Array.isArray(t)||2!==t.length)continue;const e=t[0],r=t[1];"number"==typeof e&&"number"==typeof r&&n.push(new q(e,r));}if(n.length<3)return null;n.length>1&&n[n.length-1].equals(n[0])&&n.pop();let i=0;for(let t=0;t<n.length;t++){const e=n[t],r=n[(t+1)%n.length],a=n[(t+2)%n.length];i+=(e.x-r.x)*(a.y-r.y)-(a.x-r.x)*(e.y-r.y);}i>0&&n.reverse();const a=hc(n.flatMap((t=>[t.x,t.y])),[]);return 0===a.length?null:{vertices:n,indices:a}}function iv(t,e){const r=[],n=[];let i=0;const a=[];for(const s of t){i=r.length;const t=s.vertexArray.float32,o=s.indexArray.uint16;for(let n=0;n<s.vertexArray.length;n++)a[0]=t[3*n+0],a[1]=t[3*n+1],a[2]=t[3*n+2],O.vec3.transformMat4(a,a,e),r.push(new q(a[0],a[1]));for(let t=0;t<3*s.indexArray.length;t++)n.push(o[t]+i);}if(n.length%3!=0)return null;for(let t=0;t<n.length;t+=3){const e=r[n[t+0]],i=r[n[t+1]],a=r[n[t+2]];(e.x-i.x)*(a.y-i.y)-(a.x-i.x)*(e.y-i.y)>0&&([n[t+1],n[t+2]]=[n[t+2],n[t+1]]);}return {vertices:r,indices:n}}function av(t){const e=function(t,e){const r=[],n=WebGL2RenderingContext;if(t.json.textures)for(const i of t.json.textures){const a={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==i.sampler&&Object.assign(a,t.json.samplers[i.sampler]),r.push({image:e[i.source],sampler:a,uploaded:!1});}return r}(t,t.images),r=function(t,e){const r=[];for(const n of t.json.meshes){const i=[];for(const r of n.primitives)i.push(tv(r,t,e));r.push(i);}return r}(t,e),{scenes:n,scene:i,nodes:a}=t.json,s=n?n[i||0].nodes:a,o=[];for(const e of s)o.push(ev(a[e],t,r));return function(t,e,r){const n={},i=new Set;for(let a=0;a<t.length;a++){const t=r[e[a]];if(!t.extras)continue;const s=t.extras["mapbox:footprint:version"],o=t.extras["mapbox:footprint:id"];(s||o)&&i.add(a),"1.0.0"===s&&o&&(n[o]=a);}for(let a=0;a<t.length;a++){if(i.has(a))continue;const s=t[a],o=r[e[a]];if(!o.extras)continue;let l=null;s.id in n&&(l=iv(t[n[s.id]].meshes,s.matrix)),l||(l=nv(o)),l&&(s.footprint=rv(l));}if(i.size>0){const e=Array.from(i.values()).sort(((t,e)=>t-e));for(let r=e.length-1;r>=0;r--)t.splice(e[r],1);}}(o,s,t.json.nodes),o}function sv(t){t.heightmap=new Float32Array(4096),t.heightmap.fill(-1);const e=t.vertexArray.float32,r=t.aabb.min[0]-1,n=t.aabb.min[1]-1,i=ey/(t.aabb.max[0]-r+2),a=ey/(t.aabb.max[1]-n+2);for(let s=0;s<e.length;s+=3){const o=e[s+2],l=(e[s+0]-r)*i|0,u=(e[s+1]-n)*a|0;o>t.heightmap[u*ey+l]&&(t.heightmap[u*ey+l]=o);}}function ov(t,e){const r={};r.indexArray=new Ls,r.indexArray.reserve(4*t.length),r.vertexArray=new Ms,r.vertexArray.reserve(10*t.length),r.colorArray=new Es,r.vertexArray.reserve(10*t.length);let n=0;for(const i of t){const t=Math.min(10,Math.max(4,1.3*i.height))*e,a=[-i.normal[1],i.normal[0],0],s=Math.min(.29,.1*i.width/i.depth),o=i.width-2*i.depth*e*(s+.01),l=O.vec3.scaleAndAdd([],i.pos,a,o/2),u=O.vec3.scaleAndAdd([],i.pos,a,-o/2),c=[l[0],l[1],l[2]+i.height],h=[u[0],u[1],u[2]+i.height],p=O.vec3.scaleAndAdd([],i.normal,a,s);O.vec3.scale(p,p,t);const f=O.vec3.scaleAndAdd([],i.normal,a,-s);O.vec3.scale(f,f,t),O.vec3.add(p,l,p),O.vec3.add(f,u,f),l[2]+=.1,u[2]+=.1,r.vertexArray.emplaceBack(p[0],p[1],p[2]),r.vertexArray.emplaceBack(f[0],f[1],f[2]),r.vertexArray.emplaceBack(l[0],l[1],l[2]),r.vertexArray.emplaceBack(u[0],u[1],u[2]),r.vertexArray.emplaceBack(c[0],c[1],c[2]),r.vertexArray.emplaceBack(h[0],h[1],h[2]),r.vertexArray.emplaceBack(l[0],l[1],l[2]),r.vertexArray.emplaceBack(u[0],u[1],u[2]),r.vertexArray.emplaceBack(p[0],p[1],p[2]),r.vertexArray.emplaceBack(f[0],f[1],f[2]);const d=o/t/2;r.colorArray.emplaceBack(-d-s,-1,d,.8),r.colorArray.emplaceBack(d+s,-1,d,.8),r.colorArray.emplaceBack(-d,0,d,1.3),r.colorArray.emplaceBack(d,0,d,1.3),r.colorArray.emplaceBack(d+s,-.8,d,.7),r.colorArray.emplaceBack(d+s,-.8,d,.7),r.colorArray.emplaceBack(0,0,d,1.3),r.colorArray.emplaceBack(0,0,d,1.3),r.colorArray.emplaceBack(d+s,-1.2,d,.8),r.colorArray.emplaceBack(d+s,-1.2,d,.8),r.indexArray.emplaceBack(6+n,4+n,8+n),r.indexArray.emplaceBack(7+n,9+n,5+n),r.indexArray.emplaceBack(0+n,1+n,2+n),r.indexArray.emplaceBack(1+n,3+n,2+n),n+=10;}const i={defined:!0,emissiveFactor:[0,0,0]},a={};return a.baseColorFactor=Ie.white,i.pbrMetallicRoughness=a,r.material=i,r.aabb=new xu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),r}class lv{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}const uv=["id","tile","layer","source","sourceLayer","state"];class cv{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t.properties,this.id=i;}clone(){const t=new cv(this._vectorTileFeature,this._z,this._x,this._y,this.id);return this.state&&(t.state=Object.assign({},this.state)),this.layer&&(t.layer=Object.assign({},this.layer)),this.source&&(t.source=this.source),this.sourceLayer&&(t.sourceLayer=this.sourceLayer),t}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};for(const e of uv)void 0!==this[e]&&(t[e]=this[e]);return t}}class hv{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new aa(Wr,16,0),this.featureIndexArray=new so,this.promoteId=e,this.is3DTile=!1,this.serializedLayersCache=new Map;}insert(t,e,r,n,i,a=0,s=0){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,a);const l=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}0!==s&&(n[0]-=s,n[1]-=s,n[2]+=s,n[3]+=s),n[0]<Wr&&n[1]<Wr&&n[2]>=0&&n[3]>=0&&l.insert(o,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new fh.VectorTile(new pf(this.rawTileData)).layers,this.sourceLayerCoder=new lv(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e){const{tilespaceGeometry:r,transform:n,tileTransform:i,pixelPosMatrix:a,availableImages:s}=e;this.loadVTLayers(),this.serializedLayersCache.clear();const o=r.bufferedTilespaceBounds,l=this.grid.query(o.min.x,o.min.y,o.max.x,o.max.y,((t,e,n,i)=>ql(r.bufferedTilespaceGeometry,t,e,n,i)));l.sort(fv);let u=null;n.elevation&&l.length>0&&(u=uy.create(n.elevation,this.tileID));const c={};let h;for(let e=0;e<l.length;e++){const o=l[e];if(o===h)continue;h=o;const p=this.featureIndexArray.get(o);let f=null;this.is3DTile?this.loadMatchingModelFeature(c,p,t,r,n):this.loadMatchingFeature(c,p,t,s,((t,e,s,o=0)=>(f||(f=zl(t,this.tileID.canonical,i)),e.queryIntersectsFeature(r,t,s,f,this.z,n,a,u,o))));}return c}loadMatchingFeature(t,e,r,n,i){const{featureIndex:a,bucketIndex:s,sourceLayerIndex:o,layoutVertexArrayOffset:l}=e,u=this.bucketLayerIDs[s],c=r.layers,h=Object.keys(c);if(h.length&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(h,u))return;const p=r.sourceCache,f=this.sourceLayerCoder.decode(o),d=this.vtLayers[f].feature(a),m=this.getId(d,f);for(let e=0;e<u.length;e++){const r=u[e];if(!c[r])continue;const{styleLayer:s,targets:o}=c[r];let h={};void 0!==m&&(h=p.getFeatureState(s.sourceLayer,m));const f=!i||i(d,s,h,l);if(!f)continue;const y=new cv(d,this.z,this.x,this.y,m);y.tile=this.tileID.canonical,y.state=h;let g=this.serializedLayersCache.get(r);g||(g=s.serialize(),g.id=r,this.serializedLayersCache.set(r,g)),y.source=g.source,y.sourceLayer=g["source-layer"],y.layer=nt({},g),y.layer.paint=pv(g.paint,s.paint,d,h,n),y.layer.layout=pv(g.layout,s.layout,d,h,n);let x=!1;for(const t of o){this.updateFeatureProperties(y,t);const{filter:e}=t;if(e)if(d.properties=y.properties,e.needGeometry){const t=El(d,!0);if(!e.filter(new Ca(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!e.filter(new Ca(this.tileID.overscaledZ),d))continue;x=!0,t.targetId&&this.addFeatureVariant(y,t);}x&&this.appendToResult(t,r,a,y,f);}}loadMatchingModelFeature(t,e,r,n,i){const a=this.bucketLayerIDs[0][0],s=r.layers;if(!s[a])return;const{styleLayer:o,targets:l}=s[a];if("model"!==o.type)return;const u=n.tile,c=e.featureIndex,h=u.getBucket(o);if(!(h&&h instanceof yy))return;const p=function(t,e,r,n){const i=t.getNodesInfo()[e];if(i.hiddenByReplacement||!i.node.meshes)return;let a=Number.MAX_VALUE;const s=i.node,o=r.tile,l=n.calculatePosMatrix(o.tileID.toUnwrapped(),n.worldSize),u=i.evaluatedScale;let c=0;n.elevation&&s.elevation&&(c=s.elevation*n.elevation.exaggeration()),O.mat4.translate(l,l,[(s.anchor?s.anchor[0]:0)*(u[0]-1),(s.anchor?s.anchor[1]:0)*(u[1]-1),c]),O.mat4.scale(l,l,u);const h=r.queryGeometry,p=h.isPointQuery()?h.screenBounds:h.screenGeometry,f=function(t){const e=O.mat4.multiply([],l,t.matrix);O.mat4.multiply(e,n.expandedFarZProjMatrix,e);for(let r=0;r<t.meshes.length;++r){const i=t.meshes[r];if(r===t.lightMeshIndex)continue;const s=Om(p,n,e,i.aabb);null!=s&&(a=Math.min(s,a));}if(t.children)for(const e of t.children)f(e);};if(f(s),a===Number.MAX_VALUE)return;const d=new il(0,0);return by(o.tileID.canonical,d,i.node.anchor[0],i.node.anchor[1]),{intersectionZ:a,position:d,feature:i.feature}}(h,c,n,i);if(!p)return;const{z:f,x:d,y:m}=u.tileID.canonical,{feature:y,intersectionZ:g,position:x}=p;let v={};void 0!==y.id&&(v=r.sourceCache.getFeatureState(o.sourceLayer,y.id));const b=new cv({},f,d,m,y.id);b.tile=this.tileID.canonical,b.state=v,b.properties=y.properties,b.geometry={type:"Point",coordinates:[x.lng,x.lat]};let _=this.serializedLayersCache.get(a);_||(_=o.serialize(),_.id=a,this.serializedLayersCache.set(a,_)),b.source=_.source,b.sourceLayer=_["source-layer"],b.layer=nt({},_);let w=!1;for(const t of l){this.updateFeatureProperties(b,t);const{filter:e}=t;if(e)if(y.properties=b.properties,e.needGeometry){if(!e.filter(new Ca(this.tileID.overscaledZ),y,this.tileID.canonical))continue}else if(!e.filter(new Ca(this.tileID.overscaledZ),y))continue;w=!0,t.targetId&&this.addFeatureVariant(b,t);}w&&this.appendToResult(t,a,c,b,g);}updateFeatureProperties(t,e,r){if(e.properties){const n={};for(const i in e.properties){const a=e.properties[i].evaluate({zoom:this.z},t._vectorTileFeature,t.state,t.tile,r);null!=a&&(n[i]=a);}t.properties=n;}}addFeatureVariant(t,e,r){const n={target:e.target,namespace:e.namespace,uniqueFeatureID:e.uniqueFeatureID};e.properties&&(n.properties=t.properties),t.variants=t.variants||{},t.variants[e.targetId]=t.variants[e.targetId]||[],t.variants[e.targetId].push(n);}appendToResult(t,e,r,n,i){let a=t[e];void 0===a&&(a=t[e]=[]),a.push({featureIndex:r,feature:n,intersectionZ:i});}lookupSymbolFeatures(t,e,r,n,i){const a={};this.loadVTLayers();for(const s of t)this.loadMatchingFeature(a,{bucketIndex:e,sourceLayerIndex:r,featureIndex:s,layoutVertexArrayOffset:0},n,i);return a}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const a=this.vtLayers[n].feature(e);return i[e]=a,a}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n=Array.isArray(this.promoteId)||"object"!=typeof this.promoteId?this.promoteId:this.promoteId[e];if(null!=n)if(Array.isArray(n)){if(!this.promoteIdExpression){const t=Wi(n);if("success"!==t.result){const e=t.value.map((t=>`${t.key}: ${t.message}`)).join(", ");return void ft(`Failed to create expression for promoteId: ${e}`)}this.promoteIdExpression=t.value;}this.promoteIdExpression._evaluator||(this.promoteIdExpression._evaluator=new mr),r=this.promoteIdExpression.evaluate({zoom:0},t);}else r=t.properties[n];"boolean"==typeof r&&(r=Number(r));}return r}}function pv(t,e,r,n,i){return ut(t,((t,a)=>{const s=e instanceof Ua?e.get(a):null;return s&&s.evaluate?s.evaluate(r,n,i):s}))}function fv(t,e){return e-t}oa(hv,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});const dv=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class mv{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=dv[15&r];if(!i)throw new Error("Unrecognized array type.");const[a]=new Uint16Array(t,2,1),[s]=new Uint32Array(t,4,1);return new mv(s,a,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=dv.indexOf(this.ArrayType),a=2*t*this.ArrayType.BYTES_PER_ELEMENT,s=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-s%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+s+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+a+s+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+s+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return yv(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:a,nodeSize:s}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let s=h;s<=c;s++){const o=a[2*s],u=a[2*s+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[s]);}continue}const p=h+c>>1,f=a[2*p],d=a[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:a}=this,s=[0,n.length-1,0],o=[],l=r*r;for(;s.length;){const u=s.pop()||0,c=s.pop()||0,h=s.pop()||0;if(c-h<=a){for(let r=h;r<=c;r++)bv(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];bv(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(s.push(h),s.push(p-1),s.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(s.push(p+1),s.push(c),s.push(1-u));}return o}}function yv(t,e,r,n,i,a){if(i-n<=r)return;const s=n+i>>1;gv(t,e,s,n,i,a),yv(t,e,r,n,s-1,1-a),yv(t,e,r,s+1,i,1-a);}function gv(t,e,r,n,i,a){for(;i>n;){if(i-n>600){const s=i-n+1,o=r-n+1,l=Math.log(s),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(s-u)/s)*(o-s/2<0?-1:1);gv(t,e,r,Math.max(n,Math.floor(r-o*u/s+c)),Math.min(i,Math.floor(r+(s-o)*u/s+c)),a);}const s=e[2*r+a];let o=n,l=i;for(xv(t,e,n,r),e[2*i+a]>s&&xv(t,e,n,i);o<l;){for(xv(t,e,o,l),o++,l--;e[2*o+a]<s;)o++;for(;e[2*l+a]>s;)l--;}e[2*n+a]===s?xv(t,e,n,l):(l++,xv(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function xv(t,e,r,n){vv(t,r,n),vv(e,2*r,2*n),vv(e,2*r+1,2*n+1);}function vv(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function bv(t,e,r,n){const i=t-r,a=e-n;return i*i+a*a}t.$=Ha,t.A=tr,t.B=2,t.C=$f,t.D=zy,t.E=we,t.F=jf,t.G=class extends Zm{},t.H=hr,t.I=Ag,t.J=Te,t.K=Xa,t.L=Oi,t.M=Li,t.N=Fi,t.O=Hi,t.P=q,t.Q=Za,t.R=te,t.S=Qi,t.T=dm,t.U=Wi,t.V=Zm,t.W=Bn,t.X=Vn,t.Y=Tn,t.Z=yr,t._=Se,t.a=function(t){return St.API_CDN_URL_REGEX.test(t)},t.a$=cv,t.a0=Ni,t.a1=Ri,t.a2=function(t){const e=t.value;let r=[];if(!e)return r;const n=hr(e);return "string"!==n?(r=r.concat([new Zm(t.key,e,`string expected, "${n}" found`)]),r):(Hm(e,!0)||(r=r.concat([new Zm(t.key,e,`invalid url "${e}"`)])),r)},t.a3=Ya,t.a4=La,t.a5=Ga,t.a6=ja,t.a7=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return yt(t.expression.evaluate(e))}interpolate(t,e,r){return {x:ze(t.x,e.x,r),y:ze(t.y,e.y,r),z:ze(t.z,e.z,r),azimuthal:ze(t.azimuthal,e.azimuthal,r),polar:ze(t.polar,e.polar,r)}}},t.a8=Ca,t.a9=Ji,t.aA=cl,t.aB=class{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}},t.aC=us,t.aD=function(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=ie(t.request,((t,n,i,a)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new fh.VectorTile(new pf(n)),rawData:n,cacheControl:i,expires:a});}));return ()=>{n.cancel(),e();}}),e)},t.aE=function(t){Yt++,Yt>Nt&&(t.getActor().send("enforceCacheSizeLimit",Ot),Yt=0);},t.aF=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.aG=iu,t.aH=_m,t.aI=Pm,t.aJ=vm,t.aK=function(t,e){const r=document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=document.createElement("source");ae(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.aL=mm,t.aM=function(t){return fetch(t).then((t=>t.arrayBuffer())).then((e=>Kx(e,0,t)))},t.aN=av,t.aO=class{constructor(t,e,r,n){this.id=t,this.position=null!=e?new il(e[0],e[1]):new il(0,0),this.orientation=null!=r?r:[0,0,0],this.nodes=n,this.uploaded=!1,this.aabb=new xu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[];}_applyTransformations(t,e){if(O.mat4.multiply(t.matrix,e,t.matrix),t.meshes)for(const e of t.meshes){const r=xu.applyTransformFast(e.aabb,t.matrix);this.aabb.encapsulate(r);}if(t.children)for(const e of t.children)this._applyTransformations(e,t.matrix);}computeBoundsAndApplyParent(){const t=O.mat4.identity([]);for(const e of this.nodes)this._applyTransformations(e,t);}computeModelMatrix(t,e,r,n,i,a,s=!1){ny(this.matrix,this,t.transform,this.position,e,r,n,i,a,s);}upload(t){if(!this.uploaded){for(const e of this.nodes)sy(e,t);for(const t of this.nodes)oy(t);this.uploaded=!0;}}destroy(){for(const t of this.nodes)ly(t);}},t.aP=ot,t.aQ=wd,t.aR=pl,t.aS=fl,t.aT=bs,t.aU=Ls,t.aV=at,t.aW=Js,t.aX=tm,t.aY=function(){Ba.isLoading()||Ba.isLoaded()||"deferred"!==ka()||Ta();},t.aZ=Wa,t.a_=El,t.aa=bl,t.ab=O,t.ac=tt,t.ad=Ua,t.ae=Fu,t.af=ze,t.ag=Wr,t.ah=Ee,t.ai=X,t.aj=Ie,t.ak=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return function([t,e]){const r=yt([1,t,e]);return {x:r.x,y:r.y,z:r.z}}(t.expression.evaluate(e))}interpolate(t,e,r){return {x:ze(t.x,e.x,r),y:ze(t.y,e.y,r),z:ze(t.z,e.z,r)}}},t.al=function(t,e,r=0,n=!0){const i=new q(r,r),a=t.sub(i),s=e.add(i),o=[a,new q(s.x,a.y),s,new q(a.x,s.y)];return n&&o.push(a.clone()),o},t.am=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=et(n-1,-1,t.length-1),a=et(n+1,-1,t.length-1),s=t[n],o=t[a],l=t[i].sub(s).unit(),u=o.sub(s).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(s.add(h));}return r},t.an=Md,t.ao=ql,t.ap=function(t,e,r=0){return O.vec3.fromValues(((e.x-r)*t.scale-t.x)*Wr,(e.y*t.scale-t.y)*Wr,dl(e.z,e.y))},t.aq=hu,t.ar=zp,t.as=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const a of t)e=Math.min(e,a.x),r=Math.min(r,a.y),n=Math.max(n,a.x),i=Math.max(i,a.y);return {min:new q(e,r),max:new q(n,i)}},t.at=ul,t.au=jl,t.av=wl,t.aw=Q,t.ax=Yo,t.ay=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.az=al,t.b=function(t){return St.API_FONTS_REGEX.test(t)},t.b$=Bm,t.b0=xt,t.b1=Ap,t.b2=Uc,t.b3=zl,t.b4=xs,t.b5=Ys,t.b6=cu,t.b7=po,t.b8=hc,t.b9=hm,t.bA=kh,t.bB=pd,t.bC=hd,t.bD=Ef,t.bE=mv,t.bF=et,t.bG=bt,t.bH=hl,t.bI=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.bJ=Eo,t.bK=Ao,t.bL=So,t.bM=Mo,t.bN=wo,t.bO=il,t.bP=$d,t.bQ=nu,t.bR=gu,t.bS=Tm,t.bT=ru,t.bU=Pu,t.bV=function(t,e,r,n,i,a,s,o,l){if("globe"===l.name)return Pu(t,e,new ru(r,n,i),!1);const u=wd({z:r,x:n,y:i},l);return new xu([(a+u.x/u.scale)*e,e*(u.y/u.scale),s],[(a+u.x2/u.scale)*e,e*(u.y2/u.scale),o])},t.bW=function(t,e,r){let n=0;for(let r=0;r<2;++r){const i=0;t[r]>i&&(n+=(t[r]-i)*(t[r]-i)),e[r]<i&&(n+=(i-e[r])*(i-e[r]));}return n},t.bX=ml,t.bY=Zo,t.bZ=function(t){const e=O.mat4.identity(new Float64Array(16));O.mat4.multiply(e,t.pixelMatrix,t.globeMatrix);const r=[0,Jo,0],n=[0,Qo,0];return O.vec3.transformMat4(r,r,e),O.vec3.transformMat4(n,n,e),[r[0]>0&&r[0]<=t.width&&r[1]>0&&r[1]<=t.height&&!Nu(t,new il(t.center.lat,90)),n[0]>0&&n[0]<=t.width&&n[1]>0&&n[1]<=t.height&&!Nu(t,new il(t.center.lat,-90))]},t.b_=function(t,e){const{scale:r}=t.tileTransform,n=r*Wr/(t.tileSize*Math.pow(2,e.zoom-t.tileID.overscaledZ+t.tileID.canonical.z));return O.mat2.scale(new Float32Array(4),e.inverseAdjustmentMatrix,[n,n])},t.ba=function(t,e){const r=Fu(e.zoom);if(0===r)return Au(t);const n=zu(t),i=Eu(n),a=ul(n.getWest())*e.worldSize,s=ul(n.getEast())*e.worldSize,o=cl(n.getNorth())*e.worldSize,l=cl(n.getSouth())*e.worldSize,u=[a,o,0],c=[s,o,0],h=[a,l,0],p=[s,l,0],f=O.mat4.invert([],e.globeMatrix);return O.vec3.transformMat4(u,u,f),O.vec3.transformMat4(c,c,f),O.vec3.transformMat4(h,h,f),O.vec3.transformMat4(p,p,f),i[0]=Su(i[0],h,r),i[1]=Su(i[1],p,r),i[2]=Su(i[2],c,r),i[3]=Su(i[3],u,r),xu.fromPoints(i)},t.bb=Cu,t.bc=ku,t.bd=Su,t.be=vs,t.bf=uu,t.bg=Ix,t.bh=pf,t.bi=ie,t.bj=function(t){const e=[];for(const r in t)e.push(t[r]);return e},t.bk=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.bl=rt,t.bm=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.bn=$,t.bo=function(t,e){const{x:r,y:n}=t.point,i=Ru(r,n,t.worldSize/t._pixelsPerMercatorPixel,0,0);return O.mat4.multiply(i,i,Vu(Au(e)))},t.bp=Qp,t.bq=xf,t.br=Jp,t.bs=function(t,e,r,n,i){const a=5*e+2;t.float32[a+0]=r,t.float32[a+1]=n,t.float32[a+2]=i;},t.bt=Wd,t.bu=Uf,t.bv=Cl,t.bw=Zp,t.bx=bh,t.by=Xm,t.bz=Eh,t.c=Pt,t.c$=(t,e,r,n,i,a,s,o)=>{const l=t.transform,u=l.pitch<15?Ep(.07,.7,Q((14-l.zoom)/5,0,1)):.07,c="none"===r.paint.get("line-trim-color-use-theme").constantOr("default");return {u_matrix:Tp(t,e,r,n),u_texsize:e.imageAtlasTexture?e.imageAtlasTexture.size:[0,0],u_pixels_to_tile_units:l.calculatePixelsToTileUnitsMatrix(e),u_device_pixel_ratio:i,u_width_scale:a,u_floor_width_scale:s,u_image:0,u_tile_units_to_pixels:kp(e,l),u_units_to_pixels:[1/l.pixelsToGLUnits[0],1/l.pixelsToGLUnits[1]],u_alpha_discard_threshold:0,u_trim_offset:o,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toRenderColor(c?null:r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength"),u_zbias_factor:u,u_tile_to_meter:vl(e.tileID.canonical,0)}},t.c0=km,t.c1=function(t){const e=km(t,!0);return O.mat2.invert([],[e[0],e[1],e[4],e[5]])},t.c2=pu,t.c3=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return Ru(e,r,t.worldSize,n,i)},t.c4=Z,t.c5=au,t.c6=Xo,t.c7=function(t){const e=Math.round((t+45+360)%360/90)%4;return H[e]},t.c8=45,t.c9=ll,t.cA=class extends _o{constructor(t){super(t),this.current=ko;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.cB=W,t.cC=function(t,e,r){const n=Fu(r.zoom),i=t.style.map._antialias,a=t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!a},t.cD=function(t){const e=t.pixelsPerMeter,r=e/hl(1,t.center.lat),n=O.mat4.identity(new Float64Array(16));return O.mat4.translate(n,n,[t.point.x,t.point.y,0]),O.mat4.scale(n,n,[r,r,e]),Float32Array.from(n)},t.cE=zu,t.cF=function(t){const e=ml-5;t=Q(t,-e,e)/e*90;const r=Math.pow(Math.abs(Math.sin(X(t))),3);return Math.round(r*(Ko.length-1))},t.cG=function(t,e,r,n){const i=e.getNorth(),a=e.getSouth(),s=e.getWest(),o=e.getEast(),l=1<<t.z,u=o-s,c=i-a,h=u/Wo,p=-c/Ko[r],f=[0,h,0,p,0,0,i,s,0];if(t.z>0){const t=180/n;O.mat3.multiply(f,f,[t/u+1,0,0,0,t/c+1,0,-.5*t/h,.5*t/p,1]);}return f[2]=l,f[5]=t.x,f[8]=t.y,f},t.cH=Au,t.cI=function(t,e,r){const n=O.mat4.identity(new Float64Array(16)),i=(e/(1<<t)-.5)*Math.PI*2;return O.mat4.rotateY(n,r.globeMatrix,i),Float32Array.from(n)},t.cJ=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),a=Math.floor((t.x-i)*n),s=Math.floor(t.y*n),o=this.findDEMTileFor(new iu(r,i,r,a,s));return !(!o||!o.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,a=1<<i,s=Math.floor(t.x),o=t.x-s,l=new iu(i,s,i,Math.floor(o*a),Math.floor(t.y*a)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(o*h-u.tileID.canonical.x)*c.dim,f=(t.y*h-u.tileID.canonical.y)*c.dim,d=Math.floor(p),m=Math.floor(f);return (r?this.exaggeration():1)*ze(ze(c.get(d,m),c.get(d,m+1),f-m),ze(c.get(d+1,m),c.get(d+1,m+1),f-m),p-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new bl(t.wrap+(t.canonical.x+e/Wr)/n,(t.canonical.y+r/Wr)/n))}getAtTileOffsetFunc(t,e,r,n){return i=>{const a=this.getAtTileOffset(t,i.x,i.y),s=n.upVector(t.canonical,i.x,i.y),o=n.upVectorScale(t.canonical,e,r).metersToTile;return O.vec3.scale(s,s,a*o),s}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=uy.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let a=t.canonical.x/i-n.canonical.x,s=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){a*=2,s*=2;const t=2*Math.floor(s)+Math.floor(a);o=r.childOffsets[o]+t,a%=1,s%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}getMinMaxForVisibleTiles(){const t=this.visibleDemTiles;if(0===t.length)return null;let e=!1,r=Number.MAX_VALUE,n=Number.MIN_VALUE;for(const i of t){const t=this.getMinMaxForTile(i.tileID);t&&(r=Math.min(r,t.min),n=Math.max(n,t.max),e=!0);}return e?{min:r,max:n}:null}},t.cK=oc,t.cL=vu,t.cM=function(t,e){return [Math.pow(t[0],2.2)*e,Math.pow(t[1],2.2)*e,Math.pow(t[2],2.2)*e]},t.cN=Lu,t.cO=At,t.cP=Mt,t.cQ=256,t.cR=function(t,e){const r=[0,0,0],n=Cu(Au(e.canonical));return O.vec3.transformMat4(r,r,n),O.vec3.transformMat4(r,r,t),r},t.cS=t=>({u_camera_to_center_distance:new Mo(t),u_extrude_scale:new Bo(t),u_device_pixel_ratio:new Mo(t),u_matrix:new Eo(t),u_inv_rot_matrix:new Eo(t),u_merc_center:new Ao(t),u_tile_id:new So(t),u_zoom_transition:new Mo(t),u_up_dir:new So(t),u_emissive_strength:new Mo(t)}),t.cT=t=>({u_matrix:new Eo(t),u_pixels_to_tile_units:new Bo(t),u_device_pixel_ratio:new Mo(t),u_width_scale:new Mo(t),u_floor_width_scale:new Mo(t),u_units_to_pixels:new Ao(t),u_dash_image:new wo(t),u_gradient_image:new wo(t),u_image_height:new Mo(t),u_texsize:new Ao(t),u_tile_units_to_pixels:new Mo(t),u_alpha_discard_threshold:new Mo(t),u_trim_offset:new Ao(t),u_trim_fade_range:new Ao(t),u_trim_color:new Io(t),u_emissive_strength:new Mo(t),u_zbias_factor:new Mo(t),u_tile_to_meter:new Mo(t)}),t.cU=t=>({u_matrix:new Eo(t),u_texsize:new Ao(t),u_pixels_to_tile_units:new Bo(t),u_device_pixel_ratio:new Mo(t),u_width_scale:new Mo(t),u_floor_width_scale:new Mo(t),u_image:new wo(t),u_units_to_pixels:new Ao(t),u_tile_units_to_pixels:new Mo(t),u_alpha_discard_threshold:new Mo(t),u_trim_offset:new Ao(t),u_trim_fade_range:new Ao(t),u_trim_color:new Io(t),u_emissive_strength:new Mo(t),u_zbias_factor:new Mo(t),u_tile_to_meter:new Mo(t)}),t.cV=Vs,t.cW=Xp,t.cX=tf,t.cY=Gu,t.cZ=(t,e,r,n,i,a)=>{const s=t.transform,o="globe"===s.projection.name;let l;if("map"===a.paint.get("circle-pitch-alignment"))if(o){const t=Lu(s.zoom,e.canonical)*s._pixelsPerMercatorPixel;l=Float32Array.from([t,0,0,t]);}else l=s.calculatePixelsToTileUnitsMatrix(r);else l=new Float32Array([s.pixelsToGLUnits[0],0,0,s.pixelsToGLUnits[1]]);const u={u_camera_to_center_distance:t.transform.getCameraToCenterDistance(s.projection),u_matrix:t.translatePosMatrix(e.projMatrix,r,a.paint.get("circle-translate"),a.paint.get("circle-translate-anchor")),u_device_pixel_ratio:Dt.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:$u,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:a.paint.get("circle-emissive-strength")};if(o){u.u_inv_rot_matrix=n,u.u_merc_center=i,u.u_tile_id=[e.canonical.x,e.canonical.y,1<<e.canonical.z],u.u_zoom_transition=Fu(s.zoom);const t=i[0]*Wr,r=i[1]*Wr;u.u_up_dir=s.projection.upVector(new ru(0,0,0),t,r);}return u},t.c_=Bp,t.ca=Io,t.cb=function(t,e,r){const n=Math.sqrt(t*t+e*e+r*r),i=n>0?Math.acos(r/n)*Y:0;let a=0!==t||0!==e?Math.atan2(-e,-t)*Y+90:0;return a<0&&(a+=360),[n,a,i]},t.cc=vl,t.cd=xu,t.ce=yt,t.cf=function(t){return [Math.pow(t[0],1/2.2),Math.pow(t[1],1/2.2),Math.pow(t[2],1/2.2)]},t.cg=function(t,e){return t.readFields(Oy,{icons:[]},e)},t.ch=function(t){return t({pluginStatus:Sa,pluginURL:Ia}),Ea.on("pluginStateChange",t),t},t.ci=Ty,t.cj=Kf,t.ck=Wf,t.cl=re,t.cm=Pa,t.cn=Rt,t.co=ge,t.cp=ht,t.cq=function(t){const e=t.indexOf(ls);return e>=0?t.slice(0,e):t},t.cr=function(t){return t.indexOf(ls)>=0},t.cs=function(t){const e=t.indexOf(ls);return e>=0?t.slice(e+1):""},t.ct=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.cu=function(t,e,r,n){return "custom"===t.type?new zm(t,e):new _y[t.type](t,e,r,n)},t.cv=ct,t.cw=class extends cv{constructor(t,e){super(t._vectorTileFeature,t._z,t._x,t._y,t.id),t.state&&(this.state=Object.assign({},t.state)),this.target=e.target,this.namespace=e.namespace,e.properties&&(this.properties=e.properties),this.target&&("featuresetId"in this.target&&!this.target.importId||"layerId"in this.target)&&(this.source=t.source,this.sourceLayer=t.sourceLayer,this.layer=t.layer);}toJSON(){const t=super.toJSON();return t.target=this.target,t.namespace=this.namespace,t}},t.cx=Ea,t.cy=ne,t.cz=Po,t.d=function(t){return St.API_TILEJSON_REGEX.test(t)},t.d$=hv,t.d0=(t,e,r,n,i,a,s,o,l)=>{const u=t.transform,c=u.calculatePixelsToTileUnitsMatrix(e),h="none"===r.paint.get("line-trim-color-use-theme").constantOr("default"),p=u.pitch<15?Ep(.07,.7,Q((14-u.zoom)/5,0,1)):.07;return {u_matrix:Tp(t,e,r,n),u_pixels_to_tile_units:c,u_device_pixel_ratio:a,u_width_scale:s,u_floor_width_scale:o,u_units_to_pixels:[1/u.pixelsToGLUnits[0],1/u.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:i,u_texsize:Cp(r)&&e.lineAtlasTexture?e.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:kp(e,t.transform),u_alpha_discard_threshold:0,u_trim_offset:l,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toRenderColor(h?null:r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength"),u_zbias_factor:p,u_tile_to_meter:vl(e.tileID.canonical,0)}},t.d1=st,t.d2=lc,t.d3=ap,t.d4=su,t.d5=Kh,t.d6=Oh,t.d7=450,t.d8=7,t.d9=bm,t.dA=J,t.dB=xl,t.dC=el,t.dD=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),a=.5*Math.PI-Math.acos(-e/n);return new il(Z(i),Z(a))},t.dE=Vm,t.dF=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!function(t){if(null==vt){const e=t.navigator?t.navigator.userAgent:null;vt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return vt}(t)&&e&&(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/))},t.dG=function(t,e){Ot=t,Nt=e;},t.dH=Nu,t.dI=Ou,t.dJ=function(t){const e=[0,0,0],r=O.mat4.identity(new Float64Array(16));return O.mat4.multiply(r,t.pixelMatrix,t.globeMatrix),O.vec3.transformMat4(e,e,r),new q(e[0],e[1])},t.dK=function(t,e,r=!1){if(Sa===_a||Sa===wa||Sa===Ma)throw new Error("setRTLTextPlugin cannot be called multiple times.");Ia=Dt.resolveURL(t),Sa=_a,Aa=e,za(),r||Ta();},t.dL=ka,t.dM=function(){Ty().acquire(Iy);},t.dN=function(){const t=Ey;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(Iy),Ey=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.dO=Py,t.dP=function(t){const e=$t();if(!e)return;const r=e.delete(Ft);t&&r.catch(t).then((()=>t()));},t.dQ=Sy,t.dR=Dx,t.dS=function(t){kx=Dt.resolveURL(t),Vx||(Vx=new zy(Ty(),new we)),Vx.broadcast("setDracoUrl",kx);},t.dT=Lx,t.dU=function(t){Bx=Dt.resolveURL(t),Vx||(Vx=new zy(Ty(),new we)),Vx.broadcast("setMeshoptUrl",Bx);},t.dV=oa,t.dW=ac,t.dX=Hf,t.dY=fh,t.dZ=class{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=O.vec2.dot(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,!0}},t.d_=lv,t.da=ys,t.db=Hs,t.dc=256,t.dd=Vu,t.de=Ms,t.df=Ns,t.dg=Us,t.dh=function(t,e,r,n,i){return Q((t-e)/(r-e)*(i-n)+n,n,i)},t.di=Ii,t.dj=gl,t.dk=class{constructor(t,e,r,n){this.context=t,this.format=n,this.size=r,this.texture=t.gl.createTexture();const[i,a,s]=this.size,{gl:o}=t;o.bindTexture(o.TEXTURE_3D,this.texture),t.pixelStoreUnpackFlipY.set(!1),t.pixelStoreUnpack.set(1),t.pixelStoreUnpackPremultiplyAlpha.set(!1),o.texImage3D(o.TEXTURE_3D,0,this.format,i,a,s,0,pm(this.format),fm(this.format),e.data);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_3D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}},t.dl=Fm,t.dm=[1,1,1],t.dn=uy,t.dp=ry,t.dq=Ts,t.dr=$s,t.ds=rl,t.dt=qs,t.du=js,t.dv=class{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[],this._globalClipBounds={min:new q(1/0,1/0),max:new q(-1/0,-1/0)};}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[];}get updateTime(){return this._updateTime}getReplacementRegionsForTile(t,e=!1){const r=Sh(new q(0,0),new q(Wr,Wr),t),n=[];if(e&&!Mh(r,this._globalClipBounds))return n;for(const e of this._activeRegions){if(e.hiddenByOverlap)continue;if(!Mh(r,e))continue;const i=Ih(e.min,e.max,t);n.push({min:i.min,max:i.max,sourceId:this._sourceIds[e.priority],footprint:e.footprint,footprintTileId:e.tileId,order:e.order,clipMask:e.clipMask,clipScope:e.clipScope});}return n}setSources(t){this._setSources(t.map((t=>({getSourceId:()=>t.cache.id,getFootprints:()=>{const e=[];for(const r of t.cache.getVisibleCoordinates()){const n=t.cache.getTile(r).buckets[t.layer];n&&n.updateFootprints(r.toUnwrapped(),e);}return e},getOrder:()=>t.order,getClipMask:()=>t.clipMask,getClipScope:()=>t.clipScope}))));}_addSource(t){const e=t.getFootprints();if(0===e.length)return;const r=t.getOrder(),n=t.getClipMask(),i=t.getClipScope();for(const t of e){if(!t.footprint)continue;const e=Sh(t.footprint.min,t.footprint.max,t.id);this._activeRegions.push({min:e.min,max:e.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:t.id,footprint:t.footprint,order:r,clipMask:n,clipScope:i});}this._sourceIds.push(t.getSourceId());}_computeReplacement(){this._activeRegions.sort(((t,e)=>t.priority-e.priority||_h(t.min,e.min)||_h(t.max,e.max)||t.order-e.order||t.clipMask-e.clipMask||function(t,e){const r=(t,e)=>t+e;return t.length-e.length||t.reduce(r,"").localeCompare(e.reduce(r,""))}(t.clipScope,e.clipScope)));let t=this._activeRegions.length!==this._prevRegions.length;if(!t){let e=0;for(;!t&&e!==this._activeRegions.length;){const r=this._activeRegions[e],n=this._prevRegions[e];t=r.priority!==n.priority||!wh(r,n)||r.order!==n.order||r.clipMask!==n.clipMask||!$(r.clipScope,n.clipScope),++e;}}if(t){++this._updateTime;for(const t of this._activeRegions)t.order!==vh&&(this._globalClipBounds.min.x=Math.min(this._globalClipBounds.min.x,t.min.x),this._globalClipBounds.min.y=Math.min(this._globalClipBounds.min.y,t.min.y),this._globalClipBounds.max.x=Math.max(this._globalClipBounds.max.x,t.max.x),this._globalClipBounds.max.y=Math.max(this._globalClipBounds.max.y,t.max.y));const t=t=>{const e=this._activeRegions;if(t>=e.length)return t;const r=e[t].priority;for(;t<e.length&&e[t].priority===r;)++t;return t};if(this._sourceIds.length>1){let e=0,r=t(e);for(;e!==r;){let n=e;const i=e;for(;n!==r;){const t=this._activeRegions[n];t.hiddenByOverlap=!1;for(let e=0;e<i;e++){const r=this._activeRegions[e];if(!r.hiddenByOverlap&&t.order===vh&&Mh(t,r)&&(t.hiddenByOverlap=zh(t.footprint,t.tileId,r.footprint,r.tileId),t.hiddenByOverlap))break}++n;}e=r,r=t(e);}}}}_setSources(t){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let e=t.length-1;e>=0;e--)this._addSource(t[e]);this._computeReplacement();}},t.dw=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();}_fillGridMeshWithLods(t,e){const r=new xs,n=new Ls,i=[],a=t+1+2,s=e[0]+1,o=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===a-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<a;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<s;++t)for(let e=0;e<a;++e)r.emplaceBack(...l(e,t,(0===e||e===a-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<a;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const s=n.length,l=e[t]+1+2,u=new Ls;for(let r=0;r<l-1;r++){const i=r===l-2,s=i?a*(o-e.length+t-r):a;for(let t=0;t<a-1;t++){const e=r*a+t;0===r||i||0===t||t===a-2?(u.emplaceBack(e+1,e,e+s),u.emplaceBack(e+s,e+s+1,e+1)):(n.emplaceBack(e+1,e,e+s),n.emplaceBack(e+s,e+s+1,e+1));}}const c=po.simpleSegment(0,s,r.length,n.length-s);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=po.simpleSegment(0,s,r.length,n.length-s);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(Wo,Ko);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,cu.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new Ls;for(let t=0;t<=Wo;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new Ns,n=new Ns,i=new Ns,a=new Ns;this._poleSegments=[];for(let t=0,e=0;t<Xo;t++){const s=360/(1<<t);r.emplaceBack(0,-Yo,0,.5,0),n.emplaceBack(0,-Yo,0,.5,1),i.emplaceBack(0,-Yo,0,.5,.5),a.emplaceBack(0,-Yo,0,.5,.5);for(let t=0;t<=Wo;t++){let e=t/Wo,o=0;const l=ze(0,s,e),[u,c,h]=tl(ju,qu,l,Yo);r.emplaceBack(u,c,h,e,o),n.emplaceBack(u,c,h,e,1-o);const p=X(l);e=.5+.5*Math.sin(p),o=.5+.5*Math.cos(p),i.emplaceBack(u,c,h,e,o),a.emplaceBack(u,c,h,e,1-o);}this._poleSegments.push(po.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,lu,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,lu,!1),this._texturedPoleNorthVertexBuffer=t.createVertexBuffer(i,lu,!1),this._texturedPoleSouthVertexBuffer=t.createVertexBuffer(a,lu,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t,e){return [e?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,e?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}},t.dx=vh,t.dy=K,t.dz=function(){return !!document.fullscreenElement||!!document.webkitFullscreenElement},t.e=St,t.e0=bp,t.e1=ut,t.e2=Qe,t.e3=Gf,t.e4=function(t,e,r,n,i,a,s,o,l,u,c=1,h,p){t.createArrays(),t.tilePixelRatio=Wr/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const f=t.layers[0].layout,d=t.layers[0]._unevaluatedLayout._values,m={};m.scaleFactor=c,m.textSizeScaleRange=f.get("text-size-scale-range"),m.iconSizeScaleRange=f.get("icon-size-scale-range");const[y,g]=m.textSizeScaleRange,[x,v]=m.iconSizeScaleRange;if(m.textScaleFactor=Q(m.scaleFactor,y,g),m.iconScaleFactor=Q(m.scaleFactor,x,v),"composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;m.compositeTextSizes=[d["text-size"].possiblyEvaluate(new Ca(e),o),d["text-size"].possiblyEvaluate(new Ca(r),o)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;m.compositeIconSizes=[d["icon-size"].possiblyEvaluate(new Ca(e),o),d["icon-size"].possiblyEvaluate(new Ca(r),o)];}m.layoutTextSize=d["text-size"].possiblyEvaluate(new Ca(l+1),o),m.layoutIconSize=d["icon-size"].possiblyEvaluate(new Ca(l+1),o),m.textMaxSize=d["text-size"].possiblyEvaluate(new Ca(18),o);const b="map"===f.get("text-rotation-alignment")&&"point"!==f.get("symbol-placement"),_=f.get("text-size");let w=!1;for(const e of t.features)if(e.icon&&e.icon.nameSecondary){w=!0;break}for(const a of t.features){const l=f.get("text-font").evaluate(a,{},o).join(","),c=_.evaluate(a,{},o)*m.textScaleFactor,y=m.layoutTextSize.evaluate(a,{},o)*m.textScaleFactor,g=(m.layoutIconSize.evaluate(a,{},o),{horizontal:{},vertical:void 0}),x=a.text;let v,M=[0,0];if(x){const n=x.toString(),s=f.get("text-letter-spacing").evaluate(a,{},o)*Zp,u=f.get("text-line-height").evaluate(a,{},o)*Zp,h=da(n)?s:0,p=f.get("text-anchor").evaluate(a,{},o),d=f.get("text-variable-anchor");if(!d){const t=f.get("text-radial-offset").evaluate(a,{},o);M=t?hd(p,[t*Zp,ud]):f.get("text-offset").evaluate(a,{},o).map((t=>t*Zp));}let m=b?"center":f.get("text-justify").evaluate(a,{},o);const v="point"===f.get("symbol-placement"),_=v?f.get("text-max-width").evaluate(a,{},o)*Zp:1/0,w=a=>{t.allowVerticalPlacement&&fa(n)&&(g.vertical=_f(x,e,r,i,l,_,u,p,a,h,M,xf.vertical,!0,y,c));};if(!b&&d){const t="auto"===m?d.map((t=>pd(t))):[m];let n=!1;for(let a=0;a<t.length;a++){const s=t[a];if(!g.horizontal[s])if(n)g.horizontal[s]=g.horizontal[0];else {const t=_f(x,e,r,i,l,_,u,"center",s,h,M,xf.horizontal,!1,y,c);t&&(g.horizontal[s]=t,n=1===t.positionedLines.length);}}w("left");}else {if("auto"===m&&(m=pd(p)),v||f.get("text-writing-mode").indexOf("horizontal")>=0||!fa(n)){const t=_f(x,e,r,i,l,_,u,p,m,h,M,xf.horizontal,!1,y,c);t&&(g.horizontal[m]=t);}w(v?"left":m);}}let A=!1;if(a.icon&&a.icon.namePrimary){const e=Wp(t.iconSizeData,d["icon-size"],o,t.zoom,a)*m.iconScaleFactor*h,r=a.icon.getPrimary().scaleSelf(e).serialize(),s=n[r];s&&(v=Tf(i[r],a.icon.nameSecondary?i[a.icon.getSecondary().scaleSelf(e).serialize()]:void 0,f.get("icon-offset").evaluate(a,{},o),f.get("icon-anchor").evaluate(a,{},o)),A=s.sdf,void 0===t.sdfIcons?t.sdfIcons=s.sdf:t.sdfIcons!==s.sdf&&ft("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(s.pixelRatio!==t.pixelRatio||0!==f.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const S=gd(g.horizontal)||g.vertical;t.iconsInText||(t.iconsInText=!!S&&S.iconsInText),(S||v)&&fd(t,a,g,v,n,m,y,0,M,A,s,o,u,p,w);}a&&t.generateCollisionDebugBuffers(l,t.collisionBoxArray,m.textScaleFactor);},t.e5=Lg,t.e6=j,t.e7=ph,t.e8=hf,t.e9=e,t.ea=function(t){let e=0;if(new Uint32Array(t,0,1)[0]!==Gx){const r=new Uint32Array(t,0,7),[,,n,i,a,s]=r;e=r.byteLength+i+a+s+a,(n!==t.byteLength||e>=t.byteLength)&&ft("Invalid b3dm header information.");}return Kx(t,e)},t.eb=function(t,e){const r=av(t);for(const t of r){for(const e of t.meshes)sv(e);t.lights&&(t.lightMeshIndex=t.meshes.length,t.meshes.push(ov(t.lights,e)));}return r},t.ec=yy,t.ed=Ay,t.ee=Ba,t.ef=function(t){Gt(),null!=jt&&jt.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.f=function(t){return 0===t.indexOf("mapbox:")},t.g=function(t,e){return ne(nt(t,{method:"GET"}),e)},t.h=It,t.i=function(t){return St.API_STYLE_REGEX.test(t)&&!Pt(t)},t.j=function(t){return decodeURIComponent(atob(t).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join(""))},t.k=function(t){return btoa(encodeURIComponent(t).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e)))))},t.l=nt,t.m=Xt,t.n=function(t,e){return ne(nt(t,{type:"json"}),e)},t.o=ue,t.p=function(t,e){return ne(nt(t,{method:"POST"}),e)},t.q=Dt,t.r=sc,t.s=function(t){try{const e=self[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}},t.t=Vt,t.u=function(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()},t.v=function(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)},t.w=ft,t.x=function(){return ky||(ky=new Py),ky},t.y=ve,t.z=xe;}));

define(["./shared"],(function(e){function t(e){const t=e?e.url.toString():void 0;return t?performance.getEntriesByName(t):[]}function s(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const i of e)t+=`${s(i)},`;return `${t}]`}let t="{";for(const i of Object.keys(e).sort())t+=`${i}:${s(e[i])},`;return `${t}}`}function i(t){let i="";for(const o of e.bm)("model"!==t.type||"minzoom"!==o&&"maxzoom"!==o)&&(i+=`/${s(t[o])}`);return i}class o{constructor(e){this.keyCache={},this._layers={},this._layerConfigs={},e&&this.replace(e);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,o,r){this._options=r;for(const s of t)this._layerConfigs[s.id]=s,(this._layers[s.id]=e.cu(s,this.scope,null,this._options)).compileFilter(r),this.keyCache[s.id]&&delete this.keyCache[s.id];for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const n=function(e,t){const o={};for(let r=0;r<e.length;r++){const n=e[r];let a=t&&t[n.id];!a&&(a=i(n),"line"===n.type&&n.paint)&&function e(t){return "string"==typeof t&&"line-progress"===t||(Array.isArray(t)?t.some(e):!(!t||"object"!=typeof t)&&Object.values(t).some(e))}(n.paint["line-width"])&&(a+=`/${s(n.paint["line-width"])}`),t&&(t[n.id]=a);let l=o[a];l||(l=o[a]=[]),l.push(n);}const r=[];for(const e in o)r.push(o[e]);return r}(e.bj(this._layerConfigs),this.keyCache);for(const e of n){const t=e.map((e=>this._layers[e.id])),s=t[0];if("none"===s.visibility)continue;const i=s.source||"";let o=this.familiesBySource[i];o||(o=this.familiesBySource[i]={});const r=s.sourceLayer||"_geojsonTileLayer";let n=o[r];n||(n=o[r]=[]),n.push(t);}}}const r=1*e.dX;class n{constructor(t){const s={},i=[];for(const e in t){const o=t[e],n=s[e]={};for(const e in o.glyphs){const t=o.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const s=t.metrics.localGlyph?r:1,a={x:0,y:0,w:t.bitmap.width+2*s,h:t.bitmap.height+2*s};i.push(a),n[e]=a;}}const{w:o,h:n}=e.F(i),a=new e.dW({width:o||1,height:n||1});for(const i in t){const o=t[i];for(const t in o.glyphs){const n=o.glyphs[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const l=s[i][t],c=n.metrics.localGlyph?r:1;e.dW.copy(n.bitmap,a,{x:0,y:0},{x:l.x+c,y:l.y+c},n.bitmap);}}this.image=a,this.positions=s;}}e.dV(n,"GlyphAtlas");const a="3d_elevation_id",l="hd_road_elevation";class c{constructor(){this._valid=!1;}reset(e){return this.feature=e,this._valid=!0,this._geometry=e.loadGeometry(),0!==this._geometry.length&&0!==this._geometry[0].length||(this._valid=!1),this}geometry(e,t){return this._valid&&e(t(this._geometry)),this}require(e,t,s){return this.get(e,!0,t,s)}optional(e,t,s){return this.get(e,!1,t,s)}success(){return this._valid}get(e,t,s,i){const o=this.feature.properties.hasOwnProperty(e)?+this.feature.properties[e]:void 0;return this._valid&&void 0!==o?s(i?i(o):o):t&&(this._valid=!1),this}}class h{constructor(e,t){this.featureFunc=e,this.vertexFunc=t;}parseFeature(e,t,s){return this.featureFunc(e,t,s)}parseVertex(e,t,s){return this.vertexFunc(e,t,s)}}const u=new h(((e,t,s)=>e.reset(t).require(a,(e=>{s.id=e;})).optional("fixed_height_relative",(e=>{s.constantHeight=e;}),p.decodeRelativeHeight).geometry((e=>{s.bounds=e;}),p.computeBounds).success()),((e,t,s)=>e.reset(t).require(a,(e=>{s.id=e;})).require("elevation_idx",(e=>{s.idx=e;})).require("extent",(e=>{s.extent=e;})).require("height_relative",(e=>{s.height=e;}),p.decodeRelativeHeight).geometry((e=>{s.position=e;}),p.getPoint).success())),d=new h(((e,t,s)=>e.reset(t).require(a,(e=>{s.id=e;})).optional("fixed_height",(e=>{s.constantHeight=e;}),p.decodeMetricHeight).geometry((e=>{s.bounds=e;}),p.computeBounds).success()),((e,t,s)=>e.reset(t).require(a,(e=>{s.id=e;})).require("elevation_idx",(e=>{s.idx=e;})).require("extent",(e=>{s.extent=e;})).require("height",(e=>{s.height=e;}),p.decodeMetricHeight).geometry((e=>{s.position=e;}),p.getPoint).success()));class p{static computeBounds(t){const s=new e.P(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY),i=new e.P(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY);for(const e of t[0])s.x>e.x&&(s.x=e.x),s.y>e.y&&(s.y=e.y),i.x<e.x&&(i.x=e.x),i.y<e.y&&(i.y=e.y);return {min:s,max:i}}static getPoint(t){return e.ab.vec2.fromValues(t[0][0].x,t[0][0].y)}static decodeRelativeHeight(e){return 1e-4*e*5}static decodeMetricHeight(e){return 1e-4*e}static parse(t){const s=[],i=[],o=t.length,r=new c;for(let a=0;a<o;a++){const o=t.feature(a),l=o.properties.hasOwnProperty("version")?String(o.properties.version):void 0,c=(n=l)?"1.0.1"===n?d:void 0:u;if(void 0===c){e.w(`Unknown elevation feature version number ${l||"(unknown)"}`);continue}const h=o.properties.hasOwnProperty("type")?o.properties.type:void 0;if(h)if("Point"===e.dY.VectorTileFeature.types[o.type]&&"curve_point"===h){const e={};c.parseVertex(r,o,e)&&s.push(e);}else if("Polygon"===e.dY.VectorTileFeature.types[o.type]&&"curve_meta"===h){const e={};c.parseFeature(r,o,e)&&i.push(e);}}var n;return {vertices:s,features:i}}}class f{constructor(t,s,i,o,r,n){if(this.vertices=new Array,this.vertexProps=new Array,this.edges=new Array,this.edgeProps=new Array,this.id=t,this.heightRange={min:i,max:i},this.safeArea=s,this.constantHeight=i,null==this.constantHeight&&(null!=this.constantHeight||0!==o.length)){this.vertices=o,this.edges=r,this.edges=this.edges.filter((t=>t.a<this.vertices.length&&t.b<this.vertices.length&&!e.ab.vec2.exactEquals(this.vertices[t.a].position,this.vertices[t.b].position))),this.heightRange={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};for(const t of this.vertices)this.vertexProps.push({dir:e.ab.vec2.fromValues(0,0)}),this.heightRange.min=Math.min(this.heightRange.min,t.height),this.heightRange.max=Math.max(this.heightRange.max,t.height);for(const t of this.edges){const s=this.vertices[t.a].position,i=this.vertices[t.b].position,o=e.ab.vec2.subtract(e.ab.vec2.create(),i,s),r=e.ab.vec2.length(o),n=e.ab.vec2.scale(e.ab.vec2.create(),o,1/r);this.edgeProps.push({vec:o,dir:n,len:r});const a=this.vertexProps[t.a].dir,l=this.vertexProps[t.b].dir;e.ab.vec2.add(a,a,n),e.ab.vec2.add(l,l,n);}for(const t of this.vertexProps)0===t.dir[0]&&0===t.dir[1]||e.ab.vec2.normalize(t.dir,t.dir);this.tessellate(n);}}pointElevation(e){if(null!=this.constantHeight)return this.constantHeight;const t=this.getClosestEdge(e);if(null==t)return 0;const[s,i]=t;return (1-(o=i))*this.vertices[this.edges[s].a].height+o*this.vertices[this.edges[s].b].height;var o;}getClosestEdge(t){if(0===this.edges.length)return;let s=0,i=Number.POSITIVE_INFINITY,o=0;const r=e.ab.vec2.fromValues(t.x,t.y);for(let t=0;t<this.edges.length;t++){const n=this.edges[t],a=this.edgeProps[t].dir,l=new e.dZ(r,this.edgeProps[t].dir),c=this.vertices[n.a].position,h=this.vertices[n.b].position,u=e.ab.vec2.create(),d=e.ab.vec2.create(),p=l.intersectsPlane(c,this.vertexProps[n.a].dir,u),f=l.intersectsPlane(h,this.vertexProps[n.b].dir,d);if(!p||!f)continue;const g=e.ab.vec2.subtract(e.ab.vec2.create(),d,u),m=e.ab.vec2.subtract(e.ab.vec2.create(),r,u),y=e.ab.vec2.dot(g,g),v=y>0?e.ab.vec2.dot(m,g)/y:0,b=e.aw(v,0,1),x=Math.abs((v-b)*this.edgeProps[t].len),w=e.ab.vec2.subtract(e.ab.vec2.create(),r,c),I=x+Math.abs(e.ab.vec2.dot(w,e.ab.vec2.fromValues(a[1],-a[0])));I<i&&(s=t,i=I,o=b);}return [s,o]}tessellate(t){for(let s=this.edges.length-1;s>=0;--s){const i=this.edges[s].a,o=this.edges[s].b,{position:r,height:n,extent:a}=this.vertices[i],{position:l,height:c,extent:h}=this.vertices[o],u=this.vertexProps[i].dir,d=this.vertexProps[o].dir,p=e.ab.vec3.fromValues(r[0]/t,r[1]/t,n),f=e.ab.vec3.fromValues(l[0]/t,l[1]/t,c),g=e.ab.vec3.fromValues(u[1],-u[0],0);e.ab.vec3.scale(g,g,a);const m=e.ab.vec3.fromValues(d[1],-d[0],0);if(e.ab.vec3.scale(m,m,h),this.distSqLines(e.ab.vec3.fromValues(p[0]+.5*g[0],p[1]+.5*g[1],p[2]+.5*g[2]),e.ab.vec3.fromValues(f[0]-.5*m[0],f[1]-.5*m[1],f[2]-.5*m[2]),e.ab.vec3.fromValues(p[0]-.5*g[0],p[1]-.5*g[1],p[2]-.5*g[2]),e.ab.vec3.fromValues(f[0]+.5*m[0],f[1]+.5*m[1],f[2]+.5*m[2]))<=.05*.05)continue;const y=this.vertices.length,v=e.ab.vec2.add(e.ab.vec2.create(),r,l);this.vertices.push({position:e.ab.vec2.scale(v,v,.5),height:.5*(n+c),extent:.5*(a+h)});const b=e.ab.vec2.add(e.ab.vec2.create(),u,d);this.vertexProps.push({dir:e.ab.vec2.normalize(b,b)}),this.edges.splice(s,1),this.edgeProps.splice(s,1),this.edges.push({a:i,b:y}),this.edges.push({a:y,b:o});const x=e.ab.vec2.subtract(e.ab.vec2.create(),this.vertices[y].position,r),w=e.ab.vec2.length(x),I={vec:x,dir:e.ab.vec2.scale(e.ab.vec2.create(),x,1/w),len:w};this.edgeProps.push(I),this.edgeProps.push(I);}}distSqLines(t,s,i,o){const r=e.ab.vec3.subtract(e.ab.vec3.create(),s,t),n=e.ab.vec3.subtract(e.ab.vec3.create(),o,i),a=e.ab.vec3.subtract(e.ab.vec3.create(),t,i),l=e.ab.vec3.dot(r,r),c=e.ab.vec3.dot(r,n),h=e.ab.vec3.dot(r,a),u=e.ab.vec3.dot(n,n),d=e.ab.vec3.dot(n,a),p=l*u-c*c;if(0===p){const s=e.ab.vec3.dot(a,n)/e.ab.vec3.dot(n,n),r=e.ab.vec3.lerp(e.ab.vec3.create(),i,o,s);return e.ab.vec3.squaredDistance(r,t)}const f=(c*d-h*u)/p,g=(l*d-c*h)/p,m=e.ab.vec3.lerp(e.ab.vec3.create(),t,s,f),y=e.ab.vec3.lerp(e.ab.vec3.create(),i,o,g);return e.ab.vec3.squaredDistance(m,y)}}class g{static parseFrom(t,s){const i=p.parse(t);if(!i)return [];let{vertices:o,features:r}=i;const n=1/e.cc(s);r.sort(((e,t)=>e.id-t.id)),o.sort(((e,t)=>e.id-t.id||e.idx-t.idx)),o=o.filter(((e,t,s)=>t===s.findIndex((t=>t.id===e.id&&t.idx===e.idx))));const a=new Array;let l=0;const c=o.length;for(const e of r){if(e.constantHeight){a.push(new f(e.id,e.bounds,e.constantHeight));continue}for(;l!==c&&o[l].id<e.id;)l++;if(l===c||o[l].id!==e.id)continue;const t=new Array,s=new Array,i=l;for(;l!==c&&o[l].id===e.id;){const e=o[l];if(t.push({position:e.position,height:e.height,extent:e.extent}),l!==i&&o[l-1].idx===e.idx-1){const e=l-i;s.push({a:e-1,b:e});}l++;}a.push(new f(e.id,e.bounds,void 0,t,s,n));}return a}}e.dV(f,"ElevationFeature");class m{constructor(t){this.tileID=new e.aG(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.lut=t.lut,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.scope=t.scope,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.request&&t.request.collectResourceTiming,this.promoteId=t.promoteId,this.isSymbolTile=t.isSymbolTile,this.tileTransform=e.aQ(t.tileID.canonical,t.projection),this.projection=t.projection,this.worldview=t.worldview,this.localizableLayerIds=t.localizableLayerIds,this.brightness=t.brightness,this.extraShadowCaster=!!t.extraShadowCaster,this.tessellationStep=t.tessellationStep,this.scaleFactor=t.scaleFactor;}parse(t,s,i,o,r){this.status="parsing",this.data=t,this.collisionBoxArray=new e.aW;const c=new e.d_(Object.keys(t.layers).sort()),h=new e.d$(this.tileID,this.promoteId);h.bucketLayerIDs=[];const u={},d=new e.e0(256,256),p={featureIndex:h,iconDependencies:{},patternDependencies:{},glyphDependencies:{},lineAtlas:d,availableImages:i,brightness:this.brightness,scaleFactor:this.scaleFactor,elevationFeatures:void 0},f=s.familiesBySource[this.source];for(const s in f){const o=t.layers[s];if(!o)continue;let r=!1,n=!1,d=!1;for(const e of f[s])"symbol"===e[0].type?r=!0:n=!0,e[0].is3D()&&"model"!==e[0].type&&(d=!0);if(this.extraShadowCaster&&!d)continue;if(!0===this.isSymbolTile&&!r)continue;if(!1===this.isSymbolTile&&!n)continue;1===o.version&&e.w(`Vector tile source "${this.source}" layer "${s}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const m=c.encode(s),v=[];let b=!1;for(let e=0,t=0;e<o.length;e++){const i=o.feature(e),r=h.getId(i,s);if(this.localizableLayerIds&&this.localizableLayerIds.has(s)){const e=i.properties?i.properties.worldview:null;if(this.worldview&&"string"==typeof e)if("all"===e)i.properties.$localized=!0;else {if(!e.split(",").includes(this.worldview))continue;i.properties.$localized=!0,i.properties.worldview=this.worldview;}}!b&&i.properties&&i.properties.hasOwnProperty(a)&&(b=!0),v.push({feature:i,id:r,index:t,sourceLayerIndex:m}),t++;}b&&t.layers.hasOwnProperty(l)&&(p.elevationFeatures=g.parseFrom(t.layers[l],this.canonical));for(const t of f[s]){const s=t[0];(!this.extraShadowCaster||s.is3D()&&"model"!==s.type)&&(void 0!==this.isSymbolTile&&"symbol"===s.type!==this.isSymbolTile||s.minzoom&&this.zoom<Math.floor(s.minzoom)||s.maxzoom&&this.zoom>=s.maxzoom||"none"!==s.visibility&&(y(t,this.zoom,p.brightness,i),(u[s.id]=s.createBucket({index:h.bucketLayerIDs.length,layers:t,zoom:this.zoom,lut:this.lut,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:m,sourceID:this.source,projection:this.projection.spec,tessellationStep:this.tessellationStep})).populate(v,p,this.tileID.canonical,this.tileTransform),h.bucketLayerIDs.push(t.map((t=>e.aC(t.id,t.scope))))));}}let m,v,b,x;d.trim();const w={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},I=()=>{if(m)return this.status="done",r(m);if(this.extraShadowCaster)this.status="done",r(null,{buckets:e.bj(u).filter((e=>!e.isEmpty())),featureIndex:h,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:p.brightness,glyphMap:null,iconMap:null,glyphPositions:null});else if(v&&b&&x){const t=new n(v),s=new e.e3(b,x,this.lut);for(const o in u){const r=u[o];r instanceof e.aX?(y(r.layers,this.zoom,p.brightness,i),e.e4(r,v,t.positions,b,s.iconPositions,this.showCollisionBoxes,i,this.tileID.canonical,this.tileZoom,this.projection,this.scaleFactor,this.pixelRatio,this.brightness)):r.hasPattern&&(r instanceof e.b1||r instanceof e.b2||r instanceof e.d5)&&(y(r.layers,this.zoom,p.brightness,i),r.addFeatures(p,this.tileID.canonical,s.patternPositions,i,this.tileTransform,this.brightness));}this.status="done",r(null,{buckets:e.bj(u).filter((e=>!e.isEmpty())),featureIndex:h,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,lineAtlas:d,imageAtlas:s,brightness:p.brightness});}};if(!this.extraShadowCaster){const t=e.e1(p.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(t).length?o.send("getGlyphs",{uid:this.uid,stacks:t,scope:this.scope},((e,t)=>{m||(m=e,v=t,I());}),void 0,!1,w):v={};const s=Object.keys(p.iconDependencies);s.length?o.send("getImages",{icons:s,source:this.source,scope:this.scope,tileID:this.tileID,type:"icons"},((e,t)=>{if(m)return;m=e;const s={};Object.values(t).some((e=>e.usvg))?this.rasterize(o,s,t,p.iconDependencies,(()=>{b=s,I();})):(this.fillImageMap(s,p.iconDependencies,t),b=s,I());}),void 0,!1,w):b={};const i=Object.keys(p.patternDependencies);i.length?o.send("getImages",{icons:i,source:this.source,scope:this.scope,tileID:this.tileID,type:"patterns"},((e,t)=>{if(!m){m=e;const s={};Object.values(t).some((e=>e.usvg))?this.rasterize(o,s,t,p.patternDependencies,(()=>{x=s,I();})):(this.fillImageMap(s,p.patternDependencies,t),x=s,I());}}),void 0,!1,w):x={};}I();}fillImageMap(e,t,s){for(const i in s){const o=t[i]||[];for(const t of o)s[t.id].usvg||(e[t.serialize()]=s[t.id]);}}getImageTaskQueue(e,t,s){const i={};for(const o in t){const r=s[o]||[];for(const s of r){const o=s.serialize();t[s.id].usvg?i[o]||(i[o]=s):e[o]=t[s.id];}}return i}rasterize(t,s,i,o,r){const n=this.getImageTaskQueue(s,i,o);this.rasterizeTask=t.send("rasterizeImages",{scope:this.scope,imageTasks:n},((t,o)=>{if(!t)for(const t in o){const{id:r}=e.e2.deserializeFromString(t);s[t]=Object.assign({},i[r],{data:o[t]});}r();}));}cancelRasterize(){this.rasterizeTask&&this.rasterizeTask.cancel();}}function y(t,s,i,o){const r=new e.a8(s,{brightness:i});for(const e of t)e.recalculate(r,o);}class v extends e.E{constructor(t,s,i,o,r,n){super(),this.actor=t,this.layerIndex=s,this.availableImages=i,this.loadVectorData=r||e.aD,this.loading={},this.loaded={},this.deduped=new e.aB(t.scheduler),this.isSpriteLoaded=o,this.scheduler=t.scheduler,this.brightness=n;}loadTile(s,i){const o=s.uid,r=s&&s.request,n=r&&r.collectResourceTiming,a=this.loading[o]=new m(s);a.abort=this.loadVectorData(s,((l,c)=>{const h=!this.loading[o];if(delete this.loading[o],a.cancelRasterize(),h||l||!c)return a.status="done",h||(this.loaded[o]=a),i(l);const u=c.rawData,d={};c.expires&&(d.expires=c.expires),c.cacheControl&&(d.cacheControl=c.cacheControl),a.vectorTile=c.vectorTile||new e.dY.VectorTile(new e.bh(u));const p=()=>{a.parse(a.vectorTile,this.layerIndex,this.availableImages,this.actor,((s,o)=>{if(s||!o)return i(s);const a={};if(n){const e=t(r);e.length>0&&(a.resourceTiming=JSON.parse(JSON.stringify(e)));}i(null,e.l({rawTileData:u.slice(0)},o,d,a));}));};this.isSpriteLoaded?p():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(p,{type:"parseTile",isSymbolTile:s.isSymbolTile,zoom:s.tileZoom}):p();})),this.loaded=this.loaded||{},this.loaded[o]=a;}));}reloadTile(t,s){const i=this.loaded,o=t.uid;if(i&&i[o]){const r=i[o];r.scaleFactor=t.scaleFactor,r.showCollisionBoxes=t.showCollisionBoxes,r.projection=t.projection,r.brightness=t.brightness,r.tileTransform=e.aQ(t.tileID.canonical,t.projection),r.extraShadowCaster=t.extraShadowCaster,r.lut=t.lut;const n=(e,t)=>{const i=r.reloadCallback;i&&(delete r.reloadCallback,r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,i)),s(e,t);};"parsing"===r.status?r.reloadCallback=n:"done"===r.status&&(r.vectorTile?r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,n):n());}else s(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class b{loadTile(t,s){const{uid:i,encoding:o,rawImageData:r,padding:n}=t,a=ImageBitmap&&r instanceof ImageBitmap?this.getImageData(r,n):r;s(null,new e.e5(i,a,o,n<1));}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const s=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),s}}e.bg.setPbf(e.bh);class x{decodeRasterArray({task:t,buffer:s},i){e.bg.performDecoding(s,t).then((e=>{i(null,e);}),(e=>{i(e);}));}}const w=e.dY.VectorTileFeature.prototype.toGeoJSON;class I{constructor(t){this._feature=t,this.extent=e.ag,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const s of this._feature.geometry)t.push([new e.P(s[0],s[1])]);return t}{const t=[];for(const s of this._feature.geometry){const i=[];for(const t of s)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,s){return w.call(this,e,t,s)}}class S{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.ag,this.length=t.length,this._features=t;}feature(e){return new I(this._features[e])}}const M=64/4096,P=128;class T{constructor(){this.features=new Map;}clear(){this.features.clear();}load(e=[],t){for(const s of e){const e=s.id;if(null==e)continue;let i=this.features.get(e);i&&this.updateCache(i,t),s.geometry?(i=_(s),this.updateCache(i,t),this.features.set(e,i)):this.features.delete(e),this.updateCache(i,t);}}updateCache(e,t){for(const{canonical:s,uid:i}of Object.values(t)){const{z:o,x:r,y:n}=s;k(e,Math.pow(2,o),r,n)&&delete t[i];}}getTile(e,t,s){const i=Math.pow(2,e),o=[];for(const e of this.features.values())k(e,i,t,s)&&o.push(D(e,i,t,s));return {features:o}}getFeatures(){return [...this.features.values()]}}function k({minX:e,minY:t,maxX:s,maxY:i},o,r,n){return e<(r+1+M)/o&&t<(n+1+M)/o&&s>(r-M)/o&&i>(n-M)/o}function _(e){const{id:t,geometry:s,properties:i}=e;if(!s)return;if("GeometryCollection"===s.type)throw new Error("GeometryCollection not supported in dynamic mode.");const{type:o,coordinates:r}=s,n={id:t,type:1,geometry:[],tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0},a=n.geometry;if("Point"===o)C(r,a,n);else if("MultiPoint"===o)for(const e of r)C(e,a,n);else if("LineString"===o)n.type=2,z(r,a,n);else if("MultiLineString"===o)n.type=2,L(r,a,n);else if("Polygon"===o)n.type=3,L(r,a,n,!0);else {if("MultiPolygon"!==o)throw new Error("Input data is not a valid GeoJSON object.");n.type=3;for(const e of r)L(e,a,n,!0);}return n}function C([t,s],i,o){const r=e.at(t);let n=e.aA(s);n=n<0?0:n>1?1:n,i.push(r,n),o.minX=Math.min(o.minX,r),o.minY=Math.min(o.minY,n),o.maxX=Math.max(o.maxX,r),o.maxY=Math.max(o.maxY,n);}function z(e,t,s,i=!1,o=!1){const r=[];for(const t of e)C(t,r,s);t.push(r),i&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(r,o);}function L(e,t,s,i=!1){for(let o=0;o<e.length;o++)z(e[o],t,s,i,0===o);}function D(t,s,i,o){const{id:r,type:n,geometry:a,tags:l}=t,c=[];if(1===n)!function(t,s,i,o,r){for(let n=0;n<t.length;n+=2){const a=Math.round(e.ag*(t[n+0]*s-i)),l=Math.round(e.ag*(t[n+1]*s-o));r.push([a,l]);}}(a,s,i,o,c);else for(const e of a)O(e,s,i,o,c);return {id:r,type:n,geometry:c,tags:l}}function O(t,s,i,o,r){const n=-P,a=e.ag+P;let l;for(let c=0;c<t.length-2;c+=2){let h=Math.round(e.ag*(t[c+0]*s-i)),u=Math.round(e.ag*(t[c+1]*s-o)),d=Math.round(e.ag*(t[c+2]*s-i)),p=Math.round(e.ag*(t[c+3]*s-o));const f=d-h,g=p-u;h<n&&d<n||(h<n?(u+=Math.round(g*((n-h)/f)),h=n):d<n&&(p=u+Math.round(g*((n-h)/f)),d=n),u<n&&p<n||(u<n?(h+=Math.round(f*((n-u)/g)),u=n):p<n&&(d=h+Math.round(f*((n-u)/g)),p=n),h>=a&&d>=a||(h>=a?(u+=Math.round(g*((a-h)/f)),h=a):d>=a&&(p=u+Math.round(g*((a-h)/f)),d=a),u>=a&&p>=a||(u>=a?(h+=Math.round(f*((a-u)/g)),u=a):p>=a&&(d=h+Math.round(f*((a-u)/g)),p=a),l&&h===l[l.length-1][0]&&u===l[l.length-1][1]||(l=[[h,u]],r.push(l)),l.push([d,p])))));}}var j,F,N,A={exports:{}},E=function(){if(N)return A.exports;N=1;var t=e.e8(),s=function(){if(F)return j;F=1;var t=e.e6(),s=e.e7().VectorTileFeature;function i(e,t){this.options=t||{},this.features=e,this.length=e.length;}function o(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}return j=i,i.prototype.feature=function(e){return new o(this.features[e],this.options.extent)},o.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var s=0;s<e.length;s++){for(var i=e[s],o=[],r=0;r<i.length;r++)o.push(new t(i[r][0],i[r][1]));this.geometry.push(o);}return this.geometry},o.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,s=-1/0,i=1/0,o=-1/0,r=0;r<e.length;r++)for(var n=e[r],a=0;a<n.length;a++){var l=n[a];t=Math.min(t,l.x),s=Math.max(s,l.x),i=Math.min(i,l.y),o=Math.max(o,l.y);}return [t,i,s,o]},o.prototype.toGeoJSON=s.prototype.toGeoJSON,j}();function i(e){var s=new t;return function(e,t){for(var s in e.layers)t.writeMessage(3,o,e.layers[s]);}(e,s),s.finish()}function o(e,t){var s;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(s=0;s<e.length;s++)i.feature=e.feature(s),t.writeMessage(2,r,i);var o=i.keys;for(s=0;s<o.length;s++)t.writeStringField(3,o[s]);var n=i.values;for(s=0;s<n.length;s++)t.writeMessage(4,h,n[s]);}function r(e,t){var s=e.feature;void 0!==s.id&&t.writeVarintField(1,s.id),t.writeMessage(2,n,e),t.writeVarintField(3,s.type),t.writeMessage(4,c,s);}function n(e,t){var s=e.feature,i=e.keys,o=e.values,r=e.keycache,n=e.valuecache;for(var a in s.properties){var l=s.properties[a],c=r[a];if(null!==l){void 0===c&&(i.push(a),r[a]=c=i.length-1),t.writeVarint(c);var h=typeof l;"string"!==h&&"boolean"!==h&&"number"!==h&&(l=JSON.stringify(l));var u=h+":"+l,d=n[u];void 0===d&&(o.push(l),n[u]=d=o.length-1),t.writeVarint(d);}}}function a(e,t){return (t<<3)+(7&e)}function l(e){return e<<1^e>>31}function c(e,t){for(var s=e.loadGeometry(),i=e.type,o=0,r=0,n=s.length,c=0;c<n;c++){var h=s[c],u=1;1===i&&(u=h.length),t.writeVarint(a(1,u));for(var d=3===i?h.length-1:h.length,p=0;p<d;p++){1===p&&1!==i&&t.writeVarint(a(2,d-1));var f=h[p].x-o,g=h[p].y-r;t.writeVarint(l(f)),t.writeVarint(l(g)),o+=f,r+=g;}3===i&&t.writeVarint(a(7,1));}}function h(e,t){var s=typeof e;"string"===s?t.writeStringField(1,e):"boolean"===s?t.writeBooleanField(7,e):"number"===s&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}return A.exports=i,A.exports.fromVectorTileJs=i,A.exports.fromGeojsonVt=function(e,t){t=t||{};var o={};for(var r in e)o[r]=new s(e[r].features,t),o[r].name=r,o[r].version=t.version,o[r].extent=t.extent;return i({layers:o})},A.exports.GeoJSONWrapper=s,A.exports}(),V=e.e9(E);const Y={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},R=Math.fround||(Z=new Float32Array(1),e=>(Z[0]=+e,Z[0]));var Z;const G=3,B=5,W=6;class X{constructor(e){this.options=Object.assign(Object.create(Y),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:s,maxZoom:i}=this.options;t&&console.time("total time");const o=`prepare ${e.length} points`;t&&console.time(o),this.points=e;const r=[];for(let t=0;t<e.length;t++){const s=e[t];if(!s.geometry)continue;const[i,o]=s.geometry.coordinates,n=R($(i)),a=R(H(o));r.push(n,a,1/0,t,-1,1),this.options.reduce&&r.push(0);}let n=this.trees[i+1]=this._createTree(r);t&&console.timeEnd(o);for(let e=i;e>=s;e--){const s=+Date.now();n=this.trees[e]=this._createTree(this._cluster(n,e)),t&&console.log("z%d: %d clusters in %dms",e,n.numItems,+Date.now()-s);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let s=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const r=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)s=-180,o=180;else if(s>o){const e=this.getClusters([s,i,180,r],t),n=this.getClusters([-180,i,o,r],t);return e.concat(n)}const n=this.trees[this._limitZoom(t)],a=n.range($(s),H(r),$(o),H(i)),l=n.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+B]>1?J(l,t,this.clusterProps):this.points[l[t+G]]);}return c}getChildren(e){const t=this._getOriginId(e),s=this._getOriginZoom(e),i="No cluster with the specified id.",o=this.trees[s];if(!o)throw new Error(i);const r=o.data;if(t*this.stride>=r.length)throw new Error(i);const n=this.options.radius/(this.options.extent*Math.pow(2,s-1)),a=o.within(r[t*this.stride],r[t*this.stride+1],n),l=[];for(const t of a){const s=t*this.stride;r[s+4]===e&&l.push(r[s+B]>1?J(r,s,this.clusterProps):this.points[r[s+G]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,s){const i=[];return this._appendLeaves(i,e,t=t||10,s=s||0,0),i}getTile(e,t,s){const i=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:r,radius:n}=this.options,a=n/r,l=(s-a)/o,c=(s+1+a)/o,h={features:[]};return this._addTileFeatures(i.range((t-a)/o,l,(t+1+a)/o,c),i.data,t,s,o,h),0===t&&this._addTileFeatures(i.range(1-a/o,l,1,c),i.data,o,s,o,h),t===o-1&&this._addTileFeatures(i.range(0,l,a/o,c),i.data,-1,s,o,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const s=this.getChildren(e);if(t++,1!==s.length)break;e=s[0].properties.cluster_id;}return t}_appendLeaves(e,t,s,i,o){const r=this.getChildren(t);for(const t of r){const r=t.properties;if(r&&r.cluster?o+r.point_count<=i?o+=r.point_count:o=this._appendLeaves(e,r.cluster_id,s,i,o):o<i?o++:e.push(t),e.length===s)break}return o}_createTree(t){const s=new e.bE(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)s.add(t[e],t[e+1]);return s.finish(),s.data=t,s}_addTileFeatures(e,t,s,i,o,r){for(const n of e){const e=n*this.stride,a=t[e+B]>1;let l,c,h;if(a)l=q(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const s=this.points[t[e+G]];l=s.properties;const[i,o]=s.geometry.coordinates;c=$(i),h=H(o);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*o-s)),Math.round(this.options.extent*(h*o-i))]],tags:l};let d;d=a||this.options.generateId?t[e+G]:this.points[t[e+G]].id,void 0!==d&&(u.id=d),r.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:s,extent:i,reduce:o,minPoints:r}=this.options,n=s/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let s=0;s<a.length;s+=c){if(a[s+2]<=t)continue;a[s+2]=t;const i=a[s],h=a[s+1],u=e.within(a[s],a[s+1],n),d=a[s+B];let p=d;for(const e of u){const s=e*c;a[s+2]>t&&(p+=a[s+B]);}if(p>d&&p>=r){let e,r=i*d,n=h*d,f=-1;const g=(s/c<<5)+(t+1)+this.points.length;for(const i of u){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+B];r+=a[l]*h,n+=a[l+1]*h,a[l+4]=g,o&&(e||(e=this._map(a,s,!0),f=this.clusterProps.length,this.clusterProps.push(e)),o(e,this._map(a,l)));}a[s+4]=g,l.push(r/p,n/p,1/0,g,-1,p),o&&l.push(f);}else {for(let e=0;e<c;e++)l.push(a[s+e]);if(p>1)for(const e of u){const s=e*c;if(!(a[s+2]<=t)){a[s+2]=t;for(let e=0;e<c;e++)l.push(a[s+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,s){if(e[t+B]>1){const i=this.clusterProps[e[t+W]];return s?Object.assign({},i):i}const i=this.points[e[t+G]].properties,o=this.options.map(i);return s&&o===i?Object.assign({},o):o}}function J(e,t,s){return {type:"Feature",id:e[t+G],properties:q(e,t,s),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),U(e[t+1])]}};var i;}function q(e,t,s){const i=e[t+B],o=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,r=e[t+W],n=-1===r?{}:Object.assign({},s[r]);return Object.assign(n,{cluster:!0,cluster_id:e[t+G],point_count:i,point_count_abbreviated:o})}function $(e){return e/360+.5}function H(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function U(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function Q(e,t,s,i){let o=i;const r=t+(s-t>>1);let n,a=s-t;const l=e[t],c=e[t+1],h=e[s],u=e[s+1];for(let i=t+3;i<s;i+=3){const t=K(e[i],e[i+1],l,c,h,u);if(t>o)n=i,o=t;else if(t===o){const e=Math.abs(i-r);e<a&&(n=i,a=e);}}o>i&&(n-t>3&&Q(e,t,n,i),e[n+2]=o,s-n>3&&Q(e,n,s,i));}function K(e,t,s,i,o,r){let n=o-s,a=r-i;if(0!==n||0!==a){const l=((e-s)*n+(t-i)*a)/(n*n+a*a);l>1?(s=o,i=r):l>0&&(s+=n*l,i+=a*l);}return n=e-s,a=t-i,n*n+a*a}function ee(e,t,s,i){const o={id:e??null,type:t,geometry:s,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)te(o,s);else if("Polygon"===t)te(o,s[0]);else if("MultiLineString"===t)for(const e of s)te(o,e);else if("MultiPolygon"===t)for(const e of s)te(o,e[0]);return o}function te(e,t){for(let s=0;s<t.length;s+=3)e.minX=Math.min(e.minX,t[s]),e.minY=Math.min(e.minY,t[s+1]),e.maxX=Math.max(e.maxX,t[s]),e.maxY=Math.max(e.maxY,t[s+1]);}function se(e,t,s,i){if(!t.geometry)return;const o=t.geometry.coordinates;if(o&&0===o.length)return;const r=t.geometry.type,n=Math.pow(s.tolerance/((1<<s.maxZoom)*s.extent),2);let a=[],l=t.id;if(s.promoteId?l=t.properties[s.promoteId]:s.generateId&&(l=i||0),"Point"===r)ie(o,a);else if("MultiPoint"===r)for(const e of o)ie(e,a);else if("LineString"===r)oe(o,a,n,!1);else if("MultiLineString"===r){if(s.lineMetrics){for(const s of o)a=[],oe(s,a,n,!1),e.push(ee(l,"LineString",a,t.properties));return}re(o,a,n,!1);}else if("Polygon"===r)re(o,a,n,!0);else {if("MultiPolygon"!==r){if("GeometryCollection"===r){for(const o of t.geometry.geometries)se(e,{id:l,geometry:o,properties:t.properties},s,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of o){const t=[];re(e,t,n,!0),a.push(t);}}e.push(ee(l,r,a,t.properties));}function ie(e,t){t.push(ne(e[0]),ae(e[1]),0);}function oe(e,t,s,i){let o,r,n=0;for(let s=0;s<e.length;s++){const a=ne(e[s][0]),l=ae(e[s][1]);t.push(a,l,0),s>0&&(n+=i?(o*l-a*r)/2:Math.sqrt(Math.pow(a-o,2)+Math.pow(l-r,2))),o=a,r=l;}const a=t.length-3;t[2]=1,Q(t,0,a,s),t[a+2]=1,t.size=Math.abs(n),t.start=0,t.end=t.size;}function re(e,t,s,i){for(let o=0;o<e.length;o++){const r=[];oe(e[o],r,s,i),t.push(r);}}function ne(e){return e/360+.5}function ae(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function le(e,t,s,i,o,r,n,a){if(i/=t,r>=(s/=t)&&n<i)return e;if(n<s||r>=i)return null;const l=[];for(const t of e){const e=t.geometry;let r=t.type;const n=0===o?t.minX:t.minY,c=0===o?t.maxX:t.maxY;if(n>=s&&c<i){l.push(t);continue}if(c<s||n>=i)continue;let h=[];if("Point"===r||"MultiPoint"===r)ce(e,h,s,i,o);else if("LineString"===r)he(e,h,s,i,o,!1,a.lineMetrics);else if("MultiLineString"===r)de(e,h,s,i,o,!1);else if("Polygon"===r)de(e,h,s,i,o,!0);else if("MultiPolygon"===r)for(const t of e){const e=[];de(t,e,s,i,o,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===r){for(const e of h)l.push(ee(t.id,r,e,t.tags));continue}"LineString"!==r&&"MultiLineString"!==r||(1===h.length?(r="LineString",h=h[0]):r="MultiLineString"),"Point"!==r&&"MultiPoint"!==r||(r=3===h.length?"Point":"MultiPoint"),l.push(ee(t.id,r,h,t.tags));}}return l.length?l:null}function ce(e,t,s,i,o){for(let r=0;r<e.length;r+=3){const n=e[r+o];n>=s&&n<=i&&pe(t,e[r],e[r+1],e[r+2]);}}function he(e,t,s,i,o,r,n){let a=ue(e);const l=0===o?fe:ge;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const p=e[d],f=e[d+1],g=e[d+2],m=e[d+3],y=e[d+4],v=0===o?p:f,b=0===o?m:y;let x=!1;n&&(c=Math.sqrt(Math.pow(p-m,2)+Math.pow(f-y,2))),v<s?b>s&&(h=l(a,p,f,m,y,s),n&&(a.start=u+c*h)):v>i?b<i&&(h=l(a,p,f,m,y,i),n&&(a.start=u+c*h)):pe(a,p,f,g),b<s&&v>=s&&(h=l(a,p,f,m,y,s),x=!0),b>i&&v<=i&&(h=l(a,p,f,m,y,i),x=!0),!r&&x&&(n&&(a.end=u+c*h),t.push(a),a=ue(e)),n&&(u+=c);}let d=e.length-3;const p=e[d],f=e[d+1],g=0===o?p:f;g>=s&&g<=i&&pe(a,p,f,e[d+2]),d=a.length-3,r&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&pe(a,a[0],a[1],a[2]),a.length&&t.push(a);}function ue(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function de(e,t,s,i,o,r){for(const n of e)he(n,t,s,i,o,r,!1);}function pe(e,t,s,i){e.push(t,s,i);}function fe(e,t,s,i,o,r){const n=(r-t)/(i-t);return pe(e,r,s+(o-s)*n,1),n}function ge(e,t,s,i,o,r){const n=(r-s)/(o-s);return pe(e,t+(i-t)*n,r,1),n}function me(e,t){const s=[];for(let i=0;i<e.length;i++){const o=e[i],r=o.type;let n;if("Point"===r||"MultiPoint"===r||"LineString"===r)n=ye(o.geometry,t);else if("MultiLineString"===r||"Polygon"===r){n=[];for(const e of o.geometry)n.push(ye(e,t));}else if("MultiPolygon"===r){n=[];for(const e of o.geometry){const s=[];for(const i of e)s.push(ye(i,t));n.push(s);}}s.push(ee(o.id,r,n,o.tags));}return s}function ye(e,t){const s=[];s.size=e.size,void 0!==e.start&&(s.start=e.start,s.end=e.end);for(let i=0;i<e.length;i+=3)s.push(e[i]+t,e[i+1],e[i+2]);return s}function ve(e,t){if(e.transformed)return e;const s=1<<e.z,i=e.x,o=e.y;for(const r of e.features){const e=r.geometry,n=r.type;if(r.geometry=[],1===n)for(let n=0;n<e.length;n+=2)r.geometry.push(be(e[n],e[n+1],t,s,i,o));else for(let n=0;n<e.length;n++){const a=[];for(let r=0;r<e[n].length;r+=2)a.push(be(e[n][r],e[n][r+1],t,s,i,o));r.geometry.push(a);}}return e.transformed=!0,e}function be(e,t,s,i,o,r){return [Math.round(s*(e*i-o)),Math.round(s*(t*i-r))]}function xe(e,t,s,i,o){const r=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),n={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:s,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)we(n,t,r,o);return n}function we(e,t,s,i){const o=t.geometry,r=t.type,n=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===r||"MultiPoint"===r)for(let t=0;t<o.length;t+=3)n.push(o[t],o[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===r)Ie(n,o,e,s,!1,!1);else if("MultiLineString"===r||"Polygon"===r)for(let t=0;t<o.length;t++)Ie(n,o[t],e,s,"Polygon"===r,0===t);else if("MultiPolygon"===r)for(let t=0;t<o.length;t++){const i=o[t];for(let t=0;t<i.length;t++)Ie(n,i[t],e,s,!0,0===t);}if(n.length){let s=t.tags||null;if("LineString"===r&&i.lineMetrics){s={};for(const e in t.tags)s[e]=t.tags[e];s.mapbox_clip_start=o.start/o.size,s.mapbox_clip_end=o.end/o.size;}const a={geometry:n,type:"Polygon"===r||"MultiPolygon"===r?3:"LineString"===r||"MultiLineString"===r?2:1,tags:s};null!==t.id&&(a.id=t.id),e.features.push(a);}}function Ie(e,t,s,i,o,r){const n=i*i;if(i>0&&t.size<(o?n:i))return void(s.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>n)&&(s.numSimplified++,a.push(t[e],t[e+1])),s.numPoints++;o&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(a,r),e.push(a);}const Se={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class Me{constructor(e,t){const s=(t=this.options=function(e,t){for(const s in t)e[s]=t[s];return e}(Object.create(Se),t)).debug;if(s&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const s=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)se(s,e.features[i],t,i);else se(s,"Feature"===e.type?e:{geometry:e},t);return s}(e,t);this.tiles={},this.tileCoords=[],s&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const s=t.buffer/t.extent;let i=e;const o=le(e,1,-1-s,s,0,-1,2,t),r=le(e,1,1-s,2+s,0,-1,2,t);return (o||r)&&(i=le(e,1,-s,1+s,0,-1,2,t)||[],o&&(i=me(o,1).concat(i)),r&&(i=i.concat(me(r,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),s&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,s,i,o,r,n){const a=[e,t,s,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),s=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=Pe(t,s,i);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=xe(e,t,s,i,l),this.tileCoords.push({z:t,x:s,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,s,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==o){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===o)continue;if(null!=o){const e=o-t;if(s!==r>>e||i!==n>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const p=.5*l.buffer/l.extent,f=.5-p,g=.5+p,m=1+p;let y=null,v=null,b=null,x=null,w=le(e,h,s-p,s+g,0,d.minX,d.maxX,l),I=le(e,h,s+f,s+m,0,d.minX,d.maxX,l);e=null,w&&(y=le(w,h,i-p,i+g,1,d.minY,d.maxY,l),v=le(w,h,i+f,i+m,1,d.minY,d.maxY,l),w=null),I&&(b=le(I,h,i-p,i+g,1,d.minY,d.maxY,l),x=le(I,h,i+f,i+m,1,d.minY,d.maxY,l),I=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*s,2*i),a.push(v||[],t+1,2*s,2*i+1),a.push(b||[],t+1,2*s+1,2*i),a.push(x||[],t+1,2*s+1,2*i+1);}}getTile(e,t,s){e=+e,t=+t,s=+s;const i=this.options,{extent:o,debug:r}=i;if(e<0||e>24)return null;const n=1<<e,a=Pe(e,t=t+n&n-1,s);if(this.tiles[a])return ve(this.tiles[a],o);r>1&&console.log("drilling down to z%d-%d-%d",e,t,s);let l,c=e,h=t,u=s;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[Pe(c,h,u)];return l&&l.source?(r>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,s),r>1&&console.timeEnd("drilling down"),this.tiles[a]?ve(this.tiles[a],o):null):null}}function Pe(e,t,s){return 32*((1<<e)*s+t)+e}function Te(e,t){const s=e.tileID.canonical;if(!this._geoJSONIndex)return void t(null,null);const i=this._geoJSONIndex.getTile(s.z,s.x,s.y);if(!i)return void t(null,null);const o=new S(i.features);let r=V(o);0===r.byteOffset&&r.byteLength===r.buffer.byteLength||(r=new Uint8Array(r)),t(null,{vectorTile:o,rawData:r.buffer});}class ke extends v{constructor(e,t,s,i,o,r){super(e,t,s,i,Te,r),o&&(this.loadGeoJSON=o),this._dynamicIndex=new T;}loadData(s,i){const o=s&&s.request,r=o&&o.collectResourceTiming;this.loadGeoJSON(s,((n,a)=>{if(n||!a)return i(n);if("object"!=typeof a)return i(new Error(`Input data given to '${s.source}' is not a valid GeoJSON object.`));{try{if(s.filter){const t=e.U(s.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a.features=a.features.filter((e=>t.value.evaluate({zoom:0},e)));}s.dynamic?("Feature"===a.type&&(a={type:"FeatureCollection",features:[a]}),s.append||(this._dynamicIndex.clear(),this.loaded={}),this._dynamicIndex.load(a.features,this.loaded),s.cluster&&(a.features=this._dynamicIndex.getFeatures())):this.loaded={},this._geoJSONIndex=s.cluster?new X(function({superclusterOptions:t,clusterProperties:s}){if(!s||!t)return t;const i={},o={},r={accumulated:null,zoom:0},n={properties:null},a=Object.keys(s);for(const t of a){const[r,n]=s[t],a=e.U(n),l=e.U("string"==typeof r?[r,["accumulated"],["get",t]]:r);i[t]=a.value,o[t]=l.value;}return t.map=e=>{n.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(r,n);return t},t.reduce=(e,t)=>{n.properties=t;for(const t of a)r.accumulated=e[t],e[t]=o[t].evaluate(r,n);},t}(s)).load(a.features):s.dynamic?this._dynamicIndex:function(e,t){return new Me(e,t)}(a,s.geojsonVtOptions);}catch(e){return i(e)}const n={};if(r){const e=t(o);e&&(n.resourceTiming={},n.resourceTiming[s.source]=JSON.parse(JSON.stringify(e)));}i(null,n);}}));}reloadTile(e,t){const s=this.loaded;return s&&s[e.uid]?e.partial?t(null,void 0):super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,s){if(t.request)e.n(t.request,s);else {if("string"!=typeof t.data)return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return s(null,JSON.parse(t.data))}catch(e){return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class _e{constructor(t,s){this.tileID=new e.aG(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.projection=t.projection,this.brightness=s;}parse(t,s,i,o){this.status="parsing";const r=new e.aG(i.tileID.overscaledZ,i.tileID.wrap,i.tileID.canonical.z,i.tileID.canonical.x,i.tileID.canonical.y),n=[],a=s.familiesBySource[i.source],l=new e.d$(r,i.promoteId);return l.bucketLayerIDs=[],l.is3DTile=!0,e.ea(t).then((t=>{if(!t)return o(new Error("Could not parse tile"));const s=e.eb(t,1/e.cc(i.tileID.canonical)),c=t.json.extensionsUsed&&t.json.extensionsUsed.includes("MAPBOX_mesh_features")||t.json.asset.extras&&t.json.asset.extras.MAPBOX_mesh_features,h=t.json.extensionsUsed&&t.json.extensionsUsed.includes("EXT_meshopt_compression"),u=new e.a8(this.zoom,{brightness:this.brightness});for(const t in a)for(const i of a[t]){const t=i[0];l.bucketLayerIDs.push(i.map((t=>e.aC(t.id,t.scope)))),t.recalculate(u,[]);const o=new e.ec(i,s,r,c,h,this.brightness,l);c||(o.needsUpload=!0),n.push(o),o.evaluate(t);}this.status="done",o(null,{buckets:n,featureIndex:l,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:null});})).catch((e=>o(new Error(e.message))))}}class Ce{constructor(e,t,s,i,o,r){this.actor=e,this.layerIndex=t,this.availableImages=s,this.brightness=r,this.loading={},this.loaded={};}loadTile(t,s){const i=t.uid,o=this.loading[i]=new _e(t,this.brightness);e.bi(t.request,((e,r)=>{const n=!this.loading[i];return delete this.loading[i],n||e?(o.status="done",n||(this.loaded[i]=o),s(e)):r&&0!==r.byteLength?void o.parse(r,this.layerIndex,t,((e,t)=>{o.status="done",this.loaded=this.loaded||{},this.loaded[i]=o,e||!t?s(e):s(null,t);})):(o.status="done",this.loaded[i]=o,s())}));}reloadTile(e,t){const s=this.loaded,i=e.uid;if(s&&s[i]){const o=s[i];o.projection=e.projection,o.brightness=e.brightness;const r=(s,i)=>{o.reloadCallback&&(delete o.reloadCallback,this.loadTile(e,t)),t(s,i);};"parsing"===o.status?o.reloadCallback=r:"done"===o.status&&this.loadTile(e,t);}}abortTile(e,t){const s=e.uid;this.loading[s]&&delete this.loading[s],t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class ze{constructor(t){this.self=t,this.actor=new e.ed(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded={},this.imageRasterizer=new e.I,this.projections={},this.defaultProjection=e.bP({name:"mercator"}),this.workerSourceTypes={vector:v,geojson:ke,"batched-model":Ce},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.ee.isParsed())throw new Error("RTL text plugin already registered.");e.ee.applyArabicShaping=t.applyArabicShaping,e.ee.processBidirectionalText=t.processBidirectionalText,e.ee.processStyledBidirectionalText=t.processStyledBidirectionalText;};}clearCaches(e,t,s){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e],delete this.rasterArrayWorkerSource,s();}checkIfReady(e,t,s){s();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,{scope:s,isLoaded:i}){if(this.isSpriteLoaded[t]||(this.isSpriteLoaded[t]={}),this.isSpriteLoaded[t][s]=i,this.workerSources[t]&&this.workerSources[t][s])for(const o in this.workerSources[t][s]){const r=this.workerSources[t][s][o];for(const t in r){const s=r[t];s instanceof v&&(s.isSpriteLoaded=i,s.fire(new e.z("isSpriteLoaded")));}}}setImages(e,{scope:t,images:s},i){if(this.availableImages[e]||(this.availableImages[e]={}),this.availableImages[e][t]=s,this.workerSources[e]&&this.workerSources[e][t]){for(const i in this.workerSources[e][t]){const o=this.workerSources[e][t][i];for(const e in o)o[e].availableImages=s;}i();}else i();}setProjection(t,s){this.projections[t]=e.bP(s);}setBrightness(e,t,s){this.brightness=t,s();}setLayers(e,t,s){this.getLayerIndex(e,t.scope).replace(t.layers,t.options),s();}updateLayers(e,t,s){this.getLayerIndex(e,t.scope).update(t.layers,t.removedIds,t.options),s();}loadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).loadTile(t,s);}loadDEMTile(e,t,s){this.getDEMWorkerSource(e,t.source,t.scope).loadTile(t,s);}decodeRasterArray(e,t,s){this.getRasterArrayWorkerSource().decodeRasterArray(t,s);}reloadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).reloadTile(t,s);}abortTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).abortTile(t,s);}removeTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).removeTile(t,s);}removeSource(e,t,s){if(!(this.workerSources[e]&&this.workerSources[e][t.scope]&&this.workerSources[e][t.scope][t.type]&&this.workerSources[e][t.scope][t.type][t.source]))return;const i=this.workerSources[e][t.scope][t.type][t.source];delete this.workerSources[e][t.scope][t.type][t.source],void 0!==i.removeSource?i.removeSource(t,s):s();}loadWorkerSource(e,t,s){try{this.self.importScripts(t.url),s();}catch(e){s(e.toString());}}syncRTLPluginState(t,s,i){try{e.ee.setState(s);const t=e.ee.getPluginURL();if(e.ee.isLoaded()&&!e.ee.isParsed()&&null!=t){this.self.importScripts(t);const s=e.ee.isParsed();i(s?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),s);}}catch(e){i(e.toString());}}setDracoUrl(e,t){this.dracoUrl=t;}getAvailableImages(e,t){this.availableImages[e]||(this.availableImages[e]={});let s=this.availableImages[e][t];return s||(s=[]),s}getLayerIndex(e,t){this.layerIndexes[e]||(this.layerIndexes[e]={});let s=this.layerIndexes[e][t];return s||(s=this.layerIndexes[e][t]=new o,s.scope=t),s}getWorkerSource(e,t,s,i){return this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][i]||(this.workerSources[e][i]={}),this.workerSources[e][i][t]||(this.workerSources[e][i][t]={}),this.isSpriteLoaded[e]||(this.isSpriteLoaded[e]={}),this.workerSources[e][i][t][s]||(this.workerSources[e][i][t][s]=new this.workerSourceTypes[t]({send:(t,s,i,o,r,n)=>{this.actor.send(t,s,i,e,r,n);},scheduler:this.actor.scheduler},this.getLayerIndex(e,i),this.getAvailableImages(e,i),this.isSpriteLoaded[e][i],void 0,this.brightness)),this.workerSources[e][i][t][s]}rasterizeImages(e,t,s){const{imageTasks:i,scope:o}=t,r={};for(const t in i){const{image:s,imageIdWithOptions:n}=i[t];r[t]=this.imageRasterizer.rasterize(n,s,o,e);}s(void 0,r);}removeRasterizedImages(e,t,s){const{imageIds:i,scope:o}=t;this.imageRasterizer.removeImagesFromCacheByIds(i,o,e),s();}getDEMWorkerSource(e,t,s){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][s]||(this.demWorkerSources[e][s]={}),this.demWorkerSources[e][s][t]||(this.demWorkerSources[e][s][t]=new b),this.demWorkerSources[e][s][t]}getRasterArrayWorkerSource(){return this.rasterArrayWorkerSource||(this.rasterArrayWorkerSource=new x),this.rasterArrayWorkerSource}enforceCacheSizeLimit(t,s){e.ef(s);}getWorkerPerformanceMetrics(e,t,s){s(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new ze(self)),ze}));

define(["./shared"],(function(e){var t="3.10.0";const i={create:"create",load:"load",fullLoad:"fullLoad"},o={mark(e){performance.mark(e);},measure(e,t,i){performance.measure(e,t,i);}};function s(t){const i=t.name.split("?")[0];return e.a(i)&&i.includes("mapbox-gl.js")?"javascript":e.a(i)&&i.includes("mapbox-gl.css")?"css":e.b(i)?"fontRange":e.c(i)?"sprite":e.i(i)?"style":e.d(i)?"tilejson":"other"}var r,a={},n=function(){if(r)return a;function e(e){return !t(e)}function t(t){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===i[o=t&&t.failIfMajorPerformanceCaveat]&&(i[o]=function(t){var i,o=function(t){var i=document.createElement("canvas"),o=Object.create(e.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=t,i.getContext("webgl2",o)}(t);if(!o)return !1;try{i=o.createShader(o.VERTEX_SHADER);}catch(e){return !1}return !(!i||o.isContextLost())&&(o.shaderSource(i,"void main() {}"),o.compileShader(i),!0===o.getShaderParameter(i,o.COMPILE_STATUS))}(o)),i[o]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL2 support"):"insufficient Canvas/getImageData support":"insufficient worker support";var o;}r=1,a.supported=e,a.notSupportedReason=t;var i={};return e.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0},a}();function l(e,t,i){const o=document.createElement(e);return null!=t&&(o.className=t),i&&i.appendChild(o),o}function c(e,t,i){const o=document.createElementNS("http://www.w3.org/2000/svg",e);for(const e of Object.keys(t))o.setAttributeNS(null,e,String(t[e]));return i&&i.appendChild(o),o}const h="undefined"!=typeof document?document.documentElement&&document.documentElement.style:null,u=h&&void 0!==h.userSelect?"userSelect":"WebkitUserSelect";let d;function _(){h&&u&&(d=h[u],h[u]="none");}function p(){h&&u&&(h[u]=d);}function f(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",f,!0);}function m(){window.addEventListener("click",f,!0),window.setTimeout((()=>{window.removeEventListener("click",f,!0);}),0);}function g(e,t){const i=e.getBoundingClientRect();return x(e,i,t)}function v(e,t){const i=e.getBoundingClientRect(),o=[];for(let s=0;s<t.length;s++)o.push(x(e,i,t[s]));return o}function y(e){return /firefox/i.test(navigator.userAgent)&&/macintosh/i.test(navigator.userAgent)&&2===e.button&&e.ctrlKey?0:e.button}function x(t,i,o){const s=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.P((o.clientX-i.left)*s,(o.clientY-i.top)*s)}const b="01",w="NO_ACCESS_TOKEN";class T{constructor(e,t,i){this._transformRequestFn=e,this._customAccessToken=t,this._silenceAuthErrors=!!i,this._createSkuToken();}_createSkuToken(){const e=function(){let e="";for(let t=0;t<10;t++)e+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",b,e].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=e.token,this._skuTokenExpiresAt=e.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}normalizeStyleURL(i,o){if(!e.f(i))return i;const s=S(i);return s.params.push(`sdk=js-${t}`),s.path=`/styles/v1${s.path}`,this._makeAPIURL(s,this._customAccessToken||o)}normalizeGlyphsURL(t,i){if(!e.f(t))return t;const o=S(t);return o.path=`/fonts/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeModelURL(t,i){if(!e.f(t))return t;const o=S(t);return o.path=`/models/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeSourceURL(t,i,o,s){if(!e.f(t))return t;const r=S(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),o&&r.params.push(`language=${o}`),s&&r.params.push(`worldview=${s}`),this._makeAPIURL(r,this._customAccessToken||i)}normalizeIconsetURL(t,i){const o=S(t);return e.f(t)?(o.path=`/styles/v1${o.path}/iconset.pbf`,this._makeAPIURL(o,this._customAccessToken||i)):C(o)}normalizeSpriteURL(t,i,o,s){const r=S(t);return e.f(t)?(r.path=`/styles/v1${r.path}/sprite${i}${o}`,this._makeAPIURL(r,this._customAccessToken||s)):(r.path+=`${i}${o}`,C(r))}normalizeTileURL(t,i,o){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!e.f(t))return t;const s=S(t);s.path=s.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${i||o&&"raster"!==s.authority&&512===o?"@2x":""}${e.m.supported?".webp":"$1"}`),"raster"===s.authority?s.path=`/${e.e.RASTER_URL_PREFIX}${s.path}`:"rasterarrays"===s.authority?s.path=`/${e.e.RASTERARRAYS_URL_PREFIX}${s.path}`:"3dtiles"===s.authority?s.path=`/${e.e.TILES3D_URL_PREFIX}${s.path}`:(s.path=s.path.replace(/^.+\/v4\//,"/"),s.path=`/${e.e.TILE_URL_VERSION}${s.path}`);const r=this._customAccessToken||function(e){for(const t of e){const e=t.match(/^access_token=(.*)$/);if(e)return e[1]}return null}(s.params)||e.e.ACCESS_TOKEN;return e.e.REQUIRE_ACCESS_TOKEN&&r&&this._skuToken&&s.params.push(`sku=${this._skuToken}`),this._makeAPIURL(s,r)}canonicalizeTileURL(t,i){const o=S(t);if(!o.path.match(/^(\/v4\/|\/(raster|rasterarrays)\/v1\/)/)||!o.path.match(/\.[\w]+$/))return t;let s="mapbox://";o.path.match(/^\/raster\/v1\//)?s+=`raster/${o.path.replace(`/${e.e.RASTER_URL_PREFIX}/`,"")}`:o.path.match(/^\/rasterarrays\/v1\//)?s+=`rasterarrays/${o.path.replace(`/${e.e.RASTERARRAYS_URL_PREFIX}/`,"")}`:s+=`tiles/${o.path.replace(`/${e.e.TILE_URL_VERSION}/`,"")}`;let r=o.params;return i&&(r=r.filter((e=>!e.match(/^access_token=/)))),r.length&&(s+=`?${r.join("&")}`),s}canonicalizeTileset(t,i){const o=!!i&&e.f(i),s=[];for(const i of t.tiles||[])e.h(i)?s.push(this.canonicalizeTileURL(i,o)):s.push(i);return s}_makeAPIURL(t,i){const o="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",s=S(e.e.API_URL);if(t.protocol=s.protocol,t.authority=s.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==s.path&&(t.path=`${s.path}${t.path}`),!e.e.REQUIRE_ACCESS_TOKEN)return C(t);if(i=i||e.e.ACCESS_TOKEN,!this._silenceAuthErrors){if(!i)throw new Error(`An API access token is required to use Mapbox GL. ${o}`);if("s"===i[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${o}`)}return t.params=t.params.filter((e=>-1===e.indexOf("access_token"))),t.params.push(`access_token=${i||""}`),C(t)}}const E=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function S(e){const t=e.match(E);if(!t)throw new Error("Unable to parse URL object");return {protocol:t[1],authority:t[2],path:t[3]||"/",params:t[4]?t[4].split("&"):[]}}function C(e){const t=e.params.length?`?${e.params.join("&")}`:"";return `${e.protocol}://${e.authority}${e.path}${t}`}const I="mapbox.eventData";function R(t){if(!t)return null;const i=t.split(".");if(!i||3!==i.length)return null;try{return JSON.parse(e.j(i[1]))}catch(e){return null}}class D{constructor(e){this.type=e,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const i=R(e.e.ACCESS_TOKEN);let o="";return o=i&&i.u?e.k(i.u):e.e.ACCESS_TOKEN||"",t?`${I}.${t}:${o}`:`${I}:${o}`}fetchEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid");if(t)try{const e=localStorage.getItem(i);e&&(this.eventData=JSON.parse(e));const t=localStorage.getItem(o);t&&(this.anonId=t);}catch(t){e.w("Unable to read from LocalStorage");}}saveEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid"),s=this.anonId;if(t&&s)try{localStorage.setItem(o,s),Object.keys(this.eventData).length>=1&&localStorage.setItem(i,JSON.stringify(this.eventData));}catch(t){e.w("Unable to write to LocalStorage");}}processRequests(e){}postEvent(t,i,o,s){if(!e.e.EVENTS_URL)return;const r=S(e.e.EVENTS_URL);r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const a={event:this.type,created:new Date(t).toISOString()},n=i?e.l(a,i):a,l={url:C(r),headers:{"Content-Type":"text/plain"},body:JSON.stringify([n])};this.pendingRequest=e.p(l,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}queueRequest(e,t){this.queue.push(e),this.processRequests(t);}}const L=new class extends D{constructor(e){super("appUserTurnstile"),this._customAccessToken=e;}postTurnstileEvent(t,i){e.e.EVENTS_URL&&e.e.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>e.f(t)||e.h(t)))&&this.queueRequest(Date.now(),i);}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const o=R(e.e.ACCESS_TOKEN),s=o?o.u:e.e.ACCESS_TOKEN;let r=s!==this.eventData.tokenU;e.v(this.anonId)||(this.anonId=e.u(),r=!0);const a=this.queue.shift();if(this.eventData.lastSuccess){const e=new Date(this.eventData.lastSuccess),t=new Date(a),i=(a-this.eventData.lastSuccess)/864e5;r=r||i>=1||i<-1||e.getDate()!==t.getDate();}else r=!0;r?this.postEvent(a,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,"enabled.telemetry":!1,userId:this.anonId},(e=>{e||(this.eventData.lastSuccess=a,this.eventData.tokenU=s);}),i):this.processRequests();}},A=L.postTurnstileEvent.bind(L),z=new class extends D{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.EVENTS_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;const{id:o,timestamp:s}=this.queue.shift();o&&this.success[o]||(this.anonId||this.fetchEventData(),e.v(this.anonId)||(this.anonId=e.u()),this.postEvent(s,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,skuToken:this.skuToken,userId:this.anonId},(e=>{e?this.errorCb(e):o&&(this.success[o]=!0);}),i));}remove(){this.errorCb=null;}},P=z.postMapLoadEvent.bind(z),M=new class extends D{constructor(){super("style.load"),this.eventIdPerMapInstanceMap=new Map,this.mapInstanceIdMap=new WeakMap;}getMapInstanceId(t){let i=this.mapInstanceIdMap.get(t);return i||(i=e.u(),this.mapInstanceIdMap.set(t,i)),i}getEventId(e){const t=this.eventIdPerMapInstanceMap.get(e)||0;return this.eventIdPerMapInstanceMap.set(e,t+1),t}postStyleLoadEvent(t,i){const{map:o,style:s,importedStyles:r}=i;if(!e.e.EVENTS_URL||!t&&!e.e.ACCESS_TOKEN)return;const a=this.getMapInstanceId(o),n={mapInstanceId:a,eventId:this.getEventId(a),style:s};r.length&&(n.importedStyles=r),this.queueRequest({timestamp:Date.now(),payload:n},t);}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:t,payload:i}=this.queue.shift();this.postEvent(t,i,(()=>{}),e);}},O=M.postStyleLoadEvent.bind(M),F=new class extends D{constructor(){super("gljs.performance");}postPerformanceEvent(t,i){e.e.EVENTS_URL&&(t||e.e.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:i},t);}processRequests(o){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:a}=this.queue.shift(),n=function(o){const r=performance.getEntriesByType("resource"),a=performance.getEntriesByType("mark"),n=function(e){const t={};if(e)for(const i in e)if("other"!==i)for(const o of e[i]){const e=`${i}ResolveRangeMin`,s=`${i}ResolveRangeMax`,r=`${i}RequestCount`,a=`${i}RequestCachedCount`;t[e]=Math.min(t[e]||1/0,o.startTime),t[s]=Math.max(t[s]||-1/0,o.responseEnd);const n=e=>{void 0===t[e]&&(t[e]=0),++t[e];};void 0!==o.transferSize&&0===o.transferSize&&n(a),n(r);}return t}(function(e,t){const i={};if(e)for(const o of e){const e=t(o);void 0===i[e]&&(i[e]=[]),i[e].push(o);}return i}(r,s)),l=window.devicePixelRatio,c=navigator.connection||navigator.mozConnection||navigator.webkitConnection,h=c?c.effectiveType:void 0,u={counters:[],metadata:[],attributes:[]},d=(e,t,i)=>{null!=i&&e.push({name:t,value:i.toString()});};for(const e in n)d(u.counters,e,n[e]);if(o.interactionRange[0]!==1/0&&o.interactionRange[1]!==-1/0&&(d(u.counters,"interactionRangeMin",o.interactionRange[0]),d(u.counters,"interactionRangeMax",o.interactionRange[1])),a)for(const e of Object.keys(i)){const t=i[e],o=a.find((e=>e.name===t));o&&d(u.counters,t,o.startTime);}return d(u.counters,"visibilityHidden",o.visibilityHidden),d(u.attributes,"style",function(t){if(t)for(const i of t){const t=i.name.split("?")[0];if(e.i(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(r)),d(u.attributes,"terrainEnabled",o.terrainEnabled?"true":"false"),d(u.attributes,"fogEnabled",o.fogEnabled?"true":"false"),d(u.attributes,"projection",o.projection),d(u.attributes,"zoom",o.zoom),d(u.metadata,"devicePixelRatio",l),d(u.metadata,"connectionEffectiveType",h),d(u.metadata,"navigatorUserAgent",navigator.userAgent),d(u.metadata,"screenWidth",window.screen.width),d(u.metadata,"screenHeight",window.screen.height),d(u.metadata,"windowWidth",window.innerWidth),d(u.metadata,"windowHeight",window.innerHeight),d(u.metadata,"mapWidth",o.width/l),d(u.metadata,"mapHeight",o.height/l),d(u.metadata,"webglRenderer",o.renderer),d(u.metadata,"webglVendor",o.vendor),d(u.metadata,"sdkVersion",t),d(u.metadata,"sdkIdentifier","mapbox-gl-js"),u}(a);for(const e of n.metadata);for(const e of n.counters);for(const e of n.attributes);this.postEvent(r,n,(()=>{}),o);}},k=F.postPerformanceEvent.bind(F),B=new class extends D{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,i,o,s){if(!e.e.API_URL||!e.e.SESSION_PATH)return;const r=S(e.e.API_URL+e.e.SESSION_PATH);r.params.push(`sku=${i||""}`),r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const a={url:C(r),headers:{"Content-Type":"text/plain"}};this.pendingRequest=e.g(a,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}getSessionAPI(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.SESSION_PATH&&e.e.API_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:t,timestamp:i}=this.queue.shift();t&&this.success[t]||this.getSession(i,this.skuToken,(e=>{e?this.errorCb(e):t&&(this.success[t]=!0);}),e);}remove(){this.errorCb=null;}},N=B.getSessionAPI.bind(B),U=new Set;function j(e,t){t?U.add(e):U.delete(e);}class G{constructor(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps=new Set,this._updatedImages=new Set;}isDirty(){return this._changed}setDirty(){this._changed=!0;}getUpdatedSourceCaches(){return this._updatedSourceCaches}updateSourceCache(e,t){this._updatedSourceCaches[e]=t,this.setDirty();}discardSourceCacheUpdate(e){delete this._updatedSourceCaches[e];}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id),this.setDirty();}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this._updatedPaintProps.delete(e.fqid),this.setDirty();}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id];}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}getUpdatedPaintProperties(){return this._updatedPaintProps}updatePaintProperties(e){this._updatedPaintProps.add(e.fqid),this.setDirty();}getUpdatedImages(){return Array.from(this._updatedImages.values())}updateImage(e){this._updatedImages.add(e),this.setDirty();}resetUpdatedImages(){this._updatedImages.clear();}reset(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps.clear(),this._updatedImages.clear();}}function V(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class q extends e.E{constructor(t){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded={},this.requestors=[],this.patterns={},this.atlasImage={},this.atlasTexture={},this.dirty=!0,this.spriteFormat=t,"raster"!==t&&e.t()&&(this.imageRasterizerDispatcher=new e.D(e.x(),this,"Image Rasterizer Worker",1));}get imageRasterizer(){return this._imageRasterizer||(this._imageRasterizer=new e.I),this._imageRasterizer}createScope(t){this.images[t]={},this.loaded[t]=!1,this.updatedImages[t]={},this.patterns[t]={},this.callbackDispatchedThisFrame[t]={},this.atlasImage[t]=new e.r({width:1,height:1});}isLoaded(){for(const e in this.loaded)if(!this.loaded[e])return !1;return !0}setLoaded(e,t){if(this.loaded[t]!==e&&(this.loaded[t]=e,e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[];}}hasImage(e,t){return !!this.getImage(e,t)}getImage(e,t){return this.images[t][e]}addImage(e,t,i){this._validate(e,i)&&(this.images[t][e]=i);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.y(new Error(`Image "${t}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.y(new Error(`Image "${t}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.y(new Error(`Image "${t}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;if(!t.usvg){if(e[0]<0||t.data.width<e[0])return !1;if(e[1]<0||t.data.height<e[1])return !1;if(e[2]<0||t.data.width<e[2])return !1;if(e[3]<0||t.data.height<e[3])return !1}return !(e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i){i.version=this.images[t][e].version+1,this.images[t][e]=i,this.updatedImages[t][e]=!0,this.removeFromImageRasterizerCache(e,t);}removeFromImageRasterizerCache(t,i){"raster"!==this.spriteFormat&&(e.t()?this.imageRasterizerDispatcher.getActor().send("removeRasterizedImages",{imageIds:[t],scope:i}):this.imageRasterizer.removeImagesFromCacheByIds([t],i));}removeImage(e,t){const i=this.images[t][e];delete this.images[t][e],delete this.patterns[t][e],this.removeFromImageRasterizerCache(e,t),i.userImage&&i.userImage.onRemove&&i.userImage.onRemove();}listImages(e){return Object.keys(this.images[e])}getImages(e,t,i){let o=!0;const s=!!this.loaded[t];if(!s)for(const i of e)this.images[t][i]||(o=!1);s||o?this._notify(e,t,i):this.requestors.push({ids:e,scope:t,callback:i});}rasterizeImages({scope:t,imageTasks:i},o){const s={};for(const e in i){const o=i[e],r=this.getImage(o.id,t);r&&(s[e]={image:r,imageIdWithOptions:o});}e.t()?this.imageRasterizerDispatcher.getActor().send("rasterizeImages",{imageTasks:s,scope:t},o):this.rasterizeImagesInMainThread({imageTasks:s,scope:t},o);}rasterizeImagesInMainThread(e,t){const{imageTasks:i,scope:o}=e,s={};for(const e in i){const{image:t,imageIdWithOptions:r}=i[e];s[e]=this.imageRasterizer.rasterize(r,t,o,"");}t(void 0,s);}getUpdatedImages(e){return this.updatedImages[e]}_notify(t,i,o){const s={};for(const o of t){this.images[i][o]||this.fire(new e.z("styleimagemissing",{id:o}));const t=this.images[i][o];t?s[o]={data:t.usvg?null:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,usvg:t.usvg,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.w(`Image "${o}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}o(null,s);}getPixelSize(e){const{width:t,height:i}=this.atlasImage[e];return {width:t,height:i}}getPattern(t,i,o){const s=this.patterns[i][t],r=this.getImage(t,i);if(!r)return null;if(s&&s.position.version===r.version)return s.position;if(s)s.position.version=r.version;else {r.usvg&&!r.data&&(r.data=this.imageRasterizer.rasterize(e.A.from(t).getPrimary(),r,i,""));const o={w:r.data.width+2*e.B,h:r.data.height+2*e.B,x:0,y:0},s=new e.C(o,r,e.B);this.patterns[i][t]={bin:o,position:s};}return this._updatePatternAtlas(i,o),this.patterns[i][t].position}bind(t,i){const o=t.gl;let s=this.atlasTexture[i];s?this.dirty&&(s.update(this.atlasImage[i]),this.dirty=!1):(s=new e.T(t,this.atlasImage[i],o.RGBA8),this.atlasTexture[i]=s),s.bind(o.LINEAR,o.CLAMP_TO_EDGE);}_updatePatternAtlas(t,i){const o=[];for(const e in this.patterns[t])o.push(this.patterns[t][e].bin);const{w:s,h:r}=e.F(o),a=this.atlasImage[t];a.resize({width:s||1,height:r||1});for(const o in this.patterns[t]){const{bin:s,position:r}=this.patterns[t][o];let n=r.padding;const l=s.x+n,c=s.y+n,h=this.images[t][o].data,u=h.width,d=h.height;n=n>1?n-1:n,e.r.copy(h,a,{x:0,y:0},{x:l,y:c},{width:u,height:d},i),e.r.copy(h,a,{x:0,y:d-n},{x:l,y:c-n},{width:u,height:n},i),e.r.copy(h,a,{x:0,y:0},{x:l,y:c+d},{width:u,height:n},i),e.r.copy(h,a,{x:u-n,y:0},{x:l-n,y:c},{width:n,height:d},i),e.r.copy(h,a,{x:0,y:0},{x:l+u,y:c},{width:n,height:d},i),e.r.copy(h,a,{x:u-n,y:d-n},{x:l-n,y:c-n},{width:n,height:n},i),e.r.copy(h,a,{x:0,y:d-n},{x:l+u,y:c-n},{width:n,height:n},i),e.r.copy(h,a,{x:0,y:0},{x:l+u,y:c+d},{width:n,height:n},i),e.r.copy(h,a,{x:u-n,y:0},{x:l-n,y:c+d},{width:n,height:n},i);}this.dirty=!0;}beginFrame(){for(const e in this.images)this.callbackDispatchedThisFrame[e]={};}dispatchRenderCallbacks(e,t){for(const i of e){if(this.callbackDispatchedThisFrame[t][i])continue;this.callbackDispatchedThisFrame[t][i]=!0;const e=this.images[t][i];V(e)&&this.updateImage(i,t,e);}}}function H(t){const i=t.key,o=t.value,s=t.valueSpec||{},r=t.objectElementValidators||{},a=t.style,n=t.styleSpec;let l=[];const c=e.H(o);if("object"!==c)return [new e.V(i,o,`object expected, ${c} found`)];for(const t in o){const c=t.split(".")[0];let h;r[c]?h=r[c]:s[c]?h=_e:r["*"]?h=r["*"]:s["*"]&&(h=_e),h?l=l.concat(h({key:(i?`${i}.`:i)+t,value:o[t],valueSpec:s[c]||s["*"],style:a,styleSpec:n,object:o,objectKey:t},o)):l.push(new e.G(i,o[t],`unknown property "${t}"`));}for(const t in s)r[t]||s[t].required&&void 0===s[t].default&&void 0===o[t]&&l.push(new e.V(i,o,`missing required property "${t}"`));return l}function Z(t){const i=t.value,o=t.valueSpec,s=t.style,r=t.styleSpec,a=t.key,n=t.arrayElementValidator||_e;if("array"!==e.H(i))return [new e.V(a,i,`array expected, ${e.H(i)} found`)];if(o.length&&i.length!==o.length)return [new e.V(a,i,`array length ${o.length} expected, length ${i.length} found`)];if(o["min-length"]&&i.length<o["min-length"])return [new e.V(a,i,`array length at least ${o["min-length"]} expected, length ${i.length} found`)];let l={type:o.value,values:o.values,minimum:o.minimum,maximum:o.maximum,function:void 0};r.$version<7&&(l.function=o.function),"object"===e.H(o.value)&&(l=o.value);let c=[];for(let e=0;e<i.length;e++)c=c.concat(n({array:i,arrayIndex:e,value:i[e],valueSpec:l,style:s,styleSpec:r,key:`${a}[${e}]`},!0));return c}function W(t){const i=t.key,o=t.value,s=t.valueSpec;let r=e.H(o);if("number"===r&&o!=o&&(r="NaN"),"number"!==r)return [new e.V(i,o,`number expected, ${r} found`)];if("minimum"in s){let r=s.minimum;if("array"===e.H(s.minimum)&&(r=s.minimum[t.arrayIndex]),o<r)return [new e.V(i,o,`${o} is less than the minimum value ${r}`)]}if("maximum"in s){let r=s.maximum;if("array"===e.H(s.maximum)&&(r=s.maximum[t.arrayIndex]),o>r)return [new e.V(i,o,`${o} is greater than the maximum value ${r}`)]}return []}function $(t){const i=t.valueSpec,o=e.K(t.value.type);let s,r,a,n={};const l="categorical"!==o&&void 0===t.value.property,c=!l,h="array"===e.H(t.value.stops)&&"array"===e.H(t.value.stops[0])&&"object"===e.H(t.value.stops[0][0]),u=H({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===o)return [new e.V(t.key,t.value,'identity function may not have a "stops" property')];let i=[];const s=t.value;return i=i.concat(Z({key:t.key,value:s,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:d})),"array"===e.H(s)&&0===s.length&&i.push(new e.V(t.key,s,"array must have at least one stop")),i},default:function(e){return _e({key:e.key,value:e.value,valueSpec:i,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===o&&l&&u.push(new e.V(t.key,t.value,'missing required property "property"')),"identity"===o||t.value.stops||u.push(new e.V(t.key,t.value,'missing required property "stops"')),"exponential"===o&&t.valueSpec.expression&&!e.L(t.valueSpec)&&u.push(new e.V(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(c&&!e.M(t.valueSpec)?u.push(new e.V(t.key,t.value,"property functions not supported")):l&&!e.N(t.valueSpec)&&u.push(new e.V(t.key,t.value,"zoom functions not supported"))),"categorical"!==o&&!h||void 0!==t.value.property||u.push(new e.V(t.key,t.value,'"property" property is required')),u;function d(t){let o=[];const s=t.value,l=t.key;if("array"!==e.H(s))return [new e.V(l,s,`array expected, ${e.H(s)} found`)];if(2!==s.length)return [new e.V(l,s,`array length 2 expected, length ${s.length} found`)];if(h){if("object"!==e.H(s[0]))return [new e.V(l,s,`object expected, ${e.H(s[0])} found`)];if(void 0===s[0].zoom)return [new e.V(l,s,"object stop key must have zoom")];if(void 0===s[0].value)return [new e.V(l,s,"object stop key must have value")];const i=e.K(s[0].zoom);if("number"!=typeof i)return [new e.V(l,s[0].zoom,"stop zoom values must be numbers")];if(a&&a>i)return [new e.V(l,s[0].zoom,"stop zoom values must appear in ascending order")];i!==a&&(a=i,r=void 0,n={}),o=o.concat(H({key:`${l}[0]`,value:s[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:W,value:_}}));}else o=o.concat(_({key:`${l}[0]`,value:s[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},s));return e.O(e.Q(s[1]))?o.concat([new e.V(`${l}[1]`,s[1],"expressions are not allowed in function stops.")]):o.concat(_e({key:`${l}[1]`,value:s[1],valueSpec:i,style:t.style,styleSpec:t.styleSpec}))}function _(t,a){const l=e.H(t.value),c=e.K(t.value),h=null!==t.value?t.value:a;if(s){if(l!==s)return [new e.V(t.key,h,`${l} stop domain type must match previous stop domain type ${s}`)]}else s=l;if("number"!==l&&"string"!==l&&"boolean"!==l&&"number"!=typeof c&&"string"!=typeof c&&"boolean"!=typeof c)return [new e.V(t.key,h,"stop domain value must be a number, string, or boolean")];if("number"!==l&&"categorical"!==o){let s=`number expected, ${l} found`;return e.M(i)&&void 0===o&&(s+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new e.V(t.key,h,s)]}return "categorical"!==o||"number"!==l||"number"==typeof c&&isFinite(c)&&Math.floor(c)===c?"categorical"!==o&&"number"===l&&"number"==typeof c&&"number"==typeof r&&void 0!==r&&c<r?[new e.V(t.key,h,"stop domain values must appear in ascending order")]:(r=c,"categorical"===o&&c in n?[new e.V(t.key,h,"stop domain values must be unique")]:(n[c]=!0,[])):[new e.V(t.key,h,`integer expected, found ${String(c)}`)]}}function X(t){const i=("property"===t.expressionContext?e.S:e.U)(e.Q(t.value),t.valueSpec);if("error"===i.result)return i.value.map((i=>new e.V(`${t.key}${i.key}`,t.value,i.message)));const o=i.value.expression||i.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!o.outputDefined())return [new e.V(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!e.W(o))return [new e.V(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return K(o,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!e.X(o,["zoom","feature-state"]))return [new e.V(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!e.Y(o))return [new e.V(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function K(t,i){const o=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.delete(e);if(0===o.size)return [];const s=[];return t instanceof e.Z&&o.has(t.name)?[new e.V(i.key,i.value,`["${t.name}"] expression is not supported in a filter for a ${i.object.type} layer with id: ${i.object.id}`)]:(t.eachChild((e=>{s.push(...K(e,i));})),s)}function Y(t){const i=t.key,o=t.value,s=t.valueSpec,r=[];return Array.isArray(s.values)?-1===s.values.indexOf(e.K(o))&&r.push(new e.V(i,o,`expected one of [${s.values.join(", ")}], ${JSON.stringify(o)} found`)):-1===Object.keys(s.values).indexOf(e.K(o))&&r.push(new e.V(i,o,`expected one of [${Object.keys(s.values).join(", ")}], ${JSON.stringify(o)} found`)),r}function J(t){return e.$(e.Q(t.value))?X(e.J({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):Q(t)}function Q(t){const i=t.value,o=t.key;if("array"!==e.H(i))return [new e.V(o,i,`array expected, ${e.H(i)} found`)];const s=t.styleSpec;let r,a=[];if(i.length<1)return [new e.V(o,i,"filter array must have at least 1 element")];switch(a=a.concat(Y({key:`${o}[0]`,value:i[0],valueSpec:s.filter_operator,style:t.style,styleSpec:t.styleSpec})),e.K(i[0])){case"<":case"<=":case">":case">=":i.length>=2&&"$type"===e.K(i[1])&&a.push(new e.V(o,i,`"$type" cannot be use with operator "${i[0]}"`));case"==":case"!=":3!==i.length&&a.push(new e.V(o,i,`filter array for operator "${i[0]}" must have 3 elements`));case"in":case"!in":i.length>=2&&(r=e.H(i[1]),"string"!==r&&a.push(new e.V(`${o}[1]`,i[1],`string expected, ${r} found`)));for(let n=2;n<i.length;n++)r=e.H(i[n]),"$type"===e.K(i[1])?a=a.concat(Y({key:`${o}[${n}]`,value:i[n],valueSpec:s.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==r&&"number"!==r&&"boolean"!==r&&a.push(new e.V(`${o}[${n}]`,i[n],`string, number, or boolean expected, ${r} found`));break;case"any":case"all":case"none":for(let e=1;e<i.length;e++)a=a.concat(Q({key:`${o}[${e}]`,value:i[e],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":r=e.H(i[1]),2!==i.length?a.push(new e.V(o,i,`filter array for "${i[0]}" operator must have 2 elements`)):"string"!==r&&a.push(new e.V(`${o}[1]`,i[1],`string expected, ${r} found`));}return a}function ee(t,i){const o=t.key,s=t.style,r=t.layer,a=t.styleSpec,n=t.value,l=t.objectKey,c=a[`${i}_${t.layerType}`];if(!c)return [];const h=l.match(/^(.*)-use-theme$/);if("paint"===i&&h&&c[h[1]])return e.O(n)?[].concat(_e({key:t.key,value:n,valueSpec:{type:"string",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},style:s,styleSpec:a,expressionContext:"property",propertyType:i,propertyKey:l})):_e({key:o,value:n,valueSpec:{type:"string"},style:s,styleSpec:a});const u=l.match(/^(.*)-transition$/);if("paint"===i&&u&&c[u[1]]&&c[u[1]].transition)return _e({key:o,value:n,valueSpec:a.transition,style:s,styleSpec:a});const d=t.valueSpec||c[l];if(!d)return [new e.G(o,n,`unknown property "${l}"`)];let _;if("string"===e.H(n)&&e.M(d)&&!d.tokens&&(_=/^{([^}]+)}$/.exec(n))){const t=`\`{ "type": "identity", "property": ${_?JSON.stringify(_[1]):'"_"'} }\``;return [new e.V(o,n,`"${l}" does not support interpolation syntax\nUse an identity property function instead: ${t}.`)]}const p=[];if("symbol"===t.layerType)"text-field"!==l||!s||s.glyphs||s.imports||p.push(new e.V(o,n,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&e.a0(e.Q(n))&&"identity"===e.K(n.type)&&p.push(new e.V(o,n,'"text-font" does not support identity functions'));else if("model"===t.layerType&&"paint"===i&&r&&r.layout&&r.layout.hasOwnProperty("model-id")&&e.M(d)&&(e.a1(d)||e.N(d))){const t=e.S(e.Q(n),d),i=t.value.expression||t.value._styleExpression.expression;i&&!e.X(i,["measure-light"])&&("model-emissive-strength"===l&&e.Y(i)&&e.W(i)||p.push(new e.V(o,n,`${l} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`)));}return p.concat(_e({key:t.key,value:n,valueSpec:d,style:s,styleSpec:a,expressionContext:"property",propertyType:i,propertyKey:l}))}function te(e){return ee(e,"paint")}function ie(e){return ee(e,"layout")}function oe(t){let i=[];const o=t.value,s=t.key,r=t.style,a=t.styleSpec;o.type||o.ref||i.push(new e.V(s,o,'either "type" or "ref" is required'));let n=e.K(o.type);const l=e.K(o.ref);if(o.id){const a=e.K(o.id);for(let n=0;n<t.arrayIndex;n++){const t=r.layers[n];e.K(t.id)===a&&i.push(new e.V(s,o.id,`duplicate layer id "${o.id}", previously used at line ${t.id.__line__}`));}}if("ref"in o){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in o&&i.push(new e.V(s,o[t],`"${t}" is prohibited for ref layers`));})),r.layers.forEach((i=>{e.K(i.id)===l&&(t=i);})),t?t.ref?i.push(new e.V(s,o.ref,"ref cannot reference another ref layer")):n=e.K(t.type):"string"==typeof l&&i.push(new e.V(s,o.ref,`ref layer "${l}" not found`));}else if("background"!==n&&"sky"!==n&&"slot"!==n)if(o.source){const t=r.sources&&r.sources[o.source],a=t&&e.K(t.type);t?"vector"===a&&"raster"===n?i.push(new e.V(s,o.source,`layer "${o.id}" requires a raster source`)):"raster"===a&&"raster"!==n?i.push(new e.V(s,o.source,`layer "${o.id}" requires a vector source`)):"vector"!==a||o["source-layer"]?"raster-dem"===a&&"hillshade"!==n?i.push(new e.V(s,o.source,"raster-dem source can only be used with layer type 'hillshade'.")):"raster-array"!==a||["raster","raster-particle"].includes(n)?"line"!==n||!o.paint||!o.paint["line-gradient"]&&!o.paint["line-trim-offset"]||"geojson"===a&&t.lineMetrics?"raster-particle"===n&&"raster-array"!==a&&i.push(new e.V(s,o.source,`layer "${o.id}" requires a 'raster-array' source.`)):i.push(new e.V(s,o,`layer "${o.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):i.push(new e.V(s,o.source,"raster-array source can only be used with layer type 'raster'.")):i.push(new e.V(s,o,`layer "${o.id}" must specify a "source-layer"`)):i.push(new e.V(s,o.source,`source "${o.source}" not found`));}else i.push(new e.V(s,o,'missing required property "source"'));return i=i.concat(H({key:s,value:o,valueSpec:a.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>_e({key:`${s}.type`,value:o.type,valueSpec:a.layer.type,style:t.style,styleSpec:t.styleSpec,object:o,objectKey:"type"}),filter:t=>J(e.J({layerType:n},t)),layout:t=>H({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>ie(e.J({layerType:n},t))}}),paint:t=>H({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>te(e.J({layerType:n,layer:o},t))}})}})),i}function se(t){const i=t.value,o=t.key,s=e.H(i);return "string"!==s?[new e.V(o,i,`string expected, ${s} found`)]:[]}const re={promoteId:function t({key:i,value:o}){if("string"===e.H(o))return se({key:i,value:o});if(Array.isArray(o)){const t=[],s=e.Q(o),r=e.U(s);return "error"===r.result&&r.value.forEach((o=>{t.push(new e.V(`${i}${o.key}`,null,`${o.message}`));})),e.X(r.value.expression,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])||t.push(new e.V(`${i}`,null,"promoteId expression should be only feature dependent")),t}{const e=[];for(const s in o)e.push(...t({key:`${i}.${s}`,value:o[s]}));return e}}};function ae(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!i.type)return [new e.V(o,i,'"type" is required')];const a=e.K(i.type);let n=[];switch(["vector","raster","raster-dem","raster-array"].includes(a)&&(i.url||i.tiles||n.push(new e.G(o,i,'Either "url" or "tiles" is required.'))),a){case"vector":case"raster":case"raster-dem":case"raster-array":return n=n.concat(H({key:o,value:i,valueSpec:s[`source_${a.replace("-","_")}`],style:t.style,styleSpec:s,objectElementValidators:re})),n;case"geojson":if(n=H({key:o,value:i,valueSpec:s.source_geojson,style:r,styleSpec:s,objectElementValidators:re}),i.cluster)for(const e in i.clusterProperties){const[t,s]=i.clusterProperties[e],r="string"==typeof t?[t,["accumulated"],["get",e]]:t;n.push(...X({key:`${o}.${e}.map`,value:s,expressionContext:"cluster-map"})),n.push(...X({key:`${o}.${e}.reduce`,value:r,expressionContext:"cluster-reduce"}));}return n;case"video":return H({key:o,value:i,valueSpec:s.source_video,style:r,styleSpec:s});case"image":return H({key:o,value:i,valueSpec:s.source_image,style:r,styleSpec:s});case"canvas":return [new e.V(o,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Y({key:`${o}.type`,value:i.type,valueSpec:{values:ne(s)},style:r,styleSpec:s})}}function ne(e){return e.source.reduce(((t,i)=>{const o=e[i];return "enum"===o.type.type&&(t=t.concat(Object.keys(o.type.values))),t}),[])}function le(t){const i=t.value,o=t.styleSpec,s=o.light,r=t.style;let a=[];const n=e.H(i);if(void 0===i)return a;if("object"!==n)return a=a.concat([new e.V("light",i,`object expected, ${n} found`)]),a;for(const t in i){const n=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);a=a.concat(l&&s[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:r,styleSpec:o}):n&&s[n[1]]&&s[n[1]].transition?_e({key:t,value:i[t],valueSpec:o.transition,style:r,styleSpec:o}):s[t]?_e({key:t,value:i[t],valueSpec:s[t],style:r,styleSpec:o}):[new e.V(t,i[t],`unknown property "${t}"`)]);}return a}function ce(t){const i=t.value;let o=[];if(!i)return o;const s=e.H(i);if("object"!==s)return o=o.concat([new e.V("light-3d",i,`object expected, ${s} found`)]),o;const r=t.styleSpec,a=r["light-3d"],n=t.key,l=t.style,c=t.style.lights;for(const t of ["type","id"])if(!(t in i))return o=o.concat([new e.V("light-3d",i,`missing property ${t} on light`)]),o;if(i.type&&c)for(let s=0;s<t.arrayIndex;s++){const t=e.K(i.type),r=c[s];e.K(r.type)===t&&o.push(new e.V(n,i.id,`duplicate light type "${i.type}", previously defined at line ${r.id.__line__}`));}const h=`properties_light_${i.type}`;if(!(h in r))return o=o.concat([new e.V("light-3d",i,`Invalid light type ${i.type}`)]),o;const u=r[h];for(const s in i)if("properties"===s){const a=i[s],n=e.H(a);if("object"!==n)return o=o.concat([new e.V("properties",a,`object expected, ${n} found`)]),o;for(const i in a)o=o.concat(u[i]?_e({key:i,value:a[i],valueSpec:u[i],style:l,styleSpec:r}):[new e.G(t.key,a[i],`unknown property "${i}"`)]);}else {const t=s.match(/^(.*)-transition$/),n=s.match(/^(.*)-use-theme$/);o=o.concat(n&&a[n[1]]?_e({key:s,value:i[s],valueSpec:{type:"string"},style:l,styleSpec:r}):t&&a[t[1]]&&a[t[1]].transition?_e({key:s,value:i[s],valueSpec:r.transition,style:l,styleSpec:r}):a[s]?_e({key:s,value:i[s],valueSpec:a[s],style:l,styleSpec:r}):[new e.G(s,i[s],`unknown property "${s}"`)]);}return o}function he(t){const i=t.value,o=t.key,s=t.style,r=t.styleSpec,a=r.terrain;let n=[];const l=e.H(i);if(void 0===i)return n;if("null"===l)return n;if("object"!==l)return n=n.concat([new e.V("terrain",i,`object expected, ${l} found`)]),n;for(const t in i){const o=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&a[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:s,styleSpec:r}):o&&a[o[1]]&&a[o[1]].transition?_e({key:t,value:i[t],valueSpec:r.transition,style:s,styleSpec:r}):a[t]?_e({key:t,value:i[t],valueSpec:a[t],style:s,styleSpec:r}):[new e.G(t,i[t],`unknown property "${t}"`)]);}if(i.source){const t=s.sources&&s.sources[i.source],r=t&&e.K(t.type);t?"raster-dem"!==r&&n.push(new e.V(o,i.source,`terrain cannot be used with a source of type ${String(r)}, it only be used with a "raster-dem" source type`)):n.push(new e.V(o,i.source,`source "${i.source}" not found`));}else n.push(new e.V(o,i,'terrain is missing required property "source"'));return n}function ue(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.fog;let a=[];const n=e.H(i);if(void 0===i)return a;if("object"!==n)return a=a.concat([new e.V("fog",i,`object expected, ${n} found`)]),a;for(const t in i){const n=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);a=a.concat(l&&r[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:o,styleSpec:s}):n&&r[n[1]]&&r[n[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.G(t,i[t],`unknown property "${t}"`)]);}return a}const de={"*":()=>[],array:Z,boolean:function(t){const i=t.value,o=t.key,s=e.H(i);return "boolean"!==s?[new e.V(o,i,`boolean expected, ${s} found`)]:[]},number:W,color:function(t){const i=t.key,o=t.value,s=e.H(o);return "string"!==s?[new e.V(i,o,`color expected, ${s} found`)]:null===e._.parseCSSColor(o)?[new e.V(i,o,`color expected, "${o}" found`)]:[]},enum:Y,filter:J,function:$,layer:oe,object:H,source:ae,model:e.a2,light:le,"light-3d":ce,terrain:he,fog:ue,string:se,formatted:function(e){return 0===se(e).length?[]:X(e)},resolvedImage:function(e){return 0===se(e).length?[]:X(e)},projection:function(t){const i=t.value,o=t.styleSpec,s=o.projection,r=t.style;let a=[];const n=e.H(i);if("object"===n)for(const e in i)a=a.concat(_e({key:e,value:i[e],valueSpec:s[e],style:r,styleSpec:o}));else "string"!==n&&(a=a.concat([new e.V("projection",i,`object or string expected, ${n} found`)]));return a},import:function(t){const{value:i,styleSpec:o}=t,{data:s,...r}=i;Object.defineProperty(r,"__line__",{value:i.__line__,enumerable:!1});let a=H(e.J({},t,{value:r,valueSpec:o.import}));return ""===e.K(r.id)&&a.push(new e.V(`${t.key}.id`,r,"import id can't be an empty string")),s&&(a=a.concat(fe(s,o,{key:`${t.key}.data`}))),a}};function _e(t,i=!1){const o=t.value,s=t.valueSpec,r=t.styleSpec;if(s.expression&&e.a0(e.K(o)))return $(t);if(s.expression&&e.O(e.Q(o)))return X(t);if(s.type&&de[s.type]){const o=de[s.type](t);return !0===i&&o.length>0&&"array"===e.H(t.value)?X(t):o}return H(e.J({},t,{valueSpec:s.type?r[s.type]:s}))}function pe(t){const i=t.value,o=t.key,s=se(t);return s.length||(-1===i.indexOf("{fontstack}")&&s.push(new e.V(o,i,'"glyphs" url must include a "{fontstack}" token')),-1===i.indexOf("{range}")&&s.push(new e.V(o,i,'"glyphs" url must include a "{range}" token'))),s}function fe(t,i=e.a3,o={}){return _e({key:o.key||"",value:t,valueSpec:i.$root,styleSpec:i,style:t,objectElementValidators:{glyphs:pe,"*":()=>[]}})}function me(t,i=e.a3){return De(fe(t,i))}const ge=e=>De(ae(e)),ve=e=>De(le(e)),ye=e=>De(ce(e)),xe=e=>De(he(e)),be=e=>De(ue(e)),we=t=>De(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.snow;let a=[];const n=e.H(i);if(void 0===i)return a;if("object"!==n)return a=a.concat([new e.V("snow",i,`object expected, ${n} found`)]),a;for(const t in i){const n=t.match(/^(.*)-transition$/);a=a.concat(n&&r[n[1]]&&r[n[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.G(t,i[t],`unknown property "${t}"`)]);}return a}(t)),Te=t=>De(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.rain;let a=[];const n=e.H(i);if(void 0===i)return a;if("object"!==n)return a=a.concat([new e.V("rain",i,`object expected, ${n} found`)]),a;for(const t in i){const n=t.match(/^(.*)-transition$/);a=a.concat(n&&r[n[1]]&&r[n[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.G(t,i[t],`unknown property "${t}"`)]);}return a}(t)),Ee=e=>De(oe(e)),Se=e=>De(J(e)),Ce=e=>De(te(e)),Ie=e=>De(ie(e)),Re=t=>De(e.a2(t));function De(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Le(t,i){let o=!1;if(i&&i.length)for(const s of i)s instanceof e.G?e.w(s.message):(t.fire(new e.y(new Error(s.message))),o=!0);return o}let Ae;class ze extends e.E{constructor(t,i="flat"){super(),this._transitionable=new e.a4(Ae||(Ae=new e.a5({anchor:new e.a6(e.a3.light.anchor),position:new e.a7(e.a3.light.position),color:new e.a6(e.a3.light.color),intensity:new e.a6(e.a3.light.intensity)}))),this.setLight(t,i),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(ve,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Le(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a3})))}}let Pe=class extends e.E{constructor(t,i,o,s){super(),this.scope=o,this._transitionable=new e.a4(new e.a5({source:new e.a6(e.a3.terrain.source),exaggeration:new e.a6(e.a3.terrain.exaggeration)}),o,s),this._transitionable.setTransitionOrValue(t,s),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i;}get(){return this._transitionable.serialize()}set(e,t){this._transitionable.setTransitionOrValue(e,t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}getExaggeration(t){return this._transitioning.possiblyEvaluate(new e.a8(t)).get("exaggeration")}getAttenuationRange(){if(!this.isZoomDependent())return null;const t=this._transitionable._values.exaggeration;if(!t)return null;const i=t.value.expression;if(!i)return null;let o=-1,s=-1,r=1;for(const t of i.zoomStops)r=i.evaluate(new e.a8(t)),r>.01?(o=t,s=-1):s=t;return r<.01&&o>0&&s>o?[o,s]:null}isZoomDependent(){const t=this._transitionable._values.exaggeration;return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof e.a9}};const Me=45,Oe=65,Fe=.05;function ke(t,i,o,s){const r=e.ac(Me,Oe,o),[a,n]=Be(t,s);let l=1-Math.min(1,Math.exp((i-a)/(n-a)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*r*t.alpha}function Be(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}function Ne(t,i,o,s,r){const a=e.ab.vec3.transformMat4([],[i,o,s],r.mercatorFogMatrix);return ke(t,e.ab.vec3.length(a),r.pitch,r._fov)}function Ue(t,i,o,s,r,a,n){const l=[[o,s,0],[r,s,0],[r,a,0],[o,a,0]];let c=Number.MAX_VALUE,h=-Number.MAX_VALUE;for(const t of l){const o=e.ab.vec3.transformMat4([],t,i),s=e.ab.vec3.length(o);c=Math.min(c,s),h=Math.max(h,s);}return [ke(t,c,n.pitch,n._fov),ke(t,h,n.pitch,n._fov)]}class je extends e.E{constructor(t,i,o,s){super();const r=new e.a5({range:new e.a6(e.a3.fog.range),color:new e.a6(e.a3.fog.color),"color-use-theme":new e.a6({type:"string","property-type":"data-constant",default:"default"}),"high-color":new e.a6(e.a3.fog["high-color"]),"high-color-use-theme":new e.a6({type:"string","property-type":"data-constant",default:"default"}),"space-color":new e.a6(e.a3.fog["space-color"]),"space-color-use-theme":new e.a6({type:"string","property-type":"data-constant",default:"default"}),"horizon-blend":new e.a6(e.a3.fog["horizon-blend"]),"star-intensity":new e.a6(e.a3.fog["star-intensity"]),"vertical-range":new e.a6(e.a3.fog["vertical-range"])});this._transitionable=new e.a4(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this._transform=i,this.properties=new e.ad(r),this.scope=o;}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.ae(t.zoom),s=this.properties.get("range"),r=[.5,3];return {range:i?[e.af(r[0],s[0],o),e.af(r[1],s[1],o)]:s,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(be,t,o))return;const s=e.l({},t);for(const t of Object.keys(e.a3.fog))void 0===s[t]&&(s[t]=e.a3.fog[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.ac(Me,Oe,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const s=e.aa.fromLngLat(i),r=o.elevation?o.elevation.getAtPointOrZero(s):0;return Ne(t,s.x,s.y,r,o)}(this.state,t,i):0}getOpacityForTile(t){if(!this._transform.projection.supportsFog)return [1,1];const i=this._transform.calculateFogTileMatrix(t.toUnwrapped());return Ue(this.state,i,0,0,e.ag,e.ag,this._transform)}getOpacityForBounds(e,t,i,o,s){return this._transform.projection.supportsFog?Ue(this.state,e,t,i,o,s,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?Be(this.state,e):[0,1]}isVisibleOnFrustum(t){if(!this._transform.projection.supportsFog)return !1;const i=[4,5,6,7];for(const o of i){const i=t.points[o];let s;if(i[2]>=0)s=i;else {const r=t.points[o-4];s=e.ah(r,i,r[2]/(r[2]-i[2]));}if(Ne(this.state,s[0],s[1],0,this._transform)>=Fe)return !0}return !1}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Le(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a3})))}}let Ge,Ve,qe,He,Ze=class extends e.E{constructor(t,i,o,s){super();const r=Ge||(Ge=new e.a5({density:new e.a6(e.a3.snow.density),intensity:new e.a6(e.a3.snow.intensity),color:new e.a6(e.a3.snow.color),opacity:new e.a6(e.a3.snow.opacity),vignette:new e.a6(e.a3.snow.vignette),"vignette-color":new e.a6(e.a3.snow["vignette-color"]),"center-thinning":new e.a6(e.a3.snow["center-thinning"]),direction:new e.a6(e.a3.snow.direction),"flake-size":new e.a6(e.a3.snow["flake-size"])}));this._transitionable=new e.a4(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.ad(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.ai(o[0]),r=-Math.max(e.ai(o[1]),.01),a=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],n=this.properties.get("vignette"),l=this.properties.get("vignette-color");return l.a=n,{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.aj(i.r,i.g,i.b,i.a*t),direction:a,centerThinning:this.properties.get("center-thinning"),flakeSize:this.properties.get("flake-size"),vignetteColor:l}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(we,t,o))return;const s=e.l({},t);for(const t of Object.keys(e.a3.snow))void 0===s[t]&&(s[t]=e.a3.snow[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Le(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a3})))}},We=class extends e.E{constructor(t,i,o,s){super();const r=Ve||(Ve=new e.a5({density:new e.a6(e.a3.rain.density),intensity:new e.a6(e.a3.rain.intensity),color:new e.a6(e.a3.rain.color),opacity:new e.a6(e.a3.rain.opacity),vignette:new e.a6(e.a3.rain.vignette),"vignette-color":new e.a6(e.a3.rain["vignette-color"]),"center-thinning":new e.a6(e.a3.rain["center-thinning"]),direction:new e.a6(e.a3.rain.direction),"droplet-size":new e.a6(e.a3.rain["droplet-size"]),"distortion-strength":new e.a6(e.a3.rain["distortion-strength"])}));this._transitionable=new e.a4(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.ad(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.ai(o[0]),r=-Math.max(e.ai(o[1]),.01),a=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],n=this.properties.get("vignette-color");return n.a=this.properties.get("vignette"),{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.aj(i.r,i.g,i.b,i.a*t),direction:a,centerThinning:this.properties.get("center-thinning"),dropletSize:this.properties.get("droplet-size"),distortionStrength:this.properties.get("distortion-strength"),vignetteColor:n}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(Te,t,o))return;const s=e.l({},t);for(const t of Object.keys(e.a3.rain))void 0===s[t]&&(s[t]=e.a3.rain[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Le(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a3})))}};class $e extends e.E{constructor(t,i,o,s){super(),this.scope=o,this._options=t,this.properties=new e.ad(i),this._transitionable=new e.a4(i,o,new Map(s)),this._transitionable.setTransitionOrValue(t.properties),this._transitioning=this._transitionable.untransitioned();}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t);}shadowsEnabled(){return !!this.properties&&!0===this.properties.get("cast-shadows")}}class Xe{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,o);}static createFromScreenPoints(t,i){let o,s;if(t instanceof e.P||"number"==typeof t[0]){const r=e.P.convert(t);o=[r],s=i.isPointAboveHorizon(r);}else {const r=e.P.convert(t[0]),a=e.P.convert(t[1]);o=[r,a],s=e.al(r,a).every((e=>i.isPointAboveHorizon(e)));}return new Xe(o,i.getCameraPoint(),s,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.al(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.al(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?s.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?s[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(s[3]=this.cameraPoint)),e.am(s,t)}bufferedCameraGeometryGlobe(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.al(i,o,t),r=this.cameraPoint.clone();switch(3*((r.y>i.y)+(r.y>o.y))+((r.x>i.x)+(r.x>o.x))){case 0:s[0]=r,s[4]=r.clone();break;case 1:s.splice(1,0,r);break;case 2:s[1]=r;break;case 3:s.splice(4,0,r);break;case 5:s.splice(2,0,r);break;case 6:s[3]=r;break;case 7:s.splice(3,0,r);break;case 8:s[2]=r;}return s}containsTile(t,i,o,s=0){const r=t.queryPadding/i._pixelsPerMercatorPixel+1,a=o?this._bufferedCameraMercator(r,i):this._bufferedScreenMercator(r,i);let n=t.tileID.wrap+(a.unwrapped?s:0);const l=a.polygon.map((i=>e.an(t.tileTransform,i,n)));if(!e.ao(l,0,0,e.ag,e.ag))return;n=t.tileID.wrap+(this.screenGeometryMercator.unwrapped?s:0);const c=this.screenGeometryMercator.polygon.map((i=>e.ap(t.tileTransform,i,n))),h=c.map((t=>new e.P(t[0],t[1]))),u=i.getFreeCameraOptions().position||new e.aa(0,0,0),d=e.ap(t.tileTransform,u,n),_=c.map((t=>{const i=e.ab.vec3.sub(t,t,d);return e.ab.vec3.normalize(i,i),new e.aq(d,i)})),p=e.ar(t,1,i.zoom)*i._pixelsPerMercatorPixel;return {queryGeometry:this,tilespaceGeometry:h,tilespaceRays:_,bufferedTilespaceGeometry:l,bufferedTilespaceBounds:(f=e.as(l),f.min.x=e.aw(f.min.x,0,e.ag),f.min.y=e.aw(f.min.y,0,e.ag),f.max.x=e.aw(f.max.x,0,e.ag),f.max.y=e.aw(f.max.y,0,e.ag),f),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:p};var f;}_bufferedScreenMercator(e,t){const i=Je(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=Je(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=o,o}}_projectAndResample(t,i){const o=function(t,i){const o=e.ab.mat4.multiply([],i.pixelMatrix,i.globeMatrix),s=[0,-e.ax,0,1],r=[0,e.ax,0,1],a=[0,0,0,1];e.ab.vec4.transformMat4(s,s,o),e.ab.vec4.transformMat4(r,r,o),e.ab.vec4.transformMat4(a,a,o);const n=new e.P(s[0]/s[3],s[1]/s[3]),l=new e.P(r[0]/r[3],r[1]/r[3]),c=e.au(t,n)&&s[3]<a[3],h=e.au(t,l)&&r[3]<a[3];if(!c&&!h)return null;const u=function(e,t,i){for(let o=1;o<e.length;o++){const s=Ye(t.pointCoordinate3D(e[o-1]).x),r=Ye(t.pointCoordinate3D(e[o]).x);if(i<0){if(s<r)return {idx:o,t:-s/(r-1-s)}}else if(r<s)return {idx:o,t:(1-s)/(r+1-s)}}return null}(t,i,c?-1:1);if(!u)return null;const{idx:d,t:_}=u;let p=d>1?Ke(t.slice(0,d),i):[],f=d<t.length?Ke(t.slice(d),i):[];p=p.map((t=>new e.P(Ye(t.x),t.y))),f=f.map((t=>new e.P(Ye(t.x),t.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const g=e.af(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,_);let v;return v=c?[new e.P(0,g),new e.P(0,0),new e.P(1,0),new e.P(1,g)]:[new e.P(1,g),new e.P(1,1),new e.P(0,1),new e.P(0,g)],m.push(...v),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((t=>new e.aa(t.x,t.y))),unwrapped:!1}}(t,i);if(o)return o;const s=function(t,i){let o=!1,s=-1/0,r=0;for(let e=0;e<t.length-1;e++)t[e].x>s&&(s=t[e].x,r=e);for(let e=0;e<t.length-1;e++){const i=(r+e)%(t.length-1),s=t[i],a=t[i+1];Math.abs(s.x-a.x)>.5&&(s.x<a.x?(s.x+=1,0===i&&(t[t.length-1].x+=1)):(a.x+=1,i+1===t.length-1&&(t[0].x+=1)),o=!0);}const a=e.at(i.center.lng);return o&&a<Math.abs(a-1)&&t.forEach((e=>{e.x-=1;})),{polygon:t,unwrapped:o}}(Ke(t,i).map((t=>new e.P(Ye(t.x),t.y))),i);return {polygon:s.polygon.map((t=>new e.aa(t.x,t.y))),unwrapped:s.unwrapped}}}function Ke(t,i){return e.av(t,(e=>{const t=i.pointCoordinate3D(e);e.x=t.x,e.y=t.y;}),1/256)}function Ye(e){return e<0?1+e%1:e%1}function Je(e){return 100*e|0}function Qe(t,i,o,s,r){const a=function(o,s){if(o)return r(o);if(s){if(t.url&&s.tiles&&t.tiles&&delete t.tiles,s.variants){if(!Array.isArray(s.variants))return r(new Error("variants must be an array"));for(const t of s.variants){if(null==t||"object"!=typeof t||t.constructor!==Object)return r(new Error("variant must be an object"));if(!Array.isArray(t.capabilities))return r(new Error("capabilities must be an array"));if(1===t.capabilities.length&&"meshopt"===t.capabilities[0]){s=e.l(s,t);break}}}const o=e.ay(e.l({},s,t),["tilejson","tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding","vector_layers","raster_layers","worldview_options","worldview_default","worldview"]);o.tiles=i.canonicalizeTileset(o,t.url),r(null,o);}},n=function(e,t,i){if(!e)return null;if(!t&&!i)return e;i=i||e.worldview_default;const o=Object.values(e.language||{});if(0===o.length)return null;const s=Object.values(e.worldview||{});if(0===s.length)return null;const r=o.every((e=>e===t)),a=s.every((e=>e===i));return r&&a?e:t in(e.language_options||{})||i in(e.worldview_options||{})?null:e.language_options&&e.worldview_options?e:null}(t.data,o,s);return n?e.q.frame((()=>a(null,n))):t.url?e.n(i.transformRequest(i.normalizeSourceURL(t.url,null,o,s),e.R.Source),a):e.q.frame((()=>{const{data:e,...i}=t;a(null,i);}))}class et{constructor(t,i,o){this.bounds=e.az.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.at(this.bounds.getWest())*i),s=Math.floor(e.aA(this.bounds.getNorth())*i),r=Math.ceil(e.at(this.bounds.getEast())*i),a=Math.ceil(e.aA(this.bounds.getSouth())*i);return t.x>=o&&t.x<r&&t.y>=s&&t.y<a}}class tt extends e.E{constructor(t,i,o,s){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.l(this,e.ay(i,["url","scheme","tileSize","promoteId"])),this._options=e.l({type:"vector"},i),this._collectResourceTiming=!!i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(s),this._tileWorkers={},this._deduped=new e.aB;}load(t){this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,i,o,((s,r)=>{if(this._tileJSONRequest=null,this._loaded=!0,s)i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.y(s));else if(r){if(e.l(this,r),this.hasWorldviews=!!r.worldview_options,r.worldview_default&&(this.worldviewDefault=r.worldview_default),r.vector_layers){this.vectorLayers=r.vector_layers,this.vectorLayerIds=[],this.localizableLayerIds=new Set;for(const e of r.vector_layers)this.vectorLayerIds.push(e.id),r.worldview&&r.worldview[e.source]&&this.localizableLayerIds.add(e.id);}r.bounds&&(this.tileBounds=new et(r.bounds,this.minzoom,this.maxzoom)),A(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}));}t&&t(s);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.aC(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.l({},this._options)}loadTile(t,i){const o=t.tileID.canonical.url(this.tiles,this.scheme),s=this.map._requestManager.normalizeTileURL(o),r=this.map._requestManager.transformRequest(s,e.R.Tile),a=this.map.style?this.map.style.getLut(this.scope):null,n=a?{image:a.image.clone()}:null,l={request:r,data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,lut:n,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:e.q.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,tessellationStep:this.map._tessellationStep,scaleFactor:this.map.getScaleFactor()};if(this.hasWorldviews&&e.f(o)&&(l.worldview=this.map.getWorldview()||this.worldviewDefault,l.localizableLayerIds=this.localizableLayerIds),l.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",l,c.bind(this));else if(t.actor=this._tileWorkers[s]=this._tileWorkers[s]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",l,c.bind(this),void 0,!0);else {const i=e.aD.call({deduped:this._deduped},l,((e,i)=>{e||!i?c.call(this,e):(l.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",l,c.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function c(o,s){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(s&&s.resourceTiming&&(t.resourceTiming=s.resourceTiming),this.map._refreshExpiredTiles&&s&&t.setExpiryData(s),t.loadVectorData(s,this.map.painter),e.aE(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e,t){e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class it extends e.E{constructor(t,i,o,s){super(),this.id=t,this.dispatcher=o,this.setEventedParent(s),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.l({type:"raster"},i),e.l(this,e.ay(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"})),this._tileJSONRequest=Qe(this._options,this.map._requestManager,null,null,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.y(i)):o&&(e.l(this,o),o.raster_layers&&(this.rasterLayers=o.raster_layers,this.rasterLayerIds=this.rasterLayers.map((e=>e.id))),o.bounds&&(this.tileBounds=new et(o.bounds,this.minzoom,this.maxzoom)),A(o.tiles),this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.aC(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.l({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.q.devicePixelRatio>=2,s=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.o(this.map._requestManager.transformRequest(s,e.R.Tile),((o,s,r,a)=>(delete t.request,t.aborted?(t.state="unloaded",i(null)):o?(t.state="errored",i(o)):s?(this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:r,expires:a}),t.setTexture(s,this.map.painter),t.state="loaded",e.aE(this.dispatcher),void i(null)):i(null))));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t&&t();}unloadTile(t,i){t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),i&&i();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class ot extends it{constructor(t,i,o,s){super(t,i,o,s),this.type="raster-array",this.maxzoom=22,this._options=e.l({type:"raster-array"},i);}triggerRepaint(e){const t=this.map.painter._terrain,i=this.map.style.getSourceCache(this.id);t&&t.enabled&&i&&t._clearRenderCacheForTile(i.id,e.tileID),this.map.triggerRepaint();}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),s=this.map._requestManager.transformRequest(o,e.R.Tile);t.requestParams=s,t.actor||(t.actor=this.dispatcher.getActor()),t.request=t.fetchHeader(void 0,((e,o,s,r)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(e){if(20===e.code)return;return t.state="errored",i(e)}this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:s,expires:r}),t.state="empty",i(null);}));}unloadTile(t,i){const o=t.texture;o&&o instanceof e.T?(t.destroy(!0),this.map.painter.saveTileTexture(o)):(t.destroy(),t.flushQueues(),t._isHeaderLoaded=!1,delete t._mrt,delete t.textureDescriptor),t.fbo&&(t.fbo.destroy(),delete t.fbo),delete t.request,delete t.requestParams,delete t.neighboringTiles,t.state="unloaded";}prepareTile(t,i,o){t._isHeaderLoaded&&("empty"!==t.state&&(t.state="reloading"),t.fetchBand(i,o,((i,o)=>{if(i)return t.state="errored",this.fire(new e.y(i)),void this.triggerRepaint(t);o&&(t.setTexture(o,this.map.painter),t.state="loaded",this.triggerRepaint(t));})));}getInitialBand(e){if(!this.rasterLayers)return 0;const t=this.rasterLayers.find((({id:t})=>t===e)),i=t&&t.fields,o=i&&i.bands&&i.bands;return o?o[0]:0}getTextureDescriptor(t,i,o){if(!t)return;const s=i.sourceLayer||this.rasterLayerIds&&this.rasterLayerIds[0];if(!s)return;let r=null;i instanceof e.aH?r=i.paint.get("raster-array-band"):i instanceof e.aI&&(r=i.paint.get("raster-particle-array-band"));const a=r||this.getInitialBand(s);if(null!=a)if(t.textureDescriptor){if(!t.updateNeeded(s,a)||o)return Object.assign({},t.textureDescriptor,{texture:t.texture})}else this.prepareTile(t,s,a);}}const st={vector:tt,raster:it,"raster-dem":class extends it{constructor(t,i,o,s){super(t,i,o,s),this.type="raster-dem",this.maxzoom=22,this._options=e.l({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function s(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.o(this.map._requestManager.transformRequest(o,e.R.Tile),function(o,r,a,n){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:a,expires:n});const i=ImageBitmap&&r instanceof ImageBitmap&&e.t(),o=1-(r.width-e.aF(r.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?r:e.q.getImageData(r,o),c={uid:t.uid,coord:t.tileID,source:this.id,scope:this.scope,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",c,s.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),s=(i.x-1+o)%o,r=0===i.x?t.wrap-1:t.wrap,a=(i.x+1+o)%o,n=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.aG(t.overscaledZ,r,i.z,s,i.y).key]={backfilled:!1},l[new e.aG(t.overscaledZ,n,i.z,a,i.y).key]={backfilled:!1},i.y>0&&(l[new e.aG(t.overscaledZ,r,i.z,s,i.y-1).key]={backfilled:!1},l[new e.aG(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.aG(t.overscaledZ,n,i.z,a,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.aG(t.overscaledZ,r,i.z,s,i.y+1).key]={backfilled:!1},l[new e.aG(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.aG(t.overscaledZ,n,i.z,a,i.y+1).key]={backfilled:!1}),l}},"raster-array":ot,geojson:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(s),this._data=i.data,this._options=e.l({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),void 0!==i.minzoom&&(this.minzoom=i.minzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const r=e.ag/this.tileSize;this.workerOptions=e.l({source:this.id,scope:this.scope,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*r,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*r,extent:e.ag,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.ag,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*r,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter,dynamic:i.dynamic},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}updateData(t){if(!this._options.dynamic)return this.fire(new e.y(new Error("Can't call updateData on a GeoJSON source with dynamic set to false.")));if("string"!=typeof t&&("Feature"===t.type&&(t={type:"FeatureCollection",features:[t]}),"FeatureCollection"!==t.type))return this.fire(new e.y(new Error("Data to update should be a feature or a feature collection.")));if(this._coalesce&&"string"!=typeof t&&"string"!=typeof this._data&&"FeatureCollection"===this._data.type){const e=new Map;for(const t of this._data.features)e.set(t.id,t);for(const i of t.features)e.set(i.id,i);this._data.features=[...e.values()];}else this._data=t;return this._updateWorkerData(!0),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(t=!1){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.z("dataloading",{dataType:"source"})),this._loaded=!1;const i=e.l({append:t},this.workerOptions);i.scope=this.scope;const o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(e.q.resolveURL(o),e.R.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this._pendingLoad=this.actor.send(`${this.type}.loadData`,i,((i,o)=>{if(this._loaded=!0,this._pendingLoad=null,i)this.fire(new e.y(i));else {const i={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&o&&o.resourceTiming&&o.resourceTiming[this.id]&&(i.resourceTiming=o.resourceTiming[this.id]),t&&(this._partialReload=!0),this.fire(new e.z("data",i)),this._partialReload=!1,this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(t),this._coalesce=!1);}));}loaded(){return this._loaded}reload(){const t=e.aC(this.id,this.scope);this.map.style.clearSource(t),this._updateWorkerData();}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const s=this.map.style?this.map.style.getLut(this.scope):null,r=s?{image:s.image.clone()}:null,a=this._partialReload,n={type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,lut:r,scope:this.scope,pixelRatio:e.q.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0,scaleFactor:this.map.getScaleFactor(),partial:a};t.request=this.actor.send(o,n,((e,s)=>a&&!s?(t.state="loaded",i(null)):(delete t.request,t.destroy(),t.aborted?i(null):e?i(e):(t.loadVectorData(s,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e,t){this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}onRemove(e){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.l({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends e.aJ{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.R.Source).url);e.aK(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.y(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.y(new e.V(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.T(t,this.video,i.RGBA8),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:e.aJ,model:class extends e.E{constructor(e,t,i,o){super(),this.id=e,this.type="model",this.models=[],this._loaded=!1,this._options=t;}load(){const t=[];for(const i in this._options.models){const o=this._options.models[i],s=e.aM(this.map._requestManager.transformRequest(o.uri,e.R.Model).url).then((t=>{if(!t)return;const s=e.aN(t),r=new e.aO(i,o.position,o.orientation,s);r.computeBoundsAndApplyParent(),this.models.push(r);})).catch((t=>{this.fire(new e.y(new Error(`Could not load model ${i} from ${o.uri}: ${t.message}`)));}));t.push(s);}return Promise.allSettled(t).then((()=>{this._loaded=!0,this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"}));})).catch((t=>{this.fire(new e.y(new Error(`Could not load models: ${t.message}`)));}))}onAdd(e){this.map=e,this.load();}hasTransition(){return !1}loaded(){return this._loaded}getModels(){return this.models}loadTile(e,t){}serialize(){return {type:"model"}}},"batched-model":class extends e.E{constructor(e,t,i,o){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(o);}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.aC(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}load(t){this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,i,o,((s,r)=>{this._tileJSONRequest=null,this._loaded=!0,s?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.y(s))):r&&(e.l(this,r),r.bounds&&(this.tileBounds=new et(r.bounds,this.minzoom,this.maxzoom)),A(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}))),t&&t(s);}));}hasTransition(){return !1}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),s={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,lut:null,maxZoom:null,promoteId:null,pixelRatio:null,scaleFactor:null};if(t.actor&&"expired"!==t.state)if("loading"===t.state)t.reloadCallback=i;else {if(t.buckets){const e=Object.values(t.buckets);for(const t of e)t.dirty=!0;return void(t.state="loaded")}t.request=t.actor.send("reloadTile",s,r.bind(this));}else t.actor=this.dispatcher.getActor(),t.request=t.actor.send("loadTile",s,r.bind(this),void 0,!0);function r(e,o){return t.aborted?i(null):e&&404!==e.status?i(e):(this.map._refreshExpiredTiles&&o&&t.setExpiryData(o),t.loadModelData(o,this.map.painter),t.state="loaded",void i(null))}}serialize(){return e.l({},this._options)}},canvas:class extends e.aJ{constructor(t,i,o,s){super(t,i,o,s),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.y(new e.V(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.y(new e.V(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.y(new e.V(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.y(new e.V(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.y(new e.V(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.y(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(e){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?!t&&!this._playing||this.texture instanceof e.aL||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.T(i,this.canvas,i.gl.RGBA8,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(s),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.y(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.y(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new et(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),e.l(this,e.ay(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.ay(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this.map=t,this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const{x:i,y:o,z:s}=e.tileID.canonical,r=new AbortController;e.request=Promise.resolve(this._implementation.loadTile({x:i,y:o,z:s},{signal:r.signal})).then(function(i){return delete e.request,e.aborted?(e.state="unloaded",t(null)):void 0===i?(e.state="errored",t(null)):null===i?(this.loadTileData(e,{width:this.tileSize,height:this.tileSize,data:null}),e.state="loaded",t(null)):function(e){return e instanceof ImageData||e instanceof HTMLCanvasElement||e instanceof ImageBitmap||e instanceof HTMLImageElement}(i)?(this.loadTileData(e,i),e.state="loaded",void t(null)):(e.state="errored",t(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((i=>{20!==i.code&&(e.state="errored",t(i));})),e.request.cancel=()=>r.abort();}loadTileData(e,t){e.setTexture(t,this.map.painter);}unloadTile(t,i){if(t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),this._implementation.unloadTile){const{x:e,y:i,z:o}=t.tileID.canonical;this._implementation.unloadTile({x:e,y:i,z:o});}i&&i();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t&&t();}hasTransition(){return !1}_coveringTiles(){return this.map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const t=e.aC(this.id,this.scope);this.map.style.clearSource(t);}_update(){this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}));}}},rt=function(t,i,o,s){const r=new st[i.type](t,i,o,s);if(r.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${r.id}`);return e.aP(["load","abort","unload","serialize","prepare"],r),r};function at(e,t,i=""){return `${i}:${t.id||""}:${t.layer.id}:${function(e){if("layerId"in e)return `layer:${e.layerId}`;{const{featuresetId:t,importId:i}=e;return `featureset:${t}${i?`:import:${i}`:""}`}}(e.target)}`}function nt(e,t,i,o=""){if(e.uniqueFeatureID){const s=at(e,t,o);if(i.has(s))return !0;i.add(s);}return !1}function lt(e,t,i,o,s=!1){const r=t.sourceCache.transform,a=t.sourceCache.tilesIn(e,t.has3DLayers,s);a.sort(ut);const n=[];for(const e of a){const a=e.tile.queryRenderedFeatures(t,e,i,o,r,s);Object.keys(a).length&&n.push({wrappedTileID:e.tile.tileID.wrapped().key,queryResults:a});}return 0===n.length?{}:function(e){const t={},i={};for(const o of e){const e=o.queryResults,s=o.wrappedTileID,r=i[s]=i[s]||{};for(const i in e){const o=e[i],s=r[i]=r[i]||{},a=t[i]=t[i]||[];for(const e of o)s[e.featureIndex]||(s[e.featureIndex]=!0,a.push(e));}}return t}(n)}function ct(e,t,i,o,s){const r={},a=o.queryRenderedSymbols(e),n=[];for(const e of Object.keys(a).map(Number))n.push(s[e]);n.sort(ut);for(const e of n){const o=e.featureIndex.lookupSymbolFeatures(a[e.bucketInstanceId],e.bucketIndex,e.sourceLayerIndex,t,i);for(const t in o){const i=r[t]=r[t]||[],s=o[t];s.sort(((t,i)=>{const o=e.featureSortOrder;if(o){const e=o.indexOf(t.featureIndex);return o.indexOf(i.featureIndex)-e}return i.featureIndex-t.featureIndex}));for(const e of s)i.push(e);}}return r}function ht(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],s={};for(let e=0;e<i.length;e++){const r=i[e],a=r.tileID.canonical.key;s[a]||(s[a]=!0,r.querySourceFeatures(o,t));}return o}function ut(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function dt(e,t){const i={};if(!t)return i;for(const o of e){const e=o.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){o.layers=e,o.stateDependentLayerIds&&(o.stateDependentLayers=o.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.fqid]=o;}}return i}const _t=32,pt=33,ft=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,o=0,s=0,r=0,a=0,n=0;for(1&t?s=r=a=_t:i=o=n=_t;(t>>=1)>1;){const e=i+s>>1,l=o+r>>1;1&t?(s=i,r=o,i=a,o=n):(i=s,o=r,s=a,r=n),a=e,n=l;}const l=4*e;ft[l+0]=i,ft[l+1]=o,ft[l+2]=s,ft[l+3]=r;}const mt=new Uint16Array(2178),gt=new Uint8Array(1089),vt=new Uint16Array(1089);function yt(e){return 0===e?-.03125:32===e?.03125:0}const xt=(()=>({type:2,extent:e.ag,loadGeometry:()=>[[new e.P(0,0),new e.P(e.ag+1,0),new e.P(e.ag+1,e.ag+1),new e.P(0,e.ag+1),new e.P(0,0)]]}))();class bt{constructor(t,i,o,s,r){this.tileID=t,this.uid=e.aV(),this.uses=0,this.tileSize=i,this.tileZoom=o,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=r,s&&s.style&&(this._lastUpdatedBrightness=s.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",s&&s.transform&&(this.projection=s.transform.projection);}registerFadeDuration(t){const i=t+this.timeAdded;i<e.q.now()||this.fadeEndTime&&i<this.fadeEndTime||(this.fadeEndTime=i);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=e.aQ(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,i,o){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=dt(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.aX){if(this.hasSymbolBuckets=!0,!o)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.aX&&i.hasRTLText){this.hasRTLText=!0,e.aY();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e],o=i.style.getOwnLayer(e);if(!o)continue;const s=o.queryRadius(t);this.queryPadding=Math.max(this.queryPadding,s);}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas),this._lastUpdatedBrightness=t.brightness;}else this.collisionBoxArray=new e.aW;}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}loadModelData(e,t,i){e&&(e.resourceTiming&&(this.resourceTiming=e.resourceTiming),this.buckets=Object.assign({},this.buckets,dt(e.buckets,t.style)),e.featureIndex&&(this.latestFeatureIndex=e.featureIndex));}getBucket(e){return this.buckets[e.fqid]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t);}const i=t.gl,o=this.imageAtlas;if(o&&!o.uploaded){const s=!!Object.keys(o.patternPositions).length;this.imageAtlasTexture=new e.T(t,o.image,i.RGBA8,{useMipmap:s}),this.imageAtlas.uploaded=!0;}this.glyphAtlasImage&&(this.glyphAtlasTexture=new e.T(t,this.glyphAtlasImage,i.R8),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new e.T(t,this.lineAtlas.image,i.R8),this.lineAtlas.uploaded=!0);}prepare(e,t,i){if(this.imageAtlas&&this.imageAtlasTexture&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture,i),!t||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const o=t.style.getBrightness();(this._lastUpdatedBrightness||o)&&(this._lastUpdatedBrightness&&o&&Math.abs(this._lastUpdatedBrightness-o)<.001||(this.updateBuckets(t,this._lastUpdatedBrightness!==o),this._lastUpdatedBrightness=o));}queryRenderedFeatures(t,i,o,s,r,a){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData&&!this.latestFeatureIndex.is3DTile)return {};const n=function(t,i){const o=e.ab.mat4.fromScaling([],[.5*t.width,.5*-t.height,1]);return e.ab.mat4.translate(o,o,[1,-1,0]),e.ab.mat4.multiply(o,o,t.calculateProjMatrix(i.toUnwrapped())),Float32Array.from(o)}(r,this.tileID);return this.latestFeatureIndex.query(t,{tilespaceGeometry:i,pixelPosMatrix:n,transform:s,availableImages:o,tileTransform:this.tileTransform})}querySourceFeatures(t,i){const o=this.latestFeatureIndex;if(!o||!o.rawTileData)return;const s=o.loadVTLayers(),r=i?i.sourceLayer:"",a=s._geojsonTileLayer||s[r];if(!a)return;const n=e.aZ(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<a.length;i++){const s=a.feature(i);if(n.needGeometry){const t=e.a_(s,!0);if(!n.filter(new e.a8(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!n.filter(new e.a8(this.tileID.overscaledZ),s))continue;const d=o.getId(s,r),_=new e.a$(s,l,c,h,d);_.tile=u,t.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return !!this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.b0(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const o=this.expirationTime-i;o?this.expirationTime=e+Math.max(o,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}refreshFeatureState(e){this.latestFeatureIndex&&(this.latestFeatureIndex.rawTileData||this.latestFeatureIndex.is3DTile)&&e&&this.updateBuckets(e);}updateBuckets(t,i){if(!this.latestFeatureIndex)return;if(!t.style)return;const o=this.latestFeatureIndex.loadVTLayers(),s=t.style.listImages(),r=t.style.getBrightness();for(const a in this.buckets){if(!t.style.hasLayer(a))continue;const n=this.buckets[a],l=n.layers[0],c=l.sourceLayer||"_geojsonTileLayer",h=o[c],u=t.style.getLayerSourceCache(l);let d={};u&&(d=u._state.getState(c,void 0));const _=this.imageAtlas&&this.imageAtlas.patternPositions||{},p=Object.keys(d).length>0&&!i;p&&!n.stateDependentLayers.length&&!i||n.update(d,h,s,_,p?n.stateDependentLayers:n.layers,i,r),(n instanceof e.b1||n instanceof e.b2)&&t._terrain&&t._terrain.enabled&&u&&n.programConfigurations.needsUpload&&t._terrain._clearRenderCacheForTile(u.id,this.tileID);const f=t&&t.style&&t.style.getOwnLayer(a);f&&(this.queryPadding=Math.max(this.queryPadding,f.queryRadius(n)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<e.q.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=e.q.now()+t;}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t):(this.texture=new e.T(o,t,s.RGBA8,{useMipmap:!0}),this.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE));}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,i){if(!i||"mercator"===i.name||this._tileDebugBuffer)return;const o=e.b3(xt,this.tileID.canonical,this.tileTransform)[0],s=new e.b4,r=new e.b5;for(let e=0;e<o.length;e++){const{x:t,y:i}=o[e];s.emplaceBack(t,i),r.emplaceBack(e);}r.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(r),this._tileDebugBuffer=t.createVertexBuffer(s,e.b6.members),this._tileDebugSegments=e.b7.simpleSegment(0,0,s.length,r.length);}_makeTileBoundsBuffers(t,i){if(this._tileBoundsBuffer||!i||"mercator"===i.name)return;const o=e.b3(xt,this.tileID.canonical,this.tileTransform)[0];let s,r;if(this.isRaster){const t=function(t,i){const o=e.aQ(t,i),s=Math.pow(2,t.z);for(let r=0;r<pt;r++)for(let a=0;a<pt;a++){const n=e.aR((t.x+(a+yt(a))/_t)/s),l=e.aS((t.y+(r+yt(r))/_t)/s),c=i.project(n,l),h=r*pt+a;mt[2*h+0]=Math.round((c.x*o.scale-o.x)*e.ag),mt[2*h+1]=Math.round((c.y*o.scale-o.y)*e.ag);}gt.fill(0),vt.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=ft[t+0],o=ft[t+1],s=ft[t+2],r=ft[t+3],a=i+s>>1,n=o+r>>1,l=a+n-o,c=n+i-a,h=o*pt+i,u=r*pt+s,d=n*pt+a,_=Math.hypot((mt[2*h+0]+mt[2*u+0])/2-mt[2*d+0],(mt[2*h+1]+mt[2*u+1])/2-mt[2*d+1])>=16;gt[d]=gt[d]||(_?1:0),e<1022&&(gt[d]=gt[d]||gt[(o+c>>1)*pt+(i+l>>1)]||gt[(r+c>>1)*pt+(s+l>>1)]);}const r=new e.aT,a=new e.aU;let n=0;function l(t,i){const o=i*pt+t;return 0===vt[o]&&(r.emplaceBack(mt[2*o+0],mt[2*o+1],t*e.ag/_t,i*e.ag/_t),vt[o]=++n),vt[o]-1}function c(e,t,i,o,s,r){const n=e+i>>1,h=t+o>>1;if(Math.abs(e-s)+Math.abs(t-r)>1&&gt[h*pt+n])c(s,r,e,t,n,h),c(i,o,s,r,n,h);else {const n=l(e,t),c=l(i,o),h=l(s,r);a.emplaceBack(n,c,h);}}return c(0,0,_t,_t,_t,0),c(_t,_t,0,0,0,_t),{vertices:r,indices:a}}(this.tileID.canonical,i);s=t.vertices,r=t.indices;}else {s=new e.aT,r=new e.aU;for(const{x:e,y:t}of o)s.emplaceBack(e,t,0,0);const t=e.b8(s.int16,void 0,4);for(let e=0;e<t.length;e+=3)r.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(s,e.b9.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(r),this._tileBoundsSegments=e.b7.simpleSegment(0,0,s.length,r.length);}_makeGlobeTileDebugBuffers(t,i){const o=i.projection;if(!o||"globe"!==o.name||i.freezeTileCoverage)return;const s=this.tileID.canonical,r=e.ba(s,i),a=e.bb(r),n=e.ae(i.zoom);let l;n>0&&(l=e.ab.mat4.invert(new Float64Array(16),i.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(t,s,i,a,l,n),this._makeGlobeTileDebugTextBuffer(t,s,i,a,l,n);}_globePoint(t,i,o,s,r,a,n){let l=e.bc(t,i,o);if(a){const r=1<<o.z,c=e.at(s.center.lng),h=e.aA(s.center.lat),u=(o.x+.5)/r-c;let d=0;u>.5?d=-1:u<-.5&&(d=1);let _=(t/e.ag+o.x)/r+d,p=(i/e.ag+o.y)/r;_=(_-c)*s._pixelsPerMercatorPixel+c,p=(p-h)*s._pixelsPerMercatorPixel+h;const f=[_*s.worldSize,p*s.worldSize,0];e.ab.vec3.transformMat4(f,f,a),l=e.bd(l,f,n);}return e.ab.vec3.transformMat4(l,l,r)}_makeGlobeTileDebugBorderBuffer(t,i,o,s,r,a){const n=new e.b4,l=new e.b5,c=new e.be,h=(e,t,h,u,d)=>{const _=(h-e)/(d-1),p=(u-t)/(d-1),f=n.length;for(let h=0;h<d;h++){const u=e+h*_,d=t+h*p;n.emplaceBack(u,d);const m=this._globePoint(u,d,i,o,s,r,a);c.emplaceBack(m[0],m[1],m[2]),l.emplaceBack(f+h);}},u=e.ag;h(0,0,u,0,16),h(u,0,u,u,16),h(u,u,0,u,16),h(0,u,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(l),this._tileDebugBuffer=t.createVertexBuffer(n,e.b6.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(c,e.bf.members),this._tileDebugSegments=e.b7.simpleSegment(0,0,n.length,l.length);}_makeGlobeTileDebugTextBuffer(t,i,o,s,r,a){const n=e.ag/4,l=new e.b4,c=new e.aU,h=new e.be,u=25;c.reserve(32),l.reserve(u),h.reserve(u);const d=(e,t)=>u*e+t;for(let e=0;e<u;e++){const t=e*n;for(let e=0;e<u;e++){const c=e*n;l.emplaceBack(c,t);const u=this._globePoint(c,t,i,o,s,r,a);h.emplaceBack(u[0],u[1],u[2]);}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=d(e,t),o=d(e,t+1),s=d(e+1,t),r=d(e+1,t+1);c.emplaceBack(i,o,s),c.emplaceBack(s,o,r);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(c),this._tileDebugTextBuffer=t.createVertexBuffer(l,e.b6.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(h,e.bf.members),this._tileDebugTextSegments=e.b7.simpleSegment(0,0,u,32);}destroy(t=!1){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&(this.imageAtlasTexture.destroy(),delete this.imageAtlasTexture),this.glyphAtlasTexture&&(this.glyphAtlasTexture.destroy(),delete this.glyphAtlasTexture),this.lineAtlasTexture&&(this.lineAtlasTexture.destroy(),delete this.lineAtlasTexture),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),!t&&this.texture&&this.texture instanceof e.T&&(this.texture.destroy(),delete this.texture),this.hillshadeFBO&&(this.hillshadeFBO.destroy(),delete this.hillshadeFBO),this.dem&&delete this.dem,this.neighboringTiles&&delete this.neighboringTiles,this.demTexture&&(this.demTexture.destroy(),delete this.demTexture),this.rasterParticleState&&(this.rasterParticleState.destroy(),delete this.rasterParticleState),this.latestFeatureIndex=null,this.state="unloaded";}}e.bg.setPbf(e.bh);class wt extends bt{constructor(e,t,i,o,s){super(e,t,i,o,s),this._workQueue=[],this._fetchQueue=[],this._isHeaderLoaded=!1;}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t,{premultiply:!1}):this.texture=new e.T(o,t,s.RGBA8,{premultiply:!1});}flushQueues(){for(;this._workQueue.length;)this._workQueue.pop()();for(;this._fetchQueue.length;)this._fetchQueue.pop()();}fetchHeader(t=16384,i){const o=this._mrt=new e.bg(30),s=Object.assign({},this.requestParams,{headers:{Range:"bytes=0-"+(t-1)}});return this.entireBuffer=null,this.request=e.bi(s,((e,s,r,a)=>{if(e)i(e);else try{const e=o.getHeaderLength(s);if(e>t)return void(this.request=this.fetchHeader(e,i));o.parseHeader(s),this._isHeaderLoaded=!0;let n=0;for(const e of Object.values(o.layers))n=Math.max(n,e.dataIndex[e.dataIndex.length-1].last_byte);s.byteLength>=n&&(this.entireBuffer=s),i(null,this.entireBuffer||s,r,a);}catch(e){i(e);}})),this.request}fetchBand(t,i,o){const s=this._mrt;if(!this._isHeaderLoaded||!s)return void o(new Error("Tile header is not ready"));const r=this.actor;if(!r)return void o(new Error("Can't fetch tile band without an actor"));let a;const n=(e,s)=>{a.complete(e,s),e?o(e):(this.updateTextureDescriptor(t,i),o(null,this.textureDescriptor&&this.textureDescriptor.img));},l=(e,t)=>{if(e)return o(e);const i=r.send("decodeRasterArray",{buffer:t,task:a},n,void 0,!0);this._workQueue.push((()=>{i&&i.cancel(),a.cancel();}));},c=s.getLayer(t);if(!c)return void o(new Error(`Unknown sourceLayer "${t}"`));if(c.hasDataForBand(i))return this.updateTextureDescriptor(t,i),void o(null,this.textureDescriptor?this.textureDescriptor.img:null);const h=c.getDataRange([i]);if(a=s.createDecodingTask(h),!a||a.tasks.length)if(this.flushQueues(),this.entireBuffer)l(null,this.entireBuffer.slice(h.firstByte,h.lastByte+1));else {const t=Object.assign({},this.requestParams,{headers:{Range:`bytes=${h.firstByte}-${h.lastByte}`}}),i=e.bi(t,l);this._fetchQueue.push((()=>{i.cancel(),a.cancel();}));}else o(null);}updateNeeded(e,t){return (!this.textureDescriptor||this.textureDescriptor.band!==t||this.textureDescriptor.layer!==e)&&"errored"!==this.state}updateTextureDescriptor(t,i){if(!this._mrt)return;const o=this._mrt.getLayer(t);if(!o||!o.hasBand(i)||!o.hasDataForBand(i))return;const{bytes:s,tileSize:r,buffer:a,offset:n,scale:l}=o.getBandView(i),c=r+2*a,h={data:s,width:c,height:c},u=this.texture;u&&u instanceof e.T&&u.update(h,{premultiply:!1}),this.textureDescriptor={layer:t,band:i,img:h,buffer:a,offset:n,tileSize:r,format:o.pixelFormat,mix:[l,256*l,65536*l,16777216*l]};}}class Tt{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const o=e.wrapped().key;void 0===this.data[o]&&(this.data[o]=[]);const s={value:t,timeout:void 0};if(void 0!==i&&(s.timeout=setTimeout((()=>{this.remove(e,s);}),i)),this.data[o].push(s),this.order.push(o),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,o=void 0===t?0:this.data[i].indexOf(t),s=this.data[i][o];return this.data[i].splice(o,1),s.timeout&&clearTimeout(s.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(s.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const o of this.data[i])e(o.value)||t.push(o);for(const e of t)this.remove(e.value.tileID,e);}}class Et{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,i,o){const s=String(i);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][s]=this.stateChanges[t][s]||{},e.l(this.stateChanges[t][s],o),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==s&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][s]){this.deletedStates[t][s]={};for(const e in this.state[t][s])o[e]||(this.deletedStates[t][s][e]=null);}else for(const e in o)this.deletedStates[t]&&this.deletedStates[t][s]&&null===this.deletedStates[t][s][e]&&delete this.deletedStates[t][s][e];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const o=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][o]&&(this.deletedStates[e][o]=this.deletedStates[e][o]||{},this.deletedStates[e][o][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][o])for(i in this.deletedStates[e][o]={},this.stateChanges[e][o])this.deletedStates[e][o][i]=null;else this.deletedStates[e][o]=null;else this.deletedStates[e]=null;}getState(t,i){const o=this.state[t]||{},s=this.stateChanges[t]||{},r=this.deletedStates[t];if(null===r)return {};if(void 0!==i){const t=String(i),a=e.l({},o[t],s[t]);if(r){const e=r[i];if(null===e)return {};for(const t in e)delete a[t];}return a}const a=e.l({},o,s);if(r)for(const e in r)delete a[e];return a}initializeTileState(e,t){e.refreshFeatureState(t);}coalesceChanges(t,i){const o={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const i={};for(const o in this.stateChanges[t])this.state[t][o]||(this.state[t][o]={}),e.l(this.state[t][o],this.stateChanges[t][o]),i[o]=this.state[t][o];o[t]=i;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const i={};if(null===this.deletedStates[t])for(const e in this.state[t])i[e]={},this.state[t][e]={};else for(const e in this.deletedStates[t]){if(null===this.deletedStates[t][e])this.state[t][e]={};else if(this.state[t][e])for(const i of Object.keys(this.deletedStates[t][e]))delete this.state[t][e][i];i[e]=this.state[t][e];}o[t]=o[t]||{},e.l(o[t],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(o).length)for(const e in t)t[e].refreshFeatureState(i);}}class St extends e.E{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),t.on("error",(()=>{this._sourceErrored=!0;})),this._source=t,this._tiles={},this._cache=new Tt(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this.tileCoverLift=0,this._coveredTiles={},this._shadowCasterTiles={},this._state=new Et,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"raster-array"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const e in this._tiles){const t=this._tiles[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,e.isExtraShadowCaster=this._shadowCasterTiles[e.tileID.key],this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e)}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e)}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope);}}getIds(){return e.bj(this._tiles).map((e=>e.tileID)).sort(Ct).map((e=>e.key))}getRenderableIds(t,i){const o=[];for(const e in this._tiles)this._isIdRenderable(+e,t,i)&&o.push(this._tiles[e]);return t?o.sort(((t,i)=>{const o=t.tileID,s=i.tileID,r=new e.P(o.canonical.x,o.canonical.y)._rotate(this.transform.angle),a=new e.P(s.canonical.x,s.canonical.y)._rotate(this.transform.angle);return o.overscaledZ-s.overscaledZ||a.y-r.y||a.x-r.x})).map((e=>e.tileID.key)):o.map((e=>e.tileID)).sort(Ct).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t,i){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())&&(i||!this._shadowCasterTiles[e])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading");}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)));}_tileLoaded(t,i,o,s){if(s)if(t.state="errored",404!==s.status)this._source.fire(new e.y(s,{tile:t}));else {if(this._source.fire(new e.z("data",{dataType:"source",sourceDataType:"error",sourceId:this._source.id,tile:t})),!(t.tileID.key in this._loadedParentTiles))return;if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id);}else this.update(this.transform);}else t.timeAdded=e.q.now(),"expired"===o&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new e.z("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(e){const t=this.getRenderableIds();for(let o=0;o<t.length;o++){const s=t[o];if(e.neighboringTiles&&e.neighboringTiles[s]){const t=this.getTileByID(s);i(e,t),i(t,e);}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const o=t.tileID.canonical.y-e.tileID.canonical.y,s=Math.pow(2,e.tileID.canonical.z),r=t.tileID.key;0===i&&0===o||Math.abs(o)>1||(Math.abs(i)>1&&(1===Math.abs(i+s)?i+=s:1===Math.abs(i-s)&&(i-=s)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,o),e.neighboringTiles&&e.neighboringTiles[r]&&(e.neighboringTiles[r].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,o){for(const s in this._tiles){let r=this._tiles[s];if(o[s]||!r.hasData()||r.tileID.overscaledZ<=t||r.tileID.overscaledZ>i)continue;let a=r.tileID;for(;r&&r.tileID.overscaledZ>t+1;){const e=r.tileID.scaledTo(r.tileID.overscaledZ-1);r=this._tiles[e.key],r&&r.hasData()&&(a=e);}let n=a;for(;n.overscaledZ>t;)if(n=n.scaledTo(n.overscaledZ-1),e[n.key]){o[a.key]=a;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),o=this._getLoadedTile(t);if(o)return o}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,o=Math.ceil(e.height/t)+1,s=Math.floor(i*o*5),r="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,s):s,a="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(a);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const o=this._tiles[i];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),e[o.tileID.key]=o;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e]);}}update(t,i,o,s){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!o)return;this.updateCacheSize(t,i),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={};const r="batched-model"===this._source.type;let a,n=this._source.maxzoom;const l=this.map&&this.map.painter?this.map.painter._terrain:null;if(l&&l.sourceCache===this&&l.attenuationRange()){const e=l.attenuationRange()[0],t=Math.floor(e)-Math.log2(l.getDemUpscale());n>t&&(n=t);}if(this.used||this.usedForTerrain){if(this._source.tileID)a=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.aG(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)));else if(0!==this.tileCoverLift){const s=t.clone();s.tileCoverLift=this.tileCoverLift,a=s.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:n,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:r}),this._source.minzoom<=1&&"globe"===t.projection.name&&(a.push(new e.aG(1,0,1,0,0)),a.push(new e.aG(1,0,1,1,0)),a.push(new e.aG(1,0,1,0,1)),a.push(new e.aG(1,0,1,1,1)));}else if(a=t.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:n,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:r}),this._source.hasTile){const e=this._source.hasTile.bind(this._source);a=a.filter((t=>e(t)));}}else a=[];if(a.length>0&&this.castsShadows&&s&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!It(this._source.type)){const e=t.coveringZoomLevel({tileSize:i||this._source.tileSize,roundZoom:this._source.roundZoom&&!o}),n=Math.min(e,this._source.maxzoom);if(r){const e=t.extendTileCover(a,n);for(const t of e)a.push(t);}else {const e=t.extendTileCover(a,n,s);for(const t of e)this._shadowCasterTiles[t.key]=!0,a.push(t);}}const c=this._updateRetainedTiles(a);if(It(this._source.type)&&0!==a.length){const t={},i={},o=Object.keys(c);for(const s of o){const o=c[s],r=this._tiles[s];if(!r||r.fadeEndTime&&r.fadeEndTime<=e.q.now())continue;const a=this.findLoadedParent(o,Math.max(o.overscaledZ-St.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),i[s]=o;}const s=a[a.length-1].overscaledZ;for(const e in this._tiles){const t=this._tiles[e];if(c[e]||!t.hasData())continue;let o=t.tileID;for(;o.overscaledZ>s;){o=o.scaledTo(o.overscaledZ-1);const s=this._tiles[o.key];if(s&&s.hasData()&&i[o.key]){c[e]=t.tileID;break}}}for(const e in t)c[e]||(this._coveredTiles[e]=!0,c[e]=t[e]);}for(const e in c)this._tiles[e].clearFadeHold();const h=e.bk(this._tiles,c);for(const e of h){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e);}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},o=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),s=e[0].overscaledZ,r=Math.max(s-St.maxOverzooming,this._source.minzoom),a=Math.max(s+St.maxUnderzooming,this._source.minzoom),n={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||o<this._source.maxzoom&&(n[i.key]=i);}this._retainLoadedChildren(n,o,a,t);for(const o of e){let e=this._tiles[o.key];if(e.hasData())continue;if(o.canonical.z>=this._source.maxzoom){const e=o.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else {const e=o.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let s=e.wasRequested();for(let a=o.overscaledZ-1;a>=r;--a){const r=o.scaledTo(a);if(i[r.key])break;if(i[r.key]=!0,e=this.getTile(r),!e&&s&&(e=this._addTile(r)),e&&(t[r.key]=r,s=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,o=this._tiles[e].tileID;for(;o.overscaledZ>0;){if(o.key in this._loadedParentTiles){i=this._loadedParentTiles[o.key];break}t.push(o.key);const e=o.scaledTo(o.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;o=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return !0!==i.isExtraShadowCaster||!!this._shadowCasterTiles[t.key]||this._reloadTile(t.key,"reloading"),i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const o=Boolean(i);if(!o){const e=this.map?this.map.painter:null,o=this._source.tileSize*t.overscaleFactor();i="raster-array"===this._source.type?new wt(t,o,this.transform.tileZoom,e,this._isRaster):new bt(t,o,this.transform.tileZoom,e,this._isRaster),this._loadTile(i,this._tileLoaded.bind(this,i,t.key,i.state));}return i?(i.uses++,this._tiles[t.key]=i,o||this._source.fire(new e.z("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i):null}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state||"empty"===t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,i,o){const s=[],r=this.transform;if(!r)return s;const a="globe"===r.projection.name,n=e.at(r.center.lng);for(const l in this._tiles){const c=this._tiles[l];if(o&&c.clearQueryDebugViz(),c.holdingForFade())continue;let h;if(a){const t=c.tileID.canonical;if(0===t.z){const i=[Math.abs(e.aw(n,...Rt(t,-1))-n),Math.abs(e.aw(n,...Rt(t,1))-n)];h=[0,2*i.indexOf(Math.min(...i))-1];}else {const i=[Math.abs(e.aw(n,...Rt(t,-1))-n),Math.abs(e.aw(n,...Rt(t,0))-n),Math.abs(e.aw(n,...Rt(t,1))-n)];h=[i.indexOf(Math.min(...i))-1];}}else h=[0];for(const e of h){const o=t.containsTile(c,r,i,e);o&&s.push(o);}}return s}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(e){return this._getRenderableCoordinates(e)}_getRenderableCoordinates(e,t){const i=this.getRenderableIds(e,t).map((e=>this._tiles[e].tileID)),o="globe"===this.transform.projection.name;for(const e of i)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped()),e.expandedProjMatrix=o?this.transform.calculateProjMatrix(e.toUnwrapped(),!1,!0):e.projMatrix;return i}sortCoordinatesByDistance(e){const t=e.slice(),i=this.transform._camera.position,o=this.transform._camera.forward(),s={};for(const e of t){const t=1/(1<<e.canonical.z);s[e.key]=((e.canonical.x+.5)*t+e.wrap-i[0])*o[0]+((e.canonical.y+.5)*t-i[1])*o[1]-i[2]*o[2];}return t.sort(((e,t)=>s[e.key]-s[t.key])),t}hasTransition(){if(this._source.hasTransition())return !0;if(It(this._source.type))for(const t in this._tiles){const i=this._tiles[t];if(void 0!==i.fadeEndTime&&i.fadeEndTime>=e.q.now())return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const o=this._tiles[e];o&&o.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}_preloadTiles(t,i){if(!this._sourceLoaded){const e=()=>{this._sourceLoaded&&(this._source.off("data",e),this._preloadTiles(t,i));};return void this._source.on("data",e)}const o=new Map,s=Array.isArray(t)?t:[t],r=this.map.painter.terrain,a=this.usedForTerrain&&r?r.getScaledDemTileSize():this._source.tileSize;for(const e of s){const t=e.coveringTiles({tileSize:a,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)o.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1);}const n=Array.from(o.values());e.bl(n,((e,t)=>{const i=new bt(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i);}));}),i);}}function Ct(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),o=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||o-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function It(e){return "raster"===e||"image"===e||"video"===e||"custom"===e}function Rt(e,t){const i=1<<e.z;return [e.x/i+t,(e.x+1)/i+t]}St.maxOverzooming=10,St.maxUnderzooming=3;class Dt{constructor(e){this.style=e,this.layersGotHidden=!1,this.layers=[];}processLayersChanged(){this.layers=[];const e=!1,t=!1;for(const i in this.style._mergedLayers){const o=this.style._mergedLayers[i];if("fill-extrusion"===o.type)this.layers.push({layer:o,visible:e,visibilityChanged:t});else if("model"===o.type){const i=this.style.getLayerSource(o);i&&"batched-model"===i.type&&this.layers.push({layer:o,visible:e,visibilityChanged:t});}}}onNewFrame(e){this.layersGotHidden=!1;for(const t of this.layers){const i=t.layer;let o=!1;"fill-extrusion"===i.type?o=!i.isHidden(e)&&i.paint.get("fill-extrusion-opacity")>0:"model"===i.type&&(o=!i.isHidden(e)&&i.paint.get("model-opacity").constantOr(1)>0),this.layersGotHidden=this.layersGotHidden||!o&&t.visible,t.visible=o;}}updateZOffset(e,t){this.currentBuildingBuckets=[];for(const e of this.layers){const i=e.layer,o=this.style.getLayerSourceCache(i);let s=1;"fill-extrusion"===i.type&&(s=e.visible?i.paint.get("fill-extrusion-vertical-scale"):0);let r=o?o.getTile(t):null;if(!r&&o&&t.canonical.z>o.getSource().minzoom){let e=t.scaledTo(Math.min(o.getSource().maxzoom,t.overscaledZ-1));for(;e.overscaledZ>=o.getSource().minzoom&&(r=o.getTile(e),!r&&0!==e.overscaledZ);)e=e.scaledTo(e.overscaledZ-1);}this.currentBuildingBuckets.push({bucket:r?r.getBucket(i):null,tileID:r?r.tileID:t,verticalScale:s});}e.hasAnyZOffset=!1;let i=!1;for(let o=0;o<e.symbolInstances.length;o++){const s=e.symbolInstances.get(o),r=s.zOffset,a=this._getHeightAtTileOffset(t,s.tileAnchorX,s.tileAnchorY);s.zOffset=a!==Number.NEGATIVE_INFINITY?a:r,i||r===s.zOffset||(i=!0),e.hasAnyZOffset||0===s.zOffset||(e.hasAnyZOffset=!0);}i&&(e.zOffsetBuffersNeedUpload=!0,e.zOffsetSortDirty=!0);}_mapCoordToOverlappingTile(t,i,o,s){let r=i,a=o;if(t.canonical.z!==s.canonical.z){const n=s.canonical,l=1/(1<<t.canonical.z-n.z);r=(i+t.canonical.x*e.ag)*l-n.x*e.ag|0,a=(o+t.canonical.y*e.ag)*l-n.y*e.ag|0;}return {tileX:r,tileY:a}}_getHeightAtTileOffset(e,t,i){let o,s;for(let r=0;r<this.layers.length;++r){if("fill-extrusion"!==this.layers[r].layer.type)continue;const{bucket:a,tileID:n,verticalScale:l}=this.currentBuildingBuckets[r];if(!a)continue;const{tileX:c,tileY:h}=this._mapCoordToOverlappingTile(e,t,i,n),u=a.getHeightAtTileCoord(c,h);u&&void 0!==u.height&&(u.hidden?o=u.height:s=Math.max(u.height*l,s||0));}if(void 0!==s)return s;for(let s=0;s<this.layers.length;++s){const r=this.layers[s];if("model"!==r.layer.type||!r.visible)continue;const{bucket:a,tileID:n}=this.currentBuildingBuckets[s];if(!a)continue;const{tileX:l,tileY:c}=this._mapCoordToOverlappingTile(e,t,i,n),h=a.getHeightAtTileCoord(l,c);if(h&&!h.hidden)return void 0===h.height&&void 0!==o?Math.min(h.maxHeight,o)*h.verticalScale:h.height?h.height*h.verticalScale:Number.NEGATIVE_INFINITY}return this.layersGotHidden?0:Number.NEGATIVE_INFINITY}}function Lt(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.bm.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function At(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Lt(e[i],t[e[i].ref]));return e}const zt={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setSlot:"setSlot",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setSnow:"setSnow",setRain:"setRain",setCamera:"setCamera",setLights:"setLights",setProjection:"setProjection",addImport:"addImport",removeImport:"removeImport",updateImport:"updateImport"};function Pt(e,t,i){i.push({command:zt.addSource,args:[e,t[e]]});}function Mt(e,t,i){t.push({command:zt.removeSource,args:[e]}),i[e]=!0;}function Ot(e,t,i,o){Mt(e,i,o),Pt(e,t,i);}function Ft(t,i,o){let s;for(s in t[o])if(t[o].hasOwnProperty(s)&&"data"!==s&&!e.bn(t[o][s],i[o][s]))return !1;for(s in i[o])if(i[o].hasOwnProperty(s)&&"data"!==s&&!e.bn(t[o][s],i[o][s]))return !1;return !0}function kt(t,i,o,s,r,a){let n;for(n in i=i||{},t=t||{})t.hasOwnProperty(n)&&(e.bn(t[n],i[n])||o.push({command:a,args:[s,n,i[n],r]}));for(n in i)i.hasOwnProperty(n)&&!t.hasOwnProperty(n)&&(e.bn(t[n],i[n])||o.push({command:a,args:[s,n,i[n],r]}));}function Bt(e){return e.id}function Nt(e,t){return e[t.id]=t,e}class Ut{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.aw(t,0,1);let i=1,o=this._distances[i];const s=t*this.paddedLength+this.padding;for(;o<s&&i<this._distances.length;)o=this._distances[++i];const r=i-1,a=this._distances[r],n=o-a,l=n>0?(s-a)/n:0;return this.points[r].mult(1-l).add(this.points[i].mult(l))}}class jt{constructor(e,t,i){const o=this.boxCells=[],s=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),s.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,s){this._forEachCell(t,i,o,s,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(s);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,s,r){this.boxCells[s].push(r);}_insertCircleCell(e,t,i,o,s,r){this.circleCells[s].push(r);}_query(e,t,i,o,s,r){if(i<0||e>this.width||o<0||t>this.height)return !s&&[];const a=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(s)return !0;for(let e=0;e<this.boxKeys.length;e++)a.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];a.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return r?a.filter(r):a}return this._forEachCell(e,t,i,o,this._queryCell,a,{hitTest:s,seenUids:{box:{},circle:{}}},r),s?a.length>0:a}_queryCircle(e,t,i,o,s){const r=e-i,a=e+i,n=t-i,l=t+i;if(a<0||r>this.width||l<0||n>this.height)return !o&&[];const c=[];return this._forEachCell(r,n,a,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},s),o?c.length>0:c}query(e,t,i,o,s){return this._query(e,t,i,o,!1,s)}hitTest(e,t,i,o,s){return this._query(e,t,i,o,!0,s)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,s,r,a,n){const l=a.seenUids,c=this.boxCells[s];if(null!==c){const s=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=s[c+2]&&t<=s[c+3]&&i>=s[c+0]&&o>=s[c+1]&&(!n||n(this.boxKeys[h]))){if(a.hitTest)return r.push(!0),!0;r.push({key:this.boxKeys[h],x1:s[c],y1:s[c+1],x2:s[c+2],y2:s[c+3]});}}}const h=this.circleCells[s];if(null!==h){const s=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(s[h],s[h+1],s[h+2],e,t,i,o)&&(!n||n(this.circleKeys[c]))){if(a.hitTest)return r.push(!0),!0;{const e=s[h],t=s[h+1],i=s[h+2];r.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,s,r,a,n){const l=a.circle,c=a.seenUids,h=this.boxCells[s];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!n||n(this.boxKeys[t])))return r.push(!0),!0}}const u=this.circleCells[s];if(null!==u){const e=this.circles;for(const t of u)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!n||n(this.circleKeys[t])))return r.push(!0),!0}}}_forEachCell(e,t,i,o,s,r,a,n){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(s.call(this,e,t,i,o,this.xCellCount*l+d,r,a,n))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,s,r){const a=o-e,n=s-t,l=i+r;return l*l>a*a+n*n}_circleAndRectCollide(e,t,i,o,s,r,a){const n=(r-o)/2,l=Math.abs(e-(o+n));if(l>n+i)return !1;const c=(a-s)/2,h=Math.abs(t-(s+c));if(h>c+i)return !1;if(l<=n||h<=c)return !0;const u=l-n,d=h-c;return u*u+d*d<=i*i}}const Gt={unknown:0,flipRequired:1,flipNotRequired:2},Vt=Math.tan(85*Math.PI/180);function qt(t,i,o,s,r,a,n){const l=e.ab.mat4.create();if(o)if("globe"===a.name){const t=e.bo(r,i);e.ab.mat4.multiply(l,l,t);}else {const t=e.ab.mat2.invert([],n);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],s||e.ab.mat4.rotateZ(l,l,r.angle);}else e.ab.mat4.multiply(l,r.labelPlaneMatrix,t);return l}function Ht(e,t,i,o,s,r,a){const n=qt(e,t,i,o,s,r,a);return "globe"===r.name&&i||(n[2]=n[6]=n[10]=n[14]=0),n}function Zt(t,i,o,s,r,a,n){if(o){if("globe"===a.name){const l=qt(t,i,o,s,r,a,n);return e.ab.mat4.invert(l,l),e.ab.mat4.multiply(l,t,l),l}{const i=e.ab.mat4.clone(t),o=e.ab.mat4.identity([]);return o[0]=n[0],o[1]=n[1],o[4]=n[2],o[5]=n[3],e.ab.mat4.multiply(i,i,o),s||e.ab.mat4.rotateZ(i,i,-r.angle),i}}return r.glCoordMatrix}function Wt(t,i,o,s){const r=[t,i,o,1];o?e.ab.vec4.transformMat4(r,r,s):si(r,r,s);const a=r[3];return r[0]/=a,r[1]/=a,r[2]/=a,r}function $t(e,t){return Math.min(.5+e/t*.5,1.5)}function Xt(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function Kt(t,i,o,s,r,a,n,l,c,h){const u=o.transform,d=s?t.textSizeData:t.iconSizeData,_=e.bp(d,o.transform.zoom),p="globe"===u.projection.name,f=[256/o.width*2+1,256/o.height*2+1],m=s?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;m.clear();let g=null;p&&(g=s?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const v=t.lineVertexArray,y=s?t.text.placedSymbolArray:t.icon.placedSymbolArray,x=o.transform.width/o.transform.height;let b,w=!1;for(let s=0;s<y.length;s++){const p=y.get(s),{numGlyphs:T,writingMode:E}=p;if(E!==e.bq.vertical||w||b===e.bq.horizontal||(w=!0),b=E,(p.hidden||E===e.bq.vertical)&&!w){oi(T,m);continue}w=!1;const S=new e.P(p.tileAnchorX,p.tileAnchorY);let{x:C,y:I,z:R}=u.projection.projectTilePoint(S.x,S.y,h.canonical);if(c){const[e,t,i]=c(S);C+=e,I+=t,R+=i;}const D=[C,I,R,1];if(e.ab.vec4.transformMat4(D,D,i),!Xt(D,f)){oi(T,m);continue}const L=D[3],A=$t(o.transform.getCameraToCenterDistance(u.projection),L),z=e.br(d,_,p),P=n?z/A:z*A,M=Wt(C,I,R,r);if(M[3]<=0){oi(T,m);continue}let O={};const F=n?null:c,k=Qt(p,P,!1,l,i,r,a,t.glyphOffsetArray,v,m,g,M,S,O,x,F,u.projection,h,n);w=k.useVertical,F&&k.needsFlipping&&(O={}),(k.notEnoughRoom||w||k.needsFlipping&&Qt(p,P,!0,l,i,r,a,t.glyphOffsetArray,v,m,g,M,S,O,x,F,u.projection,h,n).notEnoughRoom)&&oi(T,m);}s?(t.text.dynamicLayoutVertexBuffer.updateData(m),g&&t.text.globeExtVertexBuffer&&t.text.globeExtVertexBuffer.updateData(g)):(t.icon.dynamicLayoutVertexBuffer.updateData(m),g&&t.icon.globeExtVertexBuffer&&t.icon.globeExtVertexBuffer.updateData(g));}function Yt(e,t,i,o,s,r,a,n,l,c,h,u,d,_,p,f){const{lineStartIndex:m,glyphStartIndex:g,segment:v}=n,y=g+n.numGlyphs,x=m+n.lineLength,b=t.getoffsetX(g),w=t.getoffsetX(y-1),T=ii(e*b,i,o,s,r,a,v,m,x,l,c,h,u,d,!0,_,p,f);if(!T)return null;const E=ii(e*w,i,o,s,r,a,v,m,x,l,c,h,u,d,!0,_,p,f);return E?{first:T,last:E}:null}function Jt(t,i,o,s){return t===e.bq.horizontal&&Math.abs(s)>Math.abs(o)?{useVertical:!0}:t===e.bq.vertical?s>0?{needsFlipping:!0}:null:i!==Gt.unknown&&function(e,t){return 0===e||Math.abs(t/e)>Vt}(o,s)?i===Gt.flipRequired?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function Qt(t,i,o,s,r,a,n,l,c,h,u,d,_,p,f,m,g,v,y){const x=i/24,b=t.lineOffsetX*x,w=t.lineOffsetY*x,{lineStartIndex:T,glyphStartIndex:E,numGlyphs:S,segment:C,writingMode:I,flipState:R}=t,D=T+t.lineLength,L=t=>{if(u){const[i,o,s]=t.up,r=h.length;e.bs(u,r+0,i,o,s),e.bs(u,r+1,i,o,s),e.bs(u,r+2,i,o,s),e.bs(u,r+3,i,o,s);}const[i,o,s]=t.point;e.bt(h,i,o,s,t.angle);};if(S>1){const e=Yt(x,l,b,w,o,d,_,t,c,a,p,m,!1,g,v,y);if(!e)return {notEnoughRoom:!0};if(s&&!o){let[i,o,s]=e.first.point,[r,a,l]=e.last.point;[i,o]=Wt(i,o,s,n),[r,a]=Wt(r,a,l,n);const c=Jt(I,R,(r-i)*f,a-o);if(t.flipState=c&&c.needsFlipping?Gt.flipRequired:Gt.flipNotRequired,c)return c}L(e.first);for(let e=E+1;e<E+S-1;e++){const t=ii(x*l.getoffsetX(e),b,w,o,d,_,C,T,D,c,a,p,m,!1,!1,g,v,y);if(!t)return h.length-=4*(e-E),{notEnoughRoom:!0};L(t);}L(e.last);}else {if(s&&!o){const i=Wt(_.x,_.y,0,r),o=T+C+1,s=new e.P(c.getx(o),c.gety(o)),a=Wt(s.x,s.y,0,r),n=a[3]>0?a:ti(_,s,i,1,r,void 0,g,v.canonical),l=Jt(I,R,(n[0]-i[0])*f,n[1]-i[1]);if(t.flipState=l&&l.needsFlipping?Gt.flipRequired:Gt.flipNotRequired,l)return l}const i=ii(x*l.getoffsetX(E),b,w,o,d,_,C,T,D,c,a,p,m,!1,!1,g,v,y);if(!i)return {notEnoughRoom:!0};L(i);}return {}}function ei(e,t,i,o,s){const{x:r,y:a,z:n}=o.projectTilePoint(e.x,e.y,t);if(!s)return Wt(r,a,n,i);const[l,c,h]=s(e);return Wt(r+l,a+c,n+h,i)}function ti(t,i,o,s,r,a,n,l){const c=ei(t.sub(i)._unit()._add(t),l,r,n,a);return e.ab.vec3.sub(c,o,c),e.ab.vec3.normalize(c,c),e.ab.vec3.scaleAndAdd(c,o,c,s)}function ii(t,i,o,s,r,a,n,l,c,h,u,d,_,p,f,m,g,v){const y=s?t-i:t+i;let x=y>0?1:-1,b=0;s&&(x*=-1,b=Math.PI),x<0&&(b+=Math.PI);let w=l+n+(x>0?0:1)|0,T=r,E=r,S=0,C=0;const I=Math.abs(y),R=[],D=[];let L=a,A=L;const z=()=>ti(A,L,E,I-S+1,u,_,m,g.canonical);for(;S+C<=I;){if(w+=x,w<l||w>=c)return null;if(E=T,A=L,R.push(E),p&&D.push(A),L=new e.P(h.getx(w),h.gety(w)),T=d[w],!T){const e=ei(L,g.canonical,u,m,_);T=e[3]>0?d[w]=e:z();}S+=C,C=e.ab.vec3.distance(E,T);}f&&_&&(d[w]&&(T=z(),C=e.ab.vec3.distance(E,T)),d[w]=T);const P=(I-S)/C,M=L.sub(A)._mult(P)._add(A),O=e.ab.vec3.sub([],T,E),F=e.ab.vec3.scaleAndAdd([],E,O,P);let k=[0,0,1],B=O[0],N=O[1];if(v&&(k=m.upVector(g.canonical,M.x,M.y),0!==k[0]||0!==k[1]||1!==k[2])){const t=[k[2],0,-k[0]],i=e.ab.vec3.cross([],k,t);e.ab.vec3.normalize(t,t),e.ab.vec3.normalize(i,i),B=e.ab.vec3.dot(O,t),N=e.ab.vec3.dot(O,i);}if(o){const t=e.ab.vec3.cross([],k,O);e.ab.vec3.normalize(t,t),e.ab.vec3.scaleAndAdd(F,F,t,o*x);}const U=b+Math.atan2(N,B);return R.push(F),p&&D.push(M),{point:F,angle:U,path:R,tilePath:D,up:k}}function oi(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function si(e,t,i){const o=t[0],s=t[1];return e[0]=i[0]*o+i[4]*s+i[12],e[1]=i[1]*o+i[5]*s+i[13],e[3]=i[3]*o+i[7]*s+i[15],e}const ri=100;class ai{constructor(e,t,i=new jt(e.width+200,e.height+200,25),o=new jt(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+ri,this.screenBottomBoundary=e.height+ri,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(e,t,i,o,s,r,a,n){let l=i.projectedAnchorX,c=i.projectedAnchorY,h=i.projectedAnchorZ;const u=i.elevation,d=i.tileID,_=e.getProjection();if(u&&d){const[e,t,o]=_.upVector(d.canonical,i.tileAnchorX,i.tileAnchorY),s=_.upVectorScale(d.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*u*s,c+=t*u*s,h+=o*u*s;}const p=this.projectAndGetPerspectiveRatio(a,l,c,h,i.tileID,"globe"===_.name||!!u||this.transform.pitch>0,_),f=r*p.perspectiveRatio,m=(i.x1*t+o.x-i.padding)*f+p.point.x,g=(i.y1*t+o.y-i.padding)*f+p.point.y,v=(i.x2*t+o.x+i.padding)*f+p.point.x,y=(i.y2*t+o.y+i.padding)*f+p.point.y,x=p.perspectiveRatio<=.55||p.occluded;return !this.isInsideGrid(m,g,v,y)||!s&&this.grid.hitTest(m,g,v,y,n)||x?{box:[],offscreen:!1,occluded:p.occluded}:{box:[m,g,v,y],offscreen:this.isOffscreen(m,g,v,y),occluded:!1}}placeCollisionCircles(t,i,o,s,r,a,n,l,c,h,u,d,_,p,f){const m=[],g=this.transform.elevation,v=t.getProjection(),y=g?g.getAtTileOffsetFunc(f,this.transform.center.lat,this.transform.worldSize,v):null,x=new e.P(o.tileAnchorX,o.tileAnchorY);let{x:b,y:w,z:T}=v.projectTilePoint(x.x,x.y,f.canonical);if(y){const[e,t,i]=y(x);b+=e,w+=t,T+=i;}const E="globe"===v.name,S=this.projectAndGetPerspectiveRatio(n,b,w,T,f,E||!!g||this.transform.pitch>0,v),{perspectiveRatio:C}=S,I=(u?a/C:a*C)/e.bw,R=Wt(b,w,T,l),D=S.signedDistanceFromCamera>0?Yt(I,r,o.lineOffsetX*I,o.lineOffsetY*I,!1,R,x,o,s,l,{},g&&!u?y:null,u&&!!g,v,f,u):null;let L=!1,A=!1,z=!0;if(D&&!S.occluded){const t=.5*_*C+p,o=new e.P(-100,-100),s=new e.P(this.screenRightBoundary,this.screenBottomBoundary),r=new Ut,{first:a,last:n}=D,l=a.path.length;let u=[];for(let e=l-1;e>=1;e--)u.push(a.path[e]);for(let e=1;e<n.path.length;e++)u.push(n.path[e]);const f=2.5*t;c&&(u=u.map((([e,t,i],o)=>(y&&!E&&(i=y(o<l-1?a.tilePath[l-1-o]:n.tilePath[o-l+2])[2]),Wt(e,t,i,c)))),u.some((e=>e[3]<=0))&&(u=[]));let g=[];if(u.length>0){let t=1/0,i=-1/0,r=1/0,a=-1/0;for(const e of u)t=Math.min(t,e[0]),r=Math.min(r,e[1]),i=Math.max(i,e[0]),a=Math.max(a,e[1]);i>=o.x&&t<=s.x&&a>=o.y&&r<=s.y&&(g=[u.map((t=>new e.P(t[0],t[1])))],(t<o.x||i>s.x||r<o.y||a>s.y)&&(g=e.bu(g,o.x,o.y,s.x,s.y)));}for(const e of g){r.reset(e,.25*t);let o=0;o=r.length<=.5*t?1:Math.ceil(r.paddedLength/f)+1;for(let e=0;e<o;e++){const s=e/Math.max(o-1,1),a=r.lerp(s),n=a.x+ri,l=a.y+ri;m.push(n,l,t,0);const c=n-t,u=l-t,_=n+t,p=l+t;if(z=z&&this.isOffscreen(c,u,_,p),A=A||this.isInsideGrid(c,u,_,p),!i&&this.grid.hitTestCircle(n,l,t,d)&&(L=!0,!h))return {circles:[],offscreen:!1,collisionDetected:L,occluded:!1}}}}return {circles:!h&&L||!A?[]:m,offscreen:z,collisionDetected:L,occluded:S.occluded}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,s=1/0,r=-1/0,a=-1/0;for(const n of t){const t=new e.P(n.x+ri,n.y+ri);o=Math.min(o,t.x),s=Math.min(s,t.y),r=Math.max(r,t.x),a=Math.max(a,t.y),i.push(t);}const n=this.grid.query(o,s,r,a).concat(this.ignoredGrid.query(o,s,r,a)),l={},c={};for(const t of n){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const s=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.bv(i,s)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,s){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:s},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,s){const r=t?this.ignoredGrid:this.grid,a={bucketInstanceId:i,featureIndex:o,collisionGroupID:s};for(let t=0;t<e.length;t+=4)r.insertCircle(a,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,s,r,a,n){const l=[i,o,s,1];let c=!1;if(s||this.transform.pitch>0){if(e.ab.vec4.transformMat4(l,l,t),this.fogState&&r&&"globe"!==n.name){const t=function(t,i,o,s,r,a){const n=a.calculateFogTileMatrix(r),l=[i,o,s];return e.ab.vec3.transformMat4(l,l,n),ke(t,e.ab.vec3.length(l),a.pitch,a._fov)}(this.fogState,i,o,s,r.toUnwrapped(),this.transform);c=t>.9;}}else si(l,l,t);const h=l[3];return {point:new e.P((l[0]/h+1)/2*this.transform.width+ri,(-l[1]/h+1)/2*this.transform.height+ri),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(n)/h*.5,1.5),signedDistanceFromCamera:h,occluded:a&&l[2]>h||c}}isOffscreen(e,t,i,o){return i<ri||e>=this.screenRightBoundary||o<ri||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.ab.mat4.identity([]);return e.ab.mat4.translate(t,t,[-100,-100,0]),t}}function ni(t,i,o){const s=i.createTileMatrix(t,t.worldSize,o.toUnwrapped());return e.ab.mat4.multiply(new Float32Array(16),t.projMatrix,s)}function li(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const o=i.clone();return o.setProjection(t.projection),ni(o,t.getProjection(),e)}function ci(e,t,i){return t.name===i.projection.name?e.projMatrix:ni(i,t,e)}class hi{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class ui{constructor(e,t,i,o,s,r=!1){this.text=new hi(e?e.text:null,t,i,s),this.icon=new hi(e?e.icon:null,t,o,s),this.clipped=r;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class di{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class _i{constructor(){this.invProjMatrix=e.ab.mat4.create(),this.viewportMatrix=e.ab.mat4.create(),this.circles=[];}}class pi{constructor(e,t,i,o,s){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=s;}}class fi{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function mi(t,i,o,s,r){const{horizontalAlign:a,verticalAlign:n}=e.bD(t),l=-(a-.5)*i,c=-(n-.5)*o,h=e.bC(t,s);return new e.P(l+h[0]*r,c+h[1]*r)}function gi(t,i,o,s,r){const a=new e.P(t,i);return o&&a._rotate(s?r:-r),a}class vi{constructor(e,t,i,o,s,r){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new ai(this.transform,s),this.buildingIndex=r,this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new fi(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,s,r=1){const a=o.getBucket(i),n=o.latestFeatureIndex;if(!a||!n||i.fqid!==a.layerIds[0])return;const l=a.layers[0].layout,c=a.layers[0].paint,h=o.collisionBoxArray,u=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),d=o.tileSize/e.ag,_=o.tileID.toUnwrapped();this.transform.setProjection(a.projection);const p=(f=o.tileID,m=a.getProjection(),g=this.transform,m.name===this.projection?g.calculateProjMatrix(f.toUnwrapped()):ni(g,m,f));var f,m,g;const v="map"===l.get("text-pitch-alignment"),y="map"===l.get("text-rotation-alignment");i.compileFilter(i.options);const x=i.dynamicFilter(),b=i.dynamicFilterNeedsFeature(),w=this.transform.calculatePixelsToTileUnitsMatrix(o),T=Ht(p,o.tileID.canonical,v,y,this.transform,a.getProjection(),w);let E=null;if(v){const t=Zt(p,o.tileID.canonical,v,y,this.transform,a.getProjection(),w);E=e.ab.mat4.multiply([],this.transform.labelPlaneMatrix,t);}let S=null;x&&o.latestFeatureIndex&&(S={unwrappedTileID:_,dynamicFilter:x,dynamicFilterNeedsFeature:b}),this.retainedQueryData[a.bucketInstanceId]=new pi(a.bucketInstanceId,n,a.sourceLayerIndex,a.index,o.tileID);const[C,I]=a.layers[0].layout.get("text-size-scale-range"),R=e.aw(r,C,I),[D,L]=l.get("icon-size-scale-range"),A=e.aw(r,D,L),z={bucket:a,layout:l,paint:c,posMatrix:p,textLabelPlaneMatrix:T,labelToScreenMatrix:E,clippingData:S,scale:u,textPixelRatio:d,holdingForFade:o.holdingForFade(),collisionBoxArray:h,partiallyEvaluatedTextSize:e.bp(a.textSizeData,this.transform.zoom,R),partiallyEvaluatedIconSize:e.bp(a.iconSizeData,this.transform.zoom,A),collisionGroup:this.collisionGroups.get(a.sourceID),latestFeatureIndex:o.latestFeatureIndex};if(s)for(const e of a.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s,parameters:z});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:a.symbolInstances.length,parameters:z});}attemptAnchorPlacement(e,t,i,o,s,r,a,n,l,c,h,u,d,_,p,f,m,g){const{textOffset0:v,textOffset1:y,crossTileID:x}=u,b=[v,y],w=mi(e,i,o,b,s),T=this.collisionIndex.placeCollisionBox(_,s,t,gi(w.x,w.y,r,a,this.transform.angle),h,n,l,c.predicate);if(f){const e=_.getSymbolInstanceIconSize(g,this.transform.zoom,u.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(_,e,f,gi(w.x,w.y,r,a,this.transform.angle),h,n,l,c.predicate).box.length)return}if(T.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[x]&&this.prevPlacement.placements[x]&&this.prevPlacement.placements[x].text&&(t=this.prevPlacement.variableOffsets[x].anchor),this.variableOffsets[x]={textOffset:b,width:i,height:o,anchor:e,textScale:s,prevAnchor:t},this.markUsedJustification(_,e,u,p),_.allowVerticalPlacement&&(this.markUsedOrientation(_,p,u),this.placedOrientations[x]=p),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,i,o,s,r=1){const{bucket:a,layout:n,paint:l,posMatrix:c,textLabelPlaneMatrix:h,labelToScreenMatrix:u,clippingData:d,textPixelRatio:_,holdingForFade:p,collisionBoxArray:f,partiallyEvaluatedTextSize:m,partiallyEvaluatedIconSize:g,collisionGroup:v,latestFeatureIndex:y}=t.parameters,x=n.get("text-optional"),b=n.get("icon-optional"),w=n.get("text-allow-overlap"),T=n.get("icon-allow-overlap"),E="map"===n.get("text-rotation-alignment"),S="map"===n.get("text-pitch-alignment"),C=n.get("symbol-z-elevate"),I=l.get("symbol-z-offset"),R="sea"===n.get("symbol-elevation-reference"),[D,L]=n.get("text-size-scale-range"),[A,z]=n.get("icon-size-scale-range"),P=e.aw(r,D,L),M=e.aw(r,A,z);this.transform.setProjection(a.projection);let O=w&&(T||!a.hasIconData()||b),F=T&&(w||!a.hasTextData()||x);const k=!I.isConstant();!a.collisionArrays&&f&&a.deserializeCollisionBoxes(f),o&&s&&a.updateCollisionDebugBuffers(this.transform.zoom,f,P,M);const B=(t,s,l)=>{const{crossTileID:f,numVerticalGlyphVertices:C}=t;let D=null;if(d&&d.dynamicFilterNeedsFeature||k){const e=this.retainedQueryData[a.bucketInstanceId];D=y.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});}if(d&&!(0,d.dynamicFilter)({zoom:this.transform.zoom,pitch:this.transform.pitch},D,this.retainedQueryData[a.bucketInstanceId].tileID.canonical,new e.P(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(d.unwrappedTileID)))return this.placements[f]=new di(!1,!1,!1,!0),void i.add(f);const L=I.evaluate(D,{});if(i.has(f))return;if(p)return void(this.placements[f]=new di(!1,!1,!1));let A=!1,z=!1,P=!0,M=!1,B=!1,N=null,U={box:null,offscreen:null,occluded:null},j={box:null,offscreen:null,occluded:null},G=null,V=null,q=null,H=0,Z=0,W=0;l.textFeatureIndex?H=l.textFeatureIndex:t.useRuntimeCollisionCircles&&(H=t.featureIndex),l.verticalTextFeatureIndex&&(Z=l.verticalTextFeatureIndex);const $=e=>{e.tileID=this.retainedQueryData[a.bucketInstanceId].tileID;const i=this.transform.elevation;e.elevation=R?L:L+(i?i.getAtTileOffset(e.tileID,e.tileAnchorX,e.tileAnchorY):0),e.elevation+=t.zOffset;},X=l.textBox;if(X){$(X);const i=i=>{let o=e.bq.horizontal;if(a.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[f];e&&(this.placedOrientations[f]=e,o=e,this.markUsedOrientation(a,o,t));}return o},o=(t,i)=>{if(a.allowVerticalPlacement&&C>0&&l.verticalTextBox){for(const o of a.writingModes)if(o===e.bq.vertical?(U=i(),j=U):U=t(),U&&U.box&&U.box.length)break}else U=t();};if(n.get("text-variable-anchor")){let r=n.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[f]){const e=this.prevPlacement.variableOffsets[f];r.indexOf(e.anchor)>0&&(r=r.filter((t=>t!==e.anchor)),r.unshift(e.anchor));}const h=(e,i,o)=>{const n=a.getSymbolInstanceTextSize(m,t,this.transform.zoom,s),l=(e.x2-e.x1)*n+2*e.padding,h=(e.y2-e.y1)*n+2*e.padding,u=t.hasIconTextFit&&!T?i:null;u&&$(u);let d={box:[],offscreen:!1,occluded:!1};const p=w?2*r.length:r.length;for(let i=0;i<p;++i){const p=this.attemptAnchorPlacement(r[i%r.length],e,l,h,n,E,S,_,c,v,i>=r.length,t,s,a,o,u,m,g);if(p&&(d=p.placedGlyphBoxes,d&&d.box&&d.box.length)){A=!0,N=p.shift;break}}return d};o((()=>h(X,l.iconBox,e.bq.horizontal)),(()=>{const t=l.verticalTextBox;return t&&$(t),a.allowVerticalPlacement&&!(U&&U.box&&U.box.length)&&C>0&&t?h(t,l.verticalIconBox,e.bq.vertical):{box:null,offscreen:null,occluded:null}})),U&&(A=U.box,P=U.offscreen,M=U.occluded);const u=i(!(!U||!U.box));if(!A&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[f];e&&(this.variableOffsets[f]=e,this.markUsedJustification(a,e.anchor,t,u));}}else {const n=(i,o)=>{const n=a.getSymbolInstanceTextSize(m,t,this.transform.zoom,s,r),l=this.collisionIndex.placeCollisionBox(a,n,i,new e.P(0,0),w,_,c,v.predicate);return l&&l.box&&l.box.length&&(this.markUsedOrientation(a,o,t),this.placedOrientations[f]=o),l};o((()=>n(X,e.bq.horizontal)),(()=>{const t=l.verticalTextBox;return a.allowVerticalPlacement&&C>0&&t?($(t),n(t,e.bq.vertical)):{box:null,offscreen:null,occluded:null}})),i(!!(U&&U.box&&U.box.length));}}if(G=U,A=G&&G.box&&G.box.length>0,P=G&&G.offscreen,M=G&&G.occluded,t.useRuntimeCollisionCircles){const i=a.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex),s=e.br(a.textSizeData,m,i),r=n.get("text-padding");V=this.collisionIndex.placeCollisionCircles(a,w,i,a.lineVertexArray,a.glyphOffsetArray,s,c,h,u,o,S,v.predicate,t.collisionCircleDiameter*s/e.bw,r,this.retainedQueryData[a.bucketInstanceId].tileID),A=w||V.circles.length>0&&!V.collisionDetected,P=P&&V.offscreen,M=V.occluded;}if(l.iconFeatureIndex&&(W=l.iconFeatureIndex),l.iconBox){const i=i=>{$(i);const o=t.hasIconTextFit&&N?gi(N.x,N.y,E,S,this.transform.angle):new e.P(0,0),s=a.getSymbolInstanceIconSize(g,this.transform.zoom,t.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(a,s,i,o,T,_,c,v.predicate)};j&&j.box&&j.box.length&&l.verticalIconBox?(q=i(l.verticalIconBox),z=q.box.length>0):(q=i(l.iconBox),z=q.box.length>0),P=P&&q.offscreen,B=q.occluded;}const K=x||0===t.numHorizontalGlyphVertices&&0===C,Y=b||0===t.numIconVertices;if(K||Y?Y?K||(z=z&&A):A=z&&A:z=A=z&&A,A&&G&&G.box&&this.collisionIndex.insertCollisionBox(G.box,n.get("text-ignore-placement"),a.bucketInstanceId,j&&j.box&&Z?Z:H,v.ID),z&&q&&this.collisionIndex.insertCollisionBox(q.box,n.get("icon-ignore-placement"),a.bucketInstanceId,W,v.ID),V&&(A&&this.collisionIndex.insertCollisionCircles(V.circles,n.get("text-ignore-placement"),a.bucketInstanceId,H,v.ID),o)){const e=a.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new _i);for(let e=0;e<V.circles.length;e+=4)t.circles.push(V.circles[e+0]),t.circles.push(V.circles[e+1]),t.circles.push(V.circles[e+2]),t.circles.push(V.collisionDetected?1:0);}const J="globe"!==a.projection.name;O=O&&(J||!M),F=F&&(J||!B),this.placements[f]=new di(A||O,z||F,P||a.justReloaded),i.add(f);};if(C&&this.buildingIndex&&(this.buildingIndex.updateZOffset(a,this.retainedQueryData[a.bucketInstanceId].tileID),a.updateZOffset()),a.sortFeaturesByY){const t=a.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];B(a.symbolInstances.get(i),i,a.collisionArrays[i]);}a.hasAnyZOffset&&e.w(`${a.layerIds[0]} layer symbol-z-elevate: symbols are not sorted by elevation if symbol-z-order is evaluated to viewport-y`);}else if(a.hasAnyZOffset){const e=a.getSortedIndexesByZOffset();for(let t=0;t<e.length;++t){const i=e[t];B(a.symbolInstances.get(i),i,a.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)B(a.symbolInstances.get(e),e,a.collisionArrays[e]);if(o&&a.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[a.bucketInstanceId];e.ab.mat4.invert(t.invProjMatrix,c),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}a.justReloaded=!1;}markUsedJustification(t,i,o,s){const{leftJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:n,verticalPlacedTextSymbolIndex:l,crossTileID:c}=o,h=e.bB(i),u=s===e.bq.vertical?l:"left"===h?r:"center"===h?a:"right"===h?n:-1;r>=0&&(t.text.placedSymbolArray.get(r).crossTileID=u>=0&&r!==u?0:c),a>=0&&(t.text.placedSymbolArray.get(a).crossTileID=u>=0&&a!==u?0:c),n>=0&&(t.text.placedSymbolArray.get(n).crossTileID=u>=0&&n!==u?0:c),l>=0&&(t.text.placedSymbolArray.get(l).crossTileID=u>=0&&l!==u?0:c);}markUsedOrientation(t,i,o){const s=i===e.bq.horizontal||i===e.bq.horizontalOnly?i:0,r=i===e.bq.vertical?i:0,{leftJustifiedTextSymbolIndex:a,centerJustifiedTextSymbolIndex:n,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=o,h=t.text.placedSymbolArray;a>=0&&(h.get(a).placedOrientation=s),n>=0&&(h.get(n).placedOrientation=s),l>=0&&(h.get(l).placedOrientation=s),c>=0&&(h.get(c).placedOrientation=r);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,s=t?t.opacities:{},r=t?t.variableOffsets:{},a=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],r=s[e];r?(this.opacities[e]=new ui(r,o,t.text,t.icon,null,t.clipped),i=i||t.text!==r.text.placed||t.icon!==r.icon.placed):(this.opacities[e]=new ui(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in s){const t=s[e];if(!this.opacities[e]){const s=new ui(t,o,!1,!1);s.isHidden()||(this.opacities[e]=s,i=i||t.text.placed||t.icon.placed);}}for(const e in r)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=r[e]);for(const e in a)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=a[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t,i,o){const s=new Set;for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.fqid===t.layerIds[0]&&(this.updateBucketOpacities(t,s,r,r.collisionBoxArray,i,o,r.tileID,e.scope),t.layers[0].layout.get("symbol-z-elevate")&&this.buildingIndex&&(this.buildingIndex.updateZOffset(t,r.tileID),t.updateZOffset()));}}updateBucketOpacities(t,i,o,s,r,a,n,l){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const c=t.layers[0].layout,h=t.layers[0].paint,u=!!t.layers[0].dynamicFilter(),d=new ui(null,0,!1,!1,!0),_=c.get("text-allow-overlap"),p=c.get("icon-allow-overlap"),f=c.get("text-variable-anchor"),m="map"===c.get("text-rotation-alignment"),g="map"===c.get("text-pitch-alignment"),v=h.get("symbol-z-offset"),y="sea"===c.get("symbol-elevation-reference"),x=!v.isConstant(),b=new ui(null,0,_&&(p||!t.hasIconData()||c.get("icon-optional")),p&&(_||!t.hasTextData()||c.get("text-optional")),!0);!t.collisionArrays&&s&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(s);const w=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let T=0;a&&t.updateReplacement(n,a);for(let s=0;s<t.symbolInstances.length;s++){const c=t.symbolInstances.get(s),{numHorizontalGlyphVertices:h,numVerticalGlyphVertices:_,crossTileID:p,numIconVertices:E,tileAnchorX:S,tileAnchorY:C}=c;let I=null;const R=this.retainedQueryData[t.bucketInstanceId];x&&c&&R&&(I=o.latestFeatureIndex.loadFeature({featureIndex:c.featureIndex,bucketIndex:R.bucketIndex,sourceLayerIndex:R.sourceLayerIndex,layoutVertexArrayOffset:0}));const D=v.evaluate(I,{}),L=i.has(p);let A=this.opacities[p];L?A=d:A||(A=b,this.opacities[p]=A),i.add(p);const z=h>0||_>0,P=E>0,M=this.placedOrientations[p],O=M===e.bq.vertical,F=M===e.bq.horizontal||M===e.bq.horizontalOnly;!z&&!P||A.isHidden()||T++;let k=!1;if((z||P)&&a)for(const i of t.activeReplacements){if(e.bx(i,r,e.by.Symbol,l))continue;if(i.min.x>S||S>i.max.x||i.min.y>C||C>i.max.y)continue;const t=e.bz(S,C,n.canonical,i.footprintTileId.canonical);if(k=e.bA(t,i.footprint),k)break}if(z){const e=k?Ri:Ii(A.text);w(t.text,h,O?Ri:e),w(t.text,_,F?Ri:e);const i=A.text.isHidden(),{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:r,verticalPlacedTextSymbolIndex:a}=c,n=t.text.placedSymbolArray,l=i||O?1:0;o>=0&&(n.get(o).hidden=l),s>=0&&(n.get(s).hidden=l),r>=0&&(n.get(r).hidden=l),a>=0&&(n.get(a).hidden=i||F?1:0);const u=this.variableOffsets[p];u&&this.markUsedJustification(t,u.anchor,c,M);const d=this.placedOrientations[p];d&&(this.markUsedJustification(t,"left",c,d),this.markUsedOrientation(t,d,c));}if(P){const e=k?Ri:Ii(A.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:o}=c,s=t.icon.placedSymbolArray,r=A.icon.isHidden()?1:0;i>=0&&(w(t.icon,E,O?Ri:e),s.get(i).hidden=r),o>=0&&(w(t.icon,c.numVerticalIconVertices,F?Ri:e),s.get(o).hidden=r);}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[s];if(i){let o=new e.P(0,0),s=!0;if(i.textBox||i.verticalTextBox){if(f){const e=this.variableOffsets[p];e?(o=mi(e.anchor,e.width,e.height,e.textOffset,e.textScale),m&&o._rotate(g?this.transform.angle:-this.transform.angle)):s=!1;}u&&(s=!A.clipped),i.textBox&&yi(t.textCollisionBox.collisionVertexArray,A.text.placed,!s||O,D,y,o.x,o.y),i.verticalTextBox&&yi(t.textCollisionBox.collisionVertexArray,A.text.placed,!s||F,D,y,o.x,o.y);}const r=s&&Boolean(!F&&i.verticalIconBox);i.iconBox&&yi(t.iconCollisionBox.collisionVertexArray,A.icon.placed,r,D,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0),i.verticalIconBox&&yi(t.iconCollisionBox.collisionVertexArray,A.icon.placed,!r,D,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0);}}}if(t.fullyClipped=0===T,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function yi(e,t,i,o,s,r,a){e.emplaceBack(t?1:0,i?1:0,r||0,a||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,a||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,a||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,a||0,o,s?1:0);}const xi=Math.pow(2,25),bi=Math.pow(2,24),wi=Math.pow(2,17),Ti=Math.pow(2,16),Ei=Math.pow(2,9),Si=Math.pow(2,8),Ci=Math.pow(2,1);function Ii(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*xi+t*bi+i*wi+t*Ti+i*Ei+t*Si+i*Ci+t}const Ri=0;class Di{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[];}continuePlacement(e,t,i,o,s,r){const a=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(a,o,e[this._currentTileIndex],this._sortAcrossTiles,r),this._currentTileIndex++,s())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,a.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<a.length;){const e=a[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart,r),this._currentPartIndex++,s())return !0}return !1}}class Li{constructor(e,t,i,o,s,r,a,n,l){this.placement=new vi(e,s,r,a,n,l),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o,s,r){const a=e.q.now(),n=()=>{const t=e.q.now()-a;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const a=i[t[this._currentPlacementIndex]],l=this.placement.collisionIndex.transform.zoom;if("symbol"===a.type&&(!a.minzoom||a.minzoom<=l)&&(!a.maxzoom||a.maxzoom>l)){const t=a,i=t.layout.get("symbol-z-elevate"),l=void 0!==t.layout.get("symbol-sort-key").constantOr(1),c=t.layout.get("symbol-z-order"),h="viewport-y"===c||"auto"===c&&!("viewport-y"!==c&&l),u=t.layout.get("text-allow-overlap")||t.layout.get("icon-allow-overlap")||t.layout.get("text-ignore-placement")||t.layout.get("icon-ignore-placement"),d=h&&u,_=this._inProgressLayer=this._inProgressLayer||new Di(t),p=e.aC(a.source,a.scope);if(_.continuePlacement(i||d?s[p]:o[p],this.placement,this._showCollisionBoxes,a,n,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Ai=512/e.ag/2;class zi{constructor(t,i,o){this.tileID=t,this.bucketInstanceId=o,this.index=new e.bE(i.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const s=t.canonical.x*e.ag,r=t.canonical.y*e.ag;for(let e=0;e<i.length;e++){const{key:t,crossTileID:o,tileAnchorX:a,tileAnchorY:n}=i.get(e),l=Math.floor((s+a)*Ai),c=Math.floor((r+n)*Ai);this.index.add(l,c),this.keys.push(t),this.crossTileIDs.push(o);}this.index.finish();}findMatches(t,i,o){const s=this.tileID.canonical.z<i.canonical.z?1:Math.pow(2,this.tileID.canonical.z-i.canonical.z),r=Ai/Math.pow(2,i.canonical.z-this.tileID.canonical.z),a=i.canonical.x*e.ag,n=i.canonical.y*e.ag;for(let e=0;e<t.length;e++){const i=t.get(e);if(i.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:h}=i,u=Math.floor((a+c)*r),d=Math.floor((n+h)*r),_=this.index.range(u-s,d-s,u+s,d+s);for(const e of _){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!o.has(t)){o.add(t),i.crossTileID=t;break}}}}}class Pi{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Mi{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const s=i[e];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+t),o[s.tileID.key]=s;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const s=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in s){const r=s[i];r.tileID.isChildOf(e)&&r.findMatches(t.symbolInstances,e,o);}else {const r=s[e.scaledTo(Number(i)).key];r&&r.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const s=t.symbolInstances.get(e);s.crossTileID||(s.crossTileID=i.generate(),o.add(s.crossTileID));}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new zi(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i);}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const s in o)e[o[s].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[s]),delete o[s],t=!0);}return t}}class Oi{constructor(){this.layerIndexes={},this.crossTileIDs=new Pi,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let s=this.layerIndexes[e.fqid];void 0===s&&(s=this.layerIndexes[e.fqid]=new Mi);let r=!1;const a={};"globe"!==o.name&&s.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.fqid===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),s.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),a[t.bucketInstanceId]=!0);}return s.removeStaleBuckets(a)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const Fi=771;class ki{constructor(e,t,i,o){this.blendFunction=e,this.blendColor=t,this.mask=i,this.blendEquation=o;}}ki.Replace=[1,0,1,0],ki.disabled=new ki(ki.Replace,e.aj.transparent,[!1,!1,!1,!1]),ki.unblended=new ki(ki.Replace,e.aj.transparent,[!0,!0,!0,!0]),ki.alphaBlended=new ki([1,Fi,1,Fi],e.aj.transparent,[!0,!0,!0,!0]),ki.alphaBlendedNonPremultiplied=new ki([770,Fi,770,Fi],e.aj.transparent,[!0,!0,!0,!0]),ki.multiply=new ki([774,0,774,0],e.aj.transparent,[!0,!0,!0,!0]);class Bi{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Bi.ReadOnly=!1,Bi.ReadWrite=!0,Bi.disabled=new Bi(519,Bi.ReadOnly,[0,1]);const Ni=7680;class Ui{constructor(e,t,i,o,s,r){this.test=e,this.ref=t,this.mask=i,this.fail=o,this.depthFail=s,this.pass=r;}}Ui.disabled=new Ui({func:519,mask:0},0,0,Ni,Ni,Ni);const ji=1029,Gi=2305;class Vi{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}function qi(t,i){const o=e.bG(t,3);e.ab.mat4.fromQuat(t,i),e.bI(t,3,o);}function Hi(t,i){const o=e.ab.quat.identity([]);return e.ab.quat.rotateZ(o,o,-i),e.ab.quat.rotateX(o,o,-t),o}function Zi(t,i){const o=[t[0],t[1],0],s=[i[0],i[1],0];if(e.ab.vec3.length(o)>=1e-15){const t=e.ab.vec3.normalize([],o);e.ab.vec3.scale(s,t,e.ab.vec3.dot(s,t)),i[0]=s[0],i[1]=s[1];}const r=e.ab.vec3.cross([],i,t);if(e.ab.vec3.len(r)<1e-15)return null;const a=Math.atan2(-r[1],r[0]);return Hi(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),a)}Vi.disabled=new Vi(!1,ji,Gi),Vi.backCCW=new Vi(!0,ji,Gi),Vi.backCW=new Vi(!0,ji,2304),Vi.frontCW=new Vi(!0,1028,2304),Vi.frontCCW=new Vi(!0,1028,Gi);class Wi{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.aa?t:new e.aa(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.bF(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this.position,s=this._elevation?this._elevation.getAtPointOrZero(e.aa.fromLngLat(t)):0,r=e.aa.fromLngLat(t,s),a=[r.x-o.x,r.y-o.y,r.z-o.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=Zi(a,i);}setPitchBearing(t,i){this.orientation=Hi(e.ai(t),e.ai(-i));}}class $i{constructor(t,i){this._transform=e.ab.mat4.identity([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.aa(t[0],t[1],t[2])}get position(){const t=e.bG(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.bI(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.ab.quat.identity([]),t&&qi(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=Hi(e,t),qi(this._transform,this._orientation);}forward(){const t=e.bG(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.bG(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.bG(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.ab.mat4.invert(o,this.getWorldToCamera(t,i)),o}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(t,i,o){const s=this.position;e.ab.vec3.scale(s,s,-t);const r=new Float64Array(16);return e.ab.mat4.fromScaling(r,[o,o,o]),e.ab.mat4.translate(r,r,s),r[10]*=i,r}getWorldToCamera(t,i){const o=new Float64Array(16),s=new Float64Array(4),r=this.position;return e.ab.quat.conjugate(s,this._orientation),e.ab.vec3.scale(r,r,-t),e.ab.mat4.fromQuat(o,s),e.ab.mat4.translate(o,o,r),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,s){const r=new Float64Array(16);return e.ab.mat4.perspective(r,t,i,o,s),r}getCameraToClipOrthographic(t,i,o,s,r,a){const n=new Float64Array(16);return e.ab.mat4.ortho(n,t,i,o,s,r,a),n}getDistanceToElevation(t,i=!1){const o=0===t?0:e.bH(t,i?e.aS(this.position[1]):this.position[1]),s=this.forward();return (o-this.position[2])/s[2]}clone(){return new $i([...this.position],[...this.orientation])}}const Xi={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,LUT:10,ShadowMap0:11};class Ki{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.af(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.af(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.af(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.af(t.right,i.right,o)),this}getCenter(t,i){const o=e.aw((this.left+t-this.right)/2,0,t),s=e.aw((this.top+i-this.bottom)/2,0,i);return new e.P(o,s)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Ki(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}const Yi=(e,t,i)=>(1-i)*e+i*t,Ji=e=>e*e*e*e*e;class Qi{constructor(t,i,o,s,r,a,n){this.tileSize=512,this._renderWorldCopies=void 0===r||r,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=o??0,this._maxPitch=s??60,this.setProjection(a),this.setMaxBounds(n),this.width=0,this.height=0,this._center=new e.bO(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new Ki,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._expandedProjMatrixCache={},this._distanceTileDataCache={},this._camera=new $i,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._tileCoverLift=0,this.freezeTileCoverage=!1,this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1;}clone(){const e=new Qi(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection());return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._orthographicProjectionAtLowPitch=this._orthographicProjectionAtLowPitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e}get isOrthographic(){return "globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<15}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}get depthOcclusionForSymbolsAndCircles(){return "globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.ay(this.projection,["name","center","parallels"])}setProjection(t){this.projectionOptions=t||{name:"mercator"};const i=this.projection?this.getProjection():void 0;this.projection=e.bP(this.projectionOptions);const o=this.getProjection(),s=!e.bn(i,o);return s&&this._calcMatrices(),this.mercatorFromTransition=!1,s}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.bP({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.bH(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return e.bF(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.ab.mat2.create(),e.ab.mat2.rotate(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.aw(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.ai(t),this._calcMatrices());}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}get tileCoverLift(){return this._tileCoverLift}set tileCoverLift(e){this._tileCoverLift!==e&&(this._tileCoverLift=e);}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize));}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let s=0,r=0;for(let a=0;a<i.length;a++){const n=new e.P(i[a][0]*this.width,o+i[a][1]*(this.height-o)),l=t.pointCoordinate(n);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);s+=l[3]*c,r+=c;}return 0===r?NaN:s/r}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),s=this._mercatorZfromZoom(this._maxZoom),r=Math.max(o-i,s);this._setZoom(this._zoomFromMercatorZ(r));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const s=e.ab.vec3.length(e.ab.vec3.sub([],this._camera.position,o));return e.aw(this._zoomFromMercatorZ(s),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.ab.quat.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.ab.vec3.exactEquals(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new Wi;return i.position=new e.aa(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.ab.quat.length(t))return !1;e.ab.quat.normalize(t,t);const i=e.ab.vec3.transformQuat([],[0,0,-1],t),o=e.ab.vec3.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const s=Zi(i,o);return !!s&&(this._camera.orientation=s,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,s=this.cameraToCenterDistance;t[2]=e.aw(t[2],s/o,s/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.bQ(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.P(0,0)),s=this.pointCoordinate(new e.P(this.width,0)),r=this.pointCoordinate(new e.P(this.width,this.height)),a=this.pointCoordinate(new e.P(0,this.height)),n=Math.floor(Math.min(o.x,s.x,r.x,a.x)),l=Math.floor(Math.max(o.x,s.x,r.x,a.x)),c=1;for(let o=n-c;o<=l+c;o++)0!==o&&i.push(new e.bQ(o,t));}return i}isLODDisabled(e){return (!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCover(t,i,o){let s=[];const r=void 0!==o,a=!r;if(a&&this.zoom<i)return s;if(r&&0===o[0]&&0===o[1])return s;const n=new Set,l=(t,i,o,r,a)=>{const l=e.c5(i,t,o,r,a);n.has(l)||(s.push(new e.aG(t,i,o,r,a)),n.add(l));};for(let e=0;e<t.length;e++){const s=t[e];if(a&&s.canonical.z!==i)continue;const n=s.canonical,c=s.overscaledZ,h=s.wrap,u=1<<n.z,d=n.x+1<u,_=n.x>0,p=n.y+1<u,f=n.y>0,m=s.wrap-(_?0:1),g=s.wrap+(d?0:1),v=_?n.x-1:u-1,y=d?n.x+1:0;if(r)o[0]<0?(l(c,g,n.z,y,n.y),o[1]<0&&p&&(l(c,h,n.z,n.x,n.y+1),l(c,g,n.z,y,n.y+1)),o[1]>0&&f&&(l(c,h,n.z,n.x,n.y-1),l(c,g,n.z,y,n.y-1))):o[0]>0?(l(c,m,n.z,v,n.y),o[1]<0&&p&&(l(c,h,n.z,n.x,n.y+1),l(c,m,n.z,v,n.y+1)),o[1]>0&&f&&(l(c,h,n.z,n.x,n.y-1),l(c,m,n.z,v,n.y-1))):o[1]<0&&p?l(c,h,n.z,n.x,n.y+1):f&&l(c,h,n.z,n.x,n.y-1);else {const e=s.visibleQuadrants;1&e&&(l(c,m,n.z,v,n.y),f&&(l(c,h,n.z,n.x,n.y-1),l(c,m,n.z,v,n.y-1))),2&e&&(l(c,g,n.z,y,n.y),f&&(l(c,h,n.z,n.x,n.y-1),l(c,g,n.z,y,n.y-1))),4&e&&(l(c,m,n.z,v,n.y),p&&(l(c,h,n.z,n.x,n.y+1),l(c,m,n.z,v,n.y+1))),8&e&&(l(c,g,n.z,y,n.y),p&&(l(c,h,n.z,n.x,n.y+1),l(c,g,n.z,y,n.y+1)));}}const c=[];for(const e of s)s.some((t=>e.isChildOf(t)))||c.push(e);if(s=c.filter((e=>!t.some((t=>!!(e.overscaledZ<i&&t.isChildOf(e))||e.equals(t)||e.isChildOf(t))))),a){const e=1<<i,t="globe"===this.projection.name?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),o=[e*t.x,e*t.y],r=4,a=r*r;s=s.filter((e=>{const t=e.canonical.x+.5-o[0],i=e.canonical.y+.5-o[1];return t*t+i*i<a}));}return s}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,s=this.elevation&&this.elevation.exaggeration(),r=s&&!t.isTerrainDEM,a="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const n=this.locationCoordinate(this.center),l=this.center.lat,c=1<<i,h=[c*n.x,c*n.y,0],u="globe"===this.projection.name,d=!u,_=e.bR.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,d),p=u?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=c*e.bH(1,this.center.lat),m=this._camera.position[2]/e.bH(1,this.center.lat),g=[c*p.x,c*p.y,m*(d?1:f)],v=u||s,y=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),x=this.isLODDisabled(!0)?i:0;let b;if(this._elevation&&t.isTerrainDEM)b=1e4*this._elevation.exaggeration();else if(this._elevation){const e=this._elevation.getMinMaxForVisibleTiles();b=e?e.max:this._centerAltitude;}else b=this._centerAltitude;const w=t.isTerrainDEM?-b:this._elevation?this._elevation.getMinElevationBelowMSL():0,T=this.projection.isReprojectedInTileSpace?e.bS(this):1,E=t=>{const i=1/4e4,o=new e.aa(t.x+i,t.y,t.z),s=new e.aa(t.x,t.y+i,t.z),r=t.toLngLat(),a=o.toLngLat(),n=s.toLngLat(),l=this.locationCoordinate(r),c=this.locationCoordinate(a),h=this.locationCoordinate(n),u=Math.hypot(c.x-l.x,c.y-l.y),d=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(u*d)*T/i},S=t=>{const i=b,o=w;return {aabb:e.bV(this,c,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},C=[];let I=[];const R=i,D=t.reparseOverscaled?o:i,L=(m-this._centerAltitude)*f,A=e=>{if(!this._elevation||!e.tileID||!a)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=P(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},z=(e,t)=>{if(.707*t<e)return 1;const i=t/e;return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)},P=t=>{if(t.zoom<x)return !0;if(t.zoom===R)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(g),s=t.aabb.distanceY(g);let n=L,c=1;if(u){n=t.aabb.distanceZ(g);const i=Math.pow(2,t.zoom),o=e.aS((t.y+1)/i),s=e.aS(t.y/i),r=Math.min(Math.max(l,o),s),a=e.c9(r)/e.c9(l);if(c=r===l?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,a/this._mercatorScaleRatio),this.zoom<=e.c6&&t.zoom===R-1&&a>=.9)return !0}else if(r&&(n=t.aabb.distanceZ(g)*f),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=E(new e.aa((t.x+.5)/i,(t.y+.5)/i));c=o>.85?1:o;}if(!a){const e=Math.sqrt(i*i+s*s+n*n);let o=(1<<R-t.zoom)*y*c;return o*=z(Math.max(n,L),e),e<o}let d=Number.MAX_VALUE,_=0;const p=t.aabb.getCorners(),m=[];for(const t of p){e.ab.vec3.sub(m,t,g),u||(r?m[2]*=f:m[2]=L);const i=e.ab.vec3.dot(m,this._camera.forward());i<d&&(d=i,_=Math.abs(m[2]));}let v=(1<<R-t.zoom)*y*c;if(v*=z(Math.max(_,L),d),d<v)return !0;const b=t.aabb.closestPoint(h);return b[0]===h[0]&&b[1]===h[1]};if(this.renderWorldCopies)for(let e=1;e<=3;e++)C.push(S(-e)),C.push(S(e));for(C.push(S(0));C.length>0;){const o=C.pop(),s=o.x,n=o.y;let l=o.fullyVisible;const d=()=>"globe"===this.projection.name&&(0===o.y||o.y===(1<<o.zoom)-1);if(!l){let t=v?o.aabb.intersects(_):o.aabb.intersectsFlat(_);if(0===t&&d()){const i=new e.bT(o.zoom,s,n);t=e.bU(this,c,i,!0).intersects(_);}if(0===t)continue;l=2===t;}if(o.zoom!==R&&P(o))for(let t=0;t<4;t++){const i=(s<<1)+t%2,h=(n<<1)+(t>>1),d={aabb:a?o.aabb.quadrant(t):e.bV(this,c,o.zoom+1,i,h,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:h,wrap:o.wrap,fullyVisible:l,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};r&&!u&&(d.tileID=new e.aG(o.zoom+1===R?D:o.zoom+1,o.wrap,o.zoom+1,i,h),A(d)),C.push(d);}else {const r=o.zoom===R?D:o.zoom;if(t.minzoom&&t.minzoom>r)continue;let a=0;if(!l){let i=v?o.aabb.intersectsPrecise(_):o.aabb.intersectsPreciseFlat(_);if(0===i&&d()){const t=new e.bT(o.zoom,s,n);i=e.bU(this,c,t,!0).intersectsPrecise(_);}if(0===i)continue;if(t.calculateQuadrantVisibility)if(_.containsPoint(o.aabb.center))a=15;else for(let e=0;e<4;e++)0!==o.aabb.quadrant(e).intersects(_)&&(a|=1<<e);}const u=h[0]-(.5+s+(o.wrap<<o.zoom))*(1<<i-o.zoom),p=h[1]-.5-n,f=o.tileID?o.tileID:new e.aG(r,o.wrap,o.zoom,s,n);t.calculateQuadrantVisibility&&(f.visibleQuadrants=a),I.push({tileID:f,distanceSq:u*u+p*p});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();I=I.filter((s=>{const r=[0,0,0,1],a=[e.ag,e.ag,0,1],n=this.calculateFogTileMatrix(s.tileID.toUnwrapped());e.ab.vec4.transformMat4(r,r,n),e.ab.vec4.transformMat4(a,a,n);const l=e.ab.vec4.min([],r,a),c=e.ab.vec4.max([],r,a),h=e.bW(l,c);if(0===h)return !0;let u=!1;const d=this._elevation;if(d&&h>i&&0!==o){const i=this.calculateProjMatrix(s.tileID.toUnwrapped());let r;t.isTerrainDEM||(r=d.getMinMaxForTile(s.tileID)),r||(r={min:w,max:b});const a=e.c7(this.rotation),n=[a[0]*e.ag,a[1]*e.ag,r.max];e.ab.vec3.transformMat4(n,n,i),u=(1-n[1])*this.height*.5<o;}return h<i||u}));}return I.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.aw(t.lat,-e.bX,e.bX),o=this.projection.project(t.lng,i);return new e.P(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.bH(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,s;const r=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-r.x)/e,s=(i.y-r.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(r);o=e.x-t.x,s=e.y-t.y;}const a=this.locationCoordinate(t);this.setLocation(new e.aa(a.x-o,a.y-s));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this.projection.locationPoint(this,e,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(t,i){const o=i?e.bH(i,t.lat):void 0,s=this.projection.project(t.lng,t.lat);return new e.aa(s.x,s.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,s=[t.x,t.y,0,1],r=[t.x,t.y,1,1];e.ab.vec4.transformMat4(s,s,this.pixelMatrixInverse),e.ab.vec4.transformMat4(r,r,this.pixelMatrixInverse);const a=r[3];e.ab.vec4.scale(s,s,1/s[3]),e.ab.vec4.scale(r,r,1/a);const n=s[2],l=r[2];return {p0:s,p1:r,t:n===l?0:(o-n)/(l-n)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.ab.vec4.transformMat4(i,i,this.pixelMatrixInverse),e.ab.vec4.transformMat4(o,o,this.pixelMatrixInverse),e.ab.vec4.scale(i,i,1/i[3]),e.ab.vec4.scale(o,o,1/o[3]),i[2]=e.bH(i[2],this._center.lat)*this.worldSize,o[2]=e.bH(o[2],this._center.lat)*this.worldSize,e.ab.vec4.scale(i,i,1/this.worldSize),e.ab.vec4.scale(o,o,1/this.worldSize),new e.aq([i[0],i[1],i[2]],e.ab.vec3.normalize([],e.ab.vec3.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:s}=t,r=e.bH(i[2],this._center.lat),a=e.bH(o[2],this._center.lat);return new e.aa(e.af(i[0],o[0],s)/this.worldSize,e.af(i[1],o[1],s)/this.worldSize,e.af(r,a,s))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t){if(!this.elevation)return this.pointCoordinate(t);let i=this.projection.pointCoordinate3D(this,t.x,t.y);if(i)return new e.aa(i[0],i[1],i[2]);let o=0,s=this.horizonLineFromTop();if(t.y>s)return this.pointCoordinate(t);const r=.02*s,a=t.clone();for(let t=0;t<10&&s-o>r;t++){a.y=e.af(o,s,.66);const t=this.projection.pointCoordinate3D(this,a.x,a.y);t?(s=a.y,i=t):o=a.y;}return i?new e.aa(i[0],i[1],i[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(t){if(t.y<0||t.y>this.height||t.x<0||t.x>this.width)return !1;if(this.elevation||this.zoom>=e.bY)return !this.isPointAboveHorizon(t);const i=this.pointCoordinate(t);return i.y>=0&&i.y<=1}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,s=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.ab.vec4.transformMat4(s,s,this.pixelMatrix),s[3]>0?new e.P(s[0]/s[3],s[1]/s[3]):new e.P(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,s=this.width-this._edgeInsets.right,r=this.pointLocation3D(new e.P(i,t)),a=this.pointLocation3D(new e.P(s,t)),n=this.pointLocation3D(new e.P(s,o)),l=this.pointLocation3D(new e.P(i,o));let c=Math.min(r.lng,a.lng,n.lng,l.lng),h=Math.max(r.lng,a.lng,n.lng,l.lng),u=Math.min(r.lat,a.lat,n.lat,l.lat),d=Math.max(r.lat,a.lat,n.lat,l.lat);const _=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(t,i,o,s,r)=>{const a=(t+o)/2,n=(i+s)/2,l=new e.P(a,n),{lng:m,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-m,u-g,m-h,g-d);c=Math.min(c,m),h=Math.max(h,m),u=Math.min(u,g),d=Math.max(d,g),(r<p||v>_)&&(f(t,i,a,n,r+1),f(a,n,o,s,r+1));};if(f(i,t,s,t,1),f(s,t,s,o,1),f(s,o,i,o,1),f(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.bZ(this);t?(d=90,h=180,c=-180):i&&(u=-90,h=180,c=-180);}return new e.az(new e.bO(c,u),new e.bO(h,d))}_getBoundsRectangular(t,i){const{top:o,left:s}=this._edgeInsets,r=this.height-this._edgeInsets.bottom,a=this.width-this._edgeInsets.right,n=new e.P(s,o),l=new e.P(a,o),c=new e.P(a,r),h=new e.P(s,r);let u=this.pointCoordinate(n,t),d=this.pointCoordinate(l,t);const _=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return u.y>1&&d.y>=0?u=new e.aa((1-p.y)/f(p,u)+p.x,1):u.y<0&&d.y<=1&&(u=new e.aa(-p.y/f(p,u)+p.x,0)),d.y>1&&u.y>=0?d=new e.aa((1-_.y)/f(_,d)+_.x,1):d.y<0&&u.y<=1&&(d=new e.aa(-_.y/f(_,d)+_.x,0)),(new e.az).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(d)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(_))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.bX,this.maxLat=e.bX,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.at(this.minLng)*this.tileSize,this.worldMaxX=e.at(this.maxLng)*this.tileSize,this.worldMinY=e.aA(this.maxLat)*this.tileSize,this.worldMaxY=e.aA(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const s=t.canonical,r=1/this.height,a=this.cameraWorldSize,n=a/this.zoomScale(s.z),l=(s.x+Math.pow(2,s.z)*t.wrap)*n,c=s.y*n,h=this.point;h.x*=a/this.worldSize,h.y*=a/this.worldSize;const u=this.angle,d=Math.sin(-u),_=-Math.cos(-u);return o[i]={bearing:[d,_],center:[(h.x-l)*r,(h.y-c)*r],scale:n/e.ag*r},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const s=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.ab.mat4.multiply(s,this.worldToFogMatrix,s),o[i]=new Float32Array(s),o[i]}calculateProjMatrix(t,i=!1,o=!1){const s=t.key;let r;if(r=o?this._expandedProjMatrixCache:i?this._alignedProjMatrixCache:this._projMatrixCache,r[s])return r[s];const a=this.calculatePosMatrix(t,this.worldSize);let n;return n=this.projection.isReprojectedInTileSpace?this.mercatorMatrix:o?this.expandedFarZProjMatrix:i?this.alignedProjMatrix:this.projMatrix,e.ab.mat4.multiply(a,n,a),r[s]=new Float32Array(a),r[s]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const s=e.b_(t,this);return o[i]=s,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.ab.mat4.fromScaling([],[t,t,t]);return e.ab.mat4.multiply(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.bH(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),s=this._camera.forward(),r=e.bH(1,this._center.lat);o[2]/=r,s[2]/=r,e.ab.vec3.normalize(s,s);const a=t.raycast(o,s,t.exaggeration());if(a){const t=e.ab.vec3.scaleAndAdd([],o,s,a),i=new e.aa(t[0],t[1],e.bH(t[2],e.aS(t[1]))),n=(i.z+e.ab.vec3.length([i.x-o[0],i.y-o[1],i.z-o[2]*r]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(n),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.bH(1,this._center.lat)*this.worldSize,s=this._computeCameraPosition(o),r=i.getAtPointOrZero(new e.aa(...s)),a=this.pixelsPerMeter/this.worldSize*r,n=this._minimumHeightOverTerrain(),l=s[2]-a;if(l<=n)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[s[0],s[1],t.z-s[2]],o=e.ab.vec3.length(i);i[2]-=(n-l)/this._pixelsPerMercatorPixel;const r=e.ab.vec3.length(i);if(0===r)return;e.ab.vec3.scale(i,i,o/r*this._pixelsPerMercatorPixel),this._camera.position=[s[0],s[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.aw(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.aw(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:s}=this.point;let r=0,a=o,n=s;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,u=this.worldMaxY*this.scale;if(s-c<h&&(n=h+c),s+c>u&&(n=u-c),u-h<this.height&&(r=Math.max(r,this.height/(u-h)),n=(u+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;a=(o+i+this.worldSize)%this.worldSize-i,a-l<e&&(a=e+l),a+l>t&&(a=t-l),t-e<this.width&&(r=Math.max(r,this.width/(t-e)),a=(t+e)/2);}a===o&&n===s||(this.center=this.unproject(new e.P(a,n))),r&&(this.zoom+=this.scaleZoom(r)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i="globe"===this.projection.name,o=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.bH(1,this.center.lat)/e.bH(1,e.c8));const s=e.b$(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,s),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const r="meters"===this.projection.zAxisUnit?o:1,a=this._camera.getWorldToCamera(this.worldSize,r);let n;const l=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(l[8]=2*-t.x/this.width,l[9]=2*t.y/this.height,this.isOrthographic){let e=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),i=e*this.aspect,o=-i,s=-e;i-=t.x,o-=t.x,e+=t.y,s+=t.y,n=this._camera.getCameraToClipOrthographic(o,i,s,e,this._nearZ,this._farZ),((e,t,i,o)=>{for(let s=0;s<16;s++)e[s]=Yi(t[s],i[s],o);})(n,n,l,Ji(this.pitch>=15?1:this.pitch/15));}else n=l;const c=e.ab.mat4.mul([],l,a);let h=e.ab.mat4.mul([],n,a);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.ab.mat4.identity([]);e.ab.mat4.translate(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.ab.mat4.multiply(i,i,e.c0(this)),e.ab.mat4.translate(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.ab.mat4.multiply(h,h,i),e.ab.mat4.multiply(c,c,i),this.inverseAdjustmentMatrix=e.c1(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];if(this.mercatorMatrix=e.ab.mat4.scale([],h,[this.worldSize,this.worldSize,this.worldSize/r,1]),this.projMatrix=h,this.invProjMatrix=e.ab.mat4.invert(new Float64Array(16),this.projMatrix),i){const i=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,1/0);i[8]=2*-t.x/this.width,i[9]=2*t.y/this.height,this.expandedFarZProjMatrix=e.ab.mat4.mul([],i,a);}else this.expandedFarZProjMatrix=this.projMatrix;const u=e.ab.mat4.invert([],n);this.frustumCorners=e.c2.fromInvProjectionMatrix(u,this.horizonLineFromTop(),this.height),this.cameraFrustum=e.bR.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!i);const d=new Float32Array(16);e.ab.mat4.identity(d),e.ab.mat4.scale(d,d,[1,-1,1]),e.ab.mat4.rotateX(d,d,this._pitch),e.ab.mat4.rotateZ(d,d,this.angle);const _=e.ab.mat4.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=e.ab.mat4.clone(_);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;_[8]=2*-t.x/this.width,_[9]=2*(t.y+p)/this.height,this.skyboxMatrix=e.ab.mat4.multiply(d,_,d);const f=this.point,m=f.x,g=f.y,v=this.width%2/2,y=this.height%2/2,x=Math.cos(this.angle),b=Math.sin(this.angle),w=m-Math.round(m)+x*v+b*y,T=g-Math.round(g)+x*y+b*v,E=new Float64Array(h);if(e.ab.mat4.translate(E,E,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=E,h=e.ab.mat4.create(),e.ab.mat4.scale(h,h,[this.width/2,-this.height/2,1]),e.ab.mat4.translate(h,h,[1,-1,0]),this.labelPlaneMatrix=h,h=e.ab.mat4.create(),e.ab.mat4.scale(h,h,[1,-1,1]),e.ab.mat4.translate(h,h,[-1,-1,0]),e.ab.mat4.scale(h,h,[2/this.width,2/this.height,1]),this.glCoordMatrix=h,this.pixelMatrix=e.ab.mat4.multiply(new Float64Array(16),this.labelPlaneMatrix,c),this._calcFogMatrices(),this._distanceTileDataCache={},h=e.ab.mat4.invert(new Float64Array(16),this.pixelMatrix),!h)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=h,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.c3(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e.ab.vec3.transformMat4(t,t,a),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=h;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={},this._expandedProjMatrixCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,s=1/this.height/this._pixelsPerMercatorPixel,r=[t,t,i];e.ab.vec3.scale(r,r,s),e.ab.vec3.scale(o,o,-1),e.ab.vec3.multiply(o,o,r);const a=e.ab.mat4.create();e.ab.mat4.translate(a,a,o),e.ab.mat4.scale(a,a,r),this.mercatorFogMatrix=a,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,s);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,s=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*s,o.y/this.worldSize-i[1]*s,e/this.worldSize*this._centerAltitude-i[2]*s]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],s=t[2];let r=1;this.projection.wrap&&(this.center=this.center.wrap()),s>0&&(r=Math.min((i-o)/s,1)),this._camera.position=e.ab.vec3.scaleAndAdd([],this._camera.position,t,r),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:s}=this._camera.getPitchBearing(),r=e.bH(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,a=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.ai(this._maxPitch)),n=Math.max((t[2]-r)/Math.cos(o),a),l=this._zoomFromMercatorZ(n);e.ab.vec3.scaleAndAdd(t,t,i,n),this._pitch=e.aw(o,e.ai(this.minPitch),e.ai(this.maxPitch)),this.angle=e.bF(s,-Math.PI,Math.PI),this._setZoom(e.aw(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.aa(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min(null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom,this._maxZoom)+4;return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.bY,s=0,r=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),a=this.tileSize*Math.pow(2,e),n=this.getCameraToCenterDistance(this.projection,e,a),l=this.scaleZoom(n/(t*this.tileSize)),c=Math.abs(e-l);c<r&&(r=c,s=e),e<l?i=e:o=e;}return s}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.w("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),s=Math.max(t.x,i.x),r=Math.min(t.y,i.y),a=Math.max(t.y,i.y);if(r<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const n=[new e.P(o,r),new e.P(s,a),new e.P(o,a),new e.P(s,r)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of n){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.c4(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.P(0,0),new e.P(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.ab.vec3.length(e.ab.vec3.sub([],this._camera.position,t)),s=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(s)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],s){const r=[t,i,o,1];e.ab.vec4.transformMat4(r,r,s);const a=r[3]=Math.max(r[3],1e-6);return r[0]/=a,r[1]/=a,r[2]/=a,r}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.P(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}}getCameraToCenterDistance(t,i=this.zoom,o=this.worldSize){const s=e.b$(t,i,this.width,this.height,1024),r=t.pixelSpaceConversion(this.center.lat,o,s);let a=.5/Math.tan(.5*this._fov)*this.height*r;return this.isOrthographic&&(a=Yi(1,a,Ji(this.pitch>=15?1:this.pitch/15))),a}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.ab.mat4.multiply(t,t,this.globeMatrix),t}getFrustum(t){return e.bR.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,"meters"===this.projection.zAxisUnit)}}const eo=(t,i)=>{if(i>0&&t.terrain&&e.w("Cutoff is currently disabled on terrain"),i<=0||t.terrain)return {shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,1]}};const o=t.transform,s=Math.max(Math.abs(o._zoom-(t.minCutoffZoom-1)),1),r=o.isLODDisabled(!1)?e.ac(60,45,o.pitch):e.ac(30,15,o.pitch),a=o._farZ-o._nearZ,n=i*o.height,l=((1-(c=r))*o.cameraToCenterDistance+c*(o._farZ+n))*s;var c;return {shouldRenderCutoff:r<1,uniformValues:{u_cutoff_params:[o._nearZ,o._farZ,(l-o._nearZ)/a,(l-n-o._nearZ)/a]}}},to={cascadeCount:2,normalOffset:3,shadowMapResolution:2048};class io{constructor(e,t){this.aabb=e,this.lastCascade=t;}}class oo{add(e,t){const i=this.receivers[e.key];void 0!==i?(i.aabb.min[0]=Math.min(i.aabb.min[0],t.min[0]),i.aabb.min[1]=Math.min(i.aabb.min[1],t.min[1]),i.aabb.min[2]=Math.min(i.aabb.min[2],t.min[2]),i.aabb.max[0]=Math.max(i.aabb.max[0],t.max[0]),i.aabb.max[1]=Math.max(i.aabb.max[1],t.max[1]),i.aabb.max[2]=Math.max(i.aabb.max[2],t.max[2])):this.receivers[e.key]=new io(t,null);}clear(){this.receivers={};}get(e){return this.receivers[e.key]}computeRequiredCascades(t,i,o){const s=e.cd.fromPoints(t.points);let r=0;for(const t in this.receivers){const a=this.receivers[t];if(!a)continue;if(!s.intersectsAabb(a.aabb))continue;a.aabb.min=s.closestPoint(a.aabb.min),a.aabb.max=s.closestPoint(a.aabb.max);const n=a.aabb.getCorners();for(let t=0;t<o.length;t++){let s=!0;for(const r of n){const a=[r[0]*i,r[1]*i,r[2]];if(e.ab.vec3.transformMat4(a,a,o[t].matrix),a[0]<-1||a[0]>1||a[1]<-1||a[1]>1){s=!1;break}}if(a.lastCascade=t,r=Math.max(r,t),s)break}}return r+1}}class so{constructor(e){this.painter=e,this._enabled=!1,this._shadowLayerCount=0,this._numCascadesToRender=0,this._cascades=[],this._groundShadowTiles=[],this._receivers=new oo,this._depthMode=new Bi(e.context.gl.LEQUAL,Bi.ReadWrite,[0,1]),this._uniformValues={u_light_matrix_0:new Float32Array(16),u_light_matrix_1:new Float32Array(16),u_shadow_intensity:0,u_fade_range:[0,0],u_shadow_normal_offset:[1,1,1],u_shadow_texel_size:1,u_shadow_map_resolution:1,u_shadow_direction:[0,0,1],u_shadow_bias:[36e-5,.0012,.012],u_shadowmap_0:0,u_shadowmap_1:0},this._forceDisable=!1,this.useNormalOffset=!1,e.tp.registerParameter(this,["Shadows"],"_forceDisable",{label:"forceDisable"},(()=>{this.painter.style.map.triggerRepaint();})),e.tp.registerParameter(to,["Shadows"],"cascadeCount",{min:1,max:2,step:1}),e.tp.registerParameter(to,["Shadows"],"normalOffset",{min:0,max:10,step:.05}),e.tp.registerParameter(to,["Shadows"],"shadowMapResolution",{min:32,max:2048,step:32}),e.tp.registerBinding(this,["Shadows"],"_numCascadesToRender",{readonly:!0,label:"numCascadesToRender"});}destroy(){for(const e of this._cascades)e.texture.destroy(),e.framebuffer.destroy();this._cascades=[];}updateShadowParameters(t,i){const o=this.painter;if(this._enabled=!1,this._shadowLayerCount=0,this._receivers.clear(),!i||!i.properties)return;const s=i.properties.get("shadow-intensity");if(!i.shadowsEnabled()||s<=0)return;if(this._shadowLayerCount=o.style.order.reduce(((e,i)=>{const s=o.style._mergedLayers[i];return e+(s.hasShadowPass()&&!s.isHidden(t.zoom)?1:0)}),0),this._enabled=this._shadowLayerCount>0,!this.enabled)return;const r=o.context,a=to.shadowMapResolution,n=to.shadowMapResolution;if(0===this._cascades.length||to.shadowMapResolution!==this._cascades[0].texture.size[0]){this._cascades=[];for(let t=0;t<to.cascadeCount;++t){const t=o._shadowMapDebug,i=r.gl,s=r.createFramebuffer(a,n,t,"texture"),l=new e.T(r,{width:a,height:n,data:null},i.DEPTH_COMPONENT16);if(s.depthAttachment.set(l.texture),t){const t=new e.T(r,{width:a,height:n,data:null},i.RGBA8);s.colorAttachment.set(t.texture);}this._cascades.push({framebuffer:s,texture:l,matrix:[],far:0,boundingSphereRadius:0,frustum:new e.bR,scale:0});}}this.shadowDirection=ao(i);let l=0;if(t.elevation){const e=t.elevation,i=[1e4,-1e4];e.visibleDemTiles.filter((e=>e.dem)).forEach((e=>{const t=e.dem.tree;i[0]=Math.min(i[0],t.minimums[0]),i[1]=Math.max(i[1],t.maximums[0]);})),1e4!==i[0]&&(l=(i[1]-i[0])*e.exaggeration());}const c=1.5*t.cameraToCenterDistance,h=3*c,u=new Float64Array(16);for(let i=0;i<this._cascades.length;++i){const o=this._cascades[i];let s=t.height/50,r=1;1===to.cascadeCount?r=h:0===i?r=c:(s=c,r=h);const[a,n]=lo(t,this.shadowDirection,s,r,to.shadowMapResolution,l);o.scale=t.scale,o.matrix=a,o.boundingSphereRadius=n,e.ab.mat4.invert(u,o.matrix),o.frustum=e.bR.fromInvProjectionMatrix(u,1,0,!0),o.far=r;}const d=this._cascades.length-1;this._uniformValues.u_fade_range=[.75*this._cascades[d].far,this._cascades[d].far],this._uniformValues.u_shadow_intensity=s,this._uniformValues.u_shadow_direction=[this.shadowDirection[0],this.shadowDirection[1],this.shadowDirection[2]],this._uniformValues.u_shadow_texel_size=1/to.shadowMapResolution,this._uniformValues.u_shadow_map_resolution=to.shadowMapResolution,this._uniformValues.u_shadowmap_0=Xi.ShadowMap0,this._uniformValues.u_shadowmap_1=Xi.ShadowMap0+1,this._groundShadowTiles=o.transform.coveringTiles({tileSize:512,renderWorldCopies:!0});const _=o.transform.elevation;for(const e of this._groundShadowTiles){let t={min:0,max:0};if(_){const i=_.getMinMaxForTile(e);i&&(t=i);}this.addShadowReceiver(e.toUnwrapped(),t.min,t.max);}}get enabled(){return this._enabled&&!this._forceDisable}set enabled(e){this._enabled=e;}drawShadowPass(t,i){if(!this.enabled)return;const o=this.painter,s=o.context;this._numCascadesToRender=this._receivers.computeRequiredCascades(o.transform.getFrustum(0),o.transform.worldSize,this._cascades),s.viewport.set([0,0,to.shadowMapResolution,to.shadowMapResolution]);for(let r=0;r<this._numCascadesToRender;++r){o.currentShadowCascade=r,s.bindFramebuffer.set(this._cascades[r].framebuffer.framebuffer),s.clear({color:e.aj.white,depth:1});for(const e of t.order){const s=t._mergedLayers[e];if(!s.hasShadowPass()||s.isHidden(o.transform.zoom))continue;const r=t.getLayerSourceCache(s),a=r?i[r.id]:void 0;("model"===s.type||a&&a.length)&&o.renderLayer(o,r,s,a);}}o.currentShadowCascade=0;}drawGroundShadows(){if(!this.enabled)return;const e=this.painter,t=e.style,i=e.context,o=t.directionalLight,s=t.ambientLight;if(!o||!s)return;const r=[],a=eo(e,e.longestCutoffRange);a.shouldRenderCutoff&&r.push("RENDER_CUTOFF"),r.push("RENDER_SHADOWS","DEPTH_TEXTURE"),this.useNormalOffset&&r.push("NORMAL_OFFSET");const n=no(t,o,s),l=new Bi(i.gl.LEQUAL,Bi.ReadOnly,e.depthRangeFor3D);for(const t of this._groundShadowTiles){const o=t.toUnwrapped(),s=e.isTileAffectedByFog(t),c=e.getOrCreateProgram("groundShadow",{defines:r,overrideFog:s});this.setupShadows(o,c),e.uploadCommonUniforms(i,c,o,null,a);const h={u_matrix:e.transform.calculateProjMatrix(o),u_ground_shadow_factor:n};c.draw(e,i.gl.TRIANGLES,l,Ui.disabled,ki.multiply,Vi.disabled,h,"ground_shadow",e.tileExtentBuffer,e.quadTriangleIndexBuffer,e.tileExtentSegments,{},e.transform.zoom,null,null);}}getShadowPassColorMode(){return this.painter._shadowMapDebug?ki.unblended:ki.disabled}getShadowPassDepthMode(){return this._depthMode}getShadowCastingLayerCount(){return this._shadowLayerCount}calculateShadowPassMatrixFromTile(t){const i=this.painter.transform,o=i.calculatePosMatrix(t,i.worldSize);return e.ab.mat4.multiply(o,this._cascades[this.painter.currentShadowCascade].matrix,o),Float32Array.from(o)}calculateShadowPassMatrixFromMatrix(t){return e.ab.mat4.multiply(t,this._cascades[this.painter.currentShadowCascade].matrix,t),Float32Array.from(t)}setupShadows(t,i,o,s=0){if(!this.enabled)return;const r=this.painter.transform,a=this.painter.context,n=a.gl,l=this._uniformValues,c=new Float64Array(16),h=r.calculatePosMatrix(t,r.worldSize);for(let t=0;t<this._cascades.length;t++)e.ab.mat4.multiply(c,this._cascades[t].matrix,h),l[0===t?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(c),a.activeTexture.set(n.TEXTURE0+Xi.ShadowMap0+t),this._cascades[t].texture.bind(n.NEAREST,n.CLAMP_TO_EDGE);if(this.useNormalOffset=!!o,this.useNormalOffset){const i=e.cc(t.canonical),a=2/r.tileSize*e.ag/to.shadowMapResolution,n=a*this._cascades[0].boundingSphereRadius,c=a*this._cascades[this._cascades.length-1].boundingSphereRadius,h=("vector-tile"===o?1:3)/Math.pow(2,s-t.canonical.z-(1-r.zoom+Math.floor(r.zoom)));l.u_shadow_normal_offset=[i,n*h,c*h],l.u_shadow_bias=[6e-5,.0012,.012];}else l.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(a,l);}setupShadowsFromMatrix(t,i,o=!1){if(!this.enabled)return;const s=this.painter.context,r=s.gl,a=this._uniformValues,n=new Float64Array(16);for(let i=0;i<to.cascadeCount;i++)e.ab.mat4.multiply(n,this._cascades[i].matrix,t),a[0===i?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(n),s.activeTexture.set(r.TEXTURE0+Xi.ShadowMap0+i),this._cascades[i].texture.bind(r.NEAREST,r.CLAMP_TO_EDGE);if(this.useNormalOffset=o,o){const e=to.normalOffset;a.u_shadow_normal_offset=[1,e,e],a.u_shadow_bias=[6e-5,.0012,.012];}else a.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(s,a);}getShadowUniformValues(){return this._uniformValues}getCurrentCascadeFrustum(){return this._cascades[this.painter.currentShadowCascade].frustum}computeSimplifiedTileShadowVolume(t,i,o,s){if(s[2]>=0)return {};const r=function(t,i,o){const s=o/(1<<t.canonical.z);return new e.cd([t.canonical.x*s+t.wrap*o,t.canonical.y*s+t.wrap*o,0],[(t.canonical.x+1)*s+t.wrap*o,(t.canonical.y+1)*s+t.wrap*o,i])}(t,i,o).getCorners(),a=i/-s[2];s[0]<0?(e.ab.vec3.add(r[0],r[0],[s[0]*a,0,0]),e.ab.vec3.add(r[3],r[3],[s[0]*a,0,0])):s[0]>0&&(e.ab.vec3.add(r[1],r[1],[s[0]*a,0,0]),e.ab.vec3.add(r[2],r[2],[s[0]*a,0,0])),s[1]<0?(e.ab.vec3.add(r[0],r[0],[0,s[1]*a,0]),e.ab.vec3.add(r[1],r[1],[0,s[1]*a,0])):s[1]>0&&(e.ab.vec3.add(r[2],r[2],[0,s[1]*a,0]),e.ab.vec3.add(r[3],r[3],[0,s[1]*a,0]));const n={};return n.vertices=r,n.planes=[ro(r[1],r[0],r[4]),ro(r[2],r[1],r[5]),ro(r[3],r[2],r[6]),ro(r[0],r[3],r[7])],n}addShadowReceiver(t,i,o){this._receivers.add(t,e.cd.fromTileIdAndHeight(t,i,o));}getMaxCascadeForTile(e){const t=this._receivers.get(e);return t&&t.lastCascade?t.lastCascade:0}}function ro(t,i,o){const s=e.ab.vec3.sub([],o,i),r=e.ab.vec3.sub([],t,i),a=e.ab.vec3.cross([],s,r),n=e.ab.vec3.length(a);return 0===n?[0,0,1,0]:(e.ab.vec3.scale(a,a,1/n),[a[0],a[1],a[2],-e.ab.vec3.dot(a,i)])}function ao(t){const i=t.properties.get("direction"),o=e.cb(i.x,i.y,i.z);o[2]=e.aw(o[2],0,75);const s=e.ce([o[0],o[1],o[2]]);return e.ab.vec3.fromValues(s.x,s.y,s.z)}function no(t,i,o){const s="none"===i.properties.get("color-use-theme"),r=i.properties.get("color"),a=i.properties.get("intensity"),n=i.properties.get("direction"),l=[n.x,n.y,n.z],c="none"===o.properties.get("color-use-theme"),h=o.properties.get("color"),u=o.properties.get("intensity"),d=Math.max(e.ab.vec3.dot([0,0,1],l),0),_=[0,0,0];e.ab.vec3.scale(_,h.toRenderColor(c?null:t.getLut(i.scope)).toArray01Linear().slice(0,3),u);const p=[0,0,0];return e.ab.vec3.scale(p,r.toRenderColor(s?null:t.getLut(o.scope)).toArray01Linear().slice(0,3),d*a),e.cf([_[0]>0?_[0]/(_[0]+p[0]):0,_[1]>0?_[1]/(_[1]+p[1]):0,_[2]>0?_[2]/(_[2]+p[2]):0])}function lo(t,i,o,s,r,a){const n=t.zoom,l=t.scale,c=t.worldSize,h=1/c,u=t.aspect,d=Math.sqrt(1+u*u)*Math.tan(.5*t.fovX),_=d*d,p=s-o,f=s+o;let m,g;_>p/f?(m=s,g=s*d):(m=.5*f*(1+_),g=.5*Math.sqrt(p*p+2*(s*s+o*o)*_+f*f*_*_));const v=t.projection.pixelsPerMeter(t.center.lat,c),y=t._camera.getCameraToWorldMercator(),x=[0,0,-m*h];e.ab.vec3.transformMat4(x,x,y);let b=g*h;const w=t._edgeInsets;if(!(0===w.left&&0===w.top&&0===w.right&&0===w.bottom||w.left===w.right&&w.top===w.bottom)){const i=t._camera.getWorldToCamera(t.worldSize,"meters"===t.projection.zAxisUnit?v:1),r=t._camera.getCameraToClipPerspective(t._fov,t.width/t.height,o,s);r[8]=2*-t.centerOffset.x/t.width,r[9]=2*t.centerOffset.y/t.height;const a=new Float64Array(16);e.ab.mat4.mul(a,r,i);const h=new Float64Array(16);e.ab.mat4.invert(h,a);const u=e.bR.fromInvProjectionMatrix(h,c,n,!0);for(const i of u.points){const o=((T=i)[0]/=l,T[1]/=l,T[2]=e.bH(T[2],t._center.lat),T);b=Math.max(b,e.ab.vec3.len(e.ab.vec3.subtract([],x,o)));}}var T;b*=r/(r-1);const E=Math.acos(i[2]),S=Math.atan2(-i[0],-i[1]),C=new $i;C.position=x,C.setPitchBearing(E,S);const I=C.getWorldToCamera(c,v),R=b*c,D=Math.min(t._mercatorZfromZoom(17)*c*-2,-2*R),L=C.getCameraToClipOrthographic(-R,R,-R,R,D,(R+a*v)/i[2]),A=new Float64Array(16);e.ab.mat4.multiply(A,L,I);const z=e.ab.vec3.fromValues(Math.floor(1e6*x[0])/1e6*c,Math.floor(1e6*x[1])/1e6*c,0),P=.5*r,M=[0,0,0];e.ab.vec3.transformMat4(M,z,A),e.ab.vec3.scale(M,M,P);const O=[Math.floor(M[0]),Math.floor(M[1]),Math.floor(M[2])],F=[0,0,0];e.ab.vec3.sub(F,M,O),e.ab.vec3.scale(F,F,-1/P);const k=new Float64Array(16);return e.ab.mat4.identity(k),e.ab.mat4.translate(k,k,F),e.ab.mat4.multiply(A,k,A),[A,R]}class co extends e.E{constructor(e){super(),this.requestManager=e,this.models={"":{}},this.modelUris={"":{}},this.numModelsLoading={};}loadModel(t,i){return e.aM(this.requestManager.transformRequest(i,e.R.Model).url).then((i=>{if(!i)return;const o=e.aN(i),s=new e.aO(t,void 0,void 0,o);return s.computeBoundsAndApplyParent(),s})).catch((o=>{if(o&&404===o.status)return null;this.fire(new e.y(new Error(`Could not load model ${t} from ${i}: ${o.message}`)));}))}load(t,i,o={keepNumReferences:!1}){this.models[i]||(this.models[i]={});const s=Object.keys(t);this.numModelsLoading[i]=(this.numModelsLoading[i]||0)+s.length;const r=[];for(const e of s)r.push(this.loadModel(e,t[e]));Promise.allSettled(r).then((t=>{for(let e=0;e<t.length;e++){const{status:r,value:a}=t[e];if("fulfilled"===r&&a){const t=this.models[i][s[e]];this.models[i][s[e]]={model:a,numReferences:o.keepNumReferences&&t?t.numReferences:1};}}this.numModelsLoading[i]-=s.length,this.fire(new e.z("data",{dataType:"style"}));})).catch((t=>{this.fire(new e.y(new Error(`Could not load models: ${t.message}`)));}));}isLoaded(){for(const e in this.numModelsLoading)if(this.numModelsLoading[e]>0)return !1;return !0}hasModel(e,t){return !!this.getModel(e,t)}getModel(e,t){return this.models[t]||(this.models[t]={}),this.models[t][e]?this.models[t][e].model:void 0}addModel(e,t,i){this.models[i]||(this.models[i]={}),this.modelUris[i]||(this.modelUris[i]={}),this.hasModel(e,i)&&this.models[i][e].numReferences++,this.modelUris[i][e]=this.requestManager.normalizeModelURL(t),this.load({[e]:this.modelUris[i][e]},i);}addModels(e,t){this.models[t]||(this.models[t]={}),this.modelUris[t]||(this.modelUris[t]={});const i=this.modelUris[t];for(const o in e)this.models[t][o]={},i[o]=this.requestManager.normalizeModelURL(e[o]);this.load(i,t,{keepNumReferences:!0});}reloadModels(e){this.load(this.modelUris[e],e);}addModelsFromBucket(e,t){this.models[t]||(this.models[t]={}),this.modelUris[t]||(this.modelUris[t]={});const i={};for(const o of e)this.hasModel(o,t)?this.models[t][o].numReferences++:(this.modelUris[t][o]=this.requestManager.normalizeModelURL(o),i[o]=this.modelUris[t][o]);this.load(i,t);}removeModel(e,t){if(this.models[t]&&this.models[t][e]&&(this.models[t][e].numReferences--,0===this.models[t][e].numReferences)){const i=this.models[t][e].model;delete this.models[t][e],delete this.modelUris[t][e],i.destroy();}}listModels(e){return this.models[e]||(this.models[e]={}),Object.keys(this.models[e])}upload(e,t){this.models[t]||(this.models[t]={});for(const i in this.models[t])this.models[t][i].model&&this.models[t][i].model.upload(e.context);}}const ho=new e.a5({data:new e.a6(e.a3.colorTheme.data)}),uo={"mbx-indoor-active-floorplans":{default:["literal",[]]},"mbx-indoor-underground":{default:["literal",!1]},"mbx-indoor-loaded-levels":{default:["literal",[]]},"mbx-indoor-level-height":{default:["literal",{}]},"mbx-indoor-level-base":{default:["literal",{}]},"mbx-indoor-level-selected":{default:["literal",{}]},"mbx-indoor-level-overlapped":{default:["literal",{}]}};function _o(e){return e=e||{},Object.assign(e,uo)}class po extends e.E{constructor(t){super(),this.mergeFloors=!0,this._scope=void 0,this._queryFeatureSetId=void 0,this._buildingEntryFeatureSetId=void 0,this._selectedFloorplan=void 0,this._indoorData=void 0,this._selectedLevel=void 0,this._floorplanStates={},e.aP(["_onLoad","_onMove","_checkFloorplanVisible"],this),this._map=t,this._checkFloorplanVisible(!0),this._map.on("load",this._onLoad),this._map.on("move",this._onMove);}destroy(){this._map.indoor.off("load",this._onLoad),this._map.indoor.off("move",this._onMove),this._map=void 0;}_onLoad(){this._map.style.forEachFragmentStyle((t=>{t.stylesheet.indoor&&(this._queryFeatureSetId?this.fire(new e.y(new Error("Multiple indoor map styles detected, simultaneous usage is not allowed currently."))):(this._queryFeatureSetId=t.stylesheet.indoor.floorplanFeaturesetId,this._buildingEntryFeatureSetId=t.stylesheet.indoor.buildingFeaturesetId,this._scope=t.scope));})),this._queryFeatureSetId&&this._buildingEntryFeatureSetId&&this._map.addInteraction("mbx-indoor-buildingclick",{type:"click",target:{featuresetId:this._buildingEntryFeatureSetId,importId:this._scope},handler:e=>(e.feature&&e.feature.properties.floorplan&&this.selectFloorplan(e.feature.properties.floorplan),!0)}),this._checkFloorplanVisible(!0);}_onMove(){this._checkFloorplanVisible(!1);}_checkFloorplanVisible(t){if(!this._queryFeatureSetId)return;if(!this._map.isStyleLoaded())return;if(this._map.transform.zoom<13)return;this._indoorData&&!function(e,t){const[i,o]=e,{center:s,radius:r}=t,[a,n]=s,l=Math.abs(i-a);return Math.sqrt((l>180?360-l:l)**2+(o-n)**2)<=r}([this._map.getCenter().lng,this._map.getCenter().lat],this._indoorData.circumCircle)&&(this._indoorData=void 0,this._selectedFloorplan=void 0,this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!1),this._map.setConfigProperty(this._scope,"mbx-indoor-active-floorplans",["literal",[]]),this.fire(new e.z("floorplangone")));const i={target:{featuresetId:this._queryFeatureSetId,importId:this._scope}},o=new e.P(this._map.transform.width/2,this._map.transform.height/2),s=[new e.P(0,0),new e.P(this._map.transform.width,this._map.transform.height)],r=this._map.queryRenderedFeatures(t?s:o,i);r.length>0&&(this._selectedFloorplan&&r[0].properties.id===this._selectedFloorplan.properties.id||(this._selectedFloorplan=r[0],this._floorplanSelected(!1)));}_floorplanSelected(t){this._indoorData=JSON.parse(this._selectedFloorplan.properties["indoor-data"]),this._indoorData.id=this._selectedFloorplan.properties.id,this._indoorData.circumCircle=function(e){const[[t,i],[o,s]]=e,r=(o-t+360)%360,a=r>180?360-r:r;return {center:[(t+a/2+360)%360,(i+s)/2],radius:Math.sqrt(a**2+(s-i)**2)/2}}(this._indoorData.extent),this._floorplanStates[this._indoorData.id]||(this._floorplanStates[this._indoorData.id]={});const i=this._floorplanStates[this._indoorData.id].selectedBuilding,o=this._floorplanStates[this._indoorData.id].selectedLevel;let s;if(this._map.setConfigProperty(this._scope,"mbx-indoor-active-floorplans",this._indoorData.floorplanIDs),this._selectedLevel)for(const e of this._indoorData.levels)e.id===this._selectedLevel.id&&(s=e.id);if(this.fire(new e.z("floorplanselected",{buildings:this._indoorData.buildings,levels:this._indoorData.levels,selectedLevelId:s})),i){const e=this._indoorData.buildings.find((e=>e.id===i));this._buildingSelected(e,!1);}else this._indoorData.buildings.length>0&&this._buildingSelected(this._indoorData.buildings[0],!1);if(o){const e=this._indoorData.levels.find((e=>e.id===o));this._updateLevels(e,t);}else t&&this._indoorData["default-levels"].length>0&&this.selectLevel(this._indoorData["default-levels"][0]);}_buildingSelected(t,i){i&&t&&t.extent&&this._map.fitBounds(t.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}),this._floorplanStates[this._indoorData.id].selectedBuilding=t?t.id:void 0;const o=this._indoorData.levels.filter((e=>t.levels.includes(e.id)));this.fire(new e.z("buildingselected",{buildingId:t.id,levels:o}));}_levelSelected(t){if("overview"===t)this._updateLevels(void 0,!0);else {const e=this._indoorData.levels.find((e=>e.id===t));this._updateLevels(e,!0);}this.fire(new e.z("levelselected",{levelId:"overview"===t?void 0:t}));}_updateLevels(e,t){if(!e)return this._map.setConfigProperty(this._scope,"mbx-indoor-loaded-levels",["literal",[]]),this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!1),this._floorplanStates[this._indoorData.id].selectedLevel=void 0,void(t&&this._indoorData.extent&&this._map.fitBounds(this._indoorData.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}));function i(e){const t=e.indexOf("/floor/");if(-1===t)return e;const i=t+7,o=e.indexOf("/",i);return -1===o?e.slice(i):e.slice(i,o)}this._selectedLevel=e,this._floorplanStates[this._indoorData.id].selectedLevel=e?e.id:void 0;const o=[],s={},r={},a={},n={};for(const t of this._indoorData.levels)if(o.push(t.id),s[t.id]=t.height,r[t.id]=t.base,e){if(this.mergeFloors){const o=i(e.id),s=i(t.id);a[t.id]=s===o?"true":"false";}else a[t.id]=t.id===e.id?"true":"false";n[t.id]=t.base<e.base?"true":"false";}else n[t.id]=!0;if(this._map.setConfigProperty(this._scope,"mbx-indoor-loaded-levels",["literal",o]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-height",["literal",s]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-base",["literal",r]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-selected",["literal",a]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-overlapped",["literal",n]),e&&(this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!!e.isUnderground),t&&e.extent)){const t=this._map.cameraForBounds(e.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}),i=this._map.getZoom(),o=t.zoom?Math.abs(i-t.zoom):0;this._map.fitBounds(e.extent,o>=1?{pitch:this._map.getPitch(),bearing:this._map.getBearing()}:{pitch:this._map.getPitch(),bearing:this._map.getBearing(),zoom:i});}}selectFloorplan(t){const i={target:{featuresetId:this._queryFeatureSetId,importId:this._scope}},o=[new e.P(0,0),new e.P(this._map.transform.width,this._map.transform.height)],s=this._map.queryRenderedFeatures(o,i);if(s.length>0)for(const e of s)if(JSON.parse(e.properties["indoor-data"]).floorplanIDs.includes(t)){this._selectedFloorplan=e,this._floorplanSelected(!0);break}}selectBuilding(e){const t=this._indoorData.buildings.find((t=>t.id===e));this._buildingSelected(t,!0);}selectLevel(e){this._levelSelected(e);}}function fo(t){if(!t.metadata||!t.metadata.content_area)return;const i=e.q.devicePixelRatio,{left:o,top:s,width:r,height:a}=t.metadata.content_area,n=o*i,l=s*i;return [n,l,n+r*i,l+a*i]}function mo(t){if(t)return t.map((([t,i])=>[t*e.q.devicePixelRatio,i*e.q.devicePixelRatio]))}const go=(e,t)=>Le(e,t&&t.filter((e=>"source.canvas"!==e.identifier))),vo=e.ay(zt,["addLayer","removeLayer","setLights","setPaintProperty","setLayoutProperty","setSlot","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setSnow","setRain","setProjection","setCamera","addImport","removeImport","updateImport"]),yo=e.ay(zt,["setCenter","setZoom","setBearing","setPitch"]),xo=new Set(["background","sky","slot","custom"]),bo={version:8,layers:[],sources:{}},wo={duration:300,delay:0};class To extends e.E{constructor(t,i={}){super(),this.map=t,this.scope=i.scope||"",this.globalId=null,this.fragments=[],this.importDepth=i.importDepth||0,this.importsCache=i.importsCache||new Map,this.resolvedImports=i.resolvedImports||new Set,this.transition=e.l({},wo),this._buildingIndex=new Dt(this),this.crossTileSymbolIndex=new Oi,this._mergedOrder=[],this._drapedFirstOrder=[],this._mergedLayers={},this._mergedSourceCaches={},this._mergedOtherSourceCaches={},this._mergedSymbolSourceCaches={},this._clipLayerPresent=!1,this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this._changes=i.styleChanges||new G,this.dispatcher=i.dispatcher?i.dispatcher:new e.D(e.ci(),this),i.imageManager?this.imageManager=i.imageManager:(this.imageManager=new q(this.map._spriteFormat),this.imageManager.setEventedParent(this)),this.imageManager.createScope(this.scope),this.glyphManager=i.glyphManager?i.glyphManager:new e.cj(t._requestManager,i.localFontFamily?e.ck.all:i.localIdeographFontFamily?e.ck.ideographs:e.ck.none,i.localFontFamily||i.localIdeographFontFamily),i.modelManager?this.modelManager=i.modelManager:(this.modelManager=new co(t._requestManager),this.modelManager.setEventedParent(this)),this._layers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this._loaded=!1,this._precompileDone=!1,this._shouldPrecompile=!1,this._availableImages=[],this._order=[],this._markersNeedUpdate=!1,this.options=i.configOptions?i.configOptions:new Map,this._configDependentLayers=i.configDependentLayers?i.configDependentLayers:new Set,this._config=i.config,this._styleColorTheme={lut:null,lutLoading:!1,lutLoadingCorrelationID:0,colorTheme:null,colorThemeOverride:i.colorThemeOverride},this._styleColorThemeForScope={},this._initialConfig=i.initialConfig,this.dispatcher.broadcast("setReferrer",e.cl());const o=this;this._rtlTextPluginCallback=To.registerForPluginStateChange((t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},((t,i)=>{if(e.cm(t),i&&i.every((e=>e)))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}}));})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getOwnSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}}));}load(e){return e?("string"==typeof e?this.loadURL(e):this.loadJSON(e),this):this}_getGlobalId(t){if(!t)return null;if("string"==typeof t){if(e.f(t))return t;const i=e.cn(t);if(!i.startsWith("http"))try{return new URL(i,location.href).toString()}catch(e){return i}return i}return `json://${e.co(JSON.stringify(t))}`}_diffStyle(t,i,o){this.globalId=this._getGlobalId(t);const s=(e,t)=>{try{t(null,this.setState(e,o));}catch(e){t(e,!1);}};if("string"==typeof t){const o=this.map._requestManager.normalizeStyleURL(t),r=this.map._requestManager.transformRequest(o,e.R.Style);e.n(r,((t,o)=>{t?this.fire(new e.y(t)):o&&s(o,i);}));}else "object"==typeof t&&s(t,i);}loadURL(t,i={}){this.fire(new e.z("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.f(t);this.globalId=this._getGlobalId(t),t=this.map._requestManager.normalizeStyleURL(t,i.accessToken),this.resolvedImports.add(t);const s=this.importsCache.get(t);if(s)return this._load(s,o);const r=this.map._requestManager.transformRequest(t,e.R.Style);this._request=e.n(r,((i,s)=>{if(this._request=null,i)this.fire(new e.y(i));else if(s)return this.importsCache.set(t,s),this._load(s,o)}));}loadJSON(t,i={}){this.fire(new e.z("dataloading",{dataType:"style"})),this.globalId=this._getGlobalId(t),this._request=e.q.frame((()=>{this._request=null,this._load(t,!1!==i.validate);}));}loadEmpty(){this.fire(new e.z("dataloading",{dataType:"style"})),this._load(bo,!1);}_loadImports(t,i,o){if(this.importDepth>=4)return e.w("Style doesn't support nesting deeper than 5"),Promise.resolve();const s=[];for(const e of t){const t=this._createFragmentStyle(e),r=new Promise((e=>{t.once("style.import.load",e),t.once("error",e);})).then((()=>this.mergeAll()));if(s.push(r),this.resolvedImports.has(e.url)){t.loadEmpty();continue}const a=e.data||this.importsCache.get(e.url);a?(t.loadJSON(a,{validate:i}),this._isInternalStyle(a)&&(t.globalId=null)):e.url?t.loadURL(e.url,{validate:i}):t.loadEmpty();const n={style:t,id:e.id,config:e.config};if(o){const e=this.fragments.findIndex((({id:e})=>e===o));this.fragments=this.fragments.slice(0,e).concat(n).concat(this.fragments.slice(e));}else this.fragments.push(n);}return Promise.allSettled(s)}getImportGlobalIds(e=this,t=new Set){for(const i of e.fragments)i.style.globalId&&t.add(i.style.globalId),this.getImportGlobalIds(i.style,t);return [...t.values()]}_createFragmentStyle(t){const i=this.scope?e.aC(t.id,this.scope):t.id;let o;const s=this._initialConfig&&this._initialConfig[i];(t.config||s)&&(o=e.l({},t.config,s));const r=new To(this.map,{scope:i,styleChanges:this._changes,importDepth:this.importDepth+1,importsCache:this.importsCache,resolvedImports:new Set(this.resolvedImports),dispatcher:this.dispatcher,imageManager:this.imageManager,glyphManager:this.glyphManager,modelManager:this.modelManager,config:o,configOptions:this.options,colorThemeOverride:t["color-theme"],configDependentLayers:this._configDependentLayers});return r.setEventedParent(this.map,{style:r}),r}_reloadImports(){this.mergeAll(),this._updateMapProjection(),this.updateConfigDependencies(),this.map._triggerCameraUpdate(this.camera),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),this._shouldPrecompile=this.map._precompilePrograms&&this.isRootStyle();}_isInternalStyle(e){return this.isRootStyle()&&(e.fragment||!!e.schema&&!1!==e.fragment)}_load(t,i){const o=t.indoor?_o(t.schema):t.schema;if(this._isInternalStyle(t)){const o=e.l({},bo,{imports:[{id:"basemap",data:t,url:""}]});return void this._load(o,i)}if(this.updateConfig(this._config,o),i&&go(this,me(t)))return;this._loaded=!0,this.stylesheet=e.cp(t);const s=()=>{for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1,isInitialLoad:!0});t.sprite?this._loadIconset(t.sprite):(this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0})),this.glyphManager.setURL(t.glyphs,this.scope);const o=At(this.stylesheet.layers);if(this._order=o.map((e=>e.id)),this.stylesheet.light&&e.w("The `light` root property is deprecated, prefer using `lights` with `flat` light type instead."),this.stylesheet.lights)if(1===this.stylesheet.lights.length&&"flat"===this.stylesheet.lights[0].type){const e=this.stylesheet.lights[0];this.light=new ze(e.properties,e.id);}else this.setLights(this.stylesheet.lights);this.light||(this.light=new ze(this.stylesheet.light)),this._layers={};for(const t of o){const i=e.cu(t,this.scope,this._styleColorTheme.lut,this.options);0!==i.configDependencies.size&&this._configDependentLayers.add(i.fqid),i.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=i;const o=this.getOwnLayerSourceCache(i),s=!!this.directionalLight&&this.directionalLight.shadowsEnabled();o&&i.canCastShadows()&&s&&(o.castsShadows=!0);}this.stylesheet.featuresets&&this.setFeaturesetSelectors(this.stylesheet.featuresets),this.stylesheet.models&&this.modelManager.addModels(this.stylesheet.models,this.scope);const s=this.stylesheet.terrain;s&&(this.checkCanvasFingerprintNoise(),this.disableElevatedTerrain||this.terrainSetForDrapingOnly()||this._createTerrain(s,1)),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this.stylesheet.snow&&this._createSnow(this.stylesheet.snow),this.stylesheet.rain&&this._createRain(this.stylesheet.rain),this.stylesheet.transition&&this.setTransition(this.stylesheet.transition),this.fire(new e.z("data",{dataType:"style"}));const r=this.isRootStyle();t.imports?this._loadImports(t.imports,i).then((()=>{this._reloadImports(),this.fire(new e.z(r?"style.load":"style.import.load"));})):(this._reloadImports(),this.fire(new e.z(r?"style.load":"style.import.load")));};this._styleColorTheme.colorTheme=this.stylesheet["color-theme"];const r=this._styleColorTheme.colorThemeOverride?this._styleColorTheme.colorThemeOverride:this._styleColorTheme.colorTheme;if(r){const t=this._evaluateColorThemeData(r);this._loadColorTheme(t).then((()=>{s();})).catch((t=>{e.w(`Couldn't load color theme from the stylesheet: ${t}`),s();}));}else this._styleColorTheme.lut=null,s();}isRootStyle(){return 0===this.importDepth}mergeAll(){let t,i,o,s,r,a,n,l,c,h;const u={};this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((e=>{if(e.stylesheet){if(null!=e.light&&(t=e.light),e.stylesheet.lights)for(const t of e.stylesheet.lights)"ambient"===t.type&&null!=e.ambientLight&&(i=e.ambientLight),"directional"===t.type&&null!=e.directionalLight&&(o=e.directionalLight);s=this._prioritizeTerrain(s,e.terrain,e.stylesheet.terrain),e.stylesheet.fog&&null!=e.fog&&(r=e.fog),e.stylesheet.snow&&null!=e.snow&&(a=e.snow),e.stylesheet.rain&&null!=e.rain&&(n=e.rain),null!=e.stylesheet.camera&&(h=e.stylesheet.camera),null!=e.stylesheet.projection&&(l=e.stylesheet.projection),null!=e.stylesheet.transition&&(c=e.stylesheet.transition),u[e.scope]=e._styleColorTheme;}})),this.light=t,this.ambientLight=i,this.directionalLight=o,this.fog=r,this.snow=a,this.rain=n,this._styleColorThemeForScope=u,null===s?delete this.terrain:this.terrain=s,this.camera=h||{"camera-projection":"perspective"},this.projection=l||{name:"mercator"},this.transition=e.l({},wo,c),this.mergeSources(),this.mergeLayers();}forEachFragmentStyle(e){const t=i=>{for(const e of i.fragments)t(e.style);e(i);};t(this);}_prioritizeTerrain(e,t,i){const o=e&&0===e.drapeRenderMode;return null===i?t&&0===t.drapeRenderMode?t:o?e:null:null!=t&&(!e||o||t&&1===t.drapeRenderMode)?t:e}mergeTerrain(){let e;this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((t=>{e=this._prioritizeTerrain(e,t.terrain,t.stylesheet.terrain);})),null===e?delete this.terrain:this.terrain=e;}mergeProjection(){let e;this.forEachFragmentStyle((t=>{null!=t.stylesheet.projection&&(e=t.stylesheet.projection);})),this.projection=e||{name:"mercator"};}mergeSources(){const t={},i={},o={};this.forEachFragmentStyle((s=>{for(const i in s._sourceCaches){const o=e.aC(i,s.scope);t[o]=s._sourceCaches[i];}for(const t in s._otherSourceCaches){const o=e.aC(t,s.scope);i[o]=s._otherSourceCaches[t];}for(const t in s._symbolSourceCaches){const i=e.aC(t,s.scope);o[i]=s._symbolSourceCaches[t];}})),this._mergedSourceCaches=t,this._mergedOtherSourceCaches=i,this._mergedSymbolSourceCaches=o;}mergeLayers(){const t={},i=[],o={};this._mergedSlots=[],this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this.forEachFragmentStyle((o=>{for(const s of o._order){const r=o._layers[s];if("slot"===r.type){const i=e.cq(s);if(t[i])continue;t[i]=[];}r.slot&&t[r.slot]?t[r.slot].push(r):i.push(r);}})),this._mergedOrder=[];const s=(i=[])=>{for(const r of i)if("slot"===r.type){const i=e.cq(r.id);t[i]&&s(t[i]),this._mergedSlots.push(i);}else {const t=e.aC(r.id,r.scope);this._mergedOrder.push(t),o[t]=r,r.is3D()&&(this._has3DLayers=!0),"circle"===r.type&&(this._hasCircleLayers=!0),"symbol"===r.type&&(this._hasSymbolLayers=!0),"clip"===r.type&&(this._clipLayerPresent=!0);}};s(i),this._mergedOrder.sort(((e,t)=>{const i=o[e],s=o[t];return i.hasInitialOcclusionOpacityProperties?s.is3D()?1:0:i.is3D()&&s.hasInitialOcclusionOpacityProperties?-1:0})),this._mergedLayers=o,this.updateDrapeFirstLayers(),this._buildingIndex.processLayersChanged();}terrainSetForDrapingOnly(){return !!this.terrain&&0===this.terrain.drapeRenderMode}getCamera(){return this.stylesheet.camera}setCamera(t){return this.stylesheet.camera=e.l({},this.stylesheet.camera,t),this.camera=this.stylesheet.camera,this}_evaluateColorThemeData(t){return t.data?function(t,i,o){const s=e.l({},i);for(const t of Object.keys(e.a3.colorTheme))void 0===s[t]&&(s[t]=e.a3.colorTheme[t].default);const r=new e.a4(ho,t,new Map(o));return r.setTransitionOrValue(s,o),r.untransitioned().possiblyEvaluate(new e.a8(0))}(this.scope,t,this.options).get("data"):null}_loadColorTheme(t){this._styleColorTheme.lutLoading=!0,this._styleColorTheme.lutLoadingCorrelationID+=1;const i=this._styleColorTheme.lutLoadingCorrelationID;return new Promise(((o,s)=>{const r="data:image/png;base64,";if(!t||0===t.length)return this._styleColorTheme.lut=null,this._styleColorTheme.lutLoading=!1,void o();let a=t;a.startsWith(r)||(a=r+a);const n="mapbox-reserved-lut",l=new Image;l.src=a,l.onerror=()=>{this._styleColorTheme.lutLoading=!1,s(new Error("Failed to load image data"));},l.onload=()=>{if(this._styleColorTheme.lutLoadingCorrelationID!==i)return void o();this._styleColorTheme.lutLoading=!1;const{width:r,height:a,data:c}=e.q.getImageData(l);if(a>32)return void s(new Error("The height of the image must be less than or equal to 32 pixels."));if(r!==a*a)return void s(new Error("The width of the image must be equal to the height squared."));this.getImage(n)&&this.removeImage(n),this.addImage(n,{data:new e.r({width:r,height:a},c),pixelRatio:1,sdf:!1,usvg:!1,version:0});const h=this.imageManager.getImage(n,this.scope);h?(this._styleColorTheme.lut={image:h.data,data:t},o()):s(new Error("Missing LUT image."));};}))}getLut(e){const t=this._styleColorThemeForScope[e];return t?t.lut:null}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this.mergeProjection(),this._updateMapProjection();}applyProjectionUpdate(){this._loaded&&(this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),this.map.transform.projection.requiresDraping?(this.getTerrain()||this.stylesheet.terrain)&&!this.disableElevatedTerrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null,0));}_updateMapProjection(){this.isRootStyle()&&(this.map._useExplicitProjection?this.applyProjectionUpdate():this.map._prioritizeAndUpdateProjection(null,this.projection));}_loadSprite(t){this._spriteRequest=function(t,i,o){let s,r,a;const n=e.q.devicePixelRatio>1?"@2x":"";let l=e.n(i.transformRequest(i.normalizeSpriteURL(t,n,".json"),e.R.SpriteJSON),((e,t)=>{l=null,a||(a=e,s=t,h());})),c=e.o(i.transformRequest(i.normalizeSpriteURL(t,n,".png"),e.R.SpriteImage),((e,t)=>{c=null,a||(a=e,r=t,h());}));function h(){if(a)o(a);else if(s&&r){const t=e.q.getImageData(r),i={};for(const o in s){const{width:r,height:a,x:n,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_}=s[o],p=new e.r({width:r,height:a});e.r.copy(t,p,{x:n,y:l},{x:0,y:0},{width:r,height:a},null),i[o]={data:p,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_,usvg:!1};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,((t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.y(t));else if(i)for(const e in i)this.imageManager.addImage(e,this.scope,i[e]);this.imageManager.setLoaded(!0,this.scope),this._availableImages=this.imageManager.listImages(this.scope),this.dispatcher.broadcast("setImages",{scope:this.scope,images:this._availableImages}),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.z("data",{dataType:"style"}));}));}_loadIconset(t){if(!e.f(t)&&"icon_set"!==this.map._spriteFormat||"raster"===this.map._spriteFormat)return void this._loadSprite(t);const i="auto"===this.map._spriteFormat;var o,s;this._spriteRequest=(s=(o,s)=>{if(this._spriteRequest=null,o)i?this._loadSprite(t):this.fire(new e.y(o));else if(s)for(const e in s)this.imageManager.addImage(e,this.scope,s[e]);this.imageManager.setLoaded(!0,this.scope),this._availableImages=this.imageManager.listImages(this.scope),this.dispatcher.broadcast("setImages",{scope:this.scope,images:this._availableImages}),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.z("data",{dataType:"style"}));},e.bi((o=this.map._requestManager).transformRequest(o.normalizeIconsetURL(t),e.R.Iconset),((t,i)=>{if(t)return void s(t);const o={},r=e.cg(new e.bh(i));for(const t of r.icons){const i={version:1,pixelRatio:e.q.devicePixelRatio,content:fo(t),stretchX:t.metadata?mo(t.metadata.stretch_x_areas):void 0,stretchY:t.metadata?mo(t.metadata.stretch_y_areas):void 0,sdf:!1,usvg:!0,icon:t};o[t.name]=i;}s(null,o);})));}_validateLayer(t){const i=this.getOwnSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.y(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._changes.getUpdatedSourceCaches()).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;if(!this.imageManager.isLoaded())return !1;if(!this.modelManager.isLoaded())return !1;if(this._styleColorTheme.lutLoading)return !1;for(const{style:e}of this.fragments)if(!e.loaded())return !1;return !0}_serializeImports(){if(this.stylesheet.imports)return this.stylesheet.imports.map(((e,t)=>{const i=this.fragments[t];return i&&i.style&&(e.data=i.style.serialize()),e}))}_serializeSources(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize());}return e}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];e&&"custom"!==e.type&&t.push(e.serialize());}return t}hasLightTransitions(){return !(!this.light||!this.light.hasTransition())||!(!this.ambientLight||!this.ambientLight.hasTransition())||!(!this.directionalLight||!this.directionalLight.hasTransition())}hasFogTransition(){return !!this.fog&&this.fog.hasTransition()}hasSnowTransition(){return !!this.snow&&this.snow.hasTransition()}hasRainTransition(){return !!this.rain&&this.rain.hasTransition()}hasTransitions(){if(this.hasLightTransitions())return !0;if(this.hasFogTransition())return !0;if(this.hasSnowTransition())return !0;if(this.hasRainTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.terrain?this._drapedFirstOrder:this._mergedOrder}_getOrder(e){return e?this.order:this._mergedOrder}isLayerDraped(e){return !!this.terrain&&e.isDraped(this.getLayerSourceCache(e))}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}_checkLayer(t){const i=this.getOwnLayer(t);if(i)return i;this.fire(new e.y(new Error(`The layer '${t}' does not exist in the map's style.`)));}_checkSource(t){const i=this.getOwnSource(t);if(i)return i;this.fire(new e.y(new Error(`The source '${t}' does not exist in the map's style.`)));}precompilePrograms(e,t){const i=this.map.painter;if(i)for(let o=e.minzoom||0;o<(e.maxzoom||25.5);o++){const o=e.getProgramIds();if(o)for(const s of o){const o=e.getDefaultProgramParams(s,t.zoom,this._styleColorTheme.lut);o&&(i.style=this,this.fog&&(i._fogVisible=!0,o.overrideFog=!0,i.getOrCreateProgram(s,o)),i._fogVisible=!1,o.overrideFog=!1,i.getOrCreateProgram(s,o),(this.stylesheet.terrain||this.stylesheet.projection&&"globe"===this.stylesheet.projection.name)&&(o.overrideRtt=!0,i.getOrCreateProgram(s,o)));}}}update(t){if(!this._loaded)return;this.ambientLight&&this.ambientLight.recalculate(t),this.directionalLight&&this.directionalLight.recalculate(t);const i=this.calculateLightsBrightness();t.brightness=i||0,i!==this._brightness&&(this._brightness=i,this.dispatcher.broadcast("setBrightness",i));const o=this._changes.isDirty();let s=!1;if(this._changes.isDirty()){const e=this._changes.getLayerUpdatesByScope();for(const t in e){const{updatedIds:i,removedIds:o}=e[t];(i||o)&&(this._updateWorkerLayers(t,i,o),s=!0);}this.updateSourceCaches(),this._updateTilesForChangedImages(),this.updateLayers(t),this.light&&this.light.updateTransitions(t),this.ambientLight&&this.ambientLight.updateTransitions(t),this.directionalLight&&this.directionalLight.updateTransitions(t),this.fog&&this.fog.updateTransitions(t),this.snow&&this.snow.updateTransitions(t),this.rain&&this.rain.updateTransitions(t),this._changes.reset();}const r={};for(const e in this._mergedSourceCaches){const t=this._mergedSourceCaches[e];r[e]=t.used,t.used=!1,t.tileCoverLift=0;}for(const e of this._mergedOrder){const i=this._mergedLayers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this.getLayerSourceCache(i);e&&(e.used=!0,e.tileCoverLift=Math.max(e.tileCoverLift,i.tileCoverLift()));}!this._precompileDone&&this._shouldPrecompile&&("requestIdleCallback"in window?requestIdleCallback((()=>{this.precompilePrograms(i,t);})):this.precompilePrograms(i,t));}this._shouldPrecompile&&(this._precompileDone=!0),this.terrain&&s&&this.mergeLayers();for(const t in r){const i=this._mergedSourceCaches[t];r[t]!==i.used&&i.getSource().fire(new e.z("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light&&this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.fog&&this.fog.recalculate(t),this.snow&&this.snow.recalculate(t),this.rain&&this.rain.recalculate(t),this.z=t.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),o&&this.fire(new e.z("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=this._changes.getUpdatedImages();if(e.length){for(const t in this._sourceCaches)this._sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changes.resetUpdatedImages();}}_updateWorkerLayers(e,t,i){const o=this.getFragmentStyle(e);o&&this.dispatcher.broadcast("updateLayers",{layers:t?o._serializeLayers(t):[],scope:e,removedIds:i||[],options:o.options});}setState(t,i){if(this._checkLoaded(),go(this,me(t)))return !1;(t=e.cp(t)).layers=At(t.layers);const o=function(t,i){if(!t)return [{command:zt.setStyle,args:[i]}];let o=[];try{if(!e.bn(t.version,i.version))return [{command:zt.setStyle,args:[i]}];if(e.bn(t.center,i.center)||o.push({command:zt.setCenter,args:[i.center]}),e.bn(t.zoom,i.zoom)||o.push({command:zt.setZoom,args:[i.zoom]}),e.bn(t.bearing,i.bearing)||o.push({command:zt.setBearing,args:[i.bearing]}),e.bn(t.pitch,i.pitch)||o.push({command:zt.setPitch,args:[i.pitch]}),e.bn(t.sprite,i.sprite)||o.push({command:zt.setSprite,args:[i.sprite]}),e.bn(t.glyphs,i.glyphs)||o.push({command:zt.setGlyphs,args:[i.glyphs]}),e.bn(t.imports,i.imports)||function(t=[],i=[],o){i=i||[];const s=(t=t||[]).map(Bt),r=i.map(Bt),a=t.reduce(Nt,{}),n=i.reduce(Nt,{}),l=s.slice();let c,h,u,d;for(c=0,h=0;c<s.length;c++)u=s[c],n.hasOwnProperty(u)?h++:(o.push({command:zt.removeImport,args:[u]}),l.splice(l.indexOf(u,h),1));for(c=0,h=0;c<r.length;c++)u=r[r.length-1-c],l[l.length-1-c]!==u&&(a.hasOwnProperty(u)?(o.push({command:zt.removeImport,args:[u]}),l.splice(l.lastIndexOf(u,l.length-h),1)):h++,d=l[l.length-c],o.push({command:zt.addImport,args:[n[u],d]}),l.splice(l.length-c,0,u));for(const t of i){const i=a[t.id];i&&!e.bn(i,t)&&o.push({command:zt.updateImport,args:[t.id,t]});}}(t.imports,i.imports,o),e.bn(t.transition,i.transition)||o.push({command:zt.setTransition,args:[i.transition]}),e.bn(t.light,i.light)||o.push({command:zt.setLight,args:[i.light]}),e.bn(t.fog,i.fog)||o.push({command:zt.setFog,args:[i.fog]}),e.bn(t.snow,i.snow)||o.push({command:zt.setSnow,args:[i.snow]}),e.bn(t.rain,i.rain)||o.push({command:zt.setRain,args:[i.rain]}),e.bn(t.projection,i.projection)||o.push({command:zt.setProjection,args:[i.projection]}),e.bn(t.lights,i.lights)||o.push({command:zt.setLights,args:[i.lights]}),e.bn(t.camera,i.camera)||o.push({command:zt.setCamera,args:[i.camera]}),!e.bn(t["color-theme"],i["color-theme"]))return [{command:zt.setStyle,args:[i]}];const s={},r=[];!function(t,i,o,s){let r;for(r in i=i||{},t=t||{})t.hasOwnProperty(r)&&(i.hasOwnProperty(r)||Mt(r,o,s));for(r in i){if(!i.hasOwnProperty(r))continue;const a=i[r];t.hasOwnProperty(r)?e.bn(t[r],a)||("geojson"===t[r].type&&"geojson"===a.type&&Ft(t,i,r)?o.push({command:zt.setGeoJSONSourceData,args:[r,a.data]}):Ot(r,i,o,s)):Pt(r,i,o);}}(t.sources,i.sources,r,s);const a=[];t.layers&&t.layers.forEach((e=>{e.source&&s[e.source]?o.push({command:zt.removeLayer,args:[e.id]}):a.push(e);}));let n=t.terrain;n&&s[n.source]&&(o.push({command:zt.setTerrain,args:[void 0]}),n=void 0),o=o.concat(r),e.bn(n,i.terrain)||o.push({command:zt.setTerrain,args:[i.terrain]}),function(t,i,o){i=i||[];const s=(t=t||[]).map(Bt),r=i.map(Bt),a=t.reduce(Nt,{}),n=i.reduce(Nt,{}),l=s.slice(),c=Object.create(null);let h,u,d,_,p,f,m;for(h=0,u=0;h<s.length;h++)d=s[h],n.hasOwnProperty(d)?u++:(o.push({command:zt.removeLayer,args:[d]}),l.splice(l.indexOf(d,u),1));for(h=0,u=0;h<r.length;h++)d=r[r.length-1-h],l[l.length-1-h]!==d&&(a.hasOwnProperty(d)?(o.push({command:zt.removeLayer,args:[d]}),l.splice(l.lastIndexOf(d,l.length-u),1)):u++,f=l[l.length-h],o.push({command:zt.addLayer,args:[n[d],f]}),l.splice(l.length-h,0,d),c[d]=!0);for(h=0;h<r.length;h++)if(d=r[h],_=a[d],p=n[d],!c[d]&&!e.bn(_,p))if(e.bn(_.source,p.source)&&e.bn(_["source-layer"],p["source-layer"])&&e.bn(_.type,p.type)){for(m in kt(_.layout,p.layout,o,d,null,zt.setLayoutProperty),kt(_.paint,p.paint,o,d,null,zt.setPaintProperty),e.bn(_.slot,p.slot)||o.push({command:zt.setSlot,args:[d,p.slot]}),e.bn(_.filter,p.filter)||o.push({command:zt.setFilter,args:[d,p.filter]}),e.bn(_.minzoom,p.minzoom)&&e.bn(_.maxzoom,p.maxzoom)||o.push({command:zt.setLayerZoomRange,args:[d,p.minzoom,p.maxzoom]}),_)_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?kt(_[m],p[m],o,d,m.slice(6),zt.setPaintProperty):e.bn(_[m],p[m])||o.push({command:zt.setLayerProperty,args:[d,m,p[m]]}));for(m in p)p.hasOwnProperty(m)&&!_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?kt(_[m],p[m],o,d,m.slice(6),zt.setPaintProperty):e.bn(_[m],p[m])||o.push({command:zt.setLayerProperty,args:[d,m,p[m]]}));}else o.push({command:zt.removeLayer,args:[d]}),f=l[l.lastIndexOf(d)+1],o.push({command:zt.addLayer,args:[p,f]});}(a,i.layers,o);}catch(e){console.warn("Unable to compute style diff:",e),o=[{command:zt.setStyle,args:[i]}];}return o}(this.serialize(),t).filter((e=>!(e.command in yo)));if(0===o.length)return !1;const s=o.filter((e=>!(e.command in vo)));if(s.length>0)throw new Error(`Unimplemented: ${s.map((e=>e.command)).join(", ")}.`);const r=[];return o.forEach((e=>{r.push(this[e.command].apply(this,e.args));})),i&&Promise.all(r).then(i),this.stylesheet=t,this.mergeAll(),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),!0}addImage(t,i){return this.getImage(t)?this.fire(new e.y(new Error("An image with this name already exists."))):(this.imageManager.addImage(t,this.scope,i),this._afterImageUpdated(t),this)}updateImage(e,t,i=!1){this.imageManager.updateImage(e,this.scope,t),i&&this._afterImageUpdated(e);}getImage(e){return this.imageManager.getImage(e,this.scope)}removeImage(t){return this.getImage(t)?(this.imageManager.removeImage(t,this.scope),this._afterImageUpdated(t),this):this.fire(new e.y(new Error("No image with this name exists.")))}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(this.scope),this._changes.updateImage(t),this.dispatcher.broadcast("setImages",{scope:this.scope,images:this._availableImages}),this.fire(new e.z("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this._availableImages.slice()}addModel(e,t,i={}){return this._checkLoaded(),this._validate(Re,`models.${e}`,t,null,i)||(this.modelManager.addModel(e,t,this.scope),this._changes.setDirty()),this}hasModel(e){return this.modelManager.hasModel(e,this.scope)}removeModel(t){return this.hasModel(t)?(this.modelManager.removeModel(t,this.scope),this):this.fire(new e.y(new Error("No model with this ID exists.")))}listModels(){return this._checkLoaded(),this.modelManager.listModels(this.scope)}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getOwnSource(t))throw new Error(`There is already a source with ID "${t}".`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(ge,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const s=rt(t,i,this.dispatcher,this);s.scope=this.scope,s.setEventedParent(this,(()=>({isSourceLoaded:this._isSourceCacheLoaded(s.id),source:s.serialize(),sourceId:s.id})));const r=t=>{const i=(t?"symbol:":"other:")+s.id,o=e.aC(i,this.scope),r=this._sourceCaches[i]=new St(o,s,t);(t?this._symbolSourceCaches:this._otherSourceCaches)[s.id]=r,r.onAdd(this.map);};r(!1),"vector"!==i.type&&"geojson"!==i.type||r(!0),s.onAdd&&s.onAdd(this.map),o.isInitialLoad||(this.mergeSources(),this._changes.setDirty());}removeSource(t){this._checkLoaded();const i=this.getOwnSource(t);if(!i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.y(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.scope===this.scope&&this.terrain.get().source===t)return this.fire(new e.y(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));const o=this.getOwnSourceCaches(t);for(const t of o){const i=e.cq(t.id);delete this._sourceCaches[i],this._changes.discardSourceCacheUpdate(t.id),t.fire(new e.z("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();}return delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],this.mergeSources(),i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changes.setDirty(),this}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getOwnSource(e).setData(t),this._changes.setDirty();}getOwnSource(e){const t=this.getOwnSourceCache(e);return t&&t.getSource()}getOwnSources(){const e=[];for(const t in this._otherSourceCaches){const i=this.getOwnSourceCache(t);i&&e.push(i.getSource());}return e}areTilesLoaded(){const e=this._mergedSourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}setLights(t){if(this._checkLoaded(),!t)return delete this.ambientLight,void delete this.directionalLight;const i=this._getTransitionParameters();for(const o of t){if(this._validate(ye,"lights",o))return;switch(o.type){case"ambient":if(this.ambientLight){const e=this.ambientLight;e.set(o),e.updateTransitions(i);}else this.ambientLight=new $e(o,qe||(qe=new e.a5({color:new e.a6(e.a3.properties_light_ambient.color),"color-use-theme":new e.a6({type:"string",default:"default","property-type":"data-constant"}),intensity:new e.a6(e.a3.properties_light_ambient.intensity)})),this.scope,this.options);break;case"directional":if(this.directionalLight){const e=this.directionalLight;e.set(o),e.updateTransitions(i);}else this.directionalLight=new $e(o,He||(He=new e.a5({direction:new e.ak(e.a3.properties_light_directional.direction),color:new e.a6(e.a3.properties_light_directional.color),"color-use-theme":new e.a6({type:"string",default:"default","property-type":"data-constant"}),intensity:new e.a6(e.a3.properties_light_directional.intensity),"cast-shadows":new e.a6(e.a3.properties_light_directional["cast-shadows"]),"shadow-quality":new e.a6(e.a3.properties_light_directional["shadow-quality"]),"shadow-intensity":new e.a6(e.a3.properties_light_directional["shadow-intensity"])})),this.scope,this.options);}}const o=new e.a8(this.z||0,i);this.ambientLight&&this.ambientLight.recalculate(o),this.directionalLight&&this.directionalLight.recalculate(o),this._brightness=this.calculateLightsBrightness(),this.dispatcher.broadcast("setBrightness",this._brightness);}calculateLightsBrightness(){const t=this.directionalLight,i=this.ambientLight;if(!t||!i)return;const o=e=>.2126*(e[0]<=.03928?e[0]/12.92:Math.pow((e[0]+.055)/1.055,2.4))+.7152*(e[1]<=.03928?e[1]/12.92:Math.pow((e[1]+.055)/1.055,2.4))+.0722*(e[2]<=.03928?e[2]/12.92:Math.pow((e[2]+.055)/1.055,2.4)),s=t.properties.get("color").toRenderColor(null).toArray01(),r=t.properties.get("intensity"),a=t.properties.get("direction"),n=1-e.cb(a.x,a.y,a.z)[2]/90,l=o(s)*r*n,c=i.properties.get("color").toRenderColor(null).toArray01(),h=i.properties.get("intensity"),u=o(c)*h;return Number(((l+u)/2).toFixed(6))}getBrightness(){return this._brightness}getLights(){if(!this.enable3dLights())return null;const e=[];return this.directionalLight&&e.push(this.directionalLight.get()),this.ambientLight&&e.push(this.ambientLight.get()),e}enable3dLights(){return !!this.ambientLight&&!!this.directionalLight}getFragmentStyle(t){if(!t)return this;if(e.cr(t)){const i=e.cs(t),o=this.fragments.find((({id:e})=>e===i));if(!o)throw new Error(`Style import '${t}' not found`);const s=e.cq(t);return o.style.getFragmentStyle(s)}{const e=this.fragments.find((({id:e})=>e===t));return e?e.style:void 0}}setFeaturesetSelectors(t){if(!t)return;const i={},o=(e,t="")=>`${e}::${t}`;this._featuresetSelectors={};for(const s in t){const r=this._featuresetSelectors[s]=[];for(const a of t[s].selectors){if(a.featureNamespace){const t=this.getOwnLayer(a.layer);if(!t){e.w(`Layer is undefined for selector: ${a.layer}`);continue}const r=o(t.source,t.sourceLayer);if(r in i&&i[r]!==a.featureNamespace){e.w(`"featureNamespace ${a.featureNamespace} of featureset ${s}'s selector is not associated to the same source, skip this selector`);continue}i[r]=a.featureNamespace;}let t;if(a.properties)for(const i in a.properties){const o=e.U(a.properties[i]);"success"===o.result&&(t=t||{},t[i]=o.value);}r.push({layerId:a.layer,namespace:a.featureNamespace,properties:t,uniqueFeatureID:a._uniqueFeatureID});}}}getFeaturesetDescriptors(e){const t=this.getFragmentStyle(e);if(!t||!t.stylesheet.featuresets)return [];const i=[];for(const e in t.stylesheet.featuresets)i.push({featuresetId:e,importId:t.scope?t.scope:void 0});return i}getFeaturesetLayers(t,i){const o=this.getFragmentStyle(i),s=o.stylesheet.featuresets;if(!s||!s[t])return this.fire(new e.y(new Error(`The featureset '${t}' does not exist in the map's style and cannot be queried.`))),[];const r=[];for(const e of s[t].selectors){const t=o.getOwnLayer(e.layer);t&&r.push(t);}return r}getConfigProperty(t,i){const o=this.getFragmentStyle(t);if(!o)return null;const s=e.aC(i,o.scope),r=o.options.get(s),a=r?r.value||r.default:null;return a?a.serialize():null}setConfigProperty(t,i,o){const s=this.getFragmentStyle(t);if(!s)return;const r=s.stylesheet.indoor?_o(s.stylesheet.schema):s.stylesheet.schema;if(!r||!r[i])return;const a=e.U(o);if("success"!==a.result)return void go(this,a.value);const n=a.value.expression,l=e.aC(i,s.scope),c=s.options.get(l);if(!c)return;let h;const{minValue:u,maxValue:d,stepValue:_,type:p,values:f}=r[i],m=e.U(r[i].default);"success"===m.result&&(h=m.value.expression),h?(this.options.set(l,Object.assign({},c,{value:n,default:h,minValue:u,maxValue:d,stepValue:_,type:p,values:f})),this.updateConfigDependencies(i)):this.fire(new e.y(new Error(`No schema defined for the config option "${i}" in the "${t}" fragment.`)));}getConfig(t){const i=this.getFragmentStyle(t);if(!i)return null;const o=i.stylesheet.schema;if(!o)return null;const s={};for(const t in o){const o=e.aC(t,i.scope),r=i.options.get(o),a=r?r.value||r.default:null;s[t]=a?a.serialize():null;}return s}setConfig(e,t){const i=this.getFragmentStyle(e);i&&(i.updateConfig(t,i.stylesheet.schema),this.updateConfigDependencies());}getSchema(e){const t=this.getFragmentStyle(e);return t?t.stylesheet.schema:null}setSchema(e,t){const i=this.getFragmentStyle(e);i&&(i.stylesheet.schema=t,i.updateConfig(i._config,t),this.updateConfigDependencies());}updateConfig(t,i){if(this._config=t,t||i)if(i)for(const o in i){let s,r;const a=e.U(i[o].default);if("success"===a.result&&(s=a.value.expression),t&&void 0!==t[o]){const i=e.U(t[o]);"success"===i.result&&(r=i.value.expression);}const{minValue:n,maxValue:l,stepValue:c,type:h,values:u}=i[o];if(s){const t=e.aC(o,this.scope);this.options.set(t,{default:s,value:r,minValue:n,maxValue:l,stepValue:c,type:h,values:u});}else this.fire(new e.y(new Error(`No schema defined for config option "${o}".`)));}else this.fire(new e.y(new Error("Attempting to set config for a style without schema.")));}updateConfigDependencies(e){for(const t of this._configDependentLayers){const i=this.getLayer(t);if(i){if(e&&!i.configDependencies.has(e))continue;i.possiblyEvaluateVisibility(),this._updateLayer(i);}}this.ambientLight&&this.ambientLight.updateConfig(this.options),this.directionalLight&&this.directionalLight.updateConfig(this.options),this.fog&&this.fog.updateConfig(this.options),this.snow&&this.snow.updateConfig(this.options),this.rain&&this.rain.updateConfig(this.options),this.forEachFragmentStyle((e=>{const t=e._styleColorTheme.colorThemeOverride?e._styleColorTheme.colorThemeOverride:e._styleColorTheme.colorTheme;if(t){const i=e._evaluateColorThemeData(t);(!e._styleColorTheme.lut&&""!==i||e._styleColorTheme.lut&&i!==e._styleColorTheme.lut.data)&&e.setColorTheme(t);}})),this._changes.setDirty();}addLayer(t,i,o={}){this._checkLoaded();const s=t.id;if(this._layers[s])return void this.fire(new e.y(new Error(`Layer with id "${s}" already exists on this map`)));let r;if("custom"===t.type){if(go(this,e.ct(t)))return;r=e.cu(t,this.scope,this._styleColorTheme.lut,this.options);}else {if("object"==typeof t.source&&(this.addSource(s,t.source),t=e.cp(t),t=e.l(t,{source:s})),this._validate(Ee,`layers.${s}`,t,{arrayIndex:-1},o))return;r=e.cu(t,this.scope,this._styleColorTheme.lut,this.options),this._validateLayer(r),r.setEventedParent(this,{layer:{id:s}});}0!==r.configDependencies.size&&this._configDependentLayers.add(r.fqid);let a=this._order.length;if(i){const t=this._order.indexOf(i);if(-1===t)return void this.fire(new e.y(new Error(`Layer with id "${i}" does not exist on this map.`)));r.slot===this._layers[i].slot?a=t:e.w(`Layer with id "${i}" has a different slot. Layers can only be rearranged within the same slot.`);}this._order.splice(a,0,s),this._layerOrderChanged=!0,this._layers[s]=r;const n=this.getOwnLayerSourceCache(r),l=!!this.directionalLight&&this.directionalLight.shadowsEnabled();n&&r.canCastShadows()&&l&&(n.castsShadows=!0);const c=this._changes.getRemovedLayer(r);if(c&&r.source&&n&&"custom"!==r.type){this._changes.discardLayerRemoval(r);const t=e.aC(r.source,r.scope);c.type!==r.type?this._changes.updateSourceCache(t,"clear"):(this._changes.updateSourceCache(t,"reload"),n.pause());}this._updateLayer(r),r.onAdd&&r.onAdd(this.map),r.scope=this.scope,this.mergeLayers();}moveLayer(t,i){this._checkLoaded();const o=this._checkLayer(t);if(!o)return;if(t===i)return;const s=this._order.indexOf(t);this._order.splice(s,1);let r=this._order.length;if(i){const t=this._order.indexOf(i);if(-1===t)return void this.fire(new e.y(new Error(`Layer with id "${i}" does not exist on this map.`)));o.slot===this._layers[i].slot?r=t:e.w(`Layer with id "${i}" has a different slot. Layers can only be rearranged within the same slot.`);}this._order.splice(r,0,t),this._changes.setDirty(),this._layerOrderChanged=!0,this.mergeLayers();}removeLayer(e){this._checkLoaded();const t=this._checkLayer(e);if(!t)return;t.setEventedParent(null);const i=this._order.indexOf(e);this._order.splice(i,1),delete this._layers[e],this._changes.setDirty(),this._layerOrderChanged=!0,this._configDependentLayers.delete(t.fqid),this._changes.removeLayer(t);const o=this.getOwnLayerSourceCache(t);if(o&&o.castsShadows){let e=!1;for(const i in this._layers)if(this._layers[i].source===t.source&&this._layers[i].canCastShadows()){e=!0;break}o.castsShadows=e;}t.onRemove&&t.onRemove(this.map),this.mergeLayers();}getOwnLayer(e){return this._layers[e]}hasLayer(e){return e in this._mergedLayers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return !0;return !1}setLayerZoomRange(e,t,i){this._checkLoaded();const o=this._checkLayer(e);o&&(o.minzoom===t&&o.maxzoom===i||(null!=t&&(o.minzoom=t),null!=i&&(o.maxzoom=i),this._updateLayer(o)));}getSlots(){return this._checkLoaded(),this._mergedSlots}setSlot(e,t){this._checkLoaded();const i=this._checkLayer(e);i&&i.slot!==t&&(i.slot=t,this._updateLayer(i));}setFilter(t,i,o={}){this._checkLoaded();const s=this._checkLayer(t);if(s&&!e.bn(s.filter,i))return null==i?(s.filter=void 0,void this._updateLayer(s)):void(this._validate(Se,`layers.${s.id}.filter`,i,{layerType:s.type},o)||(s.filter=e.cp(i),this._updateLayer(s)))}getFilter(t){const i=this._checkLayer(t);if(i)return e.cp(i.filter)}setLayoutProperty(t,i,o,s={}){this._checkLoaded();const r=this._checkLayer(t);if(r&&!e.bn(r.getLayoutProperty(i),o)){if(null!=o&&(!s||!1!==s.validate)&&go(r,Ie.call(me,{key:`layers.${t}.layout.${i}`,layerType:r.type,objectKey:i,value:o,styleSpec:e.a3,style:{glyphs:!0,sprite:!0}})))return;r.setLayoutProperty(i,o),0!==r.configDependencies.size&&this._configDependentLayers.add(r.fqid),this._updateLayer(r);}}getLayoutProperty(e,t){const i=this._checkLayer(e);if(i)return i.getLayoutProperty(t)}setPaintProperty(t,i,o,s={}){this._checkLoaded();const r=this._checkLayer(t);if(!r)return;if(e.bn(r.getPaintProperty(i),o))return;if(null!=o&&(!s||!1!==s.validate)&&go(r,Ce.call(me,{key:`layers.${t}.paint.${i}`,layerType:r.type,objectKey:i,value:o,styleSpec:e.a3})))return;const a=r.setPaintProperty(i,o);0!==r.configDependencies.size&&this._configDependentLayers.add(r.fqid),a&&this._updateLayer(r),this._changes.updatePaintProperties(r);}getPaintProperty(e,t){const i=this._checkLayer(e);if(i)return i.getPaintProperty(t)}setFeatureState(t,i){if(this._checkLoaded(),"target"in t){if("featuresetId"in t.target){const{featuresetId:e,importId:o}=t.target,s=this.getFragmentStyle(o),r=s.getFeaturesetLayers(e);for(const{source:e,sourceLayer:o}of r)s.setFeatureState({id:t.id,source:e,sourceLayer:o},i);}else if("layerId"in t.target){const{layerId:e}=t.target,o=this.getLayer(e);this.setFeatureState({id:t.id,source:o.source,sourceLayer:o.sourceLayer},i);}return}const o=t.source,s=t.sourceLayer,r=this._checkSource(o);if(!r)return;const a=r.type;if("geojson"===a&&s)return void this.fire(new e.y(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===a&&!s)return void this.fire(new e.y(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===t.id&&this.fire(new e.y(new Error("The feature id parameter must be provided.")));const n=this.getOwnSourceCaches(o);for(const e of n)e.setFeatureState(s,t.id,i);}removeFeatureState(t,i){if(this._checkLoaded(),"target"in t){if("featuresetId"in t.target){const{featuresetId:e,importId:o}=t.target,s=this.getFragmentStyle(o),r=s.getFeaturesetLayers(e);for(const{source:e,sourceLayer:o}of r)s.removeFeatureState({id:t.id,source:e,sourceLayer:o},i);}else if("layerId"in t.target){const{layerId:e}=t.target,o=this.getLayer(e);this.removeFeatureState({id:t.id,source:o.source,sourceLayer:o.sourceLayer},i);}return}const o=t.source,s=this._checkSource(o);if(!s)return;const r=s.type,a="vector"===r?t.sourceLayer:void 0;if("vector"===r&&!a)return void this.fire(new e.y(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof t.id&&"number"!=typeof t.id)return void this.fire(new e.y(new Error("A feature id is required to remove its specific state property.")));const n=this.getOwnSourceCaches(o);for(const e of n)e.removeFeatureState(a,t.id,i);}getFeatureState(t){if(this._checkLoaded(),"target"in t){let i;if("featuresetId"in t.target){const{featuresetId:o,importId:s}=t.target,r=this.getFragmentStyle(s),a=r.getFeaturesetLayers(o);for(const{source:o,sourceLayer:s}of a){const a=r.getFeatureState({id:t.id,source:o,sourceLayer:s});if(a&&!i)i=a;else if(!e.bn(i,a))return void this.fire(new e.y(new Error("The same feature id exists in multiple sources in the featureset, but their feature states are not consistent through the sources.")))}}else if("layerId"in t.target){const{layerId:e}=t.target,o=this.getLayer(e);i=this.getFeatureState({id:t.id,source:o.source,sourceLayer:o.sourceLayer});}return i}const i=t.source,o=t.sourceLayer,s=this._checkSource(i);if(s){if("vector"!==s.type||o)return void 0===t.id&&this.fire(new e.y(new Error("The feature id parameter must be provided."))),this.getOwnSourceCaches(i)[0].getFeatureState(o,t.id);this.fire(new e.y(new Error("The sourceLayer parameter must be provided for vector source types.")));}}setTransition(t){return this.stylesheet.transition=e.l({},this.stylesheet.transition,t),this.transition=this.stylesheet.transition,this}getTransition(){return e.l({},this.stylesheet.transition)}serialize(){this._checkLoaded();const t=this.getTerrain(),i=t&&this.terrain&&this.terrain.scope===this.scope?t:this.stylesheet.terrain;return e.cv({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,fragment:this.stylesheet.fragment,imports:this._serializeImports(),schema:this.stylesheet.schema,camera:this.stylesheet.camera,light:this.stylesheet.light,lights:this.stylesheet.lights,terrain:i,fog:this.stylesheet.fog,snow:this.stylesheet.snow,rain:this.stylesheet.rain,center:this.stylesheet.center,"color-theme":this.stylesheet["color-theme"],zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,projection:this.stylesheet.projection,sources:this._serializeSources(),layers:this._serializeLayers(this._order)},(e=>void 0!==e))}_updateFilteredLayers(e){for(const t of Object.values(this._mergedLayers))e(t)&&this._updateLayer(t);}_updateLayer(t){this._changes.updateLayer(t);const i=this.getLayerSourceCache(t),o=e.aC(t.source,t.scope),s=this._changes.getUpdatedSourceCaches();t.source&&!s[o]&&i&&"raster"!==i.getSource().type&&(this._changes.updateSourceCache(o,"reload"),i.pause()),t.invalidateCompiledFilter();}_flattenAndSortRenderedFeatures(e){const t=e=>this._mergedLayers[e].is3D(),i=this.order,o={},s=[];for(let r=i.length-1;r>=0;r--){const a=i[r];if(t(a)){o[a]=r;for(const t of e){const e=t[a];if(e)for(const t of e)s.push(t);}}}s.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let a=i.length-1;a>=0;a--){const n=i[a];if(t(n))for(let e=s.length-1;e>=0;e--){const t=s[e].feature;if(t.layer&&o[t.layer.id]<a)break;r.push(t),s.pop();}else for(const t of e){const e=t[n];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(t,i,o){let s;i&&!Array.isArray(i)&&i.filter&&(this._validate(Se,"queryRenderedFeatures.filter",i.filter,null,i),s=e.aZ(i.filter));const r={},a=e=>{if(xo.has(e.type))return;const t=this.getOwnLayerSourceCache(e),i=r[t.id]=r[t.id]||{sourceCache:t,layers:{},has3DLayers:!1};e.is3D()&&(i.has3DLayers=!0),i.layers[e.fqid]=i.layers[e.fqid]||{styleLayer:e,targets:[]},i.layers[e.fqid].targets.push({filter:s});};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.y(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._layers[t];if(!i)return this.fire(new e.y(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];a(i);}}else for(const e in this._layers)a(this._layers[e]);const n=this._queryRenderedFeatures(t,r,o),l=this._flattenAndSortRenderedFeatures(n),c=[];for(const t of l)e.cs(t.layer.id)===this.scope&&c.push(t);return c}queryRenderedFeatureset(t,i,o){let s;i&&!Array.isArray(i)&&i.filter&&(this._validate(Se,"queryRenderedFeatures.filter",i.filter,null,i),s=e.aZ(i.filter));const r="mock",a=[];if(i&&i.target)a.push(Object.assign({},i,{targetId:r,filter:s}));else {const e=this.getFeaturesetDescriptors();for(const t of e)a.push({targetId:r,filter:s,target:t});for(const{style:e}of this.fragments){const t=e.getFeaturesetDescriptors();for(const e of t)a.push({targetId:r,filter:s,target:e});}}const n=this.queryRenderedTargets(t,a,o),l=[],c=new Set;for(const t of n)for(const i of t.variants[r])nt(i,t,c)||l.push(new e.cw(t,i));return l}queryRenderedTargets(t,i,o){const s={},r=(e,t,i,o)=>{const r=s[t.id]=s[t.id]||{sourceCache:t,layers:{},has3DLayers:!1};if(r.layers[e.fqid]=r.layers[e.fqid]||{styleLayer:e,targets:[]},e.is3D()&&(r.has3DLayers=!0),!o)return i.uniqueFeatureID=!1,void r.layers[e.fqid].targets.push(i);r.layers[e.fqid].targets.push(Object.assign({},i,{namespace:o.namespace,properties:o.properties,uniqueFeatureID:o.uniqueFeatureID}));};for(const t of i)if("featuresetId"in t.target){const{featuresetId:i,importId:o}=t.target,s=this.getFragmentStyle(o);if(!s||!s._featuresetSelectors)continue;const a=s._featuresetSelectors[i];if(!a){this.fire(new e.y(new Error(`The featureset '${i}' does not exist in the map's style and cannot be queried for features.`)));continue}for(const e of a){const i=s.getOwnLayer(e.layerId);i&&!xo.has(i.type)&&r(i,s.getOwnLayerSourceCache(i),t,e);}}else if("layerId"in t.target){const{layerId:e}=t.target,i=this.getLayer(e);if(!i||xo.has(i.type))continue;r(i,this.getLayerSourceCache(i),t);}const a=this._queryRenderedFeatures(t,s,o);return this._flattenAndSortRenderedFeatures(a)}_queryRenderedFeatures(e,t,i){const o=[],s=!!this.map._showQueryGeometry,r=Xe.createFromScreenPoints(e,i);for(const e in t){const a=lt(r,t[e],this._availableImages,i,s);Object.keys(a).length&&o.push(a);}if(this.placement)for(const e in t){if(!t[e].sourceCache._onlySymbols)continue;const i=ct(r.screenGeometry,t[e],this._availableImages,this.placement.collisionIndex,this.placement.retainedQueryData);Object.keys(i).length&&o.push(i);}return o}querySourceFeatures(e,t){const i=t&&t.filter;i&&this._validate(Se,"querySourceFeatures.filter",i,null,t);let o=[];const s=this.getOwnSourceCaches(e);for(const e of s)o=o.concat(ht(e,t));return o}addSourceType(e,t,i){return To.getSourceType(e)?i(new Error(`A source type called "${e}" already exists.`)):(To.setSourceType(e,t),t.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:e,url:t.workerSourceURL},i):i(null,null))}getFlatLight(){return this.light.getLight()}setFlatLight(t,i,o={}){this._checkLoaded();const s=this.light.getLight();let r=!1;for(const i in t)if(!e.bn(t[i],s[i])){r=!0;break}if(!r)return;const a=this._getTransitionParameters();this.light.setLight(t,i,o),this.light.updateTransitions(a);}getTerrain(){return this.terrain&&1===this.terrain.drapeRenderMode?this.terrain.get():null}setTerrainForDraping(){this.setTerrain({source:"",exaggeration:0},0);}checkCanvasFingerprintNoise(){void 0===this.disableElevatedTerrain&&(this.disableElevatedTerrain=e.q.hasCanvasFingerprintNoise(),this.disableElevatedTerrain&&e.w("Terrain and hillshade are disabled because of Canvas2D limitations when fingerprinting protection is enabled (e.g. in private browsing mode)."));}setTerrain(t,i=1){if(this._checkLoaded(),!t)return this.terrainSetForDrapingOnly()||(delete this.terrain,this.map.transform.projection.requiresDraping&&this.setTerrainForDraping()),0===i&&delete this.terrain,null===t?this.stylesheet.terrain=null:delete this.stylesheet.terrain,this._force3DLayerUpdate(),void(this._markersNeedUpdate=!0);this.checkCanvasFingerprintNoise();let o=t;const s=null==t.source;if(1===i){if(this.disableElevatedTerrain)return;if("object"==typeof o.source){const t="terrain-dem-src";this.addSource(t,o.source),o=e.cp(o),o=e.l(o,{source:t});}const t=e.l({},o),i={};if(this.terrain&&s){t.source=this.terrain.get().source;const e=this.terrain?this.getFragmentStyle(this.terrain.scope):null;e&&(i.style=e.serialize());}if(this._validate(xe,"terrain",t,i))return}if(!this.terrain||this.terrain.scope!==this.scope&&!s||this.terrain&&i!==this.terrain.drapeRenderMode){if(!o)return;this._createTerrain(o,i),this.fire(new e.z("data",{dataType:"style"}));}else {const i=this.terrain,s=i.get();for(const t of Object.keys(e.a3.terrain))!o.hasOwnProperty(t)&&e.a3.terrain[t].default&&(o[t]=e.a3.terrain[t].default);for(const o in t)if(!e.bn(t[o],s[o])){i.set(t,this.options),this.stylesheet.terrain=t;const o=this._getTransitionParameters({duration:0});i.updateTransitions(o),this.fire(new e.z("data",{dataType:"style"}));break}}this.mergeTerrain(),this.updateDrapeFirstLayers(),this._markersNeedUpdate=!0;}_createFog(e){const t=this.fog=new je(e,this.map.transform,this.scope,this.options);this.stylesheet.fog=t.get();const i=this._getTransitionParameters({duration:0});t.updateTransitions(i);}_createSnow(e){const t=this.snow=new Ze(e,this.map.transform,this.scope,this.options);this.stylesheet.snow=t.get();const i=this._getTransitionParameters({duration:0});t.updateTransitions(i);}_createRain(e){const t=this.rain=new We(e,this.map.transform,this.scope,this.options);this.stylesheet.rain=t.get();const i=this._getTransitionParameters({duration:0});t.updateTransitions(i);}_updateMarkersOpacity(){0!==this.map._markers.length&&this.map._requestDomTask((()=>{for(const e of this.map._markers)e._evaluateOpacity();}));}getFog(){return this.fog?this.fog.get():null}setFog(t){if(this._checkLoaded(),!t)return delete this.fog,delete this.stylesheet.fog,void(this._markersNeedUpdate=!0);if(this.fog){const i=this.fog;if(!e.bn(i.get(),t)){i.set(t,this.options),this.stylesheet.fog=i.get();const e=this._getTransitionParameters({duration:0});i.updateTransitions(e);}}else this._createFog(t);this._markersNeedUpdate=!0;}getSnow(){return this.snow?this.snow.get():null}setSnow(t){if(this._checkLoaded(),!t)return delete this.snow,void delete this.stylesheet.snow;if(this.snow){const i=this.snow;if(!e.bn(i.get(),t)){i.set(t,this.options),this.stylesheet.snow=i.get();const e=this._getTransitionParameters({duration:0});i.updateTransitions(e);}}else this._createSnow(t);this._markersNeedUpdate=!0;}getRain(){return this.rain?this.rain.get():null}setRain(t){if(this._checkLoaded(),!t)return delete this.rain,void delete this.stylesheet.rain;if(this.rain){const i=this.rain;if(!e.bn(i.get(),t)){i.set(t,this.options),this.stylesheet.rain=i.get();const e=this._getTransitionParameters({duration:0});i.updateTransitions(e);}}else this._createRain(t);this._markersNeedUpdate=!0;}_reloadColorTheme(){const t=()=>{for(const e in this._layers)this._layers[e].lut=this._styleColorTheme.lut;for(const e in this._sourceCaches)this._sourceCaches[e].clearTiles();},i=this._styleColorTheme.colorThemeOverride?this._styleColorTheme.colorThemeOverride:this._styleColorTheme.colorTheme;if(!i)return this._styleColorTheme.lut=null,void t();const o=this._evaluateColorThemeData(i);this._loadColorTheme(o).then((()=>{this.fire(new e.z("colorthemeset")),t();})).catch((t=>{e.w(`Couldn't set color theme: ${t}`);}));}setColorTheme(t){this._checkLoaded(),this._styleColorTheme.colorThemeOverride&&e.w("Note: setColorTheme is called on a style with a color-theme override, the passed color-theme won't be visible."),this._styleColorTheme.colorTheme=t,this._reloadColorTheme();}setImportColorTheme(e,t){const i=this.getFragmentStyle(e);i&&(i._styleColorTheme.colorThemeOverride=t,i._reloadColorTheme());}_getTransitionParameters(t){return {now:e.q.now(),transition:e.l(this.transition,t)}}updateDrapeFirstLayers(){if(!this.terrain)return;const e=[],t=[];for(const i of this._mergedOrder)this.isLayerDraped(this._mergedLayers[i])?e.push(i):t.push(i);this._drapedFirstOrder=[],this._drapedFirstOrder.push(...e),this._drapedFirstOrder.push(...t);}_createTerrain(e,t){const i=this.terrain=new Pe(e,t,this.scope,this.options);1===t&&(this.stylesheet.terrain=e),this.mergeTerrain(),this.updateDrapeFirstLayers(),this._force3DLayerUpdate();const o=this._getTransitionParameters({duration:0});i.updateTransitions(o);}_force3DLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"fill-extrusion"===t.type&&this._updateLayer(t);}}_forceSymbolLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"symbol"===t.type&&this._updateLayer(t);}}_validate(t,i,o,s,r={}){if(r&&!1===r.validate)return !1;const a=e.l({},this.serialize());return go(this,t.call(me,e.l({key:i,style:a,value:o,styleSpec:e.a3},s)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),e.cx.off("pluginStateChange",this._rtlTextPluginCallback);for(const e in this._mergedLayers)this._mergedLayers[e].setEventedParent(null);for(const e in this._mergedSourceCaches)this._mergedSourceCaches[e].clearTiles(),this._mergedSourceCaches[e].setEventedParent(null);this.setEventedParent(null),delete this.fog,delete this.snow,delete this.rain,delete this.terrain,delete this.ambientLight,delete this.directionalLight,this.isRootStyle()&&(this.imageManager.setEventedParent(null),this.modelManager.setEventedParent(null),this.dispatcher.remove());}clearSource(e){const t=this.getSourceCaches(e);for(const e of t)e.clearTiles();}clearSources(){for(const e in this._mergedSourceCaches)this._mergedSourceCaches[e].clearTiles();}reloadSource(e){const t=this.getSourceCaches(e);for(const e of t)e.resume(),e.reload();}reloadSources(){for(const e of this.getSources())e.reload&&e.reload();}reloadModels(){this.modelManager.reloadModels(""),this.forEachFragmentStyle((e=>{e.modelManager.reloadModels(e.scope);}));}updateSources(e){let t;this.directionalLight&&(t=ao(this.directionalLight));for(const i in this._mergedSourceCaches)this._mergedSourceCaches[i].update(e,void 0,void 0,t);}_generateCollisionBoxes(){for(const e in this._sourceCaches){const t=this._sourceCaches[e];t.resume(),t.reload();}}_updatePlacement(t,i,o,s,r,a,n=!1){let l=!1,c=!1;const h={},u={};for(const t of this._mergedOrder){const o=this._mergedLayers[t];if("symbol"!==o.type)continue;const s=e.aC(o.source,o.scope);let r=h[s];if(!r){const e=this.getLayerSourceCache(o);if(!e)continue;const t=e.getRenderableIds(!0).map((t=>e.getTileByID(t)));u[s]=t.slice(),r=h[s]=t.sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const a=this.crossTileSymbolIndex.addLayer(o,r,i.center.lng,i.projection);l=l||a;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._mergedOrder),n=n||this._layerOrderChanged||0===s,this._layerOrderChanged&&this.fire(new e.z("neworder")),(n||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(e.q.now(),i.zoom))&&(this.pauseablePlacement=new Li(i,this._mergedOrder,n,o,s,r,this.placement,this.fog&&i.projection.supportsFog?this.fog.state:null,this._buildingIndex),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._mergedOrder,this._mergedLayers,h,u,this.map.painter.scaleFactor),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(e.q.now()),c=!0),l&&this.pauseablePlacement.placement.setStale()),c||l){this._buildingIndex.onNewFrame(i.zoom);for(let t=0;t<this._mergedOrder.length;t++){const i=this._mergedLayers[this._mergedOrder[t]];if("symbol"!==i.type)continue;const o=this.isLayerClipped(i);this.placement.updateLayerOpacities(i,h[e.aC(i.source,i.scope)],t,o?a:null);}}return {needsRerender:!this.pauseablePlacement.isDone()||this.placement.hasTransitions(e.q.now())}}_releaseSymbolFadeTiles(){for(const e in this._sourceCaches)this._sourceCaches[e].releaseSymbolFadeTiles();}addImport(t,i){this._checkLoaded();const o=this.stylesheet.imports=this.stylesheet.imports||[];if(-1!==o.findIndex((({id:e})=>e===t.id)))return void this.fire(new e.y(new Error(`Import with id '${t.id}' already exists in the map's style.`)));if(!i)return o.push(t),this._loadImports([t],!0);const s=o.findIndex((({id:e})=>e===i));return -1===s&&this.fire(new e.y(new Error(`Import with id "${i}" does not exist on this map.`))),this.stylesheet.imports=o.slice(0,s).concat(t).concat(o.slice(s)),this._loadImports([t],!0,i)}updateImport(t,i){this._checkLoaded();const o=this.stylesheet.imports||[],s=this.getImportIndex(t);return -1===s?this:"string"==typeof i?(this.setImportUrl(t,i),this):(i.url&&i.url!==o[s].url&&this.setImportUrl(t,i.url),e.bn(i.config,o[s].config)||this.setImportConfig(t,i.config,i.data.schema),e.bn(i.data,o[s].data)||this.setImportData(t,i.data),this)}moveImport(e,t){this._checkLoaded();let i=this.stylesheet.imports||[];const o=this.getImportIndex(e);if(-1===o)return this;const s=this.getImportIndex(t);if(-1===s)return this;const r=i[o],a=this.fragments[o];return i=i.filter((({id:t})=>t!==e)),this.fragments=this.fragments.filter((({id:t})=>t!==e)),this.stylesheet.imports=i.slice(0,s).concat(r).concat(i.slice(s)),this.fragments=this.fragments.slice(0,s).concat(a).concat(this.fragments.slice(s)),this.mergeLayers(),this}setImportUrl(e,t){this._checkLoaded();const i=this.stylesheet.imports||[],o=this.getImportIndex(e);if(-1===o)return this;i[o].url=t;const s=this.fragments[o];return s.style=this._createFragmentStyle(i[o]),s.style.on("style.import.load",(()=>this.mergeAll())),s.style.loadURL(t),this}setImportData(e,t){this._checkLoaded();const i=this.getImportIndex(e),o=this.stylesheet.imports||[];return -1===i?this:t?(this.fragments[i].style.setState(t),this._reloadImports(),this):(delete o[i].data,this.setImportUrl(e,o[i].url))}setImportConfig(e,t,i){this._checkLoaded();const o=this.getImportIndex(e),s=this.stylesheet.imports||[];if(-1===o)return this;t?s[o].config=t:delete s[o].config;const r=this.fragments[o];i&&r.style.stylesheet&&(r.style.stylesheet.schema=i);const a=r.style.stylesheet&&r.style.stylesheet.schema;return r.config=t,r.style.updateConfig(t,a),this.updateConfigDependencies(),this}removeImport(e){this._checkLoaded();const t=this.stylesheet.imports||[],i=this.getImportIndex(e);-1!==i&&(t.splice(i,1),this.fragments[i].style._remove(),this.fragments.splice(i,1),this._reloadImports());}getImportIndex(t){const i=(this.stylesheet.imports||[]).findIndex((e=>e.id===t));return -1===i&&this.fire(new e.y(new Error(`Import '${t}' does not exist in the map's style and cannot be updated.`))),i}getLayer(e){return this._mergedLayers[e]}getSources(){const e=[];for(const t in this._mergedOtherSourceCaches){const i=this._mergedOtherSourceCaches[t];i&&e.push(i.getSource());}return e}getSource(e,t){const i=this.getSourceCache(e,t);return i&&i.getSource()}getLayerSource(e){const t=this.getLayerSourceCache(e);return t&&t.getSource()}getSourceCache(t,i){const o=e.aC(t,i);return this._mergedOtherSourceCaches[o]}getLayerSourceCache(t){const i=e.aC(t.source,t.scope);return "symbol"===t.type?this._