/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public enum CacheType {
    INDICES_REQUEST_CACHE("indices.requests.cache", "request_cache");

    private final String settingPrefix;
    private final String value;
    private static final Map<String, CacheType> valuesMap;

    private CacheType(String settingPrefix, String representation) {
        this.settingPrefix = settingPrefix;
        this.value = representation;
    }

    public String getSettingPrefix() {
        return this.settingPrefix;
    }

    public String getValue() {
        return this.value;
    }

    public static CacheType getByValue(String value) {
        CacheType result = valuesMap.get(value);
        if (result == null) {
            throw new IllegalArgumentException("No CacheType with value = " + value);
        }
        return result;
    }

    public static Set<String> allValues() {
        return valuesMap.keySet();
    }

    static {
        HashMap<String, CacheType> values = new HashMap<String, CacheType>();
        for (CacheType cacheType : CacheType.values()) {
            values.put(cacheType.value, cacheType);
        }
        valuesMap = Collections.unmodifiableMap(values);
    }
}

