/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.ThisExpression;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ElementRenamedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.UseAccessorsJavaCodeProcessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "field", "Lcom/intellij/psi/PsiField;", "propertyName", "", "isNullable", "", "replaceReadWithFieldReference", "replaceWriteWithFieldReference", "<init>", "(Lcom/intellij/psi/PsiField;Ljava/lang/String;ZZZ)V", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "setJavaCodeProcessors", "(Ljava/util/List;)V", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ElementRenamedCodeProcessor;", "getKotlinCodeProcessors", "MyConvertedCodeProcessor", "kotlin.j2k.k1.old"})
public final class FieldToPropertyProcessing
implements UsageProcessing {
    @NotNull
    private final PsiField field;
    @NotNull
    private final String propertyName;
    private final boolean isNullable;
    private final boolean replaceReadWithFieldReference;
    private final boolean replaceWriteWithFieldReference;
    @Nullable
    private final ConvertedCodeProcessor convertedCodeProcessor;
    @NotNull
    private List<? extends ExternalCodeProcessor> javaCodeProcessors;
    @NotNull
    private final List<ElementRenamedCodeProcessor> kotlinCodeProcessors;

    public FieldToPropertyProcessing(@NotNull PsiField field2, @NotNull String propertyName, boolean isNullable, boolean replaceReadWithFieldReference, boolean replaceWriteWithFieldReference) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.field = field2;
        this.propertyName = propertyName;
        this.isNullable = isNullable;
        this.replaceReadWithFieldReference = replaceReadWithFieldReference;
        this.replaceWriteWithFieldReference = replaceWriteWithFieldReference;
        ConvertedCodeProcessor convertedCodeProcessor2 = this.convertedCodeProcessor = !Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) || this.replaceReadWithFieldReference || this.replaceWriteWithFieldReference ? (ConvertedCodeProcessor)new MyConvertedCodeProcessor() : null;
        if (this.field.hasModifierProperty("private")) {
            list2 = CollectionsKt.emptyList();
        } else if (!Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName)) {
            Object[] objectArray = new ExternalCodeProcessor[2];
            objectArray[0] = new ElementRenamedCodeProcessor(this.propertyName);
            PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)this.field.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(...)");
            objectArray[1] = new UseAccessorsJavaCodeProcessor(psiElementFactory, this.propertyName);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)this.field.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(...)");
            list2 = CollectionsKt.listOf((Object)new UseAccessorsJavaCodeProcessor(psiElementFactory, this.propertyName));
        }
        this.javaCodeProcessors = list2;
        this.kotlinCodeProcessors = !Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ? CollectionsKt.listOf((Object)new ElementRenamedCodeProcessor(this.propertyName)) : CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.field;
    }

    @Override
    @Nullable
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return this.convertedCodeProcessor;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    public void setJavaCodeProcessors(@NotNull List<? extends ExternalCodeProcessor> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.javaCodeProcessors = list2;
    }

    @NotNull
    public List<ElementRenamedCodeProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing$MyConvertedCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "<init>", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;)V", "convertVariableUsage", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "codeConverter", "Lorg/jetbrains/kotlin/j2k/CodeConverter;", "kotlin.j2k.k1.old"})
    private final class MyConvertedCodeProcessor
    implements ConvertedCodeProcessor {
        @Override
        @NotNull
        public Expression convertVariableUsage(@NotNull PsiReferenceExpression expression, @NotNull CodeConverter codeConverter) {
            PsiReferenceExpression psiReferenceExpression;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
            boolean useFieldReference = FieldToPropertyProcessing.this.replaceReadWithFieldReference && PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)expression)) || FieldToPropertyProcessing.this.replaceWriteWithFieldReference && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression));
            Identifier identifier = Identifier.Companion.withNoPrototype$default(Identifier.Companion, useFieldReference ? "field" : FieldToPropertyProcessing.this.propertyName, FieldToPropertyProcessing.this.isNullable, false, null, 12, null);
            PsiExpression qualifier2 = expression.getQualifierExpression();
            if (qualifier2 != null && !useFieldReference) {
                return new QualifiedExpression(CodeConverter.convertExpression$default(codeConverter, qualifier2, false, 2, null), identifier, UtilsKt.dot(expression));
            }
            PsiElementFactory elementFactory = PsiElementFactory.getInstance((Project)expression.getProject());
            try {
                PsiExpression psiExpression = elementFactory.createExpressionFromText(identifier.getName(), (PsiElement)expression);
                PsiReferenceExpression psiReferenceExpression2 = psiExpression instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiExpression : null;
                if (psiReferenceExpression2 == null) {
                    return identifier;
                }
                psiReferenceExpression = psiReferenceExpression2;
            }
            catch (IncorrectOperationException e) {
                return identifier;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            return refExpr.resolve() == null ? (Expression)identifier : (Expression)new QualifiedExpression((Expression)ElementKt.assignNoPrototype((Element)new ThisExpression(Identifier.Companion.getEmpty())), identifier, null);
        }
    }
}

