/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\n\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u0012H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider;", "", "<init>", "()V", "getExternalJavaDocUrl", "", "", "element", "Lcom/intellij/psi/PsiElement;", "findUrlsForClass", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "Lcom/intellij/psi/PsiClass;", "findUrlsForEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "findUrlsForContainingClassOf", "ktElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classFqName", "containingKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "pkgFqName", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findUrlsForLightProperty", "lightProperty", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "findUrlsForLightElement", "lightElement", "classUrls", "getLightElementSignatures", "getContainingLightClassForKtDeclaration", "declaration", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinExternalDocs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExternalDocs.kt\norg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,386:1\n1563#2:387\n1634#2,3:388\n1617#2,9:391\n1869#2:400\n1870#2:403\n1626#2:404\n1374#2:405\n1460#2,2:406\n1563#2:408\n1634#2,3:409\n1462#2,3:412\n1#3:401\n1#3:402\n171#4:415\n19#5:416\n*S KotlinDebug\n*F\n+ 1 KotlinExternalDocs.kt\norg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider\n*L\n75#1:387\n75#1:388,3\n99#1:391,9\n99#1:400\n99#1:403\n99#1:404\n151#1:405\n151#1:406,2\n151#1:408\n151#1:409,3\n151#1:412,3\n99#1:402\n174#1:415\n174#1:416\n*E\n"})
public final class KotlinExternalDocUrlsProvider {
    @NotNull
    public static final KotlinExternalDocUrlsProvider INSTANCE = new KotlinExternalDocUrlsProvider();

    private KotlinExternalDocUrlsProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> getExternalJavaDocUrl(@Nullable PsiElement element) {
        List list2;
        List<String> urls;
        PsiElement psiElement = element;
        List<String> list3 = urls = psiElement instanceof KtEnumEntry ? this.findUrlsForEnumEntry((KtEnumEntry)element) : (psiElement instanceof KtClass ? this.findUrlsForClass((KtClass)element) : (psiElement instanceof KtFunction ? this.findUrlsForLightElement((KtDeclaration)element, (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)element)) : (psiElement instanceof KtProperty ? this.findUrlsForLightProperty((KtDeclaration)element, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element)) : (psiElement instanceof KtParameter ? this.findUrlsForLightProperty((KtDeclaration)element, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)element)) : (psiElement instanceof KtLightClass ? this.findUrlsForClass((PsiClass)element) : (psiElement instanceof KtLightMember ? this.findUrlsForLightElement(this.findUrlsForClass((PsiClass)((KtLightMember)element).getContainingClass()), element) : null))))));
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtil.toSystemIndependentName((String)it));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final List<String> findUrlsForClass(KtClass aClass) {
        Object object = aClass;
        if (object == null || (object = object.getFqName()) == null || (object = object.asString()) == null) {
            return CollectionsKt.emptyList();
        }
        Object classFqName = object;
        KtFile ktFile2 = aClass.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        return this.findUrlsForClass((String)classFqName, ktFile2);
    }

    private final List<String> findUrlsForClass(PsiClass aClass) {
        Object object = aClass;
        if (object == null || (object = object.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        Object classFqName = object;
        String string = PsiUtil.getPackageName((PsiClass)aClass);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String pkgFqName = string;
        PsiFile psiFile = aClass.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile virtualFile = psiFile;
        Project project = aClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.findUrlsForClass(pkgFqName, (String)classFqName, project, (VirtualFile)virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findUrlsForEnumEntry(KtEnumEntry enumEntry) {
        void $this$mapNotNullTo$iv$iv;
        String string;
        PsiClass psiClass;
        Object object;
        UElement uElement;
        PsiElement psiElement;
        if (enumEntry == null || (psiElement = enumEntry.getParent()) == null || (uElement = UastContextKt.toUElement((PsiElement)psiElement)) == null || (object = (UClass)UastUtils.getParentOfType$default((UElement)uElement, UClass.class, (boolean)false, (int)2, null)) == null || (psiClass = object.getJavaPsi()) == null || (string = psiClass.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        String classFqName = string;
        KtFile ktFile2 = enumEntry.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        Iterable $this$mapNotNull$iv = this.findUrlsForClass(classFqName, ktFile2);
        boolean $i$f$mapNotNull = false;
        object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String classUrl = (String)element$iv$iv;
            boolean bl2 = false;
            if (enumEntry.getName() != null) {
                String it;
                boolean bl3 = false;
                string2 = classUrl + "#" + it;
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            String it$iv$iv = string2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> findUrlsForContainingClassOf(KtDeclaration ktElement) {
        PsiClass psiClass = this.getContainingLightClassForKtDeclaration(ktElement);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass containingClass = psiClass;
        String string = containingClass.getQualifiedName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String classFqName = string;
        KtFile ktFile2 = ktElement.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        return this.findUrlsForClass(classFqName, ktFile2);
    }

    private final List<String> findUrlsForClass(String classFqName, KtFile containingKtFile) {
        VirtualFile virtualFile = containingKtFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        String pkgName = containingKtFile.getPackageFqName().asString();
        Project project = containingKtFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.findUrlsForClass(pkgName, classFqName, project, virtualFile2);
    }

    private final List<String> findUrlsForClass(String pkgFqName, String classFqName, Project project, VirtualFile virtualFile) {
        List urls;
        List list2;
        String relPath;
        if (((CharSequence)pkgFqName).length() == 0) {
            v0 = "[root]/" + classFqName;
        } else {
            String string = StringsKt.replace$default((String)pkgFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
            String string2 = classFqName.substring(pkgFqName.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            v0 = relPath = string + "/" + string2;
        }
        if ((list2 = (urls = JavaDocumentationProvider.findUrlForVirtualFile((Project)project, (VirtualFile)virtualFile, (String)(relPath + ".html")))) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final List<String> findUrlsForLightProperty(KtDeclaration ktElement, LightClassUtil.PropertyAccessorsPsiMethods lightProperty) {
        List<String> classUrls = this.findUrlsForContainingClassOf(ktElement);
        Object[] objectArray = new List[]{this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getBackingField()), this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getSetter()), this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getGetter())};
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    private final List<String> findUrlsForLightElement(KtDeclaration ktElement, PsiElement lightElement) {
        return this.findUrlsForLightElement(this.findUrlsForContainingClassOf(ktElement), lightElement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findUrlsForLightElement(List<String> classUrls, PsiElement lightElement) {
        void $this$flatMapTo$iv$iv;
        if (lightElement == null) {
            return CollectionsKt.emptyList();
        }
        List<String> elementSignatures = this.getLightElementSignatures(lightElement);
        Iterable $this$flatMap$iv = classUrls;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String classUrl = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = elementSignatures;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void signature;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(classUrl + "#" + (String)signature);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getLightElementSignatures(PsiElement element) {
        List list2;
        PsiElement psiElement = element;
        if (psiElement instanceof PsiField) {
            list2 = CollectionsKt.listOf((Object)((PsiField)element).getName());
        } else if (psiElement instanceof PsiMethod) {
            Object[] objectArray = new String[]{((PsiMethod)element).getName() + "(", ((PsiMethod)element).getName() + "-"};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final PsiClass getContainingLightClassForKtDeclaration(KtDeclaration declaration) {
        PsiClass psiClass;
        if (declaration instanceof KtFunction && ((KtFunction)declaration).isLocal()) {
            psiClass = null;
        } else {
            PsiElement $this$toUElementOfType$iv = (PsiElement)declaration;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod != null && (uMethod = uMethod.getUastParent()) != null && (uMethod = uMethod.getJavaPsi()) != null) {
                UMethod $this$asSafely$iv = uMethod;
                boolean $i$f$asSafely = false;
                UMethod uMethod2 = $this$asSafely$iv;
                if (!(uMethod2 instanceof PsiClass)) {
                    uMethod2 = null;
                }
                psiClass = (PsiClass)uMethod2;
            } else {
                psiClass = null;
            }
        }
        return psiClass;
    }
}

