/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ImplicitThisInspection;
import org.jetbrains.kotlin.idea.util.ImplicitReceiversUtilsKt;
import org.jetbrains.kotlin.idea.util.ReceiverExpressionFactory;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ImplicitThisInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CallFix", "CallableReferenceFix", "kotlin.idea"})
public final class ImplicitThisInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCallableReferenceExpression(KtCallableReferenceExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (expression.getReceiverExpression() != null) {
                    return;
                }
                KtExpression ktExpression = (KtExpression)expression;
                KtSimpleNameExpression ktSimpleNameExpression = expression.getCallableReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
                this.handle(ktExpression, (KtReferenceExpression)ktSimpleNameExpression, (Function1<? super String, ? extends LocalQuickFix>)((Function1)buildVisitor.visitCallableReferenceExpression.1.INSTANCE));
            }

            public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!(expression instanceof KtNameReferenceExpression)) {
                    return;
                }
                if (((KtNameReferenceExpression)expression).getParent() instanceof KtThisExpression) {
                    return;
                }
                if (((KtNameReferenceExpression)expression).getParent() instanceof KtCallableReferenceExpression) {
                    return;
                }
                if (this.isSelectorOfDotQualifiedExpression((KtExpression)expression)) {
                    return;
                }
                PsiElement parent = ((KtNameReferenceExpression)expression).getParent();
                if (parent instanceof KtCallExpression && this.isSelectorOfDotQualifiedExpression((KtExpression)parent)) {
                    return;
                }
                this.handle((KtExpression)expression, (KtReferenceExpression)expression, (Function1<? super String, ? extends LocalQuickFix>)((Function1)buildVisitor.visitSimpleNameExpression.1.INSTANCE));
            }

            private final void handle(KtExpression expression, KtReferenceExpression reference, Function1<? super String, ? extends LocalQuickFix> fixFactory) {
                BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)reference, null, 1, null);
                LexicalScope lexicalScope = ScopeUtils.getResolutionScope((PsiElement)reference, context2);
                if (lexicalScope == null) {
                    return;
                }
                LexicalScope scope = lexicalScope;
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)reference), (BindingContext)context2);
                if (resolvedCall == null) {
                    return;
                }
                ResolvedCall resolvedCall2 = resolvedCall;
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)resolvedCall2 : null;
                VariableDescriptor variableDescriptor = variableAsFunctionResolvedCall != null && (variableAsFunctionResolvedCall = variableAsFunctionResolvedCall.getVariableCall()) != null ? (VariableDescriptor)variableAsFunctionResolvedCall.getResultingDescriptor() : null;
                CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
                CallableDescriptor callableDescriptor2 = callableDescriptor;
                VariableDescriptor variableDescriptor2 = variableDescriptor;
                if ((variableDescriptor2 == null || (variableDescriptor2 = this.receiverDescriptor((CallableDescriptor)variableDescriptor2)) == null) && (variableDescriptor2 = this.receiverDescriptor(callableDescriptor2)) == null) {
                    return;
                }
                VariableDescriptor receiverDescriptor = variableDescriptor2;
                KotlinType kotlinType = receiverDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                KotlinType receiverType = kotlinType;
                ReceiverExpressionFactory receiverExpressionFactory = ImplicitReceiversUtilsKt.getFactoryForImplicitReceiverWithSubtypeOf(scope, receiverType);
                if (receiverExpressionFactory == null) {
                    return;
                }
                ReceiverExpressionFactory expressionFactory = receiverExpressionFactory;
                String receiverText = expressionFactory.isImmediate() ? "this" : expressionFactory.getExpressionText();
                LocalQuickFix fix3 = (LocalQuickFix)fixFactory.invoke((Object)receiverText);
                Object[] objectArray = new Object[]{receiverText};
                String string = KotlinBundle.message((String)"callable.reference.fix.family.name", (Object[])objectArray);
                objectArray = new LocalQuickFix[]{fix3};
                this.$holder.registerProblem((PsiElement)expression, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
            }

            private final ReceiverParameterDescriptor receiverDescriptor(CallableDescriptor $this$receiverDescriptor) {
                ReceiverParameterDescriptor receiverParameterDescriptor = $this$receiverDescriptor.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    receiverParameterDescriptor = $this$receiverDescriptor.getDispatchReceiverParameter();
                }
                return receiverParameterDescriptor;
            }

            private final boolean isSelectorOfDotQualifiedExpression(KtExpression $this$isSelectorOfDotQualifiedExpression) {
                PsiElement parent = $this$isSelectorOfDotQualifiedExpression.getParent();
                return parent instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent).getSelectorExpression(), (Object)$this$isSelectorOfDotQualifiedExpression);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ImplicitThisInspection$CallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "receiverText", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class CallFix
    implements LocalQuickFix {
        @NotNull
        private final String receiverText;

        public CallFix(@NotNull String receiverText) {
            Intrinsics.checkNotNullParameter((Object)receiverText, (String)"receiverText");
            this.receiverText = receiverText;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.receiverText};
            return KotlinBundle.message((String)"callable.reference.fix.family.name", (Object[])objectArray);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
            if (ktExpression == null) {
                return;
            }
            KtExpression expression = ktExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            PsiElement psiElement2 = expression.getParent();
            KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
            KtExpression call2 = ktCallExpression != null ? (KtExpression)ktCallExpression : expression;
            Object[] objectArray = new Object[]{this.receiverText, call2};
            call2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0.$1", (Object[])objectArray, (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ImplicitThisInspection$CallableReferenceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "receiverText", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class CallableReferenceFix
    implements LocalQuickFix {
        @NotNull
        private final String receiverText;

        public CallableReferenceFix(@NotNull String receiverText) {
            Intrinsics.checkNotNullParameter((Object)receiverText, (String)"receiverText");
            this.receiverText = receiverText;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.receiverText};
            return KotlinBundle.message((String)"callable.reference.fix.family.name", (Object[])objectArray);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
            if (ktCallableReferenceExpression == null) {
                return;
            }
            KtCallableReferenceExpression expression = ktCallableReferenceExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            KtSimpleNameExpression ktSimpleNameExpression = expression.getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
            KtSimpleNameExpression reference = ktSimpleNameExpression;
            Object[] objectArray = new Object[]{this.receiverText, reference};
            expression.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0::$1", (Object[])objectArray, (boolean)false, (int)4, null));
        }
    }
}

