/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "", "variable", "Lcom/sun/jdi/LocalVariable;", "location", "Lcom/sun/jdi/Location;", "<init>", "(Lcom/sun/jdi/LocalVariable;Lcom/sun/jdi/Location;)V", "getVariable", "()Lcom/sun/jdi/LocalVariable;", "getLocation", "()Lcom/sun/jdi/Location;", "compareTo", "", "other", "equals", "", "", "hashCode", "name", "", "getName", "()Ljava/lang/String;", "isInlineMarkerVariable", "()Z", "toString", "intellij.kotlin.jvm.debugger.core"})
public final class VariableWithLocation
implements Comparable<VariableWithLocation> {
    @NotNull
    private final LocalVariable variable;
    @NotNull
    private final Location location;

    public VariableWithLocation(@NotNull LocalVariable variable, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.variable = variable;
        this.location = location;
    }

    @NotNull
    public final LocalVariable getVariable() {
        return this.variable;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(@NotNull VariableWithLocation other) {
        int inlineMarkerComparison;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int locationComparison = ((Comparable)this.location).compareTo(other.location);
        if (locationComparison != 0) {
            return locationComparison;
        }
        if (this.isInlineMarkerVariable() && other.isInlineMarkerVariable() && (inlineMarkerComparison = Intrinsics.compare((int)(DebuggerUtil.isInlineLambdaMarkerVariableName(this.getName()) ? 1 : 0), (int)(DebuggerUtil.isInlineLambdaMarkerVariableName(other.getName()) ? 1 : 0))) != 0) {
            return inlineMarkerComparison;
        }
        return ((Comparable)((Object)this.getName())).compareTo(other.getName());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VariableWithLocation && ((Comparable)this).compareTo(other) == 0;
    }

    public int hashCode() {
        return 31 * ((Object)this.location).hashCode() + this.getName().hashCode();
    }

    @NotNull
    public final String getName() {
        String string = this.variable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return string;
    }

    private final boolean isInlineMarkerVariable() {
        return DebuggerUtil.isInlineFunctionMarkerVariableName(this.getName()) || DebuggerUtil.isInlineLambdaMarkerVariableName(this.getName());
    }

    @NotNull
    public String toString() {
        return this.getName() + " at " + this.location;
    }
}

