/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.EnumValuesSoftDeprecateKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.completion.implCommon.weighers.SoftDeprecationWeigher;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/completion/K1SoftDeprecationWeigher;", "Lcom/intellij/codeInsight/lookup/LookupElementWeigher;", "<init>", "()V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/Boolean;", "isEnumValuesSoftDeprecatedMethod", "declarationLookupObject", "Lorg/jetbrains/kotlin/idea/core/completion/DescriptorBasedDeclarationLookupObject;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlin.completion.impl.k1"})
public final class K1SoftDeprecationWeigher
extends LookupElementWeigher {
    @NotNull
    public static final K1SoftDeprecationWeigher INSTANCE = new K1SoftDeprecationWeigher();

    private K1SoftDeprecationWeigher() {
        super("kotlin.unwantedElement");
    }

    @NotNull
    public Boolean weigh(@NotNull LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element.getObject();
        DescriptorBasedDeclarationLookupObject descriptorBasedDeclarationLookupObject = object instanceof DescriptorBasedDeclarationLookupObject ? (DescriptorBasedDeclarationLookupObject)object : null;
        if (descriptorBasedDeclarationLookupObject == null) {
            return false;
        }
        DescriptorBasedDeclarationLookupObject declarationLookupObject = descriptorBasedDeclarationLookupObject;
        DeclarationDescriptor declarationDescriptor = declarationLookupObject.getDescriptor();
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        PsiElement psiElement = declarationLookupObject.getPsiElement();
        if (psiElement == null || (psiElement = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(psiElement)) == null) {
            return false;
        }
        PsiElement languageVersionSettings = psiElement;
        return SoftDeprecationWeigher.INSTANCE.isSoftDeprecatedFqName(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2), (LanguageVersionSettings)languageVersionSettings) || this.isEnumValuesSoftDeprecatedMethod(declarationLookupObject, descriptor2, (LanguageVersionSettings)languageVersionSettings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEnumValuesSoftDeprecatedMethod(DescriptorBasedDeclarationLookupObject declarationLookupObject, DeclarationDescriptor descriptor2, LanguageVersionSettings languageVersionSettings) {
        if (!EnumValuesSoftDeprecateKt.isEnumValuesSoftDeprecateEnabled(languageVersionSettings)) return false;
        if (!DescriptorUtils.isEnumClass((DeclarationDescriptor)descriptor2.getContainingDeclaration())) return false;
        if (!Intrinsics.areEqual((Object)StandardNames.ENUM_VALUES, (Object)declarationLookupObject.getName())) return false;
        CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor2 : null;
        if ((callableMemberDescriptor != null ? callableMemberDescriptor.getKind() : null) != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        return true;
    }
}

