/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J9\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "invalidChars", "", "", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkNameAndReport", "name", "Lorg/jetbrains/kotlin/name/Name;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkNameAndReport$checkers_native", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeIdentifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeIdentifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,61:1\n1107#2,2:62\n*S KotlinDebug\n*F\n+ 1 FirNativeIdentifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker\n*L\n50#1:62,2\n*E\n"})
public final class FirNativeIdentifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeIdentifierChecker INSTANCE = new FirNativeIdentifierChecker();
    @NotNull
    private static final Set<Character> invalidChars;

    private FirNativeIdentifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtSourceElement source = declaration.getSource();
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirRegularClass)declaration).getName(), source);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirSimpleFunction)declaration).getName(), source);
        } else if (firDeclaration instanceof FirTypeParameter) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirTypeParameter)declaration).getName(), source);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirProperty)declaration).getName(), source);
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirTypeAlias)declaration).getName(), source);
        } else if (firDeclaration instanceof FirValueParameter) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirValueParameter)declaration).getName(), source);
        } else if (firDeclaration instanceof FirEnumEntry) {
            this.checkNameAndReport$checkers_native(context2, reporter, ((FirEnumEntry)declaration).getName(), source);
        } else {
            return;
        }
    }

    public final void checkNameAndReport$checkers_native(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull Name name2, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (source != null && !(source.getKind() instanceof KtFakeSourceElementKind) && !name2.isSpecial()) {
            String message2;
            String string;
            String string2 = name2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String text = string2;
            if (((CharSequence)text).length() == 0) {
                string = "should not be empty";
            } else {
                boolean bl;
                block5: {
                    CharSequence $this$any$iv = text;
                    boolean $i$f$any = false;
                    for (int j = 0; j < $this$any$iv.length(); ++j) {
                        char element$iv;
                        char it = element$iv = $this$any$iv.charAt(j);
                        boolean bl2 = false;
                        if (!invalidChars.contains(Character.valueOf(it))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                string = message2 = bl ? "contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)invalidChars, (Iterable)StringsKt.toSet((CharSequence)text)), (CharSequence)"", (CharSequence)"\"", (CharSequence)"\"", (int)0, null, null, (int)56, null) : null;
            }
            if (message2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirNativeErrors.INSTANCE.getINVALID_CHARACTERS_NATIVE(), (Object)message2, null, (int)16, null);
            }
        }
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('|'), Character.valueOf('\u00a7'), Character.valueOf('%'), Character.valueOf('@')};
        invalidChars = SetsKt.setOf((Object[])objectArray);
    }
}

