/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CanonicalPathHashStrategy;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.JpsModel;

public final class BuildFSState {
    public static final int VERSION = 3;
    private static final Logger LOG = Logger.getInstance(BuildFSState.class);
    private static final Key<Set<? extends BuildTarget<?>>> CONTEXT_TARGETS_KEY = Key.create((String)"_fssfate_context_targets_");
    @ApiStatus.Internal
    public static final Key<FilesDelta> NEXT_ROUND_DELTA_KEY = Key.create((String)"_next_round_delta_");
    @ApiStatus.Internal
    public static final Key<FilesDelta> CURRENT_ROUND_DELTA_KEY = Key.create((String)"_current_round_delta_");
    private final boolean myAlwaysScanFS;
    private final Set<BuildTarget<?>> myInitialScanPerformed = Collections.synchronizedSet(new HashSet());
    private final Object2LongOpenCustomHashMap<Path> myRegistrationStamps = new Object2LongOpenCustomHashMap((Hash.Strategy)CanonicalPathHashStrategy.INSTANCE);
    private final Map<BuildTarget<?>, FilesDelta> myDeltas = Collections.synchronizedMap(new HashMap());

    public BuildFSState(boolean alwaysScanFS) {
        this.myAlwaysScanFS = alwaysScanFS;
    }

    public void save(DataOutput out) throws IOException {
        MultiMap targetsByType = new MultiMap();
        for (BuildTarget<?> target : this.myInitialScanPerformed) {
            targetsByType.putValue(target.getTargetType(), target);
        }
        out.writeInt(targetsByType.size());
        for (BuildTargetType type : targetsByType.keySet()) {
            IOUtil.writeString((String)type.getTypeId(), (DataOutput)out);
            Collection targets = targetsByType.get((Object)type);
            out.writeInt(targets.size());
            for (BuildTarget target : targets) {
                IOUtil.writeString((String)target.getId(), (DataOutput)out);
                this.getDelta(target).save(out);
            }
        }
    }

    public void load(DataInputStream in, JpsModel model, BuildRootIndex buildRootIndex) throws IOException {
        TargetTypeRegistry registry = TargetTypeRegistry.getInstance();
        int typeCount = in.readInt();
        while (typeCount-- > 0) {
            BuildTargetLoader<?> loader;
            String typeId = IOUtil.readString((DataInput)in);
            int targetCount = in.readInt();
            BuildTargetType<?> type = registry.getTargetType(typeId);
            BuildTargetLoader<?> buildTargetLoader = loader = type != null ? type.createLoader(model) : null;
            while (targetCount-- > 0) {
                Object target;
                String id = IOUtil.readString((DataInput)in);
                boolean loaded = false;
                if (loader != null && (target = loader.createTarget(id)) != null) {
                    this.getDelta((BuildTarget<?>)target).load(in, (BuildTarget<?>)target, buildRootIndex);
                    this.myInitialScanPerformed.add((BuildTarget<?>)target);
                    loaded = true;
                }
                if (loaded) continue;
                LOG.info("Skipping unknown target (typeId=" + typeId + ", type=" + String.valueOf(type) + ", id=" + id + ")");
                FilesDelta.skip(in);
            }
        }
    }

    public void clearRecompile(@NotNull BuildRootDescriptor rootDescriptor) {
        if (rootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(0);
        }
        this.getDelta(rootDescriptor.getTarget()).clearRecompile(rootDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEventRegistrationStamp(@NotNull Path file) {
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(1);
        }
        Object2LongOpenCustomHashMap<Path> object2LongOpenCustomHashMap = this.myRegistrationStamps;
        synchronized (object2LongOpenCustomHashMap) {
            return this.myRegistrationStamps.getLong((Object)file);
        }
    }

    public boolean hasWorkToDo(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildFSState.$$$reportNull$$$0(2);
        }
        if (!this.myInitialScanPerformed.contains(target)) {
            return true;
        }
        FilesDelta delta = this.myDeltas.get(target);
        return delta != null && delta.hasChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnprocessedChanges(@NotNull CompileContext context, @NotNull BuildTarget<?> target) {
        if (context == null) {
            BuildFSState.$$$reportNull$$$0(3);
        }
        if (target == null) {
            BuildFSState.$$$reportNull$$$0(4);
        }
        if (!this.myInitialScanPerformed.contains(target)) {
            return false;
        }
        FilesDelta delta = this.myDeltas.get(target);
        if (delta == null) {
            return false;
        }
        long targetBuildStart = context.getCompilationStartStamp(target);
        if (targetBuildStart <= 0L) {
            return false;
        }
        CompileScope scope = context.getScope();
        BuildRootIndex rootIndex = context.getProjectDescriptor().getBuildRootIndex();
        try {
            delta.lockData();
            long now = System.currentTimeMillis();
            for (Set<Path> files : delta.getSourceSetsToRecompile()) {
                block5: for (Path file : files) {
                    long fileStamp;
                    if (this.getEventRegistrationStamp(file) <= targetBuildStart && ((fileStamp = FSOperations.lastModified(file)) <= targetBuildStart || fileStamp >= now) || !scope.isAffected(target, file)) continue;
                    for (BuildRootDescriptor rd : rootIndex.findAllParentDescriptors(file.toFile(), context)) {
                        if (!rd.isGenerated()) continue;
                        continue block5;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unprocessed changes detected for target " + String.valueOf(target) + "; file: " + String.valueOf(file) + "; targetBuildStart=" + targetBuildStart + "; eventRegistrationStamp=" + this.getEventRegistrationStamp(file) + "; lastModified=" + FSOperations.lastModified(file));
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            delta.unlockData();
        }
        return false;
    }

    public void markInitialScanPerformed(BuildTarget<?> target) {
        this.myInitialScanPerformed.add(target);
    }

    public void registerDeleted(@Nullable CompileContext context, BuildTarget<?> target, @NotNull Path file, @Nullable StampsStorage<?> stampStorage) throws IOException {
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(5);
        }
        this.registerDeleted(context, target, file);
        if (stampStorage != null) {
            stampStorage.removeStamp(file, target);
        }
    }

    public void registerDeleted(@Nullable CompileContext context, BuildTarget<?> target, @NotNull Path file) {
        FilesDelta nextDelta;
        FilesDelta currentDelta;
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(6);
        }
        if ((currentDelta = BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context)) != null) {
            currentDelta.addDeleted(file);
        }
        if ((nextDelta = BuildFSState.getRoundDelta(NEXT_ROUND_DELTA_KEY, context)) != null) {
            nextDelta.addDeleted(file);
        }
        this.getDelta(target).addDeleted(file);
    }

    public void clearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            delta.clearDeletedPaths();
        }
    }

    public Collection<String> getAndClearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        return delta == null ? List.of() : delta.getAndClearDeletedPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public FilesDelta getDelta(@NotNull BuildTarget<?> buildTarget) {
        if (buildTarget == null) {
            BuildFSState.$$$reportNull$$$0(7);
        }
        Map<BuildTarget<?>, FilesDelta> map = this.myDeltas;
        // MONITORENTER : map
        FilesDelta filesDelta = this.myDeltas.computeIfAbsent(buildTarget, __ -> new FilesDelta());
        // MONITOREXIT : map
        if (filesDelta != null) return filesDelta;
        BuildFSState.$$$reportNull$$$0(8);
        return filesDelta;
    }

    public boolean isInitialScanPerformed(BuildTarget<?> target) {
        return !this.myAlwaysScanFS && this.myInitialScanPerformed.contains(target);
    }

    @ApiStatus.Internal
    @NotNull
    public FilesDelta getEffectiveFilesDelta(@NotNull CompileContext context, BuildTarget<?> target) {
        FilesDelta lastRoundDelta;
        if (context == null) {
            BuildFSState.$$$reportNull$$$0(9);
        }
        if (target instanceof ModuleBuildTarget && (lastRoundDelta = BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context)) != null) {
            FilesDelta filesDelta = lastRoundDelta;
            if (filesDelta == null) {
                BuildFSState.$$$reportNull$$$0(10);
            }
            return filesDelta;
        }
        FilesDelta filesDelta = this.getDelta(target);
        if (filesDelta == null) {
            BuildFSState.$$$reportNull$$$0(11);
        }
        return filesDelta;
    }

    public boolean isMarkedForRecompilation(@Nullable CompileContext context, CompilationRound round, BuildRootDescriptor rd, Path file) {
        FilesDelta delta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context);
        if (delta == null) {
            delta = this.getDelta(rd.getTarget());
        }
        return delta.isMarkedRecompile(rd, file);
    }

    public boolean markDirty(@Nullable CompileContext context, @NotNull File file, @NotNull BuildRootDescriptor buildRootDescriptor, @Nullable StampsStorage<?> stampStorage, boolean saveEventStamp) throws IOException {
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(12);
        }
        if (buildRootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(13);
        }
        return this.markDirty(context, CompilationRound.NEXT, file.toPath(), buildRootDescriptor, stampStorage, saveEventStamp);
    }

    public boolean markDirty(@Nullable CompileContext context, @NotNull Path file, @NotNull BuildRootDescriptor buildRootDescriptor, @Nullable StampsStorage<?> stampStorage, boolean saveEventStamp) throws IOException {
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(14);
        }
        if (buildRootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(15);
        }
        return this.markDirty(context, CompilationRound.NEXT, file, buildRootDescriptor, stampStorage, saveEventStamp);
    }

    @Deprecated
    public boolean markDirty(@Nullable CompileContext context, @NotNull CompilationRound round, @NotNull File file, @NotNull BuildRootDescriptor buildRootDescriptor, @Nullable StampsStorage<?> stampStorage, boolean saveEventStamp) throws IOException {
        if (round == null) {
            BuildFSState.$$$reportNull$$$0(16);
        }
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(17);
        }
        if (buildRootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(18);
        }
        return this.markDirty(context, round, file.toPath(), buildRootDescriptor, stampStorage, saveEventStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markDirty(@Nullable CompileContext context, @NotNull CompilationRound round, @NotNull Path file, @NotNull BuildRootDescriptor buildRootDescriptor, @Nullable StampsStorage<?> stampStorage, boolean saveEventStamp) throws IOException {
        if (round == null) {
            BuildFSState.$$$reportNull$$$0(19);
        }
        if (file == null) {
            BuildFSState.$$$reportNull$$$0(20);
        }
        if (buildRootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(21);
        }
        FilesDelta roundDelta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context);
        BuildTarget<?> target = buildRootDescriptor.getTarget();
        if (roundDelta != null && BuildFSState.isInCurrentContextTargets(context, target)) {
            roundDelta.markRecompile(buildRootDescriptor, file);
        }
        FilesDelta filesDelta = this.getDelta(target);
        filesDelta.lockData();
        try {
            boolean marked = filesDelta.markRecompile(buildRootDescriptor, file);
            if (marked) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(target) + ": MARKED DIRTY: " + String.valueOf(file));
                }
                if (saveEventStamp) {
                    long eventStamp = System.currentTimeMillis();
                    Object2LongOpenCustomHashMap<Path> object2LongOpenCustomHashMap = this.myRegistrationStamps;
                    synchronized (object2LongOpenCustomHashMap) {
                        this.myRegistrationStamps.put((Object)file, eventStamp);
                    }
                }
                if (stampStorage != null) {
                    stampStorage.removeStamp(file, target);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(target) + ": NOT MARKED DIRTY: " + String.valueOf(file));
            }
            boolean bl = marked;
            return bl;
        }
        finally {
            filesDelta.unlockData();
        }
    }

    private static boolean isInCurrentContextTargets(CompileContext context, BuildTarget<?> target) {
        return context != null && ((Set)CONTEXT_TARGETS_KEY.get((UserDataHolder)context, Set.of())).contains(target);
    }

    public boolean markDirtyIfNotDeleted(@Nullable CompileContext context, CompilationRound round, Path file, @NotNull BuildRootDescriptor buildRootDescriptor, @Nullable StampsStorage<?> stampStorage) throws IOException {
        FilesDelta roundDelta;
        boolean marked;
        if (buildRootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(22);
        }
        if ((marked = this.getDelta(buildRootDescriptor.getTarget()).markRecompileIfNotDeleted(buildRootDescriptor, file)) && stampStorage != null) {
            stampStorage.removeStamp(file, buildRootDescriptor.getTarget());
        }
        if (marked && (roundDelta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context)) != null && BuildFSState.isInCurrentContextTargets(context, buildRootDescriptor.getTarget())) {
            roundDelta.markRecompile(buildRootDescriptor, file);
        }
        return marked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.clearContextRoundData(null);
        this.clearContextChunk(null);
        this.myInitialScanPerformed.clear();
        this.myDeltas.clear();
        Object2LongOpenCustomHashMap<Path> object2LongOpenCustomHashMap = this.myRegistrationStamps;
        synchronized (object2LongOpenCustomHashMap) {
            this.myRegistrationStamps.clear();
        }
    }

    public void clearContextRoundData(@Nullable CompileContext context) {
        BuildFSState.setRoundDelta(NEXT_ROUND_DELTA_KEY, context, null);
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, null);
    }

    public void clearContextChunk(@Nullable CompileContext context) {
        if (context != null) {
            CONTEXT_TARGETS_KEY.set((UserDataHolder)context, null);
        }
    }

    @ApiStatus.Internal
    public void beforeChunkBuildStart(@NotNull CompileContext context, @NotNull Set<? extends BuildTarget<?>> targets) {
        if (context == null) {
            BuildFSState.$$$reportNull$$$0(23);
        }
        if (targets == null) {
            BuildFSState.$$$reportNull$$$0(24);
        }
        CONTEXT_TARGETS_KEY.set((UserDataHolder)context, targets);
    }

    public void beforeNextRoundStart(@NotNull CompileContext context, ModuleChunk chunk) {
        FilesDelta currentDelta;
        if (context == null) {
            BuildFSState.$$$reportNull$$$0(25);
        }
        if ((currentDelta = BuildFSState.getRoundDelta(NEXT_ROUND_DELTA_KEY, context)) == null) {
            SmartList deltas = new SmartList();
            for (ModuleBuildTarget target : chunk.getTargets()) {
                deltas.add(this.getDelta(target));
            }
            currentDelta = new FilesDelta((Collection<FilesDelta>)deltas);
        }
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, currentDelta);
        BuildFSState.setRoundDelta(NEXT_ROUND_DELTA_KEY, context, new FilesDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BuildRootDescriptor, T extends BuildTarget<R>> boolean processFilesToRecompile(CompileContext context, @NotNull T target, FileProcessor<R, T> processor) throws IOException {
        if (target == null) {
            BuildFSState.$$$reportNull$$$0(26);
        }
        CompileScope scope = context.getScope();
        FilesDelta delta = this.getEffectiveFilesDelta(context, target);
        delta.lockData();
        try {
            for (Map.Entry<BuildRootDescriptor, Set<Path>> entry : delta.getSourceMapToRecompile().entrySet()) {
                BuildRootDescriptor root = entry.getKey();
                if (!target.equals(root.getTarget())) continue;
                for (Path file : entry.getValue()) {
                    if (!scope.isAffected(target, file)) continue;
                    if (processor.apply(target, file.toFile(), root)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            delta.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markAllUpToDate(@NotNull CompileContext context, @NotNull BuildRootDescriptor buildRootDescriptor, @Nullable StampsStorage<?> stampStorage, long targetBuildStartStamp) throws IOException {
        if (context == null) {
            BuildFSState.$$$reportNull$$$0(27);
        }
        if (buildRootDescriptor == null) {
            BuildFSState.$$$reportNull$$$0(28);
        }
        boolean marked = false;
        BuildTarget<?> target = buildRootDescriptor.getTarget();
        FilesDelta delta = this.getDelta(target);
        delta.lockData();
        try {
            Set<Path> files = delta.clearRecompile(buildRootDescriptor);
            if (files == null) {
                boolean bl = marked;
                return bl;
            }
            CompileScope scope = context.getScope();
            for (Path file : files) {
                if (scope.isAffected(target, file)) {
                    long currentFileTimestamp = FSOperations.lastModified(file);
                    if (!(buildRootDescriptor.isGenerated() || currentFileTimestamp <= targetBuildStartStamp && this.getEventRegistrationStamp(file) <= targetBuildStartStamp)) {
                        if (Utils.IS_TEST_MODE) {
                            LOG.info("Timestamp after compilation started; marking dirty again: " + String.valueOf(file));
                        }
                        delta.markRecompile(buildRootDescriptor, file);
                        continue;
                    }
                    marked = true;
                    if (stampStorage == null) continue;
                    stampStorage.updateStamp(file, target, currentFileTimestamp);
                    continue;
                }
                if (Utils.IS_TEST_MODE) {
                    LOG.info("Not affected by compile scope; marking dirty again: " + String.valueOf(file));
                }
                delta.markRecompile(buildRootDescriptor, file);
            }
            boolean bl = marked;
            return bl;
        }
        finally {
            delta.unlockData();
        }
    }

    @Nullable
    private static FilesDelta getRoundDelta(@NotNull Key<FilesDelta> key, @Nullable CompileContext context) {
        if (key == null) {
            BuildFSState.$$$reportNull$$$0(29);
        }
        return context == null ? null : (FilesDelta)key.get((UserDataHolder)context);
    }

    private static void setRoundDelta(@NotNull Key<FilesDelta> key, @Nullable CompileContext context, @Nullable FilesDelta delta) {
        if (key == null) {
            BuildFSState.$$$reportNull$$$0(30);
        }
        if (context != null) {
            key.set((UserDataHolder)context, (Object)delta);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 9: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTarget";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/fs/BuildFSState";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRootDescriptor";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "round";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/fs/BuildFSState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelta";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFilesDelta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "clearRecompile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEventRegistrationStamp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasWorkToDo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasUnprocessedChanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerDeleted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDelta";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveFilesDelta";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "markDirty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyIfNotDeleted";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "beforeChunkBuildStart";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "beforeNextRoundStart";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processFilesToRecompile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "markAllUpToDate";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRoundDelta";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setRoundDelta";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

