/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.sonatype.nexus.index.updater.AbstractResourceFetcher;

public class Maven3ServerIndexFetcher
extends AbstractResourceFetcher {
    private final String myOriginalRepositoryId;
    private final String myOriginalRepositoryUrl;
    private final WagonManager myWagonManager;
    private final RepositorySystem myRepositorySystem;
    private final TransferListener myListener;
    private Wagon myWagon = null;

    public Maven3ServerIndexFetcher(String originalRepositoryId, String originalRepositoryUrl, WagonManager wagonManager, RepositorySystem repositorySystem, TransferListener listener) {
        this.myOriginalRepositoryId = originalRepositoryId;
        this.myOriginalRepositoryUrl = originalRepositoryUrl;
        this.myWagonManager = wagonManager;
        this.myRepositorySystem = repositorySystem;
        this.myListener = listener;
    }

    public void connect(String _ignoredContextId, String _ignoredUrl) throws IOException {
        ArtifactRepository artifactRepository = this.myRepositorySystem.createArtifactRepository(this.myOriginalRepositoryId, this.myOriginalRepositoryUrl, null, null, null);
        ArtifactRepository mirrorRepository = this.myWagonManager.getMirrorRepository(artifactRepository);
        String mirrorUrl = mirrorRepository.getUrl();
        String indexUrl = mirrorUrl + (mirrorUrl.endsWith("/") ? "" : "/") + ".index";
        Repository repository = new Repository(this.myOriginalRepositoryId, indexUrl);
        try {
            this.myWagon = this.myWagonManager.getWagon(repository);
            this.myWagon.addTransferListener(this.myListener);
            this.myWagon.connect(repository, this.myWagonManager.getAuthenticationInfo(mirrorRepository.getId()), this.myWagonManager.getProxy(mirrorRepository.getProtocol()));
        }
        catch (AuthenticationException e) {
            throw new IOException("Authentication exception connecting to " + repository, e);
        }
        catch (WagonException e) {
            throw new IOException("Wagon exception connecting to " + repository, e);
        }
    }

    public void disconnect() throws RemoteException {
        if (this.myWagon == null) {
            return;
        }
        try {
            this.myWagon.disconnect();
        }
        catch (ConnectionException ex) {
            MavenServerGlobals.getLogger().warn((Throwable)ex);
        }
    }

    public void retrieve(String name, File targetFile) throws IOException {
        try {
            this.myWagon.get(name, targetFile);
        }
        catch (AuthorizationException e) {
            throw new IOException("Authorization exception retrieving " + name, e);
        }
        catch (ResourceDoesNotExistException e) {
            FileNotFoundException newEx = new FileNotFoundException("Resource " + name + " does not exist");
            newEx.initCause(e);
            throw newEx;
        }
        catch (WagonException e) {
            throw new IOException("Transfer for " + name + " failed", e);
        }
    }
}

