﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class StartExecutionPreviewResult {
 public:
  AWS_SSM_API StartExecutionPreviewResult() = default;
  AWS_SSM_API StartExecutionPreviewResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API StartExecutionPreviewResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the execution preview generated by the system.</p>
   */
  inline const Aws::String& GetExecutionPreviewId() const { return m_executionPreviewId; }
  template <typename ExecutionPreviewIdT = Aws::String>
  void SetExecutionPreviewId(ExecutionPreviewIdT&& value) {
    m_executionPreviewIdHasBeenSet = true;
    m_executionPreviewId = std::forward<ExecutionPreviewIdT>(value);
  }
  template <typename ExecutionPreviewIdT = Aws::String>
  StartExecutionPreviewResult& WithExecutionPreviewId(ExecutionPreviewIdT&& value) {
    SetExecutionPreviewId(std::forward<ExecutionPreviewIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartExecutionPreviewResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_executionPreviewId;
  bool m_executionPreviewIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
