# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_sqop_global_optspecs
	string join \n debug h/help
end

function __fish_sqop_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_sqop_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_sqop_using_subcommand
	set -l cmd (__fish_sqop_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c sqop -n "__fish_sqop_needs_command" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_needs_command" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "version" -d 'Prints version information'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "verify" -d 'Verifies Detached Signatures'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "inline-verify" -d 'Verifies Inline-Signed Messages'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "list-profiles" -d 'Emits a list of profiles supported by the identified subcommand'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "generate-key" -d 'Generates a Secret Key'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "change-key-password" -d 'Updates a key\'s password'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "revoke-key" -d 'Creates a Revocation Certificate'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "extract-cert" -d 'Extracts a Certificate from a Secret Key'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "update-key" -d 'Keep a Secret Key Up-To-Date'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "merge-certs" -d 'Merge OpenPGP Certificates'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "certify-userid" -d 'Certify OpenPGP Certificate User IDs'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "validate-userid" -d 'Validate a User ID in an OpenPGP Certificate'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "sign" -d 'Creates Detached Signatures'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "encrypt" -d 'Encrypts a Message'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "decrypt" -d 'Decrypts a Message'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "armor" -d 'Converts binary OpenPGP data to ASCII'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "dearmor" -d 'Converts ASCII OpenPGP data to binary'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "inline-detach" -d 'Splits Signatures from an Inline-Signed Message'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "inline-sign" -d 'Creates Inline-Signed Messages'
complete -c sqop -n "__fish_sqop_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sqop -n "__fish_sqop_using_subcommand version" -l backend -d 'Returns name and version of the primary underlying OpenPGP toolkit'
complete -c sqop -n "__fish_sqop_using_subcommand version" -l extended -d 'Returns multiple lines of name and version information'
complete -c sqop -n "__fish_sqop_using_subcommand version" -l sop-spec -d 'Returns the latest version of the SOP spec that is implemented'
complete -c sqop -n "__fish_sqop_using_subcommand version" -l sopv -d 'Returns "1.0\\n" if the sopv subset is implemented'
complete -c sqop -n "__fish_sqop_using_subcommand version" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand version" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sqop -n "__fish_sqop_using_subcommand verify" -l not-before -d 'Consider signatures before this date invalid' -r
complete -c sqop -n "__fish_sqop_using_subcommand verify" -l not-after -d 'Consider signatures after this date invalid' -r
complete -c sqop -n "__fish_sqop_using_subcommand verify" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand verify" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand inline-verify" -l not-before -d 'Consider signatures before this date invalid' -r
complete -c sqop -n "__fish_sqop_using_subcommand inline-verify" -l not-after -d 'Consider signatures after this date invalid' -r
complete -c sqop -n "__fish_sqop_using_subcommand inline-verify" -l verifications-out -d 'Write verification result here' -r
complete -c sqop -n "__fish_sqop_using_subcommand inline-verify" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand inline-verify" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand list-profiles" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand list-profiles" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand generate-key" -l profile -d 'Select the profile to use for key generation' -r
complete -c sqop -n "__fish_sqop_using_subcommand generate-key" -l with-key-password -d 'Protect the newly generated key with the given password' -r
complete -c sqop -n "__fish_sqop_using_subcommand generate-key" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand generate-key" -l signing-only -d 'Create a signing-only key'
complete -c sqop -n "__fish_sqop_using_subcommand generate-key" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand generate-key" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand change-key-password" -l new-key-password -d 'The new password to lock the key with, or just unlock the key if the option is absent' -r
complete -c sqop -n "__fish_sqop_using_subcommand change-key-password" -l old-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand change-key-password" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand change-key-password" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand change-key-password" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sqop -n "__fish_sqop_using_subcommand revoke-key" -l with-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand revoke-key" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand revoke-key" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand revoke-key" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sqop -n "__fish_sqop_using_subcommand extract-cert" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand extract-cert" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand extract-cert" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -l with-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -l merge-certs -d 'Merge updates into the key' -r
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -l signing-only -d 'Don\'t make the updated key encryption-capable if it isn\'t already'
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -l no-added-capabilities -d 'Don\'t advertise support for capabilities that aren\'t already advertised by the key'
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand update-key" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand merge-certs" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand merge-certs" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand merge-certs" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand certify-userid" -l userid -d 'Certify the specified user IDs' -r
complete -c sqop -n "__fish_sqop_using_subcommand certify-userid" -l with-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand certify-userid" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand certify-userid" -l no-require-self-sig -d 'Don\'t require self-signatures on the user IDs to be certified'
complete -c sqop -n "__fish_sqop_using_subcommand certify-userid" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand certify-userid" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand validate-userid" -l validate-at -d 'Evaluate the validity of the User ID at the specified time, not at the current time' -r
complete -c sqop -n "__fish_sqop_using_subcommand validate-userid" -l addr-spec-only -d 'Treat USERID as an e-mail address, and matched only against the e-mail address part of each correctly bound User ID'
complete -c sqop -n "__fish_sqop_using_subcommand validate-userid" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand validate-userid" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand sign" -l as -d 'Sign binary data or UTF-8 text' -r
complete -c sqop -n "__fish_sqop_using_subcommand sign" -l micalg-out -d 'Emit the digest algorithm used to the specified file' -r
complete -c sqop -n "__fish_sqop_using_subcommand sign" -l with-key-password -d 'Try to decrypt the signing KEYS with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand sign" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand sign" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand sign" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l profile -d 'Select the profile to use for encryption' -r
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l as -d 'Encrypt binary data or UTF-8 text' -r
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l with-password -d 'Encrypt with passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l sign-with -d 'Keys for signing' -r
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l with-key-password -d 'Try to decrypt the signing KEYS with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l session-key-out -d 'Write the session key here' -r
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand encrypt" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l session-key-out -d 'Write the session key here' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l with-session-key -d 'Try to decrypt with this session key' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l with-password -d 'Try to decrypt with this password' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l verifications-out -d 'Write verification result here' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l verify-with -d 'Certs for verification' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l verify-not-before -d 'Consider signatures before this date invalid' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l verify-not-after -d 'Consider signatures after this date invalid' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l with-key-password -d 'Try to decrypt the encryption KEYS with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand decrypt" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand armor" -l label -d 'Indicates the kind of data' -r
complete -c sqop -n "__fish_sqop_using_subcommand armor" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand armor" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand dearmor" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand dearmor" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand inline-detach" -l signatures-out -d 'Write Signatures here' -r
complete -c sqop -n "__fish_sqop_using_subcommand inline-detach" -l no-armor -d 'Don\'t ASCII-armor the signatures'
complete -c sqop -n "__fish_sqop_using_subcommand inline-detach" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand inline-detach" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand inline-sign" -l as -d 'Sign binary data, UTF-8 text, or using the Cleartext Signature Framework' -r
complete -c sqop -n "__fish_sqop_using_subcommand inline-sign" -l with-key-password -d 'Try to decrypt the signing KEYS with these passwords' -r
complete -c sqop -n "__fish_sqop_using_subcommand inline-sign" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqop -n "__fish_sqop_using_subcommand inline-sign" -l debug -d 'Emit verbose output for debugging'
complete -c sqop -n "__fish_sqop_using_subcommand inline-sign" -s h -l help -d 'Print help'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "version" -d 'Prints version information'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "verify" -d 'Verifies Detached Signatures'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "inline-verify" -d 'Verifies Inline-Signed Messages'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "list-profiles" -d 'Emits a list of profiles supported by the identified subcommand'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "generate-key" -d 'Generates a Secret Key'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "change-key-password" -d 'Updates a key\'s password'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "revoke-key" -d 'Creates a Revocation Certificate'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "extract-cert" -d 'Extracts a Certificate from a Secret Key'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "update-key" -d 'Keep a Secret Key Up-To-Date'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "merge-certs" -d 'Merge OpenPGP Certificates'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "certify-userid" -d 'Certify OpenPGP Certificate User IDs'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "validate-userid" -d 'Validate a User ID in an OpenPGP Certificate'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "sign" -d 'Creates Detached Signatures'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "encrypt" -d 'Encrypts a Message'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "decrypt" -d 'Decrypts a Message'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "armor" -d 'Converts binary OpenPGP data to ASCII'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "dearmor" -d 'Converts ASCII OpenPGP data to binary'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "inline-detach" -d 'Splits Signatures from an Inline-Signed Message'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "inline-sign" -d 'Creates Inline-Signed Messages'
complete -c sqop -n "__fish_sqop_using_subcommand help; and not __fish_seen_subcommand_from version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
