/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.lucene;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.AbstractMethodResolver;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.ResolvedMethodContext;
import org.opensearch.knn.index.engine.lucene.LuceneHNSWMethod;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;

public class LuceneMethodResolver
extends AbstractMethodResolver {
    private static final Set<CompressionLevel> SUPPORTED_COMPRESSION_LEVELS = Set.of(CompressionLevel.x1, CompressionLevel.x4);

    @Override
    public ResolvedMethodContext resolveMethod(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext, boolean shouldRequireTraining, SpaceType spaceType) {
        this.validateConfig(knnMethodConfigContext, shouldRequireTraining);
        KNNMethodContext resolvedKNNMethodContext = this.initResolvedKNNMethodContext(knnMethodContext, KNNEngine.LUCENE, spaceType, "hnsw");
        this.resolveEncoder(resolvedKNNMethodContext, knnMethodConfigContext);
        this.resolveMethodParams(resolvedKNNMethodContext.getMethodComponentContext(), knnMethodConfigContext, LuceneHNSWMethod.HNSW_METHOD_COMPONENT);
        CompressionLevel resolvedCompressionLevel = this.resolveCompressionLevelFromMethodContext(resolvedKNNMethodContext, knnMethodConfigContext, LuceneHNSWMethod.SUPPORTED_ENCODERS);
        this.validateCompressionConflicts(knnMethodConfigContext.getCompressionLevel(), resolvedCompressionLevel);
        return ResolvedMethodContext.builder().knnMethodContext(resolvedKNNMethodContext).compressionLevel(resolvedCompressionLevel).build();
    }

    protected void resolveEncoder(KNNMethodContext resolvedKNNMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        if (!this.shouldEncoderBeResolved(resolvedKNNMethodContext, knnMethodConfigContext)) {
            return;
        }
        CompressionLevel resolvedCompressionLevel = this.getDefaultCompressionLevel(knnMethodConfigContext);
        if (resolvedCompressionLevel == CompressionLevel.x1) {
            return;
        }
        MethodComponentContext methodComponentContext = resolvedKNNMethodContext.getMethodComponentContext();
        MethodComponentContext encoderComponentContext = new MethodComponentContext(LuceneHNSWMethod.SQ_ENCODER.getName(), new HashMap<String, Object>());
        Map<String, Object> resolvedParams = MethodComponent.getParameterMapWithDefaultsAdded(encoderComponentContext, LuceneHNSWMethod.SQ_ENCODER.getMethodComponent(), knnMethodConfigContext);
        encoderComponentContext.getParameters().putAll(resolvedParams);
        methodComponentContext.getParameters().put("encoder", encoderComponentContext);
    }

    private void validateConfig(KNNMethodConfigContext knnMethodConfigContext, boolean shouldRequireTraining) {
        ValidationException validationException = this.validateNotTrainingContext(shouldRequireTraining, KNNEngine.LUCENE, null);
        validationException = this.validateCompressionSupported(knnMethodConfigContext.getCompressionLevel(), SUPPORTED_COMPRESSION_LEVELS, KNNEngine.LUCENE, validationException);
        if ((validationException = this.validateCompressionNotx1WhenOnDisk(knnMethodConfigContext, validationException)) != null) {
            throw validationException;
        }
    }

    private CompressionLevel getDefaultCompressionLevel(KNNMethodConfigContext knnMethodConfigContext) {
        if (CompressionLevel.isConfigured(knnMethodConfigContext.getCompressionLevel())) {
            return knnMethodConfigContext.getCompressionLevel();
        }
        if (knnMethodConfigContext.getMode() == Mode.ON_DISK) {
            return CompressionLevel.x4;
        }
        return CompressionLevel.x1;
    }
}

