/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider;

public class DescribeVerifiedAccessTrustProvidersPublisher
implements SdkPublisher<DescribeVerifiedAccessTrustProvidersResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVerifiedAccessTrustProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVerifiedAccessTrustProvidersPublisher(Ec2AsyncClient client, DescribeVerifiedAccessTrustProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVerifiedAccessTrustProvidersPublisher(Ec2AsyncClient client, DescribeVerifiedAccessTrustProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVerifiedAccessTrustProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVerifiedAccessTrustProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VerifiedAccessTrustProvider> verifiedAccessTrustProviders() {
        Function<DescribeVerifiedAccessTrustProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessTrustProviders() != null) {
                return response.verifiedAccessTrustProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVerifiedAccessTrustProvidersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVerifiedAccessTrustProvidersResponseFetcher
    implements AsyncPageFetcher<DescribeVerifiedAccessTrustProvidersResponse> {
        private DescribeVerifiedAccessTrustProvidersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessTrustProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVerifiedAccessTrustProvidersResponse> nextPage(DescribeVerifiedAccessTrustProvidersResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessTrustProvidersPublisher.this.client.describeVerifiedAccessTrustProviders(DescribeVerifiedAccessTrustProvidersPublisher.this.firstRequest);
            }
            return DescribeVerifiedAccessTrustProvidersPublisher.this.client.describeVerifiedAccessTrustProviders((DescribeVerifiedAccessTrustProvidersRequest)((Object)DescribeVerifiedAccessTrustProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

