function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import chroma from 'chroma-js';
import { colorPalette } from './color_palette';
var flatten = function flatten(arr) {
  var _ref;
  return (_ref = []).concat.apply(_ref, _toConsumableArray(arr));
};
var ouiPalette = function ouiPalette(colors, steps) {
  var diverge = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var categorical = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  // This function also trims the first color so white/black is never a color
  if (!diverge && steps > 1) {
    var palette = colorPalette(colors, steps + 1);
    palette.shift();
    return palette;
  }
  return colorPalette(colors, steps, diverge, categorical);
};
export var ouiPaletteColorBlind = function ouiPaletteColorBlind() {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref2$rotations = _ref2.rotations,
    rotations = _ref2$rotations === void 0 ? 1 : _ref2$rotations,
    _ref2$order = _ref2.order,
    order = _ref2$order === void 0 ? 'append' : _ref2$order,
    _ref2$direction = _ref2.direction,
    direction = _ref2$direction === void 0 ? 'lighter' : _ref2$direction,
    _ref2$sortBy = _ref2.sortBy,
    sortBy = _ref2$sortBy === void 0 ? 'default' : _ref2$sortBy,
    _ref2$sortShift = _ref2.sortShift,
    sortShift = _ref2$sortShift === void 0 ? '-100' : _ref2$sortShift;
  var colors = [];
  var base = ['#54B399',
  // 0 green
  '#6092C0',
  // 1 blue
  '#D36086',
  // 2 dark pink
  '#9170B8',
  // 3 purple
  '#CA8EAE',
  // 4 light pink
  '#D6BF57',
  // 5 yellow
  '#B9A888',
  // 6 tan
  '#DA8B45',
  // 7 orange
  '#AA6556',
  // 8 brown
  '#E7664C' // 9 red
  ];
  if (sortBy === 'natural') {
    // Sort the colors based on the color wheel, but shifting the values based on sortShift
    base = _toConsumableArray(base).sort(function (a, b) {
      return chroma(a).set('hsl.h', sortShift).hsl()[0] - chroma(b).set('hsl.h', sortShift).hsl()[0];
    });
  }
  if (rotations > 1) {
    var palettes = base.map(function (color) {
      // Create the darkest and lightest versions of each color using black and white
      var palette = colorPalette(['black', color, 'white'], 5, false, true);
      // Then removing the extremes
      palette.pop();
      palette.shift();
      switch (direction) {
        case 'lighter':
          return colorPalette([palette[1], palette[2]], rotations, false, true);
        case 'darker':
          return colorPalette([palette[1], palette[0]], rotations, false, true);
        case 'both':
          return colorPalette(palette, rotations, false, true);
      }
    });
    if (order === 'group') {
      colors = flatten(palettes);
    } else {
      var _loop = function _loop(i) {
        var _colors;
        var rotation = palettes.map(function (palette) {
          return palette[i];
        });
        (_colors = colors).push.apply(_colors, _toConsumableArray(rotation));
      };
      for (var i = 0; i < rotations; i++) {
        _loop(i);
      }
    }

    // start with the appended order, then pick from both ends
    if (order === 'middle-out') {
      var shadePalettes = [];
      while (colors.length) {
        shadePalettes.push(colors.splice(0, base.length));
      }
      while (shadePalettes.length) {
        var firstPalette = shadePalettes.shift();
        if (firstPalette) {
          var _colors2;
          (_colors2 = colors).unshift.apply(_colors2, _toConsumableArray(firstPalette));
        }
        var lastPalette = shadePalettes.pop();
        if (lastPalette) {
          var _colors3;
          (_colors3 = colors).unshift.apply(_colors3, _toConsumableArray(lastPalette));
        }
      }
    }
  } else {
    colors = base;
  }
  return colors;
};

/**
 * Color blind palette with text is meant for use when text is applied on top of the color.
 * It increases the brightness of the color to give the text more contrast.
 */
export var ouiPaletteColorBlindBehindText = function ouiPaletteColorBlindBehindText() {
  var paletteProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var originalPalette = ouiPaletteColorBlind(paletteProps);
  var newPalette = originalPalette.map(function (color) {
    return chroma(color).brighten(0.5).hex();
  });
  return newPalette;
};
export var ouiPaletteForLightBackground = function ouiPaletteForLightBackground() {
  return ['#006BB4', '#017D73', '#F5A700', '#BD271E', '#DD0A73'];
};
export var ouiPaletteForDarkBackground = function ouiPaletteForDarkBackground() {
  return ['#1BA9F5', '#7DE2D1', '#F990C0', '#FF6666', '#FFCE7A'];
};
var positiveColor = '#209280';
var negativeColor = '#CC5642';
var lightNegativeColor = ouiPaletteColorBlind()[9];
var coolArray = [ouiPaletteColorBlind()[1], '#6092C0'];
var warmArray = [ouiPaletteColorBlind()[7], ouiPaletteColorBlind()[9]];
export var ouiPaletteForStatus = function ouiPaletteForStatus(steps) {
  if (steps === 1) {
    return [positiveColor];
  }
  if (steps <= 3) {
    return ouiPalette([positiveColor, ouiPaletteColorBlind()[5], negativeColor], steps, true);
  }
  return ouiPalette([positiveColor, ouiPaletteColorBlind()[0], ouiPaletteColorBlind()[5], lightNegativeColor, negativeColor], steps, true);
};
export var ouiPaletteForTemperature = function ouiPaletteForTemperature(steps) {
  var cools = colorPalette([].concat(_toConsumableArray(coolArray.slice().reverse()), ['#EBEFF5']), 3);
  var warms = colorPalette(['#F4F3DB'].concat(warmArray), 3);
  if (steps === 1) {
    return [cools[0]];
  } else if (steps <= 3) {
    return ouiPalette([cools[0], lightNegativeColor], steps, true);
  }
  return ouiPalette([].concat(_toConsumableArray(cools), _toConsumableArray(warms)), steps, true);
};
export var ouiPaletteComplimentary = function ouiPaletteComplimentary(steps) {
  if (steps === 1) {
    return [ouiPaletteColorBlind()[1]];
  }
  return ouiPalette([ouiPaletteColorBlind()[1], ouiPaletteColorBlind()[7]], steps, true);
};
export var ouiPaletteNegative = function ouiPaletteNegative(steps) {
  if (steps === 1) {
    return [lightNegativeColor];
  }
  return ouiPalette(['white', negativeColor], steps);
};
export var ouiPalettePositive = function ouiPalettePositive(steps) {
  if (steps === 1) {
    return [ouiPaletteColorBlind()[0]];
  }
  return ouiPalette(['white', positiveColor], steps);
};
export var ouiPaletteCool = function ouiPaletteCool(steps) {
  if (steps === 1) {
    return [coolArray[1]];
  }
  return ouiPalette(['white'].concat(coolArray), steps);
};
export var ouiPaletteWarm = function ouiPaletteWarm(steps) {
  if (steps === 1) {
    return [lightNegativeColor];
  }
  return ouiPalette(['#FBFBDC'].concat(warmArray), steps);
};
export var ouiPaletteGray = function ouiPaletteGray(steps) {
  if (steps === 1) {
    return ['#98a2b3'];
  }
  return ouiPalette(['white', '#d3dae6', '#98a2b3', '#69707d', '#343741'], steps, false);
};

/* OUI -> EUI Aliases */

export var euiPaletteColorBlind = ouiPaletteColorBlind;
export var euiPaletteColorBlindBehindText = ouiPaletteColorBlindBehindText;
export var euiPaletteForLightBackground = ouiPaletteForLightBackground;
export var euiPaletteForDarkBackground = ouiPaletteForDarkBackground;
export var euiPaletteForStatus = ouiPaletteForStatus;
export var euiPaletteForTemperature = ouiPaletteForTemperature;
export var euiPaletteComplimentary = ouiPaletteComplimentary;
export var euiPaletteNegative = ouiPaletteNegative;
export var euiPalettePositive = ouiPalettePositive;
export var euiPaletteCool = ouiPaletteCool;
export var euiPaletteWarm = ouiPaletteWarm;
export var euiPaletteGray = ouiPaletteGray;
/* End of Aliases */