/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.routing.allocation.DiskThresholdEvaluator;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.core.common.unit.ByteSizeValue;

public class HotNodeDiskThresholdEvaluator
implements DiskThresholdEvaluator {
    private final DiskThresholdSettings diskThresholdSettings;

    public HotNodeDiskThresholdEvaluator(DiskThresholdSettings diskThresholdSettings) {
        this.diskThresholdSettings = diskThresholdSettings;
    }

    @Override
    public boolean isNodeExceedingLowWatermark(DiskUsage diskUsage) {
        return diskUsage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes() || diskUsage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow();
    }

    @Override
    public boolean isNodeExceedingHighWatermark(DiskUsage diskUsage) {
        return diskUsage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || diskUsage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh();
    }

    @Override
    public boolean isNodeExceedingFloodStageWatermark(DiskUsage diskUsage) {
        return diskUsage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdFloodStage().getBytes() || diskUsage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdFloodStage();
    }

    @Override
    public long getFreeSpaceLowThreshold(long totalAddressableSpace) {
        return this.calculateFreeSpaceWatermarkThreshold(this.diskThresholdSettings.getFreeDiskThresholdLow(), this.diskThresholdSettings.getFreeBytesThresholdLow(), totalAddressableSpace);
    }

    @Override
    public long getFreeSpaceHighThreshold(long totalAddressableSpace) {
        return this.calculateFreeSpaceWatermarkThreshold(this.diskThresholdSettings.getFreeDiskThresholdHigh(), this.diskThresholdSettings.getFreeBytesThresholdHigh(), totalAddressableSpace);
    }

    @Override
    public long getFreeSpaceFloodStageThreshold(long totalAddressableSpace) {
        return this.calculateFreeSpaceWatermarkThreshold(this.diskThresholdSettings.getFreeDiskThresholdFloodStage(), this.diskThresholdSettings.getFreeBytesThresholdFloodStage(), totalAddressableSpace);
    }

    private long calculateFreeSpaceWatermarkThreshold(double freeDiskWatermarkThreshold, ByteSizeValue freeBytesWatermarkThreshold, long totalAddressableSpace) {
        ByteSizeValue bytesThreshold = freeBytesWatermarkThreshold;
        if (bytesThreshold != null && bytesThreshold.getBytes() > 0L) {
            return bytesThreshold.getBytes();
        }
        double percentageThreshold = freeDiskWatermarkThreshold;
        if (percentageThreshold > 0.0) {
            return (long)((double)totalAddressableSpace * percentageThreshold / 100.0);
        }
        return 0L;
    }
}

