/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.complete;

import java.util.Collections;
import java.util.List;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.FetchBuilderBasicValued;
import org.hibernate.query.results.internal.complete.CompleteFetchBuilder;
import org.hibernate.query.results.internal.complete.ModelPartReferenceBasic;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DelayedFetchBuilderBasicPart
implements CompleteFetchBuilder,
FetchBuilderBasicValued,
ModelPartReferenceBasic {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart referencedModelPart;
    private final boolean isEnhancedForLazyLoading;

    public DelayedFetchBuilderBasicPart(NavigablePath navigablePath, BasicValuedModelPart referencedModelPart, boolean isEnhancedForLazyLoading) {
        this.navigablePath = navigablePath;
        this.referencedModelPart = referencedModelPart;
        this.isEnhancedForLazyLoading = isEnhancedForLazyLoading;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public BasicValuedModelPart getReferencedPart() {
        return this.referencedModelPart;
    }

    @Override
    public BasicFetch<?> buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        return new BasicFetch(-1, parent, fetchPath, this.referencedModelPart, null, FetchTiming.DELAYED, this.isEnhancedForLazyLoading, domainResultCreationState, false, false);
    }

    @Override
    public List<String> getColumnAliases() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelayedFetchBuilderBasicPart that = (DelayedFetchBuilderBasicPart)o;
        return this.isEnhancedForLazyLoading == that.isEnhancedForLazyLoading && this.navigablePath.equals(that.navigablePath) && this.referencedModelPart.equals(that.referencedModelPart);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.referencedModelPart.hashCode();
        result = 31 * result + (this.isEnhancedForLazyLoading ? 1 : 0);
        return result;
    }
}

