/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.metrics.instrumentation;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetrics;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetricsBuilder;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.Startup;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;

@Startup
@ApplicationScoped
public class JvmMetricsService {
    private final RuntimeMetrics runtimeMetrics;

    public JvmMetricsService(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        if (runtimeConfig.sdkDisabled() || !runtimeConfig.instrument().jvmMetrics()) {
            this.runtimeMetrics = RuntimeMetrics.builder((OpenTelemetry)openTelemetry).disableAllMetrics().build();
            return;
        }
        RuntimeMetricsBuilder builder = RuntimeMetrics.builder((OpenTelemetry)openTelemetry).enableFeature(JfrFeature.CONTEXT_SWITCH_METRICS).enableFeature(JfrFeature.CPU_COUNT_METRICS).enableFeature(JfrFeature.LOCK_METRICS).enableFeature(JfrFeature.NETWORK_IO_METRICS).disableFeature(JfrFeature.MEMORY_POOL_METRICS);
        if (ImageMode.current().isNativeImage()) {
            builder.enableFeature(JfrFeature.THREAD_METRICS);
            builder.enableFeature(JfrFeature.CLASS_LOAD_METRICS);
            builder.enableFeature(JfrFeature.GC_DURATION_METRICS);
            builder.enableFeature(JfrFeature.CPU_UTILIZATION_METRICS);
            builder.enableFeature(JfrFeature.MEMORY_ALLOCATION_METRICS);
        } else {
            builder.disableFeature(JfrFeature.THREAD_METRICS);
            builder.disableFeature(JfrFeature.CLASS_LOAD_METRICS);
            builder.disableFeature(JfrFeature.GC_DURATION_METRICS);
            builder.disableFeature(JfrFeature.CPU_UTILIZATION_METRICS);
            builder.disableFeature(JfrFeature.MEMORY_ALLOCATION_METRICS);
        }
        this.runtimeMetrics = builder.build();
    }

    @PreDestroy
    public void close() {
        if (this.runtimeMetrics != null) {
            this.runtimeMetrics.close();
        }
    }
}

