/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.instruction;

import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StoreInstruction
extends Instruction {
    public int slot();

    public TypeKind typeKind();

    public static StoreInstruction of(TypeKind kind, int slot) {
        Opcode opcode = BytecodeHelpers.storeOpcode(kind, slot);
        return new AbstractInstruction.UnboundStoreInstruction(opcode, slot);
    }

    public static StoreInstruction of(Opcode op, int slot) {
        Util.checkKind(op, Opcode.Kind.STORE);
        BytecodeHelpers.validateSlot(op, slot, false);
        return new AbstractInstruction.UnboundStoreInstruction(op, slot);
    }
}

