/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class FirstSkipLimitHandler
extends AbstractLimitHandler {
    public static final FirstSkipLimitHandler INSTANCE = new FirstSkipLimitHandler();

    public String processSql(String sql, Limit limit) {
        return this.processSql(sql, -1, null, limit);
    }

    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, parameterMarkerStrategy, queryOptions.getLimit());
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, Limit limit) {
        boolean hasFirstRow = FirstSkipLimitHandler.hasFirstRow((Limit)limit);
        boolean hasMaxRows = FirstSkipLimitHandler.hasMaxRows((Limit)limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (ParameterMarkerStrategyStandard.isStandardRenderer((ParameterMarkerStrategy)parameterMarkerStrategy)) {
            if (hasMaxRows) {
                skipFirst.append(" first ?");
            }
            if (hasFirstRow) {
                skipFirst.append(" skip ?");
            }
        } else {
            String marker = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
            if (hasMaxRows) {
                skipFirst.append(" first ");
                skipFirst.append(marker);
                marker = parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
            }
            if (hasFirstRow) {
                skipFirst.append(" skip ");
                skipFirst.append(marker);
            }
        }
        return FirstSkipLimitHandler.insertAfterSelect((String)skipFirst.toString(), (String)sql);
    }

    public final boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffset() {
        return true;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public final boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean processSqlMutatesState() {
        return false;
    }

    public int getParameterPositionStart(Limit limit) {
        return FirstSkipLimitHandler.hasMaxRows((Limit)limit) ? (FirstSkipLimitHandler.hasFirstRow((Limit)limit) ? 3 : 2) : (FirstSkipLimitHandler.hasFirstRow((Limit)limit) ? 2 : 1);
    }
}

