/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;

public final class SessionWindows {
    private final long gapMs;
    private final long graceMs;

    private SessionWindows(long gapMs, long graceMs) {
        this.gapMs = gapMs;
        this.graceMs = graceMs;
        if (gapMs < 0L) {
            throw new IllegalArgumentException("Gap time cannot be negative.");
        }
        if (graceMs < 0L) {
            throw new IllegalArgumentException("Grace period cannot be negative.");
        }
    }

    public static SessionWindows ofInactivityGapWithNoGrace(Duration inactivityGap) {
        return SessionWindows.ofInactivityGapAndGrace(inactivityGap, Duration.ofMillis(0L));
    }

    public static SessionWindows ofInactivityGapAndGrace(Duration inactivityGap, Duration afterWindowEnd) {
        String inactivityGapMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(inactivityGap, "inactivityGap");
        long inactivityGapMs = ApiUtils.validateMillisecondDuration(inactivityGap, inactivityGapMsgPrefix);
        String afterWindowEndMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, afterWindowEndMsgPrefix);
        return new SessionWindows(inactivityGapMs, afterWindowEndMs);
    }

    public long gracePeriodMs() {
        return this.graceMs;
    }

    public long inactivityGap() {
        return this.gapMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWindows that = (SessionWindows)o;
        return this.gapMs == that.gapMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.gapMs, this.graceMs);
    }

    public String toString() {
        return "SessionWindows{gapMs=" + this.gapMs + ", graceMs=" + this.graceMs + "}";
    }
}

