/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains;

import io.opentelemetry.api.metrics.Meter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLCaffeineStatsCounter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsScopes;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsScopesKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLStatisticsDomain;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLSymbolProviderStatistics;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLStatisticsDomain;", "statisticsService", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService;)V", "meter", "Lio/opentelemetry/api/metrics/Meter;", "combinedSymbolProviderClassCacheStatsCounter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLCaffeineStatsCounter;", "getCombinedSymbolProviderClassCacheStatsCounter", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLCaffeineStatsCounter;", "combinedSymbolProviderCallableCacheStatsCounter", "getCombinedSymbolProviderCallableCacheStatsCounter", "low-level-api-fir"})
public final class LLSymbolProviderStatistics
implements LLStatisticsDomain {
    @NotNull
    private final Meter meter;
    @NotNull
    private final LLCaffeineStatsCounter combinedSymbolProviderClassCacheStatsCounter;
    @NotNull
    private final LLCaffeineStatsCounter combinedSymbolProviderCallableCacheStatsCounter;

    public LLSymbolProviderStatistics(@NotNull LLStatisticsService statisticsService) {
        Intrinsics.checkNotNullParameter((Object)statisticsService, (String)"statisticsService");
        this.meter = LLStatisticsScopesKt.getMeter(statisticsService.getOpenTelemetry$low_level_api_fir(), LLStatisticsScopes.SymbolProviders.INSTANCE);
        this.combinedSymbolProviderClassCacheStatsCounter = new LLCaffeineStatsCounter(this.meter, LLStatisticsScopes.SymbolProviders.Combined.Classes.INSTANCE);
        this.combinedSymbolProviderCallableCacheStatsCounter = new LLCaffeineStatsCounter(this.meter, LLStatisticsScopes.SymbolProviders.Combined.Callables.INSTANCE);
    }

    @NotNull
    public final LLCaffeineStatsCounter getCombinedSymbolProviderClassCacheStatsCounter() {
        return this.combinedSymbolProviderClassCacheStatsCounter;
    }

    @NotNull
    public final LLCaffeineStatsCounter getCombinedSymbolProviderCallableCacheStatsCounter() {
        return this.combinedSymbolProviderCallableCacheStatsCounter;
    }
}

