/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighSymbol;
import java.io.IOException;

public abstract class SymbolEntry {
    protected HighSymbol symbol;
    protected Address pcaddr;

    public SymbolEntry(HighSymbol sym) {
        this.symbol = sym;
    }

    public abstract void decode(Decoder var1) throws DecoderException;

    public abstract void encode(Encoder var1) throws IOException;

    public abstract VariableStorage getStorage();

    public abstract int getSize();

    public abstract int getMutability();

    public Address getPCAdress() {
        return this.pcaddr;
    }

    protected void decodeRangeList(Decoder decoder) throws DecoderException {
        int rangelistel = decoder.openElement(ElementId.ELEM_RANGELIST);
        if (decoder.peekElement() != 0) {
            int rangeel = decoder.openElement(ElementId.ELEM_RANGE);
            AddressSpace spc = decoder.readSpace(AttributeId.ATTRIB_SPACE);
            long offset = decoder.readUnsignedInteger(AttributeId.ATTRIB_FIRST);
            this.pcaddr = spc.getAddress(offset);
            decoder.closeElement(rangeel);
        }
        decoder.closeElement(rangelistel);
    }

    protected void encodeRangelist(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_RANGELIST);
        if (this.pcaddr == null || this.pcaddr.isExternalAddress()) {
            encoder.closeElement(ElementId.ELEM_RANGELIST);
            return;
        }
        AddressSpace space = this.pcaddr.getAddressSpace();
        long off = this.pcaddr.getUnsignedOffset();
        encoder.openElement(ElementId.ELEM_RANGE);
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, off);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, off);
        encoder.closeElement(ElementId.ELEM_RANGE);
        encoder.closeElement(ElementId.ELEM_RANGELIST);
    }
}

