/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.file.formats.bplist.NSObject;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Date;

public class NSDate
extends NSObject {
    public static final long EPOCH = 978307200000L;
    private double value;

    public NSDate(double value) {
        this.value = value;
    }

    @Override
    public String getType() {
        return "NSDate";
    }

    public Date getDate() {
        return new Date(978307200000L + (long)(1000.0 * this.value));
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("NSDate", 0);
        structure.add(BYTE, "objectDescriptor", null);
        structure.add((DataType)new DoubleDataType(), "date", null);
        return structure;
    }

    @Override
    public String toString() {
        return this.getDate().toString();
    }
}

