/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.program.model.pcode.Varnode;
import java.util.Objects;

public enum JitTypeBehavior {
    ANY{

        @Override
        public JitType type(int size) {
            return INTEGER.type(size);
        }

        @Override
        public JitType resolve(JitType varType) {
            return varType;
        }
    }
    ,
    INTEGER{

        @Override
        public JitType type(int size) {
            assert (size > 0);
            return switch (size) {
                case 1, 2, 3, 4 -> JitType.IntJitType.forSize(size);
                case 5, 6, 7, 8 -> JitType.LongJitType.forSize(size);
                default -> JitType.MpIntJitType.forSize(size);
            };
        }

        @Override
        public JitType resolve(JitType varType) {
            return this.type(varType.size());
        }
    }
    ,
    FLOAT{

        @Override
        public JitType type(int size) {
            return switch (size) {
                case 4 -> JitType.FloatJitType.F4;
                case 8 -> JitType.DoubleJitType.F8;
                default -> JitType.MpFloatJitType.forSize(size);
            };
        }

        @Override
        public JitType resolve(JitType varType) {
            return this.type(varType.size());
        }
    }
    ,
    COPY{

        @Override
        public JitType type(int size) {
            throw new AssertionError();
        }

        @Override
        public JitType resolve(JitType varType) {
            return ANY.resolve(varType);
        }
    };


    public static int compare(JitTypeBehavior b1, JitTypeBehavior b2) {
        return Objects.compare(b1, b2, Enum::compareTo);
    }

    public abstract JitType type(int var1);

    public abstract JitType resolve(JitType var1);

    public static JitTypeBehavior forJavaType(Class<?> cls) {
        if (cls == Byte.TYPE) {
            return INTEGER;
        }
        if (cls == Short.TYPE) {
            return INTEGER;
        }
        if (cls == Integer.TYPE) {
            return INTEGER;
        }
        if (cls == Long.TYPE) {
            return INTEGER;
        }
        if (cls == int[].class) {
            return INTEGER;
        }
        if (cls == Float.TYPE) {
            return FLOAT;
        }
        if (cls == Double.TYPE) {
            return FLOAT;
        }
        if (cls == Boolean.TYPE) {
            return INTEGER;
        }
        if (cls == Character.TYPE) {
            return null;
        }
        if (cls == Void.TYPE) {
            return null;
        }
        if (cls == Varnode.class) {
            return ANY;
        }
        if (cls.isPrimitive()) {
            throw new AssertionError();
        }
        return null;
    }
}

